/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import processing.app.Editor;
import processing.app.EditorConsole;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.Sketch;
import processing.app.Theme;
import processing.app.UpdateCheck;
import processing.app.debug.Compiler;
import processing.app.debug.Target;
import processing.core.PApplet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Base {
    public static final int REVISION = 21;
    static String VERSION_NAME = "0021";
    public static boolean RELEASE = false;
    static HashMap<Integer, String> platformNames = new HashMap();
    static HashMap<String, Integer> platformIndices;
    static Platform platform;
    private static boolean commandLine;
    Preferences preferencesFrame;
    boolean builtOnce;
    static File buildFolder;
    private static File examplesFolder;
    private static File librariesFolder;
    private static File toolsFolder;
    private static File hardwareFolder;
    static HashSet<File> libraries;
    static HashMap<String, File> importToLibraryTable;
    public static String librariesClassPath;
    public static HashMap<String, Target> targetsTable;
    static File untitledFolder;
    List<Editor> editors = Collections.synchronizedList(new ArrayList());
    Editor activeEditor;
    boolean breakTime = false;
    String[] months = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};

    public static void main(String[] stringArray) {
        block5: {
            String string;
            try {
                File file = Base.getContentFile("lib/version.txt");
                if (file.exists() && !(string = PApplet.loadStrings((File)file)[0]).equals(VERSION_NAME)) {
                    VERSION_NAME = string;
                    RELEASE = true;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            Base.initPlatform();
            JPopupMenu.setDefaultLightWeightPopupEnabled(false);
            Preferences.init(null);
            Theme.init();
            try {
                platform.setLookAndFeel();
            }
            catch (Exception exception) {
                string = exception.getMessage();
                if (string.indexOf("ch.randelshofer.quaqua.QuaquaLookAndFeel") != -1) break block5;
                System.err.println("Non-fatal error while setting the Look & Feel.");
                System.err.println("The error message follows, however Arduino should run fine.");
                System.err.println(string);
            }
        }
        untitledFolder = Base.createTempFolder("untitled");
        untitledFolder.deleteOnExit();
        new Base(stringArray);
    }

    protected static void setCommandLine() {
        commandLine = true;
    }

    protected static boolean isCommandLine() {
        return commandLine;
    }

    protected static void initPlatform() {
        try {
            Class<?> clazz = Class.forName("processing.app.Platform");
            if (Base.isMacOS()) {
                clazz = Class.forName("processing.app.macosx.Platform");
            } else if (Base.isWindows()) {
                clazz = Class.forName("processing.app.windows.Platform");
            } else if (Base.isLinux()) {
                clazz = Class.forName("processing.app.linux.Platform");
            }
            platform = (Platform)clazz.newInstance();
        }
        catch (Exception exception) {
            Base.showError("Problem Setting the Platform", "An unknown error occurred while trying to load\nplatform-specific code for your machine.", exception);
        }
    }

    protected static void initRequirements() {
        try {
            Class.forName("com.sun.jdi.VirtualMachine");
        }
        catch (ClassNotFoundException classNotFoundException) {
            Base.showPlatforms();
            Base.showError("Please install JDK 1.5 or later", "Arduino requires a full JDK (not just a JRE)\nto run. Please install JDK 1.5 or later.\nMore information can be found in the reference.", classNotFoundException);
        }
    }

    public Base(String[] stringArray) {
        File file;
        platform.init(this);
        examplesFolder = Base.getContentFile("examples");
        librariesFolder = Base.getContentFile("libraries");
        toolsFolder = Base.getContentFile("tools");
        String string = Preferences.get("sketchbook.path");
        if (string != null && !(file = new File(string)).exists()) {
            Base.showWarning("Sketchbook folder disappeared", "The sketchbook folder no longer exists.\nArduino will switch to the default sketchbook\nlocation, and create a new sketchbook folder if\nnecessary. Arduino will then stop talking about\nhimself in the third person.", null);
            string = null;
        }
        if (string == null) {
            file = this.getDefaultSketchbookFolder();
            Preferences.set("sketchbook.path", file.getAbsolutePath());
            if (!file.exists()) {
                file.mkdirs();
            }
        }
        targetsTable = new HashMap();
        this.loadHardware(Base.getHardwareFolder());
        this.loadHardware(Base.getSketchbookHardwareFolder());
        boolean bl = this.restoreSketches();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (Base.isWindows()) {
                try {
                    File file2 = new File(stringArray[i]);
                    string2 = file2.getCanonicalPath();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (this.handleOpen(string2) == null) continue;
            bl = true;
        }
        if (!bl) {
            this.handleNew();
        }
        if (Preferences.getBoolean("update.check")) {
            new UpdateCheck(this);
        }
    }

    protected boolean restoreSketches() {
        int n;
        int n2;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        boolean bl = true;
        if (Preferences.get("last.screen.height") != null) {
            n2 = Preferences.getInteger("last.screen.width");
            n = Preferences.getInteger("last.screen.height");
            if (dimension.width != n2 || dimension.height != n) {
                bl = false;
            }
        } else {
            bl = false;
        }
        n2 = Preferences.getInteger("last.sketch.count");
        n = 0;
        for (int i = 0; i < n2; ++i) {
            int[] nArray;
            String string = Preferences.get("last.sketch" + i + ".path");
            if (bl) {
                String string2 = Preferences.get("last.sketch" + i + ".location");
                nArray = PApplet.parseInt((String[])PApplet.split((String)string2, (char)','));
            } else {
                nArray = this.nextEditorLocation();
            }
            if (this.handleOpen(string, nArray) == null) continue;
            ++n;
        }
        return n > 0;
    }

    protected void storeSketches() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Preferences.setInteger("last.screen.width", dimension.width);
        Preferences.setInteger("last.screen.height", dimension.height);
        String string = untitledFolder.getAbsolutePath();
        int n = 0;
        for (Editor editor : this.editors) {
            String string2 = editor.getSketch().getMainFilePath();
            if (string2.startsWith(string) && !editor.getSketch().isModified()) continue;
            Preferences.set("last.sketch" + n + ".path", string2);
            int[] nArray = editor.getPlacement();
            String string3 = PApplet.join((String[])PApplet.str((int[])nArray), (String)",");
            Preferences.set("last.sketch" + n + ".location", string3);
            ++n;
        }
        Preferences.setInteger("last.sketch.count", n);
    }

    protected void storeSketchPath(Editor editor, int n) {
        String string;
        String string2 = editor.getSketch().getMainFilePath();
        if (string2.startsWith(string = untitledFolder.getAbsolutePath())) {
            string2 = "";
        }
        Preferences.set("last.sketch" + n + ".path", string2);
    }

    protected void handleActivated(Editor editor) {
        this.activeEditor = editor;
        EditorConsole.setEditor(this.activeEditor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] nextEditorLocation() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = Preferences.getInteger("editor.window.width.default");
        int n2 = Preferences.getInteger("editor.window.height.default");
        if (this.activeEditor == null) {
            return new int[]{(dimension.width - n) / 2, (dimension.height - n2) / 2, n, n2, 0};
        }
        List<Editor> list = this.editors;
        synchronized (list) {
            Editor editor = this.editors.get(this.editors.size() - 1);
            int[] nArray = editor.getPlacement();
            nArray[0] = nArray[0] + 50;
            nArray[1] = nArray[1] + 50;
            if (nArray[0] == 50 || nArray[2] == 50 || nArray[0] + nArray[2] > dimension.width || nArray[1] + nArray[3] > dimension.height) {
                return new int[]{(int)(Math.random() * (double)(dimension.width - n)), (int)(Math.random() * (double)(dimension.height - n2)), n, n2, 0};
            }
            return nArray;
        }
    }

    protected String createNewUntitled() throws IOException {
        File file = null;
        String string = null;
        File file2 = Base.getSketchbookFolder();
        File file3 = untitledFolder;
        int n = 0;
        Calendar calendar = Calendar.getInstance();
        int n2 = calendar.get(5);
        int n3 = calendar.get(2);
        String string2 = this.months[n3] + PApplet.nf((int)n2, (int)2);
        do {
            if (n == 26) {
                if (!this.breakTime) {
                    Base.showWarning("Time for a Break", "You've reached the limit for auto naming of new sketches\nfor the day. How about going for a walk instead?", null);
                    this.breakTime = true;
                } else {
                    Base.showWarning("Sunshine", "No really, time for some fresh air for you.", null);
                }
                return null;
            }
            string = "sketch_" + string2 + (char)(97 + n);
            file = new File(file3, string);
            ++n;
        } while (file.exists() || new File(file2, string).exists());
        file.mkdirs();
        File file4 = new File(file, string + ".pde");
        new FileOutputStream(file4);
        return file4.getAbsolutePath();
    }

    public void handleNew() {
        block3: {
            try {
                String string = this.createNewUntitled();
                if (string != null) {
                    Editor editor = this.handleOpen(string);
                    editor.untitled = true;
                }
            }
            catch (IOException iOException) {
                if (this.activeEditor == null) break block3;
                this.activeEditor.statusError(iOException);
            }
        }
    }

    public void handleNewReplace() {
        if (!this.activeEditor.checkModified()) {
            return;
        }
        this.activeEditor.internalCloseRunner();
        this.handleNewReplaceImpl();
    }

    protected void handleNewReplaceImpl() {
        try {
            String string = this.createNewUntitled();
            if (string != null) {
                this.activeEditor.handleOpenInternal(string);
                this.activeEditor.untitled = true;
            }
        }
        catch (IOException iOException) {
            this.activeEditor.statusError(iOException);
        }
    }

    public void handleOpenReplace(String string) {
        if (!this.activeEditor.checkModified()) {
            return;
        }
        this.activeEditor.internalCloseRunner();
        boolean bl = this.activeEditor.handleOpenInternal(string);
        if (!bl) {
            this.handleNewReplaceImpl();
        }
    }

    public void handleOpenPrompt() {
        FileDialog fileDialog = new FileDialog((Frame)this.activeEditor, "Open an Arduino sketch...", 0);
        fileDialog.setFilenameFilter(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.toLowerCase().endsWith(".pde");
            }
        });
        fileDialog.setVisible(true);
        String string = fileDialog.getDirectory();
        String string2 = fileDialog.getFile();
        if (string2 == null) {
            return;
        }
        File file = new File(string, string2);
        this.handleOpen(file.getAbsolutePath());
    }

    public Editor handleOpen(String string) {
        return this.handleOpen(string, this.nextEditorLocation());
    }

    protected Editor handleOpen(String string, int[] nArray) {
        File file = new File(string);
        if (!file.exists()) {
            return null;
        }
        for (Editor editor : this.editors) {
            if (!editor.getSketch().getMainFilePath().equals(string)) continue;
            editor.toFront();
            return editor;
        }
        Editor editor = new Editor(this, string, nArray);
        if (editor.getSketch() == null) {
            return null;
        }
        this.editors.add(editor);
        editor.setVisible(true);
        return editor;
    }

    public boolean handleClose(Editor editor) {
        if (!editor.checkModified()) {
            return false;
        }
        editor.internalCloseRunner();
        if (this.editors.size() == 1) {
            Object[] objectArray;
            String string;
            int n;
            if (Base.isMacOS() && ((n = JOptionPane.showOptionDialog(editor, string = "<html> <head> <style type=\"text/css\">b { font: 13pt \"Lucida Grande\" }p { font: 11pt \"Lucida Grande\"; margin-top: 8px }</style> </head><b>Are you sure you want to Quit?</b><p>Closing the last open sketch will quit Arduino.", "Quit", 0, 3, null, objectArray = new Object[]{"OK", "Cancel"}, objectArray[0])) == 1 || n == -1)) {
                return false;
            }
            this.editors.remove(editor);
            this.storeSketches();
            Preferences.save();
            System.exit(0);
        } else {
            editor.setVisible(false);
            editor.dispose();
            this.editors.remove(editor);
        }
        return true;
    }

    public boolean handleQuit() {
        this.storeSketches();
        if (this.handleQuitEach()) {
            for (Editor editor : this.editors) {
                editor.internalCloseRunner();
            }
            Preferences.save();
            if (!Base.isMacOS()) {
                System.exit(0);
            }
            return true;
        }
        return false;
    }

    protected boolean handleQuitEach() {
        int n = 0;
        for (Editor editor : this.editors) {
            if (editor.checkModified()) {
                this.storeSketchPath(editor, n);
                ++n;
                continue;
            }
            return false;
        }
        return true;
    }

    protected void rebuildSketchbookMenus() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Base.this.rebuildSketchbookMenu(Editor.sketchbookMenu);
                Base.this.rebuildToolbarMenu(Editor.toolbarMenu);
            }
        });
    }

    protected void rebuildToolbarMenu(JMenu jMenu) {
        boolean bl;
        jMenu.removeAll();
        JMenuItem jMenuItem = Editor.newJMenuItem("Open...", 79);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Base.this.handleOpenPrompt();
            }
        });
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        try {
            bl = this.addSketches(jMenu, Base.getSketchbookFolder(), true);
            if (bl) {
                jMenu.addSeparator();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            bl = this.addSketches(jMenu, examplesFolder, true);
            if (bl) {
                jMenu.addSeparator();
            }
            if (bl = this.addSketches(jMenu, Base.getSketchbookLibrariesFolder(), true)) {
                jMenu.addSeparator();
            }
            this.addSketches(jMenu, librariesFolder, true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected void rebuildSketchbookMenu(JMenu jMenu) {
        try {
            jMenu.removeAll();
            this.addSketches(jMenu, Base.getSketchbookFolder(), false);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void rebuildImportMenu(JMenu jMenu) {
        jMenu.removeAll();
        libraries = new HashSet();
        importToLibraryTable = new HashMap();
        try {
            this.addLibraries(jMenu, librariesFolder);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        int n = jMenu.getItemCount();
        try {
            File file = Base.getSketchbookLibrariesFolder();
            boolean bl = this.addLibraries(jMenu, file);
            if (bl) {
                JMenuItem jMenuItem = new JMenuItem("Contributed");
                jMenuItem.setEnabled(false);
                jMenu.insert(jMenuItem, n);
                jMenu.insertSeparator(n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void rebuildExamplesMenu(JMenu jMenu) {
        try {
            jMenu.removeAll();
            boolean bl = this.addSketches(jMenu, examplesFolder, false);
            if (bl) {
                jMenu.addSeparator();
            }
            if (bl = this.addSketches(jMenu, Base.getSketchbookLibrariesFolder(), false)) {
                jMenu.addSeparator();
            }
            this.addSketches(jMenu, librariesFolder, false);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void rebuildBoardsMenu(JMenu jMenu) {
        jMenu.removeAll();
        ButtonGroup buttonGroup = new ButtonGroup();
        for (Target target : targetsTable.values()) {
            for (String string : target.getBoards().keySet()) {
                AbstractAction abstractAction = new AbstractAction(target.getBoards().get(string).get("name")){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Preferences.set("target", (String)this.getValue("target"));
                        Preferences.set("board", (String)this.getValue("board"));
                    }
                };
                abstractAction.putValue("target", target.getName());
                abstractAction.putValue("board", string);
                JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(abstractAction);
                if (target.getName().equals(Preferences.get("target")) && string.equals(Preferences.get("board"))) {
                    jRadioButtonMenuItem.setSelected(true);
                }
                buttonGroup.add(jRadioButtonMenuItem);
                jMenu.add(jRadioButtonMenuItem);
            }
        }
    }

    public void rebuildBurnBootloaderMenu(JMenu jMenu) {
        jMenu.removeAll();
        for (Target target : targetsTable.values()) {
            for (String string : target.getProgrammers().keySet()) {
                AbstractAction abstractAction = new AbstractAction("w/ " + target.getProgrammers().get(string).get("name")){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Base.this.activeEditor.handleBurnBootloader((String)this.getValue("target"), (String)this.getValue("programmer"));
                    }
                };
                abstractAction.putValue("target", target.getName());
                abstractAction.putValue("programmer", string);
                JMenuItem jMenuItem = new JMenuItem(abstractAction);
                jMenu.add(jMenuItem);
            }
        }
    }

    protected boolean addSketches(JMenu jMenu, File file, final boolean bl) throws IOException {
        if (!file.isDirectory()) {
            return false;
        }
        String[] stringArray = file.list();
        if (stringArray == null) {
            return false;
        }
        Arrays.sort(stringArray, String.CASE_INSENSITIVE_ORDER);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (new File(string).exists()) {
                    boolean bl3 = bl;
                    if ((actionEvent.getModifiers() & 1) != 0) {
                        boolean bl2 = bl3 = !bl3;
                    }
                    if (bl3) {
                        Base.this.handleOpenReplace(string);
                    } else {
                        Base.this.handleOpen(string);
                    }
                } else {
                    Base.showWarning("Sketch Does Not Exist", "The selected sketch no longer exists.\nYou may need to restart Arduino to update\nthe sketchbook menu.", null);
                }
            }
        };
        boolean bl2 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            File file2;
            if (stringArray[i].charAt(0) == '.' || stringArray[i].equals("CVS") || !(file2 = new File(file, stringArray[i])).isDirectory()) continue;
            File file3 = new File(file2, stringArray[i] + ".pde");
            if (file3.exists()) {
                if (!Sketch.isSanitaryName(stringArray[i])) {
                    if (this.builtOnce) continue;
                    String string = "The sketch \"" + stringArray[i] + "\" cannot be used.\n" + "Sketch names must contain only basic letters and numbers\n" + "(ASCII-only with no spaces, " + "and it cannot start with a number).\n" + "To get rid of this message, remove the sketch from\n" + file3.getAbsolutePath();
                    Base.showMessage("Ignoring sketch with bad name", string);
                    continue;
                }
                JMenuItem jMenuItem = new JMenuItem(stringArray[i]);
                jMenuItem.addActionListener(actionListener);
                jMenuItem.setActionCommand(file3.getAbsolutePath());
                jMenu.add(jMenuItem);
                bl2 = true;
                continue;
            }
            if (file2.getName().equals("examples")) {
                boolean bl3 = this.addSketches(jMenu, file2, bl);
                if (!bl3) continue;
                bl2 = true;
                continue;
            }
            JMenu jMenu2 = new JMenu(stringArray[i]);
            boolean bl4 = this.addSketches(jMenu2, file2, bl);
            if (!bl4) continue;
            jMenu.add(jMenu2);
            bl2 = true;
        }
        return bl2;
    }

    protected boolean addLibraries(JMenu jMenu, File file) throws IOException {
        if (!file.isDirectory()) {
            return false;
        }
        String[] stringArray = file.list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                if (string.charAt(0) == '.') {
                    return false;
                }
                if (string.equals("CVS")) {
                    return false;
                }
                return new File(file, string).isDirectory();
            }
        });
        if (stringArray == null) {
            return false;
        }
        Arrays.sort(stringArray, String.CASE_INSENSITIVE_ORDER);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Base.this.activeEditor.getSketch().importLibrary(actionEvent.getActionCommand());
            }
        };
        boolean bl = false;
        for (String string : stringArray) {
            String string2;
            File file2 = new File(file, string);
            String string3 = Sketch.sanitizeName(string);
            if (!string3.equals(string)) {
                string2 = "The library \"" + string + "\" cannot be used.\n" + "Library names must contain only basic letters and numbers.\n" + "(ASCII only and no spaces, and it cannot start with a number)";
                Base.showMessage("Ignoring bad library name", string2);
                continue;
            }
            string2 = string;
            libraries.add(file2);
            String[] stringArray2 = Compiler.headerListFromIncludePath(file2.getAbsolutePath());
            for (String string4 : stringArray2) {
                importToLibraryTable.put(string4, file2);
            }
            JMenuItem jMenuItem = new JMenuItem(string2);
            jMenuItem.addActionListener(actionListener);
            jMenuItem.setActionCommand(file2.getAbsolutePath());
            jMenu.add(jMenuItem);
            bl = true;
        }
        return bl;
    }

    protected void loadHardware(File file) {
        if (!file.isDirectory()) {
            return;
        }
        String[] stringArray = file.list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                if (string.charAt(0) == '.') {
                    return false;
                }
                if (string.equals("CVS")) {
                    return false;
                }
                return new File(file, string).isDirectory();
            }
        });
        if (stringArray == null) {
            return;
        }
        Arrays.sort(stringArray, String.CASE_INSENSITIVE_ORDER);
        for (String string : stringArray) {
            File file2 = new File(file, string);
            targetsTable.put(string, new Target(string, file2));
        }
    }

    public void handleAbout() {
        final Image image = Base.getLibImage("about.jpg", this.activeEditor);
        final Window window = new Window(this.activeEditor){

            public void paint(Graphics graphics) {
                graphics.drawImage(image, 0, 0, null);
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                graphics.setFont(new Font("SansSerif", 0, 11));
                graphics.setColor(Color.white);
                graphics.drawString(VERSION_NAME, 50, 30);
            }
        };
        window.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                window.dispose();
            }
        });
        int n = image.getWidth(this.activeEditor);
        int n2 = image.getHeight(this.activeEditor);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        window.setBounds((dimension.width - n) / 2, (dimension.height - n2) / 2, n, n2);
        window.setVisible(true);
    }

    public void handlePrefs() {
        if (this.preferencesFrame == null) {
            this.preferencesFrame = new Preferences();
        }
        this.preferencesFrame.showFrame(this.activeEditor);
    }

    public static Platform getPlatform() {
        return platform;
    }

    public static String getPlatformName() {
        String string = System.getProperty("os.name");
        if (string.indexOf("Mac") != -1) {
            return "macosx";
        }
        if (string.indexOf("Windows") != -1) {
            return "windows";
        }
        if (string.equals("Linux")) {
            return "linux";
        }
        return "other";
    }

    public static String getPlatformName(int n) {
        return platformNames.get(n);
    }

    public static int getPlatformIndex(String string) {
        Integer n = platformIndices.get(string);
        return n == null ? -1 : n;
    }

    public static boolean isMacOS() {
        return System.getProperty("os.name").indexOf("Mac") != -1;
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").indexOf("Windows") != -1;
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").indexOf("Linux") != -1;
    }

    public static File getSettingsFolder() {
        File file = null;
        String string = Preferences.get("settings.path");
        if (string != null) {
            file = new File(string);
        } else {
            try {
                file = platform.getSettingsFolder();
            }
            catch (Exception exception) {
                Base.showError("Problem getting data folder", "Error getting the Arduino data folder.", exception);
            }
        }
        if (!file.exists() && !file.mkdirs()) {
            Base.showError("Settings issues", "Arduino cannot run because it could not\ncreate a folder to store your settings.", null);
        }
        return file;
    }

    public static File getSettingsFile(String string) {
        return new File(Base.getSettingsFolder(), string);
    }

    public static File getBuildFolder() {
        if (buildFolder == null) {
            String string = Preferences.get("build.path");
            if (string != null) {
                buildFolder = new File(string);
            } else {
                buildFolder = Base.createTempFolder("build");
                buildFolder.deleteOnExit();
            }
        }
        return buildFolder;
    }

    public static File createTempFolder(String string) {
        try {
            File file = File.createTempFile(string, null);
            file.delete();
            file.mkdirs();
            return file;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Set<File> getLibraries() {
        return libraries;
    }

    public static String getExamplesPath() {
        return examplesFolder.getAbsolutePath();
    }

    public static String getLibrariesPath() {
        return librariesFolder.getAbsolutePath();
    }

    public static File getToolsFolder() {
        return toolsFolder;
    }

    public static String getToolsPath() {
        return toolsFolder.getAbsolutePath();
    }

    public static File getHardwareFolder() {
        return Base.getContentFile("hardware");
    }

    public static String getHardwarePath() {
        return Base.getHardwareFolder().getAbsolutePath();
    }

    public static String getAvrBasePath() {
        if (Base.isLinux()) {
            return "";
        }
        return Base.getHardwarePath() + File.separator + "tools" + File.separator + "avr" + File.separator + "bin" + File.separator;
    }

    public static Target getTarget() {
        return targetsTable.get(Preferences.get("target"));
    }

    public static Map<String, String> getBoardPreferences() {
        Target target = Base.getTarget();
        if (target == null) {
            return new LinkedHashMap<String, String>();
        }
        Map<String, Object> map = target.getBoards();
        if (map == null) {
            return new LinkedHashMap<String, String>();
        }
        if ((map = map.get(Preferences.get("board"))) == null) {
            return new LinkedHashMap<String, String>();
        }
        return map;
    }

    public static File getSketchbookFolder() {
        return new File(Preferences.get("sketchbook.path"));
    }

    public static File getSketchbookLibrariesFolder() {
        return new File(Base.getSketchbookFolder(), "libraries");
    }

    public static String getSketchbookLibrariesPath() {
        return Base.getSketchbookLibrariesFolder().getAbsolutePath();
    }

    public static File getSketchbookHardwareFolder() {
        return new File(Base.getSketchbookFolder(), "hardware");
    }

    protected File getDefaultSketchbookFolder() {
        File file = null;
        try {
            file = platform.getDefaultSketchbookFolder();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (file == null) {
            file = Base.promptSketchbookLocation();
        }
        boolean bl = true;
        if (!file.exists()) {
            bl = file.mkdirs();
        }
        if (!bl) {
            Base.showError("You forgot your sketchbook", "Arduino cannot run because it could not\ncreate a folder to store your sketchbook.", null);
        }
        return file;
    }

    protected static File promptSketchbookLocation() {
        File file = null;
        file = new File(System.getProperty("user.home"), "sketchbook");
        if (!file.exists()) {
            file.mkdirs();
            return file;
        }
        String string = "Select (or create new) folder for sketches...";
        file = Base.selectFolder(string, null, null);
        if (file == null) {
            System.exit(0);
        }
        return file;
    }

    public static void openURL(String string) {
        try {
            platform.openURL(string);
        }
        catch (Exception exception) {
            Base.showWarning("Problem Opening URL", "Could not open the URL\n" + string, exception);
        }
    }

    protected static boolean openFolderAvailable() {
        return platform.openFolderAvailable();
    }

    public static void openFolder(File file) {
        try {
            platform.openFolder(file);
        }
        catch (Exception exception) {
            Base.showWarning("Problem Opening Folder", "Could not open the folder\n" + file.getAbsolutePath(), exception);
        }
    }

    public static File selectFolder(String string, File file, Frame frame) {
        if (Base.isMacOS()) {
            if (frame == null) {
                frame = new Frame();
            }
            FileDialog fileDialog = new FileDialog(frame, string, 0);
            if (file != null) {
                fileDialog.setDirectory(file.getParent());
            }
            System.setProperty("apple.awt.fileDialogForDirectories", "true");
            fileDialog.setVisible(true);
            System.setProperty("apple.awt.fileDialogForDirectories", "false");
            if (fileDialog.getFile() == null) {
                return null;
            }
            return new File(fileDialog.getDirectory(), fileDialog.getFile());
        }
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(string);
        if (file != null) {
            jFileChooser.setSelectedFile(file);
        }
        jFileChooser.setFileSelectionMode(1);
        int n = jFileChooser.showOpenDialog(new JDialog());
        if (n == 0) {
            return jFileChooser.getSelectedFile();
        }
        return null;
    }

    public static void setIcon(Frame frame) {
        Image image = Toolkit.getDefaultToolkit().createImage(PApplet.ICON_IMAGE);
        frame.setIconImage(image);
    }

    public static void registerWindowCloseKeys(JRootPane jRootPane, ActionListener actionListener) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        jRootPane.registerKeyboardAction(actionListener, keyStroke, 2);
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        keyStroke = KeyStroke.getKeyStroke(87, n);
        jRootPane.registerKeyboardAction(actionListener, keyStroke, 2);
    }

    public static void showReference(String string) {
        File file = Base.getContentFile("reference");
        File file2 = new File(file, string);
        Base.openURL(file2.getAbsolutePath());
    }

    public static void showGettingStarted() {
        if (Base.isMacOS()) {
            Base.showReference("Guide_MacOSX.html");
        } else if (Base.isWindows()) {
            Base.showReference("Guide_Windows.html");
        } else {
            Base.openURL("http://www.arduino.cc/playground/Learning/Linux");
        }
    }

    public static void showReference() {
        Base.showReference("index.html");
    }

    public static void showEnvironment() {
        Base.showReference("Guide_Environment.html");
    }

    public static void showPlatforms() {
        Base.showReference("environment" + File.separator + "platforms.html");
    }

    public static void showTroubleshooting() {
        Base.showReference("Guide_Troubleshooting.html");
    }

    public static void showFAQ() {
        Base.showReference("FAQ.html");
    }

    public static void showMessage(String string, String string2) {
        if (string == null) {
            string = "Message";
        }
        if (commandLine) {
            System.out.println(string + ": " + string2);
        } else {
            JOptionPane.showMessageDialog(new Frame(), string2, string, 1);
        }
    }

    public static void showWarning(String string, String string2, Exception exception) {
        if (string == null) {
            string = "Warning";
        }
        if (commandLine) {
            System.out.println(string + ": " + string2);
        } else {
            JOptionPane.showMessageDialog(new Frame(), string2, string, 2);
        }
        if (exception != null) {
            exception.printStackTrace();
        }
    }

    public static void showError(String string, String string2, Throwable throwable) {
        if (string == null) {
            string = "Error";
        }
        if (commandLine) {
            System.err.println(string + ": " + string2);
        } else {
            JOptionPane.showMessageDialog(new Frame(), string2, string, 0);
        }
        if (throwable != null) {
            throwable.printStackTrace();
        }
        System.exit(1);
    }

    public static int showYesNoCancelQuestion(Editor editor, String string, String string2, String string3) {
        if (!Base.isMacOS()) {
            int n = JOptionPane.showConfirmDialog(null, string2 + "\n" + string3, string, 1, 3);
            return n;
        }
        JOptionPane jOptionPane = new JOptionPane("<html> <head> <style type=\"text/css\">b { font: 13pt \"Lucida Grande\" }p { font: 11pt \"Lucida Grande\"; margin-top: 8px }</style> </head><b>Do you want to save changes to this sketch<BR> before closing?</b><p>If you don't save, your changes will be lost.", 3);
        Object[] objectArray = new String[]{"Save", "Cancel", "Don't Save"};
        jOptionPane.setOptions(objectArray);
        jOptionPane.setInitialValue(objectArray[0]);
        jOptionPane.putClientProperty("Quaqua.OptionPane.destructiveOption", new Integer(2));
        JDialog jDialog = jOptionPane.createDialog(editor, null);
        jDialog.setVisible(true);
        Object object = jOptionPane.getValue();
        if (object == objectArray[0]) {
            return 0;
        }
        if (object == objectArray[1]) {
            return 2;
        }
        if (object == objectArray[2]) {
            return 1;
        }
        return -1;
    }

    public static int showYesNoQuestion(Frame frame, String string, String string2, String string3) {
        if (!Base.isMacOS()) {
            return JOptionPane.showConfirmDialog(frame, "<html><body><b>" + string2 + "</b>" + "<br>" + string3, string, 0, 3);
        }
        JOptionPane jOptionPane = new JOptionPane("<html> <head> <style type=\"text/css\">b { font: 13pt \"Lucida Grande\" }p { font: 11pt \"Lucida Grande\"; margin-top: 8px }</style> </head><b>" + string2 + "</b>" + "<p>" + string3 + "</p>", 3);
        Object[] objectArray = new String[]{"Yes", "No"};
        jOptionPane.setOptions(objectArray);
        jOptionPane.setInitialValue(objectArray[0]);
        JDialog jDialog = jOptionPane.createDialog(frame, null);
        jDialog.setVisible(true);
        Object object = jOptionPane.getValue();
        if (object == objectArray[0]) {
            return 0;
        }
        if (object == objectArray[1]) {
            return 1;
        }
        return -1;
    }

    public static File getContentFile(String string) {
        Object object;
        Object object2 = System.getProperty("user.dir");
        if (Base.isMacOS() && (object = System.getProperty("javaroot")) != null) {
            object2 = object;
        }
        object = new File((String)object2);
        return new File((File)object, string);
    }

    public static Image getThemeImage(String string, Component component) {
        return Base.getLibImage("theme/" + string, component);
    }

    public static Image getLibImage(String string, Component component) {
        Image image = null;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        File file = new File(Base.getContentFile("lib"), string);
        image = toolkit.getImage(file.getAbsolutePath());
        MediaTracker mediaTracker = new MediaTracker(component);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return image;
    }

    public static InputStream getLibStream(String string) throws IOException {
        return new FileInputStream(new File(Base.getContentFile("lib"), string));
    }

    public static int countLines(String string) {
        int n = 1;
        for (char c : string.toCharArray()) {
            if (c != '\n') continue;
            ++n;
        }
        return n;
    }

    public static byte[] loadBytesRaw(File file) throws IOException {
        int n;
        int n2 = (int)file.length();
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[n2];
        int n3 = 0;
        while ((n = fileInputStream.read(byArray, n3, n2 - n3)) != -1) {
            n3 += n;
            if (n != 0) continue;
        }
        fileInputStream.close();
        fileInputStream = null;
        return byArray;
    }

    public static HashMap<String, String> readSettings(File file) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (!file.exists()) {
            return hashMap;
        }
        String[] stringArray = PApplet.loadStrings((File)file);
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            int n = stringArray[i].indexOf(35);
            String string2 = string = n == -1 ? stringArray[i].trim() : stringArray[i].substring(0, n).trim();
            if (string.length() == 0) continue;
            int n2 = string.indexOf(61);
            if (n2 == -1) {
                System.err.println("ignoring illegal line in " + file);
                System.err.println("  " + string);
                continue;
            }
            String string3 = string.substring(0, n2).trim();
            String string4 = string.substring(n2 + 1).trim();
            hashMap.put(string3, string4);
        }
        return hashMap;
    }

    public static void copyFile(File file, File file2) throws IOException {
        int n;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
        byte[] byArray = new byte[16384];
        while ((n = ((InputStream)bufferedInputStream).read(byArray)) != -1) {
            ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
        }
        ((OutputStream)bufferedOutputStream).flush();
        ((InputStream)bufferedInputStream).close();
        bufferedInputStream = null;
        ((OutputStream)bufferedOutputStream).close();
        bufferedOutputStream = null;
        file2.setLastModified(file.lastModified());
    }

    public static String loadFile(File file) throws IOException {
        String[] stringArray = PApplet.loadStrings((File)file);
        if (stringArray == null) {
            return null;
        }
        return PApplet.join((String[])stringArray, (String)"\n");
    }

    public static void saveFile(String string, File file) throws IOException {
        boolean bl;
        File file2 = File.createTempFile(file.getName(), null, file.getParentFile());
        PApplet.saveStrings((File)file2, (String[])new String[]{string});
        if (file.exists() && !(bl = file.delete())) {
            throw new IOException("Could not remove old version of " + file.getAbsolutePath());
        }
        bl = file2.renameTo(file);
        if (!bl) {
            throw new IOException("Could not replace " + file.getAbsolutePath());
        }
    }

    public static void copyDir(File file, File file2) throws IOException {
        file2.mkdirs();
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].charAt(0) == '.') continue;
            File file3 = new File(file, stringArray[i]);
            File file4 = new File(file2, stringArray[i]);
            if (file3.isDirectory()) {
                Base.copyDir(file3, file4);
                file4.setLastModified(file3.lastModified());
                continue;
            }
            Base.copyFile(file3, file4);
        }
    }

    public static void removeDir(File file) {
        if (file.exists()) {
            Base.removeDescendants(file);
            if (!file.delete()) {
                System.err.println("Could not delete " + file);
            }
        }
    }

    public static void removeDescendants(File file) {
        if (!file.exists()) {
            return;
        }
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(".") || stringArray[i].equals("..")) continue;
            File file2 = new File(file, stringArray[i]);
            if (!file2.isDirectory()) {
                if (Preferences.getBoolean("compiler.save_build_files") || file2.delete()) continue;
                System.err.println("Could not delete " + file2);
                continue;
            }
            Base.removeDir(file2);
        }
    }

    public static int calcFolderSize(File file) {
        int n = 0;
        String[] stringArray = file.list();
        if (stringArray == null) {
            return -1;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(".") || stringArray[i].equals("..") || stringArray[i].equals(".DS_Store")) continue;
            File file2 = new File(file, stringArray[i]);
            if (file2.isDirectory()) {
                n += Base.calcFolderSize(file2);
                continue;
            }
            n += (int)file2.length();
        }
        return n;
    }

    public static String[] listFiles(String string, boolean bl) {
        return Base.listFiles(new File(string), bl);
    }

    public static String[] listFiles(File file, boolean bl) {
        String string = file.getAbsolutePath();
        Vector<String> vector = new Vector<String>();
        Base.listFiles(bl ? string + File.separator : "", string, vector);
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected static void listFiles(String string, String string2, Vector<String> vector) {
        File file = new File(string2);
        String[] stringArray = file.list();
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].charAt(0) == '.') continue;
            File file2 = new File(string2, stringArray[i]);
            String string3 = file2.getAbsolutePath();
            if (string3.startsWith(string)) {
                string3 = string3.substring(string.length());
            }
            vector.add(string3);
            if (!file2.isDirectory()) continue;
            Base.listFiles(string, string3, vector);
        }
    }

    static {
        platformNames.put(1, "windows");
        platformNames.put(2, "macosx");
        platformNames.put(3, "linux");
        platformIndices = new HashMap();
        platformIndices.put("windows", 1);
        platformIndices.put("macosx", 2);
        platformIndices.put("linux", 3);
    }
}

