/* Copyright (c) 2011 Axel Wachtler, Daniel Thiele
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   * Neither the name of the authors nor the names of its contributors
     may be used to endorse or promote products derived from this software
     without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. */

#ifndef SENSORPROTO_H_
#define SENSORPROTO_H_

/* === includes ============================================================ */
#include <board.h>

/* === macros ============================================================== */

#define SENSORPROTO_WORKCHANNEL (25)
#define T_RX_SLOT MSEC(20)

/* === types =============================================================== */

typedef enum{
	SENSORPROTO_FRAMETYPE_ROSE_SLOW,
	SENSORPROTO_FRAMETYPE_ROSE_FAST,
	SENSORPROTO_FRAMETYPE_ROSE_CFG,
	SENSORPROTO_FRAMETYPE_MUSE_DATA,
	SENSORPROTO_FRAMETYPE_MUSE_CFG,
}sensorproto_frametype_t;

typedef struct{
/* start of 802.15.4 conform MAC header */
	uint16_t FCF;			/**< Frame control field acc. to 802.15.4 */
	uint8_t seqnumber;		/**< sequence number */
	uint16_t destpanid;		/**< PAN ID of destination */
	uint16_t destaddr;		/**< Short address of destination */
	uint16_t srcaddr;		/**< Short address of source */
/* end of 802.15.4 conform MAC header */

	uint8_t boardtype;		/**< board type identifier */
	sensorproto_frametype_t frametype;		/**< frame type identifier */
}sensorproto_hdr_t;

typedef struct{
	uint16_t crc;
}sensorproto_ftr_t;

/* === prototypes ========================================================== */
#ifdef __cplusplus
extern "C" {
#endif

void sensorproto_init(uint8_t boardtype);
node_config_t* sensorproto_get_config(void);
void sensorproto_tx(uint8_t *data, uint8_t frametype, uint8_t ack_req);
void cb_sensorproto_rx(uint8_t *frm);
void cb_sensorproto_txdone(radio_tx_done_t status);

#ifdef __cplusplus
} /* extern "C" */
#endif


#endif /* SENSORPROTO_H_ */
