/* Copyright (c) 2012 Axel Wachtler
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   * Neither the name of the authors nor the names of its contributors
     may be used to endorse or promote products derived from this software
     without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. */

/* $Id$ */
/**
 * @file
 * @brief ....
 * @_addtogroup grpApp...
 */


/* === includes ============================================================ */

/* === send flags =========================================================== */
#include "board.h"
#include "radio.h"
#include "p2p.h"
/* === macros ============================================================== */

/* === types =============================================================== */
typedef struct
{
    uint16_t src;
    uint16_t pan;

} p2p_context_t;
/* === globals ============================================================= */

static p2p_context_t P2PCtx;
/* === prototypes ========================================================== */

/* === functions =========================================================== */
void p2p_init(uint16_t src, uint16_t pan)
{
    P2PCtx.src = src;
    P2PCtx.pan = pan;
}

#if 0
/* will come soon */
void p2p_task(void)
{

}
#endif

void p2p_send(uint16_t dst, uint8_t cmd, uint8_t flags,
              uint8_t *data, uint8_t lendata)
{
    p2p_hdr_t *hdr = (p2p_hdr_t*) data;

    __FILL_P2P_HEADER__(hdr, ((flags & P2P_ACK) ? 0x8861 : 0x8841),
                    P2PCtx.pan, dst, P2PCtx.src, cmd);
    radio_set_state(STATE_TX);
    radio_set_state(STATE_TXAUTO);
    radio_send_frame(lendata + 2, data, 1); /* +2: add CRC bytes (FCF) */
}


#if 0
/* will come soon */
uint8_t *usr_radio_receive_frame(uint8_t len, uint8_t *frm, uint8_t lqi, int8_t ed, uint8_t crc_fail)
{

}
#endif
