/*
 * Decompiled with CFR 0.152.
 */
package processing.app.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import processing.app.Base;
import processing.app.Editor;
import processing.app.tools.Tool;
import processing.core.PApplet;

public class ColorSelector
implements Tool,
DocumentListener {
    Editor editor;
    JFrame frame;
    int hue;
    int saturation;
    int brightness;
    int red;
    int green;
    int blue;
    ColorRange range;
    ColorSlider slider;
    JTextField hueField;
    JTextField saturationField;
    JTextField brightnessField;
    JTextField redField;
    JTextField greenField;
    JTextField blueField;
    JTextField hexField;
    JPanel colorPanel;
    boolean updating;
    int labelH;

    public String getMenuTitle() {
        return "Color Selector";
    }

    public void init(Editor editor) {
        this.editor = editor;
        this.frame = new JFrame("Color Selector");
        this.frame.getContentPane().setLayout(new BorderLayout());
        Box box = Box.createHorizontalBox();
        box.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.range = new ColorRange();
        this.range.init();
        Box box2 = new Box(1);
        box2.setAlignmentY(0.0f);
        box2.setBorder(BorderFactory.createBevelBorder(1));
        box2.add((Component)((Object)this.range));
        box.add(box2);
        box.add(Box.createHorizontalStrut(10));
        this.slider = new ColorSlider();
        this.slider.init();
        Box box3 = new Box(1);
        box3.setAlignmentY(0.0f);
        box3.setBorder(BorderFactory.createBevelBorder(1));
        box3.add((Component)((Object)this.slider));
        box.add(box3);
        box.add(Box.createHorizontalStrut(10));
        box.add(this.createColorFields());
        box.add(Box.createHorizontalStrut(10));
        this.frame.getContentPane().add((Component)box, "Center");
        this.frame.pack();
        this.frame.setResizable(false);
        Dimension dimension = this.frame.getSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        this.frame.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
        this.frame.setDefaultCloseOperation(0);
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ColorSelector.this.frame.setVisible(false);
            }
        });
        Base.registerWindowCloseKeys(this.frame.getRootPane(), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ColorSelector.this.frame.setVisible(false);
            }
        });
        Base.setIcon(this.frame);
        this.hueField.getDocument().addDocumentListener(this);
        this.saturationField.getDocument().addDocumentListener(this);
        this.brightnessField.getDocument().addDocumentListener(this);
        this.redField.getDocument().addDocumentListener(this);
        this.greenField.getDocument().addDocumentListener(this);
        this.blueField.getDocument().addDocumentListener(this);
        this.hexField.getDocument().addDocumentListener(this);
        this.hexField.setText("FFFFFF");
    }

    public void run() {
        this.frame.setVisible(true);
        this.frame.setCursor(Cursor.getPredefinedCursor(1));
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void removeUpdate(DocumentEvent documentEvent) {
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.updating) {
            return;
        }
        this.updating = true;
        Document document = documentEvent.getDocument();
        if (document == this.hueField.getDocument()) {
            this.hue = this.bounded(this.hue, this.hueField, 359);
            this.updateRGB();
            this.updateHex();
        } else if (document == this.saturationField.getDocument()) {
            this.saturation = this.bounded(this.saturation, this.saturationField, 99);
            this.updateRGB();
            this.updateHex();
        } else if (document == this.brightnessField.getDocument()) {
            this.brightness = this.bounded(this.brightness, this.brightnessField, 99);
            this.updateRGB();
            this.updateHex();
        } else if (document == this.redField.getDocument()) {
            this.red = this.bounded(this.red, this.redField, 255);
            this.updateHSB();
            this.updateHex();
        } else if (document == this.greenField.getDocument()) {
            this.green = this.bounded(this.green, this.greenField, 255);
            this.updateHSB();
            this.updateHex();
        } else if (document == this.blueField.getDocument()) {
            this.blue = this.bounded(this.blue, this.blueField, 255);
            this.updateHSB();
            this.updateHex();
        } else if (document == this.hexField.getDocument()) {
            String string = this.hexField.getText();
            while (string.length() < 6) {
                string = string + "0";
            }
            if (string.length() > 6) {
                string = string.substring(0, 6);
            }
            this.updateRGB2(Integer.parseInt(string, 16));
            this.updateHSB();
        }
        this.range.redraw();
        this.slider.redraw();
        this.colorPanel.repaint();
        this.updating = false;
    }

    protected void updateRGB() {
        int n = Color.HSBtoRGB((float)this.hue / 359.0f, (float)this.saturation / 99.0f, (float)this.brightness / 99.0f);
        this.updateRGB2(n);
    }

    protected void updateRGB2(int n) {
        this.red = n >> 16 & 0xFF;
        this.green = n >> 8 & 0xFF;
        this.blue = n & 0xFF;
        this.redField.setText(String.valueOf(this.red));
        this.greenField.setText(String.valueOf(this.green));
        this.blueField.setText(String.valueOf(this.blue));
    }

    protected void updateHSB() {
        float[] fArray = new float[3];
        Color.RGBtoHSB(this.red, this.green, this.blue, fArray);
        this.hue = (int)(fArray[0] * 359.0f);
        this.saturation = (int)(fArray[1] * 99.0f);
        this.brightness = (int)(fArray[2] * 99.0f);
        this.hueField.setText(String.valueOf(this.hue));
        this.saturationField.setText(String.valueOf(this.saturation));
        this.brightnessField.setText(String.valueOf(this.brightness));
    }

    protected void updateHex() {
        this.hexField.setText(PApplet.hex((int)this.red, (int)2) + PApplet.hex((int)this.green, (int)2) + PApplet.hex((int)this.blue, (int)2));
    }

    protected int bounded(int n, final JTextField jTextField, final int n2) {
        String string = jTextField.getText();
        if (string.length() == 0) {
            return 0;
        }
        try {
            int n3 = Integer.parseInt(string);
            if (n3 > n2) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        jTextField.setText(String.valueOf(n2));
                    }
                });
                return n2;
            }
            return n3;
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    protected Container createColorFields() {
        Box box = Box.createVerticalBox();
        box.setAlignmentY(0.0f);
        this.colorPanel = new JPanel(){

            public void paintComponent(Graphics graphics) {
                graphics.setColor(new Color(ColorSelector.this.red, ColorSelector.this.green, ColorSelector.this.blue));
                Dimension dimension = this.getSize();
                graphics.fillRect(0, 0, dimension.width, dimension.height);
            }
        };
        this.colorPanel.setBorder(BorderFactory.createBevelBorder(1));
        Dimension dimension = new Dimension(60, 40);
        this.colorPanel.setMinimumSize(dimension);
        box.add(this.colorPanel);
        box.add(Box.createVerticalStrut(10));
        Box box2 = Box.createHorizontalBox();
        box2.add(this.createFixedLabel("H:"));
        this.hueField = new NumberField(4, false);
        box2.add(this.hueField);
        box2.add(new JLabel(" \u00b0"));
        box2.add(Box.createHorizontalGlue());
        box.add(box2);
        box.add(Box.createVerticalStrut(5));
        box2 = Box.createHorizontalBox();
        box2.add(this.createFixedLabel("S:"));
        this.saturationField = new NumberField(4, false);
        box2.add(this.saturationField);
        box2.add(new JLabel(" %"));
        box2.add(Box.createHorizontalGlue());
        box.add(box2);
        box.add(Box.createVerticalStrut(5));
        box2 = Box.createHorizontalBox();
        box2.add(this.createFixedLabel("B:"));
        this.brightnessField = new NumberField(4, false);
        box2.add(this.brightnessField);
        box2.add(new JLabel(" %"));
        box2.add(Box.createHorizontalGlue());
        box.add(box2);
        box.add(Box.createVerticalStrut(10));
        box2 = Box.createHorizontalBox();
        box2.add(this.createFixedLabel("R:"));
        this.redField = new NumberField(4, false);
        box2.add(this.redField);
        box2.add(Box.createHorizontalGlue());
        box.add(box2);
        box.add(Box.createVerticalStrut(5));
        box2 = Box.createHorizontalBox();
        box2.add(this.createFixedLabel("G:"));
        this.greenField = new NumberField(4, false);
        box2.add(this.greenField);
        box2.add(Box.createHorizontalGlue());
        box.add(box2);
        box.add(Box.createVerticalStrut(5));
        box2 = Box.createHorizontalBox();
        box2.add(this.createFixedLabel("B:"));
        this.blueField = new NumberField(4, false);
        box2.add(this.blueField);
        box2.add(Box.createHorizontalGlue());
        box.add(box2);
        box.add(Box.createVerticalStrut(10));
        box2 = Box.createHorizontalBox();
        box2.add(this.createFixedLabel("#"));
        this.hexField = new NumberField(5, true);
        box2.add(this.hexField);
        box2.add(Box.createHorizontalGlue());
        box.add(box2);
        box.add(Box.createVerticalStrut(10));
        box.add(Box.createVerticalGlue());
        return box;
    }

    protected JLabel createFixedLabel(String string) {
        JLabel jLabel = new JLabel(string);
        if (this.labelH == 0) {
            this.labelH = jLabel.getPreferredSize().height;
        }
        Dimension dimension = new Dimension(20, this.labelH);
        jLabel.setPreferredSize(dimension);
        jLabel.setMinimumSize(dimension);
        jLabel.setMaximumSize(dimension);
        return jLabel;
    }

    class NumberDocument
    extends PlainDocument {
        NumberField parentField;

        public NumberDocument(NumberField numberField) {
            this.parentField = numberField;
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == null) {
                return;
            }
            char[] cArray = string.toCharArray();
            int n2 = 0;
            for (int i = 0; i < cArray.length; ++i) {
                boolean bl = Character.isDigit(cArray[i]);
                if (this.parentField.allowHex) {
                    if (cArray[i] >= 'A' && cArray[i] <= 'F') {
                        bl = true;
                    }
                    if (cArray[i] >= 'a' && cArray[i] <= 'f') {
                        bl = true;
                    }
                }
                if (!bl) continue;
                if (n2 != i) {
                    cArray[n2] = cArray[i];
                }
                ++n2;
            }
            super.insertString(n, new String(cArray, 0, n2), attributeSet);
        }
    }

    class NumberField
    extends JTextField {
        public boolean allowHex;

        public NumberField(int n, boolean bl) {
            super(n);
            this.allowHex = bl;
        }

        protected Document createDefaultModel() {
            return new NumberDocument(this);
        }

        public Dimension getPreferredSize() {
            if (!this.allowHex) {
                return new Dimension(35, super.getPreferredSize().height);
            }
            return super.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    }

    public class ColorSlider
    extends PApplet {
        static final int WIDE = 20;
        static final int HIGH = 256;

        public void setup() {
            this.size(20, 256, "processing.core.PGraphics3D");
            this.colorMode(3, 255.0f, 100.0f, 100.0f);
            this.noLoop();
        }

        public void draw() {
            if (this.g == null || this.g.pixels == null) {
                return;
            }
            if (this.width != 20 || this.height < 256) {
                return;
            }
            int n = 0;
            int n2 = 255 - (int)(255.0f * ((float)ColorSelector.this.hue / 359.0f));
            for (int i = 0; i < 256; ++i) {
                int n3 = this.color(255 - i, 100, 100);
                if (i == n2) {
                    n3 = -16777216;
                }
                for (int j = 0; j < 20; ++j) {
                    this.g.pixels[n++] = n3;
                }
            }
        }

        public void mousePressed() {
            this.updateMouse();
        }

        public void mouseDragged() {
            this.updateMouse();
        }

        public void updateMouse() {
            if (this.mouseX >= 0 && this.mouseX < 256 && this.mouseY >= 0 && this.mouseY < 256) {
                int n = 359 - (int)(359.0f * ((float)this.mouseY / 255.0f));
                ColorSelector.this.hueField.setText(String.valueOf(n));
            }
        }

        public Dimension getPreferredSize() {
            return new Dimension(20, 256);
        }

        public Dimension getMinimumSize() {
            return new Dimension(20, 256);
        }

        public Dimension getMaximumSize() {
            return new Dimension(20, 256);
        }
    }

    public class ColorRange
    extends PApplet {
        static final int WIDE = 256;
        static final int HIGH = 256;
        int lastX;
        int lastY;

        public void setup() {
            this.size(256, 256, "processing.core.PGraphics3D");
            this.noLoop();
            this.colorMode(3, 360.0f, 256.0f, 256.0f);
            this.noFill();
            this.rectMode(3);
        }

        public void draw() {
            if (this.g == null || this.g.pixels == null) {
                return;
            }
            if (this.width != 256 || this.height < 256) {
                return;
            }
            int n = 0;
            for (int i = 0; i < 256; ++i) {
                for (int j = 0; j < 256; ++j) {
                    this.g.pixels[n++] = this.color(ColorSelector.this.hue, j, 255 - i);
                }
            }
            this.stroke(ColorSelector.this.brightness > 50 ? 0 : 255);
            this.rect(this.lastX, this.lastY, 9.0f, 9.0f);
        }

        public void mousePressed() {
            this.updateMouse();
        }

        public void mouseDragged() {
            this.updateMouse();
        }

        public void updateMouse() {
            if (this.mouseX >= 0 && this.mouseX < 256 && this.mouseY >= 0 && this.mouseY < 256) {
                int n = (int)(100.0f * ((float)this.mouseX / 255.0f));
                int n2 = 100 - (int)(100.0f * ((float)this.mouseY / 255.0f));
                ColorSelector.this.saturationField.setText(String.valueOf(n));
                ColorSelector.this.brightnessField.setText(String.valueOf(n2));
                this.lastX = this.mouseX;
                this.lastY = this.mouseY;
            }
        }

        public Dimension getPreferredSize() {
            return new Dimension(256, 256);
        }

        public Dimension getMinimumSize() {
            return new Dimension(256, 256);
        }

        public Dimension getMaximumSize() {
            return new Dimension(256, 256);
        }
    }
}

