/* Copyright (c) 2012 - 2013 Samuel Klipphahn
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   * Neither the name of the authors nor the names of its contributors
     may be used to endorse or promote products derived from this software
     without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. */

/* $Id: $ */
/**
 * @file
 * @brief Interface for lwMesh command frames
 * @ingroup grplwMesh
 */
#ifndef LWCMD_H
#define LWCMD_H

/**
 *  @addtogroup grplwMesh
 *  @{
 */
/* === includes ============================================================ */
#include "lw_mesh.h"

/* === macros ============================================================== */

/* === types =============================================================== */
typedef enum SHORTENUM
{
    NWK_CMD_ID_ACK          = 0x00,
    NWK_CMD_ID_ROUTE_ERROR  = 0x01,
} NWK_cmd_id_t;

/**
 * @brief structure for lightweight mesh acknowledgment command frame
 */
typedef struct{
    NWK_cmd_id_t    lw_cmd_id;          /**< use NWK_CMD_ID_ACK as ID for
                                        acknowledgment command frame here */
    uint8_t lw_cmd_seq;                 /**< lw_seq of acknowledged frame */
    uint8_t lw_cmd_ctrl_message;        /**< individual control message with
                                        arbitrary value, can be used to provide
                                        additional instructions to the
                                        receiving side */
} NWK_cmd_ack_t;

/**
 * @brief structure for lightweight mesh route error command frame
 */
typedef struct{
    NWK_cmd_id_t    lw_cmd_id;          /**< use NWK_CMD_ID_ROUTE_ERROR as ID
                                        for route error command frame here */
    uint16_t        lw_cmd_src_addr;    /**< lw_src_addr of frame that cannot
                                        be routed */
    uint16_t        lw_cmd_dst_addr;    /**< lw_dst_addr of frame that cannot
                                        be routed */
} NWK_cmd_r_err_t;

/* === prototypes ========================================================== */
#ifdef __cplusplus
extern "C" {
#endif

void lwc_init();

void lwc_data_confirm(NWK_DataReq_t *req);
void lwc_set_ack_control(uint8_t control);
void lwc_prep_ack_pl(NWK_FrameFormat_t *rx_frame, NWK_cmd_ack_t *ack_pl);
void lwc_prep_r_err_pl(NWK_FrameFormat_t *rx_frame, NWK_cmd_r_err_t *err_pl);

#ifdef __cplusplus
} /* extern "C" */
#endif

/**
 *  @}
 */
#endif  /* #ifndef LWCMD_H */
