/* THIS FILE IS GENERATED by ds2reg.py FROM INPUT Templates/mma7455.txt */

/* Copyright (c) 2009 Axel Wachtler
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   * Neither the name of the authors nor the names of its contributors
     may be used to endorse or promote products derived from this software
     without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. */

/* $Id: mma7455.txt,v 1.2 2010/12/05 20:21:54 awachtler Exp $ */
/**
 * @file
 * @brief MMA7455, a 2g/4g/8g Three Axis Low-g Digital Output Accelerometer.
 */

#ifndef MMA7455_H
#define MMA7455_H (1)

/* === Includes ============================================================== */

/* === Externals ============================================================= */

/* === Types ================================================================= */

/* === Macros ================================================================ */
/** Name string of the sensor */
#define ACC_SENSOR_NAME "MMA7455"


/** Subregister MOD[1:0], STANDBY */
#define ACC_MODE_STANDBY        (0x00)
/** Subregister MOD[1:0], MEASURE */
#define ACC_MODE_MEASURE        (0x01)
/** Subregister MOD[1:0], LEVELDETECT */
#define ACC_MODE_LEVELDETECT    (0x02)
/** Subregister MOD[1:0], PULSEDETECT */
#define ACC_MODE_PULSEDETECT    (0x03)

/** Subregister GLVL[1:0], g-Selector: 2g */
#define ACC_RANGE_2G            (0x01)
/** Subregister GLVL[1:0], g-Selector: 4g */
#define ACC_RANGE_4G            (0x02)
/** Subregister GLVL[1:0], g-Selector: 8g */
#define ACC_RANGE_8G            (0x00)
/** Offset for register XOUTL */
#define RG_XOUTL (0x0)
  /** Access parameters for sub-register XOUTL in register XOUTL */
  #define SR_XOUTL 0x0,0xff,0
/** Offset for register XOUTH */
#define RG_XOUTH (0x1)
  /** Access parameters for sub-register XOUTH in register XOUTH */
  #define SR_XOUTH 0x1,0x3,0
/** Offset for register YOUTL */
#define RG_YOUTL (0x2)
  /** Access parameters for sub-register YOUTL in register YOUTL */
  #define SR_YOUTL 0x2,0xff,0
/** Offset for register YOUTH */
#define RG_YOUTH (0x3)
  /** Access parameters for sub-register YOUTH in register YOUTH */
  #define SR_YOUTH 0x3,0x3,0
/** Offset for register ZOUTL */
#define RG_ZOUTL (0x4)
  /** Access parameters for sub-register ZOUTL in register ZOUTL */
  #define SR_ZOUTL 0x4,0xff,0
/** Offset for register ZOUTH */
#define RG_ZOUTH (0x5)
  /** Access parameters for sub-register ZOUTH in register ZOUTH */
  #define SR_ZOUTH 0x5,0x3,0
/** Offset for register XOUT8 */
#define RG_XOUT8 (0x6)
  /** Access parameters for sub-register XOUT in register XOUT8 */
  #define SR_XOUT 0x6,0xff,0
/** Offset for register YOUT8 */
#define RG_YOUT8 (0x7)
  /** Access parameters for sub-register YOUT in register YOUT8 */
  #define SR_YOUT 0x7,0xff,0
/** Offset for register ZOUT8 */
#define RG_ZOUT8 (0x8)
  /** Access parameters for sub-register ZOUT in register ZOUT8 */
  #define SR_ZOUT 0x8,0xff,0
/** Offset for register STATUS */
#define RG_STATUS (0x9)
  /** Access parameters for sub-register PERR in register STATUS */
  #define SR_PERR 0x9,0x4,2
  /** Access parameters for sub-register DRDY in register STATUS */
  #define SR_DRDY 0x9,0x1,0
  /** Access parameters for sub-register DOVR in register STATUS */
  #define SR_DOVR 0x9,0x2,1
/** Offset for register DETSRC */
#define RG_DETSRC (0xa)
  /** Access parameters for sub-register LDX in register DETSRC */
  #define SR_LDX 0xa,0x80,7
  /** Access parameters for sub-register LDY in register DETSRC */
  #define SR_LDY 0xa,0x40,6
  /** Access parameters for sub-register LDZ in register DETSRC */
  #define SR_LDZ 0xa,0x20,5
  /** Access parameters for sub-register PDX in register DETSRC */
  #define SR_PDX 0xa,0x10,4
  /** Access parameters for sub-register PDY in register DETSRC */
  #define SR_PDY 0xa,0x8,3
  /** Access parameters for sub-register PDZ in register DETSRC */
  #define SR_PDZ 0xa,0x4,2
  /** Access parameters for sub-register INT1 in register DETSRC */
  #define SR_INT1 0xa,0x1,0
  /** Access parameters for sub-register INT2 in register DETSRC */
  #define SR_INT2 0xa,0x2,1
/** Offset for register TOUT */
#define RG_TOUT (0xb)
  /** Access parameters for sub-register TMP in register TOUT */
  #define SR_TMP 0xb,0xff,0
/** Offset for register I2CAD */
#define RG_I2CAD (0xd)
  /** Access parameters for sub-register I2CDIS in register I2CAD */
  #define SR_I2CDIS 0xd,0x80,7
  /** Access parameters for sub-register DAD in register I2CAD */
  #define SR_DAD 0xd,0x7f,0
/** Offset for register USRINF */
#define RG_USRINF (0xe)
  /** Access parameters for sub-register UI in register USRINF */
  #define SR_UI 0xe,0xff,0
/** Offset for register WHOAMI */
#define RG_WHOAMI (0xf)
  /** Access parameters for sub-register ID in register WHOAMI */
  #define SR_ID 0xf,0xff,0
/** Offset for register XOFFL */
#define RG_XOFFL (0x10)
  /** Access parameters for sub-register XOFFL in register XOFFL */
  #define SR_XOFFL 0x10,0xff,0
/** Offset for register XOFFH */
#define RG_XOFFH (0x11)
  /** Access parameters for sub-register XOFFH in register XOFFH */
  #define SR_XOFFH 0x11,0x7,0
/** Offset for register YOFFL */
#define RG_YOFFL (0x12)
  /** Access parameters for sub-register YOFFL in register YOFFL */
  #define SR_YOFFL 0x12,0xff,0
/** Offset for register YOFFH */
#define RG_YOFFH (0x13)
  /** Access parameters for sub-register YOFFH in register YOFFH */
  #define SR_YOFFH 0x13,0x7,0
/** Offset for register ZOFFL */
#define RG_ZOFFL (0x14)
  /** Access parameters for sub-register ZOFFL in register ZOFFL */
  #define SR_ZOFFL 0x14,0xff,0
/** Offset for register ZOFFH */
#define RG_ZOFFH (0x15)
  /** Access parameters for sub-register ZOFFH in register ZOFFH */
  #define SR_ZOFFH 0x15,0x7,0
/** Offset for register MCTL */
#define RG_MCTL (0x16)
  /** Access parameters for sub-register DRPD in register MCTL */
  #define SR_DRPD 0x16,0x40,6
  /** Access parameters for sub-register SPI3W in register MCTL */
  #define SR_SPI3W 0x16,0x20,5
  /** Access parameters for sub-register STON in register MCTL */
  #define SR_STON 0x16,0x10,4
  /** Access parameters for sub-register GLVL in register MCTL */
  #define SR_GLVL 0x16,0xc,2
  /** Access parameters for sub-register MOD in register MCTL */
  #define SR_MOD 0x16,0x3,0
/** Offset for register INTRST */
#define RG_INTRST (0x17)
  /** Access parameters for sub-register CLRINT1 in register INTRST */
  #define SR_CLRINT1 0x17,0x1,0
  /** Access parameters for sub-register CLRINT2 in register INTRST */
  #define SR_CLRINT2 0x17,0x2,1
/** Offset for register CTL1 */
#define RG_CTL1 (0x18)
  /** Access parameters for sub-register DFBW in register CTL1 */
  #define SR_DFBW 0x18,0x80,7
  /** Access parameters for sub-register THOPT in register CTL1 */
  #define SR_THOPT 0x18,0x40,6
  /** Access parameters for sub-register ZDA in register CTL1 */
  #define SR_ZDA 0x18,0x20,5
  /** Access parameters for sub-register YDA in register CTL1 */
  #define SR_YDA 0x18,0x10,4
  /** Access parameters for sub-register XDA in register CTL1 */
  #define SR_XDA 0x18,0x8,3
  /** Access parameters for sub-register INTPIN in register CTL1 */
  #define SR_INTPIN 0x18,0x1,0
  /** Access parameters for sub-register INTRG in register CTL1 */
  #define SR_INTRG 0x18,0x6,1
/** Offset for register CTL2 */
#define RG_CTL2 (0x19)
  /** Access parameters for sub-register DRVO in register CTL2 */
  #define SR_DRVO 0x19,0x4,2
  /** Access parameters for sub-register LDPL in register CTL2 */
  #define SR_LDPL 0x19,0x1,0
  /** Access parameters for sub-register PDPL in register CTL2 */
  #define SR_PDPL 0x19,0x2,1
/** Offset for register LDTH */
#define RG_LDTH (0x1a)
  /** Access parameters for sub-register LDTH in register LDTH */
  #define SR_LDTH 0x1a,0xff,0
/** Offset for register PDTH */
#define RG_PDTH (0x1b)
  /** Access parameters for sub-register PDTH in register PDTH */
  #define SR_PDTH 0x1b,0xff,0
/** Offset for register PW */
#define RG_PW (0x1c)
  /** Access parameters for sub-register PD in register PW */
  #define SR_PD 0x1c,0xff,0
/** Offset for register LT */
#define RG_LT (0x1d)
  /** Access parameters for sub-register LT in register LT */
  #define SR_LT 0x1d,0xff,0
/** Offset for register TW */
#define RG_TW (0x1e)
  /** Access parameters for sub-register TW in register TW */
  #define SR_TW 0x1e,0xff,0

#endif /* ifndef MMA7455_H */

