<?php

/* Westgen Sitewide Templating System
   Copyright (C) 2006 Brian Nez, <thedude at bri1 dot com>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

   $wg_root/_admin/gallery_rebuild.php - Admin frontend Page Delete */

if(!file_exists('../index.php')) {
        die('<b>Fatal error:</b> ThemeX could not find the path to itself. Your
installation may be corrupt.'); }
define("westgen", true);
include("../index.php");

include("thumbnail.inc.php");

include("header_light.php");

echo("<table width=\"100%\" class=\"blend\"><tr><td><b>Rebuild Thumbnails</b></tr></td></table>\n");

echo("<table width=\"100%\"><tr><td>");

// Verify that the directory has no invalid characters
// If not, set $dir to the full path
if(strstr($_GET['subdir'], '..') != "") {
        die('<b>Fatal error:</b> Directory name can not have ".." in it.'); }
if($_GET['subdir'] != "") {
	$dir = $wg_phtml . "/pictures/" . $_GET['subdir'] . "/";
} else {
	$dir = $wg_phtml . "/pictures/"; }

// Verify that the directory is actually real, or die
if(!file_exists($dir)) {
	die("<b>Fatal error:</b> Could not open directory."); }

// Is this the first time?
if($_GET['areyousure'] != "Yes") {
	?>
<form method="GET" action="<?=$_SERVER['PHP_SELF']?>">
	Are you sure you want to non-recursively rebuild ALL thumbnails in gallery <i><?=basename($_GET['subdir'])?></i>?<br />
	<br />This action can take some time.<br /><br />
	<input type="hidden" name="subdir" value="<?=$_GET['subdir']?>" />
	<input type="submit" name="areyousure" value="Yes" />
	<a href="javascript:window.close()">Close</a>
</form>
	<?
} else {
	// They are sure!
	echo("Rebuilding thumbnails for gallery <i>" . basename($_GET['subdir']) . "</i>... ");
	$dirhand = opendir($dir);
	while(false != ($file = readdir($dirhand))) {
		$file_info = pathinfo($file);
		$ext = $file_info['extension'];
		$thumbStrPos = strpos($file, 'thumb-');
		if(($ext == "jpg" || $ext == "jpeg" || $ext == "gif" || $ext == "bmp" || $ext == "png" || $ext == "JPG" || $ext == "JPEG" || $ext == "GIF" || $ext == "BMP" || $ext == "PNG") && ($file != "_prepend.php" && $file != "_append.php" && $file != ".." && $file != "." && $ext != "title") && ($thumbStrPos != 0 || $thumbStrPos === FALSE)) {
			if(!thumbnail($dir . $file)) {
				echo ("\n<br /><b>Error:</b> Couldn't process file <i>" . $file . "</i>.");
			} // end thumbnail creation/check
		} // end extension check
	} // end directory loop
	echo ("Done<br />\n");
	echo("<br /><a href=\"javascript:window.close()\">Close</a>\n");
}

?>
</td></tr></table><?

include("footer_light.php");

?>