<?php

/* Westgen Sitewide Templating System
   Copyright (C) 2006 Brian Nez, <thedude at bri1 dot com>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

   $wg_root/_admin/pages.php - Admin frontend Page Dir Viewer */

if(!file_exists('../index.php')) {
        die('<b>Fatal error:</b> ThemeX could not find the path to itself. Your installation may be corrupt.'); }
define("westgen", true);
include("../index.php");

include("header.php");

?>
<script language="JavaScript" type="text/javascript">
<!--
function dialog(url) {
	window.open(url,'wg_dialog','toolbar=0,scrollbars=1,location=0,statusbar=1,menubar=0,resizable=1,width=410,height=200');
}
</script>
<?

function dirsize($dir) {
	$size = 0;
	$dir .= (!ereg('/$', $dir)) ? '/' : '';
	$handle = opendir($dir);
	while (($file = readdir($handle)) != FALSE) {
		if (!ereg('^\.{1,2}$', $file)) {
			$size += (is_dir($dir . $file)) ? dirsize($dir . $file) : filesize($dir . $file); } }
	closedir($handle);
	return $size;
}

function truncate ($num, $digits = 0) {
	$shift = pow(10 , $digits);
	return ((floor($num * $shift)) / $shift);
}

if(strstr($_GET['subdir'], '..') != "") {
        die('<b>Fatal error:</b> Directory name can not have ".." in it.'); }
if($_GET['subdir'] != "") {
	$dir = $wg_phtml . "/content/" . $_GET['subdir'] . "/";
} else {
	$dir = $wg_phtml . "/content/"; }

echo("	<table class=\"max blend\">\n	<tr><td><b>Current Path:</b> <a href=\"" . $_SERVER['PHP_SELF'] . "\">Content</a>");
if($_GET['subdir'] != "") {
	echo(" <b>/</b> ");
	$dir_chunks = explode("/", $_GET['subdir']);
	$count = 0;
	while($dir_chunks[$count] != "") {
		echo("<a href=\"" . $_SERVER['PHP_SELF'] . "?subdir=");
		$rev_count = 0;
		while($rev_count < ($count+1)) {
			echo($dir_chunks[$rev_count] . "/");
			$rev_count++;
		}
		echo("\">" . $dir_chunks[$count] . "</a>");
		$count++;
		if($dir_chunks[$count] != "") {
			echo(" <b>/</b> "); }
	}
}
echo("	</td><td align=\"right\"><a href=\"javascript:dialog('upload.php?mode=content&type=dir&subdir=" . $_GET['subdir'] . "')\"><img src=\"upload.png\"> <span class=\"dclick\">Upload Files</span></a> &nbsp; <a href=\"javascript:dialog('pages_new.php?mode=content&type=dir&subdir=" . $_GET['subdir'] . "')\"><img src=\"newdir.png\"> <span class=\"dclick\">New Directory</span></a> &nbsp; <a href=\"javascript:dialog('pages_new.php?mode=content&type=file&subdir=" . $_GET['subdir'] . "')\"><img src=\"newpage.png\">&nbsp;<span class=\"pclick\">New Page</span></a>&nbsp;</td></tr></table>\n	<table class=\"max\">\n	<tr><th width=\"30%\">Filename</th><th width=\"40%\">Title</th><th width=\"15%\">File size</th><th width=\"15%\">Action</td></tr>\n");

if (is_dir($dir)) {
	if($dh = opendir($dir)) {
		while(($file = readdir($dh)) !== false) {
			// It is dir.
			if(filetype($dir . $file) == "dir" && $file != "." && $file != "..")
			{
				echo("	<tr><td><a href=\"" . $_SERVER['PHP_SELF'] . "?subdir=");
				if($_GET['subdir'] != "") { echo($_GET['subdir'] . "/"); }
				echo($file . "\"><img src=\"dir.png\" alt=\"Directory\"> <span class=\"dclick\">" . $file . "</span></a><td align=\"center\">");
				// Title display code
				if(file_exists($dir . $file . "/.dir.title")) {
					if(file_get_contents($dir . $file . "/.dir.title") == "") {
						echo("(no title)");
					} else {
						echo(stripslashes(file_get_contents($dir . $file . "/.dir.title"))); }
				} else {
					echo("(no title)"); }
				echo("</a></td><td align=\"center\">" . truncate(dirsize($dir)/1024, 2) . " KB</td><td align=\"center\"><a href=\"javascript:dialog('pages_rename.php?file=" . $dir . $file . "')\"><img src=\"ren.png\" alt=\"Rename\"></a> <a href=\"javascript:dialog('pages_duplicate.php?file=" . $dir . $file . "')\"><img src=\"copy.png\" alt=\"Duplicate\"></a> <a href=\"javascript:dialog('pages_delete.php?file=" . $dir . $file . "')\"><img src=\"del.png\" alt=\"Delete\"></a></td></tr>\n");
			} else {
			// It is file.
				$file_info = pathinfo($file);
				$ext = $file_info['extension'];
				if(/*($ext == "html" || $ext == "htm" || $ext == "php") && */($file != "_prepend.php" && $file != "_append.php" && $file != ".." && $file != "." && $ext != "title")) {

					echo("	<tr><td><a href=\"pages_editfile.php?file=" . $_GET['subdir'] . "/" . $file . "\"><img src=\"page.png\" alt=\"File\"> <span class=\"fclick\">" . $file . "</span></a></td><td align=\"center\">");
					// Title display code
					if(file_exists($dir . $file . ".title")) {
						if(file_get_contents($dir . $file . ".title") == "") {
							echo("(no title)");
						} else {
							echo(stripslashes(file_get_contents($dir . $file . ".title"))); }
					} else {
						echo("(no title)"); }
					echo("</td><td align=\"center\">" . truncate(filesize($dir . $file )/1024, 2) . " KB</td><td align=\"center\"><a href=\"javascript:dialog('pages_rename.php?file=" . $dir . $file . "')\"><img src=\"ren.png\" alt=\"Rename\"></a> <a href=\"javascript:dialog('pages_duplicate.php?file=" . $dir . $file . "')\"><img src=\"copy.png\" alt=\"Duplicate\"></a> <a href=\"javascript:dialog('pages_delete.php?file=" . $dir . $file . "')\"><img src=\"del.png\" alt=\"Delete\"></a></td></tr>\n"); }
				}
			}
		closedir($dh);
		} else {
		die('<b>Fatal error:</b> Directory could not be opened for reading. Your installation may be corrupt, or you may have passed an invalid path.'); }
	} else {
	die('<b>Fatal error:</b> Not a directory. You may have passed an invalid path.'); }
?>
</table>
<?

include("footer.php");

?>