<?php

/* Westgen Sitewide Templating System
   Copyright (C) 2006 Brian Nez, <thedude at bri1 dot com>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

   $wg_root/_admin/pages_new.php - Admin frontend Page New */

if(!file_exists('../index.php')) {
        die('<b>Fatal error:</b> ThemeX could not find the path to itself. Your
installation may be corrupt.'); }
define("westgen", true);
include("../index.php");

include("header_light.php");

$perms = 0777;

// Verify that our mode is valid, and that the type is allowed for the selected mode
if($_GET['mode'] != "content" && $_GET['mode'] != "audio" && $_GET['mode'] != "embed" && $_GET['mode'] != "pictures") {
	die("<b>Fatal error:</b> Invalid mode selected."); }
if(($_GET['mode'] == "audio" && $_GET['type'] == "file") || ($_GET['mode'] == "pictures" && $_GET['type'] == "file")) {
	die("<b>Fatal error:</b> Selected mode does not support type."); }

// Verify that the directory has no invalid characters
// If not, set $dir to the full path
if(strstr($_GET['subdir'], '..') != "") {
        die('<b>Fatal error:</b> Directory name can not have ".." in it.'); }
if($_GET['subdir'] != "") {
	$dir = $wg_phtml . "/" . $_GET['mode'] . "/" . $_GET['subdir'] . "/";
} else {
	$dir = $wg_phtml . "/" . $_GET['mode'] . "/"; }

// Verify that the directory is actually real, or die
if(!file_exists($dir)) {
	die("<b>Fatal error:</b> Could not open directory."); }

// Tell the user what they are about to do and check for certain display conditions
// Also check that our type is valid, or die
echo("<table width=\"100%\" class=\"blend\"><tr><td><b>Create New ");
if($_GET['type'] == "file") {
	echo("File"); }
	elseif($_GET['type'] == "dir") {
	echo("Directory"); } else {
	echo("</b>\n<br>\n");
	die("<b>Fatal error:</b> Unknown type"); }
/* if($_GET['mode'] == "content" || $_GET['mode'] == "embed") { */
	echo(" in </b><i>/"); /* } else {
	echo("</b><i>"); } */
echo($_GET['subdir'] . "</i></tr></td></table>\n");

echo("<table width=\"100%\"><tr><td>");

// Do we have a name? If not, prompt the user for it
if($_GET['next'] == "Create") {
	// Does it already exist?
	if(file_exists($dir . $_GET['newname'])) {
		die("<b>Error:</b> File or directory name already in use! <a href=\"javascript:history.back(1)\">Back</a>\n"); }
	// Check for invalid characters
	if (ereg('[^A-Za-z0-9. -_+()]', $_GET['newname'])) {
		die('<b>Error:</b> Name must be alpha-numeric. <a href="javascript:history.back(1)">Back</a>'); }
	if(strstr($_GET['newname'], '..') != "") {
        	die('<b>Error:</b> Name must not have ".." in it. <a href="javascript:history.back(1)">Back</a>'); }

	// About to make a directory
	if($_GET['type'] == "dir") {
		// make dir
		if(!mkdir(($dir . $_GET['newname']) , $perms)) {
			die("<b>Error:</b> <i>" . $_GET['newname'] . "</i> could not be created!\n<a href=\"javascript:window.close()\">Close</a>\n");
		} else {
			echo("<i>" . $_GET['newname'] . "</i> created!\n<a href=\"javascript:window.close()\">Close</a>\n"); }
		// create title stub
		if(!$handle = fopen($dir . $_GET['newname'] . "/.dir.title", 'w')) {
			die("<b>Error:</b> <i>" . $_GET['newname'] . "/.dir.title </i> could not be created!\n<a href=\"javascript:window.close()\">Close</a>\n"); }
		// write title
		if(fwrite($handle, htmlspecialchars($_GET['title'])) == FALSE) {
			die("<b>Error:</b> <i>" . $_GET['newname'] . "/.dir.title </i> could not be opened for writing!\n<a href=\"javascript:window.close()\">Close</a>\n"); }
		fclose($handle);
	}

	// Else it is a file
	elseif($_GET['type'] == "file") {
		// Check for a valid extension
		$ext = pathinfo($_GET['newname']);
		$ext = $ext['extension'];
		if($ext == "") {
			$ext = "no extension"; }
		switch ($_GET['mode']) {
			case "content":
				// check valid extensions for content mode
				if($ext != "html" && $ext != "htm" && $ext != "php") {
					        die('<b>Error:</b> Invalid file extension (<i>' . $ext . '</i>). Use "html", "htm", or "php". <a href="javascript:history.back(1)">Back</a>'); }
				break;
			case "embed":
				// check valid extensions for embed mode
				if($ext != "swf" && $ext != "mpg" && $ext != "mpeg" && $ext != "wmv" && $ext != "avi" && $ext != "mov") {
					        die('<b>Error:</b> Invalid file extension (<i>' . $ext . '</i>). Use "swf", "mpg", "mpeg", "wmv", "avi", or "mov". <a href="javascript:history.back(1)">Back</a>'); }
				break;
		}
		// create blank file
		if(!touch($dir . $_GET['newname'])) {
			die("<b>Error:</b> <i>" . $_GET['newname'] . "</i> could not be created!\n<a href=\"javascript:window.close()\">Close</a>");
		} else {
			echo("<i>" . $_GET['newname'] . "</i> created!\n"); }
		// create title stub
		if(!$handle = fopen($dir . $_GET['newname'] . ".title", 'w')) {
			die("<b>Error:</b> <i>" . $_GET['newname'] . ".title </i> could not be created!\n<a href=\"javascript:window.close()\">Close</a>");
		}
		// write title
		if(fwrite($handle, htmlspecialchars($_GET['title'])) == FALSE) {
			die("<b>Error:</b> <i>" . $_GET['newname'] . ".title </i> could not be opened for writing!\n<a href=\"javascript:window.close()\">Close</a>"); }
		echo("<a href=\"javascript:window.close()\">Back</a>\n");
		fclose($handle);
		}
} else {
// Show the form...
?>
<form method="GET" action="<?=$_SERVER['PHP_SELF']?>">
	Name: <input type="text" name="newname" value=""><br>
	Title: <input type="text" name="title" value=""><br>
	<input type="hidden" name="mode" value="<?=$_GET['mode']?>">
	<input type="hidden" name="type" value="<?=$_GET['type']?>">
	<input type="hidden" name="subdir" value="<?=$_GET['subdir']?>">
	<input type="submit" name="next" value="Create">
	<a href="javascript:window.close()">Close</a>
</form>
<?
}

?>
</td></tr></table><?

include("footer_light.php");

?>