<?php

/* Westgen Sitewide Templating System
   Copyright (C) 2006 Brian Nez, <thedude at bri1 dot com>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

   $wg_root/_admin/pages_rename.php - Admin frontend Page Rename */

if(!file_exists('../index.php')) {
        die('<b>Fatal error:</b> ThemeX could not find the path to itself. Your
installation may be corrupt.'); }
define("westgen", true);
include("../index.php");

include("thumbnail.inc.php");

include("header_light.php");

// Load needed arguments into variables for later use
$dir = $_GET['dir'];
$file = $_GET['file'];

$rename_failure = "nez";

echo("<table width=\"100%\" class=\"blend\"><tr><td><b>Rename Files and Directories</b></tr></td></table>\n");

echo("<table width=\"100%\"><tr><td>");

// Check if file is real
if(!file_exists($_GET['file'])) {
	die("<b>Error:</b> File or directory not found or permission was denied! <a href=\"javascript:window.close()\">Close</a>\n"); }
// Is this the first time?
if($_GET['areyousure'] != "Yes") {
	$oldtitle = "(no title)";
	if(file_exists($dir . $file . "/.dir.title")) {
		if(file_get_contents($dir . $file . "/.dir.title") != "") {
			$oldtitle = file_get_contents($dir . $file . "/.dir.title"); }
	} elseif(file_exists($dir . $file . ".title")) {
		if(file_get_contents($dir . $file . ".title") != "") {
			$oldtitle = file_get_contents($dir . $file . ".title"); }
	} else {
		$oldtitle = "(no title)";
	}
	?>
<form method="GET" action="<?=$_SERVER['PHP_SELF']?>">
	Name: <input type="text" name="newname" value="<?=basename($_GET['file'])?>" /><br />
	Title: <input type="text" name="newtitle" value="<?=stripslashes($oldtitle)?>" /><br />
	<input type="hidden" name="file" value="<?=$_GET['file']?>" />
	<input type="hidden" name="mode" value="<?=$_GET['mode']?>" />
	<input type="submit" name="areyousure" value="Yes" />
	<a href="javascript:window.close()">Close</a>
</form>
	<?
} else {
// They are sure!
	// Check for invalid characters
	if (ereg('[^A-Za-z0-9. -_+()]', $_GET['newname'])) {
		die('<b>Error:</b> Name must be alpha-numeric. <a href="javascript:history.back(1)">Back</a>'); }
	if(strstr($_GET['newname'], '..') != "") {
		die('<b>Error:</b> Name must not have ".." in it. <a href="javascript:history.back(1)">Back</a>'); }
	$dirname = dirname($_GET['file']) . "/";
	// Is it dir?
	if(is_dir($_GET['file'])) {
		echo("Renaming to <i>" . basename($_GET['newname']) . "</i>... ");
		if(!rename($_GET['file'], $dirname . $_GET['newname'])) {
			echo("<font color=\"red\">Failure</font><br>\n");
		} else {
			echo("OK<br>\n"); }
		echo("Changing title to <i>" . stripslashes(basename($_GET['newtitle'])) . "</i>... ");
		// create title stub
		if(!$handle = fopen($dirname . $_GET['newname'] . "/.dir.title", 'w')) {
			echo("<font color=\"red\">Failure (open error)</font><br>\n"); }
		// write title
		if(fwrite($handle, htmlspecialchars($_GET['newtitle'])) == FALSE) {
			echo("<font color=\"red\">Failure (write error)</font><br>\n"); }
		echo("OK<br>\n");
		fclose($handle);
		echo("<br><a href=\"javascript:window.close()\">Close</a>\n");
	} else {
	// Or it is a file.
		echo("Renaming to <i>" . basename($_GET['newname']) . "</i>... ");
		if(!rename($_GET['file'], $dirname . $_GET['newname'])) {
			echo("<font color=\"red\">Failure</font><br>\n");
		} else {
			echo("OK<br>\n"); }
		echo("Changing title to <i>" . stripslashes(basename($_GET['newtitle'])) . "</i>... ");
		if(file_exists($_GET['file'] . ".title")) {
			if(!rename($_GET['file'] . ".title", $dirname . $_GET['newname'] . ".title")) {
				echo("<font color=\"red\">Failure (rename error)</font><br>\n");
				$rename_failure = "yes";
			}
		}
		if($rename_failure != "yes") {
			// create title stub
			if(!$handle = fopen($dirname . $_GET['newname'] . ".title", 'w')) {
				echo("<font color=\"red\">Failure (open error)</font><br />\n");
			} else {
				// write title
				if(!fwrite($handle, htmlspecialchars($_GET['newtitle']))) {
					echo("<font color=\"red\">Failure (write error)</font><br />\n");
				} else {
					echo("OK<br />\n");
					fclose($handle);
				}
			} // end handle creation
		} // end exist check
		// Rename thumbnail (if we're in pictures mode)
		if($_GET['mode'] == "pictures") {
			// Generate filename
			$thumb_newname = thumbnail_name($dirname . $_GET['newname']);
			$thumb_oldname = thumbnail_name($_GET['file']);
			if(file_exists($thumb_oldname)) {
				echo("Renaming thumbnail... ");
				if(!rename($thumb_oldname, $thumb_newname)) {
					echo("<font color=\"red\">Failure</font><br />\n");
				} else {
					echo("OK<br />\n");
				}
			} // end thumbnail handling
		} // end pictures mode
		echo("<br><a href=\"javascript:window.close()\">Close</a>\n");
	}
}

?>
</td></tr></table><?

include("footer_light.php");

?>