/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.io.sax;

import java.io.StringWriter;
import java.io.Writer;
import junit.framework.TestCase;
import org.x4o.xml.io.sax.ext.ContentWriterXml;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ContentWriterXmlTest
extends TestCase {
    public void testCDATANone() throws Exception {
        StringWriter outputWriter = new StringWriter();
        ContentWriterXml writer = new ContentWriterXml((Writer)outputWriter);
        writer.startDocument();
        writer.characters("foobar");
        writer.endDocument();
        String output = outputWriter.toString();
        ContentWriterXmlTest.assertNotNull((Object)output);
        ContentWriterXmlTest.assertTrue((output.length() > 0 ? 1 : 0) != 0);
        ContentWriterXmlTest.assertTrue((boolean)output.equals("<?xml version=\"1.0\" encoding=\"UTF-8\"?>foobar"));
    }

    public void testCDATANoneTagEscape() throws Exception {
        StringWriter outputWriter = new StringWriter();
        ContentWriterXml writer = new ContentWriterXml((Writer)outputWriter);
        writer.startDocument();
        writer.characters("foobar<test/>");
        writer.endDocument();
        String output = outputWriter.toString();
        ContentWriterXmlTest.assertNotNull((Object)output);
        ContentWriterXmlTest.assertTrue((output.length() > 0 ? 1 : 0) != 0);
        ContentWriterXmlTest.assertTrue((boolean)output.equals("<?xml version=\"1.0\" encoding=\"UTF-8\"?>foobar&lt;test/&gt;"));
    }

    public void testCDATANormal() throws Exception {
        StringWriter outputWriter = new StringWriter();
        ContentWriterXml writer = new ContentWriterXml((Writer)outputWriter);
        writer.startDocument();
        writer.startCDATA();
        writer.characters("foobar");
        writer.endCDATA();
        writer.endDocument();
        String output = outputWriter.toString();
        ContentWriterXmlTest.assertNotNull((Object)output);
        ContentWriterXmlTest.assertTrue((output.length() > 0 ? 1 : 0) != 0);
        ContentWriterXmlTest.assertTrue((boolean)output.equals("<?xml version=\"1.0\" encoding=\"UTF-8\"?><![CDATA[foobar]]>"));
    }

    public void testCDATAEscapeTag() throws Exception {
        StringWriter outputWriter = new StringWriter();
        ContentWriterXml writer = new ContentWriterXml((Writer)outputWriter);
        writer.startDocument();
        writer.startCDATA();
        writer.characters("foobar<test/>");
        writer.endCDATA();
        writer.endDocument();
        String output = outputWriter.toString();
        ContentWriterXmlTest.assertNotNull((Object)output);
        ContentWriterXmlTest.assertTrue((output.length() > 0 ? 1 : 0) != 0);
        ContentWriterXmlTest.assertTrue((boolean)output.equals("<?xml version=\"1.0\" encoding=\"UTF-8\"?><![CDATA[foobar<test/>]]>"));
    }

    public void testCDATAEscapeStart() throws Exception {
        StringWriter outputWriter = new StringWriter();
        ContentWriterXml writer = new ContentWriterXml((Writer)outputWriter);
        writer.startDocument();
        writer.startCDATA();
        writer.characters("<![CDATA[foobar");
        writer.endCDATA();
        writer.endDocument();
        String output = outputWriter.toString();
        ContentWriterXmlTest.assertNotNull((Object)output);
        ContentWriterXmlTest.assertTrue((output.length() > 0 ? 1 : 0) != 0);
        ContentWriterXmlTest.assertTrue((boolean)output.equals("<?xml version=\"1.0\" encoding=\"UTF-8\"?><![CDATA[foobar]]>"));
    }

    public void testCDATAEscapeEnd() throws Exception {
        StringWriter outputWriter = new StringWriter();
        ContentWriterXml writer = new ContentWriterXml((Writer)outputWriter);
        writer.startDocument();
        writer.startCDATA();
        writer.characters("foobar]]>");
        writer.endCDATA();
        writer.endDocument();
        String output = outputWriter.toString();
        ContentWriterXmlTest.assertNotNull((Object)output);
        ContentWriterXmlTest.assertTrue((output.length() > 0 ? 1 : 0) != 0);
        ContentWriterXmlTest.assertTrue((boolean)output.equals("<?xml version=\"1.0\" encoding=\"UTF-8\"?><![CDATA[foobar]]>"));
    }

    public void testCDATAEscapeInvalid() throws Exception {
        StringWriter outputWriter = new StringWriter();
        ContentWriterXml writer = new ContentWriterXml((Writer)outputWriter);
        writer.startDocument();
        writer.startCDATA();
        writer.characters("<![CDATA[tokens like ']]>' are <invalid>]]>");
        writer.endCDATA();
        writer.endDocument();
        String output = outputWriter.toString();
        ContentWriterXmlTest.assertNotNull((Object)output);
        ContentWriterXmlTest.assertTrue((output.length() > 0 ? 1 : 0) != 0);
        ContentWriterXmlTest.assertTrue((boolean)output.equals("<?xml version=\"1.0\" encoding=\"UTF-8\"?><![CDATA[tokens like '' are <invalid>]]>"));
    }

    public void testCDATAEscapeValid() throws Exception {
        StringWriter outputWriter = new StringWriter();
        ContentWriterXml writer = new ContentWriterXml((Writer)outputWriter);
        writer.startDocument();
        writer.startCDATA();
        writer.characters("<![CDATA[tokens like ']]]]><![CDATA[>' are <valid>]]>");
        writer.endCDATA();
        writer.endDocument();
        String output = outputWriter.toString();
        ContentWriterXmlTest.assertNotNull((Object)output);
        ContentWriterXmlTest.assertTrue((output.length() > 0 ? 1 : 0) != 0);
        ContentWriterXmlTest.assertTrue((boolean)output.equals("<?xml version=\"1.0\" encoding=\"UTF-8\"?><![CDATA[tokens like ']]>' are <valid>]]>"));
    }

    public void testCharactersNormal() throws Exception {
        StringWriter outputWriter = new StringWriter();
        ContentWriterXml writer = new ContentWriterXml((Writer)outputWriter);
        writer.startDocument();
        writer.characters("test is foobar!");
        writer.endDocument();
        String output = outputWriter.toString();
        ContentWriterXmlTest.assertNotNull((Object)output);
        ContentWriterXmlTest.assertTrue((output.length() > 0 ? 1 : 0) != 0);
        ContentWriterXmlTest.assertTrue((boolean)output.equals("<?xml version=\"1.0\" encoding=\"UTF-8\"?>test is foobar!"));
    }

    public void testCharactersEscape() throws Exception {
        StringWriter outputWriter = new StringWriter();
        ContentWriterXml writer = new ContentWriterXml((Writer)outputWriter);
        writer.startDocument();
        writer.characters("<test/> & 'foobar' is \"quoted\"!");
        writer.endDocument();
        String output = outputWriter.toString();
        ContentWriterXmlTest.assertNotNull((Object)output);
        ContentWriterXmlTest.assertTrue((output.length() > 0 ? 1 : 0) != 0);
        ContentWriterXmlTest.assertTrue((boolean)output.equals("<?xml version=\"1.0\" encoding=\"UTF-8\"?>&lt;test/&gt; &amp; &apos;foobar&apos; is &quote;quoted&quote;!"));
    }

    public void testAttributeNormal() throws Exception {
        StringWriter outputWriter = new StringWriter();
        ContentWriterXml writer = new ContentWriterXml((Writer)outputWriter);
        writer.startDocument();
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "attr", "", "", "foobar");
        writer.startElementEnd("", "test", "", (Attributes)atts);
        writer.endDocument();
        String output = outputWriter.toString();
        ContentWriterXmlTest.assertNotNull((Object)output);
        ContentWriterXmlTest.assertTrue((output.length() > 0 ? 1 : 0) != 0);
        ContentWriterXmlTest.assertTrue((boolean)output.equals("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<test attr=\"foobar\"/>"));
    }

    public void testAttributeEscape() throws Exception {
        StringWriter outputWriter = new StringWriter();
        ContentWriterXml writer = new ContentWriterXml((Writer)outputWriter);
        writer.startDocument();
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "attr", "", "", "<test/> & 'foobar' is \"quoted\"!");
        writer.startElementEnd("", "test", "", (Attributes)atts);
        writer.endDocument();
        String output = outputWriter.toString();
        ContentWriterXmlTest.assertNotNull((Object)output);
        ContentWriterXmlTest.assertTrue((output.length() > 0 ? 1 : 0) != 0);
        ContentWriterXmlTest.assertTrue((boolean)output.equals("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<test attr=\"&lt;test/&gt; &amp; &apos;foobar&apos; is &quote;quoted&quote;!\"/>"));
    }

    public void testCommentNormal() throws Exception {
        StringWriter outputWriter = new StringWriter();
        ContentWriterXml writer = new ContentWriterXml((Writer)outputWriter);
        writer.startDocument();
        writer.comment("foobar");
        writer.endDocument();
        String output = outputWriter.toString();
        ContentWriterXmlTest.assertNotNull((Object)output);
        ContentWriterXmlTest.assertTrue((output.length() > 0 ? 1 : 0) != 0);
        ContentWriterXmlTest.assertTrue((boolean)output.equals("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!-- foobar -->"));
    }

    public void testCommentEscape() throws Exception {
        StringWriter outputWriter = new StringWriter();
        ContentWriterXml writer = new ContentWriterXml((Writer)outputWriter);
        writer.startDocument();
        writer.comment("<!--foobar-->");
        writer.endDocument();
        String output = outputWriter.toString();
        ContentWriterXmlTest.assertNotNull((Object)output);
        ContentWriterXmlTest.assertTrue((output.length() > 0 ? 1 : 0) != 0);
        ContentWriterXmlTest.assertTrue((boolean)output.equals("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!-- foobar -->"));
    }

    public void testXmlInvalid() throws Exception {
        StringWriter outputWriter = new StringWriter();
        ContentWriterXml writer = new ContentWriterXml((Writer)outputWriter);
        AttributesImpl atts = new AttributesImpl();
        Exception e = null;
        try {
            writer.startDocument();
            writer.startElement("", "test", "", (Attributes)atts);
            writer.startElement("", "foobar", "", (Attributes)atts);
            writer.endElement("", "test", "");
            writer.endDocument();
        }
        catch (Exception catchE) {
            e = catchE;
        }
        ContentWriterXmlTest.assertNotNull((Object)e);
        ContentWriterXmlTest.assertEquals(SAXException.class, e.getClass());
        ContentWriterXmlTest.assertTrue((boolean)e.getMessage().contains("tag"));
        ContentWriterXmlTest.assertTrue((boolean)e.getMessage().contains("foobar"));
    }

    public void testXmlInvalidEnd() throws Exception {
        StringWriter outputWriter = new StringWriter();
        ContentWriterXml writer = new ContentWriterXml((Writer)outputWriter);
        AttributesImpl atts = new AttributesImpl();
        Exception e = null;
        try {
            writer.startDocument();
            writer.startElement("", "test", "", (Attributes)atts);
            writer.startElement("", "foobar", "", (Attributes)atts);
            writer.endDocument();
        }
        catch (Exception catchE) {
            e = catchE;
        }
        ContentWriterXmlTest.assertNotNull((Object)e);
        ContentWriterXmlTest.assertEquals(SAXException.class, e.getClass());
        ContentWriterXmlTest.assertTrue((boolean)e.getMessage().contains("Invalid"));
        ContentWriterXmlTest.assertTrue((boolean)e.getMessage().contains("2"));
        ContentWriterXmlTest.assertTrue((boolean)e.getMessage().contains("open"));
    }

    public void testProcessingInstruction() throws Exception {
        StringWriter outputWriter = new StringWriter();
        ContentWriterXml writer = new ContentWriterXml((Writer)outputWriter);
        AttributesImpl atts = new AttributesImpl();
        Exception e = null;
        try {
            writer.startDocument();
            writer.processingInstruction("target", "data");
            writer.startElement("", "test", "", (Attributes)atts);
            writer.endElement("", "test", "");
            writer.endDocument();
        }
        catch (Exception catchE) {
            e = catchE;
        }
        String output = outputWriter.toString();
        ContentWriterXmlTest.assertNull((Object)e);
        ContentWriterXmlTest.assertNotNull((Object)output);
        ContentWriterXmlTest.assertTrue((output.length() > 0 ? 1 : 0) != 0);
        ContentWriterXmlTest.assertTrue((boolean)output.equals("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<?target data?>\n<test/>"));
    }

    public void testProcessingInstructionInline() throws Exception {
        StringWriter outputWriter = new StringWriter();
        ContentWriterXml writer = new ContentWriterXml((Writer)outputWriter);
        AttributesImpl atts = new AttributesImpl();
        Exception e = null;
        try {
            writer.startDocument();
            writer.processingInstruction("target", "data");
            writer.startElement("", "test", "", (Attributes)atts);
            writer.processingInstruction("target-doc", "data-doc");
            writer.endElement("", "test", "");
            writer.endDocument();
        }
        catch (Exception catchE) {
            e = catchE;
        }
        String output = outputWriter.toString();
        ContentWriterXmlTest.assertNull((Object)e);
        ContentWriterXmlTest.assertNotNull((Object)output);
        ContentWriterXmlTest.assertTrue((output.length() > 0 ? 1 : 0) != 0);
        ContentWriterXmlTest.assertTrue((boolean)output.equals("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<?target data?>\n<test>\n\t<?target-doc data-doc?>\n</test>"));
    }

    public void testProcessingInstructionTargetXmlPrefix() throws Exception {
        StringWriter outputWriter = new StringWriter();
        ContentWriterXml writer = new ContentWriterXml((Writer)outputWriter);
        Exception e = null;
        try {
            writer.startDocument();
            writer.processingInstruction("xmlPrefix", "isInvalid");
        }
        catch (Exception catchE) {
            e = catchE;
        }
        ContentWriterXmlTest.assertNotNull((Object)e);
        ContentWriterXmlTest.assertEquals(SAXException.class, e.getClass());
        ContentWriterXmlTest.assertTrue((boolean)e.getMessage().contains("instruction"));
        ContentWriterXmlTest.assertTrue((boolean)e.getMessage().contains("start with xml"));
    }

    public void testProcessingInstructionTargetNoneNameChar() throws Exception {
        StringWriter outputWriter = new StringWriter();
        ContentWriterXml writer = new ContentWriterXml((Writer)outputWriter);
        Exception e = null;
        try {
            writer.startDocument();
            writer.processingInstruction("4Prefix", "isInvalid");
        }
        catch (Exception catchE) {
            e = catchE;
        }
        ContentWriterXmlTest.assertNotNull((Object)e);
        ContentWriterXmlTest.assertEquals(SAXException.class, e.getClass());
        ContentWriterXmlTest.assertTrue((boolean)e.getMessage().contains("instruction"));
        ContentWriterXmlTest.assertTrue((boolean)e.getMessage().contains("invalid name"));
        ContentWriterXmlTest.assertTrue((boolean)e.getMessage().contains("4Prefix"));
    }

    public void testProcessingInstructionDataNoneChar() throws Exception {
        StringWriter outputWriter = new StringWriter();
        ContentWriterXml writer = new ContentWriterXml((Writer)outputWriter);
        Exception e = null;
        try {
            writer.startDocument();
            writer.processingInstruction("target", "isInvalidChar=55296");
        }
        catch (Exception catchE) {
            e = catchE;
        }
        ContentWriterXmlTest.assertNotNull((Object)e);
        ContentWriterXmlTest.assertEquals(SAXException.class, e.getClass());
        ContentWriterXmlTest.assertTrue((boolean)e.getMessage().contains("instruction"));
        ContentWriterXmlTest.assertTrue((boolean)e.getMessage().contains("invalid char"));
        ContentWriterXmlTest.assertTrue((boolean)e.getMessage().contains("isInvalidChar=55296"));
    }

    public void testAttributeValueLongData() throws Exception {
        StringWriter outputWriter = new StringWriter();
        ContentWriterXml writer = new ContentWriterXml((Writer)outputWriter);
        AttributesImpl atts = new AttributesImpl();
        String data = "_FOR_FOO_BAR";
        String dataValue = "LOOP";
        for (int i = 0; i < 15; ++i) {
            dataValue = dataValue + data;
            atts.addAttribute("", "attr" + i, "", "", dataValue);
        }
        writer.startDocument();
        writer.startElement("", "test", "", (Attributes)atts);
        writer.startElement("", "testNode", "", (Attributes)new AttributesImpl());
        writer.endElement("", "testNode", "");
        writer.endElement("", "test", "");
        writer.endDocument();
        String output = outputWriter.toString();
        ContentWriterXmlTest.assertNotNull((Object)output);
        ContentWriterXmlTest.assertTrue((output.split("\n").length == 13 ? 1 : 0) != 0);
    }
}

