/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.test.swixml.conv;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.Locale;
import org.x4o.xml.conv.AbstractStringObjectConverter;
import org.x4o.xml.conv.ObjectConverter;
import org.x4o.xml.conv.ObjectConverterException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutConverter
extends AbstractStringObjectConverter {
    private static final long serialVersionUID = 6729812931433525103L;

    public Class<?> getObjectClassTo() {
        return LayoutManager.class;
    }

    public String convertStringBack(Object obj, Locale locale) throws ObjectConverterException {
        return ((LayoutManager)obj).toString();
    }

    public Object convertStringTo(String str, Locale locale) throws ObjectConverterException {
        try {
            if ("borderlayout".equals(str)) {
                return new BorderLayout();
            }
            if (str.startsWith("FlowLayout")) {
                if (str.contains("RIGHT")) {
                    return new FlowLayout(2);
                }
                if (str.contains("LEFT")) {
                    return new FlowLayout(0);
                }
                if (str.contains("CENTER")) {
                    return new FlowLayout(1);
                }
                if (str.contains("LEADING")) {
                    return new FlowLayout(3);
                }
                if (str.contains("TRAILING")) {
                    return new FlowLayout(4);
                }
                return new FlowLayout();
            }
            if (str.startsWith("GridLayout")) {
                int indexStart = str.indexOf(40);
                int indexMid = str.indexOf(44);
                int indexEnd = str.indexOf(41);
                if (indexStart > 0 && indexMid > 0 && indexEnd > 0) {
                    Integer rows = new Integer(str.substring(indexStart + 1, indexMid));
                    Integer cols = new Integer(str.substring(indexMid + 1, indexEnd));
                    return new GridLayout(rows, cols);
                }
                throw new ObjectConverterException((ObjectConverter)this, "Could not parse arguments: " + str);
            }
            if (str.startsWith("GridBagLayout")) {
                return new GridBagLayout();
            }
            throw new ObjectConverterException((ObjectConverter)this, "Unknow layout requested: " + str);
        }
        catch (Exception e) {
            throw new ObjectConverterException((ObjectConverter)this, e.getMessage(), e);
        }
    }

    public ObjectConverter clone() throws CloneNotSupportedException {
        LayoutConverter result = new LayoutConverter();
        result.converters = this.cloneConverters();
        return result;
    }
}

