/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.x4o.xml.X4ODriver;
import org.x4o.xml.lang.DefaultX4OLanguage;
import org.x4o.xml.lang.DefaultX4OLanguageConfiguration;
import org.x4o.xml.lang.X4OLanguage;
import org.x4o.xml.lang.X4OLanguageClassLoader;
import org.x4o.xml.lang.X4OLanguageConfiguration;
import org.x4o.xml.lang.phase.DefaultX4OPhaseManager;
import org.x4o.xml.lang.phase.X4OPhaseLanguageInit;
import org.x4o.xml.lang.phase.X4OPhaseLanguageRead;
import org.x4o.xml.lang.phase.X4OPhaseLanguageWrite;
import org.x4o.xml.lang.phase.X4OPhaseManager;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class X4ODriverManager {
    public static final String X4O_DRIVERS_RESOURCE = "META-INF/x4o-drivers.xml";
    private static final X4ODriverManager instance = new X4ODriverManager();
    private Logger logger = Logger.getLogger(X4ODriverManager.class.getName());
    private volatile boolean reloadDrivers = true;
    private Map<String, String> classdrivers = new HashMap<String, String>(10);
    private Map<String, String> defaultDrivers = new HashMap<String, String>(10);
    private Map<String, X4ODriver<?>> drivers = new HashMap(10);

    private X4ODriverManager() {
    }

    protected static String getDefaultLanguageVersion(String[] languages) {
        if (languages == null || languages.length == 0) {
            return "1.0";
        }
        String languageVersion = languages[languages.length - 1];
        return languageVersion;
    }

    protected static X4OPhaseManager getDefaultBuildPhaseManager() {
        DefaultX4OPhaseManager manager = new DefaultX4OPhaseManager();
        new X4OPhaseLanguageInit().createPhases(manager);
        new X4OPhaseLanguageRead().createPhases(manager);
        new X4OPhaseLanguageWrite().createPhases(manager);
        return manager;
    }

    protected static X4OLanguage getDefaultBuildLanguage(X4ODriver<?> driver, String version) {
        if (version == null) {
            version = driver.getLanguageVersionDefault();
        }
        return new DefaultX4OLanguage(driver.buildLanguageConfiguration(), driver.buildPhaseManager(), driver.getLanguageName(), version);
    }

    protected static X4OLanguageConfiguration getDefaultBuildLanguageConfiguration() {
        DefaultX4OLanguageConfiguration config = new DefaultX4OLanguageConfiguration();
        config.fillDefaults();
        X4OLanguageConfiguration result = config.createProxy();
        return result;
    }

    public static void registerX4ODriver(X4ODriver<?> driver) {
        if (driver == null) {
            throw new NullPointerException("Can't register null driver.");
        }
        if (driver.getLanguageName() == null) {
            throw new NullPointerException("Error in driver impl languageName is null in: " + driver.getClass());
        }
        if (driver.getLanguageName().length() == 0) {
            throw new IllegalArgumentException("Error in driver impl languageName is empty in: " + driver.getClass());
        }
        if (driver.getLanguageVersions() == null) {
            throw new NullPointerException("Error in driver impl languageVersions is null in: " + driver.getClass());
        }
        if (driver.getLanguageVersions().length == 0) {
            throw new IllegalArgumentException("Error in driver impl languageVersions is empty in: " + driver.getClass());
        }
        X4ODriverManager.instance.drivers.put(driver.getLanguageName(), driver);
    }

    public static void deregisterX4ODriver(X4ODriver<?> driver) {
        if (driver == null) {
            throw new NullPointerException("Can't deregister null driver.");
        }
        if (driver.getLanguageName() == null) {
            throw new NullPointerException("Error in driver impl languageName is null in: " + driver.getClass());
        }
        X4ODriverManager.instance.drivers.remove(driver.getLanguageName());
    }

    public static X4ODriver<?> getX4ODriver(String language) {
        if (language == null) {
            throw new NullPointerException("Can't provider driver for null language.");
        }
        if (language.length() == 0) {
            throw new IllegalArgumentException("Can't provider driver for empty language.");
        }
        if (X4ODriverManager.instance.drivers.containsKey(language)) {
            return X4ODriverManager.instance.drivers.get(language);
        }
        instance.lazyInit();
        X4ODriver<?> result = instance.createX4ODriver(language);
        if (result == null) {
            throw new IllegalArgumentException("Can't find driver for language: " + language);
        }
        return result;
    }

    public static List<String> getX4OLanguages() {
        instance.lazyInit();
        ArrayList<String> result = new ArrayList<String>(10);
        result.addAll(X4ODriverManager.instance.classdrivers.keySet());
        result.addAll(X4ODriverManager.instance.defaultDrivers.keySet());
        Collections.sort(result);
        return result;
    }

    private void lazyInit() {
        if (!this.reloadDrivers) {
            return;
        }
        instance.loadLanguageDrivers();
        this.reloadDrivers = false;
    }

    private X4ODriver<?> createX4ODriver(String language) {
        String driverClassName = null;
        if (this.classdrivers.containsKey(language)) {
            driverClassName = this.classdrivers.get(language);
        } else if (this.defaultDrivers.containsKey(language)) {
            driverClassName = this.defaultDrivers.get(language);
        }
        if (driverClassName == null) {
            return null;
        }
        try {
            Class<?> driverClass = X4OLanguageClassLoader.loadClass(driverClassName);
            X4ODriver driver = (X4ODriver)driverClass.newInstance();
            X4ODriverManager.registerX4ODriver(driver);
            return driver;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private void loadLanguageDrivers() {
        this.logger.finer("loading x4o drivers from: META-INF/x4o-drivers.xml");
        try {
            URL u;
            Enumeration<URL> e = Thread.currentThread().getContextClassLoader().getResources(X4O_DRIVERS_RESOURCE);
            while (e.hasMoreElements()) {
                u = e.nextElement();
                this.loadDriversXml(u.openStream());
            }
            e = Thread.currentThread().getContextClassLoader().getResources("/META-INF/x4o-drivers.xml");
            while (e.hasMoreElements()) {
                u = e.nextElement();
                this.loadDriversXml(u.openStream());
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDriversXml(InputStream in) throws IOException, SAXException {
        if (in == null) {
            throw new NullPointerException("Can't parse null input stream");
        }
        DriversTagHandler xth = new DriversTagHandler();
        XMLReader saxParser = XMLReaderFactory.createXMLReader();
        saxParser.setContentHandler(xth);
        saxParser.setProperty("http://xml.org/sax/properties/lexical-handler", xth);
        saxParser.setProperty("http://xml.org/sax/properties/declaration-handler", xth);
        try {
            saxParser.parse(new InputSource(in));
        }
        finally {
            in.close();
        }
    }

    private class DriversTagHandler
    extends DefaultHandler2 {
        private DriversTagHandler() {
        }

        public void startElement(String namespaceUri, String tag, String qName, Attributes attr) throws SAXException {
            if ("drivers".equals(tag)) {
                String version = attr.getValue("version");
                X4ODriverManager.this.logger.finest("Version attribute: " + version);
            } else if ("driver".equals(tag)) {
                String language = attr.getValue("language");
                String className = attr.getValue("className");
                X4ODriverManager.this.logger.finest("Driver className: " + className + " for language: " + language);
                if (!X4ODriverManager.this.classdrivers.containsKey(className)) {
                    X4ODriverManager.this.classdrivers.put(language, className);
                }
            } else if ("defaultDriver".equals(tag)) {
                String language = attr.getValue("language");
                X4ODriverManager.this.logger.finest("DefaultDriver language: " + language);
                if (!X4ODriverManager.this.defaultDrivers.containsKey(language)) {
                    X4ODriverManager.this.defaultDrivers.put(language, language);
                }
            }
        }
    }
}

