/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.eld.xsd;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.x4o.xml.element.ElementAttributeHandler;
import org.x4o.xml.element.ElementBindingHandler;
import org.x4o.xml.element.ElementClass;
import org.x4o.xml.element.ElementClassAttribute;
import org.x4o.xml.element.ElementInterface;
import org.x4o.xml.element.ElementMetaBase;
import org.x4o.xml.element.ElementNamespaceContext;
import org.x4o.xml.io.sax.ext.ContentWriterXsd;
import org.x4o.xml.lang.X4OLanguage;
import org.x4o.xml.lang.X4OLanguageModule;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class EldXsdXmlWriter {
    public static final String SCHEMA_URI = "http://www.w3.org/2001/XMLSchema";
    protected X4OLanguage language = null;
    protected ContentWriterXsd xmlWriter = null;
    protected String writeNamespace = null;
    protected Map<String, String> namespaces = null;
    private static final String COMMENT_SEPERATOR = " ==================================================================== ";
    private static final String COMMENT_TEXT = "=====";

    public EldXsdXmlWriter(ContentWriterXsd xmlWriter, X4OLanguage language) {
        this.xmlWriter = xmlWriter;
        this.language = language;
        this.namespaces = new HashMap<String, String>(10);
    }

    private void startNamespace(String uri, String prefixNamespace) {
        String prefix = this.namespaces.get(uri);
        if (prefix != null) {
            return;
        }
        if (uri.equals(this.writeNamespace)) {
            this.namespaces.put(uri, "this");
            return;
        }
        if (prefixNamespace != null) {
            this.namespaces.put(uri, prefixNamespace);
            return;
        }
        StringBuilder buf = new StringBuilder(20);
        for (char c : uri.toLowerCase().toCharArray()) {
            if (Character.isLetter(c)) {
                buf.append(c);
            }
            if (!Character.isDigit(c)) continue;
            buf.append(c);
        }
        prefix = buf.toString();
        if (prefix.startsWith("http")) {
            prefix = prefix.substring(4);
        }
        if (prefix.startsWith("uri")) {
            prefix = prefix.substring(3);
        }
        if (prefix.startsWith("url")) {
            prefix = prefix.substring(3);
        }
        this.namespaces.put(uri, prefix);
    }

    public void startNamespaces(String namespaceUri) {
        this.writeNamespace = namespaceUri;
        this.namespaces.clear();
        for (X4OLanguageModule modContext : this.language.getLanguageModules()) {
            for (ElementNamespaceContext nsContext : modContext.getElementNamespaceContexts()) {
                for (ElementClass ec : nsContext.getElementClasses()) {
                    Class<?> objectClass = null;
                    if (ec.getObjectClass() == null) continue;
                    objectClass = ec.getObjectClass();
                    for (X4OLanguageModule mod : this.language.getLanguageModules()) {
                        for (ElementNamespaceContext ns : mod.getElementNamespaceContexts()) {
                            for (ElementClass checkClass : ns.getElementClasses()) {
                                Class<?> checkObjectClass;
                                List<ElementBindingHandler> b;
                                if (checkClass.getObjectClass() == null || (b = this.language.findElementBindingHandlers(objectClass, checkObjectClass = checkClass.getObjectClass())).isEmpty()) continue;
                                this.startNamespace(ns.getUri(), ns.getSchemaPrefix());
                            }
                        }
                    }
                    for (ElementInterface ei : this.language.findElementInterfaces(objectClass)) {
                        List<String> eiTags = ei.getElementParents(namespaceUri);
                        if (eiTags == null) continue;
                        this.startNamespace(nsContext.getUri(), nsContext.getSchemaPrefix());
                    }
                }
            }
        }
    }

    public void startSchema(ElementNamespaceContext ns) throws SAXException {
        this.xmlWriter.startDocument();
        this.xmlWriter.ignorableWhitespace('\n');
        this.xmlWriter.comment(COMMENT_SEPERATOR);
        this.xmlWriter.ignorableWhitespace('\n');
        String desc = "Automatic generated schema for language: " + this.language.getLanguageName();
        int space = COMMENT_SEPERATOR.length() - desc.length() - 2 * COMMENT_TEXT.length() - 4;
        StringBuffer b = new StringBuffer(COMMENT_SEPERATOR.length());
        b.append(" ");
        b.append(COMMENT_TEXT);
        b.append("  ");
        b.append(desc);
        for (int i = 0; i < space; ++i) {
            b.append(' ');
        }
        b.append(COMMENT_TEXT);
        b.append(" ");
        this.xmlWriter.comment(b.toString());
        this.xmlWriter.ignorableWhitespace('\n');
        this.xmlWriter.comment(COMMENT_SEPERATOR);
        this.xmlWriter.ignorableWhitespace('\n');
        X4OLanguageModule module = null;
        for (X4OLanguageModule elm : this.language.getLanguageModules()) {
            ElementNamespaceContext s = elm.getElementNamespaceContext(ns.getUri());
            if (s == null) continue;
            module = elm;
            break;
        }
        b = new StringBuffer(COMMENT_SEPERATOR.length());
        b.append("\n\tID:\t\t");
        b.append(module.getId());
        b.append("\n\tProviderName:\t");
        b.append(module.getProviderName());
        b.append("\n\tProviderHost:\t");
        b.append(module.getProviderHost());
        b.append("\n\tNamespaces:\t\t");
        b.append(module.getElementNamespaceContexts().size());
        b.append("\n\tUri:\t\t\t");
        b.append(ns.getUri());
        b.append("\n\tUri schema:\t");
        b.append(ns.getSchemaUri());
        b.append("\n\tCreated on:\t\t");
        b.append(new Date());
        b.append("\n");
        this.xmlWriter.comment(b.toString());
        this.xmlWriter.startPrefixMapping("", SCHEMA_URI);
        for (String uri : this.namespaces.keySet()) {
            String prefix = this.namespaces.get(uri);
            this.xmlWriter.startPrefixMapping(prefix, uri);
        }
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "version", "", "", "1.0");
        atts.addAttribute("", "elementFormDefault", "", "", "qualified");
        atts.addAttribute("", "attributeFormDefault", "", "", "unqualified");
        atts.addAttribute("", "targetNamespace", "", "", ns.getUri());
        this.xmlWriter.startElement(SCHEMA_URI, "schema", "", atts);
        for (String uri : this.namespaces.keySet()) {
            if (ns.getUri().equals(uri)) continue;
            ElementNamespaceContext nsContext = this.language.findElementNamespaceContext(uri);
            atts = new AttributesImpl();
            atts.addAttribute("", "namespace", "", "", nsContext.getUri());
            atts.addAttribute("", "schemaLocation", "", "", nsContext.getSchemaResource());
            this.xmlWriter.startElement(SCHEMA_URI, "import", "", atts);
            this.xmlWriter.endElement(SCHEMA_URI, "import", "");
        }
    }

    public void endSchema() throws SAXException {
        this.xmlWriter.endElement(SCHEMA_URI, "schema", "");
        this.xmlWriter.ignorableWhitespace('\n');
        this.xmlWriter.endDocument();
    }

    public void writeElementClass(ElementClass ec, ElementNamespaceContext nsWrite) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        if (nsWrite.getLanguageRoot() != null && nsWrite.getLanguageRoot().booleanValue()) {
            atts.addAttribute("", "name", "", "", ec.getId());
            this.xmlWriter.startElement(SCHEMA_URI, "element", "", atts);
            atts = new AttributesImpl();
            this.xmlWriter.startElement(SCHEMA_URI, "complexType", "", atts);
        } else {
            atts.addAttribute("", "name", "", "", ec.getId() + "Type");
            this.xmlWriter.startElement(SCHEMA_URI, "complexType", "", atts);
        }
        if (ec.getSchemaContentBase() != null) {
            atts = new AttributesImpl();
            if (ec.getSchemaContentComplex() != null && ec.getSchemaContentComplex().booleanValue()) {
                if (ec.getSchemaContentMixed() != null && ec.getSchemaContentMixed().booleanValue()) {
                    atts.addAttribute("", "mixed", "", "", "true");
                }
                this.xmlWriter.startElement(SCHEMA_URI, "complexContent", "", atts);
            } else {
                this.xmlWriter.startElement(SCHEMA_URI, "simpleContent", "", atts);
            }
            atts = new AttributesImpl();
            atts.addAttribute("", "base", "", "", ec.getSchemaContentBase());
            this.xmlWriter.startElement(SCHEMA_URI, "extension", "", atts);
        }
        if (ec.getSchemaContentBase() == null) {
            atts = new AttributesImpl();
            atts.addAttribute("", "minOccurs", "", "", "0");
            atts.addAttribute("", "maxOccurs", "", "", "unbounded");
            this.xmlWriter.startElement(SCHEMA_URI, "choice", "", atts);
            for (X4OLanguageModule mod : this.language.getLanguageModules()) {
                for (ElementNamespaceContext ns : mod.getElementNamespaceContexts()) {
                    this.writeElementClassNamespaces(ec, nsWrite, ns);
                }
            }
            this.xmlWriter.endElement(SCHEMA_URI, "choice", "");
        }
        ArrayList<String> attrNames = new ArrayList<String>(30);
        for (ElementClassAttribute eca : ec.getElementClassAttributes()) {
            attrNames.add(eca.getId());
            atts = new AttributesImpl();
            atts.addAttribute("", "name", "", "", eca.getId());
            atts.addAttribute("", "type", "", "", "string");
            if (eca.getRequired() != null && eca.getRequired().booleanValue()) {
                atts.addAttribute("", "use", "", "", "required");
            }
            this.writeElementAttribute(eca, atts);
            for (String alias : eca.getAttributeAliases()) {
                attrNames.add(alias);
                atts = new AttributesImpl();
                atts.addAttribute("", "name", "", "", alias);
                atts.addAttribute("", "type", "", "", "string");
                this.writeElementAttribute(null, atts);
            }
        }
        for (X4OLanguageModule mod : this.language.getLanguageModules()) {
            for (ElementAttributeHandler eah : mod.getElementAttributeHandlers()) {
                attrNames.add(eah.getAttributeName());
                atts = new AttributesImpl();
                atts.addAttribute("", "name", "", "", eah.getAttributeName());
                atts.addAttribute("", "type", "", "", "string");
                this.writeElementAttribute(eah, atts);
            }
        }
        if (ec.getAutoAttributes() != null && !ec.getAutoAttributes().booleanValue()) {
            this.xmlWriter.ignorableWhitespace(' ');
        } else if (ec.getObjectClass() != null) {
            for (Method m : ec.getObjectClass().getMethods()) {
                if (!m.getName().startsWith("set")) continue;
                String n = m.getName().substring(3);
                if (m.getParameterTypes().length == 0 || n.length() < 2 || attrNames.contains(n = n.substring(0, 1).toLowerCase() + n.substring(1, n.length()))) continue;
                atts = new AttributesImpl();
                atts.addAttribute("", "name", "", "", n);
                Class<Comparable<Boolean>> type = m.getParameterTypes()[0];
                if (type.equals(Object.class)) {
                    atts.addAttribute("", "type", "", "", "string");
                } else if (type.isAssignableFrom(Boolean.class) | type.isAssignableFrom(Boolean.TYPE)) {
                    atts.addAttribute("", "type", "", "", "boolean");
                } else if (type.isAssignableFrom(Integer.class) | type.isAssignableFrom(Integer.TYPE)) {
                    atts.addAttribute("", "type", "", "", "integer");
                } else if (type.isAssignableFrom(Long.class) | type.isAssignableFrom(Long.TYPE)) {
                    atts.addAttribute("", "type", "", "", "long");
                } else if (type.isAssignableFrom(Float.class) | type.isAssignableFrom(Float.TYPE)) {
                    atts.addAttribute("", "type", "", "", "float");
                } else if (type.isAssignableFrom(Double.class) | type.isAssignableFrom(Double.TYPE)) {
                    atts.addAttribute("", "type", "", "", "double");
                } else {
                    atts.addAttribute("", "type", "", "", "string");
                }
                this.xmlWriter.startElement(SCHEMA_URI, "attribute", "", atts);
                this.xmlWriter.endElement(SCHEMA_URI, "attribute", "");
            }
        } else {
            atts = new AttributesImpl();
            this.xmlWriter.startElement(SCHEMA_URI, "anyAttribute", "", atts);
            this.xmlWriter.endElement(SCHEMA_URI, "anyAttribute", "");
        }
        if (ec.getSchemaContentBase() != null) {
            this.xmlWriter.endElement(SCHEMA_URI, "extension", "");
            if (ec.getSchemaContentComplex() != null && ec.getSchemaContentComplex().booleanValue()) {
                this.xmlWriter.endElement(SCHEMA_URI, "complexContent", "");
            } else {
                this.xmlWriter.endElement(SCHEMA_URI, "simpleContent", "");
            }
        }
        this.xmlWriter.endElement(SCHEMA_URI, "complexType", "");
        if (nsWrite.getLanguageRoot() != null && nsWrite.getLanguageRoot().booleanValue()) {
            this.xmlWriter.endElement(SCHEMA_URI, "element", "");
        }
    }

    private void writeElementClassNamespaces(ElementClass ecWrite, ElementNamespaceContext nsWrite, ElementNamespaceContext ns) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        ArrayList<String> refElements = new ArrayList<String>(20);
        for (ElementClass checkClass : ns.getElementClasses()) {
            Class<?> checkObjectClass;
            Class<?> objectClass;
            List<ElementBindingHandler> b;
            List<String> parents = checkClass.getElementParents(nsWrite.getUri());
            if (parents != null && parents.contains(ecWrite.getId())) {
                refElements.add(checkClass.getId());
                continue;
            }
            if (checkClass.getObjectClass() == null) continue;
            for (ElementInterface ei : this.language.findElementInterfaces(checkClass.getObjectClass())) {
                parents = ei.getElementParents(nsWrite.getUri());
                if (parents == null || !parents.contains(ecWrite.getId())) continue;
                refElements.add(checkClass.getId());
                break;
            }
            if (ecWrite.getObjectClass() == null || (b = this.language.findElementBindingHandlers(objectClass = ecWrite.getObjectClass(), checkObjectClass = checkClass.getObjectClass())).isEmpty()) continue;
            refElements.add(checkClass.getId());
        }
        if (!refElements.isEmpty()) {
            HashSet<String> s = new HashSet<String>(refElements.size());
            s.addAll(refElements);
            ArrayList<String> r = new ArrayList<String>(s.size());
            r.addAll(s);
            Collections.sort(r);
            String prefix = this.namespaces.get(ns.getUri());
            for (String refElement : r) {
                atts = new AttributesImpl();
                if (nsWrite.getLanguageRoot() != null && nsWrite.getLanguageRoot().booleanValue()) {
                    atts.addAttribute("", "ref", "", "", prefix + ":" + refElement);
                } else if (!nsWrite.getUri().equals(ns.getUri())) {
                    atts.addAttribute("", "ref", "", "", prefix + ":" + refElement);
                } else {
                    atts.addAttribute("", "name", "", "", refElement);
                    atts.addAttribute("", "type", "", "", prefix + ":" + refElement + "Type");
                }
                this.xmlWriter.startElement(SCHEMA_URI, "element", "", atts);
                this.xmlWriter.endElement(SCHEMA_URI, "element", "");
            }
        }
    }

    public void writeElement(ElementClass ec, ElementNamespaceContext nsWrite) throws SAXException {
        if (nsWrite.getLanguageRoot() != null && nsWrite.getLanguageRoot().booleanValue()) {
            return;
        }
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "name", "", "", ec.getId());
        atts.addAttribute("", "type", "", "", "this:" + ec.getId() + "Type");
        this.xmlWriter.startElement(SCHEMA_URI, "element", "", atts);
        this.writeElementMetaBase(ec);
        this.xmlWriter.endElement(SCHEMA_URI, "element", "");
    }

    private void writeElementAttribute(ElementMetaBase base, AttributesImpl atts) throws SAXException {
        this.xmlWriter.startElement(SCHEMA_URI, "attribute", "", atts);
        this.writeElementMetaBase(base);
        this.xmlWriter.endElement(SCHEMA_URI, "attribute", "");
    }

    private void writeElementMetaBase(ElementMetaBase base) throws SAXException {
        if (base == null) {
            return;
        }
        if (base.getDescription() == null) {
            return;
        }
        AttributesImpl atts = new AttributesImpl();
        this.xmlWriter.startElement(SCHEMA_URI, "annotation", "", atts);
        atts = new AttributesImpl();
        atts.addAttribute("", "xml:lang", "", "", "en");
        this.xmlWriter.startElement(SCHEMA_URI, "documentation", "", atts);
        this.xmlWriter.characters(base.getDescription());
        this.xmlWriter.endElement(SCHEMA_URI, "documentation", "");
        this.xmlWriter.endElement(SCHEMA_URI, "annotation", "");
    }
}

