/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.eld.xsd;

import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.x4o.xml.X4ODriver;
import org.x4o.xml.X4ODriverManager;
import org.x4o.xml.element.ElementException;
import org.x4o.xml.io.X4OSchemaWriter;

public class X4OWriteLanguageSchemaExecutor {
    private String languageName = null;
    private String languageVersion = null;
    private String languageNamespaceUri = null;
    private File basePath;

    public static void main(String[] argu) {
        X4OWriteLanguageSchemaExecutor languageSchema = new X4OWriteLanguageSchemaExecutor();
        List<String> arguList = Arrays.asList(argu);
        Iterator<String> arguIterator = arguList.iterator();
        boolean printStack = false;
        while (arguIterator.hasNext()) {
            String arg = arguIterator.next();
            if ("-path".equals(arg) || "-p".equals(arg)) {
                if (!arguIterator.hasNext()) {
                    System.err.println("No argument for " + arg + " given.");
                    System.exit(1);
                    return;
                }
                File schemaBasePath = new File(arguIterator.next());
                if (!schemaBasePath.exists()) {
                    System.err.println("path does not exists; " + schemaBasePath);
                    System.exit(1);
                    return;
                }
                languageSchema.setBasePath(schemaBasePath);
                continue;
            }
            if ("-language".equals(arg) || "-l".equals(arg)) {
                if (!arguIterator.hasNext()) {
                    System.err.println("No argument for " + arg + " given.");
                    System.exit(1);
                    return;
                }
                languageSchema.setLanguageName(arguIterator.next());
                continue;
            }
            if ("-version".equals(arg) || "-v".equals(arg)) {
                if (!arguIterator.hasNext()) {
                    System.err.println("No argument for " + arg + " given.");
                    System.exit(1);
                    return;
                }
                languageSchema.setLanguageVersion(arguIterator.next());
                continue;
            }
            if (!"-verbose".equals(arg) && !"-V".equals(arg)) continue;
            printStack = true;
        }
        ElementException e = null;
        try {
            languageSchema.execute();
        }
        catch (ElementException e1) {
            e = e1;
        }
        if (e != null) {
            System.err.println("Error while schema writing: " + e.getMessage());
            if (printStack) {
                e.printStackTrace();
            }
            System.exit(1);
            return;
        }
    }

    public void execute() throws ElementException {
        X4ODriver<?> driver = X4ODriverManager.getX4ODriver(this.getLanguageName());
        X4OSchemaWriter xsd = driver.createSchemaWriter(this.getLanguageVersion());
        xsd.writeSchema(this.getBasePath(), this.getLanguageNamespaceUri());
    }

    public String getLanguageName() {
        return this.languageName;
    }

    public void setLanguageName(String languageName) {
        this.languageName = languageName;
    }

    public String getLanguageVersion() {
        return this.languageVersion;
    }

    public void setLanguageVersion(String languageVersion) {
        this.languageVersion = languageVersion;
    }

    public String getLanguageNamespaceUri() {
        return this.languageNamespaceUri;
    }

    public void setLanguageNamespaceUri(String languageNamespaceUri) {
        this.languageNamespaceUri = languageNamespaceUri;
    }

    public File getBasePath() {
        return this.basePath;
    }

    public void setBasePath(File basePath) {
        this.basePath = basePath;
    }
}

