/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.element;

import java.util.Locale;
import java.util.logging.Logger;
import javax.el.ValueExpression;
import org.x4o.xml.conv.ObjectConverterException;
import org.x4o.xml.element.Element;
import org.x4o.xml.element.ElementAttributeValueParser;
import org.x4o.xml.element.ElementAttributeValueParserException;
import org.x4o.xml.element.ElementClassAttribute;
import org.x4o.xml.element.ElementInterface;

public class DefaultElementAttributeValueParser
implements ElementAttributeValueParser {
    private Logger logger = Logger.getLogger(DefaultElementAttributeValueParser.class.getName());

    public Object getParameterValue(String name, String valueString, Element element) throws ElementAttributeValueParserException, ObjectConverterException {
        Object value = valueString;
        if (this.isELParameter(name, valueString, element)) {
            value = this.getELParameterValue(valueString, element);
        }
        return this.getConvertedParameterValue(name, value, element);
    }

    public Object getConvertedParameterValue(String name, Object value, Element element) throws ElementAttributeValueParserException, ObjectConverterException {
        if (value == null) {
            return null;
        }
        ElementClassAttribute attr = element.getElementClass().getElementClassAttributeByName(name);
        if (attr != null && attr.getObjectConverter() != null && !value.getClass().isAssignableFrom(attr.getObjectConverter().getObjectClassTo())) {
            this.logger.finer("attr conv: " + attr.getObjectConverter() + " for name: " + name);
            Object result = attr.getObjectConverter().convertTo(value.toString(), Locale.getDefault());
            return result;
        }
        if (element.getElementObject() == null) {
            return value;
        }
        for (ElementInterface ei : element.getLanguageContext().getLanguage().findElementInterfaces(element.getElementObject())) {
            this.logger.finer("Found interface match executing converter.");
            for (ElementClassAttribute attrClass : ei.getElementClassAttributes()) {
                if (!name.equals(attrClass.getId()) || attrClass.getObjectConverter() == null || value.getClass().isAssignableFrom(attrClass.getObjectConverter().getObjectClassTo())) continue;
                this.logger.finest("attr conv interface: " + attrClass.getObjectConverter() + " for name: " + name);
                Object result = attrClass.getObjectConverter().convertTo(value.toString(), Locale.getDefault());
                return result;
            }
        }
        return value;
    }

    public Object getELParameterValue(String value, Element element) throws ElementAttributeValueParserException {
        ValueExpression e = element.getLanguageContext().getExpressionLanguageFactory().createValueExpression(element.getLanguageContext().getExpressionLanguageContext(), value, Object.class);
        return e.getValue(element.getLanguageContext().getExpressionLanguageContext());
    }

    public boolean isELParameter(String name, String value, Element element) {
        if (value == null) {
            return false;
        }
        if (!value.startsWith("${")) {
            return false;
        }
        if (element == null) {
            return true;
        }
        ElementClassAttribute attr = element.getElementClass().getElementClassAttributeByName(name);
        if (attr != null && attr.getRunResolveEL() != null && !attr.getRunResolveEL().booleanValue()) {
            this.logger.finest("Skipping EL parsing for: " + name);
            return false;
        }
        for (ElementInterface ei : element.getLanguageContext().getLanguage().findElementInterfaces(element.getElementObject())) {
            this.logger.finest("Found interface match checking disables el parameters.");
            attr = ei.getElementClassAttributeByName(name);
            if (attr == null || attr.getRunResolveEL() == null || attr.getRunResolveEL().booleanValue()) continue;
            this.logger.finest("Skipping EL parsing for: " + name + " in interface element.");
            return false;
        }
        return true;
    }
}

