/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.io.sax.ext;

import java.io.Writer;
import org.x4o.xml.io.XMLConstants;
import org.x4o.xml.io.sax.ext.AbstractContentWriterHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public abstract class AbstractContentWriterLexical
extends AbstractContentWriterHandler
implements LexicalHandler {
    protected boolean printCDATA = false;

    public AbstractContentWriterLexical(Writer out, String encoding, String charNewLine, String charTab) {
        super(out, encoding, charNewLine, charTab);
    }

    public void startCDATA() throws SAXException {
        this.autoCloseStartElement();
        this.charactersRaw("<![CDATA[");
        this.printCDATA = true;
    }

    public void endCDATA() throws SAXException {
        this.charactersRaw("]]>");
        this.printCDATA = false;
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.charactersRaw("<!DOCTYPE");
        this.charactersRaw(" ");
        this.charactersRaw(name);
        if (publicId != null) {
            this.charactersRaw(" ");
            this.charactersRaw(publicId);
        }
        if (systemId != null) {
            this.charactersRaw(" \"");
            this.charactersRaw(systemId);
            this.charactersRaw("\"");
        }
        this.charactersRaw(">");
    }

    public void endDTD() throws SAXException {
        this.writeFlush();
    }

    public void startEntity(String arg0) throws SAXException {
    }

    public void endEntity(String arg0) throws SAXException {
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.characters(new String(ch, start, length));
    }

    public void characters(String text) throws SAXException {
        if (this.printCDATA) {
            this.charactersRaw(XMLConstants.escapeCharactersCdata(text, "", ""));
        } else {
            super.characters(text);
        }
    }
}

