/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.lang;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.x4o.xml.element.AbstractElementMetaBase;
import org.x4o.xml.element.ElementAttributeHandler;
import org.x4o.xml.element.ElementBindingHandler;
import org.x4o.xml.element.ElementConfiguratorGlobal;
import org.x4o.xml.element.ElementInterface;
import org.x4o.xml.element.ElementNamespaceContext;
import org.x4o.xml.lang.AbstractX4OLanguageContext;
import org.x4o.xml.lang.X4OLanguageLocal;
import org.x4o.xml.lang.X4OLanguageModule;
import org.x4o.xml.lang.X4OLanguageModuleLoader;
import org.x4o.xml.lang.X4OLanguageModuleLoaderException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractX4OLanguageModule
extends AbstractElementMetaBase
implements X4OLanguageModule {
    private Logger logger = Logger.getLogger(AbstractX4OLanguageContext.class.getName());
    private String providerName = null;
    private String providerHost = null;
    private String sourceResource = null;
    private List<ElementAttributeHandler> elementAttributeHandlers = null;
    private List<ElementBindingHandler> elementBindingHandlers = null;
    private List<ElementConfiguratorGlobal> elementConfiguratorGlobals = null;
    private List<ElementInterface> elementInterfaces = null;
    private Map<String, ElementNamespaceContext> elementNamespaceContexts = null;
    private X4OLanguageModuleLoader elementLanguageModuleLoader = null;

    public AbstractX4OLanguageModule() {
        this.logger.finest("Creating new ParsingContext");
        this.elementAttributeHandlers = new ArrayList<ElementAttributeHandler>(4);
        this.elementBindingHandlers = new ArrayList<ElementBindingHandler>(4);
        this.elementConfiguratorGlobals = new ArrayList<ElementConfiguratorGlobal>(4);
        this.elementInterfaces = new ArrayList<ElementInterface>(20);
        this.elementNamespaceContexts = new HashMap<String, ElementNamespaceContext>(10);
    }

    @Override
    public String getProviderName() {
        return this.providerName;
    }

    @Override
    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    @Override
    public String getProviderHost() {
        return this.providerHost;
    }

    @Override
    public void setProviderHost(String providerHost) {
        this.providerHost = providerHost;
    }

    @Override
    public void addElementAttributeHandler(ElementAttributeHandler elementAttributeHandler) {
        if (elementAttributeHandler == null) {
            throw new NullPointerException("Can't add null object");
        }
        if (elementAttributeHandler.getId() == null) {
            throw new NullPointerException("Can't add with null id property.");
        }
        this.logger.finer("Adding ElementAttributeHandler: " + elementAttributeHandler.getAttributeName());
        this.elementAttributeHandlers.add(elementAttributeHandler);
    }

    @Override
    public List<ElementAttributeHandler> getElementAttributeHandlers() {
        return this.elementAttributeHandlers;
    }

    @Override
    public void addElementBindingHandler(ElementBindingHandler elementBindingHandler) {
        if (elementBindingHandler == null) {
            throw new NullPointerException("Can't add null binding handler.");
        }
        if (elementBindingHandler.getId() == null) {
            throw new NullPointerException("Can't add with null id property.");
        }
        this.logger.finer("Adding ElementBindingHandler: " + elementBindingHandler);
        this.elementBindingHandlers.add(elementBindingHandler);
    }

    @Override
    public List<ElementBindingHandler> getElementBindingHandlers() {
        return this.elementBindingHandlers;
    }

    @Override
    public void addElementConfiguratorGlobal(ElementConfiguratorGlobal elementConfigurator) {
        if (elementConfigurator == null) {
            throw new NullPointerException("Can't add null");
        }
        if (elementConfigurator.getId() == null) {
            throw new NullPointerException("Can't add with null id property.");
        }
        this.logger.finer("Adding ElementConfiguratorGlobal: " + elementConfigurator);
        this.elementConfiguratorGlobals.add(elementConfigurator);
    }

    @Override
    public List<ElementConfiguratorGlobal> getElementConfiguratorGlobals() {
        return this.elementConfiguratorGlobals;
    }

    @Override
    public void addElementInterface(ElementInterface elementInterface) {
        if (elementInterface == null) {
            throw new NullPointerException("Can't add null.");
        }
        if (elementInterface.getId() == null) {
            throw new NullPointerException("Can't add with null id property.");
        }
        if (elementInterface.getInterfaceClass() == null) {
            throw new NullPointerException("ElementInterface not correctly configured getInterfaceClass returns null.");
        }
        this.elementInterfaces.add(elementInterface);
    }

    @Override
    public List<ElementInterface> getElementInterfaces() {
        return this.elementInterfaces;
    }

    @Override
    public void addElementNamespaceContext(ElementNamespaceContext elementNamespaceContext) {
        if (elementNamespaceContext == null) {
            throw new NullPointerException("Can't add null.");
        }
        if (elementNamespaceContext.getUri() == null) {
            throw new NullPointerException("Can add ElementNamespaceContext without uri.");
        }
        this.logger.fine("Adding namespaceUri: " + elementNamespaceContext.getUri());
        this.elementNamespaceContexts.put(elementNamespaceContext.getUri(), elementNamespaceContext);
    }

    @Override
    public ElementNamespaceContext getElementNamespaceContext(String namespaceUri) {
        return this.elementNamespaceContexts.get(namespaceUri);
    }

    @Override
    public List<ElementNamespaceContext> getElementNamespaceContexts() {
        return new ArrayList<ElementNamespaceContext>(this.elementNamespaceContexts.values());
    }

    @Override
    public X4OLanguageModuleLoader getLanguageModuleLoader() {
        return this.elementLanguageModuleLoader;
    }

    @Override
    public void setLanguageModuleLoader(X4OLanguageModuleLoader elementLanguageModuleLoader) {
        this.elementLanguageModuleLoader = elementLanguageModuleLoader;
    }

    @Override
    public String getSourceResource() {
        return this.sourceResource;
    }

    @Override
    public void setSourceResource(String sourceResource) {
        this.sourceResource = sourceResource;
    }

    public void reloadModule(X4OLanguageLocal elementLanguage, X4OLanguageModule elementLanguageModule) throws X4OLanguageModuleLoaderException {
        this.elementAttributeHandlers.clear();
        this.elementBindingHandlers.clear();
        this.elementInterfaces.clear();
        this.elementNamespaceContexts.clear();
        this.getLanguageModuleLoader().loadLanguageModule(elementLanguage, elementLanguageModule);
    }
}

