/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.lang.phase;

import java.util.ArrayList;
import java.util.logging.Logger;
import org.x4o.xml.element.Element;
import org.x4o.xml.lang.X4OLanguageClassLoader;
import org.x4o.xml.lang.X4OLanguageContext;
import org.x4o.xml.lang.X4OLanguageLoader;
import org.x4o.xml.lang.X4OLanguageLocal;
import org.x4o.xml.lang.X4OLanguageModule;
import org.x4o.xml.lang.X4OLanguageModuleLoaderSibling;
import org.x4o.xml.lang.phase.AbstractX4OPhase;
import org.x4o.xml.lang.phase.DefaultX4OPhaseManager;
import org.x4o.xml.lang.phase.X4OPhase;
import org.x4o.xml.lang.phase.X4OPhaseException;
import org.x4o.xml.lang.phase.X4OPhaseType;

public class X4OPhaseLanguageInit {
    private Logger logger = Logger.getLogger(X4OPhaseLanguageInit.class.getName());

    public void createPhases(DefaultX4OPhaseManager manager) {
        manager.addX4OPhase(new X4OPhaseInitStart());
        manager.addX4OPhase(new X4OPhaseInitLanguage());
        manager.addX4OPhase(new X4OPhaseInitLanguageSiblings());
        manager.addX4OPhase(new X4OPhaseInitEnd());
    }

    class X4OPhaseInitEnd
    extends AbstractX4OPhase {
        X4OPhaseInitEnd() {
        }

        public X4OPhaseType getType() {
            return X4OPhaseType.INIT;
        }

        public String getId() {
            return "INIT_END";
        }

        public String[] getPhaseDependencies() {
            return new String[]{"INIT_LANG_SIB"};
        }

        public boolean isElementPhase() {
            return false;
        }

        public void runElementPhase(Element element) throws X4OPhaseException {
        }

        public void runPhase(X4OLanguageContext languageContext) throws X4OPhaseException {
            X4OPhaseLanguageInit.this.logger.finest("Run init end phase");
        }
    }

    class X4OPhaseInitLanguageSiblings
    extends AbstractX4OPhase {
        X4OPhaseInitLanguageSiblings() {
        }

        public X4OPhaseType getType() {
            return X4OPhaseType.INIT;
        }

        public String getId() {
            return "INIT_LANG_SIB";
        }

        public String[] getPhaseDependencies() {
            return new String[]{"INIT_LANG"};
        }

        public boolean isElementPhase() {
            return false;
        }

        public void runElementPhase(Element element) throws X4OPhaseException {
        }

        public void runPhase(X4OLanguageContext languageContext) throws X4OPhaseException {
            try {
                ArrayList<X4OLanguageModuleLoaderSibling> siblingLoaders = new ArrayList<X4OLanguageModuleLoaderSibling>(3);
                for (X4OLanguageModule module : languageContext.getLanguage().getLanguageModules()) {
                    if (!(module.getLanguageModuleLoader() instanceof X4OLanguageModuleLoaderSibling)) continue;
                    siblingLoaders.add((X4OLanguageModuleLoaderSibling)module.getLanguageModuleLoader());
                }
                if (!siblingLoaders.isEmpty()) {
                    X4OLanguageLoader loader = (X4OLanguageLoader)X4OLanguageClassLoader.newInstance(languageContext.getLanguage().getLanguageConfiguration().getDefaultLanguageLoader());
                    for (X4OLanguageModuleLoaderSibling siblingLoader : siblingLoaders) {
                        siblingLoader.loadLanguageSibling((X4OLanguageLocal)languageContext.getLanguage(), loader);
                    }
                    if (languageContext.hasX4ODebugWriter()) {
                        languageContext.getX4ODebugWriter().debugElementLanguageModules(languageContext);
                    }
                }
            }
            catch (Exception e) {
                throw new X4OPhaseException((X4OPhase)this, e);
            }
        }
    }

    class X4OPhaseInitLanguage
    extends AbstractX4OPhase {
        X4OPhaseInitLanguage() {
        }

        public X4OPhaseType getType() {
            return X4OPhaseType.INIT;
        }

        public String getId() {
            return "INIT_LANG";
        }

        public String[] getPhaseDependencies() {
            return new String[]{"INIT_START"};
        }

        public boolean isElementPhase() {
            return false;
        }

        public void runElementPhase(Element element) throws X4OPhaseException {
        }

        public void runPhase(X4OLanguageContext languageContext) throws X4OPhaseException {
            try {
                X4OLanguageLoader loader = (X4OLanguageLoader)X4OLanguageClassLoader.newInstance(languageContext.getLanguage().getLanguageConfiguration().getDefaultLanguageLoader());
                loader.loadLanguage((X4OLanguageLocal)languageContext.getLanguage(), languageContext.getLanguage().getLanguageName(), languageContext.getLanguage().getLanguageVersion());
                if (languageContext.hasX4ODebugWriter()) {
                    languageContext.getX4ODebugWriter().debugElementLanguageModules(languageContext);
                }
            }
            catch (Exception e) {
                throw new X4OPhaseException((X4OPhase)this, e);
            }
        }
    }

    class X4OPhaseInitStart
    extends AbstractX4OPhase {
        X4OPhaseInitStart() {
        }

        public X4OPhaseType getType() {
            return X4OPhaseType.INIT;
        }

        public String getId() {
            return "INIT_START";
        }

        public String[] getPhaseDependencies() {
            return new String[0];
        }

        public boolean isElementPhase() {
            return false;
        }

        public void runElementPhase(Element element) throws X4OPhaseException {
        }

        public void runPhase(X4OLanguageContext languageContext) throws X4OPhaseException {
            X4OPhaseLanguageInit.this.logger.finest("Run init start phase");
        }
    }
}

