/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.eld.doc.api;

import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.x4o.xml.eld.doc.api.ApiDocContentCss;
import org.x4o.xml.io.sax.ext.ContentWriterHtml;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApiDocContentWriter
extends ContentWriterHtml {
    private boolean isAltRow = true;

    public ApiDocContentWriter(Writer out, String encoding, String charNewLine, String charTab) {
        super(out, encoding, charNewLine, charTab);
    }

    public void docCommentGenerated() throws SAXException {
        this.comment("Generated by " + ApiDocContentWriter.class.getSimpleName() + " on " + new Date());
    }

    public void docHtmlStart(NavBarConfig conf, String title, List<String> keywords) throws SAXException {
        this.printDocType(ContentWriterHtml.DocType.HTML_4_TRANSITIONAL);
        this.comment("NewPage");
        this.printHtmlStart("en");
        this.printTagStart((Enum)ContentWriterHtml.Tag.head);
        this.docCommentGenerated();
        this.printHeadMetaContentType();
        this.printHeadTitle(title);
        this.printHeadMetaDate();
        for (String keyword : keywords) {
            this.printHeadMeta("keywords", keyword);
        }
        this.printHeadLinkCss(conf.pathPrefix + "resources/stylesheet.css");
        this.printTagEnd((Enum)ContentWriterHtml.Tag.head);
        this.printTagStart((Enum)ContentWriterHtml.Tag.body);
        StringBuffer script = new StringBuffer();
        script.append("\n");
        script.append("\tif (location.href.indexOf('is-external=true') == -1) {\n");
        script.append("\t\tparent.document.title=\"");
        script.append(title);
        script.append("\";\n");
        script.append("\t}\n");
        this.printScriptInline(script.toString());
        this.printScriptNoDiv();
        this.docNavBar(conf, true);
    }

    public void docHtmlEnd(NavBarConfig conf, String copyright) throws SAXException {
        this.docNavBar(conf, false);
        this.printTagStart(ContentWriterHtml.Tag.p, ApiDocContentCss.legalCopy);
        this.printTagStart((Enum)ContentWriterHtml.Tag.small);
        this.charactersRaw(copyright);
        this.printTagEnd((Enum)ContentWriterHtml.Tag.small);
        this.printTagEnd((Enum)ContentWriterHtml.Tag.p);
        if (conf.statsJS != null) {
            this.printScriptInline(conf.statsJS);
        }
        this.printTagEnd((Enum)ContentWriterHtml.Tag.body);
        this.printHtmlEnd();
    }

    private void docNavBar(NavBarConfig conf, boolean isTop) throws SAXException {
        boolean printLink;
        String pathPrefix = conf.pathPrefix;
        String barComment = "TOP";
        String barCssDiv = "topNav";
        String barId = "navbar_top";
        if (!isTop) {
            barComment = "BOTTOM";
            barCssDiv = "bottomNav";
            barId = "navbar_bottom";
        }
        this.comment("========= START OF " + barComment + " NAVBAR =======");
        this.printTagStart(ContentWriterHtml.Tag.div, barCssDiv);
        this.printHrefNamed(barId);
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "href", "", "", "#skip-" + barId);
        atts.addAttribute("", "title", "", "", "Skip navigation links");
        this.startElement("", "a", "", atts);
        this.endElement("", "a", "");
        this.printHrefNamed(barId + "_firstrow");
        atts = new AttributesImpl();
        atts.addAttribute("", "class", "", "", "navList");
        atts.addAttribute("", "title", "", "", "Navigation");
        this.startElement("", "ul", "", atts);
        for (String navKey : conf.navList) {
            String navName = conf.navNames.get(navKey);
            String navLink = conf.navLinks.get(navKey);
            String navTitle = conf.navTitles.get(navKey);
            String selectedCss = null;
            if (navKey.equals(conf.navSelected)) {
                selectedCss = "navBarCell1Rev";
                navLink = null;
            }
            if (navTitle == null) {
                navTitle = navName;
            }
            if (navLink == null) {
                this.printTagCharacters(ContentWriterHtml.Tag.li, navName, selectedCss);
                continue;
            }
            this.docNavBarListItemHref(pathPrefix + navLink, navName, navTitle, selectedCss, null, null);
        }
        this.endElement("", "ul", "");
        this.printTagStart(ContentWriterHtml.Tag.div, ApiDocContentCss.aboutLanguage);
        this.printTagStart((Enum)ContentWriterHtml.Tag.em);
        this.printTagStart((Enum)ContentWriterHtml.Tag.strong);
        for (int i = 0; i < conf.aboutLanguage.length(); ++i) {
            char c = conf.aboutLanguage.charAt(i);
            if (c == '\n') {
                this.printTagStartEnd((Enum)ContentWriterHtml.Tag.br);
                continue;
            }
            this.characters(c);
        }
        this.printTagEnd((Enum)ContentWriterHtml.Tag.strong);
        this.printTagEnd((Enum)ContentWriterHtml.Tag.em);
        this.printTagEnd((Enum)ContentWriterHtml.Tag.div);
        this.printTagEnd((Enum)ContentWriterHtml.Tag.div);
        this.printTagStart(ContentWriterHtml.Tag.div, ApiDocContentCss.subNav);
        this.printTagStart(ContentWriterHtml.Tag.ul, ApiDocContentCss.navList);
        if (conf.prev == null) {
            this.printTagCharacters((Enum)ContentWriterHtml.Tag.li, "Prev");
        } else {
            this.docNavBarListItemHref(pathPrefix + conf.prev, "Prev", "Previous Item", null, "strong", null);
        }
        if (conf.next == null) {
            this.printTagCharacters((Enum)ContentWriterHtml.Tag.li, "Next");
        } else {
            this.docNavBarListItemHref(pathPrefix + conf.next, "Next", "Next Item", null, "strong", null);
        }
        this.printTagEnd((Enum)ContentWriterHtml.Tag.ul);
        if (conf.frame != null) {
            this.printTagStart(ContentWriterHtml.Tag.ul, ApiDocContentCss.navList);
            this.printTagStart((Enum)ContentWriterHtml.Tag.li);
            this.printHrefTarget(pathPrefix + "index.html?" + conf.frame, "Frames", "_top");
            this.printTagEnd((Enum)ContentWriterHtml.Tag.li);
            this.printTagStart((Enum)ContentWriterHtml.Tag.li);
            this.printHrefTarget(pathPrefix + conf.frame, "No Frames", "_top");
            this.printTagEnd((Enum)ContentWriterHtml.Tag.li);
            this.printTagEnd((Enum)ContentWriterHtml.Tag.ul);
        }
        if (conf.noFrameAllName != null && conf.noFrameAllLink != null) {
            this.printTagStart(ContentWriterHtml.Tag.ul, ApiDocContentCss.navList, "allclasses_" + barId);
            this.docNavBarListItemHref(pathPrefix + conf.noFrameAllLink, conf.noFrameAllName, null, null, null, null);
            this.printTagEnd((Enum)ContentWriterHtml.Tag.ul);
            this.printTagStart((Enum)ContentWriterHtml.Tag.div);
            if (isTop) {
                this.printScriptInline(conf.noFrameAllTopJS);
            } else {
                this.printScriptInline(conf.noFrameAllBottomJS);
            }
            this.printTagEnd((Enum)ContentWriterHtml.Tag.div);
        }
        String tabSpace = "&nbsp;|&nbsp;";
        boolean bl = printLink = conf.linkConstructors || conf.linkFields || conf.linkMethods;
        if (printLink) {
            this.printTagStart((Enum)ContentWriterHtml.Tag.div);
            this.printTagStart(ContentWriterHtml.Tag.ul, ApiDocContentCss.subNavList);
            this.printTagStart((Enum)ContentWriterHtml.Tag.li);
            this.charactersRaw("Summary:&nbsp;");
            this.printTagEnd((Enum)ContentWriterHtml.Tag.li);
            if (conf.linkFields) {
                this.docNavBarListItemHrefLinkSpace("#field_summary", conf.linkFieldName);
            } else {
                this.printTagCharacters((Enum)ContentWriterHtml.Tag.li, conf.linkFieldName);
                this.charactersRaw(tabSpace);
            }
            if (conf.linkConstructors) {
                this.docNavBarListItemHrefLinkSpace("#constructor_summary", conf.linkConstructorName);
            } else {
                this.printTagCharacters((Enum)ContentWriterHtml.Tag.li, conf.linkConstructorName);
                this.charactersRaw(tabSpace);
            }
            if (conf.linkMethods) {
                this.docNavBarListItemHref("#method_summary", conf.linkMethodName, null);
            } else {
                this.printTagCharacters((Enum)ContentWriterHtml.Tag.li, conf.linkMethodName);
            }
            this.printTagEnd((Enum)ContentWriterHtml.Tag.ul);
            if (conf.linkDetails) {
                this.printTagStart(ContentWriterHtml.Tag.ul, ApiDocContentCss.subNavList);
                this.printTagStart((Enum)ContentWriterHtml.Tag.li);
                this.charactersRaw("Detail:&nbsp;");
                this.printTagEnd((Enum)ContentWriterHtml.Tag.li);
                if (conf.linkFields) {
                    this.docNavBarListItemHrefLinkSpace("#field_detail", conf.linkFieldName);
                } else {
                    this.printTagCharacters((Enum)ContentWriterHtml.Tag.li, conf.linkFieldName);
                    this.charactersRaw(tabSpace);
                }
                if (conf.linkConstructors) {
                    this.docNavBarListItemHrefLinkSpace("#constructor_detail", conf.linkConstructorName);
                } else {
                    this.printTagCharacters((Enum)ContentWriterHtml.Tag.li, conf.linkConstructorName);
                    this.charactersRaw(tabSpace);
                }
                if (conf.linkMethods) {
                    this.docNavBarListItemHref("#method_detail", conf.linkMethodName, null);
                } else {
                    this.printTagCharacters((Enum)ContentWriterHtml.Tag.li, conf.linkMethodName);
                }
                this.printTagEnd((Enum)ContentWriterHtml.Tag.ul);
            }
            this.printTagEnd((Enum)ContentWriterHtml.Tag.div);
        }
        this.printHrefNamed("skip-" + barId);
        this.printTagEnd((Enum)ContentWriterHtml.Tag.div);
        this.comment("========= END OF " + barComment + " NAVBAR =======");
    }

    private void docNavBarListItemHrefLinkSpace(String href, String title) throws SAXException {
        String tabSpace = "&nbsp;|&nbsp;";
        this.docNavBarListItemHref(href, title, title, null, null, tabSpace);
    }

    private void docNavBarListItemHref(String href, String title, String cssClass) throws SAXException {
        this.docNavBarListItemHref(href, title, title, cssClass, null, null);
    }

    private void docNavBarListItemHref(String href, String title, String text, String cssClass, String spanCss, String linkSpace) throws SAXException {
        this.printTagStart(ContentWriterHtml.Tag.li, cssClass);
        this.printHref(href, title, text, spanCss);
        this.charactersRaw(linkSpace);
        this.printTagEnd((Enum)ContentWriterHtml.Tag.li);
    }

    public void docPagePackageTitle(String title, String summary) throws SAXException {
        this.printTagStart(ContentWriterHtml.Tag.div, ApiDocContentCss.header);
        this.printTagCharacters(ContentWriterHtml.Tag.h1, title, "title");
        this.printTagStart(ContentWriterHtml.Tag.div, ApiDocContentCss.docSummary);
        this.printTagCharacters(ContentWriterHtml.Tag.div, summary, ApiDocContentCss.block.name());
        this.printTagEnd((Enum)ContentWriterHtml.Tag.div);
        this.printTagStart((Enum)ContentWriterHtml.Tag.p);
        this.charactersRaw("See:&nbsp;");
        this.printHref("#package_description", "Description");
        this.printTagEnd((Enum)ContentWriterHtml.Tag.p);
        this.printTagEnd((Enum)ContentWriterHtml.Tag.div);
    }

    public void docPagePackageDescription(String title, String summary, String description) throws SAXException {
        this.printHrefNamed("package_description");
        this.printTagCharacters((Enum)ContentWriterHtml.Tag.h2, title);
        this.printTagCharacters(ContentWriterHtml.Tag.div, summary, ApiDocContentCss.block.name());
        this.characters(description);
    }

    public void docPageClassStart(String title, String subTitle) throws SAXException {
        this.comment("======== START OF CLASS DATA ========");
        this.printTagStart(ContentWriterHtml.Tag.div, ApiDocContentCss.header);
        if (subTitle != null) {
            this.printTagStart(ContentWriterHtml.Tag.div, ApiDocContentCss.subTitle);
            this.characters(subTitle);
            this.printTagEnd((Enum)ContentWriterHtml.Tag.div);
        }
        this.printTagCharacters(ContentWriterHtml.Tag.h2, title, "title");
        this.printTagEnd((Enum)ContentWriterHtml.Tag.div);
    }

    public void docPageClassEnd() throws SAXException {
        this.comment("======== END OF CLASS DATA ========");
    }

    public void docPageContentStart() throws SAXException {
        this.printTagStart(ContentWriterHtml.Tag.div, ApiDocContentCss.contentContainer);
    }

    public void docPageContentEnd() throws SAXException {
        this.printTagEnd((Enum)ContentWriterHtml.Tag.div);
    }

    public void docPageBlockStart(String title, String namedLink, String comment) throws SAXException {
        if (comment != null) {
            this.comment(comment);
        }
        this.docPageBlockStart();
        this.printHrefNamed(namedLink);
        this.printTagCharacters((Enum)ContentWriterHtml.Tag.h3, title);
    }

    public void docPageBlockStart() throws SAXException {
        this.printTagStart(ContentWriterHtml.Tag.ul, ApiDocContentCss.blockList);
        this.printTagStart(ContentWriterHtml.Tag.li, ApiDocContentCss.blockList);
    }

    public void docPageBlockEnd() throws SAXException {
        this.printTagEnd((Enum)ContentWriterHtml.Tag.li);
        this.printTagEnd((Enum)ContentWriterHtml.Tag.ul);
    }

    public void docPageBlockNext() throws SAXException {
        this.printTagEnd((Enum)ContentWriterHtml.Tag.li);
        this.printTagStart(ContentWriterHtml.Tag.li, ApiDocContentCss.blockList);
    }

    public void docTableStart(String tableTitle, String tableDescription) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "class", "", "", "packageSummary");
        atts.addAttribute("", "border", "", "", "0");
        atts.addAttribute("", "cellpadding", "", "", "3");
        atts.addAttribute("", "cellspacing", "", "", "0");
        if (tableDescription != null) {
            atts.addAttribute("", "summary", "", "", tableDescription);
        }
        this.startElement("", "table", "", atts);
        this.printTagStart((Enum)ContentWriterHtml.Tag.caption);
        this.printTagStart((Enum)ContentWriterHtml.Tag.span);
        this.characters(tableTitle);
        this.printTagEnd((Enum)ContentWriterHtml.Tag.span);
        this.printTagStart(ContentWriterHtml.Tag.span, ApiDocContentCss.tabEnd);
        this.charactersRaw("&nbsp;");
        this.printTagEnd((Enum)ContentWriterHtml.Tag.span);
        this.printTagEnd((Enum)ContentWriterHtml.Tag.caption);
    }

    public void docTableEnd() throws SAXException {
        this.printTagEnd((Enum)ContentWriterHtml.Tag.table);
        this.isAltRow = true;
    }

    public void docTableHeader(String titleFirst, String titleLast) throws SAXException {
        this.printTagStart((Enum)ContentWriterHtml.Tag.tr);
        AttributesImpl atts = new AttributesImpl();
        if (titleLast == null) {
            atts.addAttribute("", "class", "", "", "colOne");
        } else {
            atts.addAttribute("", "class", "", "", "colFirst");
        }
        atts.addAttribute("", "scope", "", "", "col");
        this.startElement("", "th", "", atts);
        this.characters(titleFirst);
        this.endElement("", "th", "");
        if (titleLast == null) {
            this.printTagEnd((Enum)ContentWriterHtml.Tag.tr);
            return;
        }
        atts = new AttributesImpl();
        atts.addAttribute("", "class", "", "", "colLast");
        atts.addAttribute("", "scope", "", "", "col");
        this.startElement("", "th", "", atts);
        this.characters(titleLast);
        this.printTagEnd((Enum)ContentWriterHtml.Tag.th);
        this.printTagEnd((Enum)ContentWriterHtml.Tag.tr);
    }

    public void docTableRow(String dataFirst, String dataLast) throws SAXException {
        this.docTableRow(dataFirst, dataLast, null);
    }

    public void docTableRow(String dataFirst, String dataLast, String dataBlock) throws SAXException {
        this.docTableRowHref(null, dataFirst, dataLast, dataBlock);
    }

    public void docTableRowHref(String dataFirstHref, String dataFirst, String dataLast, String dataBlock) throws SAXException {
        if (this.isAltRow) {
            this.printTagStart(ContentWriterHtml.Tag.tr, ApiDocContentCss.altColor);
        } else {
            this.printTagStart(ContentWriterHtml.Tag.tr, ApiDocContentCss.rowColor);
        }
        boolean bl = this.isAltRow = !this.isAltRow;
        if (dataLast == null) {
            this.printTagStart(ContentWriterHtml.Tag.td, ApiDocContentCss.colOne);
        } else {
            this.printTagStart(ContentWriterHtml.Tag.td, ApiDocContentCss.colFirst);
        }
        this.printTagStart((Enum)ContentWriterHtml.Tag.code);
        if (dataFirstHref == null) {
            this.characters(dataFirst);
        } else {
            this.printHref(dataFirstHref, dataFirst, dataFirst);
        }
        this.printTagEnd((Enum)ContentWriterHtml.Tag.code);
        this.printTagEnd((Enum)ContentWriterHtml.Tag.td);
        if (dataLast == null) {
            this.printTagEnd((Enum)ContentWriterHtml.Tag.tr);
            return;
        }
        this.printTagStart(ContentWriterHtml.Tag.td, ApiDocContentCss.colLast);
        this.printTagStart((Enum)ContentWriterHtml.Tag.code);
        this.characters(dataLast);
        this.printTagEnd((Enum)ContentWriterHtml.Tag.code);
        if (dataBlock != null) {
            this.printTagStart(ContentWriterHtml.Tag.div, ApiDocContentCss.block);
            this.characters(dataBlock);
            this.printTagEnd((Enum)ContentWriterHtml.Tag.div);
        }
        this.printTagEnd((Enum)ContentWriterHtml.Tag.td);
        this.printTagEnd((Enum)ContentWriterHtml.Tag.tr);
    }

    public static String toSafeUri(List<String> paths) {
        return ApiDocContentWriter.toSafeUri(paths.toArray(new String[0]));
    }

    public static String toSafeUri(String ... paths) {
        StringBuffer result = new StringBuffer(100);
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i];
            result.append(ApiDocContentWriter.toSafeUri(path));
            if (i >= paths.length - 1) continue;
            result.append('/');
        }
        return result.toString();
    }

    public static String toSafeUri(String uri) {
        StringBuilder buf = new StringBuilder(20);
        for (char c : uri.toLowerCase().toCharArray()) {
            if (Character.isLetter(c)) {
                buf.append(c);
            }
            if (Character.isDigit(c)) {
                buf.append(c);
            }
            if ('.' == c) {
                buf.append(c);
            }
            if ('-' == c) {
                buf.append(c);
            }
            if ('_' != c) continue;
            buf.append(c);
        }
        String prefix = buf.toString();
        if (prefix.startsWith("http")) {
            prefix = prefix.substring(4);
        }
        if (prefix.startsWith("uri")) {
            prefix = prefix.substring(3);
        }
        if (prefix.startsWith("url")) {
            prefix = prefix.substring(3);
        }
        return prefix;
    }

    class NavBarConfig {
        String navSelected = null;
        List<String> navList = new ArrayList<String>(10);
        Map<String, String> navLinks = new HashMap<String, String>(10);
        Map<String, String> navNames = new HashMap<String, String>(10);
        Map<String, String> navTitles = new HashMap<String, String>(10);
        String pathPrefix;
        String prev;
        String next;
        String frame;
        String aboutLanguage;
        String statsJS;
        boolean linkDetails = false;
        boolean linkFields = false;
        boolean linkConstructors = false;
        boolean linkMethods = false;
        String linkFieldName = "Field";
        String linkConstructorName = "Constr";
        String linkMethodName = "Method";
        String noFrameAllName;
        String noFrameAllLink;
        String noFrameAllTopJS = "\nallClassesLink = document.getElementById(\"allclasses_navbar_top\");\nif(window==top) {\n\tallClassesLink.style.display = \"block\";\n} else {\n\tallClassesLink.style.display = \"none\";\n}\n";
        String noFrameAllBottomJS = "\nallClassesLink = document.getElementById(\"allclasses_navbar_bottom\");\nif(window==top) {\n\tallClassesLink.style.display = \"block\";\n} else {\n\tallClassesLink.style.display = \"none\";\n}\n";

        public NavBarConfig() {
        }

        public NavBarConfig(String pathPrefix, String prev, String next, String frame, String aboutLanguage) {
            this.pathPrefix = pathPrefix;
            this.prev = prev;
            this.next = next;
            this.frame = frame;
            this.aboutLanguage = aboutLanguage;
        }

        public void addNavItem(String id, String navLink, String navName) {
            this.navList.add(id);
            if (navLink != null) {
                this.navLinks.put(id, navLink);
            }
            this.navNames.put(id, navName);
        }
    }
}

