/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.plugin.ant;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public abstract class AbstractX4OLanguageTask
extends Task {
    private String languageName = null;
    private String languageVersion = null;
    private String destdir = null;
    private boolean verbose = false;
    private boolean failonerror = true;

    abstract String getLanguageTaskName();

    abstract void executeLanguageTask(File var1) throws BuildException;

    public void execute() throws BuildException {
        try {
            if (this.isVerbose()) {
                this.log("Task location: " + this.getLocation());
                this.log("X4O language name: " + this.getLanguageName());
                this.log("X4O language version: " + this.getLanguageVersion());
                this.log("Destination directory: " + this.getDestdir());
                this.log("Verbose: " + this.isVerbose());
                this.log("Fail on error: " + this.isFailonerror());
            }
            this.executeLanguageTask();
        }
        catch (BuildException e) {
            if (this.isFailonerror()) {
                throw e;
            }
            this.log(e.getMessage(), 1);
        }
    }

    private void executeLanguageTask() throws BuildException {
        if (this.getLanguageName() == null) {
            throw new BuildException("language attribute is not set.");
        }
        if (this.getDestdir() == null) {
            throw new BuildException("basePath attribute is not set.");
        }
        if (this.getLanguageName().length() == 0) {
            throw new BuildException("language attribute is empty.");
        }
        if (this.getDestdir().length() == 0) {
            throw new BuildException("basePath attribute is empty.");
        }
        File basePathFile = new File(this.getDestdir());
        if (!basePathFile.exists()) {
            throw new BuildException("destdir does not exists: " + basePathFile);
        }
        if (this.isVerbose()) {
            this.log("Starting " + this.getLanguageTaskName());
        }
        long startTime = System.currentTimeMillis();
        this.executeLanguageTask(basePathFile);
        long stopTime = System.currentTimeMillis();
        this.log("Done " + this.getLanguageTaskName() + " in " + (stopTime - startTime) + " ms.");
    }

    public String getLanguageName() {
        return this.languageName;
    }

    public void setLanguageName(String languageName) {
        this.languageName = languageName;
    }

    public String getLanguageVersion() {
        return this.languageVersion;
    }

    public void setLanguageVersion(String languageVersion) {
        this.languageVersion = languageVersion;
    }

    public String getDestdir() {
        return this.destdir;
    }

    public void setDestdir(String destdir) {
        this.destdir = destdir;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isFailonerror() {
        return this.failonerror;
    }

    public void setFailonerror(boolean failonerror) {
        this.failonerror = failonerror;
    }
}

