/*
 * Copyright (C) 2013 Google Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE AND ITS CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE OR ITS CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef UnitTestHelpers_h
#define UnitTestHelpers_h

#include "base/memory/scoped_refptr.h"
#include "platform/Timer.h"
#include "platform/wtf/text/WTFString.h"

namespace blink {

class SharedBuffer;

namespace testing {

// Note: You may want to use TestingPlatformSupportWithMockScheduler to
// provides runUntilIdle() method that can work with WebURLLoaderMockFactory.
void RunPendingTasks();

// Waits for delayed task to complete or timers to fire for |delay|.
void RunDelayedTasks(TimeDelta delay);

void EnterRunLoop();
void ExitRunLoop();

void YieldCurrentThread();

// Returns Blink top directory as an absolute path, e.g.
// /src/third_party/WebKit.
String BlinkRootDir();

// Returns directory containing the current executable as absolute path.
String ExecutableDir();

// Returns test data absolute path for webkit_unit_tests in core, i.e.
// <blinkRootDir>/Source/core/testing/data/<relativePath>.
// It returns the top web test directory if |relativePath| was not specified.
String CoreTestDataPath(const String& relative_path = String());

// Returns test data absolute path for blink_platform_unittests, i.e.
// <blinkRootDir>/Source/platform/testing/data/<relativePath>.
// It returns the top platform test directory if |relativePath| was not
// specified.
String PlatformTestDataPath(const String& relative_path = String());

scoped_refptr<SharedBuffer> ReadFromFile(const String& path);

}  // namespace testing
}  // namespace blink

#endif
