/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.haha.trove;

import com.squareup.haha.trove.THashIterator;
import com.squareup.haha.trove.TObjectHash;
import com.squareup.haha.trove.TObjectHashIterator;
import com.squareup.haha.trove.TObjectObjectProcedure;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class THashMap<K, V>
extends TObjectHash<K>
implements Map<K, V> {
    protected transient V[] _values;

    @Override
    private THashMap<K, V> clone() {
        THashMap m = (THashMap)super.clone();
        ((THashMap)super.clone())._values = (Object[])this._values.clone();
        return m;
    }

    @Override
    protected final int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = new Object[capacity];
        return capacity;
    }

    @Override
    public final V put(K key, V value) {
        if (key == null) {
            throw new NullPointerException("null keys not supported");
        }
        V previous = null;
        int index = this.insertionIndex(key);
        boolean alreadyStored = index < 0;
        if (alreadyStored) {
            index = -index - 1;
            previous = this._values[index];
        }
        Object oldKey = this._set[index];
        this._set[index] = key;
        this._values[index] = value;
        if (!alreadyStored) {
            this.postInsertHook(oldKey == null);
        }
        return previous;
    }

    @Override
    public final boolean equals(Object other) {
        if (!(other instanceof Map)) {
            return false;
        }
        Map that = (Map)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    @Override
    public final int hashCode() {
        HashProcedure p = new HashProcedure(this);
        this.forEachEntry(p);
        HashProcedure hashProcedure = p;
        return hashProcedure.h;
    }

    private boolean forEachEntry(TObjectObjectProcedure<K, V> procedure) {
        Object[] keys = this._set;
        V[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (keys[i] == null || keys[i] == REMOVED || procedure.execute(keys[i], values[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    protected final void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        Object[] oldKeys = this._set;
        V[] oldVals = this._values;
        this._set = new Object[newCapacity];
        this._values = new Object[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldKeys[i] == null || oldKeys[i] == REMOVED) continue;
            Object o = oldKeys[i];
            int index = this.insertionIndex(o);
            if (index < 0) {
                this.throwObjectContractViolation(this._set[-index - 1], o);
            }
            this._set[index] = o;
            this._values[index] = oldVals[i];
        }
    }

    @Override
    public final V get(Object key) {
        int index = this.index(key);
        if (index < 0) {
            return null;
        }
        return this._values[index];
    }

    @Override
    public final void clear() {
        if (this.size() != 0) {
            super.clear();
            Object[] keys = this._set;
            V[] values = this._values;
            int i = keys.length;
            while (i-- > 0) {
                keys[i] = null;
                values[i] = null;
            }
        }
    }

    @Override
    public final V remove(Object key) {
        V prev = null;
        int index = this.index(key);
        if (index >= 0) {
            prev = this._values[index];
            this.removeAt(index);
        }
        return prev;
    }

    @Override
    protected final void removeAt(int index) {
        this._values[index] = null;
        super.removeAt(index);
    }

    @Override
    public final Collection<V> values() {
        return new ValueView();
    }

    @Override
    public final Set<K> keySet() {
        return new KeyView(this);
    }

    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        return new EntryView();
    }

    @Override
    public final boolean containsValue(Object val) {
        Object[] set = this._set;
        V[] vals = this._values;
        if (val == null) {
            int i = vals.length;
            while (i-- > 0) {
                if (set[i] == null || set[i] == REMOVED || val != vals[i]) continue;
                return true;
            }
        } else {
            int i = vals.length;
            while (i-- > 0) {
                if (set[i] == null || set[i] == REMOVED || val != vals[i] && !val.equals(vals[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.contains(key);
    }

    @Override
    public final void putAll(Map<? extends K, ? extends V> map) {
        this.ensureCapacity(map.size());
        for (Map.Entry<K, V> e : map.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    final class Entry
    implements Map.Entry<K, V> {
        private final K key;
        private V val;
        private final int index;
        private /* synthetic */ THashMap this$0;

        Entry(THashMap tHashMap, K key, V value, int index) {
            this.this$0 = tHashMap;
            this.key = key;
            this.val = value;
            this.index = index;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.val;
        }

        @Override
        public final V setValue(V o) {
            if (this.this$0._values[this.index] != this.val) {
                throw new ConcurrentModificationException();
            }
            this.this$0._values[this.index] = o;
            Object prev = this.val;
            this.val = o;
            return prev;
        }
    }

    /*
     * Signature claims super is com.squareup.haha.trove.THashMap$com.squareup.haha.trove.THashMap$MapBackedView<K>, not com.squareup.haha.trove.THashMap$MapBackedView - discarding signature.
     */
    public final class KeyView
    extends MapBackedView {
        private /* synthetic */ THashMap this$0;

        KeyView(THashMap tHashMap) {
            this.this$0 = tHashMap;
            super(tHashMap);
        }

        @Override
        public final Iterator<K> iterator() {
            return new TObjectHashIterator(this.this$0);
        }

        public final boolean removeElement(K key) {
            return null != this.this$0.remove(key);
        }

        public final boolean containsElement(K key) {
            return this.this$0.contains(key);
        }
    }

    abstract class MapBackedView<E>
    implements Set<E> {
        private /* synthetic */ THashMap this$0;

        MapBackedView(THashMap tHashMap) {
            this.this$0 = tHashMap;
        }

        @Override
        public abstract Iterator<E> iterator();

        public abstract boolean removeElement(E var1);

        public abstract boolean containsElement(E var1);

        @Override
        public boolean contains(Object key) {
            return this.containsElement(key);
        }

        @Override
        public boolean remove(Object o) {
            return this.removeElement(o);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object element : collection) {
                if (this.contains(element)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean changed = false;
            for (Object element : collection) {
                if (!this.remove(element)) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public void clear() {
            this.this$0.clear();
        }

        @Override
        public boolean add(E obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.this$0.size();
        }

        @Override
        public Object[] toArray() {
            Object[] result = new Object[this.size()];
            Iterator<E> e = this.iterator();
            int i = 0;
            while (e.hasNext()) {
                result[i] = e.next();
                ++i;
            }
            return result;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            int size = this.size();
            if (a.length < size) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
            }
            Iterator<E> it = this.iterator();
            T[] result = a;
            for (int i = 0; i < size; ++i) {
                result[i] = it.next();
            }
            if (a.length > size) {
                a[size] = null;
            }
            return a;
        }

        @Override
        public boolean isEmpty() {
            return this.this$0.isEmpty();
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean changed = false;
            Iterator<E> i = this.iterator();
            while (i.hasNext()) {
                if (collection.contains(i.next())) continue;
                i.remove();
                changed = true;
            }
            return changed;
        }
    }

    /*
     * Signature claims super is com.squareup.haha.trove.THashMap$com.squareup.haha.trove.THashMap$MapBackedView<java.util.Map$Entry<K, V>>, not com.squareup.haha.trove.THashMap$MapBackedView - discarding signature.
     */
    public final class EntryView
    extends MapBackedView {
        EntryView() {
            super(THashMap.this);
        }

        @Override
        public final Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(this, THashMap.this);
        }

        final class EntryIterator
        extends THashIterator<Map.Entry<K, V>> {
            private /* synthetic */ EntryView this$1;

            EntryIterator(EntryView entryView, THashMap<K, V> map) {
                this.this$1 = entryView;
                super(map);
            }
        }
    }

    /*
     * Signature claims super is com.squareup.haha.trove.THashMap$com.squareup.haha.trove.THashMap$MapBackedView<V>, not com.squareup.haha.trove.THashMap$MapBackedView - discarding signature.
     */
    public final class ValueView
    extends MapBackedView {
        protected ValueView() {
            super(THashMap.this);
        }

        @Override
        public final Iterator<V> iterator() {
            return new THashIterator<V>(this, THashMap.this){
                private /* synthetic */ ValueView this$1;
                {
                    this.this$1 = valueView;
                    super(x0);
                }

                @Override
                protected final V objectAtIndex(int index) {
                    return this.this$1.THashMap.this._values[index];
                }
            };
        }

        public final boolean containsElement(V value) {
            return THashMap.this.containsValue(value);
        }

        public final boolean removeElement(V value) {
            boolean changed = false;
            V[] values = THashMap.this._values;
            Object[] set = THashMap.this._set;
            int i = values.length;
            while (i-- > 0) {
                if ((set[i] == null || set[i] == TObjectHash.REMOVED || value != values[i]) && (null == values[i] || !values[i].equals(value))) continue;
                THashMap.this.removeAt(i);
                changed = true;
            }
            return changed;
        }
    }

    static final class EqProcedure<K, V>
    implements TObjectObjectProcedure<K, V> {
        private final Map<K, V> _otherMap;

        EqProcedure(Map<K, V> otherMap) {
            this._otherMap = otherMap;
        }

        @Override
        public final boolean execute(K key, V value) {
            V oValue = this._otherMap.get(key);
            return oValue == value || oValue != null && oValue.equals(value);
        }
    }

    final class HashProcedure
    implements TObjectObjectProcedure<K, V> {
        int h;
        private /* synthetic */ THashMap this$0;

        HashProcedure(THashMap tHashMap) {
            this.this$0 = tHashMap;
        }

        @Override
        public final boolean execute(K key, V value) {
            this.h += this.this$0._hashingStrategy.computeHashCode(key) ^ (value == null ? 0 : value.hashCode());
            return true;
        }
    }
}

