/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.dynamite.client;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.IBinder;
import com.google.vr.dynamite.client.ILoadedInstanceCreator;
import com.google.vr.dynamite.client.LoaderException;
import com.google.vr.dynamite.client.TargetLibraryInfo;
import java.lang.reflect.InvocationTargetException;

class RemoteLibraryLoader {
    private static final String TAG = "RemoteLibraryLoader";
    private static final String CREATOR_NAME = "com.google.vr.dynamite.LoadedInstanceCreator";
    private Context remoteContext;
    private ILoadedInstanceCreator creator;
    private final TargetLibraryInfo targetLibrary;

    public RemoteLibraryLoader(TargetLibraryInfo targetLibrary) {
        this.targetLibrary = targetLibrary;
    }

    public synchronized ILoadedInstanceCreator getRemoteCreator(Context context) throws LoaderException {
        if (this.creator == null) {
            ClassLoader remoteClassLoader = this.getRemoteContext(context).getClassLoader();
            IBinder binder = RemoteLibraryLoader.newBinderInstance(remoteClassLoader, CREATOR_NAME);
            this.creator = ILoadedInstanceCreator.Stub.asInterface(binder);
        }
        return this.creator;
    }

    public synchronized Context getRemoteContext(Context context) throws LoaderException {
        if (this.remoteContext == null) {
            try {
                this.remoteContext = context.createPackageContext(this.targetLibrary.getRemotePackageName(), 3);
            }
            catch (PackageManager.NameNotFoundException e) {
                throw new LoaderException(1);
            }
        }
        return this.remoteContext;
    }

    private static IBinder newBinderInstance(ClassLoader classLoader, String className) {
        try {
            Class<?> clazz = classLoader.loadClass(className);
            return (IBinder)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            String string = String.valueOf(className);
            throw new IllegalStateException(string.length() != 0 ? "No constructor for dynamic class ".concat(string) : new String("No constructor for dynamic class "));
        }
        catch (InvocationTargetException e) {
            String string = String.valueOf(className);
            throw new IllegalStateException(string.length() != 0 ? "Unable to invoke constructor of dynamic class ".concat(string) : new String("Unable to invoke constructor of dynamic class "));
        }
        catch (ClassNotFoundException e) {
            String string = String.valueOf(className);
            throw new IllegalStateException(string.length() != 0 ? "Unable to find dynamic class ".concat(string) : new String("Unable to find dynamic class "));
        }
        catch (InstantiationException e) {
            String string = String.valueOf(className);
            throw new IllegalStateException(string.length() != 0 ? "Unable to instantiate the remote class ".concat(string) : new String("Unable to instantiate the remote class "));
        }
        catch (IllegalAccessException e) {
            String string = String.valueOf(className);
            throw new IllegalStateException(string.length() != 0 ? "Unable to call the default constructor of ".concat(string) : new String("Unable to call the default constructor of "));
        }
    }
}

