/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the QtCore module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

/* This file is autogenerated from the Unicode 8.0 database. Do not edit */

#include "qunicodetables_p.h"

QT_BEGIN_NAMESPACE

namespace QUnicodeTables {

static const unsigned short uc_property_trie[] = {
    // [0x0..0x11000)

    6256, 6288, 6320, 6352, 6384, 6416, 6448, 6480,
    6512, 6544, 6576, 6608, 6640, 6672, 6704, 6736,
    6768, 6800, 6832, 6864, 6896, 6928, 6960, 6992,
    7024, 7056, 7088, 7120, 7152, 7184, 7216, 7248,
    7280, 7312, 7344, 7376, 7408, 7440, 7472, 7504,
    7536, 7568, 7600, 7632, 7664, 7696, 7728, 7760,
    7792, 7824, 7856, 7888, 7920, 7952, 7984, 8016,
    8048, 8080, 8112, 8144, 8176, 8208, 8240, 8272,
    8304, 8336, 8368, 8400, 8400, 8432, 8464, 8496,
    8528, 8560, 8592, 8624, 8656, 8688, 8720, 8752,
    8784, 8816, 8848, 8880, 8912, 8944, 8976, 9008,
    9040, 9072, 9104, 9136, 9168, 9200, 9232, 9264,
    9296, 9328, 9360, 9392, 9424, 9456, 9488, 9520,
    9552, 9584, 9616, 9648, 9680, 9712, 9744, 9776,
    9808, 9840, 9872, 9904, 9936, 9968, 10000, 9904,
    10032, 10064, 10096, 10128, 10160, 10192, 10224, 9904,

    10256, 10288, 10320, 10352, 10384, 10416, 10448, 10480,
    10512, 10512, 10544, 10576, 10608, 10640, 10672, 10704,
    10736, 10768, 10800, 10768, 10832, 10864, 10896, 10928,
    10960, 10768, 10992, 11024, 11056, 11088, 11120, 11152,
    11184, 11216, 11216, 11216, 11216, 11216, 11216, 11216,
    11216, 11216, 11216, 11216, 11216, 11216, 11216, 11216,
    11216, 11216, 11216, 11248, 11280, 11312, 11312, 11344,
    11376, 11408, 11440, 11472, 11504, 11536, 11568, 11600,
    11632, 11664, 11696, 11728, 11760, 11792, 11824, 11856,
    11888, 11920, 11952, 11984, 12016, 12048, 12080, 12112,
    12144, 12176, 12208, 12240, 12272, 12304, 9904, 9904,
    12336, 12368, 12400, 12432, 12464, 12496, 12528, 12560,
    12592, 12624, 12656, 12688, 9904, 9904, 12720, 12752,
    12784, 12816, 12848, 12880, 12912, 12944, 12976, 13008,
    13040, 13040, 13040, 13040, 13072, 13040, 13040, 13104,
    13136, 13168, 13200, 13232, 13264, 13296, 13328, 13360,

    13392, 13424, 13456, 13488, 13520, 13552, 13584, 13616,
    13648, 13680, 13712, 13744, 13776, 13808, 13840, 13872,
    13904, 13936, 13968, 14000, 14032, 14064, 14096, 14128,
    14160, 14192, 14224, 14256, 14288, 14320, 14352, 14384,
    14416, 14448, 14480, 14512, 14544, 14576, 14608, 14640,
    14416, 14416, 14416, 14416, 14672, 14704, 14736, 14768,
    14800, 14832, 14416, 14864, 14896, 14928, 14960, 14992,
    15024, 15056, 15088, 15120, 15152, 15184, 15216, 15248,
    15280, 15280, 15280, 15280, 15280, 15280, 15280, 15280,
    15312, 15312, 15312, 15312, 15344, 15376, 15408, 15440,
    15472, 15504, 15312, 15536, 15568, 15600, 15632, 15664,
    15696, 15728, 15760, 15792, 15824, 15856, 15888, 15920,
    15952, 15984, 16016, 16048, 16080, 16080, 16080, 16112,
    16144, 16176, 16208, 16240, 16272, 16304, 16304, 16336,
    16368, 16400, 16432, 9904, 16464, 16496, 16496, 16528,
    16560, 16560, 16560, 16560, 16560, 16560, 16592, 16624,

    16656, 16688, 16720, 16752, 16784, 16816, 16848, 16880,
    16912, 16944, 16976, 16976, 17008, 17040, 17072, 17104,
    17136, 17168, 17200, 17232, 17168, 17264, 17296, 17328,
    17360, 17360, 17392, 17424, 17456, 17456, 17488, 17520,
    17552, 17552, 17552, 17552, 17552, 17552, 17552, 17552,
    17552, 17552, 17552, 17552, 17552, 17552, 17552, 17552,
    17552, 17552, 17552, 17552, 17552, 17552, 17552, 17552,
    17552, 17552, 17552, 17552, 17552, 17552, 17552, 17552,
    17552, 17552, 17552, 17552, 17552, 17552, 17552, 17552,
    17552, 17552, 17552, 17552, 17552, 17552, 17552, 17552,
    17552, 17552, 17552, 17552, 17552, 17552, 17552, 17552,
    17552, 17552, 17552, 17552, 17552, 17552, 17552, 17552,
    17552, 17552, 17552, 17552, 17552, 17552, 17552, 17552,
    17552, 17552, 17552, 17552, 17552, 17552, 17552, 17552,
    17552, 17552, 17552, 17552, 17552, 17552, 17552, 17552,
    17552, 17552, 17552, 17552, 17552, 17552, 17552, 17552,

    17552, 17552, 17552, 17552, 17552, 17552, 17552, 17552,
    17552, 17552, 17552, 17552, 17552, 17552, 17552, 17552,
    17552, 17552, 17552, 17552, 17552, 17552, 17552, 17552,
    17552, 17552, 17552, 17552, 17552, 17552, 17552, 17552,
    17552, 17552, 17552, 17552, 17552, 17552, 17552, 17552,
    17552, 17552, 17552, 17552, 17552, 17552, 17552, 17552,
    17552, 17552, 17552, 17552, 17552, 17552, 17552, 17552,
    17552, 17552, 17552, 17552, 17552, 17552, 17552, 17552,
    17552, 17552, 17552, 17552, 17552, 17552, 17552, 17552,
    17552, 17552, 17552, 17552, 17552, 17552, 17552, 17552,
    17552, 17552, 17552, 17552, 17552, 17552, 17552, 17552,
    17552, 17552, 17552, 17552, 17552, 17552, 17552, 17552,
    17552, 17552, 17552, 17552, 17552, 17552, 17552, 17552,
    17552, 17552, 17552, 17552, 17552, 17584, 17616, 17616,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,

    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,

    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,

    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,

    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,

    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17648, 17648, 17648,
    17648, 17648, 17648, 17648, 17648, 17680, 17712, 17744,

    17776, 17808, 17808, 17808, 17808, 17808, 17808, 17808,
    17808, 17808, 17808, 17808, 17808, 17808, 17808, 17808,
    17808, 17808, 17808, 17808, 17808, 17808, 17808, 17808,
    17808, 17808, 17808, 17808, 17808, 17808, 17808, 17808,
    17808, 17808, 17808, 17808, 17840, 17872, 17904, 17936,
    17968, 17968, 17968, 17968, 17968, 17968, 17968, 17968,
    18000, 18032, 18064, 18096, 18128, 18160, 18160, 18192,
    18224, 18256, 18288, 18320, 18352, 18384, 9904, 18416,
    18448, 18480, 18512, 18544, 18576, 18608, 18640, 18672,
    18704, 18736, 18768, 18800, 18832, 18864, 18896, 18928,
    18960, 18992, 19024, 19056, 19088, 19120, 19152, 19184,
    19216, 19248, 19280, 19312, 19344, 19376, 19408, 19440,
    19472, 19504, 19536, 19568, 19600, 19632, 19664, 19472,
    19504, 19536, 19568, 19600, 19632, 19664, 19472, 19504,
    19536, 19568, 19600, 19632, 19664, 19472, 19504, 19536,
    19568, 19600, 19632, 19664, 19472, 19504, 19536, 19568,

    19600, 19632, 19664, 19472, 19504, 19536, 19568, 19600,
    19632, 19664, 19472, 19504, 19536, 19568, 19600, 19632,
    19664, 19472, 19504, 19536, 19568, 19600, 19632, 19664,
    19472, 19504, 19536, 19568, 19600, 19632, 19664, 19472,
    19504, 19536, 19568, 19600, 19632, 19664, 19472, 19504,
    19536, 19568, 19600, 19632, 19664, 19472, 19504, 19536,
    19568, 19600, 19632, 19664, 19472, 19504, 19536, 19568,
    19600, 19632, 19664, 19472, 19504, 19536, 19568, 19600,
    19632, 19664, 19472, 19504, 19536, 19568, 19600, 19632,
    19664, 19472, 19504, 19536, 19568, 19600, 19632, 19664,
    19472, 19504, 19536, 19568, 19600, 19632, 19664, 19472,
    19504, 19536, 19568, 19600, 19632, 19664, 19472, 19504,
    19536, 19568, 19600, 19632, 19664, 19472, 19504, 19536,
    19568, 19600, 19632, 19664, 19472, 19504, 19536, 19568,
    19600, 19632, 19664, 19472, 19504, 19536, 19568, 19600,
    19632, 19664, 19472, 19504, 19536, 19568, 19600, 19632,

    19664, 19472, 19504, 19536, 19568, 19600, 19632, 19664,
    19472, 19504, 19536, 19568, 19600, 19632, 19664, 19472,
    19504, 19536, 19568, 19600, 19632, 19664, 19472, 19504,
    19536, 19568, 19600, 19632, 19664, 19472, 19504, 19536,
    19568, 19600, 19632, 19664, 19472, 19504, 19536, 19568,
    19600, 19632, 19664, 19472, 19504, 19536, 19568, 19600,
    19632, 19664, 19472, 19504, 19536, 19568, 19600, 19632,
    19664, 19472, 19504, 19536, 19568, 19600, 19632, 19664,
    19472, 19504, 19536, 19568, 19600, 19632, 19664, 19472,
    19504, 19536, 19568, 19600, 19632, 19664, 19472, 19504,
    19536, 19568, 19600, 19632, 19664, 19472, 19504, 19536,
    19568, 19600, 19632, 19664, 19472, 19504, 19536, 19568,
    19600, 19632, 19664, 19472, 19504, 19536, 19568, 19600,
    19632, 19664, 19472, 19504, 19536, 19568, 19600, 19632,
    19664, 19472, 19504, 19536, 19568, 19600, 19632, 19664,
    19472, 19504, 19536, 19568, 19600, 19632, 19664, 19472,

    19504, 19536, 19568, 19600, 19632, 19664, 19472, 19504,
    19536, 19568, 19600, 19632, 19664, 19472, 19504, 19536,
    19568, 19600, 19632, 19664, 19472, 19504, 19536, 19568,
    19600, 19632, 19664, 19472, 19504, 19536, 19568, 19600,
    19632, 19664, 19472, 19504, 19536, 19568, 19600, 19632,
    19664, 19472, 19504, 19536, 19568, 19600, 19632, 19664,
    19472, 19504, 19536, 19568, 19600, 19632, 19664, 19472,
    19504, 19536, 19568, 19600, 19632, 19696, 19728, 19760,
    19792, 19792, 19792, 19792, 19792, 19792, 19792, 19792,
    19792, 19792, 19792, 19792, 19792, 19792, 19792, 19792,
    19792, 19792, 19792, 19792, 19792, 19792, 19792, 19792,
    19792, 19792, 19792, 19792, 19792, 19792, 19792, 19792,
    19792, 19792, 19792, 19792, 19792, 19792, 19792, 19792,
    19792, 19792, 19792, 19792, 19792, 19792, 19792, 19792,
    19792, 19792, 19792, 19792, 19792, 19792, 19792, 19792,
    19792, 19792, 19792, 19792, 19792, 19792, 19792, 19792,

    19824, 19824, 19824, 19824, 19824, 19824, 19824, 19824,
    19824, 19824, 19824, 19824, 19824, 19824, 19824, 19824,
    19824, 19824, 19824, 19824, 19824, 19824, 19824, 19824,
    19824, 19824, 19824, 19824, 19824, 19824, 19824, 19824,
    19824, 19824, 19824, 19824, 19824, 19824, 19824, 19824,
    19824, 19824, 19824, 19824, 19824, 19824, 19824, 19824,
    19824, 19824, 19824, 19824, 19824, 19824, 19824, 19824,
    19824, 19824, 19824, 19824, 19824, 19824, 19824, 19824,
    19824, 19824, 19824, 19824, 19824, 19824, 19824, 19824,
    19824, 19824, 19824, 19824, 19824, 19824, 19824, 19824,
    19824, 19824, 19824, 19824, 19824, 19824, 19824, 19824,
    19824, 19824, 19824, 19824, 19824, 19824, 19824, 19824,
    19824, 19824, 19824, 19824, 19824, 19824, 19824, 19824,
    19824, 19824, 19824, 19824, 19824, 19824, 19824, 19824,
    19824, 19824, 19824, 19824, 19824, 19824, 19824, 19824,
    19824, 19824, 19824, 19824, 19824, 19824, 19824, 19824,

    19824, 19824, 19824, 19824, 19824, 19824, 19824, 19824,
    19824, 19824, 19824, 19824, 19824, 19824, 19824, 19824,
    19824, 19824, 19824, 19824, 19824, 19824, 19824, 19824,
    19824, 19824, 19824, 19824, 19824, 19824, 19824, 19824,
    19824, 19824, 19824, 19824, 19824, 19824, 19824, 19824,
    19824, 19824, 19824, 19824, 19824, 19824, 19824, 19824,
    19824, 19824, 19824, 19824, 19824, 19824, 19824, 19824,
    19824, 19824, 19824, 19824, 19824, 19824, 19824, 19824,
    19824, 19824, 19824, 19824, 19824, 19824, 19824, 19824,
    19856, 19856, 19856, 19856, 19856, 19856, 19856, 19856,
    19888, 19920, 19952, 19984, 20016, 20016, 20048, 17744,
    20080, 20112, 20144, 20176, 20176, 20208, 20240, 20176,
    20176, 20176, 20176, 20176, 20176, 20176, 20176, 20176,
    20176, 20272, 20304, 20176, 20336, 20176, 20368, 20400,
    20432, 20464, 20496, 20528, 20176, 20176, 20176, 20560,
    20592, 20624, 20656, 20688, 20720, 20752, 20784, 20816,

    20848, 20880, 20912, 9904, 20944, 20944, 20944, 20976,
    21008, 21040, 21072, 21104, 21136, 21168, 21200, 21232,
    9904, 9904, 9904, 9904, 21264, 21296, 21328, 21360,
    21392, 21424, 21456, 21488, 21520, 21552, 21584, 9904,
    21616, 21648, 21680, 21712, 21744, 21776, 9904, 9904,
    21808, 21840, 21872, 21904, 9904, 9904, 9904, 9904,
    21936, 21936, 21936, 21936, 21936, 21936, 21936, 21936,
    21936, 21968, 22000, 22032, 9904, 9904, 9904, 9904,
    22064, 22096, 22128, 22160, 22192, 22224, 8400, 22256,
    22288, 22320, 8400, 8400, 22352, 22384, 22416, 22448,
    22480, 22512, 22544, 22576, 22608, 8400, 22640, 22672,
    22704, 22736, 22768, 22800, 22832, 22864, 8400, 8400,
    22896, 22896, 22928, 8400, 22960, 22992, 23024, 23056,
    8400, 8400, 8400, 8400, 8400, 8400, 8400, 8400,
    8400, 8400, 8400, 23088, 8400, 8400, 8400, 8400,
    8400, 8400, 8400, 8400, 8400, 8400, 8400, 8400,

    // [0x11000..0x110000)

    23120, 23376, 23632, 23888, 24144, 24400, 24656, 24912,
    25168, 25424, 25680, 25424, 25424, 25424, 25424, 25424,
    25936, 25936, 25936, 26192, 26448, 26704, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    26960, 26960, 27216, 27472, 27728, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 27984, 28240, 28496, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    28752, 28752, 29008, 29264, 25424, 25424, 25424, 29520,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,

    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    29776, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 30032, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    30288, 30544, 30800, 31056, 31312, 31568, 31824, 32080,
    32336, 32336, 32592, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    32848, 33104, 33104, 33104, 33104, 33104, 33360, 33104,
    33616, 33872, 34128, 34384, 34640, 34896, 35152, 35408,
    35664, 35920, 25424, 25424, 25424, 25424, 25424, 36176,
    36432, 36432, 36432, 36432, 36432, 36432, 36432, 36432,
    36432, 36432, 36432, 36432, 36432, 36432, 36432, 36432,
    36432, 36432, 36432, 36432, 36432, 36432, 36432, 36432,
    36432, 36432, 36432, 36432, 36432, 36432, 36432, 36432,
    36432, 36432, 36432, 36432, 36432, 36432, 36432, 36432,
    36432, 36432, 36432, 36432, 36432, 36432, 36432, 36432,
    36432, 36432, 36432, 36432, 36432, 36432, 36432, 36432,
    36432, 36432, 36432, 36432, 36432, 36432, 36432, 36432,
    36432, 36432, 36432, 36432, 36432, 36432, 36432, 36432,
    36432, 36432, 36432, 36432, 36432, 36432, 36432, 36432,
    36432, 36432, 36432, 36432, 36432, 36432, 36432, 36432,
    36432, 36432, 36432, 36432, 36432, 36432, 36432, 36432,
    36432, 36432, 36432, 36432, 36432, 36432, 36432, 36432,
    36432, 36432, 36432, 36432, 36432, 36432, 36432, 36432,
    36432, 36432, 36432, 36432, 36432, 36432, 36432, 36432,
    36432, 36432, 36432, 36432, 36432, 36432, 36432, 36432,
    36432, 36432, 36432, 36432, 36432, 36432, 36432, 36432,
    36432, 36432, 36432, 36432, 36432, 36432, 36432, 36432,

    36432, 36432, 36432, 36432, 36432, 36432, 36432, 36432,
    36432, 36432, 36432, 36432, 36432, 36432, 36432, 36432,
    36432, 36432, 36432, 36432, 36432, 36432, 36688, 36944,
    36944, 36944, 36944, 36944, 36944, 36944, 36944, 36944,
    36944, 36944, 36944, 36944, 36944, 36944, 36944, 37200,
    37456, 37712, 37712, 37712, 37712, 37712, 37712, 37712,
    37712, 37712, 37712, 37712, 37712, 37712, 37712, 37712,
    37712, 37712, 37712, 37712, 37712, 37712, 37968, 38224,
    38224, 38224, 38224, 38224, 38224, 38224, 38224, 38224,
    38224, 38224, 38224, 38224, 38224, 38224, 38224, 38224,
    38224, 38224, 38224, 38224, 38224, 38224, 38224, 38224,
    38224, 38224, 38224, 38224, 38224, 38224, 38224, 38224,
    38224, 38224, 38224, 38224, 38224, 38224, 38224, 38224,
    38480, 38480, 38736, 38224, 38224, 38224, 38224, 38992,
    38224, 38224, 38224, 38224, 38224, 38224, 38224, 38224,
    38224, 38224, 38224, 38224, 38224, 38224, 38224, 38224,
    38224, 38224, 38224, 38224, 38224, 38224, 38224, 38224,
    38224, 38224, 38224, 38224, 38224, 38224, 38224, 38224,
    38224, 38224, 38224, 38224, 38224, 38224, 38224, 38224,
    38224, 38224, 38224, 38224, 38224, 38224, 38224, 38224,
    38224, 38224, 38224, 38224, 38224, 38224, 38224, 38224,
    38224, 38224, 38224, 38224, 38224, 38224, 38224, 38224,
    38224, 38224, 38224, 38224, 38224, 38224, 38224, 38224,
    38224, 38224, 38224, 38224, 38224, 38224, 38224, 38224,
    38224, 38224, 38224, 38224, 38224, 38224, 38224, 38224,
    38224, 38224, 38224, 38224, 38224, 38224, 38224, 38224,
    38224, 38224, 38224, 38224, 38224, 38224, 38224, 38224,
    38224, 38224, 38224, 38224, 38224, 38224, 38224, 38224,
    38224, 38224, 38224, 38224, 38224, 38224, 38224, 38224,
    38224, 38224, 38224, 38224, 38224, 38224, 38224, 38224,
    38224, 38224, 38224, 38224, 38224, 38224, 38224, 38224,
    38224, 38224, 38224, 38224, 38224, 38224, 38224, 38224,

    38224, 38224, 38224, 38224, 38224, 38224, 38224, 38224,
    38224, 38224, 38224, 38224, 38224, 38224, 38224, 38224,
    38224, 38224, 38224, 38224, 38224, 38224, 38224, 38224,
    38224, 38224, 38224, 38224, 38224, 38224, 38224, 38224,
    38224, 38224, 38224, 38224, 38224, 38224, 38224, 38224,
    38224, 38224, 38224, 38224, 38224, 38224, 38224, 38224,
    38224, 38224, 38224, 38224, 38224, 38224, 38224, 38224,
    38224, 38224, 38224, 38224, 38224, 38224, 38224, 38224,
    38224, 38224, 38224, 38224, 38224, 38224, 38224, 38224,
    38224, 38224, 38224, 38224, 38224, 38224, 38224, 38224,
    38224, 38224, 38224, 38224, 38224, 38224, 38224, 38224,
    38224, 38224, 38224, 38224, 38224, 38224, 38224, 38224,
    38224, 38224, 38224, 38224, 38224, 38224, 38224, 38224,
    38224, 38224, 38224, 38224, 38224, 38224, 38224, 38992,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,

    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 36176,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,

    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 36176,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,

    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 36176,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,

    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 36176,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,

    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 36176,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,

    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 36176,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,

    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 36176,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,

    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 36176,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,

    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 36176,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,

    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 36176,
    39248, 39504, 39760, 39760, 39760, 39760, 39760, 39760,
    39760, 39760, 39760, 39760, 39760, 39760, 39760, 39760,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,

    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 25424,
    25424, 25424, 25424, 25424, 25424, 25424, 25424, 36176,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,

    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40272,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,

    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40016,
    40016, 40016, 40016, 40016, 40016, 40016, 40016, 40272,


    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1, 2, 3, 4, 5, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 6, 6, 6, 7,

    8, 9, 10, 11, 12, 13, 14, 15,
    16, 17, 14, 18, 19, 20, 21, 22,
    23, 24, 25, 26, 27, 28, 29, 30,
    31, 32, 33, 34, 35, 36, 37, 9,

    14, 38, 38, 38, 38, 38, 38, 38,
    38, 38, 38, 38, 38, 38, 38, 38,
    38, 38, 38, 38, 38, 38, 38, 38,
    38, 38, 38, 39, 40, 41, 42, 43,

    42, 44, 44, 44, 44, 44, 44, 44,
    44, 44, 44, 44, 44, 44, 44, 44,
    44, 44, 44, 44, 44, 44, 44, 44,
    44, 44, 44, 39, 45, 46, 36, 0,

    0, 0, 0, 0, 0, 47, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,

    48, 49, 50, 12, 12, 12, 51, 14,
    52, 51, 53, 54, 36, 55, 51, 52,
    56, 57, 58, 59, 60, 61, 14, 62,
    52, 63, 53, 64, 65, 65, 65, 49,

    66, 66, 66, 66, 66, 66, 38, 66,
    66, 66, 66, 66, 66, 66, 66, 66,
    38, 66, 66, 66, 66, 66, 66, 36,
    38, 66, 66, 66, 66, 66, 38, 67,

    68, 68, 68, 68, 68, 68, 44, 68,
    68, 68, 68, 68, 68, 68, 68, 68,
    44, 68, 68, 68, 68, 68, 68, 36,
    44, 68, 68, 68, 68, 68, 44, 69,

    70, 71, 70, 71, 70, 71, 70, 71,
    70, 71, 70, 71, 70, 71, 70, 71,
    72, 73, 70, 71, 70, 71, 70, 71,
    70, 71, 70, 71, 70, 71, 70, 71,

    70, 71, 70, 71, 70, 71, 72, 73,
    70, 71, 70, 71, 70, 71, 70, 71,
    74, 75, 76, 77, 70, 71, 70, 71,
    78, 70, 71, 70, 71, 70, 71, 76,

    77, 72, 73, 70, 71, 70, 71, 70,
    71, 79, 72, 73, 70, 71, 70, 71,
    70, 71, 72, 73, 70, 71, 70, 71,
    70, 71, 70, 71, 70, 71, 70, 71,

    70, 71, 70, 71, 70, 71, 72, 73,
    70, 71, 70, 71, 70, 71, 70, 71,
    70, 71, 70, 71, 70, 71, 70, 71,
    80, 70, 71, 70, 71, 70, 71, 81,

    82, 83, 72, 73, 72, 73, 84, 72,
    73, 85, 85, 72, 73, 78, 86, 87,
    88, 72, 73, 85, 89, 90, 91, 92,
    72, 73, 93, 78, 91, 94, 95, 96,

    70, 71, 72, 73, 72, 73, 97, 72,
    73, 97, 78, 78, 72, 73, 97, 70,
    71, 98, 98, 72, 73, 72, 73, 99,
    72, 73, 78, 100, 72, 73, 78, 101,

    100, 100, 100, 100, 102, 103, 104, 102,
    103, 104, 102, 103, 104, 70, 71, 70,
    71, 70, 71, 70, 71, 70, 71, 70,
    71, 70, 71, 70, 71, 105, 70, 71,

    70, 71, 70, 71, 72, 73, 70, 71,
    70, 71, 70, 71, 70, 71, 70, 71,
    106, 102, 103, 104, 70, 71, 107, 108,
    109, 110, 70, 71, 70, 71, 70, 71,

    70, 71, 70, 71, 70, 71, 70, 71,
    70, 71, 70, 71, 70, 71, 70, 71,
    70, 71, 70, 71, 70, 71, 70, 71,
    109, 110, 109, 110, 111, 112, 109, 110,

    113, 114, 111, 112, 111, 112, 109, 110,
    109, 110, 109, 110, 109, 110, 109, 110,
    109, 110, 109, 110, 114, 114, 114, 115,
    115, 115, 116, 117, 118, 119, 120, 121,

    122, 117, 123, 124, 125, 126, 127, 123,
    127, 123, 127, 123, 127, 123, 127, 123,
    128, 129, 130, 131, 132, 78, 133, 133,
    78, 134, 78, 135, 136, 78, 78, 78,

    133, 137, 78, 138, 78, 139, 140, 78,
    141, 142, 78, 143, 144, 78, 78, 142,
    78, 145, 146, 78, 78, 147, 78, 78,
    78, 78, 78, 78, 78, 148, 78, 78,

    149, 78, 78, 149, 78, 78, 78, 150,
    149, 151, 152, 152, 153, 78, 78, 78,
    78, 78, 154, 78, 100, 78, 78, 78,
    78, 78, 78, 78, 78, 155, 156, 78,

    78, 78, 78, 78, 78, 78, 78, 78,
    78, 157, 157, 157, 157, 157, 114, 114,
    158, 158, 158, 158, 158, 158, 158, 158,
    158, 159, 159, 160, 160, 160, 160, 160,

    161, 161, 42, 42, 42, 42, 159, 159,
    162, 159, 159, 159, 162, 159, 159, 159,
    160, 160, 42, 42, 42, 42, 42, 163,
    52, 52, 52, 52, 52, 52, 42, 164,

    158, 158, 158, 158, 158, 42, 42, 42,
    42, 42, 165, 165, 166, 167, 168, 169,
    169, 169, 169, 169, 169, 169, 169, 169,
    169, 169, 169, 169, 169, 169, 169, 169,

    170, 170, 170, 170, 170, 171, 170, 170,
    170, 170, 170, 170, 170, 171, 171, 170,
    171, 170, 171, 170, 170, 172, 173, 173,
    173, 173, 172, 174, 173, 173, 173, 173,

    173, 175, 175, 176, 176, 176, 176, 177,
    177, 173, 173, 173, 173, 176, 176, 173,
    176, 176, 173, 173, 178, 178, 178, 178,
    179, 173, 173, 173, 173, 171, 171, 171,

    180, 180, 170, 180, 180, 181, 182, 183,
    183, 183, 182, 182, 182, 183, 183, 184,
    185, 185, 185, 186, 186, 186, 186, 185,
    187, 188, 188, 189, 190, 191, 191, 192,

    193, 193, 194, 195, 195, 195, 195, 195,
    195, 195, 195, 195, 195, 195, 195, 195,
    196, 197, 196, 197, 198, 199, 196, 197,
    200, 200, 201, 202, 202, 202, 203, 204,

    200, 200, 200, 200, 205, 206, 207, 208,
    209, 209, 209, 200, 210, 200, 211, 211,
    212, 213, 213, 213, 213, 213, 213, 213,
    213, 213, 213, 213, 213, 213, 213, 213,

    213, 213, 200, 213, 213, 213, 213, 213,
    213, 213, 214, 214, 215, 216, 216, 216,
    217, 218, 218, 218, 218, 218, 218, 218,
    218, 218, 218, 218, 218, 218, 218, 218,

    218, 218, 219, 218, 218, 218, 218, 218,
    218, 218, 220, 220, 221, 222, 222, 223,
    224, 225, 226, 227, 227, 228, 229, 230,
    231, 232, 233, 234, 233, 234, 233, 234,

    233, 234, 235, 236, 235, 236, 235, 236,
    235, 236, 235, 236, 235, 236, 235, 236,
    237, 238, 239, 240, 241, 242, 243, 244,
    245, 246, 244, 245, 247, 248, 248, 248,

    249, 250, 251, 250, 251, 251, 251, 250,
    251, 251, 251, 251, 250, 249, 250, 251,
    252, 252, 252, 252, 252, 252, 252, 252,
    252, 253, 252, 252, 252, 252, 252, 252,

    252, 252, 252, 252, 252, 252, 252, 252,
    252, 252, 252, 252, 252, 252, 252, 252,
    254, 254, 254, 254, 254, 254, 254, 254,
    254, 255, 254, 254, 254, 254, 254, 254,

    254, 254, 254, 254, 254, 254, 254, 254,
    254, 254, 254, 254, 254, 254, 254, 254,
    256, 257, 258, 257, 258, 258, 258, 257,
    258, 258, 258, 258, 257, 256, 257, 258,

    259, 260, 259, 260, 259, 260, 259, 260,
    259, 260, 259, 260, 259, 260, 259, 260,
    259, 260, 259, 260, 259, 260, 261, 262,
    259, 260, 259, 260, 259, 260, 259, 260,

    259, 260, 263, 264, 264, 171, 171, 265,
    266, 266, 267, 268, 269, 270, 269, 270,
    259, 260, 259, 260, 259, 260, 259, 260,
    259, 260, 259, 260, 259, 260, 259, 260,

    259, 260, 259, 260, 259, 260, 259, 260,
    259, 260, 259, 260, 259, 260, 259, 260,
    259, 260, 259, 260, 259, 260, 259, 260,
    259, 260, 259, 260, 259, 260, 259, 260,

    271, 261, 262, 259, 260, 267, 268, 259,
    260, 267, 268, 259, 260, 267, 268, 272,
    261, 262, 261, 262, 259, 260, 261, 262,
    259, 260, 261, 262, 261, 262, 261, 262,

    259, 260, 261, 262, 261, 262, 261, 262,
    259, 260, 261, 262, 273, 274, 261, 262,
    261, 262, 261, 262, 261, 262, 275, 276,
    261, 262, 277, 278, 277, 278, 277, 278,

    267, 268, 267, 268, 267, 268, 267, 268,
    267, 268, 267, 268, 267, 268, 267, 268,
    277, 278, 277, 278, 279, 280, 279, 280,
    279, 280, 279, 280, 279, 280, 279, 280,

    279, 280, 279, 280, 281, 282, 283, 284,
    285, 286, 285, 286, 285, 286, 285, 286,
    200, 287, 287, 287, 287, 287, 287, 287,
    287, 287, 287, 287, 287, 287, 287, 287,

    287, 287, 287, 287, 287, 287, 287, 287,
    287, 287, 287, 287, 287, 287, 287, 287,
    287, 287, 287, 287, 287, 287, 287, 200,
    200, 288, 289, 289, 289, 290, 289, 289,

    200, 291, 291, 291, 291, 291, 291, 291,
    291, 291, 291, 291, 291, 291, 291, 291,
    291, 291, 291, 291, 291, 291, 291, 291,
    291, 291, 291, 291, 291, 291, 291, 291,

    291, 291, 291, 291, 291, 291, 291, 292,
    200, 293, 294, 200, 200, 295, 295, 296,
    297, 298, 299, 299, 299, 299, 298, 299,
    299, 299, 300, 298, 299, 299, 299, 299,

    299, 299, 301, 298, 298, 298, 298, 298,
    299, 299, 298, 299, 299, 300, 302, 299,
    303, 304, 305, 306, 307, 308, 309, 310,
    311, 312, 313, 314, 315, 316, 317, 318,

    319, 320, 321, 319, 299, 301, 322, 323,
    297, 297, 297, 297, 297, 297, 297, 297,
    324, 324, 324, 324, 324, 324, 324, 324,
    324, 324, 324, 324, 324, 324, 324, 324,

    324, 324, 324, 324, 324, 324, 324, 324,
    324, 324, 324, 297, 297, 297, 297, 297,
    324, 324, 324, 325, 326, 297, 297, 297,
    297, 297, 297, 297, 297, 297, 297, 297,

    327, 327, 327, 327, 328, 329, 330, 330,
    331, 332, 332, 333, 19, 334, 335, 335,
    336, 336, 336, 336, 336, 336, 337, 337,
    338, 339, 340, 341, 342, 343, 344, 345,

    346, 347, 348, 348, 348, 348, 349, 350,
    351, 350, 351, 351, 351, 351, 351, 350,
    350, 350, 350, 351, 351, 351, 351, 351,
    351, 351, 351, 352, 352, 352, 352, 352,

    353, 351, 351, 351, 351, 351, 351, 351,
    350, 351, 351, 354, 355, 356, 357, 358,
    359, 360, 361, 362, 362, 363, 364, 336,
    336, 365, 365, 365, 366, 365, 365, 367,

    368, 369, 370, 371, 372, 373, 374, 375,
    376, 377, 378, 379, 380, 381, 382, 382,
    383, 350, 350, 350, 347, 384, 384, 384,
    385, 351, 351, 351, 351, 351, 351, 351,

    351, 351, 351, 351, 351, 351, 351, 351,
    350, 350, 350, 350, 350, 350, 350, 350,
    350, 350, 350, 350, 350, 350, 350, 350,
    350, 350, 351, 351, 351, 351, 351, 351,

    351, 351, 351, 351, 351, 351, 351, 351,
    351, 351, 351, 351, 351, 351, 351, 351,
    351, 351, 351, 351, 351, 351, 351, 351,
    386, 386, 351, 351, 351, 351, 351, 386,

    348, 351, 349, 350, 350, 350, 350, 350,
    350, 350, 350, 350, 351, 350, 351, 387,
    351, 351, 350, 348, 388, 350, 389, 389,
    389, 389, 389, 389, 389, 390, 391, 389,

    389, 389, 389, 392, 389, 393, 393, 389,
    389, 391, 392, 389, 389, 392, 394, 394,
    395, 396, 397, 398, 399, 400, 401, 402,
    403, 404, 386, 386, 386, 405, 405, 406,

    407, 407, 407, 408, 408, 408, 408, 408,
    408, 408, 408, 408, 408, 408, 343, 409,
    410, 411, 412, 412, 412, 410, 410, 410,
    410, 410, 412, 412, 412, 412, 410, 412,

    412, 412, 412, 412, 412, 412, 412, 412,
    410, 412, 410, 412, 410, 413, 413, 414,
    415, 416, 415, 415, 416, 415, 415, 416,
    416, 416, 415, 416, 416, 415, 416, 415,

    415, 415, 416, 415, 416, 415, 416, 415,
    416, 415, 415, 343, 343, 414, 413, 413,
    417, 417, 417, 417, 417, 417, 417, 417,
    417, 418, 418, 418, 417, 417, 417, 417,

    417, 417, 417, 417, 417, 417, 417, 417,
    417, 417, 417, 418, 418, 417, 352, 352,
    352, 419, 352, 419, 419, 352, 352, 352,
    419, 419, 352, 352, 352, 352, 352, 352,

    420, 420, 420, 420, 420, 420, 420, 420,
    420, 420, 420, 420, 420, 420, 420, 420,
    420, 420, 420, 420, 420, 420, 420, 420,
    420, 420, 420, 420, 420, 420, 420, 420,

    420, 420, 420, 420, 420, 420, 421, 421,
    421, 421, 421, 421, 421, 421, 421, 421,
    421, 422, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343,

    423, 424, 425, 426, 427, 428, 429, 430,
    431, 432, 433, 433, 433, 433, 433, 433,
    433, 433, 433, 433, 433, 433, 433, 433,
    433, 433, 433, 433, 433, 433, 433, 433,

    433, 433, 433, 433, 433, 433, 433, 433,
    433, 433, 433, 434, 434, 434, 434, 434,
    434, 434, 435, 434, 436, 436, 437, 438,
    439, 440, 441, 297, 297, 297, 297, 297,

    442, 442, 442, 442, 442, 442, 442, 442,
    442, 442, 442, 442, 442, 442, 442, 442,
    442, 442, 442, 442, 442, 442, 443, 443,
    443, 443, 444, 443, 443, 443, 443, 443,

    443, 443, 443, 443, 444, 443, 443, 443,
    444, 443, 443, 443, 443, 443, 297, 297,
    445, 445, 445, 445, 445, 445, 445, 445,
    445, 445, 445, 445, 445, 445, 445, 297,

    446, 447, 447, 447, 447, 447, 446, 446,
    447, 446, 447, 447, 447, 447, 447, 447,
    447, 447, 447, 447, 446, 447, 448, 448,
    448, 449, 449, 449, 297, 297, 450, 297,

    297, 297, 297, 297, 297, 297, 297, 297,
    297, 297, 297, 297, 297, 297, 297, 297,
    297, 297, 297, 297, 297, 297, 297, 297,
    297, 297, 297, 297, 297, 297, 297, 297,

    451, 452, 451, 451, 451, 451, 451, 451,
    451, 451, 453, 453, 453, 454, 455, 452,
    452, 455, 455, 456, 456, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343,

    343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343,

    343, 343, 343, 457, 458, 458, 459, 458,
    458, 459, 458, 458, 458, 459, 459, 459,
    460, 461, 462, 458, 458, 458, 459, 458,
    458, 459, 459, 458, 458, 458, 458, 463,

    464, 465, 465, 466, 467, 468, 468, 468,
    468, 468, 468, 468, 468, 468, 468, 468,
    468, 468, 468, 468, 468, 468, 468, 468,
    468, 468, 468, 468, 468, 468, 468, 468,

    468, 468, 468, 468, 468, 468, 468, 468,
    468, 469, 468, 468, 468, 468, 468, 468,
    468, 469, 468, 468, 469, 468, 468, 468,
    468, 468, 470, 471, 472, 468, 466, 466,

    466, 465, 465, 465, 465, 465, 465, 465,
    465, 466, 466, 466, 466, 473, 474, 471,
    468, 171, 173, 475, 475, 464, 470, 470,
    476, 476, 476, 476, 476, 476, 476, 476,

    468, 468, 465, 465, 477, 477, 478, 479,
    480, 481, 482, 483, 484, 485, 486, 487,
    488, 489, 490, 491, 491, 491, 491, 491,
    492, 493, 493, 494, 494, 495, 494, 494,

    496, 497, 498, 498, 200, 499, 499, 499,
    499, 499, 499, 499, 499, 200, 200, 499,
    499, 200, 200, 499, 499, 499, 499, 499,
    499, 499, 499, 499, 499, 499, 499, 499,

    499, 499, 499, 499, 499, 499, 499, 499,
    499, 200, 499, 499, 499, 499, 499, 499,
    499, 200, 499, 200, 200, 200, 499, 499,
    499, 499, 200, 200, 500, 501, 502, 498,

    498, 497, 497, 497, 497, 200, 200, 498,
    498, 200, 200, 503, 503, 504, 505, 200,
    200, 200, 200, 200, 200, 200, 200, 502,
    200, 200, 200, 200, 506, 506, 200, 506,

    499, 499, 497, 497, 200, 200, 507, 508,
    509, 510, 511, 512, 513, 514, 515, 516,
    499, 499, 517, 517, 518, 518, 518, 518,
    518, 519, 520, 521, 200, 200, 200, 200,

    200, 522, 523, 524, 200, 525, 525, 525,
    525, 525, 525, 200, 200, 200, 200, 525,
    525, 200, 200, 525, 525, 525, 525, 525,
    525, 525, 525, 525, 525, 525, 525, 525,

    525, 525, 525, 525, 525, 525, 525, 525,
    525, 200, 525, 525, 525, 525, 525, 525,
    525, 200, 525, 526, 200, 525, 526, 200,
    525, 525, 200, 200, 527, 200, 528, 528,

    528, 523, 523, 200, 200, 200, 200, 523,
    523, 200, 200, 523, 523, 529, 200, 200,
    200, 530, 200, 200, 200, 200, 200, 200,
    200, 526, 526, 526, 525, 200, 526, 200,

    200, 200, 200, 200, 200, 200, 531, 532,
    533, 534, 535, 536, 537, 538, 539, 540,
    523, 523, 525, 525, 525, 530, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    200, 541, 541, 542, 200, 543, 543, 543,
    543, 543, 543, 543, 544, 543, 200, 543,
    543, 543, 200, 543, 543, 543, 543, 543,
    543, 543, 543, 543, 543, 543, 543, 543,

    543, 543, 543, 543, 543, 543, 543, 543,
    543, 200, 543, 543, 543, 543, 543, 543,
    543, 200, 543, 543, 200, 543, 543, 543,
    543, 543, 200, 200, 545, 543, 542, 542,

    542, 541, 541, 541, 541, 541, 200, 541,
    541, 542, 200, 542, 542, 546, 200, 200,
    543, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    543, 544, 547, 547, 200, 200, 548, 549,
    550, 551, 552, 553, 554, 555, 556, 557,
    558, 559, 200, 200, 200, 200, 200, 200,
    200, 560, 200, 200, 200, 200, 200, 200,

    200, 561, 562, 562, 200, 563, 563, 563,
    563, 563, 563, 563, 563, 200, 200, 563,
    563, 200, 200, 563, 563, 563, 563, 563,
    563, 563, 563, 563, 563, 563, 563, 563,

    563, 563, 563, 563, 563, 563, 563, 563,
    563, 200, 563, 563, 563, 563, 563, 563,
    563, 200, 563, 563, 200, 564, 563, 563,
    563, 563, 200, 200, 565, 563, 566, 561,

    562, 561, 561, 561, 567, 200, 200, 562,
    568, 200, 200, 568, 568, 569, 200, 200,
    200, 200, 200, 200, 200, 200, 570, 566,
    200, 200, 200, 200, 571, 571, 200, 563,

    563, 563, 567, 567, 200, 200, 572, 573,
    574, 575, 576, 577, 578, 579, 580, 581,
    582, 564, 583, 583, 583, 583, 583, 583,
    200, 200, 200, 200, 200, 200, 200, 200,

    200, 200, 584, 585, 200, 585, 585, 585,
    585, 585, 585, 200, 200, 200, 585, 585,
    585, 200, 585, 585, 586, 585, 200, 200,
    200, 585, 585, 200, 585, 200, 585, 585,

    200, 200, 200, 585, 585, 200, 200, 200,
    585, 585, 585, 200, 200, 200, 585, 585,
    585, 585, 585, 585, 585, 585, 587, 585,
    585, 585, 200, 200, 200, 200, 588, 589,

    584, 589, 589, 200, 200, 200, 589, 589,
    589, 200, 590, 590, 590, 591, 200, 200,
    592, 200, 200, 200, 200, 200, 200, 588,
    200, 200, 200, 200, 200, 200, 200, 200,

    200, 200, 200, 200, 200, 200, 593, 594,
    595, 596, 597, 598, 599, 600, 601, 602,
    603, 603, 603, 604, 604, 604, 604, 604,
    604, 605, 604, 200, 200, 200, 200, 200,

    606, 607, 607, 607, 200, 608, 608, 608,
    608, 608, 608, 608, 608, 200, 608, 608,
    608, 200, 608, 608, 608, 608, 608, 608,
    608, 608, 608, 608, 608, 608, 608, 608,

    608, 608, 608, 608, 608, 608, 608, 608,
    608, 200, 608, 608, 608, 608, 608, 608,
    608, 608, 608, 608, 609, 608, 608, 608,
    608, 608, 200, 200, 200, 610, 611, 611,

    611, 607, 607, 607, 607, 200, 611, 611,
    612, 200, 611, 611, 611, 613, 200, 200,
    200, 200, 200, 200, 200, 614, 615, 200,
    610, 610, 616, 200, 200, 200, 200, 200,

    608, 608, 617, 617, 200, 200, 618, 619,
    620, 621, 622, 623, 624, 625, 626, 627,
    200, 200, 200, 200, 200, 200, 200, 200,
    628, 628, 628, 628, 628, 628, 628, 629,

    200, 630, 631, 631, 200, 632, 632, 632,
    632, 632, 632, 632, 632, 200, 632, 632,
    632, 200, 632, 632, 632, 632, 632, 632,
    632, 632, 632, 632, 632, 632, 632, 632,

    632, 632, 632, 632, 632, 632, 632, 632,
    632, 200, 632, 632, 632, 632, 632, 632,
    632, 632, 632, 632, 200, 632, 632, 632,
    632, 632, 200, 200, 633, 634, 631, 635,

    636, 631, 637, 631, 631, 200, 635, 636,
    636, 200, 636, 636, 638, 639, 200, 200,
    200, 200, 200, 200, 200, 637, 637, 200,
    200, 200, 200, 200, 200, 200, 632, 200,

    632, 632, 640, 640, 200, 200, 641, 642,
    643, 644, 645, 646, 647, 648, 649, 650,
    200, 651, 651, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    200, 652, 653, 653, 200, 654, 654, 654,
    654, 654, 654, 654, 654, 200, 654, 654,
    654, 200, 654, 654, 654, 654, 654, 654,
    654, 654, 654, 654, 654, 654, 654, 654,

    654, 654, 654, 654, 654, 654, 654, 654,
    654, 655, 654, 654, 654, 654, 654, 654,
    654, 654, 654, 654, 654, 654, 654, 654,
    654, 654, 655, 200, 200, 656, 657, 653,

    653, 658, 658, 658, 659, 200, 653, 653,
    653, 200, 660, 660, 660, 661, 655, 200,
    200, 200, 200, 200, 200, 200, 200, 657,
    200, 200, 200, 200, 200, 200, 200, 662,

    654, 654, 659, 659, 200, 200, 663, 664,
    665, 666, 667, 668, 669, 670, 671, 672,
    673, 673, 673, 673, 673, 673, 200, 200,
    200, 674, 656, 656, 656, 656, 656, 656,

    200, 200, 675, 675, 200, 676, 676, 676,
    676, 676, 676, 676, 676, 676, 676, 676,
    676, 676, 676, 676, 676, 676, 676, 200,
    200, 200, 676, 676, 676, 676, 676, 676,

    676, 676, 676, 676, 676, 676, 676, 676,
    676, 676, 676, 676, 676, 676, 676, 676,
    676, 676, 200, 676, 676, 676, 676, 676,
    676, 676, 676, 676, 200, 676, 200, 200,

    676, 676, 676, 676, 676, 676, 676, 200,
    200, 200, 677, 200, 200, 200, 200, 678,
    675, 675, 679, 679, 679, 200, 679, 200,
    675, 675, 680, 675, 680, 680, 680, 678,

    200, 200, 200, 200, 200, 200, 681, 682,
    683, 684, 685, 686, 687, 688, 689, 690,
    200, 200, 675, 675, 691, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    200, 692, 692, 692, 692, 692, 692, 692,
    692, 692, 692, 692, 692, 692, 692, 692,
    692, 692, 692, 692, 692, 692, 692, 692,
    692, 692, 692, 692, 692, 692, 692, 692,

    692, 692, 692, 692, 692, 692, 692, 692,
    692, 692, 692, 692, 692, 692, 692, 692,
    692, 693, 692, 694, 693, 693, 693, 693,
    695, 695, 696, 200, 200, 200, 200, 12,

    692, 692, 692, 692, 692, 692, 697, 693,
    698, 698, 698, 698, 693, 693, 693, 699,
    700, 701, 702, 703, 704, 705, 706, 707,
    708, 709, 710, 710, 200, 200, 200, 200,

    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    200, 711, 711, 200, 711, 200, 200, 711,
    711, 200, 711, 200, 200, 711, 200, 200,
    200, 200, 200, 200, 711, 711, 711, 711,
    200, 711, 711, 711, 711, 711, 711, 711,

    200, 711, 711, 711, 200, 711, 200, 711,
    200, 200, 711, 711, 200, 711, 711, 711,
    711, 712, 711, 713, 712, 712, 712, 712,
    714, 714, 200, 712, 712, 711, 200, 200,

    711, 711, 711, 711, 711, 200, 715, 200,
    716, 716, 716, 716, 712, 712, 200, 200,
    717, 718, 719, 720, 721, 722, 723, 724,
    725, 726, 200, 200, 727, 727, 728, 728,

    729, 730, 730, 730, 731, 732, 731, 731,
    733, 731, 731, 734, 735, 736, 736, 736,
    736, 736, 733, 737, 736, 737, 737, 737,
    738, 738, 737, 737, 737, 737, 737, 737,

    739, 740, 741, 742, 743, 744, 745, 746,
    747, 748, 749, 749, 749, 749, 749, 749,
    749, 749, 749, 749, 750, 738, 737, 738,
    737, 751, 752, 753, 752, 753, 754, 754,

    729, 729, 729, 755, 729, 729, 729, 729,
    200, 729, 729, 729, 729, 755, 729, 729,
    729, 729, 755, 729, 729, 729, 729, 755,
    729, 729, 729, 729, 755, 729, 729, 729,

    729, 729, 729, 729, 729, 729, 729, 729,
    729, 755, 756, 757, 757, 200, 200, 200,
    200, 758, 759, 760, 761, 760, 760, 762,
    760, 762, 759, 759, 759, 759, 763, 764,

    759, 760, 765, 765, 766, 734, 765, 765,
    729, 729, 729, 729, 767, 768, 768, 768,
    763, 763, 763, 760, 763, 763, 769, 763,
    200, 763, 763, 763, 763, 760, 763, 763,

    763, 763, 760, 763, 763, 763, 763, 760,
    763, 763, 763, 763, 760, 763, 769, 769,
    769, 763, 763, 763, 763, 763, 763, 763,
    769, 760, 769, 769, 769, 200, 770, 770,

    771, 771, 771, 771, 771, 771, 772, 771,
    771, 771, 771, 771, 771, 200, 773, 771,
    774, 774, 775, 776, 777, 778, 778, 778,
    778, 779, 779, 200, 200, 200, 200, 200,

    780, 780, 780, 780, 780, 780, 780, 780,
    780, 780, 780, 780, 780, 780, 780, 780,
    780, 780, 780, 780, 780, 780, 780, 780,
    780, 780, 780, 780, 780, 780, 780, 780,

    780, 780, 781, 780, 780, 780, 782, 780,
    781, 780, 780, 783, 784, 785, 786, 785,
    785, 787, 785, 788, 788, 788, 785, 789,
    784, 790, 791, 792, 792, 788, 788, 781,

    793, 794, 795, 796, 797, 798, 799, 800,
    801, 802, 803, 803, 804, 804, 804, 804,
    780, 780, 780, 780, 780, 780, 787, 787,
    785, 785, 781, 781, 781, 781, 788, 788,

    788, 781, 783, 783, 783, 781, 781, 783,
    783, 783, 783, 783, 783, 783, 781, 781,
    781, 788, 788, 788, 788, 781, 781, 781,
    781, 781, 781, 781, 781, 781, 781, 781,

    781, 781, 788, 783, 792, 788, 788, 783,
    783, 783, 783, 783, 783, 805, 781, 783,
    806, 807, 808, 809, 810, 811, 812, 813,
    814, 815, 816, 816, 816, 817, 818, 818,

    819, 819, 819, 819, 819, 819, 819, 819,
    819, 819, 819, 819, 819, 819, 819, 819,
    819, 819, 819, 819, 819, 819, 819, 819,
    819, 819, 819, 819, 819, 819, 819, 819,

    819, 819, 819, 819, 819, 819, 200, 820,
    200, 200, 200, 200, 200, 820, 200, 200,
    821, 821, 821, 821, 821, 821, 821, 821,
    821, 821, 821, 821, 821, 821, 821, 821,

    821, 821, 821, 821, 821, 821, 821, 821,
    821, 821, 821, 821, 821, 821, 821, 821,
    821, 821, 821, 821, 821, 821, 821, 822,
    822, 823, 823, 824, 825, 826, 826, 826,

    827, 827, 827, 827, 827, 827, 827, 827,
    827, 827, 827, 827, 827, 827, 827, 827,
    827, 827, 827, 827, 827, 827, 827, 827,
    827, 827, 827, 827, 827, 827, 827, 827,

    827, 827, 827, 827, 827, 827, 827, 827,
    827, 827, 827, 827, 827, 827, 827, 827,
    827, 827, 827, 827, 827, 827, 827, 827,
    827, 827, 828, 828, 828, 828, 828, 827,

    829, 830, 830, 830, 830, 830, 830, 830,
    830, 830, 830, 830, 830, 830, 830, 830,
    830, 830, 830, 830, 830, 830, 829, 829,
    829, 829, 829, 829, 829, 829, 829, 829,

    829, 829, 829, 829, 829, 829, 829, 829,
    829, 829, 829, 829, 829, 829, 829, 829,
    829, 829, 829, 829, 829, 829, 829, 829,
    829, 829, 829, 829, 829, 829, 829, 829,

    829, 829, 829, 831, 831, 831, 831, 831,
    832, 832, 832, 832, 832, 832, 832, 832,
    832, 832, 832, 832, 832, 832, 832, 832,
    832, 832, 832, 832, 832, 832, 832, 832,

    832, 832, 832, 833, 833, 833, 833, 833,
    833, 833, 833, 833, 833, 833, 833, 833,
    833, 833, 833, 833, 833, 833, 833, 833,
    833, 833, 833, 833, 833, 833, 833, 833,

    833, 833, 833, 833, 833, 833, 833, 833,
    833, 833, 833, 833, 833, 833, 833, 833,
    833, 833, 833, 833, 833, 833, 833, 833,
    833, 833, 834, 834, 834, 834, 834, 834,

    835, 835, 835, 835, 835, 835, 835, 836,
    835, 835, 835, 835, 835, 835, 835, 835,
    835, 835, 835, 835, 835, 835, 835, 835,
    835, 835, 835, 835, 835, 835, 835, 835,

    835, 835, 835, 835, 835, 835, 835, 835,
    835, 835, 835, 835, 835, 835, 835, 835,
    835, 835, 835, 835, 835, 835, 835, 835,
    835, 835, 835, 835, 835, 835, 835, 835,

    835, 835, 835, 835, 835, 835, 835, 836,
    835, 200, 835, 835, 835, 835, 200, 200,
    835, 835, 835, 835, 835, 835, 835, 200,
    835, 200, 835, 835, 835, 835, 200, 200,

    835, 835, 835, 835, 835, 835, 835, 836,
    835, 200, 835, 835, 835, 835, 200, 200,
    835, 835, 835, 835, 835, 835, 835, 835,
    835, 835, 835, 835, 835, 835, 835, 835,

    835, 835, 835, 835, 835, 835, 835, 835,
    835, 835, 835, 835, 835, 835, 835, 836,
    835, 200, 835, 835, 835, 835, 200, 200,
    835, 835, 835, 835, 835, 835, 835, 200,

    835, 200, 835, 835, 835, 835, 200, 200,
    835, 835, 835, 835, 835, 835, 835, 836,
    835, 835, 835, 835, 835, 835, 835, 200,
    835, 835, 835, 835, 835, 835, 835, 835,

    835, 835, 835, 835, 835, 835, 835, 835,
    835, 835, 835, 835, 835, 835, 835, 836,
    835, 835, 835, 835, 835, 835, 835, 835,
    835, 835, 835, 835, 835, 835, 835, 835,

    835, 835, 835, 835, 835, 835, 835, 835,
    835, 835, 835, 835, 835, 835, 835, 836,
    835, 200, 835, 835, 835, 835, 200, 200,
    835, 835, 835, 835, 835, 835, 835, 836,

    835, 835, 835, 835, 835, 835, 835, 836,
    835, 835, 835, 835, 835, 835, 835, 835,
    835, 835, 835, 835, 835, 835, 835, 835,
    835, 835, 835, 200, 200, 837, 837, 838,

    839, 840, 841, 842, 842, 842, 842, 841,
    841, 843, 844, 845, 846, 847, 848, 849,
    850, 851, 852, 852, 852, 852, 852, 852,
    852, 852, 852, 852, 852, 200, 200, 200,

    836, 836, 836, 836, 836, 836, 836, 836,
    836, 836, 836, 836, 836, 836, 836, 836,
    853, 853, 853, 853, 853, 853, 853, 853,
    853, 853, 200, 200, 200, 200, 200, 200,

    854, 855, 856, 857, 858, 859, 860, 861,
    862, 863, 864, 865, 866, 867, 868, 869,
    870, 871, 872, 873, 874, 875, 876, 877,
    878, 879, 880, 881, 882, 883, 884, 885,

    886, 887, 888, 889, 890, 891, 892, 893,
    894, 895, 896, 897, 898, 899, 900, 901,
    902, 903, 904, 905, 906, 907, 908, 909,
    910, 911, 912, 913, 914, 915, 916, 917,

    918, 919, 920, 921, 922, 923, 924, 925,
    926, 927, 928, 929, 930, 931, 932, 933,
    934, 934, 934, 934, 934, 935, 200, 200,
    936, 936, 936, 936, 936, 936, 200, 200,

    937, 938, 938, 938, 938, 938, 938, 938,
    938, 938, 938, 938, 938, 938, 938, 938,
    938, 938, 938, 938, 938, 938, 938, 938,
    938, 938, 938, 938, 938, 938, 938, 938,

    938, 938, 938, 938, 938, 938, 938, 938,
    938, 938, 938, 938, 938, 938, 938, 938,
    938, 938, 938, 938, 938, 938, 938, 938,
    938, 938, 938, 938, 938, 938, 938, 938,

    938, 938, 938, 938, 938, 938, 938, 938,
    938, 938, 938, 938, 938, 939, 940, 938,
    938, 938, 938, 938, 938, 938, 938, 941,
    941, 941, 941, 941, 941, 941, 941, 941,

    942, 943, 943, 943, 943, 943, 943, 943,
    943, 943, 943, 943, 943, 943, 943, 943,
    943, 943, 943, 943, 943, 943, 943, 943,
    943, 943, 943, 944, 945, 200, 200, 200,

    946, 946, 946, 946, 946, 946, 946, 946,
    946, 946, 946, 946, 946, 946, 946, 946,
    946, 946, 946, 946, 946, 946, 946, 946,
    946, 946, 946, 946, 946, 946, 946, 946,

    946, 946, 946, 946, 946, 946, 946, 946,
    946, 946, 946, 947, 947, 947, 948, 948,
    948, 949, 949, 949, 949, 949, 949, 949,
    949, 200, 200, 200, 200, 200, 200, 200,

    950, 950, 950, 950, 950, 950, 950, 950,
    950, 950, 950, 950, 950, 200, 950, 950,
    950, 950, 951, 951, 952, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    953, 953, 953, 953, 953, 953, 953, 953,
    953, 953, 953, 953, 953, 953, 953, 953,
    953, 953, 954, 954, 955, 956, 956, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    957, 957, 957, 957, 957, 957, 957, 957,
    957, 957, 957, 957, 957, 957, 957, 957,
    957, 957, 958, 958, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    959, 959, 959, 959, 959, 959, 959, 959,
    959, 959, 959, 959, 959, 200, 959, 959,
    959, 200, 960, 960, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    961, 961, 961, 961, 961, 961, 961, 961,
    961, 961, 961, 961, 961, 961, 961, 961,
    961, 961, 961, 961, 961, 961, 961, 961,
    961, 961, 961, 961, 961, 961, 961, 961,

    961, 961, 961, 961, 961, 961, 961, 961,
    961, 961, 961, 961, 961, 961, 961, 961,
    961, 961, 961, 961, 962, 962, 963, 962,
    962, 962, 962, 962, 962, 962, 963, 963,

    963, 963, 963, 963, 963, 963, 962, 963,
    963, 962, 962, 962, 962, 962, 962, 962,
    962, 962, 964, 962, 965, 965, 966, 967,
    965, 968, 965, 969, 961, 970, 200, 200,

    971, 972, 973, 974, 975, 976, 977, 978,
    979, 980, 200, 200, 200, 200, 200, 200,
    981, 981, 981, 981, 981, 981, 981, 981,
    981, 981, 200, 200, 200, 200, 200, 200,

    982, 982, 983, 984, 985, 986, 987, 988,
    989, 990, 991, 992, 992, 992, 993, 200,
    994, 995, 996, 997, 998, 999, 1000, 1001,
    1002, 1003, 200, 200, 200, 200, 200, 200,

    1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004,
    1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004,
    1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004,
    1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004,

    1004, 1004, 1004, 1005, 1004, 1004, 1004, 1004,
    1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004,
    1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004,
    1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004,

    1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004,
    1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004,
    1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004,
    200, 200, 200, 200, 200, 200, 200, 200,

    1006, 1006, 1006, 1006, 1006, 1006, 1006, 1004,
    1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004,
    1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004,
    1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004,

    1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004,
    1004, 1007, 1008, 200, 200, 200, 200, 200,
    941, 941, 941, 941, 941, 941, 941, 941,
    941, 941, 941, 941, 941, 941, 941, 941,

    941, 941, 941, 941, 941, 941, 941, 941,
    941, 941, 941, 941, 941, 941, 941, 941,
    941, 941, 941, 941, 941, 941, 941, 941,
    941, 941, 941, 941, 941, 941, 941, 941,

    941, 941, 941, 941, 941, 941, 941, 941,
    941, 941, 941, 941, 941, 941, 941, 941,
    941, 941, 941, 941, 941, 941, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    1009, 1009, 1009, 1009, 1009, 1009, 1009, 1009,
    1009, 1009, 1009, 1009, 1009, 1009, 1009, 1009,
    1009, 1009, 1009, 1009, 1009, 1009, 1009, 1009,
    1009, 1009, 1009, 1009, 1009, 1010, 1010, 200,

    1011, 1011, 1011, 1012, 1012, 1012, 1012, 1011,
    1011, 1012, 1012, 1012, 200, 200, 200, 200,
    1012, 1012, 1011, 1012, 1012, 1012, 1012, 1012,
    1012, 1013, 1014, 1015, 200, 200, 200, 200,

    1016, 200, 200, 200, 1017, 1017, 1018, 1019,
    1020, 1021, 1022, 1023, 1024, 1025, 1026, 1027,
    1028, 1028, 1028, 1028, 1028, 1028, 1028, 1028,
    1028, 1028, 1028, 1028, 1028, 1028, 1028, 1028,

    1028, 1028, 1028, 1028, 1028, 1028, 1028, 1028,
    1028, 1028, 1028, 1028, 1028, 1028, 200, 200,
    1028, 1028, 1028, 1028, 1028, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    1029, 1029, 1029, 1029, 1029, 1029, 1029, 1029,
    1029, 1029, 1029, 1029, 1029, 1029, 1029, 1029,
    1029, 1029, 1029, 1029, 1029, 1029, 1029, 1029,
    1029, 1029, 1029, 1029, 1029, 1029, 1029, 1029,

    1029, 1029, 1029, 1029, 1029, 1029, 1029, 1029,
    1029, 1029, 1030, 1030, 200, 200, 200, 200,
    1029, 1029, 1029, 1029, 1029, 1029, 1029, 1029,
    1029, 1029, 1029, 1029, 1029, 1029, 1029, 1029,

    1029, 1029, 1029, 1029, 1029, 1029, 1029, 1029,
    1029, 1029, 200, 200, 200, 200, 200, 200,
    1031, 1032, 1033, 1034, 1035, 1036, 1037, 1038,
    1039, 1040, 1041, 200, 200, 200, 1042, 1042,

    1043, 1043, 1043, 1043, 1043, 1043, 1043, 1043,
    1043, 1043, 1043, 1043, 1043, 1043, 1043, 1043,
    1043, 1043, 1043, 1043, 1043, 1043, 1043, 1043,
    1043, 1043, 1043, 1043, 1043, 1043, 1043, 1043,

    1044, 1044, 1044, 1044, 1044, 1044, 1044, 1044,
    1044, 1044, 1044, 1044, 1044, 1044, 1044, 1044,
    1044, 1044, 1044, 1044, 1044, 1044, 1044, 1045,
    1046, 1047, 1047, 1048, 200, 200, 1049, 1049,

    1050, 1050, 1050, 1050, 1050, 1050, 1050, 1050,
    1050, 1050, 1050, 1050, 1050, 1050, 1050, 1050,
    1050, 1050, 1050, 1050, 1050, 1050, 1050, 1050,
    1050, 1050, 1050, 1050, 1050, 1050, 1050, 1050,

    1050, 1050, 1050, 1050, 1050, 1050, 1050, 1050,
    1050, 1050, 1050, 1050, 1050, 1050, 1050, 1050,
    1050, 1050, 1050, 1050, 1050, 1051, 1052, 1051,
    1052, 1052, 1052, 1052, 1052, 1052, 1052, 200,

    1053, 1054, 1052, 1054, 1054, 1052, 1052, 1052,
    1052, 1052, 1052, 1052, 1052, 1051, 1051, 1051,
    1051, 1051, 1051, 1052, 1052, 1055, 1055, 1055,
    1055, 1055, 1055, 1055, 1055, 200, 200, 1056,

    1057, 1058, 1059, 1060, 1061, 1062, 1063, 1064,
    1065, 1066, 200, 200, 200, 200, 200, 200,
    1057, 1058, 1059, 1060, 1061, 1062, 1063, 1064,
    1065, 1066, 200, 200, 200, 200, 200, 200,

    1067, 1067, 1067, 1067, 1067, 1067, 1067, 1068,
    1069, 1069, 1069, 1069, 1067, 1067, 200, 200,
    1070, 1070, 1070, 1070, 1070, 1071, 1071, 1071,
    1071, 1071, 1071, 1070, 1070, 1071, 1072, 200,

    1073, 1073, 1073, 1073, 1074, 1075, 1076, 1075,
    1076, 1075, 1076, 1075, 1076, 1075, 1076, 1075,
    1075, 1075, 1076, 1075, 1075, 1075, 1075, 1075,
    1075, 1075, 1075, 1075, 1075, 1075, 1075, 1075,

    1075, 1075, 1075, 1075, 1075, 1075, 1075, 1075,
    1075, 1075, 1075, 1075, 1075, 1075, 1075, 1075,
    1075, 1075, 1075, 1075, 1077, 1078, 1073, 1073,
    1073, 1073, 1073, 1079, 1073, 1079, 1074, 1074,

    1079, 1079, 1073, 1079, 1080, 1075, 1075, 1075,
    1075, 1075, 1075, 1075, 200, 200, 200, 200,
    1081, 1082, 1083, 1084, 1085, 1086, 1087, 1088,
    1089, 1090, 1091, 1091, 1092, 1093, 1091, 1091,

    1093, 1094, 1094, 1094, 1094, 1094, 1094, 1094,
    1094, 1094, 1094, 1095, 1096, 1095, 1095, 1095,
    1095, 1095, 1095, 1095, 1094, 1094, 1094, 1094,
    1094, 1094, 1094, 1094, 1094, 200, 200, 200,

    1097, 1097, 1098, 1099, 1099, 1099, 1099, 1099,
    1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099,
    1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099,
    1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099,

    1099, 1098, 1097, 1097, 1097, 1097, 1098, 1098,
    1097, 1097, 1100, 1101, 1102, 1102, 1099, 1099,
    1103, 1104, 1105, 1106, 1107, 1108, 1109, 1110,
    1111, 1112, 1113, 1113, 1113, 1113, 1113, 1113,

    1114, 1114, 1114, 1114, 1114, 1114, 1114, 1114,
    1114, 1114, 1114, 1114, 1114, 1114, 1114, 1114,
    1114, 1114, 1114, 1114, 1114, 1114, 1114, 1114,
    1114, 1114, 1114, 1114, 1114, 1114, 1114, 1114,

    1114, 1114, 1114, 1114, 1114, 1114, 1115, 1116,
    1117, 1117, 1116, 1116, 1116, 1117, 1116, 1117,
    1117, 1117, 1118, 1118, 200, 200, 200, 200,
    200, 200, 200, 200, 1119, 1119, 1119, 1119,

    1120, 1120, 1120, 1120, 1120, 1120, 1120, 1120,
    1120, 1120, 1120, 1120, 1120, 1120, 1120, 1120,
    1120, 1120, 1120, 1120, 1120, 1120, 1120, 1120,
    1120, 1120, 1120, 1120, 1120, 1120, 1120, 1120,

    1120, 1120, 1120, 1120, 1121, 1121, 1121, 1121,
    1121, 1121, 1121, 1121, 1122, 1122, 1122, 1122,
    1122, 1122, 1122, 1122, 1121, 1121, 1122, 1123,
    200, 200, 200, 1124, 1124, 1125, 1125, 1125,

    1126, 1127, 1128, 1129, 1130, 1131, 1132, 1133,
    1134, 1135, 200, 200, 200, 1120, 1120, 1120,
    1136, 1137, 1138, 1139, 1140, 1141, 1142, 1143,
    1144, 1145, 1146, 1146, 1146, 1146, 1146, 1146,

    1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146,
    1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146,
    1146, 1146, 1146, 1146, 1146, 1146, 1146, 1146,
    1147, 1147, 1147, 1147, 1147, 1147, 1148, 1148,

    1149, 1149, 1149, 1149, 1149, 1149, 1149, 1149,
    200, 200, 200, 200, 200, 200, 200, 200,
    1150, 1150, 1150, 1151, 1152, 1153, 1153, 1153,
    1153, 1153, 1150, 1150, 1153, 1153, 1153, 1153,

    1150, 1154, 1152, 1152, 1152, 1152, 1152, 1152,
    1152, 1155, 1155, 1155, 1155, 1153, 1155, 1155,
    1155, 1155, 1154, 1156, 1157, 1158, 1158, 200,
    1070, 1070, 200, 200, 200, 200, 200, 200,

    114, 114, 114, 114, 114, 114, 114, 114,
    114, 114, 114, 114, 114, 114, 114, 114,
    114, 114, 114, 114, 114, 114, 114, 114,
    114, 114, 114, 114, 114, 114, 114, 114,

    114, 114, 114, 114, 114, 114, 1159, 1159,
    1159, 1159, 1159, 1160, 1161, 1161, 1161, 1162,
    1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161,
    1161, 1161, 1161, 1162, 1161, 1161, 1161, 1161,

    1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161,
    1161, 1161, 1161, 1161, 1161, 1161, 1162, 1161,
    1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161,
    1161, 1161, 1161, 1161, 1161, 1163, 1163, 1163,

    1163, 1163, 1161, 1161, 1161, 1161, 1163, 1163,
    1163, 1163, 1163, 114, 115, 115, 115, 115,
    115, 115, 115, 115, 115, 115, 115, 115,
    1164, 1165, 115, 115, 115, 1166, 115, 115,

    115, 115, 115, 115, 115, 115, 115, 115,
    115, 115, 115, 115, 115, 115, 115, 115,
    115, 115, 115, 115, 115, 115, 115, 115,
    115, 115, 115, 1167, 1167, 1167, 1167, 1167,

    1167, 1167, 1167, 1167, 1167, 1167, 1167, 1167,
    1167, 1167, 1167, 1167, 1167, 1167, 1167, 1167,
    1167, 1167, 1167, 1167, 1167, 1167, 1167, 1167,
    1167, 1167, 1167, 1167, 1167, 1167, 1167, 1168,

    189, 189, 188, 189, 1169, 1169, 1169, 1169,
    1169, 1169, 1170, 1171, 1171, 1172, 1173, 1174,
    1175, 1171, 1171, 1171, 1171, 1171, 1171, 1171,
    1171, 1171, 1171, 1171, 1171, 1171, 1171, 1171,

    1171, 1171, 1171, 1171, 1171, 1171, 1171, 1070,
    1070, 1070, 1070, 1070, 1070, 1070, 1070, 1070,
    1070, 1070, 1070, 1070, 1070, 1070, 200, 200,
    200, 200, 200, 200, 1176, 1153, 1169, 1170,

    70, 71, 70, 71, 70, 71, 70, 71,
    70, 71, 70, 71, 70, 71, 70, 71,
    70, 71, 70, 71, 70, 71, 70, 71,
    70, 71, 70, 71, 70, 71, 70, 71,

    70, 71, 70, 71, 70, 71, 70, 71,
    70, 71, 70, 71, 70, 71, 70, 71,
    70, 71, 70, 71, 70, 71, 1177, 1178,
    1179, 1180, 1181, 1182, 1183, 1183, 1184, 1183,

    70, 71, 70, 71, 70, 71, 70, 71,
    70, 71, 70, 71, 70, 71, 70, 71,
    70, 71, 70, 71, 70, 71, 70, 71,
    70, 71, 1185, 1186, 1185, 1186, 1185, 1186,

    1187, 1187, 1187, 1187, 1187, 1187, 1187, 1187,
    1188, 1188, 1188, 1188, 1188, 1188, 1188, 1188,
    1187, 1187, 1187, 1187, 1187, 1187, 200, 200,
    1188, 1188, 1188, 1188, 1188, 1188, 200, 200,

    1187, 1187, 1187, 1187, 1187, 1187, 1187, 1187,
    1188, 1188, 1188, 1188, 1188, 1188, 1188, 1188,
    1187, 1187, 1187, 1187, 1187, 1187, 1187, 1187,
    1188, 1188, 1188, 1188, 1188, 1188, 1188, 1188,

    1187, 1187, 1187, 1187, 1187, 1187, 200, 200,
    1188, 1188, 1188, 1188, 1188, 1188, 200, 200,
    1189, 1187, 1190, 1187, 1191, 1187, 1192, 1187,
    200, 1188, 200, 1188, 200, 1188, 200, 1188,

    1187, 1187, 1187, 1187, 1187, 1187, 1187, 1187,
    1188, 1188, 1188, 1188, 1188, 1188, 1188, 1188,
    1193, 1194, 1195, 1196, 1195, 1196, 1197, 1198,
    1199, 1200, 1201, 1202, 1203, 1204, 200, 200,

    1205, 1206, 1207, 1208, 1209, 1210, 1211, 1212,
    1213, 1214, 1215, 1216, 1217, 1218, 1219, 1220,
    1221, 1222, 1223, 1224, 1225, 1226, 1227, 1228,
    1229, 1230, 1231, 1232, 1233, 1234, 1235, 1236,

    1237, 1238, 1239, 1240, 1241, 1242, 1243, 1244,
    1245, 1246, 1247, 1248, 1249, 1250, 1251, 1252,
    1187, 1187, 1253, 1254, 1255, 200, 1256, 1257,
    1188, 1188, 1258, 1259, 1260, 205, 1261, 205,

    205, 1262, 1263, 1264, 1265, 200, 1266, 1267,
    1268, 1269, 1268, 1269, 1270, 1262, 1262, 1262,
    1187, 1187, 1271, 1272, 200, 200, 1273, 1274,
    1188, 1188, 1275, 1276, 200, 1262, 1262, 1262,

    1187, 1187, 1277, 1278, 1279, 1280, 1281, 1282,
    1188, 1188, 1283, 1284, 1285, 1262, 1286, 1286,
    200, 200, 1287, 1288, 1289, 200, 1290, 1291,
    1292, 1293, 1294, 1295, 1296, 1297, 205, 200,

    1298, 1298, 1299, 1299, 1299, 1299, 1299, 1300,
    1299, 1299, 1299, 1301, 1302, 1303, 1304, 1305,
    1306, 1307, 1306, 1308, 1309, 1310, 14, 1311,
    1312, 1313, 1314, 1315, 1315, 1316, 1314, 1315,

    14, 14, 14, 14, 1317, 1318, 1318, 1319,
    1320, 1321, 1322, 1323, 1324, 1325, 1326, 1327,
    13, 13, 13, 1328, 1328, 1329, 1330, 1330,
    14, 1331, 1332, 14, 1333, 1334, 1311, 43,

    43, 14, 14, 14, 1335, 16, 1336, 1337,
    1338, 1338, 1339, 1339, 1339, 1339, 1340, 1340,
    1340, 1340, 1341, 1342, 1343, 1344, 1345, 1346,
    1345, 1345, 1345, 1345, 1344, 1345, 1345, 1347,

    1348, 1349, 1349, 1349, 1350, 1351, 1352, 1353,
    1354, 1355, 1356, 1356, 1356, 1356, 1356, 1356,
    1357, 1358, 200, 200, 1359, 1360, 1361, 1362,
    1363, 1364, 1365, 1365, 1366, 1367, 1368, 158,

    1357, 63, 58, 59, 1359, 1360, 1361, 1362,
    1363, 1364, 1365, 1365, 1366, 1367, 1368, 200,
    1167, 1167, 1167, 1167, 1167, 1369, 1369, 1369,
    1369, 1369, 1369, 1369, 1369, 200, 200, 200,

    12, 12, 12, 12, 12, 12, 12, 50,
    1370, 12, 12, 1371, 1372, 1373, 1373, 1373,
    1374, 1374, 1375, 1375, 1375, 1375, 1376, 1377,
    1377, 1378, 1379, 1380, 1381, 1381, 1382, 1383,

    1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383,
    1383, 1383, 1383, 1383, 1383, 1383, 1383, 1383,
    171, 171, 178, 178, 171, 171, 171, 171,
    178, 178, 178, 171, 171, 1384, 1384, 1384,

    1384, 171, 1385, 1385, 1386, 1387, 1387, 195,
    1388, 195, 1387, 1389, 1170, 1170, 1170, 1170,
    1171, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    1390, 1390, 1391, 1392, 51, 1390, 1390, 1391,
    51, 1392, 1393, 1391, 1391, 1391, 1393, 1393,
    1391, 1391, 1391, 1393, 51, 1391, 1394, 51,
    36, 1391, 1391, 1391, 1391, 1391, 51, 51,

    1390, 1390, 1390, 51, 1391, 51, 1395, 51,
    1391, 51, 1396, 1397, 1391, 1391, 1398, 1393,
    1391, 1391, 1399, 1391, 1393, 1400, 1400, 1400,
    1400, 1401, 1402, 1403, 1404, 1405, 1406, 1406,

    1407, 1341, 1341, 1341, 1341, 1406, 1405, 1405,
    1405, 1405, 1408, 1341, 1409, 1410, 1411, 1412,
    1413, 1413, 1413, 65, 65, 65, 65, 65,
    65, 65, 65, 65, 65, 65, 65, 65,

    1414, 1414, 1414, 1414, 1414, 1414, 1414, 1414,
    1414, 1414, 1414, 1414, 1414, 1414, 1414, 1414,
    1415, 1415, 1415, 1415, 1415, 1415, 1415, 1415,
    1415, 1415, 1415, 1415, 1415, 1415, 1415, 1415,

    1416, 1416, 1416, 111, 123, 1417, 1417, 1417,
    1417, 1413, 1418, 1418, 200, 200, 200, 200,
    36, 36, 36, 36, 36, 51, 51, 51,
    51, 51, 1419, 1419, 51, 51, 51, 51,

    36, 51, 51, 36, 51, 51, 36, 51,
    51, 51, 51, 51, 51, 51, 1419, 51,
    51, 51, 51, 51, 51, 51, 51, 51,
    51, 51, 51, 51, 51, 51, 51, 51,

    51, 51, 51, 51, 51, 51, 51, 51,
    51, 51, 51, 51, 51, 1420, 1419, 1419,
    51, 51, 36, 51, 36, 51, 51, 51,
    51, 51, 51, 51, 51, 51, 51, 51,

    51, 51, 51, 51, 51, 51, 51, 51,
    51, 51, 51, 1402, 1402, 1402, 1402, 1402,
    1402, 1402, 1402, 1402, 1341, 1341, 1341, 1341,
    1341, 1341, 1341, 1341, 1341, 1341, 1341, 1341,

    36, 36, 36, 36, 1419, 36, 36, 36,
    1421, 1422, 1421, 1423, 1424, 1423, 36, 36,
    36, 36, 18, 57, 36, 1425, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36,

    36, 36, 36, 36, 1419, 36, 1419, 36,
    36, 36, 36, 36, 1366, 1366, 36, 1366,
    1366, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 1426, 1427, 36, 36,

    36, 1419, 36, 1428, 1419, 36, 36, 1419,
    36, 1419, 36, 36, 36, 36, 36, 36,
    36, 36, 1426, 1427, 1426, 1427, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 36,

    1419, 36, 1419, 36, 1426, 1427, 1426, 1427,
    1426, 1427, 1426, 1427, 36, 1419, 1429, 1430,
    1429, 1430, 1426, 1427, 1429, 1430, 1426, 1427,
    1429, 1430, 1426, 1427, 1426, 1427, 1426, 1427,

    1429, 1430, 1426, 1427, 1429, 1430, 1426, 1427,
    1429, 1430, 1426, 1427, 36, 36, 36, 1426,
    1427, 1426, 1427, 36, 36, 36, 36, 36,
    1431, 36, 36, 36, 36, 36, 36, 36,

    36, 36, 1426, 1427, 36, 36, 1432, 36,
    1433, 1434, 36, 1434, 1419, 1419, 1419, 1419,
    1426, 1427, 1426, 1427, 1426, 1427, 1426, 1427,
    36, 36, 36, 36, 36, 36, 36, 36,

    36, 36, 36, 36, 36, 36, 36, 36,
    36, 1426, 1427, 1426, 1427, 1435, 36, 36,
    1426, 1427, 36, 36, 36, 36, 1426, 1427,
    1426, 1427, 1426, 1427, 1426, 1427, 1426, 1427,

    1429, 1430, 1429, 1430, 1426, 1427, 1426, 1427,
    1426, 1427, 1429, 1430, 1429, 1430, 36, 1436,
    1426, 1427, 1437, 1437, 1437, 1341, 1438, 1438,
    1341, 1341, 1439, 1439, 1439, 1440, 1440, 1341,

    51, 1402, 51, 51, 51, 51, 51, 51,
    16, 1336, 16, 1336, 51, 51, 51, 51,
    51, 51, 51, 51, 51, 51, 51, 51,
    51, 51, 1441, 1441, 51, 51, 51, 51,

    36, 36, 51, 51, 51, 51, 51, 51,
    51, 1442, 1443, 51, 51, 51, 51, 51,
    51, 51, 51, 51, 51, 51, 1444, 1444,
    1444, 1444, 1444, 1444, 1444, 1444, 1444, 1444,

    1444, 1444, 1444, 1444, 1444, 1444, 1444, 1444,
    1444, 1444, 1444, 1444, 1444, 1444, 1444, 1444,
    1444, 1444, 1444, 1444, 1444, 1444, 1444, 1444,
    1444, 1444, 1444, 1444, 1444, 1444, 1444, 1444,

    1444, 1444, 1444, 1444, 1444, 1444, 1444, 1444,
    1444, 1444, 1444, 1444, 1444, 1444, 1444, 1444,
    1444, 1444, 1444, 1444, 1444, 1444, 1444, 1444,
    1444, 1444, 1444, 1402, 1341, 1402, 1402, 1402,

    1402, 1402, 1402, 1402, 1402, 1402, 1402, 1402,
    1402, 1402, 1402, 1402, 1402, 1402, 1402, 1402,
    1402, 1402, 1402, 1402, 1402, 1445, 1402, 1402,
    1402, 1402, 1402, 1341, 1341, 1341, 1341, 1341,

    1341, 1341, 1341, 1341, 1341, 1341, 1341, 1341,
    1341, 1341, 1341, 1341, 1341, 1341, 1341, 1341,
    1341, 1341, 1341, 1341, 1408, 1408, 1408, 1408,
    1408, 1408, 1408, 1408, 1408, 1408, 1408, 1408,

    1408, 1408, 1408, 1408, 1408, 1408, 1408, 1408,
    1408, 1408, 1408, 1408, 1408, 1408, 1408, 1446,
    1446, 1409, 1409, 1409, 1409, 1409, 1409, 1409,
    1409, 1409, 1409, 1409, 1447, 1447, 1447, 1447,

    1447, 1447, 1410, 1410, 1410, 1410, 1410, 1410,
    1448, 1449, 1449, 1449, 1449, 1449, 1449, 1449,
    1450, 1450, 1450, 1450, 1451, 1451, 1451, 1451,
    1451, 1451, 1451, 200, 200, 200, 200, 200,

    51, 51, 51, 51, 51, 51, 51, 51,
    51, 51, 51, 51, 51, 51, 51, 51,
    51, 51, 51, 51, 51, 51, 51, 51,
    51, 51, 51, 51, 51, 51, 51, 51,

    51, 51, 51, 51, 51, 1402, 1402, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    51, 51, 51, 51, 51, 51, 51, 51,
    51, 51, 51, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    1452, 1453, 1454, 1455, 1456, 1457, 1458, 1459,
    1460, 65, 65, 65, 65, 65, 65, 65,
    65, 65, 65, 65, 1452, 1453, 1454, 1455,
    1456, 1457, 1458, 1459, 1460, 65, 65, 65,

    65, 65, 65, 65, 65, 65, 65, 65,
    63, 58, 59, 1359, 1360, 1361, 1362, 1363,
    1364, 1461, 1461, 1461, 1461, 1461, 1461, 1461,
    1461, 1461, 1461, 1461, 1462, 1462, 1462, 1462,

    1462, 1462, 1462, 1462, 1462, 1462, 1462, 1462,
    1462, 1462, 1462, 1462, 1462, 1462, 1462, 1462,
    1462, 1462, 1462, 1462, 1462, 1462, 1463, 1463,
    1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463,

    1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463,
    1463, 1463, 1463, 1463, 1463, 1463, 1463, 1463,
    1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464,
    1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464,

    1464, 1464, 1464, 1464, 1464, 1464, 1464, 1464,
    1464, 1464, 1465, 1466, 1466, 1466, 1466, 1466,
    1466, 1466, 1466, 1466, 1466, 1467, 1468, 1469,
    1470, 1471, 1472, 1473, 1474, 1475, 1466, 1476,

    51, 51, 51, 51, 51, 51, 51, 51,
    51, 51, 51, 51, 51, 51, 51, 51,
    51, 51, 51, 51, 51, 51, 1408, 1408,
    1408, 1408, 1408, 1408, 1408, 1408, 1408, 1408,

    51, 51, 51, 51, 51, 51, 51, 51,
    51, 51, 51, 51, 51, 51, 51, 51,
    51, 51, 51, 51, 51, 51, 51, 36,
    51, 51, 51, 51, 51, 51, 51, 51,

    51, 36, 51, 51, 51, 51, 51, 51,
    51, 51, 51, 51, 51, 51, 51, 51,
    51, 51, 51, 51, 51, 51, 51, 51,
    51, 51, 51, 51, 51, 51, 51, 51,

    51, 51, 51, 51, 51, 51, 51, 51,
    51, 51, 51, 51, 51, 51, 51, 51,
    1402, 1402, 1402, 1402, 1402, 1402, 1402, 1402,
    1341, 1341, 1341, 1341, 1341, 1341, 1341, 1341,

    1441, 1441, 1441, 1441, 51, 51, 51, 51,
    51, 51, 51, 51, 51, 51, 51, 51,
    51, 51, 51, 51, 1477, 1477, 1408, 1408,
    1478, 1402, 1441, 1441, 1441, 1441, 1441, 1441,

    51, 51, 51, 51, 51, 51, 51, 51,
    51, 51, 51, 51, 51, 51, 51, 51,
    51, 51, 51, 51, 51, 51, 51, 51,
    51, 1441, 1441, 1441, 51, 51, 51, 51,

    51, 51, 51, 51, 51, 51, 51, 51,
    1441, 51, 51, 51, 51, 51, 51, 36,
    1402, 1402, 1408, 1408, 1408, 1408, 1408, 1408,
    1408, 1408, 1408, 1408, 1408, 1408, 1409, 1478,

    1408, 1408, 1408, 1408, 1408, 1408, 1408, 1408,
    1408, 1408, 1446, 1446, 1446, 1446, 1446, 1446,
    1446, 1446, 1409, 1409, 1409, 1409, 1409, 1409,
    1409, 1409, 1409, 1409, 1409, 1479, 1448, 1448,

    1446, 1446, 1409, 1409, 1409, 1409, 1409, 1409,
    1409, 1409, 1409, 1409, 1480, 1409, 1409, 1409,
    1409, 1409, 1410, 1479, 1479, 1479, 1479, 1479,
    1479, 1479, 1479, 1479, 1479, 1481, 1481, 1481,

    1482, 1482, 1482, 1482, 1481, 1481, 1481, 1481,
    1481, 1448, 1448, 1448, 1448, 1481, 1449, 1481,
    1481, 1481, 1448, 1481, 1481, 1448, 1448, 1448,
    1481, 1481, 1448, 1448, 1481, 1448, 1448, 1481,

    1481, 1481, 1449, 1448, 1449, 1449, 1449, 1449,
    1448, 1448, 1481, 1448, 1448, 1448, 1448, 1448,
    1448, 1481, 1481, 1481, 1481, 1481, 1448, 1481,
    1481, 1481, 1481, 1448, 1448, 1481, 1481, 1481,

    1483, 1441, 1441, 1441, 1441, 1449, 51, 51,
    1441, 1441, 1450, 1450, 1441, 1441, 51, 51,
    51, 51, 51, 51, 51, 51, 51, 51,
    51, 51, 51, 51, 51, 51, 51, 51,

    51, 51, 51, 51, 51, 51, 51, 51,
    1449, 51, 51, 51, 51, 51, 51, 51,
    51, 51, 51, 51, 51, 51, 51, 51,
    51, 51, 51, 51, 51, 51, 51, 51,

    51, 51, 51, 51, 51, 51, 51, 51,
    51, 51, 51, 51, 1449, 51, 1449, 51,
    51, 51, 51, 1449, 1449, 1449, 51, 1448,
    51, 51, 51, 1484, 1484, 1484, 1484, 1485,

    1485, 51, 1486, 1486, 51, 51, 51, 51,
    1487, 1488, 1487, 1488, 1487, 1488, 1487, 1488,
    1487, 1488, 1487, 1488, 1487, 1488, 1489, 1490,
    1491, 1492, 1493, 1494, 1495, 1496, 1497, 1498,

    1489, 1490, 1491, 1492, 1493, 1494, 1495, 1496,
    1497, 1498, 1489, 1490, 1491, 1492, 1493, 1494,
    1495, 1496, 1497, 1498, 51, 1449, 1449, 1449,
    51, 51, 51, 51, 51, 51, 51, 51,

    51, 51, 51, 51, 51, 51, 51, 51,
    51, 51, 51, 51, 51, 51, 51, 51,
    1449, 51, 51, 51, 51, 51, 51, 51,
    51, 51, 51, 51, 51, 51, 51, 1449,

    1499, 1499, 1499, 1500, 1501, 1502, 1503, 1447,
    1504, 1505, 1447, 1506, 1507, 1508, 1509, 1509,
    1341, 1341, 1341, 1341, 1341, 1510, 1511, 1341,
    1341, 1341, 1341, 1341, 1341, 1510, 1511, 1341,

    1341, 1341, 1510, 1511, 1510, 1511, 1487, 1488,
    1487, 1488, 1487, 1488, 1512, 1513, 1512, 1513,
    1341, 1341, 1341, 1341, 1341, 1341, 1341, 1341,
    1341, 1341, 1341, 1341, 1341, 1341, 1341, 1341,

    1514, 1514, 1514, 1514, 1514, 1514, 1514, 1514,
    1514, 1514, 1514, 1514, 1514, 1514, 1514, 1514,
    1514, 1514, 1514, 1514, 1514, 1514, 1514, 1514,
    1514, 1514, 1514, 1514, 1514, 1514, 1514, 1514,

    1341, 1341, 1341, 1341, 1341, 1341, 1341, 1341,
    1341, 1341, 1341, 1341, 1341, 1341, 1341, 1341,
    1341, 1341, 1341, 1341, 1341, 1341, 1341, 1341,
    1341, 1341, 1341, 1341, 1341, 1341, 1341, 1341,

    1341, 1341, 1341, 1487, 1488, 1487, 1488, 1487,
    1488, 1487, 1488, 1487, 1488, 1515, 1516, 1517,
    1518, 1487, 1488, 1487, 1488, 1487, 1488, 1487,
    1488, 1341, 1341, 1341, 1341, 1341, 1341, 1341,

    1341, 1341, 1341, 1341, 1341, 1341, 1341, 1341,
    1341, 1341, 1341, 1341, 1341, 1341, 1341, 1341,
    1341, 1341, 1341, 1341, 1341, 1341, 1341, 1341,
    1519, 1341, 1341, 1341, 1341, 1341, 1341, 1341,

    1510, 1511, 1341, 1341, 1510, 1511, 1341, 1341,
    1341, 1341, 1341, 1341, 1341, 1341, 1341, 1510,
    1511, 1510, 1511, 1341, 1510, 1511, 1341, 1341,
    1487, 1488, 1487, 1488, 1341, 1341, 1341, 1341,

    1341, 1341, 1341, 1341, 1341, 1341, 1341, 1341,
    1341, 1341, 1341, 1341, 1341, 1341, 1341, 1341,
    1341, 1341, 1341, 1341, 1341, 1520, 1341, 1341,
    1510, 1511, 1341, 1341, 1487, 1488, 1341, 1341,

    1341, 1341, 1341, 1341, 1341, 1341, 1341, 1341,
    1341, 1341, 1341, 1341, 1407, 1341, 1341, 1341,
    1341, 1341, 1341, 1341, 1341, 1341, 1341, 1341,
    1341, 1341, 1341, 1341, 1341, 1341, 1341, 1341,

    1341, 1341, 1341, 1341, 1341, 1341, 1341, 1341,
    1341, 1341, 1341, 1510, 1511, 1510, 1511, 1341,
    1341, 1341, 1341, 1341, 1510, 1511, 1341, 1341,
    1341, 1341, 1341, 1341, 1510, 1511, 1341, 1341,

    1341, 1341, 1341, 1341, 1510, 1511, 1341, 1341,
    1341, 1341, 1341, 1341, 1341, 1341, 1341, 1341,
    1341, 1341, 1341, 1341, 1407, 1407, 1407, 1341,
    1341, 1510, 1511, 1341, 1341, 1510, 1511, 1510,

    1511, 1510, 1511, 1510, 1511, 1341, 1341, 1341,
    1341, 1341, 1341, 1510, 1511, 1341, 1341, 1341,
    1341, 1510, 1511, 1510, 1511, 1510, 1511, 1510,
    1511, 1510, 1511, 1510, 1511, 1341, 1341, 1341,

    1341, 1510, 1511, 1341, 1341, 1341, 1510, 1511,
    1510, 1511, 1510, 1511, 1510, 1511, 1341, 1510,
    1511, 1341, 1341, 1510, 1511, 1341, 1341, 1341,
    1341, 1341, 1341, 1510, 1511, 1510, 1511, 1510,

    1511, 1510, 1511, 1510, 1511, 1510, 1511, 1341,
    1341, 1341, 1341, 1341, 1341, 1510, 1511, 1510,
    1511, 1510, 1511, 1510, 1511, 1510, 1511, 1341,
    1341, 1341, 1341, 1341, 1521, 1341, 1522, 1341,

    1341, 1341, 1341, 1523, 1524, 1523, 1341, 1341,
    1341, 1341, 1341, 1341, 1510, 1511, 1341, 1341,
    1341, 1341, 1341, 1341, 1341, 1341, 1341, 1510,
    1511, 1510, 1511, 1341, 1341, 1341, 1341, 1341,

    1446, 1446, 1446, 1446, 1446, 1446, 1446, 1446,
    1446, 1446, 1446, 1446, 1446, 1446, 1409, 1409,
    1409, 1409, 1409, 1409, 1410, 1410, 1410, 1410,
    1410, 1410, 1410, 1479, 1479, 1479, 1479, 1479,

    1410, 1410, 1410, 1410, 1479, 1479, 1479, 1479,
    1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479,
    1507, 1507, 1507, 1507, 1507, 1507, 1507, 1507,
    1507, 1507, 1507, 1507, 1507, 1507, 1507, 1507,

    1507, 1507, 1507, 1507, 1507, 1479, 1479, 1507,
    1507, 1507, 1507, 1507, 1507, 1451, 1451, 1451,
    1479, 1479, 1479, 1479, 1479, 1448, 1448, 1448,
    1448, 1448, 1451, 1451, 1451, 1451, 1451, 1451,

    1451, 1451, 1451, 1451, 1451, 1451, 1451, 1451,
    1451, 1451, 1451, 1451, 1451, 1451, 1451, 1451,
    1451, 1451, 1451, 1451, 200, 200, 1451, 1451,
    1451, 1451, 1451, 1451, 1451, 1451, 1451, 1451,

    1451, 1451, 1451, 1451, 1451, 1451, 1451, 1451,
    1451, 1451, 1451, 1451, 1451, 1451, 1451, 1451,
    1451, 1451, 1451, 1451, 1451, 1451, 200, 200,
    1451, 1451, 1451, 1451, 1451, 1451, 1451, 1451,

    1451, 1451, 1451, 1451, 1451, 1451, 1451, 1451,
    1451, 1451, 1451, 1451, 1451, 1451, 1451, 1451,
    1451, 1451, 1451, 1451, 1451, 1451, 1451, 1451,
    1451, 1451, 200, 200, 200, 1451, 1451, 1451,

    1451, 1451, 1451, 1451, 1451, 1451, 1451, 1451,
    1451, 200, 1451, 1451, 1451, 1451, 1451, 1451,
    1451, 1451, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 1418, 1418, 1418, 1418,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    1525, 1525, 1525, 1525, 1525, 1525, 1525, 1525,
    1525, 1525, 1525, 1525, 1525, 1525, 1525, 1525,
    1525, 1525, 1525, 1525, 1525, 1525, 1525, 1525,
    1525, 1525, 1525, 1525, 1525, 1525, 1525, 1525,

    1525, 1525, 1525, 1525, 1525, 1525, 1525, 1525,
    1525, 1525, 1525, 1525, 1525, 1525, 1525, 200,
    1526, 1526, 1526, 1526, 1526, 1526, 1526, 1526,
    1526, 1526, 1526, 1526, 1526, 1526, 1526, 1526,

    1526, 1526, 1526, 1526, 1526, 1526, 1526, 1526,
    1526, 1526, 1526, 1526, 1526, 1526, 1526, 1526,
    1526, 1526, 1526, 1526, 1526, 1526, 1526, 1526,
    1526, 1526, 1526, 1526, 1526, 1526, 1526, 200,

    127, 123, 1527, 1528, 1529, 1530, 1531, 127,
    123, 127, 123, 127, 123, 1532, 1533, 1534,
    1535, 1183, 1185, 1186, 1536, 127, 123, 1536,
    1183, 1183, 1183, 1183, 1537, 1537, 1538, 1539,

    1540, 1541, 1540, 1541, 1540, 1541, 1540, 1541,
    1540, 1541, 1540, 1541, 1540, 1541, 1540, 1541,
    1540, 1541, 1540, 1541, 1540, 1541, 1540, 1541,
    1540, 1541, 1540, 1541, 1540, 1541, 1540, 1541,

    1540, 1541, 1540, 1541, 1542, 1543, 1543, 1543,
    1543, 1543, 1543, 1544, 1545, 1544, 1545, 1546,
    1546, 1546, 1547, 1548, 200, 200, 200, 200,
    200, 1549, 1550, 1550, 1550, 1551, 1549, 1550,

    1552, 1552, 1552, 1552, 1552, 1552, 1552, 1552,
    1552, 1552, 1552, 1552, 1552, 1552, 1552, 1552,
    1552, 1552, 1552, 1552, 1552, 1552, 1552, 1552,
    1552, 1552, 1552, 1552, 1552, 1552, 1552, 1552,

    1552, 1552, 1552, 1552, 1552, 1552, 200, 1553,
    200, 200, 200, 200, 200, 1553, 200, 200,
    1554, 1554, 1554, 1554, 1554, 1554, 1554, 1554,
    1554, 1554, 1554, 1554, 1554, 1554, 1554, 1554,

    1554, 1554, 1554, 1554, 1554, 1554, 1554, 1554,
    1554, 1554, 1554, 1554, 1554, 1554, 1554, 1554,
    1554, 1554, 1554, 1554, 1554, 1554, 1554, 1554,
    1554, 1554, 1554, 1554, 1554, 1554, 1554, 1554,

    1554, 1554, 1554, 1554, 1554, 1554, 1555, 1555,
    200, 200, 200, 200, 200, 200, 200, 1556,
    1557, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 1558,

    836, 836, 836, 836, 836, 836, 836, 836,
    836, 836, 836, 836, 836, 836, 836, 836,
    836, 836, 836, 836, 836, 836, 836, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    836, 836, 836, 836, 836, 836, 836, 200,
    836, 836, 836, 836, 836, 836, 836, 200,
    836, 836, 836, 836, 836, 836, 836, 200,
    836, 836, 836, 836, 836, 836, 836, 200,

    265, 265, 265, 265, 265, 265, 265, 265,
    265, 265, 265, 265, 265, 265, 265, 265,
    265, 265, 265, 265, 265, 265, 265, 265,
    265, 265, 265, 265, 265, 265, 265, 265,

    1559, 1559, 1560, 1561, 1560, 1561, 1559, 1559,
    1559, 1560, 1561, 1559, 1560, 1561, 1345, 1345,
    1345, 1345, 1345, 1345, 1345, 1345, 1344, 1562,
    1563, 1564, 1565, 1566, 1560, 1561, 1566, 1566,

    1567, 1568, 1512, 1513, 1512, 1513, 1512, 1513,
    1512, 1513, 1564, 1564, 1564, 1564, 1569, 1570,
    1564, 1571, 1572, 1573, 1573, 1572, 1572, 1572,
    1572, 1572, 1574, 1574, 1575, 1576, 1576, 1577,

    1578, 1576, 1579, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    1580, 1580, 1580, 1580, 1580, 1580, 1580, 1580,
    1580, 1580, 1580, 1580, 1580, 1580, 1580, 1580,
    1580, 1580, 1580, 1580, 1580, 1580, 1580, 1580,
    1580, 1580, 200, 1580, 1580, 1580, 1580, 1581,

    1580, 1580, 1580, 1580, 1580, 1580, 1580, 1580,
    1580, 1580, 1580, 1580, 1580, 1580, 1580, 1580,
    1580, 1580, 1580, 1580, 1580, 1580, 1580, 1580,
    1580, 1580, 1580, 1580, 1580, 1580, 1580, 1580,

    1580, 1580, 1580, 1580, 1580, 1580, 1580, 1580,
    1580, 1580, 1580, 1580, 1580, 1580, 1580, 1580,
    1580, 1580, 1580, 1581, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    1581, 1581, 1581, 1581, 1581, 1581, 1581, 1581,
    1581, 1581, 1581, 1581, 1581, 1581, 1581, 1581,
    1581, 1581, 1581, 1581, 1581, 1581, 1581, 1581,
    1581, 1581, 1581, 1581, 1581, 1581, 1581, 1581,

    1581, 1581, 1581, 1581, 1581, 1581, 1581, 1581,
    1581, 1581, 1581, 1581, 1581, 1581, 1581, 1581,
    1581, 1581, 1581, 1581, 1581, 1581, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    1582, 1582, 1582, 1582, 1582, 1582, 1582, 1582,
    1582, 1582, 1582, 1582, 200, 200, 200, 200,

    1299, 1583, 1584, 1585, 1441, 1586, 1587, 1588,
    16, 1336, 16, 1336, 16, 1336, 16, 1336,
    16, 1336, 1441, 1441, 16, 1336, 16, 1336,
    16, 1336, 16, 1336, 1589, 1314, 1590, 1590,

    1441, 1588, 1588, 1588, 1588, 1588, 1588, 1588,
    1588, 1588, 1591, 1592, 172, 1593, 1594, 1594,
    1595, 1596, 1596, 1596, 1596, 1597, 1598, 1441,
    1599, 1599, 1599, 1600, 1601, 1602, 1582, 1441,

    200, 1603, 1604, 1603, 1604, 1603, 1604, 1603,
    1604, 1603, 1604, 1604, 1605, 1604, 1605, 1604,
    1605, 1604, 1605, 1604, 1605, 1604, 1605, 1604,
    1605, 1604, 1605, 1604, 1605, 1604, 1605, 1604,

    1605, 1604, 1605, 1603, 1604, 1605, 1604, 1605,
    1604, 1605, 1604, 1604, 1604, 1604, 1604, 1604,
    1605, 1605, 1604, 1605, 1605, 1604, 1605, 1605,
    1604, 1605, 1605, 1604, 1605, 1605, 1604, 1604,

    1604, 1604, 1604, 1603, 1604, 1603, 1604, 1603,
    1604, 1604, 1604, 1604, 1604, 1604, 1603, 1604,
    1604, 1604, 1604, 1604, 1605, 1606, 1606, 200,
    200, 1607, 1607, 1608, 1608, 1609, 1610, 1611,

    1612, 1613, 1614, 1613, 1614, 1613, 1614, 1613,
    1614, 1613, 1614, 1614, 1615, 1614, 1615, 1614,
    1615, 1614, 1615, 1614, 1615, 1614, 1615, 1614,
    1615, 1614, 1615, 1614, 1615, 1614, 1615, 1614,

    1615, 1614, 1615, 1613, 1614, 1615, 1614, 1615,
    1614, 1615, 1614, 1614, 1614, 1614, 1614, 1614,
    1615, 1615, 1614, 1615, 1615, 1614, 1615, 1615,
    1614, 1615, 1615, 1614, 1615, 1615, 1614, 1614,

    1614, 1614, 1614, 1613, 1614, 1613, 1614, 1613,
    1614, 1614, 1614, 1614, 1614, 1614, 1613, 1614,
    1614, 1614, 1614, 1614, 1615, 1613, 1613, 1615,
    1615, 1615, 1615, 1616, 1617, 1618, 1619, 1620,

    200, 200, 200, 200, 200, 1621, 1621, 1621,
    1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621,
    1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621,
    1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621,

    1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621,
    1621, 1621, 1621, 1621, 1621, 1622, 200, 200,
    200, 1623, 1623, 1623, 1623, 1623, 1623, 1623,
    1623, 1623, 1623, 1623, 1623, 1623, 1623, 1623,

    1623, 1623, 1623, 1623, 1623, 1623, 1623, 1623,
    1623, 1623, 1623, 1623, 1623, 1623, 1623, 1623,
    1623, 1623, 1623, 1623, 1623, 1623, 1623, 1623,
    1623, 1623, 1623, 1623, 1623, 1623, 1623, 1623,

    1623, 1623, 1623, 1623, 1623, 1623, 1623, 1623,
    1623, 1623, 1623, 1623, 1623, 1623, 1623, 200,
    1624, 1624, 1625, 1625, 1625, 1625, 1626, 1626,
    1626, 1626, 1626, 1626, 1626, 1626, 1626, 1626,

    1627, 1627, 1627, 1627, 1627, 1627, 1627, 1627,
    1627, 1627, 1627, 1627, 1627, 1627, 1627, 1627,
    1627, 1627, 1627, 1627, 1627, 1627, 1627, 1627,
    1628, 1628, 1628, 200, 200, 200, 200, 200,

    1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478,
    1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478,
    1482, 1482, 1482, 1482, 1482, 1482, 1482, 1482,
    1482, 1482, 1482, 1482, 1482, 1482, 1482, 1482,

    1482, 1482, 1482, 1482, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    1629, 1629, 1629, 1629, 1629, 1629, 1629, 1629,
    1629, 1629, 1629, 1629, 1629, 1629, 1629, 1629,

    1630, 1630, 1630, 1630, 1630, 1630, 1630, 1630,
    1630, 1630, 1630, 1630, 1630, 1630, 1630, 1630,
    1630, 1630, 1630, 1630, 1630, 1630, 1630, 1630,
    1630, 1630, 1630, 1630, 1630, 1631, 1631, 200,

    1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625,
    1625, 1625, 1626, 1626, 1626, 1626, 1626, 1626,
    1626, 1626, 1626, 1626, 1626, 1626, 1626, 1626,
    1626, 1626, 1626, 1626, 1626, 1626, 1626, 1626,

    1626, 1626, 1626, 1626, 1632, 1632, 1632, 1632,
    1633, 1633, 1633, 1633, 1633, 1633, 1633, 1633,
    1634, 1635, 1635, 1635, 1635, 1635, 1635, 1635,
    1635, 1635, 1635, 1635, 1635, 1635, 1635, 1635,

    1630, 1630, 1630, 1630, 1630, 1630, 1630, 1630,
    1630, 1630, 1630, 1630, 1630, 1630, 1630, 1630,
    1630, 1630, 1630, 1630, 1630, 1630, 1630, 1630,
    1630, 1630, 1630, 1630, 1631, 1631, 1636, 1624,

    1626, 1626, 1626, 1626, 1626, 1626, 1626, 1626,
    1626, 1626, 1626, 1626, 1626, 1626, 1626, 1626,
    1626, 1635, 1635, 1635, 1635, 1635, 1635, 1635,
    1635, 1635, 1635, 1635, 1635, 1635, 1635, 1635,

    1626, 1626, 1626, 1626, 1626, 1626, 1626, 1626,
    1626, 1626, 1626, 1626, 1634, 1634, 1634, 1634,
    1637, 1637, 1637, 1637, 1637, 1637, 1637, 1637,
    1637, 1637, 1637, 1637, 1637, 1637, 1637, 1637,

    1637, 1637, 1637, 1637, 1637, 1637, 1637, 1637,
    1637, 1637, 1637, 1637, 1637, 1637, 1637, 1637,
    1637, 1637, 1637, 1637, 1637, 1637, 1637, 1637,
    1637, 1637, 1637, 1637, 1637, 1637, 1637, 200,

    1637, 1637, 1637, 1637, 1637, 1637, 1637, 1637,
    1637, 1637, 1637, 1637, 1637, 1637, 1637, 1637,
    1637, 1637, 1637, 1637, 1637, 1637, 1637, 1637,
    1637, 1637, 1637, 1637, 1637, 1637, 1637, 1637,

    1637, 1637, 1637, 1637, 1637, 1637, 1637, 1637,
    1637, 1637, 1637, 1637, 1637, 1637, 1637, 1637,
    1637, 1637, 1637, 1637, 1637, 1637, 1637, 1637,
    1626, 1626, 1626, 1626, 1626, 1626, 1626, 1626,

    1626, 1626, 1626, 1626, 1626, 1626, 1626, 1626,
    1626, 1626, 1626, 1626, 1626, 1626, 1626, 1626,
    1626, 1626, 1626, 1626, 1626, 1626, 1626, 1634,
    1634, 1634, 1634, 1626, 1626, 1626, 1626, 1626,

    1626, 1626, 1626, 1626, 1626, 1626, 1626, 1626,
    1626, 1626, 1626, 1626, 1626, 1626, 1626, 1626,
    1626, 1626, 1626, 1626, 1626, 1626, 1626, 1626,
    1626, 1626, 1626, 1626, 1626, 1626, 1626, 1626,

    1626, 1626, 1626, 1626, 1626, 1626, 1626, 1626,
    1626, 1626, 1626, 1626, 1626, 1626, 1626, 1626,
    1626, 1626, 1626, 1626, 1626, 1626, 1626, 1626,
    1626, 1626, 1626, 1626, 1626, 1626, 1634, 1634,

    1626, 1626, 1626, 1626, 1626, 1626, 1626, 1626,
    1626, 1626, 1626, 1626, 1626, 1626, 1626, 1626,
    1626, 1626, 1626, 1626, 1626, 1626, 1626, 1626,
    1626, 1626, 1626, 1626, 1626, 1626, 1626, 1634,

    1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638,
    1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638,
    1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638,
    1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638,

    1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638,
    1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638,
    1638, 1638, 1638, 1638, 1638, 1638, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,

    1446, 1446, 1446, 1446, 1446, 1446, 1446, 1446,
    1446, 1446, 1446, 1446, 1446, 1446, 1446, 1446,
    1446, 1446, 1446, 1446, 1446, 1446, 1446, 1446,
    1446, 1446, 1446, 1446, 1446, 1446, 1446, 1446,

    1640, 1640, 1640, 1640, 1640, 1640, 1640, 1640,
    1640, 1640, 1640, 1640, 1640, 1640, 1640, 1640,
    1640, 1640, 1640, 1640, 1640, 1640, 1640, 1640,
    1640, 1640, 1640, 1640, 1640, 1640, 1640, 1640,

    1640, 1640, 1640, 1640, 1640, 1640, 1641, 1641,
    1641, 1641, 1641, 1641, 1641, 1641, 1641, 1641,
    1641, 1641, 1641, 1641, 1641, 1641, 1641, 1641,
    1641, 1641, 1641, 1641, 1642, 1642, 1642, 1642,

    1642, 1642, 1642, 1642, 1643, 1643, 1643, 1643,
    1643, 1643, 1643, 1643, 1644, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,

    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,

    1646, 1646, 1646, 1646, 1646, 1646, 1646, 1646,
    1646, 1646, 1646, 1646, 1646, 1646, 1646, 1646,
    1646, 1646, 1646, 1646, 1646, 1647, 1646, 1646,
    1646, 1646, 1646, 1646, 1646, 1646, 1646, 1646,

    1646, 1646, 1646, 1646, 1646, 1646, 1646, 1646,
    1646, 1646, 1646, 1646, 1646, 1646, 1646, 1646,
    1646, 1646, 1646, 1646, 1646, 1646, 1646, 1646,
    1646, 1646, 1646, 1646, 1646, 1646, 1646, 1646,

    1646, 1646, 1646, 1646, 1646, 1646, 1646, 1646,
    1646, 1646, 1646, 1646, 1646, 200, 200, 200,
    1648, 1648, 1648, 1648, 1648, 1648, 1648, 1648,
    1648, 1648, 1648, 1648, 1648, 1648, 1648, 1648,

    1648, 1648, 1649, 1649, 1648, 1648, 1648, 1648,
    1648, 1648, 1648, 1648, 1648, 1648, 1648, 1648,
    1648, 1648, 1648, 1648, 1649, 1648, 1648, 1648,
    1648, 1648, 1648, 1648, 1648, 1648, 1648, 1648,

    1648, 1649, 1648, 1648, 1648, 1649, 1648, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    1650, 1650, 1650, 1650, 1650, 1650, 1650, 1650,
    1650, 1650, 1650, 1650, 1650, 1650, 1650, 1650,

    1650, 1650, 1650, 1650, 1650, 1650, 1650, 1650,
    1650, 1650, 1650, 1650, 1650, 1650, 1650, 1650,
    1650, 1650, 1650, 1650, 1650, 1650, 1650, 1650,
    1651, 1651, 1651, 1651, 1651, 1651, 1652, 1653,

    1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654,
    1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654,
    1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654,
    1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654,

    1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654,
    1654, 1654, 1654, 1654, 1655, 1656, 1657, 1658,
    1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654,
    1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654,

    1659, 1660, 1661, 1662, 1663, 1664, 1665, 1666,
    1667, 1668, 1654, 1654, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    279, 280, 279, 280, 279, 280, 279, 280,
    279, 280, 279, 280, 279, 280, 279, 280,
    279, 280, 279, 280, 279, 280, 279, 280,
    279, 280, 279, 280, 279, 280, 279, 280,

    283, 284, 279, 280, 279, 280, 279, 280,
    279, 280, 279, 280, 279, 280, 1669, 265,
    1670, 1670, 1670, 1671, 1672, 1672, 1672, 1672,
    1672, 1672, 1672, 1672, 265, 265, 1671, 1673,

    279, 280, 279, 280, 279, 280, 279, 280,
    279, 280, 279, 280, 279, 280, 279, 280,
    279, 280, 279, 280, 279, 280, 279, 280,
    285, 286, 285, 286, 1674, 1674, 1675, 1672,

    1676, 1676, 1676, 1676, 1676, 1676, 1676, 1676,
    1676, 1676, 1676, 1676, 1676, 1676, 1676, 1676,
    1676, 1676, 1676, 1676, 1676, 1676, 1676, 1676,
    1676, 1676, 1676, 1676, 1676, 1676, 1676, 1676,

    1676, 1676, 1676, 1676, 1676, 1676, 1677, 1677,
    1677, 1677, 1677, 1677, 1677, 1677, 1677, 1677,
    1678, 1678, 1679, 1680, 1681, 1681, 1681, 1680,
    200, 200, 200, 200, 200, 200, 200, 200,

    1682, 1682, 1682, 1682, 1682, 1682, 1682, 1682,
    1682, 1682, 1682, 1682, 1682, 1682, 1682, 1682,
    1682, 1682, 1682, 1682, 1682, 1682, 1682, 1683,
    1683, 1683, 1683, 1570, 1570, 1570, 1570, 1570,

    1684, 1684, 1185, 1186, 1185, 1186, 1185, 1186,
    1185, 1186, 1185, 1186, 1185, 1186, 1185, 1186,
    1183, 1183, 1185, 1186, 1185, 1186, 1185, 1186,
    1185, 1186, 1185, 1186, 1185, 1186, 1185, 1186,

    1185, 1186, 1185, 1186, 1185, 1186, 1185, 1186,
    1185, 1186, 1185, 1186, 1185, 1186, 1185, 1186,
    1185, 1186, 1185, 1186, 1185, 1186, 1185, 1186,
    1185, 1186, 1185, 1186, 1185, 1186, 1185, 1186,

    1185, 1186, 1185, 1186, 1185, 1186, 1185, 1186,
    1185, 1186, 1185, 1186, 1185, 1186, 1185, 1186,
    1537, 1183, 1183, 1183, 1183, 1183, 1183, 1183,
    1183, 1185, 1186, 1185, 1186, 1685, 1185, 1186,

    1185, 1186, 1185, 1186, 1185, 1186, 1185, 1186,
    1570, 1686, 1686, 1185, 1186, 1687, 1688, 1689,
    1690, 1691, 1692, 1693, 1694, 1694, 1695, 1696,
    1695, 1696, 1695, 1696, 1695, 1696, 1695, 1696,

    1690, 1691, 1690, 1691, 1690, 1691, 1690, 1691,
    1690, 1691, 1697, 1698, 1699, 1700, 200, 200,
    1701, 1702, 1703, 1704, 1705, 1706, 1705, 1706,
    200, 200, 200, 200, 200, 200, 200, 200,

    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 1707,
    1708, 1708, 1688, 1709, 1709, 1709, 1709, 1709,

    1710, 1710, 1711, 1710, 1710, 1710, 1712, 1710,
    1710, 1710, 1710, 1711, 1710, 1710, 1710, 1710,
    1710, 1710, 1710, 1710, 1710, 1710, 1710, 1710,
    1710, 1710, 1710, 1710, 1710, 1710, 1710, 1710,

    1710, 1710, 1710, 1713, 1713, 1711, 1711, 1713,
    1714, 1714, 1714, 1714, 200, 200, 200, 200,
    1633, 1633, 1633, 1633, 1633, 1633, 778, 778,
    1376, 1715, 200, 200, 200, 200, 200, 200,

    1716, 1716, 1716, 1716, 1716, 1716, 1716, 1716,
    1716, 1716, 1716, 1716, 1716, 1716, 1716, 1716,
    1716, 1716, 1716, 1716, 1716, 1716, 1716, 1716,
    1716, 1716, 1716, 1716, 1716, 1716, 1716, 1716,

    1716, 1716, 1716, 1716, 1716, 1716, 1716, 1716,
    1716, 1716, 1716, 1716, 1716, 1716, 1716, 1716,
    1716, 1716, 1717, 1718, 1719, 1719, 1720, 1720,
    200, 200, 200, 200, 200, 200, 200, 200,

    1721, 1721, 1722, 1722, 1722, 1722, 1722, 1722,
    1722, 1722, 1722, 1722, 1722, 1722, 1722, 1722,
    1722, 1722, 1722, 1722, 1722, 1722, 1722, 1722,
    1722, 1722, 1722, 1722, 1722, 1722, 1722, 1722,

    1722, 1722, 1722, 1722, 1722, 1722, 1722, 1722,
    1722, 1722, 1722, 1722, 1722, 1722, 1722, 1722,
    1722, 1722, 1722, 1722, 1721, 1721, 1721, 1721,
    1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721,

    1721, 1721, 1721, 1721, 1723, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 1724, 1724,
    1725, 1726, 1727, 1728, 1729, 1730, 1731, 1732,
    1733, 1734, 200, 200, 200, 200, 200, 200,

    1735, 1735, 1735, 1735, 1735, 1735, 1735, 1735,
    1735, 1735, 1735, 1735, 1735, 1735, 1735, 1735,
    1735, 1735, 493, 493, 493, 493, 493, 493,
    1736, 1736, 1736, 493, 1737, 1738, 200, 200,

    1739, 1740, 1741, 1742, 1743, 1744, 1745, 1746,
    1747, 1748, 1749, 1749, 1749, 1749, 1749, 1749,
    1749, 1749, 1749, 1749, 1749, 1749, 1749, 1749,
    1749, 1749, 1749, 1749, 1749, 1749, 1749, 1749,

    1749, 1749, 1749, 1749, 1749, 1749, 1750, 1750,
    1750, 1750, 1750, 1751, 1751, 1751, 1752, 1753,
    1754, 1754, 1754, 1754, 1754, 1754, 1754, 1754,
    1754, 1754, 1754, 1754, 1754, 1754, 1754, 1754,

    1754, 1754, 1754, 1754, 1754, 1754, 1754, 1755,
    1755, 1755, 1755, 1755, 1755, 1755, 1755, 1755,
    1755, 1755, 1756, 1757, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 1758,

    828, 828, 828, 828, 828, 828, 828, 828,
    828, 828, 828, 828, 828, 828, 828, 828,
    828, 828, 828, 828, 828, 828, 828, 828,
    828, 828, 828, 828, 828, 200, 200, 200,

    1759, 1759, 1759, 1760, 1761, 1761, 1761, 1761,
    1761, 1761, 1761, 1761, 1761, 1761, 1761, 1761,
    1761, 1761, 1761, 1761, 1761, 1761, 1761, 1761,
    1761, 1761, 1761, 1761, 1761, 1761, 1761, 1761,

    1761, 1761, 1761, 1761, 1761, 1761, 1761, 1761,
    1761, 1761, 1761, 1761, 1761, 1761, 1761, 1761,
    1761, 1761, 1761, 1762, 1760, 1760, 1759, 1759,
    1759, 1759, 1760, 1760, 1759, 1760, 1760, 1760,

    1763, 1764, 1764, 1764, 1764, 1764, 1764, 1765,
    1766, 1766, 1764, 1764, 1764, 1764, 200, 1767,
    1768, 1769, 1770, 1771, 1772, 1773, 1774, 1775,
    1776, 1777, 200, 200, 200, 200, 1764, 1764,

    1778, 1778, 1778, 1778, 1778, 1779, 1780, 1778,
    1778, 1778, 1778, 1778, 1778, 1778, 1778, 1778,
    1781, 1782, 1783, 1784, 1785, 1786, 1787, 1788,
    1789, 1790, 1778, 1778, 1778, 1778, 1778, 200,

    1791, 1791, 1791, 1791, 1791, 1791, 1791, 1791,
    1791, 1791, 1791, 1791, 1791, 1791, 1791, 1791,
    1791, 1791, 1791, 1791, 1791, 1791, 1791, 1791,
    1791, 1791, 1791, 1791, 1791, 1791, 1791, 1791,

    1791, 1791, 1791, 1791, 1791, 1791, 1791, 1791,
    1791, 1792, 1792, 1792, 1792, 1792, 1792, 1793,
    1793, 1792, 1792, 1793, 1793, 1792, 1792, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    1791, 1791, 1791, 1792, 1791, 1791, 1791, 1791,
    1791, 1791, 1791, 1791, 1792, 1793, 200, 200,
    1794, 1795, 1796, 1797, 1798, 1799, 1800, 1801,
    1802, 1803, 200, 200, 1804, 1805, 1805, 1805,

    1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806,
    1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806,
    1807, 1806, 1806, 1806, 1806, 1806, 1806, 1808,
    1808, 1808, 1806, 816, 1779, 1809, 1778, 1778,

    1810, 1810, 1810, 1810, 1810, 1810, 1810, 1810,
    1810, 1810, 1810, 1810, 1810, 1810, 1810, 1810,
    1810, 1810, 1810, 1810, 1810, 1810, 1810, 1810,
    1810, 1810, 1810, 1810, 1810, 1810, 1810, 1810,

    1810, 1810, 1810, 1810, 1810, 1810, 1810, 1810,
    1810, 1810, 1810, 1810, 1810, 1810, 1810, 1810,
    1811, 1810, 1811, 1811, 1812, 1810, 1810, 1811,
    1811, 1810, 1810, 1810, 1810, 1810, 1811, 1811,

    1810, 1811, 1810, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 1810, 1810, 1813, 1814, 1814,

    1815, 1815, 1815, 1815, 1815, 1815, 1815, 1815,
    1815, 1815, 1815, 1816, 1817, 1817, 1816, 1816,
    1818, 1818, 1815, 1819, 1819, 1816, 1820, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    200, 1821, 1821, 1821, 1821, 1821, 1821, 200,
    200, 1821, 1821, 1821, 1821, 1821, 1821, 200,
    200, 1821, 1821, 1821, 1821, 1821, 1821, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    1821, 1821, 1821, 1821, 1821, 1821, 1821, 200,
    1821, 1821, 1821, 1821, 1821, 1821, 1821, 200,
    1694, 1694, 1694, 1694, 1694, 1694, 1694, 1694,
    1694, 1694, 1694, 1694, 1694, 1694, 1694, 1694,

    1694, 1694, 1694, 1694, 1694, 1694, 1694, 1694,
    1694, 1694, 1694, 1694, 1694, 1694, 1694, 1694,
    1694, 1694, 1694, 1822, 1694, 1694, 1694, 1694,
    1694, 1694, 1694, 1823, 1824, 1824, 1824, 1824,

    1825, 1825, 1825, 1825, 1694, 1826, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    1827, 1828, 1829, 1830, 1831, 1832, 1833, 1834,
    1835, 1836, 1837, 1838, 1839, 1840, 1841, 1842,

    1843, 1844, 1845, 1846, 1847, 1848, 1849, 1850,
    1851, 1852, 1853, 1854, 1855, 1856, 1857, 1858,
    1859, 1860, 1861, 1862, 1863, 1864, 1865, 1866,
    1867, 1868, 1869, 1870, 1871, 1872, 1873, 1874,

    1875, 1876, 1877, 1878, 1879, 1880, 1881, 1882,
    1883, 1884, 1885, 1886, 1887, 1888, 1889, 1890,
    1891, 1892, 1893, 1894, 1895, 1896, 1897, 1898,
    1899, 1900, 1901, 1902, 1903, 1904, 1905, 1906,

    1907, 1907, 1907, 1907, 1907, 1907, 1907, 1907,
    1907, 1907, 1907, 1907, 1907, 1907, 1907, 1907,
    1907, 1907, 1907, 1907, 1907, 1907, 1907, 1907,
    1907, 1907, 1907, 1907, 1907, 1907, 1907, 1907,

    1907, 1907, 1907, 1908, 1908, 1909, 1908, 1908,
    1909, 1908, 1908, 1910, 1908, 1911, 200, 200,
    1912, 1913, 1914, 1915, 1916, 1917, 1918, 1919,
    1920, 1921, 200, 200, 200, 200, 200, 200,

    1922, 1923, 1923, 1923, 1923, 1923, 1923, 1923,
    1923, 1923, 1923, 1923, 1923, 1923, 1923, 1923,
    1923, 1923, 1923, 1923, 1923, 1923, 1923, 1923,
    1923, 1923, 1923, 1923, 1922, 1923, 1923, 1923,

    1923, 1923, 1923, 1923, 1923, 1923, 1923, 1923,
    1923, 1923, 1923, 1923, 1923, 1923, 1923, 1923,
    1923, 1923, 1923, 1923, 1923, 1923, 1923, 1923,
    1922, 1923, 1923, 1923, 1923, 1923, 1923, 1923,

    1923, 1923, 1923, 1923, 1923, 1923, 1923, 1923,
    1923, 1923, 1923, 1923, 1923, 1923, 1923, 1923,
    1923, 1923, 1923, 1923, 1922, 1923, 1923, 1923,
    1923, 1923, 1923, 1923, 1923, 1923, 1923, 1923,

    1923, 1923, 1923, 1923, 1923, 1923, 1923, 1923,
    1923, 1923, 1923, 1923, 1923, 1923, 1923, 1923,
    1922, 1923, 1923, 1923, 1923, 1923, 1923, 1923,
    1923, 1923, 1923, 1923, 1923, 1923, 1923, 1923,

    1923, 1923, 1923, 1923, 1923, 1923, 1923, 1923,
    1923, 1923, 1923, 1923, 1922, 1923, 1923, 1923,
    1923, 1923, 1923, 1923, 1923, 1923, 1923, 1923,
    1923, 1923, 1923, 1923, 1923, 1923, 1923, 1923,

    1923, 1923, 1923, 1923, 1923, 1923, 1923, 1923,
    1922, 1923, 1923, 1923, 1923, 1923, 1923, 1923,
    1923, 1923, 1923, 1923, 1923, 1923, 1923, 1923,
    1923, 1923, 1923, 1923, 1923, 1923, 1923, 1923,

    1923, 1923, 1923, 1923, 1922, 1923, 1923, 1923,
    1923, 1923, 1923, 1923, 1923, 1923, 1923, 1923,
    1923, 1923, 1923, 1923, 1923, 1923, 1923, 1923,
    1923, 1923, 1923, 1923, 1923, 1923, 1923, 1923,

    1923, 1923, 1923, 1923, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    831, 831, 831, 831, 831, 831, 831, 831,
    831, 831, 831, 831, 831, 831, 831, 831,

    831, 831, 831, 831, 831, 831, 831, 200,
    200, 200, 200, 834, 834, 834, 834, 834,
    834, 834, 834, 834, 834, 834, 834, 834,
    834, 834, 834, 834, 834, 834, 834, 834,

    834, 834, 834, 834, 834, 834, 834, 834,
    834, 834, 834, 834, 834, 834, 834, 834,
    834, 834, 834, 834, 834, 834, 834, 834,
    834, 834, 834, 834, 200, 200, 200, 200,

    1924, 1924, 1924, 1924, 1924, 1924, 1924, 1924,
    1924, 1924, 1924, 1924, 1924, 1924, 1924, 1924,
    1924, 1924, 1924, 1924, 1924, 1924, 1924, 1924,
    1924, 1924, 1924, 1924, 1924, 1924, 1924, 1924,

    1925, 1925, 1925, 1925, 1925, 1925, 1925, 1925,
    1925, 1925, 1925, 1925, 1925, 1925, 1925, 1925,
    1925, 1925, 1925, 1925, 1925, 1925, 1925, 1925,
    1925, 1925, 1925, 1925, 1925, 1925, 1925, 1925,

    1926, 1926, 1926, 1926, 1926, 1926, 1926, 1926,
    1926, 1926, 1926, 1926, 1926, 1926, 1926, 1926,
    1926, 1926, 1926, 1926, 1926, 1926, 1926, 1926,
    1926, 1926, 1926, 1926, 1926, 1926, 1926, 1926,

    1926, 1926, 1926, 1926, 1926, 1926, 1926, 1926,
    1926, 1926, 1926, 1926, 1926, 1926, 1640, 1640,
    1926, 1640, 1926, 1640, 1640, 1926, 1926, 1926,
    1926, 1926, 1926, 1926, 1926, 1926, 1926, 1640,

    1926, 1640, 1926, 1640, 1640, 1926, 1926, 1640,
    1640, 1640, 1926, 1926, 1926, 1926, 1927, 1927,
    1928, 1928, 1928, 1928, 1928, 1928, 1928, 1928,
    1928, 1928, 1928, 1928, 1928, 1928, 1928, 1928,

    1928, 1928, 1928, 1928, 1928, 1928, 1928, 1928,
    1928, 1928, 1928, 1928, 1928, 1928, 1928, 1928,
    1928, 1928, 1928, 1928, 1928, 1928, 1928, 1928,
    1928, 1928, 1928, 1928, 1928, 1928, 1928, 1928,

    1928, 1928, 1928, 1928, 1928, 1928, 1928, 1928,
    1928, 1928, 1928, 1929, 1929, 1929, 1639, 1639,
    1930, 1930, 1930, 1930, 1930, 1930, 1930, 1930,
    1930, 1930, 1930, 1930, 1930, 1930, 1930, 1930,

    1930, 1930, 1930, 1930, 1930, 1930, 1930, 1930,
    1930, 1930, 1930, 1930, 1930, 1930, 1930, 1930,
    1930, 1930, 1930, 1930, 1930, 1930, 1930, 1930,
    1930, 1930, 1930, 1930, 1930, 1930, 1930, 1930,

    1930, 1930, 1930, 1930, 1930, 1930, 1930, 1930,
    1930, 1930, 1930, 1930, 1930, 1930, 1930, 1930,
    1930, 1930, 1930, 1930, 1930, 1930, 1930, 1930,
    1930, 1930, 1639, 1639, 1639, 1639, 1639, 1639,

    1931, 1932, 1933, 1934, 1935, 1936, 1936, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 1937, 1938, 1939, 1940, 1941,
    200, 200, 200, 200, 200, 1942, 1943, 1944,

    1945, 1945, 1945, 1945, 1945, 1945, 1945, 1945,
    1945, 1946, 1944, 1944, 1944, 1944, 1944, 1944,
    1944, 1944, 1944, 1944, 1944, 1944, 1944, 297,
    1944, 1944, 1944, 1944, 1944, 297, 1944, 297,

    1944, 1944, 297, 1944, 1944, 297, 1944, 1944,
    1944, 1944, 1944, 1944, 1944, 1944, 1944, 1945,
    1947, 1947, 1947, 1947, 1947, 1947, 1947, 1947,
    1947, 1947, 1947, 1947, 1947, 1947, 1947, 1947,

    1947, 1947, 1947, 1947, 1947, 1947, 1947, 1947,
    1947, 1947, 1947, 1947, 1947, 1947, 1947, 1947,
    1947, 1947, 1947, 1947, 1947, 1947, 1947, 1947,
    1947, 1947, 1947, 1947, 1947, 1947, 1947, 1947,

    1947, 1947, 1947, 1947, 1947, 1947, 1947, 1947,
    1947, 1947, 1947, 1947, 1947, 1947, 1947, 1947,
    1947, 1947, 1948, 1948, 1948, 1948, 1948, 1948,
    1948, 1948, 1948, 1948, 1948, 1948, 1948, 1948,

    1948, 1948, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 1947, 1947, 1947, 1947, 1947,
    1947, 1947, 1947, 1947, 1947, 1947, 1947, 1947,

    1947, 1947, 1947, 1947, 1947, 1947, 1947, 1947,
    1947, 1947, 1947, 1947, 1947, 1947, 1947, 1947,
    1947, 1947, 1947, 1947, 1947, 1947, 1947, 1947,
    1947, 1947, 1947, 1947, 1947, 1947, 1590, 1314,

    343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343,
    1947, 1947, 1947, 1947, 1947, 1947, 1947, 1947,
    1947, 1947, 1947, 1947, 1947, 1947, 1947, 1947,

    1947, 1947, 1947, 1947, 1947, 1947, 1947, 1947,
    1947, 1947, 1947, 1947, 1947, 1947, 1947, 1947,
    343, 343, 1947, 1947, 1947, 1947, 1947, 1947,
    1947, 1947, 1947, 1947, 1947, 1947, 1947, 1947,

    1947, 1947, 1947, 1947, 1947, 1947, 1947, 1947,
    343, 343, 343, 343, 343, 343, 343, 343,
    1949, 1949, 1949, 1949, 1949, 1949, 1949, 1949,
    1949, 1949, 1949, 1949, 1949, 1949, 1949, 1949,

    1949, 1949, 1949, 1949, 1949, 1949, 1949, 1949,
    1949, 1949, 1949, 1949, 1949, 1949, 1949, 1949,
    1947, 1947, 1947, 1947, 1947, 1947, 1947, 1947,
    1947, 1947, 1947, 1947, 1950, 335, 343, 343,

    1951, 1951, 1951, 1951, 1951, 1951, 1951, 1951,
    1951, 1951, 1951, 1951, 1951, 1951, 1951, 1951,
    1952, 1953, 1954, 1955, 1956, 1957, 1957, 1958,
    1959, 1960, 200, 200, 200, 200, 200, 200,

    171, 171, 171, 171, 1171, 1171, 1171, 1071,
    1071, 1071, 1071, 1071, 1071, 1071, 1675, 1675,
    1961, 1962, 1962, 1963, 1963, 1964, 1965, 1964,
    1965, 1964, 1965, 1964, 1965, 1964, 1965, 1964,

    1965, 1964, 1965, 1964, 1965, 1602, 1602, 1966,
    1967, 1961, 1961, 1961, 1961, 1963, 1963, 1963,
    1968, 1969, 1970, 200, 1971, 1972, 1973, 1973,
    1962, 1367, 1368, 1367, 1368, 1367, 1368, 1974,

    1961, 1961, 1975, 1976, 1977, 1978, 1979, 200,
    1961, 1370, 1328, 1961, 200, 200, 200, 200,
    1947, 1947, 1947, 1980, 1947, 343, 1947, 1947,
    1947, 1947, 1947, 1947, 1947, 1947, 1947, 1947,

    1947, 1947, 1947, 1947, 1947, 1947, 1947, 1947,
    1947, 1947, 1947, 1947, 1947, 1947, 1947, 1947,
    1947, 1947, 1947, 1947, 1947, 1947, 1947, 1947,
    1947, 1947, 1947, 1947, 1947, 343, 343, 1981,

    200, 1973, 1961, 1974, 1370, 1328, 1961, 1982,
    1367, 1368, 1961, 1975, 1968, 1976, 1970, 1983,
    1984, 1985, 1986, 1987, 1988, 1989, 1990, 1991,
    1992, 1993, 1972, 1971, 1994, 1979, 1995, 1973,

    1961, 1996, 1996, 1996, 1996, 1996, 1996, 1996,
    1996, 1996, 1996, 1996, 1996, 1996, 1996, 1996,
    1996, 1996, 1996, 1996, 1996, 1996, 1996, 1996,
    1996, 1996, 1996, 1997, 1961, 1998, 1999, 1963,

    1999, 2000, 2000, 2000, 2000, 2000, 2000, 2000,
    2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000,
    2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000,
    2000, 2000, 2000, 1997, 1979, 1998, 1979, 2001,

    2002, 2003, 1367, 1368, 2004, 2005, 2006, 2007,
    2007, 2007, 2007, 2007, 2007, 2007, 2007, 2007,
    2008, 2006, 2006, 2006, 2006, 2006, 2006, 2006,
    2006, 2006, 2006, 2006, 2006, 2006, 2006, 2006,

    2006, 2006, 2006, 2006, 2006, 2006, 2006, 2006,
    2006, 2006, 2006, 2006, 2006, 2006, 2006, 2006,
    2006, 2006, 2006, 2006, 2006, 2006, 2006, 2006,
    2006, 2006, 2006, 2006, 2006, 2006, 2009, 2009,

    2010, 2010, 2010, 2010, 2010, 2010, 2010, 2010,
    2010, 2010, 2010, 2010, 2010, 2010, 2010, 2010,
    2010, 2010, 2010, 2010, 2010, 2010, 2010, 2010,
    2010, 2010, 2010, 2010, 2010, 2010, 2010, 200,

    200, 200, 2010, 2010, 2010, 2010, 2010, 2010,
    200, 200, 2010, 2010, 2010, 2010, 2010, 2010,
    200, 200, 2010, 2010, 2010, 2010, 2010, 2010,
    200, 200, 2010, 2010, 2010, 200, 200, 200,

    2011, 1370, 1979, 1999, 1598, 1370, 1370, 200,
    1390, 1366, 1366, 1366, 1366, 1390, 1390, 200,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
    1351, 2012, 2012, 2012, 2013, 51, 2014, 2014,

    2015, 2015, 2015, 2015, 2015, 2015, 2015, 2015,
    2015, 2015, 2015, 2015, 200, 2015, 2015, 2015,
    2015, 2015, 2015, 2015, 2015, 2015, 2015, 2015,
    2015, 2015, 2015, 2015, 2015, 2015, 2015, 2015,

    2015, 2015, 2015, 2015, 2015, 2015, 2015, 200,
    2015, 2015, 2015, 2015, 2015, 2015, 2015, 2015,
    2015, 2015, 2015, 2015, 2015, 2015, 2015, 2015,
    2015, 2015, 2015, 200, 2015, 2015, 200, 2015,

    2015, 2015, 2015, 2015, 2015, 2015, 2015, 2015,
    2015, 2015, 2015, 2015, 2015, 2015, 200, 200,
    2015, 2015, 2015, 2015, 2015, 2015, 2015, 2015,
    2015, 2015, 2015, 2015, 2015, 2015, 200, 200,

    2015, 2015, 2015, 2015, 2015, 2015, 2015, 2015,
    2015, 2015, 2015, 2015, 2015, 2015, 2015, 2015,
    2015, 2015, 2015, 2015, 2015, 2015, 2015, 2015,
    2015, 2015, 2015, 2015, 2015, 2015, 2015, 2015,

    2015, 2015, 2015, 2015, 2015, 2015, 2015, 2015,
    2015, 2015, 2015, 2015, 2015, 2015, 2015, 2015,
    2015, 2015, 2015, 2015, 2015, 2015, 2015, 2015,
    2015, 2015, 2015, 200, 200, 200, 200, 200,

    2016, 2017, 2016, 200, 200, 200, 200, 2018,
    2018, 2018, 2018, 2018, 2018, 2018, 2018, 2018,
    2018, 2018, 2018, 2018, 2018, 2018, 2018, 2018,
    2018, 2018, 2018, 2018, 2018, 2018, 2018, 2018,

    2018, 2018, 2018, 2018, 2018, 2018, 2018, 2018,
    2018, 2018, 2018, 2018, 2018, 2018, 2018, 2018,
    2018, 2018, 2018, 2018, 200, 200, 200, 2019,
    2019, 2019, 2019, 2019, 2019, 2019, 2019, 2019,

    2020, 2020, 2020, 2020, 2020, 2020, 2020, 2020,
    2020, 2020, 2020, 2020, 2020, 2020, 2020, 2020,
    2020, 2020, 2020, 2020, 2020, 2020, 2020, 2020,
    2020, 2020, 2020, 2020, 2020, 2020, 2020, 2020,

    2020, 2020, 2020, 2020, 2020, 2020, 2020, 2020,
    2020, 2020, 2020, 2020, 2020, 2020, 2020, 2020,
    2020, 2020, 2020, 2020, 2020, 2021, 2021, 2021,
    2021, 2022, 2022, 2022, 2022, 2022, 2022, 2022,

    2022, 2022, 2022, 2022, 2022, 2022, 2022, 2022,
    2022, 2022, 2021, 2023, 2024, 200, 200, 200,
    1479, 1479, 1479, 1479, 1479, 1479, 1479, 1479,
    1479, 1479, 1479, 1479, 200, 200, 200, 200,

    2024, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412,
    1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412,

    1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412,
    1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412,
    1412, 1412, 1412, 1412, 1412, 1412, 1412, 1412,
    1412, 1412, 1412, 1412, 1412, 1174, 200, 200,

    2025, 2025, 2025, 2025, 2025, 2025, 2025, 2025,
    2025, 2025, 2025, 2025, 2025, 2025, 2025, 2025,
    2025, 2025, 2025, 2025, 2025, 2025, 2025, 2025,
    2025, 2025, 2025, 2025, 2025, 200, 200, 200,

    2026, 2026, 2026, 2026, 2026, 2026, 2026, 2026,
    2026, 2026, 2026, 2026, 2026, 2026, 2026, 2026,
    2026, 2026, 2026, 2026, 2026, 2026, 2026, 2026,
    2026, 2026, 2026, 2026, 2026, 2026, 2026, 2026,

    2026, 2026, 2026, 2026, 2026, 2026, 2026, 2026,
    2026, 2026, 2026, 2026, 2026, 2026, 2026, 2026,
    2026, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    1071, 2027, 2027, 2027, 2027, 2027, 2027, 2027,
    2027, 2027, 2027, 2027, 2027, 2027, 2027, 2027,
    2027, 2027, 2027, 2027, 2027, 2027, 2027, 2027,
    2027, 2027, 2027, 2027, 200, 200, 200, 200,

    2028, 2028, 2028, 2028, 2028, 2028, 2028, 2028,
    2028, 2028, 2028, 2028, 2028, 2028, 2028, 2028,
    2028, 2028, 2028, 2028, 2028, 2028, 2028, 2028,
    2028, 2028, 2028, 2028, 2028, 2028, 2028, 2029,

    2030, 2030, 2030, 2030, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    2031, 2031, 2031, 2031, 2031, 2031, 2031, 2031,
    2031, 2031, 2031, 2031, 2031, 2031, 2031, 2031,

    2031, 2032, 2031, 2031, 2031, 2031, 2031, 2031,
    2031, 2031, 2032, 200, 200, 200, 200, 200,
    2033, 2033, 2033, 2033, 2033, 2033, 2033, 2033,
    2033, 2033, 2033, 2033, 2033, 2033, 2033, 2033,

    2033, 2033, 2033, 2033, 2033, 2033, 2033, 2033,
    2033, 2033, 2033, 2033, 2033, 2033, 2033, 2033,
    2033, 2033, 2033, 2033, 2033, 2033, 2034, 2034,
    2034, 2034, 2034, 200, 200, 200, 200, 200,

    2035, 2035, 2035, 2035, 2035, 2035, 2035, 2035,
    2035, 2035, 2035, 2035, 2035, 2035, 2035, 2035,
    2035, 2035, 2035, 2035, 2035, 2035, 2035, 2035,
    2035, 2035, 2035, 2035, 2035, 2035, 200, 2036,

    2037, 2037, 2037, 2037, 2037, 2037, 2037, 2037,
    2037, 2037, 2037, 2037, 2037, 2037, 2037, 2037,
    2037, 2037, 2037, 2037, 2037, 2037, 2037, 2037,
    2037, 2037, 2037, 2037, 2037, 2037, 2037, 2037,

    2037, 2037, 2037, 2037, 200, 200, 200, 200,
    2037, 2037, 2037, 2037, 2037, 2037, 2037, 2037,
    2038, 2039, 2039, 2039, 2039, 2039, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    2040, 2040, 2040, 2040, 2040, 2040, 2040, 2040,
    2040, 2040, 2040, 2040, 2040, 2040, 2040, 2040,
    2040, 2040, 2040, 2040, 2040, 2040, 2040, 2040,
    2040, 2040, 2040, 2040, 2040, 2040, 2040, 2040,

    2040, 2040, 2040, 2040, 2040, 2040, 2041, 2041,
    2042, 2042, 2042, 2042, 2042, 2042, 2042, 2042,
    2042, 2042, 2042, 2042, 2042, 2042, 2042, 2042,
    2042, 2042, 2042, 2042, 2042, 2042, 2042, 2042,

    2042, 2042, 2042, 2042, 2042, 2042, 2042, 2042,
    2042, 2042, 2042, 2042, 2042, 2042, 2043, 2043,
    2044, 2044, 2044, 2044, 2044, 2044, 2044, 2044,
    2044, 2044, 2044, 2044, 2044, 2044, 2044, 2044,

    2044, 2044, 2044, 2044, 2044, 2044, 2044, 2044,
    2044, 2044, 2044, 2044, 2044, 2044, 2044, 2044,
    2044, 2044, 2044, 2044, 2044, 2044, 2044, 2044,
    2044, 2044, 2044, 2044, 2044, 2044, 2044, 2044,

    2045, 2045, 2045, 2045, 2045, 2045, 2045, 2045,
    2045, 2045, 2045, 2045, 2045, 2045, 2045, 2045,
    2045, 2045, 2045, 2045, 2045, 2045, 2045, 2045,
    2045, 2045, 2045, 2045, 2045, 2045, 200, 200,

    2046, 2047, 2048, 2049, 2050, 2051, 2052, 2053,
    2054, 2055, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    2056, 2056, 2056, 2056, 2056, 2056, 2056, 2056,
    2056, 2056, 2056, 2056, 2056, 2056, 2056, 2056,
    2056, 2056, 2056, 2056, 2056, 2056, 2056, 2056,
    2056, 2056, 2056, 2056, 2056, 2056, 2056, 2056,

    2056, 2056, 2056, 2056, 2056, 2056, 2056, 2056,
    200, 200, 200, 200, 200, 200, 200, 200,
    2057, 2057, 2057, 2057, 2057, 2057, 2057, 2057,
    2057, 2057, 2057, 2057, 2057, 2057, 2057, 2057,

    2057, 2057, 2057, 2057, 2057, 2057, 2057, 2057,
    2057, 2057, 2057, 2057, 2057, 2057, 2057, 2057,
    2057, 2057, 2057, 2057, 2057, 2057, 2057, 2057,
    2057, 2057, 2057, 2057, 2057, 2057, 2057, 2057,

    2057, 2057, 2057, 2057, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 2058,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059,
    2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059,
    2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059,
    2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059,

    2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059,
    2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059,
    2059, 2059, 2059, 2059, 2059, 2059, 2059, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059,
    2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059,
    2059, 2059, 2059, 2059, 2059, 2059, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    2060, 2060, 2060, 2060, 2060, 2060, 297, 297,
    2060, 297, 2060, 2060, 2060, 2060, 2060, 2060,
    2060, 2060, 2060, 2060, 2060, 2060, 2060, 2060,
    2060, 2060, 2060, 2060, 2060, 2060, 2060, 2060,

    2060, 2060, 2060, 2060, 2060, 2060, 2060, 2060,
    2060, 2060, 2060, 2060, 2060, 2060, 2060, 2060,
    2060, 2060, 2060, 2060, 2060, 2060, 297, 2060,
    2060, 297, 297, 297, 2060, 297, 297, 2060,

    2061, 2061, 2061, 2061, 2061, 2061, 2061, 2061,
    2061, 2061, 2061, 2061, 2061, 2061, 2061, 2061,
    2061, 2061, 2061, 2061, 2061, 2061, 297, 2062,
    2063, 2063, 2063, 2063, 2063, 2063, 2063, 2063,

    2064, 2064, 2064, 2064, 2064, 2064, 2064, 2064,
    2064, 2064, 2064, 2064, 2064, 2064, 2064, 2064,
    2064, 2064, 2064, 2064, 2064, 2064, 2064, 2065,
    2065, 2066, 2066, 2066, 2066, 2066, 2066, 2066,

    2067, 2067, 2067, 2067, 2067, 2067, 2067, 2067,
    2067, 2067, 2067, 2067, 2067, 2067, 2067, 2067,
    2067, 2067, 2067, 2067, 2067, 2067, 2067, 2067,
    2067, 2067, 2067, 2067, 2067, 2067, 2067, 297,

    297, 297, 297, 297, 297, 297, 297, 2068,
    2068, 2068, 2068, 2068, 2068, 2068, 2068, 2068,
    297, 297, 297, 297, 297, 297, 297, 297,
    297, 297, 297, 297, 297, 297, 297, 297,

    2069, 2069, 2069, 2069, 2069, 2069, 2069, 2069,
    2069, 2069, 2069, 2069, 2069, 2069, 2069, 2069,
    2069, 2069, 2069, 297, 2069, 2069, 297, 297,
    297, 297, 297, 2070, 2070, 2070, 2070, 2070,

    2071, 2071, 2071, 2071, 2071, 2071, 2071, 2071,
    2071, 2071, 2071, 2071, 2071, 2071, 2071, 2071,
    2071, 2071, 2071, 2071, 2071, 2071, 2072, 2072,
    2072, 2072, 2073, 2073, 297, 297, 297, 2074,

    2075, 2075, 2075, 2075, 2075, 2075, 2075, 2075,
    2075, 2075, 2075, 2075, 2075, 2075, 2075, 2075,
    2075, 2075, 2075, 2075, 2075, 2075, 2075, 2075,
    2075, 2075, 297, 297, 297, 297, 297, 2076,

    2077, 2077, 2077, 2077, 2077, 2077, 2077, 2077,
    2077, 2077, 2077, 2077, 2077, 2077, 2077, 2077,
    2077, 2077, 2077, 2077, 2077, 2077, 2077, 2077,
    2077, 2077, 2077, 2077, 2077, 2077, 2077, 2077,

    2078, 2078, 2078, 2078, 2078, 2078, 2078, 2078,
    2078, 2078, 2078, 2078, 2078, 2078, 2078, 2078,
    2078, 2078, 2078, 2078, 2078, 2078, 2078, 2078,
    297, 297, 297, 297, 2079, 2079, 2078, 2078,

    2079, 2079, 2079, 2079, 2079, 2079, 2079, 2079,
    2079, 2079, 2079, 2079, 2079, 2079, 2079, 2079,
    297, 297, 2079, 2079, 2079, 2079, 2079, 2079,
    2079, 2079, 2079, 2079, 2079, 2079, 2079, 2079,

    2079, 2079, 2079, 2079, 2079, 2079, 2079, 2079,
    2079, 2079, 2079, 2079, 2079, 2079, 2079, 2079,
    2079, 2079, 2079, 2079, 2079, 2079, 2079, 2079,
    2079, 2079, 2079, 2079, 2079, 2079, 2079, 2079,

    2080, 2081, 2081, 2081, 297, 2081, 2081, 297,
    297, 297, 297, 297, 2081, 2082, 2081, 2083,
    2080, 2080, 2080, 2080, 297, 2080, 2080, 2080,
    297, 2080, 2080, 2080, 2080, 2080, 2080, 2080,

    2080, 2080, 2080, 2080, 2080, 2080, 2080, 2080,
    2080, 2080, 2080, 2080, 2080, 2080, 2080, 2080,
    2080, 2080, 2080, 2080, 297, 297, 297, 297,
    2083, 2084, 2082, 297, 297, 297, 297, 2085,

    2086, 2087, 2088, 2089, 2090, 2090, 2090, 2090,
    297, 297, 297, 297, 297, 297, 297, 297,
    2091, 2091, 2091, 2091, 2091, 2091, 2092, 2092,
    2093, 297, 297, 297, 297, 297, 297, 297,

    2094, 2094, 2094, 2094, 2094, 2094, 2094, 2094,
    2094, 2094, 2094, 2094, 2094, 2094, 2094, 2094,
    2094, 2094, 2094, 2094, 2094, 2094, 2094, 2094,
    2094, 2094, 2094, 2094, 2094, 2095, 2095, 2096,

    2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097,
    2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097,
    2097, 2097, 2097, 2097, 2097, 2097, 2097, 2097,
    2097, 2097, 2097, 2097, 2097, 2098, 2098, 2098,

    2099, 2099, 2099, 2099, 2099, 2100, 2101, 2100,
    2102, 2100, 2100, 2101, 2101, 2103, 2100, 2100,
    2100, 2100, 2100, 2099, 2099, 2099, 2099, 2103,
    2099, 2099, 2099, 2099, 2099, 2100, 2099, 2099,

    2099, 2100, 2101, 2101, 2100, 2104, 2105, 297,
    297, 297, 297, 2106, 2106, 2106, 2106, 2107,
    2108, 2108, 2108, 2108, 2108, 2108, 2109, 297,
    297, 297, 297, 297, 297, 297, 297, 297,

    2110, 2110, 2110, 2110, 2110, 2110, 2110, 2110,
    2110, 2110, 2110, 2110, 2110, 2110, 2110, 2110,
    2110, 2110, 2110, 2110, 2110, 2110, 2110, 2110,
    2110, 2110, 2110, 2110, 2110, 2110, 2110, 2110,

    2110, 2110, 2110, 2110, 2110, 2110, 2110, 2110,
    2110, 2110, 2110, 2110, 2110, 2110, 2110, 2110,
    2110, 2110, 2110, 2110, 2110, 2110, 297, 297,
    297, 2111, 2111, 2111, 2111, 2111, 2111, 2111,

    2112, 2112, 2112, 2112, 2112, 2112, 2112, 2112,
    2112, 2112, 2112, 2112, 2112, 2112, 2112, 2112,
    2112, 2112, 2112, 2112, 2112, 2112, 297, 297,
    2113, 2113, 2113, 2113, 2113, 2113, 2113, 2113,

    2114, 2114, 2114, 2114, 2114, 2114, 2114, 2114,
    2114, 2114, 2114, 2114, 2114, 2114, 2114, 2114,
    2114, 2114, 2114, 297, 297, 297, 297, 297,
    2115, 2115, 2115, 2115, 2115, 2115, 2115, 2115,

    2116, 2117, 2116, 2117, 2117, 2117, 2116, 2116,
    2116, 2117, 2116, 2116, 2117, 2116, 2117, 2117,
    2116, 2117, 297, 297, 297, 297, 297, 297,
    297, 2118, 2118, 2118, 2118, 297, 297, 297,

    297, 297, 297, 297, 297, 297, 297, 297,
    297, 2119, 2119, 2119, 2119, 2120, 2120, 2121,
    297, 297, 297, 297, 297, 297, 297, 297,
    297, 297, 297, 297, 297, 297, 297, 297,

    2122, 2122, 2122, 2122, 2122, 2122, 2122, 2122,
    2122, 2122, 2122, 2122, 2122, 2122, 2122, 2122,
    2122, 2122, 2122, 2122, 2122, 2122, 2122, 2122,
    2122, 2122, 2122, 2122, 2122, 2122, 2122, 2122,

    2122, 2122, 2122, 2122, 2122, 2122, 2122, 2122,
    2122, 297, 297, 297, 297, 297, 297, 297,
    297, 297, 297, 297, 297, 297, 297, 297,
    297, 297, 297, 297, 297, 297, 297, 297,

    2123, 2123, 2123, 2123, 2123, 2123, 2123, 2123,
    2123, 2123, 2123, 2123, 2123, 2123, 2123, 2123,
    2123, 2123, 2123, 2123, 2123, 2123, 2123, 2123,
    2123, 2123, 2123, 2123, 2123, 2123, 2123, 2123,

    2123, 2123, 2123, 2123, 2123, 2123, 2123, 2123,
    2123, 2123, 2123, 2123, 2123, 2123, 2123, 2123,
    2123, 2123, 2123, 297, 297, 297, 297, 297,
    297, 297, 297, 297, 297, 297, 297, 297,

    2124, 2124, 2124, 2124, 2124, 2124, 2124, 2124,
    2124, 2124, 2124, 2124, 2124, 2124, 2124, 2124,
    2124, 2124, 2124, 2124, 2124, 2124, 2124, 2124,
    2124, 2124, 2124, 2124, 2124, 2124, 2124, 2124,

    2124, 2124, 2124, 2124, 2124, 2124, 2124, 2124,
    2124, 2124, 2124, 2124, 2124, 2124, 2124, 2124,
    2124, 2124, 2124, 297, 297, 297, 297, 297,
    297, 297, 2125, 2125, 2125, 2125, 2125, 2125,

    2126, 2127, 2128, 2129, 2130, 2131, 2132, 2133,
    2134, 2135, 2135, 2135, 2135, 2135, 2135, 2135,
    2135, 2135, 2135, 2135, 2135, 2135, 2135, 2135,
    2135, 2135, 2135, 2135, 2135, 2135, 2135, 297,

    2136, 2137, 2136, 2138, 2138, 2138, 2138, 2138,
    2138, 2138, 2138, 2138, 2138, 2138, 2138, 2138,
    2138, 2138, 2138, 2138, 2138, 2138, 2138, 2138,
    2138, 2138, 2138, 2138, 2138, 2138, 2138, 2138,
    2138, 2138, 2138, 2138, 2138, 2138, 2138, 2138,
    2138, 2138, 2138, 2138, 2138, 2138, 2138, 2138,
    2138, 2138, 2138, 2138, 2138, 2138, 2138, 2138,
    2137, 2137, 2137, 2137, 2137, 2137, 2137, 2137,
    2137, 2137, 2137, 2137, 2137, 2137, 2139, 2140,
    2140, 2141, 2141, 2141, 2141, 2141, 200, 200,
    200, 200, 2142, 2143, 2144, 2145, 2146, 2147,
    2148, 2149, 2150, 2151, 2151, 2151, 2151, 2151,
    2151, 2151, 2151, 2151, 2151, 2151, 2152, 2153,
    2154, 2155, 2156, 2157, 2158, 2159, 2160, 2161,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 2162,
    2163, 2163, 2164, 2165, 2165, 2165, 2165, 2165,
    2165, 2165, 2165, 2165, 2165, 2165, 2165, 2165,
    2165, 2165, 2165, 2165, 2165, 2165, 2165, 2165,
    2165, 2165, 2166, 2165, 2166, 2165, 2165, 2165,
    2165, 2165, 2165, 2165, 2165, 2165, 2165, 2165,
    2165, 2165, 2165, 2166, 2165, 2165, 2165, 2165,
    2164, 2164, 2164, 2163, 2163, 2163, 2163, 2164,
    2164, 2167, 2168, 2169, 2169, 2170, 2171, 2171,
    2171, 2171, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    2172, 2172, 2172, 2172, 2172, 2172, 2172, 2172,
    2172, 2172, 2172, 2172, 2172, 2172, 2172, 2172,
    2172, 2172, 2172, 2172, 2172, 2172, 2172, 2172,
    2172, 200, 200, 200, 200, 200, 200, 200,
    2173, 2174, 2175, 2176, 2177, 2178, 2179, 2180,
    2181, 2182, 200, 200, 200, 200, 200, 200,

    2183, 2183, 2183, 2184, 2184, 2184, 2184, 2184,
    2184, 2184, 2184, 2184, 2184, 2184, 2184, 2184,
    2184, 2184, 2184, 2184, 2184, 2184, 2184, 2184,
    2184, 2184, 2184, 2184, 2184, 2184, 2184, 2184,
    2184, 2184, 2184, 2184, 2184, 2184, 2184, 2185,
    2186, 2186, 2186, 2186, 2187, 2186, 2188, 2188,
    2186, 2186, 2186, 2189, 2189, 200, 2190, 2191,
    2192, 2193, 2194, 2195, 2196, 2197, 2198, 2199,
    2200, 2201, 2201, 2201, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    2202, 2202, 2202, 2202, 2202, 2202, 2202, 2202,
    2202, 2202, 2202, 2202, 2202, 2202, 2202, 2202,
    2202, 2202, 2202, 2202, 2202, 2202, 2202, 2202,
    2202, 2202, 2202, 2202, 2202, 2202, 2202, 2202,
    2202, 2202, 2202, 2203, 2204, 2205, 2202, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    2206, 2206, 2207, 2208, 2208, 2208, 2208, 2208,
    2208, 2208, 2208, 2208, 2208, 2208, 2208, 2208,
    2208, 2208, 2208, 2208, 2208, 2208, 2208, 2208,
    2208, 2208, 2208, 2208, 2208, 2208, 2208, 2208,
    2208, 2208, 2208, 2208, 2208, 2208, 2208, 2208,
    2208, 2208, 2208, 2208, 2208, 2208, 2208, 2208,
    2208, 2208, 2208, 2207, 2207, 2207, 2206, 2206,
    2206, 2206, 2206, 2206, 2206, 2206, 2206, 2207,
    2209, 2208, 2208, 2208, 2208, 2210, 2210, 2211,
    2212, 2213, 2214, 2215, 2215, 2216, 200, 200,
    2217, 2218, 2219, 2220, 2221, 2222, 2223, 2224,
    2225, 2226, 2227, 2228, 2229, 2230, 2231, 2231,
    200, 2232, 2232, 2232, 2232, 2232, 2232, 2232,
    2232, 2232, 2232, 2232, 2232, 2232, 2232, 2232,
    2232, 2232, 2232, 2232, 2232, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    2233, 2233, 2233, 2233, 2233, 2233, 2233, 2233,
    2233, 2233, 2233, 2233, 2233, 2233, 2233, 2233,
    2233, 2233, 200, 2233, 2233, 2233, 2233, 2233,
    2233, 2233, 2233, 2233, 2233, 2233, 2233, 2233,
    2233, 2233, 2233, 2233, 2233, 2233, 2233, 2233,
    2233, 2233, 2233, 2233, 2234, 2234, 2234, 2235,
    2235, 2235, 2234, 2234, 2235, 2236, 2237, 2235,
    2238, 2238, 2239, 2238, 2238, 2239, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    2240, 2240, 2240, 2240, 2240, 2240, 2240, 200,
    2240, 200, 2240, 2240, 2240, 2240, 200, 2240,
    2240, 2240, 2240, 2240, 2240, 2240, 2240, 2240,
    2240, 2240, 2240, 2240, 2240, 2240, 200, 2240,
    2240, 2240, 2240, 2240, 2240, 2240, 2240, 2240,
    2240, 2241, 200, 200, 200, 200, 200, 200,
    2242, 2242, 2242, 2242, 2242, 2242, 2242, 2242,
    2242, 2242, 2242, 2242, 2242, 2242, 2242, 2242,
    2242, 2242, 2242, 2242, 2242, 2242, 2242, 2242,
    2242, 2242, 2242, 2242, 2242, 2242, 2242, 2242,
    2242, 2242, 2242, 2242, 2242, 2242, 2242, 2242,
    2242, 2242, 2242, 2242, 2242, 2242, 2242, 2243,
    2244, 2244, 2244, 2243, 2243, 2243, 2243, 2243,
    2243, 2245, 2246, 200, 200, 200, 200, 200,
    2247, 2248, 2249, 2250, 2251, 2252, 2253, 2254,
    2255, 2256, 200, 200, 200, 200, 200, 200,

    2257, 2258, 2259, 2259, 200, 2260, 2260, 2260,
    2260, 2260, 2260, 2260, 2260, 200, 200, 2260,
    2260, 200, 200, 2260, 2260, 2260, 2260, 2260,
    2260, 2260, 2260, 2260, 2260, 2260, 2260, 2260,
    2260, 2260, 2260, 2260, 2260, 2260, 2260, 2260,
    2260, 200, 2260, 2260, 2260, 2260, 2260, 2260,
    2260, 200, 2260, 2260, 200, 2260, 2260, 2260,
    2260, 2260, 200, 200, 2261, 2260, 2262, 2259,
    2258, 2259, 2259, 2259, 2259, 200, 200, 2259,
    2259, 200, 200, 2263, 2263, 2264, 200, 200,
    2265, 200, 200, 200, 200, 200, 200, 2262,
    200, 200, 200, 200, 200, 2260, 2260, 2260,
    2260, 2260, 2259, 2259, 200, 200, 2266, 2266,
    2266, 2266, 2266, 2266, 2266, 200, 200, 200,
    2266, 2266, 2266, 2266, 2266, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267,
    2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267,
    2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267,
    2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267,
    2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267,
    2267, 2267, 2267, 2267, 2267, 2267, 2267, 2267,
    2268, 2269, 2269, 2270, 2270, 2270, 2270, 2270,
    2270, 2269, 2271, 2272, 2272, 2268, 2272, 2270,
    2270, 2269, 2273, 2274, 2267, 2267, 2275, 2267,
    200, 200, 200, 200, 200, 200, 200, 200,
    2276, 2277, 2278, 2279, 2280, 2281, 2282, 2283,
    2284, 2285, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    2286, 2286, 2286, 2286, 2286, 2286, 2286, 2286,
    2286, 2286, 2286, 2286, 2286, 2286, 2286, 2286,
    2286, 2286, 2286, 2286, 2286, 2286, 2286, 2286,
    2286, 2286, 2286, 2286, 2286, 2286, 2286, 2286,
    2286, 2286, 2286, 2286, 2286, 2286, 2286, 2286,
    2286, 2286, 2286, 2286, 2286, 2286, 2286, 2287,
    2288, 2288, 2289, 2289, 2289, 2289, 200, 200,
    2288, 2288, 2290, 2290, 2289, 2289, 2288, 2291,
    2292, 2293, 2294, 2294, 2295, 2295, 2296, 2296,
    2296, 2294, 2297, 2297, 2297, 2297, 2297, 2297,
    2297, 2297, 2297, 2297, 2297, 2297, 2297, 2297,
    2298, 2298, 2298, 2298, 2299, 2299, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    2300, 2300, 2300, 2300, 2300, 2300, 2300, 2300,
    2300, 2300, 2300, 2300, 2300, 2300, 2300, 2300,
    2300, 2300, 2300, 2300, 2300, 2300, 2300, 2300,
    2300, 2300, 2300, 2300, 2300, 2300, 2300, 2300,
    2300, 2300, 2300, 2300, 2300, 2300, 2300, 2300,
    2300, 2300, 2300, 2300, 2300, 2300, 2300, 2300,
    2301, 2301, 2301, 2302, 2302, 2302, 2302, 2302,
    2302, 2302, 2302, 2301, 2301, 2302, 2301, 2303,
    2302, 2304, 2304, 2305, 2300, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    2306, 2307, 2308, 2309, 2310, 2311, 2312, 2313,
    2314, 2315, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    2316, 2316, 2316, 2316, 2316, 2316, 2316, 2316,
    2316, 2316, 2316, 2316, 2316, 2316, 2316, 2316,
    2316, 2316, 2316, 2316, 2316, 2316, 2316, 2316,
    2316, 2316, 2316, 2316, 2316, 2316, 2316, 2316,
    2316, 2316, 2316, 2316, 2316, 2316, 2316, 2316,
    2316, 2316, 2316, 2317, 2318, 2317, 2318, 2318,
    2317, 2317, 2317, 2317, 2317, 2317, 2319, 2320,
    200, 200, 200, 200, 200, 200, 200, 200,
    2321, 2322, 2323, 2324, 2325, 2326, 2327, 2328,
    2329, 2330, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    2331, 2331, 2331, 2331, 2331, 2331, 2331, 2331,
    2331, 2331, 2331, 2331, 2331, 2331, 2331, 2331,
    2331, 2331, 2331, 2331, 2331, 2331, 2331, 2331,
    2331, 2331, 200, 200, 200, 2332, 2332, 2332,
    2333, 2333, 2332, 2332, 2332, 2332, 2333, 2332,
    2332, 2332, 2332, 2334, 200, 200, 200, 200,
    2335, 2336, 2337, 2338, 2339, 2340, 2341, 2342,
    2343, 2344, 2345, 2345, 2346, 2346, 2346, 2347,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    2348, 2348, 2348, 2348, 2348, 2348, 2348, 2348,
    2348, 2348, 2348, 2348, 2348, 2348, 2348, 2348,
    2348, 2348, 2348, 2348, 2348, 2348, 2348, 2348,
    2348, 2348, 2348, 2348, 2348, 2348, 2348, 2348,
    2349, 2349, 2349, 2349, 2349, 2349, 2349, 2349,
    2349, 2349, 2349, 2349, 2349, 2349, 2349, 2349,
    2349, 2349, 2349, 2349, 2349, 2349, 2349, 2349,
    2349, 2349, 2349, 2349, 2349, 2349, 2349, 2349,
    2350, 2351, 2352, 2353, 2354, 2355, 2356, 2357,
    2358, 2359, 2360, 2360, 2360, 2360, 2360, 2360,
    2360, 2360, 2360, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 2361,

    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    2362, 2362, 2362, 2362, 2362, 2362, 2362, 2362,
    2362, 2362, 2362, 2362, 2362, 2362, 2362, 2362,
    2362, 2362, 2362, 2362, 2362, 2362, 2362, 2362,
    2362, 2362, 2362, 2362, 2362, 2362, 2362, 2362,
    2362, 2362, 2362, 2362, 2362, 2362, 2362, 2362,
    2362, 2362, 2362, 2362, 2362, 2362, 2362, 2362,
    2362, 2362, 2362, 2362, 2362, 2362, 2362, 2362,
    2362, 200, 200, 200, 200, 200, 200, 200,

    2363, 2363, 2363, 2363, 2363, 2363, 2363, 2363,
    2363, 2363, 2363, 2363, 2363, 2363, 2363, 2363,
    2363, 2363, 2363, 2363, 2363, 2363, 2363, 2363,
    2363, 2363, 2363, 2363, 2363, 2363, 2363, 2363,
    2363, 2363, 2363, 2363, 2363, 2363, 2363, 2363,
    2363, 2363, 2363, 2363, 2363, 2363, 2363, 2363,
    2363, 2363, 2363, 2363, 2363, 2363, 2363, 2363,
    2363, 2363, 2363, 2363, 2363, 2363, 2363, 2363,
    2363, 2363, 2363, 2363, 2363, 2363, 2363, 2363,
    2363, 2363, 2363, 2363, 2363, 2363, 2363, 2363,
    2363, 2363, 2363, 2363, 2363, 2363, 2363, 2363,
    2363, 2363, 2363, 2363, 2363, 2363, 2363, 2363,
    2363, 2363, 2363, 2363, 2363, 2363, 2363, 2363,
    2363, 2363, 2363, 2363, 2363, 2363, 2363, 2363,
    2363, 2363, 2363, 2363, 2363, 2363, 2363, 2363,
    2363, 2363, 2363, 2363, 2363, 2363, 2363, 2363,
    2363, 2363, 2363, 2363, 2363, 2363, 2363, 2363,
    2363, 2363, 2363, 2363, 2363, 2363, 2363, 2363,
    2363, 2363, 2363, 2363, 2363, 2363, 2363, 2363,
    2363, 2363, 2363, 2363, 2363, 2363, 2363, 2363,
    2363, 2363, 2363, 2363, 2363, 2363, 2363, 2363,
    2363, 2363, 2363, 2363, 2363, 2363, 2363, 2363,
    2363, 2363, 2363, 2363, 2363, 2363, 2363, 2363,
    2363, 2363, 2363, 2363, 2363, 2363, 2363, 2363,
    2363, 2363, 2363, 2363, 2363, 2363, 2363, 2363,
    2363, 2363, 2363, 2363, 2363, 2363, 2363, 2363,
    2363, 2363, 2363, 2363, 2363, 2363, 2363, 2363,
    2363, 2363, 2363, 2363, 2363, 2363, 2363, 2363,
    2363, 2363, 2363, 2363, 2363, 2363, 2363, 2363,
    2363, 2363, 2363, 2363, 2363, 2363, 2363, 2363,
    2363, 2363, 2363, 2363, 2363, 2363, 2363, 2363,
    2363, 2363, 2363, 2363, 2363, 2363, 2363, 2363,

    2363, 2363, 2363, 2363, 2363, 2363, 2363, 2363,
    2363, 2363, 2363, 2363, 2363, 2363, 2363, 2363,
    2363, 2363, 2363, 2363, 2363, 2363, 2363, 2363,
    2363, 2363, 2363, 2363, 2363, 2363, 2363, 2363,
    2363, 2363, 2363, 2363, 2363, 2363, 2363, 2363,
    2363, 2363, 2363, 2363, 2363, 2363, 2363, 2363,
    2363, 2363, 2363, 2363, 2363, 2363, 2363, 2363,
    2363, 2363, 2363, 2363, 2363, 2363, 2363, 2363,
    2363, 2363, 2363, 2363, 2363, 2363, 2363, 2363,
    2363, 2363, 2363, 2363, 2363, 2363, 2363, 2363,
    2363, 2363, 2363, 2363, 2363, 2363, 2363, 2363,
    2363, 2363, 2363, 2363, 2363, 2363, 2363, 2363,
    2363, 2363, 2363, 2363, 2363, 2363, 2363, 2363,
    2363, 2363, 2363, 2363, 2363, 2363, 2363, 2364,
    2364, 2364, 2364, 2364, 2364, 2364, 2364, 2364,
    2364, 2364, 2364, 2364, 2364, 2364, 2364, 2364,
    2364, 2364, 2364, 2364, 2364, 2364, 2364, 2364,
    2364, 2364, 2364, 2364, 2364, 2364, 2364, 2364,
    2364, 2364, 2364, 2364, 2364, 2364, 2364, 2364,
    2364, 2365, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    2366, 2366, 2366, 2366, 2366, 2366, 2366, 2366,
    2366, 2366, 2366, 2366, 2366, 2366, 2366, 2366,
    2366, 2366, 2366, 2366, 2366, 2366, 2366, 2366,
    2366, 2366, 2366, 2366, 2366, 2366, 2366, 2366,
    2366, 2366, 2366, 2366, 2366, 2366, 2366, 2366,
    2366, 2366, 2366, 2366, 2366, 2366, 2366, 2366,
    2366, 2366, 2366, 2366, 2366, 2366, 2366, 2366,
    2366, 2366, 2366, 2366, 2366, 2366, 2366, 2366,
    2366, 2366, 2366, 2366, 2366, 2366, 2366, 2366,
    2366, 2366, 2366, 2366, 2366, 2366, 2366, 2366,
    2366, 2366, 2366, 2366, 2366, 2366, 2366, 2366,
    2366, 2366, 2366, 2366, 2366, 2366, 2366, 2366,
    2366, 2366, 2366, 2367, 2367, 2367, 2367, 2367,
    2367, 2367, 2367, 2367, 2367, 2367, 2367, 200,
    2368, 2368, 2368, 2368, 2369, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    2365, 2365, 2365, 2365, 2365, 2365, 2365, 2365,
    2365, 2365, 2365, 2365, 2365, 2365, 2365, 2365,
    2365, 2365, 2365, 2365, 2365, 2365, 2365, 2365,
    2365, 2365, 2365, 2365, 2365, 2365, 2365, 2365,
    2365, 2365, 2365, 2365, 2365, 2365, 2365, 2365,
    2365, 2365, 2365, 2365, 2365, 2365, 2365, 2365,
    2365, 2365, 2365, 2365, 2365, 2365, 2365, 2365,
    2365, 2365, 2365, 2365, 2365, 2365, 2365, 2365,
    2365, 2365, 2365, 2365, 2365, 2365, 2365, 2365,
    2365, 2365, 2365, 2365, 2365, 2365, 2365, 2365,
    2365, 2365, 2365, 2365, 2365, 2365, 2365, 2365,
    2365, 2365, 2365, 2365, 2365, 2365, 2365, 2365,
    2365, 2365, 2365, 2365, 2365, 2365, 2365, 2365,
    2365, 2365, 2365, 2365, 2365, 2365, 2365, 2365,
    2365, 2365, 2365, 2365, 2365, 2365, 2365, 2365,
    2365, 2365, 2365, 2365, 2365, 2365, 2365, 2365,

    2365, 2365, 2365, 2365, 2365, 2365, 2365, 2365,
    2365, 2365, 2365, 2365, 2365, 2365, 2365, 2365,
    2365, 2365, 2365, 2365, 2365, 2365, 2365, 2365,
    2365, 2365, 2365, 2365, 2365, 2365, 2365, 2365,
    2365, 2365, 2365, 2365, 2365, 2365, 2365, 2365,
    2365, 2365, 2365, 2365, 2365, 2365, 2365, 2365,
    2365, 2365, 2365, 2365, 2365, 2365, 2365, 2365,
    2365, 2365, 2365, 2365, 2365, 2365, 2365, 2365,
    2365, 2365, 2365, 2365, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,

    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2371, 2371, 2371, 2372, 2372, 2372, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2372, 2370, 2370, 2370, 2371, 2372,
    2371, 2372, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,

    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2371, 2372, 2372, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,

    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 2370,
    2370, 2370, 2370, 2370, 2370, 2370, 2370, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,

    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2374, 2375,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,

    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 2373,
    2373, 2373, 2373, 2373, 2373, 2373, 2373, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    2376, 2376, 2376, 2376, 2376, 2376, 2376, 2376,
    2376, 2376, 2376, 2376, 2376, 2376, 2376, 2376,
    2376, 2376, 2376, 2376, 2376, 2376, 2376, 2376,
    2376, 2376, 2376, 2376, 2376, 2376, 2376, 2376,
    2376, 2376, 2376, 2376, 2376, 2376, 2376, 2376,
    2376, 2376, 2376, 2376, 2376, 2376, 2376, 2376,
    2376, 2376, 2376, 2376, 2376, 2376, 2376, 2376,
    2376, 2376, 2376, 2376, 2376, 2376, 2376, 2376,
    2376, 2376, 2376, 2376, 2376, 2376, 2376, 2376,
    2376, 2376, 2376, 2376, 2376, 2376, 2376, 2376,
    2376, 2376, 2376, 2376, 2376, 2376, 2376, 2376,
    2376, 2376, 2376, 2376, 2376, 2376, 2376, 2376,
    2376, 2376, 2376, 2376, 2376, 2376, 2376, 2376,
    2376, 2376, 2376, 2376, 2376, 2376, 2376, 2376,
    2376, 2376, 2376, 2376, 2376, 2376, 2376, 2376,
    2376, 2376, 2376, 2376, 2376, 2376, 2376, 2376,
    2376, 2376, 2376, 2376, 2376, 2376, 2376, 2376,
    2376, 2376, 2376, 2376, 2376, 2376, 2376, 2376,
    2376, 2376, 2376, 2376, 2376, 2376, 2376, 2376,
    2376, 2376, 2376, 2376, 2376, 2376, 2376, 2376,
    2376, 2376, 2376, 2376, 2376, 2376, 2376, 2376,
    2376, 2376, 2376, 2376, 2376, 2376, 2376, 2376,
    2376, 2376, 2376, 2376, 2376, 2376, 2376, 2376,
    2376, 2376, 2376, 2376, 2376, 2376, 2376, 2376,
    2376, 2376, 2376, 2376, 2376, 2376, 2376, 2376,
    2376, 2376, 2376, 2376, 2376, 2376, 2376, 2376,
    2376, 2376, 2376, 2376, 2376, 2376, 2376, 2376,
    2376, 2376, 2376, 2376, 2376, 2376, 2376, 2376,
    2376, 2376, 2376, 2376, 2376, 2376, 2376, 2376,
    2376, 2376, 2376, 2376, 2376, 2376, 2376, 2376,
    2376, 2376, 2376, 2376, 2376, 2376, 2376, 2376,
    2376, 2376, 2376, 2376, 2376, 2376, 2376, 2376,

    2376, 2376, 2376, 2376, 2376, 2376, 2376, 2376,
    2376, 2376, 2376, 2376, 2376, 2376, 2376, 2376,
    2376, 2376, 2376, 2376, 2376, 2376, 2376, 2376,
    2376, 2376, 2376, 2376, 2376, 2376, 2376, 2376,
    2376, 2376, 2376, 2376, 2376, 2376, 2376, 2376,
    2376, 2376, 2376, 2376, 2376, 2376, 2376, 2376,
    2376, 2376, 2376, 2376, 2376, 2376, 2376, 2376,
    2376, 200, 200, 200, 200, 200, 200, 200,
    2377, 2377, 2377, 2377, 2377, 2377, 2377, 2377,
    2377, 2377, 2377, 2377, 2377, 2377, 2377, 2377,
    2377, 2377, 2377, 2377, 2377, 2377, 2377, 2377,
    2377, 2377, 2377, 2377, 2377, 2377, 2377, 200,
    2378, 2379, 2380, 2381, 2382, 2383, 2384, 2385,
    2386, 2387, 200, 200, 200, 200, 2388, 2388,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    2389, 2389, 2389, 2389, 2389, 2389, 2389, 2389,
    2389, 2389, 2389, 2389, 2389, 2389, 2389, 2389,
    2389, 2389, 2389, 2389, 2389, 2389, 2389, 2389,
    2389, 2389, 2389, 2389, 2389, 2389, 200, 200,
    2390, 2390, 2390, 2390, 2390, 2391, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    2392, 2392, 2392, 2392, 2392, 2392, 2392, 2392,
    2392, 2392, 2392, 2392, 2392, 2392, 2392, 2392,
    2392, 2392, 2392, 2392, 2392, 2392, 2392, 2392,
    2392, 2392, 2392, 2392, 2392, 2392, 2392, 2392,
    2392, 2392, 2392, 2392, 2392, 2392, 2392, 2392,
    2392, 2392, 2392, 2392, 2392, 2392, 2392, 2392,
    2393, 2393, 2393, 2393, 2393, 2393, 2393, 2394,
    2394, 2395, 2396, 2396, 2397, 2397, 2397, 2397,
    2398, 2398, 2398, 2398, 2394, 2397, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    2399, 2400, 2401, 2402, 2403, 2404, 2405, 2406,
    2407, 2408, 200, 2409, 2409, 2409, 2409, 2409,
    2409, 2409, 200, 2392, 2392, 2392, 2392, 2392,
    2392, 2392, 2392, 2392, 2392, 2392, 2392, 2392,
    2392, 2392, 2392, 2392, 2392, 2392, 2392, 2392,
    200, 200, 200, 200, 200, 2392, 2392, 2392,
    2392, 2392, 2392, 2392, 2392, 2392, 2392, 2392,
    2392, 2392, 2392, 2392, 2392, 2392, 2392, 2392,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    2410, 2410, 2410, 2410, 2410, 2410, 2410, 2410,
    2410, 2410, 2410, 2410, 2410, 2410, 2410, 2410,
    2410, 2410, 2410, 2410, 2410, 2410, 2410, 2410,
    2410, 2410, 2410, 2410, 2410, 2410, 2410, 2410,
    2410, 2410, 2410, 2410, 2410, 2410, 2410, 2410,
    2410, 2410, 2410, 2410, 2410, 2410, 2410, 2410,
    2410, 2410, 2410, 2410, 2410, 2410, 2410, 2410,
    2410, 2410, 2410, 2410, 2410, 2410, 2410, 2410,
    2410, 2410, 2410, 2410, 2410, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    2410, 2411, 2411, 2411, 2411, 2411, 2411, 2411,
    2411, 2411, 2411, 2411, 2411, 2411, 2411, 2411,
    2411, 2411, 2411, 2411, 2411, 2411, 2411, 2411,
    2411, 2411, 2411, 2411, 2411, 2411, 2411, 2411,
    2411, 2411, 2411, 2411, 2411, 2411, 2411, 2411,
    2411, 2411, 2411, 2411, 2411, 2411, 2411, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 2412,
    2412, 2412, 2412, 2413, 2413, 2413, 2413, 2413,
    2413, 2413, 2413, 2413, 2413, 2413, 2413, 2413,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    2414, 2415, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    2416, 2416, 2416, 2416, 2416, 2416, 2416, 2416,
    2416, 2416, 2416, 2416, 2416, 2416, 2416, 2416,
    2416, 2416, 2416, 2416, 2416, 2416, 2416, 2416,
    2416, 2416, 2416, 2416, 2416, 2416, 2416, 2416,
    2416, 2416, 2416, 2416, 2416, 2416, 2416, 2416,
    2416, 2416, 2416, 2416, 2416, 2416, 2416, 2416,
    2416, 2416, 2416, 2416, 2416, 2416, 2416, 2416,
    2416, 2416, 2416, 2416, 2416, 2416, 2416, 2416,
    2416, 2416, 2416, 2416, 2416, 2416, 2416, 2416,
    2416, 2416, 2416, 2416, 2416, 2416, 2416, 2416,
    2416, 2416, 2416, 2416, 2416, 2416, 2416, 2416,
    2416, 2416, 2416, 2416, 2416, 2416, 2416, 2416,
    2416, 2416, 2416, 2416, 2416, 2416, 2416, 2416,
    2416, 2416, 2416, 200, 200, 200, 200, 200,
    2416, 2416, 2416, 2416, 2416, 2416, 2416, 2416,
    2416, 2416, 2416, 2416, 2416, 200, 200, 200,
    2416, 2416, 2416, 2416, 2416, 2416, 2416, 2416,
    2416, 200, 200, 200, 200, 200, 200, 200,
    2416, 2416, 2416, 2416, 2416, 2416, 2416, 2416,
    2416, 2416, 200, 200, 2417, 2418, 2419, 2420,
    2421, 2421, 2421, 2421, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    2422, 2422, 2422, 2422, 2422, 2422, 2422, 2422,
    2422, 2422, 2422, 2422, 2422, 2422, 2422, 2422,
    2422, 2422, 2422, 2422, 2422, 2422, 2422, 2422,
    2422, 2422, 2422, 2422, 2422, 2422, 2422, 2422,
    2422, 2422, 2422, 2422, 2422, 2422, 2422, 2422,
    2422, 2422, 2422, 2422, 2422, 2422, 2422, 2422,
    2422, 2422, 2422, 2422, 2422, 2422, 2422, 2422,
    2422, 2422, 2422, 2422, 2422, 2422, 2422, 2422,
    2422, 2422, 2422, 2422, 2422, 2422, 2422, 2422,
    2422, 2422, 2422, 2422, 2422, 2422, 2422, 2422,
    2422, 2422, 2422, 2422, 2422, 2422, 2422, 2422,
    2422, 2422, 2422, 2422, 2422, 2422, 2422, 2422,
    2422, 2422, 2422, 2422, 2422, 2422, 2422, 2422,
    2422, 2422, 2422, 2422, 2422, 2422, 2422, 2422,
    2422, 2422, 2422, 2422, 2422, 2422, 2422, 2422,
    2422, 2422, 2422, 2422, 2422, 2422, 2422, 2422,
    2422, 2422, 2422, 2422, 2422, 2422, 2422, 2422,
    2422, 2422, 2422, 2422, 2422, 2422, 2422, 2422,
    2422, 2422, 2422, 2422, 2422, 2422, 2422, 2422,
    2422, 2422, 2422, 2422, 2422, 2422, 2422, 2422,
    2422, 2422, 2422, 2422, 2422, 2422, 2422, 2422,
    2422, 2422, 2422, 2422, 2422, 2422, 2422, 2422,
    2422, 2422, 2422, 2422, 2422, 2422, 2422, 2422,
    2422, 2422, 2422, 2422, 2422, 2422, 2422, 2422,
    2422, 2422, 2422, 2422, 2422, 2422, 2422, 2422,
    2422, 2422, 2422, 2422, 2422, 2422, 2422, 2422,
    2422, 2422, 2422, 2422, 2422, 2422, 2422, 2422,
    2422, 2422, 2422, 2422, 2422, 2422, 2422, 2422,
    2422, 2422, 2422, 2422, 2422, 2422, 2422, 2422,
    2422, 2422, 2422, 2422, 2422, 2422, 2422, 2422,
    2422, 2422, 2422, 2422, 2422, 2422, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    2422, 2422, 2422, 2422, 2422, 2422, 2422, 2422,
    2422, 2422, 2422, 2422, 2422, 2422, 2422, 2422,
    2422, 2422, 2422, 2422, 2422, 2422, 2422, 2422,
    2422, 2422, 2422, 2422, 2422, 2422, 2422, 2422,
    2422, 2422, 2422, 2422, 2422, 2422, 2422, 200,
    200, 1412, 2422, 2422, 2422, 2422, 2422, 2422,
    2422, 2422, 2422, 2422, 2422, 2422, 2422, 2422,
    2422, 2422, 2422, 2422, 2422, 2422, 2422, 2422,
    2422, 2422, 2422, 2422, 2422, 2422, 2422, 2422,
    2422, 2422, 2422, 2422, 2422, 2422, 2422, 2422,
    2422, 2422, 2422, 2422, 2422, 2422, 2422, 2422,
    2422, 2422, 2422, 2422, 2422, 2422, 2423, 2423,
    2423, 2423, 2423, 2423, 2423, 2424, 2425, 2426,
    2426, 2426, 2422, 2422, 2422, 2427, 2424, 2424,
    2424, 2424, 2424, 2428, 2428, 2428, 2428, 2428,
    2428, 2428, 2428, 2429, 2429, 2429, 2429, 2429,
    2429, 2429, 2429, 2422, 2422, 2430, 2430, 2430,
    2430, 2430, 2429, 2429, 2422, 2422, 2422, 2422,
    2422, 2422, 2422, 2422, 2422, 2422, 2422, 2422,
    2422, 2422, 2422, 2422, 2422, 2422, 2422, 2422,
    2422, 2422, 2422, 2422, 2422, 2422, 2422, 2422,
    2422, 2422, 2430, 2430, 2430, 2430, 2422, 2422,
    2422, 2422, 2422, 2422, 2422, 2422, 2422, 2422,
    2422, 2422, 2422, 2423, 2423, 2423, 2423, 2423,
    2423, 2422, 2422, 2422, 2422, 2422, 2422, 2422,
    2422, 2422, 2422, 2422, 2422, 2422, 2422, 2422,
    2422, 2422, 2422, 2422, 2422, 2422, 2422, 2422,
    2422, 2422, 2422, 2422, 2422, 2422, 2431, 2431,
    2431, 2431, 2431, 2431, 2431, 2431, 2431, 2431,
    2431, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    2022, 2022, 2022, 2022, 2022, 2022, 2022, 2022,
    2022, 2022, 2022, 2022, 2022, 2022, 2022, 2022,
    2022, 2022, 2022, 2022, 2022, 2022, 2022, 2022,
    2022, 2022, 2022, 2022, 2022, 2022, 2022, 2022,
    2022, 2022, 2022, 2022, 2022, 2022, 2022, 2022,
    2022, 2022, 2022, 2022, 2022, 2022, 2022, 2022,
    2022, 2022, 2022, 2022, 2022, 2022, 2022, 2022,
    2022, 2022, 2022, 2022, 2022, 2022, 2022, 2022,
    2022, 2022, 2432, 2432, 2432, 2022, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    1446, 1446, 1446, 1446, 1446, 1446, 1446, 1446,
    1446, 1446, 1446, 1446, 1446, 1446, 1446, 1446,
    1446, 1446, 1446, 1446, 1446, 1446, 1446, 1446,
    1446, 1446, 1446, 1446, 1446, 1446, 1446, 1446,
    1446, 1446, 1446, 1446, 1446, 1446, 1446, 1446,
    1446, 1446, 1446, 1446, 1446, 1446, 1446, 1446,
    1446, 1446, 1446, 1446, 1446, 1446, 1446, 1446,
    1446, 1446, 1446, 1446, 1446, 1446, 1446, 1446,
    1446, 1446, 1446, 1446, 1446, 1446, 1446, 1446,
    1446, 1446, 1446, 1446, 1446, 1446, 1446, 1446,
    1446, 1446, 1446, 1446, 1446, 1446, 1446, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    2433, 2433, 2433, 2433, 2433, 2433, 2433, 2433,
    2433, 2433, 2433, 2433, 2433, 2433, 2433, 2433,
    2433, 2433, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    2434, 2434, 2434, 2434, 2434, 2434, 2434, 2434,
    2434, 2434, 2434, 2434, 2434, 2434, 2434, 2434,
    2434, 2434, 2434, 2434, 2434, 2434, 2434, 2434,
    2434, 2434, 2435, 2435, 2435, 2435, 2435, 2435,
    2435, 2435, 2435, 2435, 2435, 2435, 2435, 2435,
    2435, 2435, 2435, 2435, 2435, 2435, 2435, 2435,
    2435, 2435, 2435, 2435, 2434, 2434, 2434, 2434,
    2434, 2434, 2434, 2434, 2434, 2434, 2434, 2434,
    2434, 2434, 2434, 2434, 2434, 2434, 2434, 2434,
    2434, 2434, 2434, 2434, 2434, 2434, 2435, 2435,
    2435, 2435, 2435, 2435, 2435, 200, 2435, 2435,
    2435, 2435, 2435, 2435, 2435, 2435, 2435, 2435,
    2435, 2435, 2435, 2435, 2435, 2435, 2435, 2435,
    2434, 2434, 2434, 2434, 2434, 2434, 2434, 2434,
    2434, 2434, 2434, 2434, 2434, 2434, 2434, 2434,
    2434, 2434, 2434, 2434, 2434, 2434, 2434, 2434,
    2434, 2434, 2435, 2435, 2435, 2435, 2435, 2435,
    2435, 2435, 2435, 2435, 2435, 2435, 2435, 2435,
    2435, 2435, 2435, 2435, 2435, 2435, 2435, 2435,
    2435, 2435, 2435, 2435, 2434, 200, 2434, 2434,
    200, 200, 2434, 200, 200, 2434, 2434, 200,
    200, 2434, 2434, 2434, 2434, 200, 2434, 2434,
    2434, 2434, 2434, 2434, 2434, 2434, 2435, 2435,
    2435, 2435, 200, 2435, 200, 2435, 2435, 2435,
    2435, 2436, 2435, 2435, 200, 2435, 2435, 2435,
    2435, 2435, 2435, 2435, 2435, 2435, 2435, 2435,
    2434, 2434, 2434, 2434, 2434, 2434, 2434, 2434,
    2434, 2434, 2434, 2434, 2434, 2434, 2434, 2434,
    2434, 2434, 2434, 2434, 2434, 2434, 2434, 2434,
    2434, 2434, 2435, 2435, 2435, 2435, 2435, 2435,
    2435, 2435, 2435, 2435, 2435, 2435, 2435, 2435,
    2435, 2435, 2435, 2435, 2435, 2435, 2435, 2435,

    2435, 2435, 2435, 2435, 2434, 2434, 200, 2434,
    2434, 2434, 2434, 200, 200, 2434, 2434, 2434,
    2434, 2434, 2434, 2434, 2434, 200, 2434, 2434,
    2434, 2434, 2434, 2434, 2434, 200, 2435, 2435,
    2435, 2435, 2435, 2435, 2435, 2435, 2435, 2435,
    2435, 2435, 2435, 2435, 2435, 2435, 2435, 2435,
    2435, 2435, 2435, 2435, 2435, 2435, 2435, 2435,
    2434, 2434, 200, 2434, 2434, 2434, 2434, 200,
    2434, 2434, 2434, 2434, 2434, 200, 2434, 200,
    200, 200, 2434, 2434, 2434, 2434, 2434, 2434,
    2434, 200, 2435, 2435, 2435, 2435, 2435, 2435,
    2435, 2435, 2435, 2435, 2435, 2435, 2435, 2435,
    2435, 2435, 2435, 2435, 2435, 2435, 2435, 2435,
    2435, 2435, 2435, 2435, 2434, 2434, 2434, 2434,
    2434, 2434, 2434, 2434, 2434, 2434, 2434, 2434,
    2434, 2434, 2434, 2434, 2434, 2434, 2434, 2434,
    2434, 2434, 2434, 2434, 2434, 2434, 2435, 2435,
    2435, 2435, 2435, 2435, 2435, 2435, 2435, 2435,
    2435, 2435, 2435, 2435, 2435, 2435, 2435, 2435,
    2435, 2435, 2435, 2435, 2435, 2435, 2435, 2435,
    2434, 2434, 2434, 2434, 2434, 2434, 2434, 2434,
    2434, 2434, 2434, 2434, 2434, 2434, 2434, 2434,
    2434, 2434, 2434, 2434, 2434, 2434, 2434, 2434,
    2434, 2434, 2435, 2435, 2435, 2435, 2435, 2435,
    2435, 2435, 2435, 2435, 2435, 2435, 2435, 2435,
    2435, 2435, 2435, 2435, 2435, 2435, 2435, 2435,
    2435, 2435, 2435, 2435, 2434, 2434, 2434, 2434,
    2434, 2434, 2434, 2434, 2434, 2434, 2434, 2434,
    2434, 2434, 2434, 2434, 2434, 2434, 2434, 2434,
    2434, 2434, 2434, 2434, 2434, 2434, 2435, 2435,
    2435, 2435, 2435, 2435, 2435, 2435, 2435, 2435,
    2435, 2435, 2435, 2435, 2435, 2435, 2435, 2435,

    2435, 2435, 2435, 2435, 2435, 2435, 2435, 2435,
    2434, 2434, 2434, 2434, 2434, 2434, 2434, 2434,
    2434, 2434, 2434, 2434, 2434, 2434, 2434, 2434,
    2434, 2434, 2434, 2434, 2434, 2434, 2434, 2434,
    2434, 2434, 2435, 2435, 2435, 2435, 2435, 2435,
    2435, 2435, 2435, 2435, 2435, 2435, 2435, 2435,
    2435, 2435, 2435, 2435, 2435, 2435, 2435, 2435,
    2435, 2435, 2435, 2435, 2434, 2434, 2434, 2434,
    2434, 2434, 2434, 2434, 2434, 2434, 2434, 2434,
    2434, 2434, 2434, 2434, 2434, 2434, 2434, 2434,
    2434, 2434, 2434, 2434, 2434, 2434, 2435, 2435,
    2435, 2435, 2435, 2435, 2435, 2435, 2435, 2435,
    2435, 2435, 2435, 2435, 2435, 2435, 2435, 2435,
    2435, 2435, 2435, 2435, 2435, 2435, 2435, 2435,
    2434, 2434, 2434, 2434, 2434, 2434, 2434, 2434,
    2434, 2434, 2434, 2434, 2434, 2434, 2434, 2434,
    2434, 2434, 2434, 2434, 2434, 2434, 2434, 2434,
    2434, 2434, 2435, 2435, 2435, 2435, 2435, 2435,
    2435, 2435, 2435, 2435, 2435, 2435, 2435, 2435,
    2435, 2435, 2435, 2435, 2435, 2435, 2435, 2435,
    2435, 2435, 2435, 2435, 1404, 1404, 200, 200,
    2434, 2434, 2434, 2434, 2434, 2434, 2434, 2434,
    2434, 2434, 2434, 2434, 2434, 2434, 2434, 2434,
    2434, 2434, 2434, 2434, 2434, 2434, 2434, 2434,
    2434, 2437, 2435, 2435, 2435, 2435, 2435, 2435,
    2435, 2435, 2435, 2435, 2435, 2435, 2435, 2435,
    2435, 2435, 2435, 2435, 2435, 2435, 2435, 2435,
    2435, 2435, 2435, 2438, 2435, 2435, 2435, 2435,
    2435, 2435, 2434, 2434, 2434, 2434, 2434, 2434,
    2434, 2434, 2434, 2434, 2434, 2434, 2434, 2434,
    2434, 2434, 2434, 2434, 2434, 2434, 2434, 2434,
    2434, 2434, 2434, 2437, 2435, 2435, 2435, 2435,

    2435, 2435, 2435, 2435, 2435, 2435, 2435, 2435,
    2435, 2435, 2435, 2435, 2435, 2435, 2435, 2435,
    2435, 2435, 2435, 2435, 2435, 2438, 2435, 2435,
    2435, 2435, 2435, 2435, 2434, 2434, 2434, 2434,
    2434, 2434, 2434, 2434, 2434, 2434, 2434, 2434,
    2434, 2434, 2434, 2434, 2434, 2434, 2434, 2434,
    2434, 2434, 2434, 2434, 2434, 2437, 2435, 2435,
    2435, 2435, 2435, 2435, 2435, 2435, 2435, 2435,
    2435, 2435, 2435, 2435, 2435, 2435, 2435, 2435,
    2435, 2435, 2435, 2435, 2435, 2435, 2435, 2438,
    2435, 2435, 2435, 2435, 2435, 2435, 2434, 2434,
    2434, 2434, 2434, 2434, 2434, 2434, 2434, 2434,
    2434, 2434, 2434, 2434, 2434, 2434, 2434, 2434,
    2434, 2434, 2434, 2434, 2434, 2434, 2434, 2437,
    2435, 2435, 2435, 2435, 2435, 2435, 2435, 2435,
    2435, 2435, 2435, 2435, 2435, 2435, 2435, 2435,
    2435, 2435, 2435, 2435, 2435, 2435, 2435, 2435,
    2435, 2438, 2435, 2435, 2435, 2435, 2435, 2435,
    2434, 2434, 2434, 2434, 2434, 2434, 2434, 2434,
    2434, 2434, 2434, 2434, 2434, 2434, 2434, 2434,
    2434, 2434, 2434, 2434, 2434, 2434, 2434, 2434,
    2434, 2437, 2435, 2435, 2435, 2435, 2435, 2435,
    2435, 2435, 2435, 2435, 2435, 2435, 2435, 2435,
    2435, 2435, 2435, 2435, 2435, 2435, 2435, 2435,
    2435, 2435, 2435, 2438, 2435, 2435, 2435, 2435,
    2435, 2435, 2439, 2440, 200, 200, 2441, 2442,
    2443, 2444, 2445, 2446, 2447, 2448, 2449, 2450,
    2441, 2442, 2443, 2444, 2445, 2446, 2447, 2448,
    2449, 2450, 2441, 2442, 2443, 2444, 2445, 2446,
    2447, 2448, 2449, 2450, 2441, 2442, 2443, 2444,
    2445, 2446, 2447, 2448, 2449, 2450, 2441, 2442,
    2443, 2444, 2445, 2446, 2447, 2448, 2449, 2450,

    2451, 2451, 2451, 2451, 2451, 2451, 2451, 2451,
    2451, 2451, 2451, 2451, 2451, 2451, 2451, 2451,
    2451, 2451, 2451, 2451, 2451, 2451, 2451, 2451,
    2451, 2451, 2451, 2451, 2451, 2451, 2451, 2451,
    2451, 2451, 2451, 2451, 2451, 2451, 2451, 2451,
    2451, 2451, 2451, 2451, 2451, 2451, 2451, 2451,
    2451, 2451, 2451, 2451, 2451, 2451, 2451, 2451,
    2451, 2451, 2451, 2451, 2451, 2451, 2451, 2451,
    2451, 2451, 2451, 2451, 2451, 2451, 2451, 2451,
    2451, 2451, 2451, 2451, 2451, 2451, 2451, 2451,
    2451, 2451, 2451, 2451, 2451, 2451, 2451, 2451,
    2451, 2451, 2451, 2451, 2451, 2451, 2451, 2451,
    2451, 2451, 2451, 2451, 2451, 2451, 2451, 2451,
    2451, 2451, 2451, 2451, 2451, 2451, 2451, 2451,
    2451, 2451, 2451, 2451, 2451, 2451, 2451, 2451,
    2451, 2451, 2451, 2451, 2451, 2451, 2451, 2451,
    2451, 2451, 2451, 2451, 2451, 2451, 2451, 2451,
    2451, 2451, 2451, 2451, 2451, 2451, 2451, 2451,
    2451, 2451, 2451, 2451, 2451, 2451, 2451, 2451,
    2451, 2451, 2451, 2451, 2451, 2451, 2451, 2451,
    2451, 2451, 2451, 2451, 2451, 2451, 2451, 2451,
    2451, 2451, 2451, 2451, 2451, 2451, 2451, 2451,
    2451, 2451, 2451, 2451, 2451, 2451, 2451, 2451,
    2451, 2451, 2451, 2451, 2451, 2451, 2451, 2451,
    2451, 2451, 2451, 2451, 2451, 2451, 2451, 2451,
    2451, 2451, 2451, 2451, 2451, 2451, 2451, 2451,
    2451, 2451, 2451, 2451, 2451, 2451, 2451, 2451,
    2451, 2451, 2451, 2451, 2451, 2451, 2451, 2451,
    2451, 2451, 2451, 2451, 2451, 2451, 2451, 2451,
    2451, 2451, 2451, 2451, 2451, 2451, 2451, 2451,
    2451, 2451, 2451, 2451, 2451, 2451, 2451, 2451,
    2451, 2451, 2451, 2451, 2451, 2451, 2451, 2451,

    2452, 2452, 2452, 2452, 2452, 2452, 2452, 2452,
    2452, 2452, 2452, 2452, 2452, 2452, 2452, 2452,
    2452, 2452, 2452, 2452, 2452, 2452, 2452, 2452,
    2452, 2452, 2452, 2452, 2452, 2452, 2452, 2452,
    2452, 2452, 2452, 2452, 2452, 2452, 2452, 2452,
    2452, 2452, 2452, 2452, 2452, 2452, 2452, 2452,
    2452, 2452, 2452, 2452, 2452, 2452, 2452, 2451,
    2451, 2451, 2451, 2452, 2452, 2452, 2452, 2452,
    2452, 2452, 2452, 2452, 2452, 2452, 2452, 2452,
    2452, 2452, 2452, 2452, 2452, 2452, 2452, 2452,
    2452, 2452, 2452, 2452, 2452, 2452, 2452, 2452,
    2452, 2452, 2452, 2452, 2452, 2452, 2452, 2452,
    2452, 2452, 2452, 2452, 2452, 2452, 2452, 2452,
    2452, 2452, 2452, 2452, 2452, 2451, 2451, 2451,
    2451, 2451, 2451, 2451, 2451, 2452, 2451, 2451,
    2451, 2451, 2451, 2451, 2451, 2451, 2451, 2451,
    2451, 2451, 2451, 2451, 2452, 2451, 2451, 2453,
    2454, 2453, 2453, 2455, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 2452, 2452, 2452, 2452, 2452,
    200, 2452, 2452, 2452, 2452, 2452, 2452, 2452,
    2452, 2452, 2452, 2452, 2452, 2452, 2452, 2452,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    2456, 2456, 2456, 2456, 2456, 2456, 2456, 2456,
    2456, 2456, 2456, 2456, 2456, 2456, 2456, 2456,
    2456, 2456, 2456, 2456, 2456, 2456, 2456, 2456,
    2456, 2456, 2456, 2456, 2456, 2456, 2456, 2456,
    2456, 2456, 2456, 2456, 2456, 2456, 2456, 2456,
    2456, 2456, 2456, 2456, 2456, 2456, 2456, 2456,
    2456, 2456, 2456, 2456, 2456, 2456, 2456, 2456,
    2456, 2456, 2456, 2456, 2456, 2456, 2456, 2456,
    2456, 2456, 2456, 2456, 2456, 2456, 2456, 2456,
    2456, 2456, 2456, 2456, 2456, 2456, 2456, 2456,
    2456, 2456, 2456, 2456, 2456, 2456, 2456, 2456,
    2456, 2456, 2456, 2456, 2456, 2456, 2456, 2456,
    2456, 2456, 2456, 2456, 2456, 2456, 2456, 2456,
    2456, 2456, 2456, 2456, 2456, 2456, 2456, 2456,
    2456, 2456, 2456, 2456, 2456, 2456, 2456, 2456,
    2456, 2456, 2456, 2456, 2456, 2456, 2456, 2456,
    2456, 2456, 2456, 2456, 2456, 2456, 2456, 2456,
    2456, 2456, 2456, 2456, 2456, 2456, 2456, 2456,
    2456, 2456, 2456, 2456, 2456, 2456, 2456, 2456,
    2456, 2456, 2456, 2456, 2456, 2456, 2456, 2456,
    2456, 2456, 2456, 2456, 2456, 2456, 2456, 2456,
    2456, 2456, 2456, 2456, 2456, 2456, 2456, 2456,
    2456, 2456, 2456, 2456, 2456, 2456, 2456, 2456,
    2456, 2456, 2456, 2456, 2456, 2456, 2456, 2456,
    2456, 2456, 2456, 2456, 2456, 297, 297, 2457,
    2457, 2457, 2457, 2457, 2457, 2457, 2457, 2457,
    2458, 2458, 2458, 2458, 2458, 2458, 2458, 297,
    297, 297, 297, 297, 297, 297, 297, 297,
    297, 297, 297, 297, 297, 297, 297, 297,
    297, 297, 297, 297, 297, 297, 297, 297,
    297, 297, 297, 297, 297, 297, 297, 297,
    297, 297, 297, 297, 297, 297, 297, 297,

    297, 297, 297, 297, 297, 297, 297, 297,
    297, 297, 297, 297, 297, 297, 297, 297,
    297, 297, 297, 297, 297, 297, 297, 297,
    297, 297, 297, 297, 297, 297, 297, 297,
    297, 297, 297, 297, 297, 297, 297, 297,
    297, 297, 297, 297, 297, 297, 297, 297,
    297, 297, 297, 297, 297, 297, 297, 297,
    297, 297, 297, 297, 297, 297, 297, 297,
    297, 297, 297, 297, 297, 297, 297, 297,
    297, 297, 297, 297, 297, 297, 297, 297,
    297, 297, 297, 297, 297, 297, 297, 297,
    297, 297, 297, 297, 297, 297, 297, 297,
    297, 297, 297, 297, 297, 297, 297, 297,
    297, 297, 297, 297, 297, 297, 297, 297,
    297, 297, 297, 297, 297, 297, 297, 297,
    297, 297, 297, 297, 297, 297, 297, 297,
    297, 297, 297, 297, 297, 297, 297, 297,
    297, 297, 297, 297, 297, 297, 297, 297,
    297, 297, 297, 297, 297, 297, 297, 297,
    297, 297, 297, 297, 297, 297, 297, 297,
    297, 297, 297, 297, 297, 297, 297, 297,
    297, 297, 297, 297, 297, 297, 297, 297,
    297, 297, 297, 297, 297, 297, 297, 297,
    297, 297, 297, 297, 297, 297, 297, 297,
    297, 297, 297, 297, 297, 297, 297, 297,
    297, 297, 297, 297, 297, 297, 297, 297,
    297, 297, 297, 297, 297, 297, 297, 297,
    297, 297, 297, 297, 297, 297, 297, 297,
    297, 297, 297, 297, 297, 297, 297, 297,
    297, 297, 297, 297, 297, 297, 297, 297,
    297, 297, 297, 297, 297, 297, 297, 297,
    297, 297, 297, 297, 297, 297, 297, 297,

    2459, 2459, 2459, 2459, 343, 2459, 2459, 2459,
    2459, 2459, 2459, 2459, 2459, 2459, 2459, 2459,
    2459, 2459, 2459, 2459, 2459, 2459, 2459, 2459,
    2459, 2459, 2459, 2459, 2459, 2459, 2459, 2459,
    343, 2459, 2459, 343, 2459, 343, 343, 2459,
    343, 2459, 2459, 2459, 2459, 2459, 2459, 2459,
    2459, 2459, 2459, 343, 2459, 2459, 2459, 2459,
    343, 2459, 343, 2459, 343, 343, 343, 343,
    343, 343, 2459, 343, 343, 343, 343, 2459,
    343, 2459, 343, 2459, 343, 2459, 2459, 2459,
    343, 2459, 2459, 343, 2459, 343, 343, 2459,
    343, 2459, 343, 2459, 343, 2459, 343, 2459,
    343, 2459, 2459, 343, 2459, 343, 343, 2459,
    2459, 2459, 2459, 343, 2459, 2459, 2459, 2459,
    2459, 2459, 2459, 343, 2459, 2459, 2459, 2459,
    343, 2459, 2459, 2459, 2459, 343, 2459, 343,
    2459, 2459, 2459, 2459, 2459, 2459, 2459, 2459,
    2459, 2459, 343, 2459, 2459, 2459, 2459, 2459,
    2459, 2459, 2459, 2459, 2459, 2459, 2459, 2459,
    2459, 2459, 2459, 2459, 343, 343, 343, 343,
    343, 2459, 2459, 2459, 343, 2459, 2459, 2459,
    2459, 2459, 343, 2459, 2459, 2459, 2459, 2459,
    2459, 2459, 2459, 2459, 2459, 2459, 2459, 2459,
    2459, 2459, 2459, 2459, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343,
    2460, 2460, 343, 343, 343, 343, 343, 343,
    343, 343, 343, 343, 343, 343, 343, 343,

    1482, 1482, 1482, 1482, 1482, 1482, 1482, 1482,
    1482, 1482, 1482, 1482, 1482, 1482, 1482, 1482,
    1482, 1482, 1482, 1482, 1482, 1482, 1482, 1482,
    1482, 1482, 1482, 1482, 1482, 1482, 1482, 1482,
    1482, 1482, 1482, 1482, 1482, 1482, 1482, 1482,
    1482, 1482, 1482, 1482, 200, 200, 200, 200,
    1482, 1482, 1482, 1482, 1482, 1482, 1482, 1482,
    1482, 1482, 1482, 1482, 1482, 1482, 1482, 1482,
    1482, 1482, 1482, 1482, 1482, 1482, 1482, 1482,
    1482, 1482, 1482, 1482, 1482, 1482, 1482, 1482,
    1482, 1482, 1482, 1482, 1482, 1482, 1482, 1482,
    1482, 1482, 1482, 1482, 1482, 1482, 1482, 1482,
    1482, 1482, 1482, 1482, 1482, 1482, 1482, 1482,
    1482, 1482, 1482, 1482, 1482, 1482, 1482, 1482,
    1482, 1482, 1482, 1482, 1482, 1482, 1482, 1482,
    1482, 1482, 1482, 1482, 1482, 1482, 1482, 1482,
    1482, 1482, 1482, 1482, 1482, 1482, 1482, 1482,
    1482, 1482, 1482, 1482, 1482, 1482, 1482, 1482,
    1482, 1482, 1482, 1482, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 200,
    200, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1483,
    200, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    200, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483,
    1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483,
    1483, 1483, 1483, 1483, 1483, 1483, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    2461, 2461, 2462, 2463, 2464, 2465, 2466, 2467,
    2468, 2469, 2470, 2471, 2471, 200, 200, 200,
    2472, 2472, 2472, 2472, 2472, 2472, 2472, 2472,
    2472, 2472, 2472, 2472, 2472, 2472, 2472, 2472,
    2472, 2472, 2472, 2472, 2472, 2472, 2472, 2472,
    2472, 2472, 2472, 2472, 2472, 2472, 2472, 200,
    2473, 2474, 2473, 2473, 2473, 2473, 2473, 2473,
    2473, 2473, 2473, 2473, 2473, 2474, 2473, 2474,
    2473, 2473, 2474, 2473, 2473, 2473, 2474, 2473,
    2473, 2473, 2472, 2472, 2472, 2472, 2472, 2475,
    2476, 2476, 2476, 2476, 2476, 2476, 2476, 2477,
    2476, 2476, 2476, 2476, 2476, 2476, 2476, 2477,
    2476, 2476, 2476, 2476, 2476, 2476, 2476, 2476,
    2476, 2476, 2478, 2478, 200, 200, 200, 200,
    2476, 2476, 2476, 2476, 2476, 2476, 2476, 2476,
    2476, 2477, 2476, 2477, 2477, 2476, 2476, 2477,
    2476, 2476, 2476, 2476, 2476, 2476, 2476, 2476,
    2476, 2476, 778, 778, 778, 778, 2479, 2479,
    2472, 2479, 2479, 2479, 2479, 2479, 2479, 2479,
    2479, 2479, 2479, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 2480, 2480,
    2480, 2480, 2480, 2480, 2480, 2480, 2480, 2480,
    2480, 2480, 2480, 2480, 2480, 2480, 2480, 2480,
    2480, 2480, 2480, 2480, 2480, 2480, 2480, 2480,

    2481, 2482, 2482, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    1632, 1632, 1632, 1632, 1632, 1632, 1632, 1632,
    1632, 1632, 1632, 1632, 1632, 1632, 1632, 1632,
    1632, 1632, 1632, 1632, 1632, 1632, 1632, 1632,
    1632, 1632, 1632, 1632, 1632, 1632, 1632, 1632,
    1632, 1632, 2482, 2482, 2482, 2482, 2482, 2482,
    2482, 2482, 2482, 200, 200, 200, 200, 200,
    1632, 1632, 1632, 1632, 1632, 1632, 1632, 1632,
    1632, 200, 200, 200, 200, 200, 200, 200,
    2482, 2482, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1483, 1483, 1483, 1483, 1483, 1483, 1483,
    1483, 1483, 1483, 1483, 1483, 2483, 2483, 2483,
    1450, 1450, 1450, 1450, 1450, 1450, 1483, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1483, 2483, 2483,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1483, 1483, 1483, 1483,
    1483, 1483, 1483, 1483, 1451, 1451, 1483, 1483,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1449, 1449, 1450,
    1450, 1450, 1450, 1450, 1449, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1483, 1450, 1450,
    1450, 1450, 1450, 1483, 1483, 1483, 1483, 2483,
    2483, 2483, 2483, 2483, 1483, 1483, 1483, 1483,
    1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1483, 1483, 1483, 1483, 1483, 1483, 1483,
    2483, 2483, 2483, 2484, 2484, 2484, 2484, 2484,

    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1483,
    1450, 1483, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1449, 1450, 1449, 1450, 1449, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1449,
    1450, 1449, 1449, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1483, 1450, 1450, 1450, 1450, 1483, 1483, 2483,

    1449, 1449, 1449, 1449, 1449, 1449, 1449, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1449,
    1449, 1449, 1449, 1449, 1449, 1449, 1449, 1449,
    1449, 1449, 1449, 1449, 1449, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1449, 1449, 1449, 1449, 1449, 1449,
    1449, 1449, 1449, 1449, 1449, 1449, 1451, 1451,
    2485, 2485, 2485, 2485, 1451, 1451, 1451, 1451,
    1451, 1451, 1483, 2483, 2483, 2483, 2483, 2483,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483,
    1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483,
    1483, 1483, 200, 1483, 1483, 1483, 1483, 1483,
    1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483,
    1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483,
    1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483,
    1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483,
    1483, 1483, 1483, 1483, 200, 1483, 1483, 1483,
    1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483,
    1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483,
    1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483,
    1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483,
    1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483,
    1483, 1483, 1483, 1483, 1451, 1451, 1451, 1451,
    1451, 1451, 1451, 1451, 1483, 1483, 1483, 1483,
    1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483,
    1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483,
    1483, 1483, 1483, 1483, 1451, 1451, 1451, 1451,
    1451, 1451, 1483, 1450, 1450, 1450, 1450, 1450,

    2486, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 2486, 1450, 1450, 1450, 2486, 1450, 2486,
    1450, 2486, 1450, 2486, 1450, 1450, 1450, 2486,
    1450, 1450, 1450, 1450, 1450, 1450, 2486, 2486,
    1450, 1450, 1450, 1450, 2486, 1450, 2486, 2486,
    1450, 1450, 1450, 1450, 2486, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1483, 1483, 2483, 2483, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1451, 1451, 1451, 1451, 1451, 1451, 1451, 1451,
    1451, 1451, 1451, 1451, 1451, 1451, 1451, 1451,
    1451, 1451, 1451, 1451, 1451, 1451, 1451, 1451,
    1451, 1451, 1451, 1451, 1451, 1451, 1451, 1451,
    1451, 1451, 1451, 1451, 1451, 1451, 2487, 2487,
    2487, 2488, 2488, 2488, 1451, 1451, 1451, 1451,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1450, 1450,
    1450, 1450, 1450, 1450, 1450, 1450, 1483, 1483,
    1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483,
    2483, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483,
    1483, 1483, 1483, 1483, 1483, 200, 200, 200,
    1483, 1483, 1483, 1483, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    1449, 1449, 1449, 1449, 1449, 1449, 1449, 1449,
    1449, 1449, 1449, 1449, 1449, 1449, 1449, 1449,
    1449, 1449, 1449, 1449, 1449, 1449, 1449, 1449,
    1449, 1449, 1449, 1449, 1449, 1449, 1449, 1449,
    1449, 1449, 1449, 1449, 1449, 1449, 1449, 1449,
    1449, 1449, 1449, 1449, 1449, 1449, 1449, 1449,
    1449, 1449, 1449, 1449, 1449, 1449, 1449, 1449,
    1449, 1449, 1449, 1449, 1449, 1449, 1449, 1449,
    1449, 1449, 1449, 1449, 1449, 1449, 1449, 1449,
    1449, 1449, 1449, 1449, 1449, 1449, 1449, 1449,
    1449, 1449, 1449, 1449, 1449, 1449, 1449, 1449,
    1449, 1449, 1449, 1449, 1449, 1449, 1449, 1449,
    1449, 1449, 1449, 1449, 1449, 1449, 1449, 1449,
    1449, 1449, 1449, 1449, 1449, 1449, 1449, 1449,
    1449, 1449, 1449, 1449, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    1451, 1451, 1451, 1451, 1451, 1451, 1451, 1451,
    1451, 1451, 1451, 1451, 1451, 1451, 1451, 1451,
    1451, 1451, 1451, 1451, 1451, 1451, 1451, 1451,
    1451, 1451, 1451, 1451, 1451, 1451, 1451, 1451,
    1451, 1451, 1451, 1451, 1451, 1451, 1451, 1451,
    1451, 1451, 1451, 1451, 1451, 1451, 1451, 1451,
    1451, 1451, 1451, 1451, 1451, 1451, 1451, 1451,
    1451, 1451, 1451, 1451, 1451, 1451, 1451, 1451,
    1451, 1451, 1451, 1451, 1451, 1451, 1451, 1451,
    1451, 1451, 1451, 1451, 1451, 1451, 1451, 1451,
    1451, 1451, 1451, 1451, 1451, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    1451, 1451, 1451, 1451, 1451, 1451, 1451, 1451,
    1451, 1451, 1451, 1451, 200, 200, 200, 200,
    1451, 1451, 1451, 1451, 1451, 1451, 1451, 1451,
    1451, 1451, 1451, 1451, 1451, 1451, 1451, 1451,
    1451, 1451, 1451, 1451, 1451, 1451, 1451, 1451,
    1451, 1451, 1451, 1451, 1451, 1451, 1451, 1451,
    1451, 1451, 1451, 1451, 1451, 1451, 1451, 1451,
    1451, 1451, 1451, 1451, 1451, 1451, 1451, 1451,
    1451, 1451, 1451, 1451, 1451, 1451, 1451, 1451,
    200, 200, 200, 200, 200, 200, 200, 200,
    1451, 1451, 1451, 1451, 1451, 1451, 1451, 1451,
    1451, 1451, 200, 200, 200, 200, 200, 200,
    1451, 1451, 1451, 1451, 1451, 1451, 1451, 1451,
    1451, 1451, 1451, 1451, 1451, 1451, 1451, 1451,
    1451, 1451, 1451, 1451, 1451, 1451, 1451, 1451,
    1451, 1451, 1451, 1451, 1451, 1451, 1451, 1451,
    1451, 1451, 1451, 1451, 1451, 1451, 1451, 1451,
    200, 200, 200, 200, 200, 200, 200, 200,
    1451, 1451, 1451, 1451, 1451, 1451, 1451, 1451,
    1451, 1451, 1451, 1451, 1451, 1451, 1451, 1451,
    1451, 1451, 1451, 1451, 1451, 1451, 1451, 1451,
    1451, 1451, 1451, 1451, 1451, 1451, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    2483, 2483, 2483, 2483, 2483, 2483, 2483, 2483,
    2483, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    2483, 2483, 2483, 2483, 2483, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    2483, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,

    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 200, 200,
    200, 200, 200, 200, 200, 200, 2489, 2489,

    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,

    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 2490,
    2490, 2490, 2490, 2490, 2490, 2490, 2490, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,

    1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
    1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
    1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
    1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
    1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
    1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
    1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
    1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
    1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
    1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
    1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
    1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
    1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
    1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
    1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
    1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
    1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
    1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
    1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
    1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
    1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
    1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
    1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
    1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
    1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
    1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
    1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
    1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
    1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
    1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
    1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
    1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,

    1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
    1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
    1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
    1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
    1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
    1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
    1643, 1643, 1643, 1643, 1643, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    2491, 2491, 2491, 2491, 2491, 2491, 2491, 2491,
    2491, 2491, 2491, 2491, 2491, 2491, 2491, 2491,
    2491, 2491, 2491, 2491, 2491, 2491, 2491, 2491,
    2491, 2491, 2491, 2491, 2491, 2491, 2491, 2491,
    2491, 2491, 2491, 2491, 2491, 2491, 2491, 2491,
    2491, 2491, 2491, 2491, 2491, 2491, 2491, 2491,
    2491, 2491, 2491, 2491, 2491, 2491, 2491, 2491,
    2491, 2491, 2491, 2491, 2491, 2491, 2491, 2491,
    2491, 2491, 2491, 2491, 2491, 2491, 2491, 2491,
    2491, 2491, 2491, 2491, 2491, 2491, 2491, 2491,
    2491, 2491, 2491, 2491, 2491, 2491, 2491, 2491,
    2491, 2491, 2491, 2491, 2491, 2491, 2491, 2491,
    2491, 2491, 2491, 2491, 2491, 2491, 2491, 2491,
    2491, 2491, 2491, 2491, 2491, 2491, 2491, 2491,
    2491, 2491, 2491, 2491, 2491, 2491, 2491, 2491,
    2491, 2491, 2491, 2491, 2491, 2491, 2491, 2491,
    2491, 2491, 2491, 2491, 2491, 2491, 2491, 2491,
    2491, 2491, 2491, 2491, 2491, 2491, 2491, 2491,
    2491, 2491, 2491, 2491, 2491, 2491, 2491, 2491,
    2491, 2491, 2491, 2491, 2491, 2491, 2491, 2491,
    2491, 2491, 2491, 2491, 2491, 2491, 2491, 2491,
    2491, 2491, 2491, 2491, 2491, 2491, 2491, 2491,
    2491, 2491, 2491, 2491, 2491, 2491, 2491, 2491,
    2491, 2491, 2491, 2491, 2491, 2491, 2491, 2491,

    2491, 2491, 2491, 2491, 2491, 2491, 2491, 2491,
    2491, 2491, 2491, 2491, 2491, 2491, 2491, 2491,
    2491, 2491, 2491, 2491, 2491, 2491, 2491, 2491,
    2491, 2491, 2491, 2491, 2491, 2491, 1639, 1639,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,

    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,

    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
    1645, 1645, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,

    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,

    2492, 2492, 2492, 2492, 2492, 2492, 2492, 2492,
    2492, 2492, 2492, 2492, 2492, 2492, 2492, 2492,
    2492, 2492, 2492, 2492, 2492, 2492, 2492, 2492,
    2492, 2492, 2492, 2492, 2492, 2492, 2492, 2492,
    2492, 2492, 2492, 2492, 2492, 2492, 2492, 2492,
    2492, 2492, 2492, 2492, 2492, 2492, 2492, 2492,
    2492, 2492, 2492, 2492, 2492, 2492, 2492, 2492,
    2492, 2492, 2492, 2492, 2492, 2492, 2492, 2492,
    2492, 2492, 2492, 2492, 2492, 2492, 2492, 2492,
    2492, 2492, 2492, 2492, 2492, 2492, 2492, 2492,
    2492, 2492, 2492, 2492, 2492, 2492, 2492, 2492,
    2492, 2492, 2492, 2492, 2492, 2492, 2492, 2492,
    2492, 2492, 2492, 2492, 2492, 2492, 2492, 2492,
    2492, 2492, 2492, 2492, 2492, 2492, 2492, 2492,
    2492, 2492, 2492, 2492, 2492, 2492, 2492, 2492,
    2492, 2492, 2492, 2492, 2492, 2492, 2492, 2492,
    2492, 2492, 2492, 2492, 2492, 2492, 2492, 2492,
    2492, 2492, 2492, 2492, 2492, 2492, 2492, 2492,
    2492, 2492, 2492, 2492, 2492, 2492, 2492, 2492,
    2492, 2492, 2492, 2492, 2492, 2492, 2492, 2492,
    2492, 2492, 2492, 2492, 2492, 2492, 2492, 2492,
    2492, 2492, 2492, 2492, 2492, 2492, 2492, 2492,
    2492, 2492, 2492, 2492, 2492, 2492, 2492, 2492,
    2492, 2492, 2492, 2492, 2492, 2492, 2492, 2492,
    2492, 2492, 2492, 2492, 2492, 2492, 2492, 2492,
    2492, 2492, 2492, 2492, 2492, 2492, 2492, 2492,
    2492, 2492, 2492, 2492, 2492, 2492, 2492, 2492,
    2492, 2492, 2492, 2492, 2492, 2492, 2492, 2492,
    2492, 2492, 2492, 2492, 2492, 2492, 2492, 2492,
    2492, 2492, 2492, 2492, 2492, 2492, 2492, 2492,
    2492, 2492, 2492, 2492, 2492, 2492, 2492, 2492,
    2492, 2492, 2492, 2492, 2492, 2492, 2492, 2492,

    2492, 2492, 2492, 2492, 2492, 2492, 2492, 2492,
    2492, 2492, 2492, 2492, 2492, 2492, 2492, 2492,
    2492, 2492, 2492, 2492, 2492, 2492, 2492, 2492,
    2492, 2492, 2492, 2492, 2492, 2492, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,

    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 1639, 1639,
    1639, 1639, 1639, 1639, 1639, 1639, 2489, 2489,

    1351, 2428, 1351, 1351, 1351, 1351, 1351, 1351,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
    2428, 2428, 2428, 2428, 2428, 2428, 2428, 2428,
    2428, 2428, 2428, 2428, 2428, 2428, 2428, 2428,
    2428, 2428, 2428, 2428, 2428, 2428, 2428, 2428,
    2428, 2428, 2428, 2428, 2428, 2428, 2428, 2428,
    2428, 2428, 2428, 2428, 2428, 2428, 2428, 2428,
    2428, 2428, 2428, 2428, 2428, 2428, 2428, 2428,
    2428, 2428, 2428, 2428, 2428, 2428, 2428, 2428,
    2428, 2428, 2428, 2428, 2428, 2428, 2428, 2428,
    2428, 2428, 2428, 2428, 2428, 2428, 2428, 2428,
    2428, 2428, 2428, 2428, 2428, 2428, 2428, 2428,
    2428, 2428, 2428, 2428, 2428, 2428, 2428, 2428,
    2428, 2428, 2428, 2428, 2428, 2428, 2428, 2428,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,

    2493, 2493, 2493, 2493, 2493, 2493, 2493, 2493,
    2493, 2493, 2493, 2493, 2493, 2493, 2493, 2493,
    2493, 2493, 2493, 2493, 2493, 2493, 2493, 2493,
    2493, 2493, 2493, 2493, 2493, 2493, 2493, 2493,
    2493, 2493, 2493, 2493, 2493, 2493, 2493, 2493,
    2493, 2493, 2493, 2493, 2493, 2493, 2493, 2493,
    2493, 2493, 2493, 2493, 2493, 2493, 2493, 2493,
    2493, 2493, 2493, 2493, 2493, 2493, 2493, 2493,
    2493, 2493, 2493, 2493, 2493, 2493, 2493, 2493,
    2493, 2493, 2493, 2493, 2493, 2493, 2493, 2493,
    2493, 2493, 2493, 2493, 2493, 2493, 2493, 2493,
    2493, 2493, 2493, 2493, 2493, 2493, 2493, 2493,
    2493, 2493, 2493, 2493, 2493, 2493, 2493, 2493,
    2493, 2493, 2493, 2493, 2493, 2493, 2493, 2493,
    2493, 2493, 2493, 2493, 2493, 2493, 2493, 2493,
    2493, 2493, 2493, 2493, 2493, 2493, 2493, 2493,
    2493, 2493, 2493, 2493, 2493, 2493, 2493, 2493,
    2493, 2493, 2493, 2493, 2493, 2493, 2493, 2493,
    2493, 2493, 2493, 2493, 2493, 2493, 2493, 2493,
    2493, 2493, 2493, 2493, 2493, 2493, 2493, 2493,
    2493, 2493, 2493, 2493, 2493, 2493, 2493, 2493,
    2493, 2493, 2493, 2493, 2493, 2493, 2493, 2493,
    2493, 2493, 2493, 2493, 2493, 2493, 2493, 2493,
    2493, 2493, 2493, 2493, 2493, 2493, 2493, 2493,
    2493, 2493, 2493, 2493, 2493, 2493, 2493, 2493,
    2493, 2493, 2493, 2493, 2493, 2493, 2493, 2493,
    2493, 2493, 2493, 2493, 2493, 2493, 2493, 2493,
    2493, 2493, 2493, 2493, 2493, 2493, 2493, 2493,
    2493, 2493, 2493, 2493, 2493, 2493, 2493, 2493,
    2493, 2493, 2493, 2493, 2493, 2493, 2493, 2493,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,

    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
    1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,

    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,

    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2494, 2494,
    2494, 2494, 2494, 2494, 2494, 2494, 2489, 2489
};

#define GET_PROP_INDEX(ucs4) \
       (ucs4 < 0x11000 \
        ? (uc_property_trie[uc_property_trie[ucs4>>5] + (ucs4 & 0x1f)]) \
        : (uc_property_trie[uc_property_trie[((ucs4 - 0x11000)>>8) + 0x880] + (ucs4 & 0xff)]))

#define GET_PROP_INDEX_UCS2(ucs2) \
       (uc_property_trie[uc_property_trie[ucs2>>5] + (ucs2 & 0x1f)])

static const Properties uc_properties[] = {
    { 9, 18, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 3, 0, 0, 21, 2 },
    { 9, 8, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 3, 0, 5, 17, 2 },
    { 9, 7, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 2, 2, 2, 34, 2 },
    { 9, 8, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 3, 3, 5, 35, 2 },
    { 9, 9, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 3, 3, 5, 35, 2 },
    { 9, 7, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 33, 2 },
    { 9, 7, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 3, 0, 0, 21, 2 },
    { 9, 8, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 3, 0, 0, 21, 2 },
    { 6, 9, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 5, 32, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 12, 6, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 10, 13, 3, 2 },
    { 25, 4, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 12, 2 },
    { 27, 4, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 9, 2 },
    { 25, 4, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 10, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 12, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 9, 13, 3, 2 },
    { 21, 10, 0, 0, -1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 13, 0, 2 },
    { 22, 10, 0, 0, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 13, 2, 2 },
    { 26, 3, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 9, 2 },
    { 25, 6, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 13, 11, 8, 2 },
    { 20, 3, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 11, 16, 2 },
    { 25, 6, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 13, 10, 8, 2 },
    { 25, 6, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 7, 2 },
    { 3, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 2 },
    { 3, 2, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 2 },
    { 3, 2, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 2 },
    { 3, 2, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 2 },
    { 3, 2, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 2 },
    { 3, 2, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 2 },
    { 3, 2, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 2 },
    { 3, 2, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 2 },
    { 3, 2, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 2 },
    { 3, 2, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 2 },
    { 25, 6, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 11, 8, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 13, 0, 8, 2 },
    { 26, 10, 0, 0, -1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, -2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 12, 2 },
    { 14, 0, 0, 0, -1, 0, 0, 32, 0, 0, 0, 0, 0, 32, 1, 0, 0, 8, 7, 12, 3 },
    { 21, 10, 0, 0, -1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 13, 0, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 9, 2 },
    { 22, 10, 0, 0, -1, -2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 13, 2, 2 },
    { 28, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 12, 2 },
    { 19, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 15, 0, 12, 2 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -32, 0, -32, 0, 0, 1, 0, 0, 8, 6, 12, 3 },
    { 26, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 17, 2 },
    { 22, 10, 0, 0, -1, -2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 13, 1, 2 },
    { 9, 7, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 3, 3, 3, 35, 2 },
    { 6, 6, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 5, 4, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 2 },
    { 27, 4, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 10, 2 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 12, 2 },
    { 28, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 8, 6, 12, 3 },
    { 23, 10, 0, 0, -1, 16, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 13, 3, 2 },
    { 10, 18, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 3, 4, 4, 17, 2 },
    { 29, 4, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 10, 2 },
    { 26, 4, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 9, 2 },
    { 5, 2, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 5, 2, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 28, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 18, 2 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, 743, 0, 743, 0, 775, 1, 80, 0, 8, 6, 12, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 12, 0, 12, 2 },
    { 5, 2, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 24, 10, 0, 0, -1, -16, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 13, 3, 2 },
    { 5, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 14, 0, 0, 0, -1, 0, 0, 32, 0, 0, 0, 0, 0, 32, 1, 17, 0, 8, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 404, 1, 401, 0, 0, 1, 0, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -32, 0, -32, 0, 0, 1, 17, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, 121, 0, 121, 0, 0, 1, 17, 0, 8, 6, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 17, 0, 8, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -1, 0, -1, 0, 0, 1, 17, 0, 8, 6, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 8, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -1, 0, -1, 0, 0, 1, 0, 0, 8, 6, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 407, 0, 0, 0, 0, 0, 0, 1, 17, 0, 8, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -232, 0, -232, 0, 0, 1, 0, 0, 8, 6, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 80, 0, 8, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -1, 0, -1, 0, 0, 1, 80, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 486, 1, 486, 0, 0, 1, 80, 0, 8, 6, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 0, -121, 0, 0, 0, 0, 0, -121, 1, 17, 0, 8, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -300, 0, -300, 0, -268, 1, 80, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, 195, 0, 195, 0, 0, 1, 0, 0, 8, 6, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 0, 210, 0, 0, 0, 0, 0, 210, 1, 0, 0, 8, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 0, 206, 0, 0, 0, 0, 0, 206, 1, 0, 0, 8, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 0, 205, 0, 0, 0, 0, 0, 205, 1, 0, 0, 8, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 0, 79, 0, 0, 0, 0, 0, 79, 1, 0, 0, 8, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 0, 202, 0, 0, 0, 0, 0, 202, 1, 0, 0, 8, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 0, 203, 0, 0, 0, 0, 0, 203, 1, 0, 0, 8, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 0, 207, 0, 0, 0, 0, 0, 207, 1, 0, 0, 8, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, 97, 0, 97, 0, 0, 1, 0, 0, 8, 6, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 0, 211, 0, 0, 0, 0, 0, 211, 1, 0, 0, 8, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 0, 209, 0, 0, 0, 0, 0, 209, 1, 0, 0, 8, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, 163, 0, 163, 0, 0, 1, 0, 0, 8, 6, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 0, 213, 0, 0, 0, 0, 0, 213, 1, 0, 0, 8, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, 130, 0, 130, 0, 0, 1, 0, 0, 8, 6, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 0, 214, 0, 0, 0, 0, 0, 214, 1, 0, 0, 8, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 0, 218, 0, 0, 0, 0, 0, 218, 1, 0, 0, 8, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 0, 217, 0, 0, 0, 0, 0, 217, 1, 0, 0, 8, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 0, 219, 0, 0, 0, 0, 0, 219, 1, 0, 0, 8, 7, 12, 3 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 8, 8, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, 56, 0, 56, 0, 0, 1, 0, 0, 8, 6, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 0, 2, 0, 0, 0, 1, 0, 2, 1, 80, 0, 8, 7, 12, 3 },
    { 16, 0, 0, 0, -1, 0, 0, 1, 0, -1, 0, 0, 0, 1, 1, 80, 0, 8, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -2, 0, -1, 0, 0, 1, 80, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -79, 0, -79, 0, 0, 1, 0, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 497, 1, 497, 0, 0, 1, 17, 0, 8, 6, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 0, -97, 0, 0, 0, 0, 0, -97, 4, 0, 0, 8, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 0, -56, 0, 0, 0, 0, 0, -56, 4, 0, 0, 8, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 4, 17, 0, 8, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -1, 0, -1, 0, 0, 4, 17, 0, 8, 6, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 4, 0, 0, 8, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -1, 0, -1, 0, 0, 4, 0, 0, 8, 6, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 0, -130, 0, 0, 0, 0, 0, -130, 6, 0, 0, 8, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 8, 6, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 1, 0, 0, 0, 0, 1, 1, 8, 0, 0, 8, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 8, 0, 0, 8, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -1, 0, -1, 0, 0, 8, 0, 0, 8, 6, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 0, -163, 0, 0, 0, 0, 0, -163, 8, 0, 0, 8, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 3, 0, 0, 0, 0, 1, 3, 8, 0, 0, 8, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 5, 1, 5, 0, 0, 8, 0, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 7, 1, 7, 0, 0, 8, 0, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -1, 0, -1, 0, 0, 9, 0, 0, 8, 6, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 0, -195, 0, 0, 0, 0, 0, -195, 9, 0, 0, 8, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 0, 69, 0, 0, 0, 0, 0, 69, 9, 0, 0, 8, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 0, 71, 0, 0, 0, 0, 0, 71, 9, 0, 0, 8, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 9, 0, 0, 8, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 9, 1, 9, 0, 0, 1, 0, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 11, 1, 11, 0, 0, 1, 0, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 13, 1, 13, 0, 0, 1, 0, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -210, 0, -210, 0, 0, 1, 0, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -206, 0, -206, 0, 0, 1, 0, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -205, 0, -205, 0, 0, 1, 0, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -202, 0, -202, 0, 0, 1, 0, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -203, 0, -203, 0, 0, 1, 0, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 15, 1, 15, 0, 0, 1, 0, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 17, 1, 17, 0, 0, 1, 0, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -207, 0, -207, 0, 0, 1, 0, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 19, 1, 19, 0, 0, 1, 0, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 21, 1, 21, 0, 0, 1, 0, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -209, 0, -209, 0, 0, 1, 0, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -211, 0, -211, 0, 0, 1, 0, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 23, 1, 23, 0, 0, 1, 0, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 25, 1, 25, 0, 0, 1, 0, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 27, 1, 27, 0, 0, 1, 0, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -213, 0, -213, 0, 0, 1, 0, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -214, 0, -214, 0, 0, 1, 0, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 29, 1, 29, 0, 0, 1, 0, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -218, 0, -218, 0, 0, 1, 0, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 31, 1, 31, 0, 0, 1, 0, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -69, 0, -69, 0, 0, 1, 0, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -217, 0, -217, 0, 0, 1, 0, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -71, 0, -71, 0, 0, 1, 0, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -219, 0, -219, 0, 0, 1, 0, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 33, 1, 33, 0, 0, 1, 0, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 35, 1, 35, 0, 0, 1, 0, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 6, 12, 3 },
    { 17, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 8, 6, 12, 3 },
    { 17, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 8, 8, 12, 2 },
    { 17, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 8, 8, 12, 2 },
    { 17, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 8, 6, 12, 2 },
    { 17, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 8, 8, 18, 2 },
    { 28, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 12, 0, 12, 2 },
    { 28, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 18, 2 },
    { 28, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 12, 36 },
    { 17, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 8, 12, 2 },
    { 28, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 12, 2 },
    { 17, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 8, 12, 2 },
    { 28, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 12, 2 },
    { 0, 17, 230, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 204, 4, 4, 4, 21, 1 },
    { 0, 17, 230, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 1 },
    { 0, 17, 232, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 1 },
    { 0, 17, 220, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 1 },
    { 0, 17, 216, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 204, 4, 4, 4, 21, 1 },
    { 0, 17, 202, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 1 },
    { 0, 17, 220, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 204, 4, 4, 4, 21, 1 },
    { 0, 17, 202, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 204, 4, 4, 4, 21, 1 },
    { 0, 17, 1, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 1 },
    { 0, 17, 1, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 204, 4, 4, 4, 21, 1 },
    { 0, 17, 230, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 85, 4, 4, 4, 21, 1 },
    { 0, 17, 240, 5, -1, 0, 0, 0, 0, 84, 0, 84, 0, 116, 1, 204, 4, 4, 4, 21, 1 },
    { 0, 17, 230, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 4, 4, 4, 21, 1 },
    { 0, 17, 220, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 4, 4, 4, 21, 1 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 4, 4, 4, 4, 1 },
    { 0, 17, 230, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 4, 4, 4, 21, 1 },
    { 0, 17, 220, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 4, 4, 4, 21, 1 },
    { 0, 17, 232, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 4, 4, 4, 21, 1 },
    { 0, 17, 220, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 4, 4, 4, 21, 1 },
    { 0, 17, 230, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 4, 4, 4, 21, 1 },
    { 0, 17, 233, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 4, 4, 4, 4, 1 },
    { 0, 17, 234, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 4, 4, 4, 4, 1 },
    { 0, 17, 233, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 4, 4, 4, 4, 1 },
    { 0, 17, 234, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 4, 1 },
    { 0, 17, 233, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 4, 4, 4, 4, 1 },
    { 0, 17, 230, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 4, 4, 4, 21, 1 },
    { 14, 0, 0, 0, -1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 10, 0, 0, 8, 7, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -1, 0, -1, 0, 0, 10, 0, 0, 8, 6, 12, 4 },
    { 17, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 85, 0, 8, 8, 12, 2 },
    { 28, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 12, 4 },
    { 13, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0 },
    { 17, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, 130, 0, 130, 0, 0, 9, 0, 0, 8, 6, 12, 4 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 85, 0, 13, 0, 8, 2 },
    { 14, 0, 0, 0, -1, 0, 0, 116, 0, 0, 0, 0, 0, 116, 16, 0, 0, 8, 7, 12, 4 },
    { 28, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 12, 4 },
    { 28, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 81, 0, 0, 0, 12, 2 },
    { 14, 0, 0, 0, -1, 0, 0, 38, 0, 0, 0, 0, 0, 38, 1, 17, 0, 8, 7, 12, 4 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 85, 0, 12, 0, 12, 2 },
    { 14, 0, 0, 0, -1, 0, 0, 37, 0, 0, 0, 0, 0, 37, 1, 17, 0, 8, 7, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 0, 64, 0, 0, 0, 0, 0, 64, 1, 17, 0, 8, 7, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 0, 63, 0, 0, 0, 0, 0, 63, 1, 17, 0, 8, 7, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 489, 1, 489, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 0, 32, 0, 0, 0, 0, 0, 32, 1, 0, 0, 8, 7, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 0, 32, 0, 0, 0, 0, 0, 32, 1, 17, 0, 8, 7, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -38, 0, -38, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -37, 0, -37, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 493, 1, 493, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -32, 0, -32, 0, 0, 1, 0, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -31, 0, -31, 0, 1, 1, 0, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -32, 0, -32, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -64, 0, -64, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -63, 0, -63, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 0, 8, 0, 0, 0, 0, 0, 8, 10, 0, 0, 8, 7, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -62, 0, -62, 0, -30, 1, 80, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -57, 0, -57, 0, -25, 1, 80, 0, 8, 6, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 8, 7, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 81, 0, 8, 7, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -47, 0, -47, 0, -15, 1, 80, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -54, 0, -54, 0, -22, 1, 80, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -8, 0, -8, 0, 0, 4, 0, 0, 8, 6, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 6, 0, 0, 8, 7, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -1, 0, -1, 0, 0, 6, 0, 0, 8, 6, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 8, 7, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -1, 0, -1, 0, 0, 4, 0, 0, 8, 6, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 8, 7, 12, 46 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -1, 0, -1, 0, 0, 1, 0, 0, 8, 6, 12, 46 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -86, 0, -86, 0, -54, 1, 80, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -80, 0, -80, 0, -48, 1, 80, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, 7, 0, 7, 0, 0, 1, 80, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -116, 0, -116, 0, 0, 1, 0, 0, 8, 6, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 0, -60, 0, 0, 0, 0, 0, -60, 5, 80, 0, 8, 7, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -96, 0, -96, 0, -64, 5, 80, 0, 8, 6, 12, 4 },
    { 26, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 7, 0, 0, 8, 7, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -1, 0, -1, 0, 0, 7, 0, 0, 8, 6, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 0, -7, 0, 0, 0, 0, 0, -7, 7, 80, 0, 8, 7, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 8, 6, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 0, -130, 0, 0, 0, 0, 0, -130, 8, 0, 0, 8, 7, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 0, 80, 0, 0, 0, 0, 0, 80, 4, 17, 0, 8, 7, 12, 5 },
    { 14, 0, 0, 0, -1, 0, 0, 80, 0, 0, 0, 0, 0, 80, 1, 17, 0, 8, 7, 12, 5 },
    { 14, 0, 0, 0, -1, 0, 0, 80, 0, 0, 0, 0, 0, 80, 1, 0, 0, 8, 7, 12, 5 },
    { 14, 0, 0, 0, -1, 0, 0, 32, 0, 0, 0, 0, 0, 32, 1, 0, 0, 8, 7, 12, 5 },
    { 14, 0, 0, 0, -1, 0, 0, 32, 0, 0, 0, 0, 0, 32, 1, 17, 0, 8, 7, 12, 5 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -32, 0, -32, 0, 0, 1, 0, 0, 8, 6, 12, 5 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -32, 0, -32, 0, 0, 1, 17, 0, 8, 6, 12, 5 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -80, 0, -80, 0, 0, 4, 17, 0, 8, 6, 12, 5 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -80, 0, -80, 0, 0, 1, 17, 0, 8, 6, 12, 5 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -80, 0, -80, 0, 0, 1, 0, 0, 8, 6, 12, 5 },
    { 14, 0, 0, 0, -1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 8, 7, 12, 5 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -1, 0, -1, 0, 0, 1, 0, 0, 8, 6, 12, 5 },
    { 14, 0, 0, 0, -1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 17, 0, 8, 7, 12, 5 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -1, 0, -1, 0, 0, 1, 17, 0, 8, 6, 12, 5 },
    { 29, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 12, 5 },
    { 0, 17, 230, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 5 },
    { 0, 17, 230, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 4, 4, 4, 21, 5 },
    { 2, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 4, 4, 4, 21, 5 },
    { 14, 0, 0, 0, -1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 6, 0, 0, 8, 7, 12, 5 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -1, 0, -1, 0, 0, 6, 0, 0, 8, 6, 12, 5 },
    { 14, 0, 0, 0, -1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 4, 0, 0, 8, 7, 12, 5 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -1, 0, -1, 0, 0, 4, 0, 0, 8, 6, 12, 5 },
    { 14, 0, 0, 0, -1, 0, 0, 15, 0, 0, 0, 0, 0, 15, 1, 0, 0, 8, 7, 12, 5 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -15, 0, -15, 0, 0, 9, 0, 0, 8, 6, 12, 5 },
    { 14, 0, 0, 0, -1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 4, 17, 0, 8, 7, 12, 5 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -1, 0, -1, 0, 0, 4, 17, 0, 8, 6, 12, 5 },
    { 14, 0, 0, 0, -1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 8, 0, 0, 8, 7, 12, 5 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -1, 0, -1, 0, 0, 8, 0, 0, 8, 6, 12, 5 },
    { 14, 0, 0, 0, -1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 9, 0, 0, 8, 7, 12, 5 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -1, 0, -1, 0, 0, 9, 0, 0, 8, 6, 12, 5 },
    { 14, 0, 0, 0, -1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 10, 0, 0, 8, 7, 12, 5 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -1, 0, -1, 0, 0, 10, 0, 0, 8, 6, 12, 5 },
    { 14, 0, 0, 0, -1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 11, 0, 0, 8, 7, 12, 5 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -1, 0, -1, 0, 0, 11, 0, 0, 8, 6, 12, 5 },
    { 14, 0, 0, 0, -1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 12, 0, 0, 8, 7, 12, 5 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -1, 0, -1, 0, 0, 12, 0, 0, 8, 6, 12, 5 },
    { 14, 0, 0, 0, -1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 16, 0, 0, 8, 7, 12, 5 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -1, 0, -1, 0, 0, 16, 0, 0, 8, 6, 12, 5 },
    { 14, 0, 0, 0, -1, 0, 0, 48, 0, 0, 0, 0, 0, 48, 1, 0, 0, 8, 7, 12, 6 },
    { 17, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 8, 8, 12, 6 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 12, 6 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 11, 12, 6 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -48, 0, -48, 0, 0, 1, 0, 0, 8, 6, 12, 6 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 453, 1, 450, 0, 0, 1, 80, 0, 8, 6, 12, 6 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 13, 12, 8, 2 },
    { 20, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 17, 6 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 12, 6 },
    { 27, 4, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 0, 0, 9, 6 },
    { 13, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0 },
    { 0, 17, 220, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 4, 4, 4, 21, 7 },
    { 0, 17, 230, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 4, 4, 4, 21, 7 },
    { 0, 17, 222, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 4, 4, 4, 21, 7 },
    { 0, 17, 220, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 4, 4, 4, 21, 7 },
    { 0, 17, 228, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 4, 4, 4, 21, 7 },
    { 0, 17, 10, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 7 },
    { 0, 17, 11, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 7 },
    { 0, 17, 12, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 7 },
    { 0, 17, 13, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 7 },
    { 0, 17, 14, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 7 },
    { 0, 17, 15, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 7 },
    { 0, 17, 16, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 7 },
    { 0, 17, 17, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 7 },
    { 0, 17, 18, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 7 },
    { 0, 17, 19, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 7 },
    { 0, 17, 19, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 4, 4, 4, 21, 7 },
    { 0, 17, 20, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 7 },
    { 0, 17, 21, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 7 },
    { 0, 17, 22, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 7 },
    { 20, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 17, 7 },
    { 0, 17, 23, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 7 },
    { 25, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 12, 7 },
    { 0, 17, 24, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 7 },
    { 0, 17, 25, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 7 },
    { 25, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 6, 7 },
    { 0, 17, 18, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 4, 4, 4, 21, 7 },
    { 18, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 7, 8, 13, 7 },
    { 25, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 8, 8, 12, 7 },
    { 25, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 12, 0, 12, 7 },
    { 10, 5, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 3, 4, 4, 12, 8 },
    { 10, 5, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 3, 4, 4, 12, 8 },
    { 10, 5, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 3, 4, 4, 12, 2 },
    { 26, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 12, 8 },
    { 26, 13, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 12, 8 },
    { 25, 4, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 10, 8 },
    { 27, 13, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 10, 8 },
    { 25, 13, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 13, 11, 8, 8 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 12, 8 },
    { 0, 17, 230, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 4, 4, 4, 21, 8 },
    { 0, 17, 230, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 4, 4, 4, 21, 8 },
    { 0, 17, 30, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 4, 4, 4, 21, 8 },
    { 0, 17, 31, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 4, 4, 4, 21, 8 },
    { 0, 17, 32, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 4, 4, 4, 21, 8 },
    { 25, 13, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 6, 2 },
    { 10, 13, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 0, 3, 4, 4, 21, 2 },
    { 13, 13, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0 },
    { 25, 13, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 6, 8 },
    { 25, 13, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 12, 6, 2 },
    { 18, 13, 0, 2, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 8, 8, 12, 8 },
    { 18, 13, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 8, 8, 12, 8 },
    { 18, 13, 0, 3, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 17, 0, 8, 8, 12, 8 },
    { 18, 13, 0, 2, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 17, 0, 8, 8, 12, 8 },
    { 18, 13, 0, 3, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 8, 8, 12, 8 },
    { 18, 13, 0, 2, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 8, 8, 12, 8 },
    { 18, 13, 0, 2, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 8, 8, 12, 8 },
    { 17, 13, 0, 1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 8, 8, 12, 2 },
    { 0, 17, 27, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 1 },
    { 0, 17, 28, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 1 },
    { 0, 17, 29, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 1 },
    { 0, 17, 30, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 1 },
    { 0, 17, 31, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 1 },
    { 0, 17, 32, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 1 },
    { 0, 17, 33, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 1 },
    { 0, 17, 34, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 1 },
    { 0, 17, 230, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 204, 4, 4, 4, 21, 1 },
    { 0, 17, 220, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 204, 4, 4, 4, 21, 1 },
    { 0, 17, 220, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 4, 4, 4, 21, 8 },
    { 0, 17, 230, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 4, 4, 4, 21, 8 },
    { 0, 17, 220, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 4, 4, 4, 21, 8 },
    { 0, 17, 220, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 4, 4, 4, 21, 8 },
    { 3, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 8 },
    { 3, 5, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 8 },
    { 3, 5, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 8 },
    { 3, 5, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 8 },
    { 3, 5, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 8 },
    { 3, 5, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 8 },
    { 3, 5, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 8 },
    { 3, 5, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 8 },
    { 3, 5, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 8 },
    { 3, 5, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 8 },
    { 25, 4, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 10, 8 },
    { 25, 5, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 8 },
    { 25, 5, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 13, 9, 11, 8 },
    { 25, 13, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 12, 8 },
    { 18, 13, 0, 2, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 8, 8, 12, 8 },
    { 0, 17, 35, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 1 },
    { 18, 13, 0, 3, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 8, 8, 12, 8 },
    { 18, 13, 0, 2, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 8, 8, 12, 8 },
    { 18, 13, 0, 2, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 8, 12, 8 },
    { 18, 13, 0, 3, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 8, 12, 8 },
    { 25, 13, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 12, 6, 8 },
    { 0, 17, 230, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 8 },
    { 10, 5, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 3, 4, 4, 12, 2 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 12, 8 },
    { 0, 17, 220, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 8 },
    { 17, 13, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 8, 8, 12, 8 },
    { 18, 13, 0, 3, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 8, 8, 12, 8 },
    { 3, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 8 },
    { 3, 2, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 8 },
    { 3, 2, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 8 },
    { 3, 2, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 8 },
    { 3, 2, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 8 },
    { 3, 2, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 8 },
    { 3, 2, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 8 },
    { 3, 2, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 8 },
    { 3, 2, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 8 },
    { 3, 2, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 8 },
    { 29, 13, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 12, 8 },
    { 18, 13, 0, 2, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 8, 8, 12, 8 },
    { 25, 13, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 12, 12, 9 },
    { 25, 13, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 12, 9 },
    { 10, 13, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 3, 4, 4, 12, 9 },
    { 18, 13, 0, 3, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 8, 12, 9 },
    { 0, 17, 36, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 4, 4, 4, 21, 9 },
    { 18, 13, 0, 2, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 8, 12, 9 },
    { 18, 13, 0, 2, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 8, 8, 12, 9 },
    { 18, 13, 0, 3, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 8, 8, 12, 9 },
    { 0, 17, 230, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 4, 4, 4, 21, 9 },
    { 0, 17, 220, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 4, 4, 4, 21, 9 },
    { 18, 13, 0, 2, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 8, 8, 12, 8 },
    { 18, 13, 0, 3, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 8, 8, 12, 8 },
    { 18, 13, 0, 3, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 8, 8, 12, 8 },
    { 18, 13, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 8, 12, 10 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 4, 4, 4, 21, 10 },
    { 18, 13, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 8, 8, 12, 10 },
    { 3, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 14, 9, 11, 66 },
    { 3, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 14, 9, 11, 66 },
    { 3, 1, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 14, 9, 11, 66 },
    { 3, 1, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 14, 9, 11, 66 },
    { 3, 1, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 14, 9, 11, 66 },
    { 3, 1, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 14, 9, 11, 66 },
    { 3, 1, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 14, 9, 11, 66 },
    { 3, 1, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 14, 9, 11, 66 },
    { 3, 1, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 14, 9, 11, 66 },
    { 3, 1, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 14, 9, 11, 66 },
    { 18, 1, 0, 2, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 8, 8, 12, 66 },
    { 0, 17, 230, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 4, 4, 4, 21, 66 },
    { 0, 17, 220, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 4, 4, 4, 21, 66 },
    { 17, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 8, 8, 12, 66 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 12, 66 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 12, 66 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 13, 11, 8, 66 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 12, 6, 66 },
    { 17, 1, 0, 1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 8, 8, 12, 66 },
    { 18, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 8, 8, 12, 82 },
    { 0, 17, 230, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 4, 4, 4, 21, 82 },
    { 17, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 8, 8, 12, 82 },
    { 25, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 12, 82 },
    { 18, 1, 0, 3, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 8, 8, 12, 95 },
    { 18, 1, 0, 2, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 8, 8, 12, 95 },
    { 18, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 8, 8, 12, 95 },
    { 0, 17, 220, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 4, 4, 4, 21, 95 },
    { 25, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 12, 95 },
    { 18, 13, 0, 2, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 8, 8, 12, 8 },
    { 18, 13, 0, 2, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 8, 8, 12, 8 },
    { 18, 13, 0, 3, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 8, 8, 12, 8 },
    { 18, 13, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 8, 8, 12, 8 },
    { 18, 13, 0, 3, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 8, 8, 12, 8 },
    { 18, 13, 0, 2, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 8, 8, 12, 8 },
    { 0, 17, 220, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 4, 4, 4, 21, 8 },
    { 0, 17, 230, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 4, 4, 4, 21, 8 },
    { 0, 17, 220, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 4, 4, 4, 21, 8 },
    { 0, 17, 27, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 4, 4, 4, 21, 8 },
    { 0, 17, 28, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 4, 4, 4, 21, 8 },
    { 0, 17, 29, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 4, 4, 4, 21, 8 },
    { 0, 17, 230, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 4, 4, 4, 21, 8 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 4, 4, 4, 21, 11 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 11 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 7, 4, 4, 21, 11 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 8, 8, 12, 11 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 8, 8, 12, 11 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 17, 0, 8, 8, 12, 11 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 4, 4, 4, 21, 11 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 7, 4, 4, 21, 11 },
    { 0, 17, 7, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 204, 4, 4, 4, 21, 11 },
    { 0, 17, 9, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 11 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 7, 4, 4, 21, 11 },
    { 0, 17, 230, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 11 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 85, 0, 8, 8, 12, 11 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 12, 17, 2 },
    { 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 11 },
    { 3, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 11 },
    { 3, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 11 },
    { 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 11 },
    { 3, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 11 },
    { 3, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 11 },
    { 3, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 11 },
    { 3, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 11 },
    { 3, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 11 },
    { 3, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 11 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 12, 11 },
    { 17, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 8, 8, 12, 11 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 8, 8, 12, 11 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 8, 8, 12, 11 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 8, 8, 12, 11 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 8, 8, 12, 11 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 8, 8, 12, 11 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 8, 8, 12, 11 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 8, 8, 12, 12 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 12 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 7, 4, 4, 21, 12 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 8, 8, 12, 12 },
    { 0, 17, 7, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 12 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 8, 8, 12, 12 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 204, 4, 4, 4, 21, 12 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 17, 7, 4, 4, 21, 12 },
    { 0, 17, 9, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 12 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 8, 8, 12, 12 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 85, 0, 8, 8, 12, 12 },
    { 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 12 },
    { 3, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 12 },
    { 3, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 12 },
    { 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 12 },
    { 3, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 12 },
    { 3, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 12 },
    { 3, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 12 },
    { 3, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 12 },
    { 3, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 12 },
    { 3, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 12 },
    { 27, 4, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 10, 12 },
    { 5, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 12, 12 },
    { 5, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 10, 12 },
    { 29, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 12, 12 },
    { 27, 4, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 9, 12 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 4, 4, 4, 21, 13 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 13 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 7, 4, 4, 21, 13 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 8, 8, 12, 13 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 85, 0, 8, 8, 12, 13 },
    { 0, 17, 7, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 13 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 7, 4, 4, 21, 13 },
    { 0, 17, 9, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 13 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 4, 4, 4, 21, 13 },
    { 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 13 },
    { 3, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 13 },
    { 3, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 13 },
    { 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 13 },
    { 3, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 13 },
    { 3, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 13 },
    { 3, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 13 },
    { 3, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 13 },
    { 3, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 13 },
    { 3, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 13 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 14 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 7, 4, 4, 21, 14 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 8, 8, 12, 14 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 8, 8, 12, 14 },
    { 0, 17, 7, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 14 },
    { 0, 17, 9, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 14 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 4, 4, 4, 21, 14 },
    { 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 14 },
    { 3, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 14 },
    { 3, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 14 },
    { 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 14 },
    { 3, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 14 },
    { 3, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 14 },
    { 3, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 14 },
    { 3, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 14 },
    { 3, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 14 },
    { 3, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 14 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 0, 0, 12, 14 },
    { 27, 4, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 9, 14 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 8, 8, 12, 14 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 15 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 7, 4, 4, 21, 15 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 8, 8, 12, 15 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 8, 8, 12, 15 },
    { 0, 17, 7, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 15 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 204, 4, 4, 4, 21, 15 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 4, 4, 4, 21, 15 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 17, 7, 4, 4, 21, 15 },
    { 0, 17, 9, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 15 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 204, 4, 4, 4, 21, 15 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 85, 0, 8, 8, 12, 15 },
    { 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 15 },
    { 3, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 15 },
    { 3, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 15 },
    { 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 15 },
    { 3, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 15 },
    { 3, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 15 },
    { 3, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 15 },
    { 3, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 15 },
    { 3, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 15 },
    { 3, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 15 },
    { 29, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 12, 15 },
    { 5, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 12, 15 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 16 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 8, 8, 12, 16 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 17, 0, 8, 8, 12, 16 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 8, 8, 12, 16 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 204, 4, 4, 4, 21, 16 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 7, 4, 4, 21, 16 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 17, 7, 4, 4, 21, 16 },
    { 0, 17, 9, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 16 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 8, 8, 12, 16 },
    { 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 14, 9, 11, 16 },
    { 3, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 16 },
    { 3, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 16 },
    { 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 16 },
    { 3, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 16 },
    { 3, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 16 },
    { 3, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 16 },
    { 3, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 16 },
    { 3, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 16 },
    { 3, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 16 },
    { 5, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 12, 16 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 12, 16 },
    { 27, 4, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 9, 16 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 4, 4, 4, 21, 17 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 7, 4, 4, 21, 17 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 8, 8, 12, 17 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 8, 8, 12, 17 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 8, 8, 12, 17 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 17 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 17, 4, 4, 4, 21, 17 },
    { 0, 17, 9, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 17 },
    { 0, 17, 84, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 17 },
    { 0, 17, 91, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 204, 4, 4, 4, 21, 17 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 8, 8, 12, 17 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 4, 4, 4, 21, 17 },
    { 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 17 },
    { 3, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 17 },
    { 3, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 17 },
    { 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 17 },
    { 3, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 17 },
    { 3, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 17 },
    { 3, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 17 },
    { 3, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 17 },
    { 3, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 17 },
    { 3, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 17 },
    { 5, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 12, 17 },
    { 29, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 12, 17 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 4, 4, 4, 21, 18 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 7, 4, 4, 21, 18 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 8, 8, 12, 18 },
    { 0, 17, 7, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 4, 4, 4, 21, 18 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 8, 8, 12, 18 },
    { 0, 0, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 18 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 17, 7, 4, 4, 21, 18 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 204, 4, 4, 4, 21, 18 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 18 },
    { 0, 17, 9, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 18 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 4, 4, 4, 21, 18 },
    { 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 18 },
    { 3, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 18 },
    { 3, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 18 },
    { 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 18 },
    { 3, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 18 },
    { 3, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 18 },
    { 3, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 18 },
    { 3, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 18 },
    { 3, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 18 },
    { 3, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 18 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 8, 8, 12, 18 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 4, 4, 4, 21, 19 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 7, 4, 4, 21, 19 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 8, 8, 12, 19 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 8, 8, 12, 19 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 8, 8, 12, 19 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 204, 4, 4, 4, 21, 19 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 19 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 4, 4, 4, 21, 19 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 17, 7, 4, 4, 21, 19 },
    { 0, 17, 9, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 19 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 8, 8, 12, 19 },
    { 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 19 },
    { 3, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 19 },
    { 3, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 19 },
    { 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 19 },
    { 3, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 19 },
    { 3, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 19 },
    { 3, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 19 },
    { 3, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 19 },
    { 3, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 19 },
    { 3, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 19 },
    { 5, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 12, 19 },
    { 29, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 10, 19 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 7, 4, 4, 21, 20 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 8, 12, 20 },
    { 0, 17, 9, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 204, 4, 4, 4, 21, 20 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 204, 4, 4, 4, 21, 20 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 4, 4, 4, 21, 20 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 17, 7, 4, 4, 21, 20 },
    { 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 20 },
    { 3, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 20 },
    { 3, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 20 },
    { 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 20 },
    { 3, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 20 },
    { 3, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 20 },
    { 3, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 20 },
    { 3, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 20 },
    { 3, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 20 },
    { 3, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 20 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 12, 20 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 8, 30, 21 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 30, 21 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 7, 0, 8, 30, 21 },
    { 0, 17, 103, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 30, 21 },
    { 0, 17, 9, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 30, 21 },
    { 17, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 8, 30, 21 },
    { 0, 17, 107, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 30, 21 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 12, 21 },
    { 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 21 },
    { 3, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 21 },
    { 3, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 21 },
    { 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 21 },
    { 3, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 21 },
    { 3, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 21 },
    { 3, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 21 },
    { 3, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 21 },
    { 3, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 21 },
    { 3, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 21 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 17, 21 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 8, 30, 22 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 30, 22 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 7, 0, 8, 30, 22 },
    { 0, 17, 118, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 30, 22 },
    { 17, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 8, 30, 22 },
    { 0, 17, 122, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 30, 22 },
    { 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 22 },
    { 3, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 22 },
    { 3, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 22 },
    { 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 22 },
    { 3, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 22 },
    { 3, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 22 },
    { 3, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 22 },
    { 3, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 22 },
    { 3, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 22 },
    { 3, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 14, 9, 11, 22 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 8, 30, 22 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 0, 8, 30, 22 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 8, 8, 12, 23 },
    { 29, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 18, 23 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 18, 23 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 12, 23 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 4, 23 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 17, 23 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 80, 0, 0, 0, 4, 23 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 6, 23 },
    { 29, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 12, 23 },
    { 0, 17, 220, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 4, 4, 4, 21, 23 },
    { 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 14, 9, 11, 23 },
    { 3, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 14, 9, 11, 23 },
    { 3, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 14, 9, 11, 23 },
    { 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 14, 9, 11, 23 },
    { 3, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 14, 9, 11, 23 },
    { 3, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 14, 9, 11, 23 },
    { 3, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 14, 9, 11, 23 },
    { 3, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 14, 9, 11, 23 },
    { 3, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 14, 9, 11, 23 },
    { 3, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 14, 9, 11, 23 },
    { 5, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 12, 23 },
    { 29, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 17, 23 },
    { 0, 17, 216, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 4, 4, 4, 21, 23 },
    { 21, 10, 0, 0, -1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 13, 0, 23 },
    { 22, 10, 0, 0, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 13, 1, 23 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 7, 4, 4, 21, 23 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 85, 0, 8, 8, 12, 23 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 8, 12, 23 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 8, 8, 12, 23 },
    { 0, 17, 129, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 4, 4, 4, 21, 23 },
    { 0, 17, 130, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 4, 4, 4, 21, 23 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 85, 4, 4, 4, 21, 23 },
    { 0, 17, 132, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 4, 4, 4, 21, 23 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 80, 4, 4, 4, 21, 23 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 4, 4, 4, 21, 23 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 7, 4, 4, 17, 23 },
    { 0, 17, 230, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 4, 4, 4, 21, 23 },
    { 0, 17, 9, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 4, 4, 4, 21, 23 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 8, 8, 12, 23 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 4, 4, 4, 21, 23 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 4, 4, 4, 21, 23 },
    { 29, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 17, 23 },
    { 29, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 12, 23 },
    { 0, 17, 220, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 4, 4, 4, 21, 23 },
    { 29, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 12, 23 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 18, 23 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 17, 23 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 18, 23 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 12, 23 },
    { 29, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 12, 2 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 4, 23 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 8, 30, 24 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 8, 30, 24 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 17, 0, 0, 8, 30, 24 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 4, 4, 30, 24 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 4, 4, 30, 24 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 4, 4, 4, 30, 24 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 204, 4, 4, 4, 30, 24 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 7, 4, 4, 30, 24 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 4, 4, 4, 30, 24 },
    { 0, 17, 7, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 4, 4, 4, 30, 24 },
    { 0, 17, 9, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 4, 4, 4, 30, 24 },
    { 0, 17, 9, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 4, 4, 4, 30, 24 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 7, 4, 4, 30, 24 },
    { 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 14, 9, 11, 24 },
    { 3, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 14, 9, 11, 24 },
    { 3, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 14, 9, 11, 24 },
    { 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 14, 9, 11, 24 },
    { 3, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 14, 9, 11, 24 },
    { 3, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 14, 9, 11, 24 },
    { 3, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 14, 9, 11, 24 },
    { 3, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 14, 9, 11, 24 },
    { 3, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 14, 9, 11, 24 },
    { 3, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 14, 9, 11, 24 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 12, 17, 24 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 12, 24 },
    { 0, 17, 220, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 4, 4, 4, 30, 24 },
    { 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 24 },
    { 3, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 24 },
    { 3, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 24 },
    { 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 24 },
    { 3, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 24 },
    { 3, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 24 },
    { 3, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 24 },
    { 3, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 24 },
    { 3, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 24 },
    { 3, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 24 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 4, 4, 30, 24 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 4, 4, 4, 30, 24 },
    { 29, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 30, 24 },
    { 14, 0, 0, 0, -1, 0, 0, 7264, 0, 0, 0, 0, 0, 7264, 1, 0, 0, 8, 7, 12, 25 },
    { 14, 0, 0, 0, -1, 0, 0, 7264, 0, 0, 0, 0, 0, 7264, 13, 0, 0, 8, 7, 12, 25 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 8, 8, 12, 25 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 8, 8, 12, 25 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 8, 8, 12, 25 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 12, 2 },
    { 17, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 80, 0, 8, 8, 12, 25 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 8, 8, 12, 25 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 8, 8, 8, 25, 26 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 8, 8, 8, 25, 26 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 9, 8, 8, 26, 26 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 204, 9, 8, 8, 26, 26 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 9, 8, 8, 26, 26 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 204, 10, 8, 8, 27, 26 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 10, 8, 8, 27, 26 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 10, 8, 8, 27, 26 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 8, 12, 27 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 8, 8, 12, 27 },
    { 0, 17, 230, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 4, 4, 4, 21, 27 },
    { 0, 17, 230, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 4, 4, 4, 21, 27 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 12, 27 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 17, 27 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 12, 12, 27 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 12, 27 },
    { 5, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 12, 27 },
    { 5, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 12, 27 },
    { 5, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 12, 27 },
    { 5, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 12, 27 },
    { 5, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 12, 27 },
    { 5, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 12, 27 },
    { 5, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 12, 27 },
    { 5, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 12, 27 },
    { 5, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 12, 27 },
    { 5, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 12, 27 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 12, 27 },
    { 14, 0, 0, 0, -1, 0, 1, 37, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 39, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 41, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 43, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 45, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 47, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 49, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 51, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 53, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 55, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 57, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 59, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 61, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 63, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 65, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 67, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 69, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 71, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 73, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 75, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 77, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 79, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 81, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 83, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 85, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 87, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 89, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 91, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 93, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 95, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 97, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 99, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 101, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 103, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 105, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 107, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 109, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 111, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 113, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 115, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 117, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 119, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 121, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 123, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 125, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 127, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 129, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 131, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 133, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 135, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 137, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 139, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 141, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 143, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 145, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 147, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 149, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 151, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 153, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 155, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 157, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 159, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 161, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 163, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 165, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 167, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 169, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 171, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 173, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 175, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 177, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 179, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 181, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 183, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 185, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 187, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 189, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 191, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 193, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 1, 195, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 0, 8, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 12, 28 },
    { 14, 0, 0, 0, -1, 0, 0, 8, 0, 0, 0, 0, 0, 0, 17, 0, 0, 8, 7, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -8, 0, -8, 0, -8, 17, 0, 0, 8, 6, 12, 28 },
    { 20, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 17, 29 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 8, 12, 29 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 12, 29 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 12, 12, 29 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 8, 8, 12, 29 },
    { 6, 9, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 5, 17, 30 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 8, 12, 30 },
    { 21, 10, 0, 0, -1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 13, 0, 30 },
    { 22, 10, 0, 0, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 13, 1, 30 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 8, 12, 31 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 17, 2 },
    { 4, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 8, 12, 31 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 8, 8, 12, 31 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 8, 8, 12, 42 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 4, 4, 4, 21, 42 },
    { 0, 17, 9, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 4, 4, 4, 21, 42 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 8, 8, 12, 43 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 4, 4, 4, 21, 43 },
    { 0, 17, 9, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 4, 4, 4, 21, 43 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 12, 17, 2 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 8, 8, 12, 44 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 4, 4, 4, 21, 44 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 8, 8, 12, 45 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 4, 4, 4, 21, 45 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 8, 30, 32 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 4, 4, 4, 30, 32 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 7, 4, 4, 30, 32 },
    { 0, 17, 9, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 4, 4, 4, 30, 32 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 17, 32 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 5, 32 },
    { 17, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 8, 30, 32 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 12, 32 },
    { 27, 4, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 9, 32 },
    { 0, 17, 230, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 4, 4, 4, 30, 32 },
    { 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 14, 9, 11, 32 },
    { 3, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 14, 9, 11, 32 },
    { 3, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 14, 9, 11, 32 },
    { 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 14, 9, 11, 32 },
    { 3, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 14, 9, 11, 32 },
    { 3, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 14, 9, 11, 32 },
    { 3, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 14, 9, 11, 32 },
    { 3, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 14, 9, 11, 32 },
    { 3, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 14, 9, 11, 32 },
    { 3, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 14, 9, 11, 32 },
    { 5, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 12, 32 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 12, 33 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 11, 6, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 12, 6, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 17, 33 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 17, 2 },
    { 20, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 18, 33 },
    { 25, 10, 0, 2, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 12, 33 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 11, 6, 33 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 12, 6, 33 },
    { 25, 10, 0, 1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 12, 33 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 4, 4, 4, 21, 33 },
    { 10, 18, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 3, 4, 4, 4, 33 },
    { 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 14, 9, 11, 33 },
    { 3, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 14, 9, 11, 33 },
    { 3, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 14, 9, 11, 33 },
    { 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 14, 9, 11, 33 },
    { 3, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 14, 9, 11, 33 },
    { 3, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 14, 9, 11, 33 },
    { 3, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 14, 9, 11, 33 },
    { 3, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 14, 9, 11, 33 },
    { 3, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 14, 9, 11, 33 },
    { 3, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 14, 9, 11, 33 },
    { 18, 0, 0, 2, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 8, 12, 33 },
    { 17, 0, 0, 2, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 8, 12, 33 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 8, 12, 33 },
    { 0, 17, 228, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 4, 4, 4, 21, 33 },
    { 18, 0, 0, 2, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 8, 8, 12, 33 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 8, 8, 12, 47 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 8, 8, 12, 47 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 4, 4, 4, 21, 47 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 7, 4, 4, 21, 47 },
    { 0, 17, 222, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 4, 4, 4, 21, 47 },
    { 0, 17, 230, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 4, 4, 4, 21, 47 },
    { 0, 17, 220, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 4, 4, 4, 21, 47 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 12, 47 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 12, 6, 47 },
    { 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 14, 9, 11, 47 },
    { 3, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 14, 9, 11, 47 },
    { 3, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 14, 9, 11, 47 },
    { 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 14, 9, 11, 47 },
    { 3, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 14, 9, 11, 47 },
    { 3, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 14, 9, 11, 47 },
    { 3, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 14, 9, 11, 47 },
    { 3, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 14, 9, 11, 47 },
    { 3, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 14, 9, 11, 47 },
    { 3, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 14, 9, 11, 47 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 8, 30, 48 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 8, 30, 56 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 8, 30, 56 },
    { 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 14, 9, 11, 56 },
    { 3, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 14, 9, 11, 56 },
    { 3, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 14, 9, 11, 56 },
    { 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 14, 9, 11, 56 },
    { 3, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 14, 9, 11, 56 },
    { 3, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 14, 9, 11, 56 },
    { 3, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 14, 9, 11, 56 },
    { 3, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 14, 9, 11, 56 },
    { 3, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 14, 9, 11, 56 },
    { 3, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 14, 9, 11, 56 },
    { 5, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 30, 56 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 30, 56 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 12, 32 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 8, 8, 12, 55 },
    { 0, 17, 230, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 4, 4, 4, 21, 55 },
    { 0, 17, 220, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 4, 4, 4, 21, 55 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 7, 4, 4, 21, 55 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 4, 4, 4, 21, 55 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 12, 55 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 8, 30, 78 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 7, 4, 4, 30, 78 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 4, 4, 4, 30, 78 },
    { 0, 17, 9, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 4, 4, 4, 30, 78 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 4, 4, 30, 78 },
    { 0, 17, 230, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 4, 4, 4, 30, 78 },
    { 0, 17, 220, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 4, 4, 4, 21, 78 },
    { 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 14, 9, 11, 78 },
    { 3, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 14, 9, 11, 78 },
    { 3, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 14, 9, 11, 78 },
    { 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 14, 9, 11, 78 },
    { 3, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 14, 9, 11, 78 },
    { 3, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 14, 9, 11, 78 },
    { 3, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 14, 9, 11, 78 },
    { 3, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 14, 9, 11, 78 },
    { 3, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 14, 9, 11, 78 },
    { 3, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 14, 9, 11, 78 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 30, 78 },
    { 17, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 8, 30, 78 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 12, 30, 78 },
    { 0, 17, 230, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 4, 4, 4, 21, 1 },
    { 0, 17, 220, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 4, 4, 4, 21, 1 },
    { 2, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 4, 4, 4, 21, 1 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 4, 4, 4, 21, 62 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 7, 4, 4, 21, 62 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 8, 8, 12, 62 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 17, 0, 8, 8, 12, 62 },
    { 0, 17, 7, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 4, 4, 4, 21, 62 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 204, 7, 4, 4, 21, 62 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 17, 7, 4, 4, 21, 62 },
    { 1, 0, 9, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 7, 4, 4, 21, 62 },
    { 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 14, 9, 11, 62 },
    { 3, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 14, 9, 11, 62 },
    { 3, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 14, 9, 11, 62 },
    { 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 14, 9, 11, 62 },
    { 3, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 14, 9, 11, 62 },
    { 3, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 14, 9, 11, 62 },
    { 3, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 14, 9, 11, 62 },
    { 3, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 14, 9, 11, 62 },
    { 3, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 14, 9, 11, 62 },
    { 3, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 14, 9, 11, 62 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 12, 17, 62 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 12, 62 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 17, 62 },
    { 29, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 12, 62 },
    { 0, 17, 230, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 4, 4, 4, 21, 62 },
    { 0, 17, 220, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 4, 4, 4, 21, 62 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 4, 4, 4, 21, 67 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 7, 4, 4, 21, 67 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 8, 8, 12, 67 },
    { 1, 0, 9, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 7, 4, 4, 21, 67 },
    { 0, 17, 9, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 4, 4, 4, 21, 67 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 4, 4, 4, 21, 67 },
    { 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 67 },
    { 3, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 67 },
    { 3, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 67 },
    { 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 67 },
    { 3, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 67 },
    { 3, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 67 },
    { 3, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 67 },
    { 3, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 67 },
    { 3, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 67 },
    { 3, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 67 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 8, 8, 12, 67 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 8, 8, 12, 93 },
    { 0, 17, 7, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 4, 4, 4, 21, 93 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 7, 4, 4, 21, 93 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 4, 4, 4, 21, 93 },
    { 1, 0, 9, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 7, 4, 4, 21, 93 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 12, 93 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 8, 8, 12, 68 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 7, 4, 4, 21, 68 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 4, 4, 4, 21, 68 },
    { 0, 17, 7, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 4, 4, 4, 21, 68 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 12, 17, 68 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 17, 68 },
    { 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 68 },
    { 3, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 68 },
    { 3, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 68 },
    { 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 68 },
    { 3, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 68 },
    { 3, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 68 },
    { 3, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 68 },
    { 3, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 68 },
    { 3, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 68 },
    { 3, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 68 },
    { 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 69 },
    { 3, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 69 },
    { 3, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 69 },
    { 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 69 },
    { 3, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 69 },
    { 3, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 69 },
    { 3, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 69 },
    { 3, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 69 },
    { 3, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 69 },
    { 3, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 69 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 8, 8, 12, 69 },
    { 17, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 8, 8, 12, 69 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 12, 17, 69 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 0, 0, 12, 67 },
    { 0, 17, 230, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 4, 4, 4, 21, 1 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 12, 2 },
    { 0, 17, 1, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 4, 4, 4, 21, 1 },
    { 0, 17, 220, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 4, 4, 4, 21, 1 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 7, 4, 4, 21, 2 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 8, 8, 12, 2 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 7, 4, 4, 21, 2 },
    { 0, 17, 230, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 4, 4, 4, 21, 1 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 8, 8, 12, 2 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 8, 6, 12, 5 },
    { 17, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 80, 0, 8, 6, 12, 3 },
    { 17, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 8, 6, 12, 3 },
    { 17, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 80, 0, 8, 6, 12, 4 },
    { 17, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 80, 0, 8, 6, 12, 5 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 197, 1, 197, 0, 0, 8, 0, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, 3814, 0, 3814, 0, 0, 8, 0, 0, 8, 6, 12, 3 },
    { 17, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 80, 0, 8, 6, 12, 3 },
    { 17, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 80, 0, 8, 6, 12, 4 },
    { 0, 17, 230, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 4, 4, 4, 21, 1 },
    { 0, 17, 220, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 4, 4, 4, 21, 1 },
    { 0, 17, 230, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 4, 4, 4, 21, 1 },
    { 0, 17, 234, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 4, 4, 4, 21, 1 },
    { 0, 17, 214, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 4, 4, 4, 21, 1 },
    { 0, 17, 220, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 4, 4, 4, 21, 1 },
    { 0, 17, 202, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 4, 4, 4, 21, 1 },
    { 0, 17, 233, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 4, 4, 4, 21, 1 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 500, 1, 500, 0, 0, 1, 17, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 503, 1, 503, 0, 0, 1, 17, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 506, 1, 506, 0, 0, 1, 17, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 509, 1, 509, 0, 0, 1, 17, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 512, 1, 512, 0, 0, 1, 80, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -59, 0, -59, 0, -58, 2, 81, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 8, 6, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 0, -7615, 0, 0, 0, 0, 0, -7615, 10, 0, 0, 8, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 10, 0, 0, 8, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -1, 0, -1, 0, 0, 10, 0, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, 8, 0, 8, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 0, -8, 0, 0, 0, 0, 0, -8, 1, 17, 0, 8, 7, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 515, 1, 515, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 518, 1, 518, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 522, 1, 522, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 526, 1, 526, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, 74, 0, 74, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, 74, 0, 74, 0, 0, 1, 85, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, 86, 0, 86, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, 86, 0, 86, 0, 0, 1, 85, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, 100, 0, 100, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, 100, 0, 100, 0, 0, 1, 85, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, 128, 0, 128, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, 128, 0, 128, 0, 0, 1, 85, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, 112, 0, 112, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, 112, 0, 112, 0, 0, 1, 85, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, 126, 0, 126, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, 126, 0, 126, 0, 0, 1, 85, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 564, 0, 8, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 567, 0, 8, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 570, 0, 8, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 573, 0, 8, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 576, 0, 8, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 579, 0, 8, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 582, 0, 8, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 585, 0, 8, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 16, 0, 0, 0, -1, 0, 0, -8, 1, 564, 0, 0, 0, -8, 1, 17, 0, 8, 7, 12, 4 },
    { 16, 0, 0, 0, -1, 0, 0, -8, 1, 567, 0, 0, 0, -8, 1, 17, 0, 8, 7, 12, 4 },
    { 16, 0, 0, 0, -1, 0, 0, -8, 1, 570, 0, 0, 0, -8, 1, 17, 0, 8, 7, 12, 4 },
    { 16, 0, 0, 0, -1, 0, 0, -8, 1, 573, 0, 0, 0, -8, 1, 17, 0, 8, 7, 12, 4 },
    { 16, 0, 0, 0, -1, 0, 0, -8, 1, 576, 0, 0, 0, -8, 1, 17, 0, 8, 7, 12, 4 },
    { 16, 0, 0, 0, -1, 0, 0, -8, 1, 579, 0, 0, 0, -8, 1, 17, 0, 8, 7, 12, 4 },
    { 16, 0, 0, 0, -1, 0, 0, -8, 1, 582, 0, 0, 0, -8, 1, 17, 0, 8, 7, 12, 4 },
    { 16, 0, 0, 0, -1, 0, 0, -8, 1, 585, 0, 0, 0, -8, 1, 17, 0, 8, 7, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 588, 0, 8, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 591, 0, 8, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 594, 0, 8, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 597, 0, 8, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 600, 0, 8, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 603, 0, 8, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 606, 0, 8, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 609, 0, 8, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 16, 0, 0, 0, -1, 0, 0, -8, 1, 588, 0, 0, 0, -8, 1, 17, 0, 8, 7, 12, 4 },
    { 16, 0, 0, 0, -1, 0, 0, -8, 1, 591, 0, 0, 0, -8, 1, 17, 0, 8, 7, 12, 4 },
    { 16, 0, 0, 0, -1, 0, 0, -8, 1, 594, 0, 0, 0, -8, 1, 17, 0, 8, 7, 12, 4 },
    { 16, 0, 0, 0, -1, 0, 0, -8, 1, 597, 0, 0, 0, -8, 1, 17, 0, 8, 7, 12, 4 },
    { 16, 0, 0, 0, -1, 0, 0, -8, 1, 600, 0, 0, 0, -8, 1, 17, 0, 8, 7, 12, 4 },
    { 16, 0, 0, 0, -1, 0, 0, -8, 1, 603, 0, 0, 0, -8, 1, 17, 0, 8, 7, 12, 4 },
    { 16, 0, 0, 0, -1, 0, 0, -8, 1, 606, 0, 0, 0, -8, 1, 17, 0, 8, 7, 12, 4 },
    { 16, 0, 0, 0, -1, 0, 0, -8, 1, 609, 0, 0, 0, -8, 1, 17, 0, 8, 7, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 612, 0, 8, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 615, 0, 8, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 618, 0, 8, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 621, 0, 8, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 624, 0, 8, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 627, 0, 8, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 630, 0, 8, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 633, 0, 8, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 16, 0, 0, 0, -1, 0, 0, -8, 1, 612, 0, 0, 0, -8, 1, 17, 0, 8, 7, 12, 4 },
    { 16, 0, 0, 0, -1, 0, 0, -8, 1, 615, 0, 0, 0, -8, 1, 17, 0, 8, 7, 12, 4 },
    { 16, 0, 0, 0, -1, 0, 0, -8, 1, 618, 0, 0, 0, -8, 1, 17, 0, 8, 7, 12, 4 },
    { 16, 0, 0, 0, -1, 0, 0, -8, 1, 621, 0, 0, 0, -8, 1, 17, 0, 8, 7, 12, 4 },
    { 16, 0, 0, 0, -1, 0, 0, -8, 1, 624, 0, 0, 0, -8, 1, 17, 0, 8, 7, 12, 4 },
    { 16, 0, 0, 0, -1, 0, 0, -8, 1, 627, 0, 0, 0, -8, 1, 17, 0, 8, 7, 12, 4 },
    { 16, 0, 0, 0, -1, 0, 0, -8, 1, 630, 0, 0, 0, -8, 1, 17, 0, 8, 7, 12, 4 },
    { 16, 0, 0, 0, -1, 0, 0, -8, 1, 633, 0, 0, 0, -8, 1, 17, 0, 8, 7, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 648, 1, 645, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 636, 0, 9, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 654, 1, 651, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 530, 1, 530, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 685, 1, 681, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 0, -74, 0, 0, 0, 0, 0, -74, 1, 17, 0, 8, 7, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 0, -74, 0, 0, 0, 0, 0, -74, 1, 85, 0, 8, 7, 12, 4 },
    { 16, 0, 0, 0, -1, 0, 0, -9, 1, 636, 0, 0, 0, -9, 1, 17, 0, 8, 7, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -7205, 0, -7205, 0, -7173, 1, 85, 0, 8, 6, 12, 4 },
    { 28, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 81, 0, 0, 0, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 660, 1, 657, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 639, 0, 9, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 666, 1, 663, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 533, 1, 533, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 693, 1, 689, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 0, -86, 0, 0, 0, 0, 0, -86, 1, 17, 0, 8, 7, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 0, -86, 0, 0, 0, 0, 0, -86, 1, 85, 0, 8, 7, 12, 4 },
    { 16, 0, 0, 0, -1, 0, 0, -9, 1, 639, 0, 0, 0, -9, 1, 17, 0, 8, 7, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 536, 1, 536, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 489, 1, 489, 0, 0, 1, 85, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 540, 1, 540, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 543, 1, 543, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 0, -100, 0, 0, 0, 0, 0, -100, 1, 17, 0, 8, 7, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 0, -100, 0, 0, 0, 0, 0, -100, 1, 85, 0, 8, 7, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 547, 1, 547, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 493, 1, 493, 0, 0, 1, 85, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 551, 1, 551, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, 7, 0, 7, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 554, 1, 554, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 557, 1, 557, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 0, -112, 0, 0, 0, 0, 0, -112, 1, 17, 0, 8, 7, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 0, -112, 0, 0, 0, 0, 0, -112, 1, 85, 0, 8, 7, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 0, -7, 0, 0, 0, 0, 0, -7, 1, 17, 0, 8, 7, 12, 4 },
    { 28, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 85, 0, 0, 0, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 672, 1, 669, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 642, 0, 9, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 678, 1, 675, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 561, 1, 561, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 701, 1, 697, 0, 0, 1, 17, 0, 8, 6, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 0, -128, 0, 0, 0, 0, 0, -128, 1, 17, 0, 8, 7, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 0, -128, 0, 0, 0, 0, 0, -128, 1, 85, 0, 8, 7, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 0, -126, 0, 0, 0, 0, 0, -126, 1, 17, 0, 8, 7, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 0, -126, 0, 0, 0, 0, 0, -126, 1, 85, 0, 8, 7, 12, 4 },
    { 16, 0, 0, 0, -1, 0, 0, -9, 1, 642, 0, 0, 0, -9, 1, 17, 0, 8, 7, 12, 4 },
    { 28, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 85, 0, 0, 0, 18, 4 },
    { 6, 9, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 85, 0, 0, 5, 17, 2 },
    { 6, 9, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 5, 17, 2 },
    { 6, 9, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 5, 4, 2 },
    { 10, 18, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 3, 0, 4, 20, 2 },
    { 10, 18, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 1 },
    { 10, 18, 0, 1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 1 },
    { 10, 0, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 3, 4, 4, 21, 2 },
    { 10, 1, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 3, 4, 4, 21, 2 },
    { 20, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 17, 2 },
    { 20, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 4, 2 },
    { 20, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 11, 17, 2 },
    { 20, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 11, 19, 2 },
    { 20, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 12, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 23, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 11, 13, 3, 2 },
    { 24, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 11, 13, 3, 2 },
    { 21, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 13, 0, 2 },
    { 23, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 13, 3, 2 },
    { 24, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 13, 3, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 11, 10, 15, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 15, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 12, 0, 17, 2 },
    { 7, 9, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 3, 3, 3, 35, 2 },
    { 8, 7, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 3, 3, 3, 35, 2 },
    { 10, 11, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 3, 4, 4, 21, 2 },
    { 10, 14, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 3, 4, 4, 21, 2 },
    { 10, 16, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 3, 4, 4, 21, 2 },
    { 10, 12, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 3, 4, 4, 21, 2 },
    { 10, 15, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 3, 4, 4, 21, 2 },
    { 6, 6, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 80, 0, 0, 5, 4, 2 },
    { 25, 4, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 10, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 10, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 10, 2 },
    { 23, 10, 0, 0, -1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 13, 3, 2 },
    { 24, 10, 0, 0, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 13, 3, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 12, 5, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 12, 5, 2 },
    { 26, 6, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 13, 0, 8, 2 },
    { 22, 10, 0, 0, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 13, 1, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 80, 0, 0, 12, 5, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 80, 0, 0, 12, 5, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 12, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 12, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 12, 2 },
    { 19, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 15, 0, 12, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 12, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 17, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 80, 0, 0, 0, 12, 2 },
    { 6, 9, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 80, 0, 0, 5, 17, 2 },
    { 10, 18, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 3, 4, 4, 22, 2 },
    { 10, 18, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 3, 4, 4, 12, 2 },
    { 10, 18, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 3, 4, 4, 12, 2 },
    { 13, 18, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 12, 0 },
    { 10, 19, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 0, 3, 4, 4, 21, 2 },
    { 10, 20, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 0, 3, 4, 4, 21, 2 },
    { 10, 21, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 0, 3, 4, 4, 21, 2 },
    { 10, 22, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 0, 3, 4, 4, 21, 2 },
    { 10, 18, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 3, 4, 4, 21, 2 },
    { 5, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 17, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 80, 0, 8, 6, 12, 3 },
    { 5, 2, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 5, 2, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 5, 2, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 5, 2, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 5, 2, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 5, 2, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 26, 3, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 21, 10, 0, 0, -1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 13, 0, 2 },
    { 22, 10, 0, 0, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 13, 1, 2 },
    { 17, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 80, 0, 8, 6, 12, 3 },
    { 27, 4, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 9, 2 },
    { 27, 4, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 9, 2 },
    { 27, 4, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 9, 2 },
    { 27, 4, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 9, 2 },
    { 27, 4, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 9, 2 },
    { 27, 4, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 9, 2 },
    { 27, 4, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 10, 2 },
    { 27, 4, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 9, 2 },
    { 27, 4, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 9, 2 },
    { 27, 4, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 0, 0, 0, 0, 9, 2 },
    { 27, 4, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 10, 2 },
    { 27, 4, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 9, 2 },
    { 27, 4, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 0, 10, 2 },
    { 13, 4, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0 },
    { 2, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 1 },
    { 2, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 4, 4, 4, 21, 1 },
    { 2, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 4, 4, 4, 21, 1 },
    { 0, 17, 1, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 4, 4, 4, 21, 1 },
    { 0, 17, 220, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 4, 4, 4, 21, 1 },
    { 0, 17, 1, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 4, 4, 4, 21, 1 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 14, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 8, 7, 12, 2 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 10, 2 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 8, 6, 12, 2 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 9, 2 },
    { 14, 0, 0, 0, -1, 0, 0, -7517, 0, 0, 0, 0, 0, -7517, 1, 85, 0, 8, 7, 12, 4 },
    { 14, 0, 0, 0, -1, 0, 1, 199, 0, 0, 0, 0, 1, 199, 1, 85, 0, 8, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 201, 0, 0, 0, 0, 1, 201, 1, 85, 0, 8, 7, 12, 3 },
    { 29, 4, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 12, 2 },
    { 14, 0, 0, 0, -1, 0, 0, 28, 0, 0, 0, 0, 0, 28, 1, 0, 0, 8, 7, 12, 3 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 8, 8, 12, 2 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 80, 0, 8, 6, 12, 2 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 12, 2 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 80, 0, 0, 0, 12, 2 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 80, 0, 8, 6, 12, 2 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 80, 0, 8, 6, 12, 2 },
    { 14, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 80, 0, 8, 7, 12, 2 },
    { 26, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 80, 0, 0, 0, 12, 2 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 12, 2 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 12, 2 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 12, 2 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -28, 0, -28, 0, 0, 9, 0, 0, 8, 6, 12, 3 },
    { 29, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 80, 0, 0, 0, 12, 2 },
    { 4, 0, 0, 0, -1, 0, 0, 16, 0, 0, 0, 0, 0, 16, 1, 80, 0, 8, 7, 12, 3 },
    { 4, 0, 0, 0, -1, 0, 0, 0, 0, -16, 0, -16, 0, 0, 1, 80, 0, 8, 6, 12, 3 },
    { 4, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 8, 8, 12, 3 },
    { 4, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 8, 8, 12, 3 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 17, 0, 0, 0, 12, 2 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 17, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 3, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 3, 0, 0, 0, 0, 0, 0, 0, 0, 1, 17, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, -3, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, -3, 0, 0, 0, 0, 0, 0, 0, 0, 1, 17, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 2016, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 138, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 17, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 17, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 1824, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 2104, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 2108, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 2106, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, -138, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 15, 2 },
    { 26, 10, 0, 0, -1, 8, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 7, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, -8, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, -7, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 12, 2 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 14, 2 },
    { 21, 10, 0, 0, -1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 85, 0, 0, 13, 0, 2 },
    { 22, 10, 0, 0, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 85, 0, 0, 13, 1, 2 },
    { 29, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 12, 2 },
    { 29, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 12, 2 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 12, 2 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 12, 2 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 12, 2 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 14, 2 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 5, 2, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 29, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 29, 0, 0, 0, -1, 0, 0, 26, 0, 0, 0, 0, 0, 26, 1, 80, 0, 8, 7, 12, 2 },
    { 29, 0, 0, 0, -1, 0, 0, 0, 0, -26, 0, -26, 0, 0, 1, 80, 0, 8, 6, 12, 2 },
    { 5, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 12, 2 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 14, 2 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 14, 2 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 12, 2 },
    { 29, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 12, 2 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 14, 2 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 14, 2 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 14, 2 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 13, 3, 2 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 13, 3, 2 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 6, 2 },
    { 21, 10, 0, 0, -1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 13, 0, 2 },
    { 22, 10, 0, 0, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 13, 1, 2 },
    { 5, 10, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 12, 2 },
    { 21, 10, 0, 0, -1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 13, 0, 2 },
    { 22, 10, 0, 0, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 13, 1, 2 },
    { 26, 10, 0, 0, -1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, -2, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 12, 2 },
    { 21, 10, 0, 0, -1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 13, 0, 2 },
    { 22, 10, 0, 0, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 13, 1, 2 },
    { 29, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 12, 54 },
    { 21, 10, 0, 0, -1, 3, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 13, 0, 2 },
    { 22, 10, 0, 0, -1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 13, 1, 2 },
    { 21, 10, 0, 0, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 13, 0, 2 },
    { 22, 10, 0, 0, -1, -3, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 13, 1, 2 },
    { 26, 10, 0, 0, -1, -1824, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, -2016, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 85, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, -2104, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, -2106, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, -2108, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 12, 2 },
    { 14, 0, 0, 0, -1, 0, 0, 48, 0, 0, 0, 0, 0, 48, 8, 0, 0, 8, 7, 12, 57 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -48, 0, -48, 0, 0, 8, 0, 0, 8, 6, 12, 57 },
    { 14, 0, 0, 0, -1, 0, 1, 203, 0, 0, 0, 0, 1, 203, 9, 0, 0, 8, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 0, -3814, 0, 0, 0, 0, 0, -3814, 9, 0, 0, 8, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 205, 0, 0, 0, 0, 1, 205, 9, 0, 0, 8, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 207, 1, 207, 0, 0, 9, 0, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 209, 1, 209, 0, 0, 9, 0, 0, 8, 6, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 211, 0, 0, 0, 0, 1, 211, 10, 0, 0, 8, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 213, 0, 0, 0, 0, 1, 213, 10, 0, 0, 8, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 215, 0, 0, 0, 0, 1, 215, 10, 0, 0, 8, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 217, 0, 0, 0, 0, 1, 217, 11, 0, 0, 8, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 8, 6, 12, 3 },
    { 17, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 80, 0, 8, 6, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 219, 0, 0, 0, 0, 1, 219, 11, 0, 0, 8, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 221, 0, 0, 0, 0, 1, 221, 11, 0, 0, 8, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 8, 0, 0, 8, 7, 12, 46 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -1, 0, -1, 0, 0, 8, 0, 0, 8, 6, 12, 46 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 8, 6, 12, 46 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 12, 46 },
    { 14, 0, 0, 0, -1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 11, 0, 0, 8, 7, 12, 46 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -1, 0, -1, 0, 0, 11, 0, 0, 8, 6, 12, 46 },
    { 0, 17, 230, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 4, 4, 4, 21, 46 },
    { 14, 0, 0, 0, -1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 13, 0, 0, 8, 7, 12, 46 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -1, 0, -1, 0, 0, 13, 0, 0, 8, 6, 12, 46 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 6, 46 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 17, 46 },
    { 5, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 12, 46 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -7264, 0, -7264, 0, 0, 8, 0, 0, 8, 6, 12, 25 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -7264, 0, -7264, 0, 0, 13, 0, 0, 8, 6, 12, 25 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 8, 8, 12, 58 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 8, 8, 12, 58 },
    { 17, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 80, 0, 8, 8, 12, 58 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 17, 58 },
    { 0, 17, 9, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 4, 4, 4, 21, 58 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 13, 3, 2 },
    { 23, 10, 0, 0, -1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 13, 3, 2 },
    { 24, 10, 0, 0, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 13, 3, 2 },
    { 20, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 17, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 0, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 17, 2 },
    { 20, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 12, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 12, 2 },
    { 23, 10, 0, 0, -1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 13, 3, 2 },
    { 24, 10, 0, 0, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 13, 3, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 12, 6, 2 },
    { 17, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 8, 8, 12, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 17, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 0, 0, 12, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 0, 0, 17, 2 },
    { 20, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 0, 0, 19, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 12, 17, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 17, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 12, 2 },
    { 20, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 17, 2 },
    { 21, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 13, 0, 2 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 14, 37 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 80, 0, 0, 0, 14, 37 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 14, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 11, 1, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 12, 1, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 14, 2 },
    { 17, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 8, 8, 5, 37 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 8, 14, 2 },
    { 4, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 8, 14, 37 },
    { 20, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 5, 2 },
    { 22, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 13, 1, 2 },
    { 0, 17, 218, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 1 },
    { 0, 17, 228, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 1 },
    { 0, 17, 222, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 1 },
    { 1, 0, 224, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 26 },
    { 20, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 14, 2 },
    { 17, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 6, 8, 14, 2 },
    { 17, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 6, 8, 21, 2 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 14, 2 },
    { 4, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 80, 0, 0, 8, 14, 37 },
    { 17, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 8, 8, 5, 37 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 8, 8, 5, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 14, 2 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 8, 5, 34 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 8, 14, 34 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 17, 0, 0, 8, 14, 34 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 8, 5, 34 },
    { 0, 17, 8, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 204, 4, 4, 4, 21, 1 },
    { 28, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 6, 0, 5, 2 },
    { 17, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 8, 5, 34 },
    { 17, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 17, 0, 0, 8, 5, 34 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 80, 0, 0, 8, 14, 34 },
    { 20, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 6, 0, 5, 2 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 6, 8, 5, 35 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 6, 8, 14, 35 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 17, 0, 6, 8, 14, 35 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 5, 2 },
    { 17, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 6, 8, 5, 2 },
    { 17, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 6, 8, 5, 35 },
    { 17, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 17, 0, 6, 8, 5, 35 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 80, 0, 6, 8, 14, 35 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 8, 8, 14, 36 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 8, 8, 14, 36 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 8, 8, 14, 26 },
    { 29, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 14, 2 },
    { 5, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 14, 2 },
    { 29, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 14, 2 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 8, 14, 36 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 8, 8, 14, 36 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 6, 8, 5, 35 },
    { 29, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 14, 26 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 80, 0, 0, 0, 14, 26 },
    { 29, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 80, 0, 0, 0, 14, 2 },
    { 5, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 12, 2 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 80, 0, 0, 0, 14, 2 },
    { 5, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 80, 0, 0, 0, 14, 2 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 80, 0, 0, 0, 14, 26 },
    { 29, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 6, 0, 14, 35 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 8, 14, 37 },
    { 13, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 0 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 8, 14, 37 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 8, 14, 37 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 8, 14, 37 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 8, 14, 37 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 0, 8, 14, 37 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 8, 14, 37 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 8, 14, 38 },
    { 17, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 8, 5, 38 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 14, 38 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 14, 38 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 8, 8, 12, 83 },
    { 17, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 8, 8, 12, 83 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 17, 83 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 12, 17, 83 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 8, 8, 12, 70 },
    { 17, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 8, 8, 12, 70 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 17, 70 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 12, 6, 70 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 12, 17, 70 },
    { 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 70 },
    { 3, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 70 },
    { 3, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 70 },
    { 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 70 },
    { 3, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 70 },
    { 3, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 70 },
    { 3, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 70 },
    { 3, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 70 },
    { 3, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 70 },
    { 3, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 70 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 8, 8, 12, 5 },
    { 2, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 4, 4, 4, 21, 5 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 12, 5 },
    { 0, 17, 230, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 4, 4, 4, 21, 5 },
    { 17, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 8, 8, 12, 5 },
    { 17, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 80, 0, 8, 6, 12, 5 },
    { 0, 17, 230, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 4, 4, 4, 21, 5 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 8, 8, 12, 84 },
    { 4, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 8, 8, 12, 84 },
    { 0, 17, 230, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 4, 4, 4, 21, 84 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 12, 84 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 12, 17, 84 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 17, 84 },
    { 28, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 12, 2 },
    { 17, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 8, 8, 12, 2 },
    { 28, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 12, 2 },
    { 14, 0, 0, 0, -1, 0, 1, 223, 0, 0, 0, 0, 1, 223, 10, 0, 0, 8, 7, 12, 3 },
    { 28, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 12, 2 },
    { 14, 0, 0, 0, -1, 0, 1, 225, 0, 0, 0, 0, 1, 225, 12, 0, 0, 8, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 8, 6, 12, 3 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 8, 8, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 12, 0, 0, 8, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -1, 0, -1, 0, 0, 12, 0, 0, 8, 6, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 13, 0, 0, 8, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -1, 0, -1, 0, 0, 13, 0, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 8, 6, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 16, 0, 0, 8, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -1, 0, -1, 0, 0, 16, 0, 0, 8, 6, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 227, 0, 0, 0, 0, 1, 227, 13, 0, 0, 8, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 229, 0, 0, 0, 0, 1, 229, 16, 0, 0, 8, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 231, 0, 0, 0, 0, 1, 231, 16, 0, 0, 8, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 233, 0, 0, 0, 0, 1, 233, 16, 0, 0, 8, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 235, 0, 0, 0, 0, 1, 235, 16, 0, 0, 8, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 237, 0, 0, 0, 0, 1, 237, 16, 0, 0, 8, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 1, 239, 0, 0, 0, 0, 1, 239, 17, 0, 0, 8, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 0, 928, 0, 0, 0, 0, 0, 928, 17, 0, 0, 8, 7, 12, 3 },
    { 14, 0, 0, 0, -1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 17, 0, 0, 8, 7, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -1, 0, -1, 0, 0, 17, 0, 0, 8, 6, 12, 3 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 8, 8, 12, 3 },
    { 17, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 80, 0, 8, 6, 12, 3 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 8, 8, 12, 3 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 8, 8, 12, 59 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 4, 4, 4, 21, 59 },
    { 0, 17, 9, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 4, 4, 4, 21, 59 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 7, 4, 4, 21, 59 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 12, 59 },
    { 29, 4, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 12, 2 },
    { 18, 0, 0, 2, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 8, 8, 12, 65 },
    { 18, 0, 0, 4, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 8, 8, 12, 65 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 8, 8, 12, 65 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 18, 65 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 12, 6, 65 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 7, 4, 4, 21, 71 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 8, 8, 12, 71 },
    { 0, 17, 9, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 4, 4, 4, 21, 71 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 12, 17, 71 },
    { 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 71 },
    { 3, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 71 },
    { 3, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 71 },
    { 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 71 },
    { 3, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 71 },
    { 3, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 71 },
    { 3, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 71 },
    { 3, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 71 },
    { 3, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 71 },
    { 3, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 71 },
    { 0, 17, 230, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 4, 4, 4, 21, 11 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 12, 11 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 0, 18, 11 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 8, 8, 12, 11 },
    { 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 72 },
    { 3, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 72 },
    { 3, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 72 },
    { 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 72 },
    { 3, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 72 },
    { 3, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 72 },
    { 3, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 72 },
    { 3, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 72 },
    { 3, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 72 },
    { 3, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 72 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 8, 8, 12, 72 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 4, 4, 4, 21, 72 },
    { 0, 17, 220, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 4, 4, 4, 21, 72 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 17, 2 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 12, 17, 72 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 8, 8, 12, 73 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 4, 4, 4, 21, 73 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 7, 4, 4, 21, 73 },
    { 1, 0, 9, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 7, 4, 4, 21, 73 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 12, 73 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 4, 4, 4, 21, 85 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 7, 4, 4, 21, 85 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 8, 8, 12, 85 },
    { 0, 17, 7, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 4, 4, 4, 21, 85 },
    { 1, 0, 9, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 7, 4, 4, 21, 85 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 12, 85 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 17, 85 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 12, 17, 85 },
    { 17, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 8, 8, 12, 2 },
    { 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 14, 9, 11, 85 },
    { 3, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 14, 9, 11, 85 },
    { 3, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 14, 9, 11, 85 },
    { 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 14, 9, 11, 85 },
    { 3, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 14, 9, 11, 85 },
    { 3, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 14, 9, 11, 85 },
    { 3, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 14, 9, 11, 85 },
    { 3, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 14, 9, 11, 85 },
    { 3, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 14, 9, 11, 85 },
    { 3, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 14, 9, 11, 85 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 8, 30, 24 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 4, 4, 4, 30, 24 },
    { 17, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 8, 30, 24 },
    { 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 24 },
    { 3, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 24 },
    { 3, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 24 },
    { 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 24 },
    { 3, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 24 },
    { 3, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 24 },
    { 3, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 24 },
    { 3, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 24 },
    { 3, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 24 },
    { 3, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 24 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 8, 8, 12, 77 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 4, 4, 4, 21, 77 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 7, 4, 4, 21, 77 },
    { 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 77 },
    { 3, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 77 },
    { 3, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 77 },
    { 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 77 },
    { 3, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 77 },
    { 3, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 77 },
    { 3, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 77 },
    { 3, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 77 },
    { 3, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 77 },
    { 3, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 14, 9, 11, 77 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 12, 77 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 12, 17, 77 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 8, 30, 24 },
    { 17, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 8, 30, 24 },
    { 29, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 30, 24 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 4, 4, 30, 24 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 8, 30, 79 },
    { 0, 17, 230, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 4, 4, 4, 30, 79 },
    { 0, 17, 220, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 4, 4, 4, 30, 79 },
    { 17, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 8, 30, 79 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 30, 79 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 8, 8, 12, 86 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 7, 4, 4, 21, 86 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 4, 4, 4, 21, 86 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 0, 12, 17, 86 },
    { 17, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 8, 8, 12, 86 },
    { 0, 17, 9, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 4, 4, 4, 21, 86 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 8, 8, 12, 27 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -928, 0, -928, 0, 0, 16, 0, 0, 8, 6, 12, 3 },
    { 28, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 12, 2 },
    { 17, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 80, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 8, 6, 12, 4 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 241, 1, 241, 1, 241, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 243, 1, 243, 1, 243, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 245, 1, 245, 1, 245, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 247, 1, 247, 1, 247, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 249, 1, 249, 1, 249, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 251, 1, 251, 1, 251, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 253, 1, 253, 1, 253, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 255, 1, 255, 1, 255, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 257, 1, 257, 1, 257, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 259, 1, 259, 1, 259, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 261, 1, 261, 1, 261, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 263, 1, 263, 1, 263, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 265, 1, 265, 1, 265, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 267, 1, 267, 1, 267, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 269, 1, 269, 1, 269, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 271, 1, 271, 1, 271, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 273, 1, 273, 1, 273, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 275, 1, 275, 1, 275, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 277, 1, 277, 1, 277, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 279, 1, 279, 1, 279, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 281, 1, 281, 1, 281, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 283, 1, 283, 1, 283, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 285, 1, 285, 1, 285, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 287, 1, 287, 1, 287, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 289, 1, 289, 1, 289, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 291, 1, 291, 1, 291, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 293, 1, 293, 1, 293, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 295, 1, 295, 1, 295, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 297, 1, 297, 1, 297, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 299, 1, 299, 1, 299, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 301, 1, 301, 1, 301, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 303, 1, 303, 1, 303, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 305, 1, 305, 1, 305, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 307, 1, 307, 1, 307, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 309, 1, 309, 1, 309, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 311, 1, 311, 1, 311, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 313, 1, 313, 1, 313, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 315, 1, 315, 1, 315, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 317, 1, 317, 1, 317, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 319, 1, 319, 1, 319, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 321, 1, 321, 1, 321, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 323, 1, 323, 1, 323, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 325, 1, 325, 1, 325, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 327, 1, 327, 1, 327, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 329, 1, 329, 1, 329, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 331, 1, 331, 1, 331, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 333, 1, 333, 1, 333, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 335, 1, 335, 1, 335, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 337, 1, 337, 1, 337, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 339, 1, 339, 1, 339, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 341, 1, 341, 1, 341, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 343, 1, 343, 1, 343, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 345, 1, 345, 1, 345, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 347, 1, 347, 1, 347, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 349, 1, 349, 1, 349, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 351, 1, 351, 1, 351, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 353, 1, 353, 1, 353, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 355, 1, 355, 1, 355, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 357, 1, 357, 1, 357, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 359, 1, 359, 1, 359, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 361, 1, 361, 1, 361, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 363, 1, 363, 1, 363, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 365, 1, 365, 1, 365, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 367, 1, 367, 1, 367, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 369, 1, 369, 1, 369, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 371, 1, 371, 1, 371, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 373, 1, 373, 1, 373, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 375, 1, 375, 1, 375, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 377, 1, 377, 1, 377, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 379, 1, 379, 1, 379, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 381, 1, 381, 1, 381, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 383, 1, 383, 1, 383, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 385, 1, 385, 1, 385, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 387, 1, 387, 1, 387, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 389, 1, 389, 1, 389, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 391, 1, 391, 1, 391, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 393, 1, 393, 1, 393, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 395, 1, 395, 1, 395, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 397, 1, 397, 1, 397, 17, 0, 0, 8, 6, 12, 28 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 399, 1, 399, 1, 399, 17, 0, 0, 8, 6, 12, 28 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 8, 8, 12, 86 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 7, 4, 4, 21, 86 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 4, 4, 4, 21, 86 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 12, 17, 86 },
    { 0, 17, 9, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 4, 4, 4, 21, 86 },
    { 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 14, 9, 11, 86 },
    { 3, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 14, 9, 11, 86 },
    { 3, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 14, 9, 11, 86 },
    { 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 14, 9, 11, 86 },
    { 3, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 14, 9, 11, 86 },
    { 3, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 14, 9, 11, 86 },
    { 3, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 14, 9, 11, 86 },
    { 3, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 14, 9, 11, 86 },
    { 3, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 14, 9, 11, 86 },
    { 3, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 14, 9, 11, 86 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 17, 11, 8, 8, 23, 26 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 17, 12, 8, 8, 24, 26 },
    { 11, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 3, 0, 0, 31, 0 },
    { 12, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 12, 0 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 85, 0, 0, 8, 14, 37 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 85, 0, 0, 8, 14, 37 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 85, 0, 0, 8, 14, 37 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 85, 0, 0, 8, 14, 37 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 85, 0, 0, 8, 14, 37 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 413, 1, 410, 0, 0, 1, 80, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 419, 1, 416, 0, 0, 1, 80, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 425, 1, 422, 0, 0, 1, 80, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 432, 1, 428, 0, 0, 1, 80, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 440, 1, 436, 0, 0, 1, 80, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 447, 1, 444, 0, 0, 1, 80, 0, 8, 6, 12, 3 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 459, 1, 456, 0, 0, 1, 80, 0, 8, 6, 12, 6 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 465, 1, 462, 0, 0, 1, 80, 0, 8, 6, 12, 6 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 471, 1, 468, 0, 0, 1, 80, 0, 8, 6, 12, 6 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 477, 1, 474, 0, 0, 1, 80, 0, 8, 6, 12, 6 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 1, 483, 1, 480, 0, 0, 1, 80, 0, 8, 6, 12, 6 },
    { 18, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 85, 0, 7, 8, 13, 7 },
    { 0, 17, 26, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 4, 4, 21, 7 },
    { 18, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 85, 0, 7, 8, 13, 7 },
    { 18, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 7, 8, 13, 7 },
    { 26, 3, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 12, 7 },
    { 18, 13, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 8, 8, 12, 8 },
    { 28, 13, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 12, 8 },
    { 13, 18, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 12, 0 },
    { 27, 13, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 80, 0, 0, 0, 10, 8 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 4, 4, 4, 21, 1 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 80, 0, 13, 11, 8, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 80, 0, 0, 11, 1, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 80, 0, 0, 0, 1, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 80, 0, 12, 11, 8, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 80, 0, 13, 0, 8, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 80, 0, 0, 0, 6, 2 },
    { 21, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 80, 0, 0, 13, 0, 2 },
    { 22, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 80, 0, 0, 13, 1, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 80, 0, 0, 0, 15, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 14, 2 },
    { 20, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 11, 14, 2 },
    { 19, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 15, 0, 14, 2 },
    { 21, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 13, 0, 2 },
    { 22, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 13, 1, 2 },
    { 21, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 80, 0, 0, 13, 0, 2 },
    { 22, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 80, 0, 0, 13, 1, 2 },
    { 25, 6, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 13, 11, 1, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 11, 14, 2 },
    { 25, 6, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 11, 10, 1, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 13, 0, 5, 2 },
    { 25, 6, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 12, 11, 5, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 12, 6, 2 },
    { 25, 4, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 14, 2 },
    { 26, 3, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 14, 2 },
    { 20, 3, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 11, 14, 2 },
    { 26, 10, 0, 0, -1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 14, 2 },
    { 26, 10, 0, 0, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 14, 2 },
    { 26, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 14, 2 },
    { 18, 13, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 8, 8, 12, 8 },
    { 10, 18, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 3, 4, 4, 22, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 11, 0, 14, 2 },
    { 25, 6, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 14, 2 },
    { 3, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 14, 2 },
    { 3, 2, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 14, 2 },
    { 3, 2, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 14, 2 },
    { 3, 2, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 14, 2 },
    { 3, 2, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 14, 2 },
    { 3, 2, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 14, 2 },
    { 3, 2, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 14, 2 },
    { 3, 2, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 14, 2 },
    { 3, 2, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 14, 2 },
    { 3, 2, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 14, 2 },
    { 26, 10, 0, 0, -1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 14, 2 },
    { 26, 10, 0, 0, -1, -2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 14, 2 },
    { 14, 0, 0, 0, -1, 0, 0, 32, 0, 0, 0, 0, 0, 32, 1, 80, 0, 8, 7, 14, 3 },
    { 21, 10, 0, 0, -1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 13, 0, 2 },
    { 22, 10, 0, 0, -1, -2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 13, 1, 2 },
    { 28, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 14, 2 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -32, 0, -32, 0, 0, 1, 80, 0, 8, 6, 14, 3 },
    { 21, 10, 0, 0, -1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 6, 80, 0, 0, 13, 0, 2 },
    { 22, 10, 0, 0, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 6, 80, 0, 0, 13, 1, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 12, 1, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 11, 1, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 5, 2 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 6, 8, 12, 35 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 6, 8, 5, 35 },
    { 17, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 6, 8, 5, 2 },
    { 17, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 4, 4, 4, 5, 2 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 8, 8, 12, 26 },
    { 27, 4, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 80, 0, 0, 0, 10, 2 },
    { 10, 10, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 3, 4, 4, 21, 2 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 29, 2 },
    { 13, 18, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 12, 0 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 8, 8, 12, 49 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 17, 2 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 17, 2 },
    { 5, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 12, 2 },
    { 29, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 12, 2 },
    { 4, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 8, 8, 12, 4 },
    { 5, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 12, 4 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 12, 4 },
    { 5, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 12, 4 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 12, 4 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 8, 8, 12, 74 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 8, 8, 12, 75 },
    { 5, 2, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 12, 2 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 8, 8, 12, 39 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 8, 8, 12, 39 },
    { 5, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 12, 39 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 8, 8, 12, 40 },
    { 4, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 8, 8, 12, 40 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 8, 8, 12, 120 },
    { 0, 17, 230, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 4, 4, 4, 21, 120 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 8, 8, 12, 50 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 17, 50 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 8, 8, 12, 60 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 17, 60 },
    { 4, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 8, 8, 12, 60 },
    { 14, 0, 0, 0, -1, 0, 0, 40, 0, 0, 0, 0, 0, 40, 5, 0, 0, 8, 7, 12, 41 },
    { 14, 0, 0, 0, -1, 0, 0, 40, 0, 0, 0, 0, 0, 40, 7, 0, 0, 8, 7, 12, 41 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -40, 0, -40, 0, 0, 5, 0, 0, 8, 6, 12, 41 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -40, 0, -40, 0, 0, 7, 0, 0, 8, 6, 12, 41 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 8, 8, 12, 51 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 8, 8, 12, 52 },
    { 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 14, 9, 11, 52 },
    { 3, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 14, 9, 11, 52 },
    { 3, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 14, 9, 11, 52 },
    { 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 14, 9, 11, 52 },
    { 3, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 14, 9, 11, 52 },
    { 3, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 14, 9, 11, 52 },
    { 3, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 14, 9, 11, 52 },
    { 3, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 14, 9, 11, 52 },
    { 3, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 14, 9, 11, 52 },
    { 3, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 14, 9, 11, 52 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 8, 8, 12, 106 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 8, 8, 12, 103 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 12, 103 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 8, 8, 12, 110 },
    { 18, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 8, 8, 12, 53 },
    { 18, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 8, 8, 12, 87 },
    { 25, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 17, 87 },
    { 5, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 12, 87 },
    { 18, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 8, 8, 12, 118 },
    { 29, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 12, 118 },
    { 5, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 12, 118 },
    { 18, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 8, 8, 12, 117 },
    { 5, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 12, 117 },
    { 18, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 8, 8, 12, 128 },
    { 5, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 0, 12, 128 },
    { 18, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 8, 8, 12, 64 },
    { 5, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 12, 64 },
    { 5, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 12, 64 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 17, 64 },
    { 18, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 8, 8, 12, 76 },
    { 25, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 12, 76 },
    { 18, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 8, 8, 12, 98 },
    { 18, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 8, 8, 12, 97 },
    { 5, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 0, 12, 97 },
    { 18, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 8, 8, 12, 61 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 4, 4, 4, 21, 61 },
    { 0, 17, 220, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 4, 4, 4, 21, 61 },
    { 0, 17, 230, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 4, 4, 4, 21, 61 },
    { 0, 17, 1, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 4, 4, 4, 21, 61 },
    { 0, 17, 9, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 4, 4, 4, 21, 61 },
    { 5, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 12, 61 },
    { 5, 1, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 12, 61 },
    { 5, 1, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 12, 61 },
    { 5, 1, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 12, 61 },
    { 5, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 12, 61 },
    { 25, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 17, 61 },
    { 25, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 12, 17, 61 },
    { 25, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 12, 61 },
    { 18, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 8, 8, 12, 88 },
    { 5, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 12, 88 },
    { 25, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 12, 88 },
    { 18, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 8, 8, 12, 116 },
    { 5, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 12, 116 },
    { 18, 1, 0, 2, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 8, 8, 12, 112 },
    { 18, 1, 0, 3, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 8, 8, 12, 112 },
    { 18, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 8, 8, 12, 112 },
    { 29, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 12, 112 },
    { 18, 1, 0, 4, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 8, 8, 12, 112 },
    { 0, 17, 230, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 4, 4, 4, 21, 112 },
    { 0, 17, 220, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 4, 4, 4, 21, 112 },
    { 5, 1, 0, 2, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 12, 112 },
    { 5, 1, 0, 3, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 12, 112 },
    { 25, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 17, 112 },
    { 25, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 15, 112 },
    { 18, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 8, 8, 12, 80 },
    { 25, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 17, 80 },
    { 18, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 8, 8, 12, 89 },
    { 5, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 12, 89 },
    { 18, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 8, 8, 12, 90 },
    { 5, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 12, 90 },
    { 18, 1, 0, 2, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 8, 8, 12, 121 },
    { 18, 1, 0, 3, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 8, 8, 12, 121 },
    { 25, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 12, 121 },
    { 5, 1, 0, 3, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 12, 121 },
    { 5, 1, 0, 2, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 12, 121 },
    { 5, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 12, 121 },
    { 18, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 8, 8, 12, 91 },
    { 14, 1, 0, 0, -1, 0, 0, 64, 0, 0, 0, 0, 0, 64, 17, 0, 0, 8, 7, 12, 130 },
    { 15, 1, 0, 0, -1, 0, 0, 0, 0, -64, 0, -64, 0, 0, 17, 0, 0, 8, 6, 12, 130 },
    { 5, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 0, 12, 130 },
    { 5, 5, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 12, 8 },
    { 5, 5, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 12, 8 },
    { 5, 5, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 12, 8 },
    { 5, 5, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 12, 8 },
    { 5, 5, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 12, 8 },
    { 5, 5, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 12, 8 },
    { 5, 5, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 12, 8 },
    { 5, 5, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 12, 8 },
    { 5, 5, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 12, 8 },
    { 5, 5, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 12, 8 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 7, 4, 4, 21, 94 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 4, 4, 4, 21, 94 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 8, 8, 12, 94 },
    { 0, 17, 9, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 4, 4, 4, 21, 94 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 12, 17, 94 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 12, 94 },
    { 5, 10, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 12, 94 },
    { 5, 10, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 12, 94 },
    { 5, 10, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 12, 94 },
    { 5, 10, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 12, 94 },
    { 5, 10, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 12, 94 },
    { 5, 10, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 12, 94 },
    { 5, 10, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 12, 94 },
    { 5, 10, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 12, 94 },
    { 5, 10, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 12, 94 },
    { 5, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 12, 94 },
    { 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 14, 9, 11, 94 },
    { 3, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 14, 9, 11, 94 },
    { 3, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 14, 9, 11, 94 },
    { 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 14, 9, 11, 94 },
    { 3, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 14, 9, 11, 94 },
    { 3, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 14, 9, 11, 94 },
    { 3, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 14, 9, 11, 94 },
    { 3, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 14, 9, 11, 94 },
    { 3, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 14, 9, 11, 94 },
    { 3, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 14, 9, 11, 94 },
    { 0, 17, 9, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 4, 4, 4, 21, 94 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 4, 4, 4, 21, 92 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 7, 4, 4, 21, 92 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 8, 8, 12, 92 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 17, 0, 8, 8, 12, 92 },
    { 0, 17, 9, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 4, 4, 4, 21, 92 },
    { 0, 17, 7, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 204, 4, 4, 4, 21, 92 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 12, 92 },
    { 10, 0, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 3, 4, 4, 12, 92 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 12, 17, 92 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 8, 8, 12, 101 },
    { 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 14, 9, 11, 101 },
    { 3, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 14, 9, 11, 101 },
    { 3, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 14, 9, 11, 101 },
    { 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 14, 9, 11, 101 },
    { 3, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 14, 9, 11, 101 },
    { 3, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 14, 9, 11, 101 },
    { 3, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 14, 9, 11, 101 },
    { 3, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 14, 9, 11, 101 },
    { 3, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 14, 9, 11, 101 },
    { 3, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 14, 9, 11, 101 },
    { 0, 17, 230, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 4, 4, 4, 21, 96 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 8, 8, 12, 96 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 204, 4, 4, 4, 21, 96 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 4, 4, 4, 21, 96 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 7, 4, 4, 21, 96 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 17, 4, 4, 4, 21, 96 },
    { 0, 17, 9, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 4, 4, 4, 21, 96 },
    { 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 14, 9, 11, 96 },
    { 3, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 14, 9, 11, 96 },
    { 3, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 14, 9, 11, 96 },
    { 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 14, 9, 11, 96 },
    { 3, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 14, 9, 11, 96 },
    { 3, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 14, 9, 11, 96 },
    { 3, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 14, 9, 11, 96 },
    { 3, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 14, 9, 11, 96 },
    { 3, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 14, 9, 11, 96 },
    { 3, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 14, 9, 11, 96 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 0, 0, 17, 96 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 0, 12, 17, 96 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 8, 8, 12, 111 },
    { 0, 17, 7, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 4, 4, 4, 21, 111 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 12, 111 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 18, 111 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 4, 4, 4, 21, 100 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 7, 4, 4, 21, 100 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 8, 8, 12, 100 },
    { 1, 0, 9, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 7, 4, 4, 21, 100 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 0, 12, 17, 100 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 0, 0, 12, 100 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 0, 0, 17, 100 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 0, 12, 100 },
    { 0, 17, 7, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 4, 4, 4, 21, 100 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 4, 4, 4, 21, 100 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 12, 12, 100 },
    { 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 14, 9, 11, 100 },
    { 3, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 14, 9, 11, 100 },
    { 3, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 14, 9, 11, 100 },
    { 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 14, 9, 11, 100 },
    { 3, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 14, 9, 11, 100 },
    { 3, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 14, 9, 11, 100 },
    { 3, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 14, 9, 11, 100 },
    { 3, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 14, 9, 11, 100 },
    { 3, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 14, 9, 11, 100 },
    { 3, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 14, 9, 11, 100 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 8, 8, 12, 100 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 0, 18, 100 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 8, 8, 12, 100 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 0, 17, 100 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 12, 17, 100 },
    { 5, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 12, 20 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 8, 8, 12, 109 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 7, 4, 4, 21, 109 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 4, 4, 4, 21, 109 },
    { 1, 0, 9, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 7, 4, 4, 21, 109 },
    { 0, 17, 7, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 4, 4, 4, 21, 109 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 12, 17, 109 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 12, 109 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 8, 8, 12, 129 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 12, 17, 129 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 8, 8, 12, 123 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 4, 4, 4, 21, 123 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 7, 4, 4, 21, 123 },
    { 0, 17, 7, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 4, 4, 4, 21, 123 },
    { 0, 17, 9, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 4, 4, 4, 21, 123 },
    { 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 123 },
    { 3, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 123 },
    { 3, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 123 },
    { 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 123 },
    { 3, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 123 },
    { 3, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 123 },
    { 3, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 123 },
    { 3, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 123 },
    { 3, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 123 },
    { 3, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 123 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 4, 4, 4, 21, 107 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 4, 4, 4, 21, 107 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 7, 4, 4, 21, 107 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 8, 8, 12, 107 },
    { 0, 17, 7, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 4, 4, 4, 21, 107 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 204, 4, 4, 4, 21, 107 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 17, 7, 4, 4, 21, 107 },
    { 1, 0, 9, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 7, 4, 4, 21, 107 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 8, 8, 12, 107 },
    { 0, 17, 230, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 4, 4, 4, 21, 107 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 8, 8, 12, 124 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 204, 4, 4, 4, 21, 124 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 7, 4, 4, 21, 124 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 4, 4, 4, 21, 124 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 204, 4, 4, 4, 21, 124 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 17, 7, 4, 4, 21, 124 },
    { 0, 17, 9, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 4, 4, 4, 21, 124 },
    { 0, 17, 7, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 4, 4, 4, 21, 124 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 12, 124 },
    { 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 124 },
    { 3, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 124 },
    { 3, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 124 },
    { 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 124 },
    { 3, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 124 },
    { 3, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 124 },
    { 3, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 124 },
    { 3, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 124 },
    { 3, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 124 },
    { 3, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 124 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 8, 8, 12, 122 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 204, 4, 4, 4, 21, 122 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 7, 4, 4, 21, 122 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 4, 4, 4, 21, 122 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 17, 7, 4, 4, 21, 122 },
    { 0, 17, 9, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 4, 4, 4, 21, 122 },
    { 0, 17, 7, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 4, 4, 4, 21, 122 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 18, 122 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 12, 17, 122 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 6, 122 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 12, 122 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 12, 17, 122 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 8, 8, 12, 122 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 4, 4, 4, 21, 122 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 8, 8, 12, 114 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 7, 4, 4, 21, 114 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 4, 4, 4, 21, 114 },
    { 0, 17, 9, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 4, 4, 4, 21, 114 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 12, 17, 114 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 12, 114 },
    { 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 114 },
    { 3, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 114 },
    { 3, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 114 },
    { 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 114 },
    { 3, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 114 },
    { 3, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 114 },
    { 3, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 114 },
    { 3, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 114 },
    { 3, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 114 },
    { 3, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 114 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 8, 8, 12, 102 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 4, 4, 4, 21, 102 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 7, 4, 4, 21, 102 },
    { 1, 0, 9, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 7, 4, 4, 21, 102 },
    { 0, 17, 7, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 4, 4, 4, 21, 102 },
    { 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 14, 9, 11, 102 },
    { 3, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 14, 9, 11, 102 },
    { 3, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 14, 9, 11, 102 },
    { 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 14, 9, 11, 102 },
    { 3, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 14, 9, 11, 102 },
    { 3, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 14, 9, 11, 102 },
    { 3, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 14, 9, 11, 102 },
    { 3, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 14, 9, 11, 102 },
    { 3, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 14, 9, 11, 102 },
    { 3, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 14, 9, 11, 102 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 8, 30, 126 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 4, 4, 4, 30, 126 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 7, 4, 4, 30, 126 },
    { 0, 17, 9, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 4, 4, 4, 30, 126 },
    { 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 14, 9, 11, 126 },
    { 3, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 14, 9, 11, 126 },
    { 3, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 14, 9, 11, 126 },
    { 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 14, 9, 11, 126 },
    { 3, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 14, 9, 11, 126 },
    { 3, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 14, 9, 11, 126 },
    { 3, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 14, 9, 11, 126 },
    { 3, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 14, 9, 11, 126 },
    { 3, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 14, 9, 11, 126 },
    { 3, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 14, 9, 11, 126 },
    { 5, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 0, 30, 126 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 12, 17, 126 },
    { 29, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 0, 30, 126 },
    { 14, 0, 0, 0, -1, 0, 0, 32, 0, 0, 0, 0, 0, 32, 16, 0, 0, 8, 7, 12, 125 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, -32, 0, -32, 0, 0, 16, 0, 0, 8, 6, 12, 125 },
    { 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 125 },
    { 3, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 125 },
    { 3, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 125 },
    { 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 125 },
    { 3, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 125 },
    { 3, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 125 },
    { 3, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 125 },
    { 3, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 125 },
    { 3, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 125 },
    { 3, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 125 },
    { 5, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 12, 125 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 8, 8, 12, 125 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 8, 8, 12, 119 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 8, 8, 12, 63 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 8, 8, 12, 63 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 8, 8, 12, 63 },
    { 4, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 8, 8, 12, 63 },
    { 4, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 8, 8, 12, 63 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 17, 63 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 17, 63 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 8, 8, 12, 81 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 8, 8, 0, 81 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 8, 8, 1, 81 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 8, 8, 12, 127 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 8, 8, 0, 127 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 8, 8, 1, 127 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 8, 8, 12, 84 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 8, 8, 12, 115 },
    { 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 115 },
    { 3, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 115 },
    { 3, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 115 },
    { 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 115 },
    { 3, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 115 },
    { 3, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 115 },
    { 3, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 115 },
    { 3, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 115 },
    { 3, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 115 },
    { 3, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 115 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 12, 17, 115 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 8, 8, 12, 104 },
    { 0, 17, 1, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 4, 4, 4, 21, 104 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 12, 17, 104 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 8, 8, 12, 108 },
    { 0, 17, 230, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 4, 4, 4, 21, 108 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 12, 17, 108 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 17, 108 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 12, 108 },
    { 29, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 12, 108 },
    { 17, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 8, 8, 12, 108 },
    { 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 108 },
    { 3, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 108 },
    { 3, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 108 },
    { 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 108 },
    { 3, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 108 },
    { 3, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 108 },
    { 3, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 108 },
    { 3, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 108 },
    { 3, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 108 },
    { 3, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 14, 9, 11, 108 },
    { 5, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 12, 108 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 8, 8, 12, 99 },
    { 1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 7, 4, 4, 21, 99 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 4, 4, 4, 21, 99 },
    { 17, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 8, 8, 12, 99 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 6, 8, 14, 35 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 8, 14, 34 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 8, 8, 12, 105 },
    { 29, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 12, 105 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 4, 4, 4, 21, 105 },
    { 0, 17, 1, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 4, 4, 4, 21, 105 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 12, 17, 105 },
    { 10, 18, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 3, 4, 4, 21, 2 },
    { 29, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 12, 2 },
    { 29, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 85, 0, 0, 0, 12, 2 },
    { 1, 0, 216, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 4, 4, 4, 21, 2 },
    { 1, 0, 216, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 7, 4, 4, 21, 2 },
    { 0, 17, 1, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 4, 4, 4, 21, 1 },
    { 1, 0, 226, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 7, 4, 4, 21, 2 },
    { 10, 18, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 3, 4, 4, 21, 2 },
    { 0, 17, 220, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 4, 4, 4, 21, 1 },
    { 0, 17, 230, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 4, 4, 4, 21, 1 },
    { 29, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 0, 12, 2 },
    { 0, 17, 230, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 4, 4, 4, 21, 4 },
    { 5, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 12, 2 },
    { 14, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 80, 0, 8, 7, 12, 2 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 80, 0, 8, 6, 12, 2 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 80, 0, 8, 6, 12, 2 },
    { 26, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 80, 0, 0, 0, 12, 2 },
    { 26, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 80, 0, 0, 0, 12, 2 },
    { 14, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 80, 0, 8, 7, 12, 2 },
    { 15, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 80, 0, 8, 6, 12, 2 },
    { 3, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 80, 0, 14, 9, 11, 2 },
    { 3, 2, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 80, 0, 14, 9, 11, 2 },
    { 3, 2, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 80, 0, 14, 9, 11, 2 },
    { 3, 2, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 80, 0, 14, 9, 11, 2 },
    { 3, 2, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 80, 0, 14, 9, 11, 2 },
    { 3, 2, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 80, 0, 14, 9, 11, 2 },
    { 3, 2, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 80, 0, 14, 9, 11, 2 },
    { 3, 2, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 80, 0, 14, 9, 11, 2 },
    { 3, 2, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 80, 0, 14, 9, 11, 2 },
    { 3, 2, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 80, 0, 14, 9, 11, 2 },
    { 29, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 0, 12, 131 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 4, 4, 4, 21, 131 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 0, 17, 131 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 12, 17, 131 },
    { 25, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 0, 12, 131 },
    { 18, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 8, 8, 12, 113 },
    { 5, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 12, 113 },
    { 0, 17, 220, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 4, 4, 4, 21, 113 },
    { 18, 13, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 80, 0, 8, 8, 12, 8 },
    { 26, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 0, 0, 12, 8 },
    { 5, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 80, 0, 0, 0, 12, 2 },
    { 5, 2, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 80, 0, 0, 0, 12, 2 },
    { 5, 2, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 80, 0, 0, 0, 12, 2 },
    { 5, 2, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 80, 0, 0, 0, 12, 2 },
    { 5, 2, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 80, 0, 0, 0, 12, 2 },
    { 5, 2, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 80, 0, 0, 0, 12, 2 },
    { 5, 2, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 80, 0, 0, 0, 12, 2 },
    { 5, 2, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 80, 0, 0, 0, 12, 2 },
    { 5, 2, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 80, 0, 0, 0, 12, 2 },
    { 5, 2, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 80, 0, 0, 0, 12, 2 },
    { 5, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 12, 2 },
    { 29, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 80, 0, 0, 0, 12, 2 },
    { 29, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 80, 0, 8, 7, 12, 2 },
    { 29, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 80, 0, 8, 7, 12, 2 },
    { 29, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 80, 0, 0, 0, 12, 2 },
    { 29, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 8, 7, 12, 2 },
    { 29, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 8, 7, 12, 2 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 80, 0, 0, 0, 12, 2 },
    { 29, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 12, 2 },
    { 29, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 5, 5, 0, 28, 2 },
    { 29, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 80, 0, 0, 0, 14, 34 },
    { 29, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 80, 0, 0, 0, 14, 2 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 0, 14, 2 },
    { 28, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 0, 12, 2 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 0, 0, 12, 2 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 0, 0, 14, 2 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 13, 3, 2 },
    { 29, 10, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 5, 2 },
    { 13, 18, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 12, 0 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 8, 14, 37 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 8, 14, 37 },
    { 18, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 85, 0, 0, 8, 14, 37 },
    { 0, 17, 0, 5, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 4, 4, 4, 21, 1 },
    { 12, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 12, 0 }
};

Q_DECL_CONST_FUNCTION static inline const Properties *qGetProp(uint ucs4) Q_DECL_NOTHROW
{
    return uc_properties + GET_PROP_INDEX(ucs4);
}

Q_DECL_CONST_FUNCTION static inline const Properties *qGetProp(ushort ucs2) Q_DECL_NOTHROW
{
    return uc_properties + GET_PROP_INDEX_UCS2(ucs2);
}

Q_DECL_CONST_FUNCTION Q_CORE_EXPORT const Properties * QT_FASTCALL properties(uint ucs4) Q_DECL_NOTHROW
{
    return qGetProp(ucs4);
}

Q_DECL_CONST_FUNCTION Q_CORE_EXPORT const Properties * QT_FASTCALL properties(ushort ucs2) Q_DECL_NOTHROW
{
    return qGetProp(ucs2);
}

Q_CORE_EXPORT GraphemeBreakClass QT_FASTCALL graphemeBreakClass(uint ucs4) Q_DECL_NOTHROW
{
    return static_cast<GraphemeBreakClass>(qGetProp(ucs4)->graphemeBreakClass);
}

Q_CORE_EXPORT WordBreakClass QT_FASTCALL wordBreakClass(uint ucs4) Q_DECL_NOTHROW
{
    return static_cast<WordBreakClass>(qGetProp(ucs4)->wordBreakClass);
}

Q_CORE_EXPORT SentenceBreakClass QT_FASTCALL sentenceBreakClass(uint ucs4) Q_DECL_NOTHROW
{
    return static_cast<SentenceBreakClass>(qGetProp(ucs4)->sentenceBreakClass);
}

Q_CORE_EXPORT LineBreakClass QT_FASTCALL lineBreakClass(uint ucs4) Q_DECL_NOTHROW
{
    return static_cast<LineBreakClass>(qGetProp(ucs4)->lineBreakClass);
}


static const unsigned short specialCaseMap[] = {
    0x0, // placeholder
    0x1, 0x2c65,
    0x1, 0x2c66,
    0x1, 0x2c7e,
    0x1, 0x2c7f,
    0x1, 0x2c6f,
    0x1, 0x2c6d,
    0x1, 0x2c70,
    0x1, 0xa7ab,
    0x1, 0xa7ac,
    0x1, 0xa78d,
    0x1, 0xa7aa,
    0x1, 0x2c62,
    0x1, 0xa7ad,
    0x1, 0x2c6e,
    0x1, 0x2c64,
    0x1, 0xa7b1,
    0x1, 0xa7b2,
    0x1, 0xa7b0,
    0x1, 0xab70,
    0x1, 0xab71,
    0x1, 0xab72,
    0x1, 0xab73,
    0x1, 0xab74,
    0x1, 0xab75,
    0x1, 0xab76,
    0x1, 0xab77,
    0x1, 0xab78,
    0x1, 0xab79,
    0x1, 0xab7a,
    0x1, 0xab7b,
    0x1, 0xab7c,
    0x1, 0xab7d,
    0x1, 0xab7e,
    0x1, 0xab7f,
    0x1, 0xab80,
    0x1, 0xab81,
    0x1, 0xab82,
    0x1, 0xab83,
    0x1, 0xab84,
    0x1, 0xab85,
    0x1, 0xab86,
    0x1, 0xab87,
    0x1, 0xab88,
    0x1, 0xab89,
    0x1, 0xab8a,
    0x1, 0xab8b,
    0x1, 0xab8c,
    0x1, 0xab8d,
    0x1, 0xab8e,
    0x1, 0xab8f,
    0x1, 0xab90,
    0x1, 0xab91,
    0x1, 0xab92,
    0x1, 0xab93,
    0x1, 0xab94,
    0x1, 0xab95,
    0x1, 0xab96,
    0x1, 0xab97,
    0x1, 0xab98,
    0x1, 0xab99,
    0x1, 0xab9a,
    0x1, 0xab9b,
    0x1, 0xab9c,
    0x1, 0xab9d,
    0x1, 0xab9e,
    0x1, 0xab9f,
    0x1, 0xaba0,
    0x1, 0xaba1,
    0x1, 0xaba2,
    0x1, 0xaba3,
    0x1, 0xaba4,
    0x1, 0xaba5,
    0x1, 0xaba6,
    0x1, 0xaba7,
    0x1, 0xaba8,
    0x1, 0xaba9,
    0x1, 0xabaa,
    0x1, 0xabab,
    0x1, 0xabac,
    0x1, 0xabad,
    0x1, 0xabae,
    0x1, 0xabaf,
    0x1, 0xabb0,
    0x1, 0xabb1,
    0x1, 0xabb2,
    0x1, 0xabb3,
    0x1, 0xabb4,
    0x1, 0xabb5,
    0x1, 0xabb6,
    0x1, 0xabb7,
    0x1, 0xabb8,
    0x1, 0xabb9,
    0x1, 0xabba,
    0x1, 0xabbb,
    0x1, 0xabbc,
    0x1, 0xabbd,
    0x1, 0xabbe,
    0x1, 0xabbf,
    0x1, 0xa77d,
    0x1, 0x6b,
    0x1, 0xe5,
    0x1, 0x26b,
    0x1, 0x27d,
    0x1, 0x23a,
    0x1, 0x23e,
    0x1, 0x251,
    0x1, 0x271,
    0x1, 0x250,
    0x1, 0x252,
    0x1, 0x23f,
    0x1, 0x240,
    0x1, 0x1d79,
    0x1, 0x265,
    0x1, 0x266,
    0x1, 0x25c,
    0x1, 0x261,
    0x1, 0x26c,
    0x1, 0x29e,
    0x1, 0x287,
    0x1, 0x29d,
    0x1, 0x13a0,
    0x1, 0x13a1,
    0x1, 0x13a2,
    0x1, 0x13a3,
    0x1, 0x13a4,
    0x1, 0x13a5,
    0x1, 0x13a6,
    0x1, 0x13a7,
    0x1, 0x13a8,
    0x1, 0x13a9,
    0x1, 0x13aa,
    0x1, 0x13ab,
    0x1, 0x13ac,
    0x1, 0x13ad,
    0x1, 0x13ae,
    0x1, 0x13af,
    0x1, 0x13b0,
    0x1, 0x13b1,
    0x1, 0x13b2,
    0x1, 0x13b3,
    0x1, 0x13b4,
    0x1, 0x13b5,
    0x1, 0x13b6,
    0x1, 0x13b7,
    0x1, 0x13b8,
    0x1, 0x13b9,
    0x1, 0x13ba,
    0x1, 0x13bb,
    0x1, 0x13bc,
    0x1, 0x13bd,
    0x1, 0x13be,
    0x1, 0x13bf,
    0x1, 0x13c0,
    0x1, 0x13c1,
    0x1, 0x13c2,
    0x1, 0x13c3,
    0x1, 0x13c4,
    0x1, 0x13c5,
    0x1, 0x13c6,
    0x1, 0x13c7,
    0x1, 0x13c8,
    0x1, 0x13c9,
    0x1, 0x13ca,
    0x1, 0x13cb,
    0x1, 0x13cc,
    0x1, 0x13cd,
    0x1, 0x13ce,
    0x1, 0x13cf,
    0x1, 0x13d0,
    0x1, 0x13d1,
    0x1, 0x13d2,
    0x1, 0x13d3,
    0x1, 0x13d4,
    0x1, 0x13d5,
    0x1, 0x13d6,
    0x1, 0x13d7,
    0x1, 0x13d8,
    0x1, 0x13d9,
    0x1, 0x13da,
    0x1, 0x13db,
    0x1, 0x13dc,
    0x1, 0x13dd,
    0x1, 0x13de,
    0x1, 0x13df,
    0x1, 0x13e0,
    0x1, 0x13e1,
    0x1, 0x13e2,
    0x1, 0x13e3,
    0x1, 0x13e4,
    0x1, 0x13e5,
    0x1, 0x13e6,
    0x1, 0x13e7,
    0x1, 0x13e8,
    0x1, 0x13e9,
    0x1, 0x13ea,
    0x1, 0x13eb,
    0x1, 0x13ec,
    0x1, 0x13ed,
    0x1, 0x13ee,
    0x1, 0x13ef,
    0x2, 0x53, 0x73,
    0x2, 0x53, 0x53,
    0x2, 0x69, 0x307,
    0x2, 0x46, 0x66,
    0x2, 0x46, 0x46,
    0x2, 0x46, 0x69,
    0x2, 0x46, 0x49,
    0x2, 0x46, 0x6c,
    0x2, 0x46, 0x4c,
    0x3, 0x46, 0x66, 0x69,
    0x3, 0x46, 0x46, 0x49,
    0x3, 0x46, 0x66, 0x6c,
    0x3, 0x46, 0x46, 0x4c,
    0x2, 0x53, 0x74,
    0x2, 0x53, 0x54,
    0x2, 0x535, 0x582,
    0x2, 0x535, 0x552,
    0x2, 0x544, 0x576,
    0x2, 0x544, 0x546,
    0x2, 0x544, 0x565,
    0x2, 0x544, 0x535,
    0x2, 0x544, 0x56b,
    0x2, 0x544, 0x53b,
    0x2, 0x54e, 0x576,
    0x2, 0x54e, 0x546,
    0x2, 0x544, 0x56d,
    0x2, 0x544, 0x53d,
    0x2, 0x2bc, 0x4e,
    0x3, 0x399, 0x308, 0x301,
    0x3, 0x3a5, 0x308, 0x301,
    0x2, 0x4a, 0x30c,
    0x2, 0x48, 0x331,
    0x2, 0x54, 0x308,
    0x2, 0x57, 0x30a,
    0x2, 0x59, 0x30a,
    0x2, 0x41, 0x2be,
    0x2, 0x3a5, 0x313,
    0x3, 0x3a5, 0x313, 0x300,
    0x3, 0x3a5, 0x313, 0x301,
    0x3, 0x3a5, 0x313, 0x342,
    0x2, 0x391, 0x342,
    0x2, 0x397, 0x342,
    0x3, 0x399, 0x308, 0x300,
    0x2, 0x399, 0x342,
    0x3, 0x399, 0x308, 0x342,
    0x3, 0x3a5, 0x308, 0x300,
    0x2, 0x3a1, 0x313,
    0x2, 0x3a5, 0x342,
    0x3, 0x3a5, 0x308, 0x342,
    0x2, 0x3a9, 0x342,
    0x2, 0x1f08, 0x399,
    0x2, 0x1f09, 0x399,
    0x2, 0x1f0a, 0x399,
    0x2, 0x1f0b, 0x399,
    0x2, 0x1f0c, 0x399,
    0x2, 0x1f0d, 0x399,
    0x2, 0x1f0e, 0x399,
    0x2, 0x1f0f, 0x399,
    0x2, 0x1f28, 0x399,
    0x2, 0x1f29, 0x399,
    0x2, 0x1f2a, 0x399,
    0x2, 0x1f2b, 0x399,
    0x2, 0x1f2c, 0x399,
    0x2, 0x1f2d, 0x399,
    0x2, 0x1f2e, 0x399,
    0x2, 0x1f2f, 0x399,
    0x2, 0x1f68, 0x399,
    0x2, 0x1f69, 0x399,
    0x2, 0x1f6a, 0x399,
    0x2, 0x1f6b, 0x399,
    0x2, 0x1f6c, 0x399,
    0x2, 0x1f6d, 0x399,
    0x2, 0x1f6e, 0x399,
    0x2, 0x1f6f, 0x399,
    0x2, 0x391, 0x399,
    0x2, 0x397, 0x399,
    0x2, 0x3a9, 0x399,
    0x2, 0x1fba, 0x345,
    0x2, 0x1fba, 0x399,
    0x2, 0x386, 0x345,
    0x2, 0x386, 0x399,
    0x2, 0x1fca, 0x345,
    0x2, 0x1fca, 0x399,
    0x2, 0x389, 0x345,
    0x2, 0x389, 0x399,
    0x2, 0x1ffa, 0x345,
    0x2, 0x1ffa, 0x399,
    0x2, 0x38f, 0x345,
    0x2, 0x38f, 0x399,
    0x3, 0x391, 0x342, 0x345,
    0x3, 0x391, 0x342, 0x399,
    0x3, 0x397, 0x342, 0x345,
    0x3, 0x397, 0x342, 0x399,
    0x3, 0x3a9, 0x342, 0x345,
    0x3, 0x3a9, 0x342, 0x399
};


static const unsigned short uc_decomposition_trie[] = {
    // 0 - 0x3400

    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1564, 1580, 1596, 1612, 1628, 1644,
    1660, 1676, 1692, 1708, 1724, 1740, 1756, 1772,
    1548, 1548, 1788, 1804, 1820, 1836, 1852, 1868,
    1884, 1900, 1916, 1932, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1948, 1548, 1964, 1980, 1548,
    1548, 1548, 1548, 1548, 1996, 1548, 1548, 2012,
    2028, 2044, 2060, 2076, 2092, 2108, 1548, 2124,
    2140, 2156, 1548, 2172, 1548, 2188, 1548, 2204,
    1548, 1548, 1548, 1548, 2220, 2236, 2252, 2268,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    2284, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 2300, 1548, 1548, 1548, 1548, 2316,
    1548, 1548, 1548, 1548, 2332, 2348, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 2364, 2380, 1548, 2396, 1548, 1548,
    1548, 1548, 1548, 1548, 2412, 2428, 1548, 1548,
    1548, 1548, 1548, 2444, 1548, 2460, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 2476, 2492, 1548, 1548,
    1548, 2508, 1548, 1548, 2524, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 2540, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 2556, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 2572, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 2588, 1548, 1548,
    1548, 1548, 1548, 2604, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 2620, 1548, 2636, 1548, 1548,
    2652, 1548, 1548, 1548, 2668, 2684, 2700, 2716,
    2732, 2748, 2764, 2780, 1548, 1548, 1548, 1548,

    1548, 1548, 2796, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 2812,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    2828, 2844, 1548, 2860, 2876, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 2892, 2908, 2924, 2940, 2956, 2972,
    1548, 2988, 3004, 3020, 1548, 1548, 1548, 1548,
    3036, 3052, 3068, 3084, 3100, 3116, 3132, 3148,
    3164, 3180, 3196, 3212, 3228, 3244, 3260, 3276,
    3292, 3308, 3324, 3340, 3356, 3372, 3388, 3404,
    3420, 3436, 3452, 3468, 3484, 3500, 3516, 3532,

    3548, 3564, 3580, 3596, 3612, 3628, 1548, 3644,
    3660, 3676, 3692, 1548, 1548, 1548, 1548, 1548,
    3708, 3724, 3740, 3756, 3772, 3788, 3804, 3820,
    3836, 3852, 3868, 1548, 3884, 1548, 1548, 1548,
    3900, 1548, 3916, 3932, 3948, 1548, 3964, 3980,
    3996, 1548, 4012, 1548, 1548, 1548, 4028, 1548,
    1548, 1548, 4044, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 4060, 4076,
    4092, 4108, 4124, 4140, 4156, 4172, 4188, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    4204, 1548, 1548, 1548, 1548, 1548, 1548, 4220,
    1548, 1548, 1548, 1548, 1548, 4236, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 4252,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 4268, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 1548, 1548, 1548, 1548, 1548, 1548, 1548,
    1548, 4284, 1548, 1548, 1548, 1548, 1548, 4300,
    4316, 4332, 4348, 4364, 4380, 4396, 4412, 4428,
    4444, 4460, 4476, 4492, 4508, 4524, 1548, 1548,

    4540, 1548, 1548, 4556, 4572, 4588, 4604, 4620,
    1548, 4636, 4652, 4668, 4684, 4700, 1548, 4716,
    1548, 1548, 1548, 4732, 4748, 4764, 4780, 4796,
    4812, 4828, 1548, 1548, 1548, 1548, 1548, 1548,
    4844, 4860, 4876, 4892, 4908, 4924, 4940, 4956,
    4972, 4988, 5004, 5020, 5036, 5052, 5068, 5084,
    5100, 5116, 5132, 5148, 5164, 5180, 5196, 5212,
    5228, 5244, 5260, 5276, 5292, 5308, 5324, 5340,

    // 0x3400 - 0x30000

    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5612, 5868, 5356, 5356, 5356, 6124,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,

    5356, 5356, 5356, 5356, 5356, 6380, 6636, 6892,
    7148, 7404, 7660, 7916, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 8172, 8428, 5356, 8684,
    8940, 9196, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 9452, 5356, 5356,
    9708, 9964, 10220, 10476, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 10732, 5356, 5356, 10988, 11244, 5356,

    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,
    5356, 5356, 5356, 5356, 5356, 5356, 5356, 5356,

    5356, 5356, 5356, 5356, 11500, 11756, 12012, 5356,
    5356, 5356, 5356, 5356,


    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x0, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x2, 0xffff, 0x5, 0xffff, 0xffff, 0xffff, 0xffff, 0x7,

    0xffff, 0xffff, 0xa, 0xc, 0xe, 0x11, 0xffff, 0xffff,
    0x13, 0x16, 0x18, 0xffff, 0x1a, 0x1e, 0x22, 0xffff,

    0x26, 0x29, 0x2c, 0x2f, 0x32, 0x35, 0xffff, 0x38,
    0x3b, 0x3e, 0x41, 0x44, 0x47, 0x4a, 0x4d, 0x50,

    0xffff, 0x53, 0x56, 0x59, 0x5c, 0x5f, 0x62, 0xffff,
    0xffff, 0x65, 0x68, 0x6b, 0x6e, 0x71, 0xffff, 0xffff,

    0x74, 0x77, 0x7a, 0x7d, 0x80, 0x83, 0xffff, 0x86,
    0x89, 0x8c, 0x8f, 0x92, 0x95, 0x98, 0x9b, 0x9e,

    0xffff, 0xa1, 0xa4, 0xa7, 0xaa, 0xad, 0xb0, 0xffff,
    0xffff, 0xb3, 0xb6, 0xb9, 0xbc, 0xbf, 0xffff, 0xc2,

    0xc5, 0xc8, 0xcb, 0xce, 0xd1, 0xd4, 0xd7, 0xda,
    0xdd, 0xe0, 0xe3, 0xe6, 0xe9, 0xec, 0xef, 0xf2,

    0xffff, 0xffff, 0xf5, 0xf8, 0xfb, 0xfe, 0x101, 0x104,
    0x107, 0x10a, 0x10d, 0x110, 0x113, 0x116, 0x119, 0x11c,

    0x11f, 0x122, 0x125, 0x128, 0x12b, 0x12e, 0xffff, 0xffff,
    0x131, 0x134, 0x137, 0x13a, 0x13d, 0x140, 0x143, 0x146,

    0x149, 0xffff, 0x14c, 0x14f, 0x152, 0x155, 0x158, 0x15b,
    0xffff, 0x15e, 0x161, 0x164, 0x167, 0x16a, 0x16d, 0x170,

    0x173, 0xffff, 0xffff, 0x176, 0x179, 0x17c, 0x17f, 0x182,
    0x185, 0x188, 0xffff, 0xffff, 0x18b, 0x18e, 0x191, 0x194,

    0x197, 0x19a, 0xffff, 0xffff, 0x19d, 0x1a0, 0x1a3, 0x1a6,
    0x1a9, 0x1ac, 0x1af, 0x1b2, 0x1b5, 0x1b8, 0x1bb, 0x1be,

    0x1c1, 0x1c4, 0x1c7, 0x1ca, 0x1cd, 0x1d0, 0xffff, 0xffff,
    0x1d3, 0x1d6, 0x1d9, 0x1dc, 0x1df, 0x1e2, 0x1e5, 0x1e8,

    0x1eb, 0x1ee, 0x1f1, 0x1f4, 0x1f7, 0x1fa, 0x1fd, 0x200,
    0x203, 0x206, 0x209, 0x20c, 0x20f, 0x212, 0x215, 0x218,

    0x21a, 0x21d, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x220,

    0x223, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0x226, 0x229, 0x22c, 0x22f,
    0x232, 0x235, 0x238, 0x23b, 0x23e, 0x241, 0x244, 0x247,

    0x24a, 0x24d, 0x250, 0x253, 0x256, 0x259, 0x25c, 0x25f,
    0x262, 0x265, 0x268, 0x26b, 0x26e, 0xffff, 0x271, 0x274,

    0x277, 0x27a, 0x27d, 0x280, 0xffff, 0xffff, 0x283, 0x286,
    0x289, 0x28c, 0x28f, 0x292, 0x295, 0x298, 0x29b, 0x29e,

    0x2a1, 0x2a4, 0x2a7, 0x2aa, 0x2ad, 0x2b0, 0xffff, 0xffff,
    0x2b3, 0x2b6, 0x2b9, 0x2bc, 0x2bf, 0x2c2, 0x2c5, 0x2c8,

    0x2cb, 0x2ce, 0x2d1, 0x2d4, 0x2d7, 0x2da, 0x2dd, 0x2e0,
    0x2e3, 0x2e6, 0x2e9, 0x2ec, 0x2ef, 0x2f2, 0x2f5, 0x2f8,

    0x2fb, 0x2fe, 0x301, 0x304, 0x307, 0x30a, 0x30d, 0x310,
    0x313, 0x316, 0x319, 0x31c, 0xffff, 0xffff, 0x31f, 0x322,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x325, 0x328,
    0x32b, 0x32e, 0x331, 0x334, 0x337, 0x33a, 0x33d, 0x340,

    0x343, 0x346, 0x349, 0x34c, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x34f, 0x351, 0x353, 0x355, 0x357, 0x359, 0x35b, 0x35d,
    0x35f, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x361, 0x364, 0x367, 0x36a, 0x36d, 0x370, 0xffff, 0xffff,

    0x373, 0x375, 0x377, 0x379, 0x37b, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x37d, 0x37f, 0xffff, 0x381, 0x383, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0x386, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0x388, 0xffff, 0xffff, 0xffff, 0x38b, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0x38d, 0x390, 0x393, 0x396,
    0x398, 0x39b, 0x39e, 0xffff, 0x3a1, 0xffff, 0x3a4, 0x3a7,

    0x3aa, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0x3ad, 0x3b0, 0x3b3, 0x3b6, 0x3b9, 0x3bc,

    0x3bf, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0x3c2, 0x3c5, 0x3c8, 0x3cb, 0x3ce, 0xffff,

    0x3d1, 0x3d3, 0x3d5, 0x3d7, 0x3da, 0x3dd, 0x3df, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x3e1, 0x3e3, 0x3e5, 0xffff, 0x3e7, 0x3e9, 0xffff, 0xffff,
    0xffff, 0x3eb, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x3ed, 0x3f0, 0xffff, 0x3f3, 0xffff, 0xffff, 0xffff, 0x3f6,
    0xffff, 0xffff, 0xffff, 0xffff, 0x3f9, 0x3fc, 0x3ff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0x402, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0x405, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x408, 0x40b, 0xffff, 0x40e, 0xffff, 0xffff, 0xffff, 0x411,
    0xffff, 0xffff, 0xffff, 0xffff, 0x414, 0x417, 0x41a, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x41d, 0x420,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0x423, 0x426, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x429, 0x42c, 0x42f, 0x432, 0xffff, 0xffff, 0x435, 0x438,
    0xffff, 0xffff, 0x43b, 0x43e, 0x441, 0x444, 0x447, 0x44a,

    0xffff, 0xffff, 0x44d, 0x450, 0x453, 0x456, 0x459, 0x45c,
    0xffff, 0xffff, 0x45f, 0x462, 0x465, 0x468, 0x46b, 0x46e,

    0x471, 0x474, 0x477, 0x47a, 0x47d, 0x480, 0xffff, 0xffff,
    0x483, 0x486, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x489,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0x48c, 0x48f, 0x492, 0x495, 0x498, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x49b, 0x49e, 0x4a1,
    0x4a4, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x4a7, 0xffff, 0x4aa, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0x4ad, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0x4b0, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0x4b3, 0xffff, 0xffff, 0x4b6, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x4b9, 0x4bc, 0x4bf, 0x4c2, 0x4c5, 0x4c8, 0x4cb, 0x4ce,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0x4d1, 0x4d4, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0x4d7, 0x4da, 0xffff, 0x4dd,

    0xffff, 0xffff, 0xffff, 0x4e0, 0xffff, 0xffff, 0x4e3, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0x4e6, 0x4e9, 0x4ec, 0xffff, 0xffff, 0x4ef, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x4f2, 0xffff, 0xffff, 0x4f5, 0x4f8, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0x4fb, 0x4fe, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0x501, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0x504, 0x507, 0x50a, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x50d, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x510, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x513,
    0x516, 0xffff, 0x519, 0x51c, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0x51f, 0x522, 0x525, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0x528, 0xffff, 0x52b, 0x52e, 0x531, 0xffff,

    0xffff, 0xffff, 0xffff, 0x534, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0x537, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0x53a, 0x53d, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0x540, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0x542, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x545, 0xffff, 0xffff,

    0xffff, 0xffff, 0x548, 0xffff, 0xffff, 0xffff, 0xffff, 0x54b,
    0xffff, 0xffff, 0xffff, 0xffff, 0x54e, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0x551, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0x554, 0xffff, 0x557, 0x55a, 0x55d,
    0x560, 0x563, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0x566, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0x569, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x56c, 0xffff, 0xffff,

    0xffff, 0xffff, 0x56f, 0xffff, 0xffff, 0xffff, 0xffff, 0x572,
    0xffff, 0xffff, 0xffff, 0xffff, 0x575, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0x578, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x57b, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0x57e, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x580, 0xffff,
    0x583, 0xffff, 0x586, 0xffff, 0x589, 0xffff, 0x58c, 0xffff,

    0xffff, 0xffff, 0x58f, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0x592, 0xffff, 0x595, 0xffff, 0xffff,

    0x598, 0x59b, 0xffff, 0x59e, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0x5a1, 0x5a3, 0x5a5, 0xffff,

    0x5a7, 0x5a9, 0x5ab, 0x5ad, 0x5af, 0x5b1, 0x5b3, 0x5b5,
    0x5b7, 0x5b9, 0x5bb, 0xffff, 0x5bd, 0x5bf, 0x5c1, 0x5c3,

    0x5c5, 0x5c7, 0x5c9, 0x5cb, 0x5cd, 0x5cf, 0x5d1, 0x5d3,
    0x5d5, 0x5d7, 0x5d9, 0x5db, 0x5dd, 0x5df, 0xffff, 0x5e1,

    0x5e3, 0x5e5, 0x5e7, 0x5e9, 0x5eb, 0x5ed, 0x5ef, 0x5f1,
    0x5f3, 0x5f5, 0x5f7, 0x5f9, 0x5fb, 0x5fd, 0x5ff, 0x601,

    0x603, 0x605, 0x607, 0x609, 0x60b, 0x60d, 0x60f, 0x611,
    0x613, 0x615, 0x617, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x619, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0x61b, 0x61d, 0x61f, 0x621, 0x623,

    0x625, 0x627, 0x629, 0x62b, 0x62d, 0x62f, 0x631, 0x633,
    0x635, 0x637, 0x639, 0x63b, 0x63d, 0x63f, 0x641, 0x643,

    0x645, 0x647, 0x649, 0x64b, 0x64d, 0x64f, 0x651, 0x653,
    0x655, 0x657, 0x659, 0x65b, 0x65d, 0x65f, 0x661, 0x663,

    0x665, 0x668, 0x66b, 0x66e, 0x671, 0x674, 0x677, 0x67a,
    0x67d, 0x680, 0x683, 0x686, 0x689, 0x68c, 0x68f, 0x692,

    0x695, 0x698, 0x69b, 0x69e, 0x6a1, 0x6a4, 0x6a7, 0x6aa,
    0x6ad, 0x6b0, 0x6b3, 0x6b6, 0x6b9, 0x6bc, 0x6bf, 0x6c2,

    0x6c5, 0x6c8, 0x6cb, 0x6ce, 0x6d1, 0x6d4, 0x6d7, 0x6da,
    0x6dd, 0x6e0, 0x6e3, 0x6e6, 0x6e9, 0x6ec, 0x6ef, 0x6f2,

    0x6f5, 0x6f8, 0x6fb, 0x6fe, 0x701, 0x704, 0x707, 0x70a,
    0x70d, 0x710, 0x713, 0x716, 0x719, 0x71c, 0x71f, 0x722,

    0x725, 0x728, 0x72b, 0x72e, 0x731, 0x734, 0x737, 0x73a,
    0x73d, 0x740, 0x743, 0x746, 0x749, 0x74c, 0x74f, 0x752,

    0x755, 0x758, 0x75b, 0x75e, 0x761, 0x764, 0x767, 0x76a,
    0x76d, 0x770, 0x773, 0x776, 0x779, 0x77c, 0x77f, 0x782,

    0x785, 0x788, 0x78b, 0x78e, 0x791, 0x794, 0x797, 0x79a,
    0x79d, 0x7a0, 0x7a3, 0x7a6, 0x7a9, 0x7ac, 0x7af, 0x7b2,

    0x7b5, 0x7b8, 0x7bb, 0x7be, 0x7c1, 0x7c4, 0x7c7, 0x7ca,
    0x7cd, 0x7d0, 0x7d3, 0x7d6, 0x7d9, 0x7dc, 0x7df, 0x7e2,

    0x7e5, 0x7e8, 0x7eb, 0x7ee, 0x7f1, 0x7f4, 0x7f7, 0x7fa,
    0x7fd, 0x800, 0x803, 0x806, 0x809, 0x80c, 0x80f, 0x812,

    0x815, 0x818, 0x81b, 0x81e, 0x821, 0x824, 0x827, 0x82a,
    0x82d, 0x830, 0x833, 0x836, 0xffff, 0xffff, 0xffff, 0xffff,

    0x839, 0x83c, 0x83f, 0x842, 0x845, 0x848, 0x84b, 0x84e,
    0x851, 0x854, 0x857, 0x85a, 0x85d, 0x860, 0x863, 0x866,

    0x869, 0x86c, 0x86f, 0x872, 0x875, 0x878, 0x87b, 0x87e,
    0x881, 0x884, 0x887, 0x88a, 0x88d, 0x890, 0x893, 0x896,

    0x899, 0x89c, 0x89f, 0x8a2, 0x8a5, 0x8a8, 0x8ab, 0x8ae,
    0x8b1, 0x8b4, 0x8b7, 0x8ba, 0x8bd, 0x8c0, 0x8c3, 0x8c6,

    0x8c9, 0x8cc, 0x8cf, 0x8d2, 0x8d5, 0x8d8, 0x8db, 0x8de,
    0x8e1, 0x8e4, 0x8e7, 0x8ea, 0x8ed, 0x8f0, 0x8f3, 0x8f6,

    0x8f9, 0x8fc, 0x8ff, 0x902, 0x905, 0x908, 0x90b, 0x90e,
    0x911, 0x914, 0x917, 0x91a, 0x91d, 0x920, 0x923, 0x926,

    0x929, 0x92c, 0x92f, 0x932, 0x935, 0x938, 0x93b, 0x93e,
    0x941, 0x944, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x947, 0x94a, 0x94d, 0x950, 0x953, 0x956, 0x959, 0x95c,
    0x95f, 0x962, 0x965, 0x968, 0x96b, 0x96e, 0x971, 0x974,

    0x977, 0x97a, 0x97d, 0x980, 0x983, 0x986, 0xffff, 0xffff,
    0x989, 0x98c, 0x98f, 0x992, 0x995, 0x998, 0xffff, 0xffff,

    0x99b, 0x99e, 0x9a1, 0x9a4, 0x9a7, 0x9aa, 0x9ad, 0x9b0,
    0x9b3, 0x9b6, 0x9b9, 0x9bc, 0x9bf, 0x9c2, 0x9c5, 0x9c8,

    0x9cb, 0x9ce, 0x9d1, 0x9d4, 0x9d7, 0x9da, 0x9dd, 0x9e0,
    0x9e3, 0x9e6, 0x9e9, 0x9ec, 0x9ef, 0x9f2, 0x9f5, 0x9f8,

    0x9fb, 0x9fe, 0xa01, 0xa04, 0xa07, 0xa0a, 0xffff, 0xffff,
    0xa0d, 0xa10, 0xa13, 0xa16, 0xa19, 0xa1c, 0xffff, 0xffff,

    0xa1f, 0xa22, 0xa25, 0xa28, 0xa2b, 0xa2e, 0xa31, 0xa34,
    0xffff, 0xa37, 0xffff, 0xa3a, 0xffff, 0xa3d, 0xffff, 0xa40,

    0xa43, 0xa46, 0xa49, 0xa4c, 0xa4f, 0xa52, 0xa55, 0xa58,
    0xa5b, 0xa5e, 0xa61, 0xa64, 0xa67, 0xa6a, 0xa6d, 0xa70,

    0xa73, 0xa76, 0xa78, 0xa7b, 0xa7d, 0xa80, 0xa82, 0xa85,
    0xa87, 0xa8a, 0xa8c, 0xa8f, 0xa91, 0xa94, 0xffff, 0xffff,

    0xa96, 0xa99, 0xa9c, 0xa9f, 0xaa2, 0xaa5, 0xaa8, 0xaab,
    0xaae, 0xab1, 0xab4, 0xab7, 0xaba, 0xabd, 0xac0, 0xac3,

    0xac6, 0xac9, 0xacc, 0xacf, 0xad2, 0xad5, 0xad8, 0xadb,
    0xade, 0xae1, 0xae4, 0xae7, 0xaea, 0xaed, 0xaf0, 0xaf3,

    0xaf6, 0xaf9, 0xafc, 0xaff, 0xb02, 0xb05, 0xb08, 0xb0b,
    0xb0e, 0xb11, 0xb14, 0xb17, 0xb1a, 0xb1d, 0xb20, 0xb23,

    0xb26, 0xb29, 0xb2c, 0xb2f, 0xb32, 0xffff, 0xb35, 0xb38,
    0xb3b, 0xb3e, 0xb41, 0xb44, 0xb46, 0xb49, 0xb4c, 0xb4e,

    0xb51, 0xb54, 0xb57, 0xb5a, 0xb5d, 0xffff, 0xb60, 0xb63,
    0xb66, 0xb69, 0xb6b, 0xb6e, 0xb70, 0xb73, 0xb76, 0xb79,

    0xb7c, 0xb7f, 0xb82, 0xb85, 0xffff, 0xffff, 0xb87, 0xb8a,
    0xb8d, 0xb90, 0xb93, 0xb96, 0xffff, 0xb98, 0xb9b, 0xb9e,

    0xba1, 0xba4, 0xba7, 0xbaa, 0xbac, 0xbaf, 0xbb2, 0xbb5,
    0xbb8, 0xbbb, 0xbbe, 0xbc1, 0xbc3, 0xbc6, 0xbc9, 0xbcb,

    0xffff, 0xffff, 0xbcd, 0xbd0, 0xbd3, 0xffff, 0xbd6, 0xbd9,
    0xbdc, 0xbdf, 0xbe1, 0xbe4, 0xbe6, 0xbe9, 0xbeb, 0xffff,

    0xbee, 0xbf0, 0xbf2, 0xbf4, 0xbf6, 0xbf8, 0xbfa, 0xbfc,
    0xbfe, 0xc00, 0xc02, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xc04, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xc06,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xc09, 0xc0b, 0xc0e, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xc12,

    0xffff, 0xffff, 0xffff, 0xc14, 0xc17, 0xffff, 0xc1b, 0xc1e,
    0xffff, 0xffff, 0xffff, 0xffff, 0xc22, 0xffff, 0xc25, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xc28,
    0xc2b, 0xc2e, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xc31,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xc36,

    0xc38, 0xc3a, 0xffff, 0xffff, 0xc3c, 0xc3e, 0xc40, 0xc42,
    0xc44, 0xc46, 0xc48, 0xc4a, 0xc4c, 0xc4e, 0xc50, 0xc52,

    0xc54, 0xc56, 0xc58, 0xc5a, 0xc5c, 0xc5e, 0xc60, 0xc62,
    0xc64, 0xc66, 0xc68, 0xc6a, 0xc6c, 0xc6e, 0xc70, 0xffff,

    0xc72, 0xc74, 0xc76, 0xc78, 0xc7a, 0xc7c, 0xc7e, 0xc80,
    0xc82, 0xc84, 0xc86, 0xc88, 0xc8a, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xc8c, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xc8f, 0xc93, 0xc97, 0xc99, 0xffff, 0xc9c, 0xca0, 0xca4,
    0xffff, 0xca6, 0xca9, 0xcab, 0xcad, 0xcaf, 0xcb1, 0xcb3,

    0xcb5, 0xcb7, 0xcb9, 0xcbb, 0xffff, 0xcbd, 0xcbf, 0xffff,
    0xffff, 0xcc2, 0xcc4, 0xcc6, 0xcc8, 0xcca, 0xffff, 0xffff,

    0xccc, 0xccf, 0xcd3, 0xffff, 0xcd6, 0xffff, 0xcd8, 0xffff,
    0xcda, 0xffff, 0xcdc, 0xcde, 0xce0, 0xce2, 0xffff, 0xce4,

    0xce6, 0xce8, 0xffff, 0xcea, 0xcec, 0xcee, 0xcf0, 0xcf2,
    0xcf4, 0xcf6, 0xffff, 0xcf8, 0xcfc, 0xcfe, 0xd00, 0xd02,

    0xd04, 0xffff, 0xffff, 0xffff, 0xffff, 0xd06, 0xd08, 0xd0a,
    0xd0c, 0xd0e, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xd10, 0xd14, 0xd18, 0xd1d, 0xd21, 0xd25, 0xd29, 0xd2d,
    0xd31, 0xd35, 0xd39, 0xd3d, 0xd41, 0xd45, 0xd49, 0xd4d,

    0xd50, 0xd52, 0xd55, 0xd59, 0xd5c, 0xd5e, 0xd61, 0xd65,
    0xd6a, 0xd6d, 0xd6f, 0xd72, 0xd76, 0xd78, 0xd7a, 0xd7c,

    0xd7e, 0xd80, 0xd83, 0xd87, 0xd8a, 0xd8c, 0xd8f, 0xd93,
    0xd98, 0xd9b, 0xd9d, 0xda0, 0xda4, 0xda6, 0xda8, 0xdaa,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xdac, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xdb0, 0xdb3, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xdb6, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xdb9, 0xdbc, 0xdbf,

    0xffff, 0xffff, 0xffff, 0xffff, 0xdc2, 0xffff, 0xffff, 0xffff,
    0xffff, 0xdc5, 0xffff, 0xffff, 0xdc8, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xdcb, 0xffff, 0xdce, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xdd1, 0xdd4, 0xffff, 0xdd8,

    0xddb, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xddf, 0xffff, 0xffff, 0xde2, 0xffff, 0xffff, 0xde5,
    0xffff, 0xde8, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xdeb, 0xffff, 0xdee, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xdf1, 0xdf4, 0xdf7,

    0xdfa, 0xdfd, 0xffff, 0xffff, 0xe00, 0xe03, 0xffff, 0xffff,
    0xe06, 0xe09, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xe0c, 0xe0f, 0xffff, 0xffff, 0xe12, 0xe15, 0xffff, 0xffff,
    0xe18, 0xe1b, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xe1e, 0xe21, 0xe24, 0xe27,

    0xe2a, 0xe2d, 0xe30, 0xe33, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xe36, 0xe39, 0xe3c, 0xe3f, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xe42, 0xe44, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xe46, 0xe48, 0xe4a, 0xe4c, 0xe4e, 0xe50, 0xe52, 0xe54,
    0xe56, 0xe58, 0xe5b, 0xe5e, 0xe61, 0xe64, 0xe67, 0xe6a,

    0xe6d, 0xe70, 0xe73, 0xe76, 0xe79, 0xe7d, 0xe81, 0xe85,
    0xe89, 0xe8d, 0xe91, 0xe95, 0xe99, 0xe9d, 0xea2, 0xea7,

    0xeac, 0xeb1, 0xeb6, 0xebb, 0xec0, 0xec5, 0xeca, 0xecf,
    0xed4, 0xed7, 0xeda, 0xedd, 0xee0, 0xee3, 0xee6, 0xee9,

    0xeec, 0xeef, 0xef3, 0xef7, 0xefb, 0xeff, 0xf03, 0xf07,
    0xf0b, 0xf0f, 0xf13, 0xf17, 0xf1b, 0xf1f, 0xf23, 0xf27,

    0xf2b, 0xf2f, 0xf33, 0xf37, 0xf3b, 0xf3f, 0xf43, 0xf47,
    0xf4b, 0xf4f, 0xf53, 0xf57, 0xf5b, 0xf5f, 0xf63, 0xf67,

    0xf6b, 0xf6f, 0xf73, 0xf77, 0xf7b, 0xf7f, 0xf83, 0xf85,
    0xf87, 0xf89, 0xf8b, 0xf8d, 0xf8f, 0xf91, 0xf93, 0xf95,

    0xf97, 0xf99, 0xf9b, 0xf9d, 0xf9f, 0xfa1, 0xfa3, 0xfa5,
    0xfa7, 0xfa9, 0xfab, 0xfad, 0xfaf, 0xfb1, 0xfb3, 0xfb5,

    0xfb7, 0xfb9, 0xfbb, 0xfbd, 0xfbf, 0xfc1, 0xfc3, 0xfc5,
    0xfc7, 0xfc9, 0xfcb, 0xfcd, 0xfcf, 0xfd1, 0xfd3, 0xfd5,

    0xfd7, 0xfd9, 0xfdb, 0xfdd, 0xfdf, 0xfe1, 0xfe3, 0xfe5,
    0xfe7, 0xfe9, 0xfeb, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xfed, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xff2, 0xff6, 0xff9, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffd, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0x1000, 0x1002, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x1004,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x1006,

    0xffff, 0xffff, 0xffff, 0x1008, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x100a, 0x100c, 0x100e, 0x1010, 0x1012, 0x1014, 0x1016, 0x1018,
    0x101a, 0x101c, 0x101e, 0x1020, 0x1022, 0x1024, 0x1026, 0x1028,

    0x102a, 0x102c, 0x102e, 0x1030, 0x1032, 0x1034, 0x1036, 0x1038,
    0x103a, 0x103c, 0x103e, 0x1040, 0x1042, 0x1044, 0x1046, 0x1048,

    0x104a, 0x104c, 0x104e, 0x1050, 0x1052, 0x1054, 0x1056, 0x1058,
    0x105a, 0x105c, 0x105e, 0x1060, 0x1062, 0x1064, 0x1066, 0x1068,

    0x106a, 0x106c, 0x106e, 0x1070, 0x1072, 0x1074, 0x1076, 0x1078,
    0x107a, 0x107c, 0x107e, 0x1080, 0x1082, 0x1084, 0x1086, 0x1088,

    0x108a, 0x108c, 0x108e, 0x1090, 0x1092, 0x1094, 0x1096, 0x1098,
    0x109a, 0x109c, 0x109e, 0x10a0, 0x10a2, 0x10a4, 0x10a6, 0x10a8,

    0x10aa, 0x10ac, 0x10ae, 0x10b0, 0x10b2, 0x10b4, 0x10b6, 0x10b8,
    0x10ba, 0x10bc, 0x10be, 0x10c0, 0x10c2, 0x10c4, 0x10c6, 0x10c8,

    0x10ca, 0x10cc, 0x10ce, 0x10d0, 0x10d2, 0x10d4, 0x10d6, 0x10d8,
    0x10da, 0x10dc, 0x10de, 0x10e0, 0x10e2, 0x10e4, 0x10e6, 0x10e8,

    0x10ea, 0x10ec, 0x10ee, 0x10f0, 0x10f2, 0x10f4, 0x10f6, 0x10f8,
    0x10fa, 0x10fc, 0x10fe, 0x1100, 0x1102, 0x1104, 0x1106, 0x1108,

    0x110a, 0x110c, 0x110e, 0x1110, 0x1112, 0x1114, 0x1116, 0x1118,
    0x111a, 0x111c, 0x111e, 0x1120, 0x1122, 0x1124, 0x1126, 0x1128,

    0x112a, 0x112c, 0x112e, 0x1130, 0x1132, 0x1134, 0x1136, 0x1138,
    0x113a, 0x113c, 0x113e, 0x1140, 0x1142, 0x1144, 0x1146, 0x1148,

    0x114a, 0x114c, 0x114e, 0x1150, 0x1152, 0x1154, 0x1156, 0x1158,
    0x115a, 0x115c, 0x115e, 0x1160, 0x1162, 0x1164, 0x1166, 0x1168,

    0x116a, 0x116c, 0x116e, 0x1170, 0x1172, 0x1174, 0x1176, 0x1178,
    0x117a, 0x117c, 0x117e, 0x1180, 0x1182, 0x1184, 0x1186, 0x1188,

    0x118a, 0x118c, 0x118e, 0x1190, 0x1192, 0x1194, 0x1196, 0x1198,
    0x119a, 0x119c, 0x119e, 0x11a0, 0x11a2, 0x11a4, 0x11a6, 0x11a8,

    0x11aa, 0x11ac, 0x11ae, 0x11b0, 0x11b2, 0x11b4, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x11b6, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x11b8, 0xffff,
    0x11ba, 0x11bc, 0x11be, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0x11c0, 0xffff, 0x11c3, 0xffff,

    0x11c6, 0xffff, 0x11c9, 0xffff, 0x11cc, 0xffff, 0x11cf, 0xffff,
    0x11d2, 0xffff, 0x11d5, 0xffff, 0x11d8, 0xffff, 0x11db, 0xffff,

    0x11de, 0xffff, 0x11e1, 0xffff, 0xffff, 0x11e4, 0xffff, 0x11e7,
    0xffff, 0x11ea, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x11ed, 0x11f0, 0xffff, 0x11f3, 0x11f6, 0xffff, 0x11f9, 0x11fc,
    0xffff, 0x11ff, 0x1202, 0xffff, 0x1205, 0x1208, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0x120b, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0x120e, 0x1211, 0xffff, 0x1214, 0x1217,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0x121a, 0xffff, 0x121d, 0xffff,

    0x1220, 0xffff, 0x1223, 0xffff, 0x1226, 0xffff, 0x1229, 0xffff,
    0x122c, 0xffff, 0x122f, 0xffff, 0x1232, 0xffff, 0x1235, 0xffff,

    0x1238, 0xffff, 0x123b, 0xffff, 0xffff, 0x123e, 0xffff, 0x1241,
    0xffff, 0x1244, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x1247, 0x124a, 0xffff, 0x124d, 0x1250, 0xffff, 0x1253, 0x1256,
    0xffff, 0x1259, 0x125c, 0xffff, 0x125f, 0x1262, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0x1265, 0xffff, 0xffff, 0x1268,
    0x126b, 0x126e, 0x1271, 0xffff, 0xffff, 0xffff, 0x1274, 0x1277,

    0xffff, 0x127a, 0x127c, 0x127e, 0x1280, 0x1282, 0x1284, 0x1286,
    0x1288, 0x128a, 0x128c, 0x128e, 0x1290, 0x1292, 0x1294, 0x1296,

    0x1298, 0x129a, 0x129c, 0x129e, 0x12a0, 0x12a2, 0x12a4, 0x12a6,
    0x12a8, 0x12aa, 0x12ac, 0x12ae, 0x12b0, 0x12b2, 0x12b4, 0x12b6,

    0x12b8, 0x12ba, 0x12bc, 0x12be, 0x12c0, 0x12c2, 0x12c4, 0x12c6,
    0x12c8, 0x12ca, 0x12cc, 0x12ce, 0x12d0, 0x12d2, 0x12d4, 0x12d6,

    0x12d8, 0x12da, 0x12dc, 0x12de, 0x12e0, 0x12e2, 0x12e4, 0x12e6,
    0x12e8, 0x12ea, 0x12ec, 0x12ee, 0x12f0, 0x12f2, 0x12f4, 0x12f6,

    0x12f8, 0x12fa, 0x12fc, 0x12fe, 0x1300, 0x1302, 0x1304, 0x1306,
    0x1308, 0x130a, 0x130c, 0x130e, 0x1310, 0x1312, 0x1314, 0x1316,

    0x1318, 0x131a, 0x131c, 0x131e, 0x1320, 0x1322, 0x1324, 0x1326,
    0x1328, 0x132a, 0x132c, 0x132e, 0x1330, 0x1332, 0x1334, 0xffff,

    0xffff, 0xffff, 0x1336, 0x1338, 0x133a, 0x133c, 0x133e, 0x1340,
    0x1342, 0x1344, 0x1346, 0x1348, 0x134a, 0x134c, 0x134e, 0x1350,

    0x1352, 0x1356, 0x135a, 0x135e, 0x1362, 0x1366, 0x136a, 0x136e,
    0x1372, 0x1376, 0x137a, 0x137e, 0x1382, 0x1386, 0x138a, 0x138f,

    0x1394, 0x1399, 0x139e, 0x13a3, 0x13a8, 0x13ad, 0x13b2, 0x13b7,
    0x13bc, 0x13c1, 0x13c6, 0x13cb, 0x13d0, 0x13d5, 0x13dd, 0xffff,

    0x13e4, 0x13e8, 0x13ec, 0x13f0, 0x13f4, 0x13f8, 0x13fc, 0x1400,
    0x1404, 0x1408, 0x140c, 0x1410, 0x1414, 0x1418, 0x141c, 0x1420,

    0x1424, 0x1428, 0x142c, 0x1430, 0x1434, 0x1438, 0x143c, 0x1440,
    0x1444, 0x1448, 0x144c, 0x1450, 0x1454, 0x1458, 0x145c, 0x1460,

    0x1464, 0x1468, 0x146c, 0x1470, 0x1474, 0x1476, 0x1478, 0x147a,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x147c, 0x1480, 0x1483, 0x1486, 0x1489, 0x148c, 0x148f, 0x1492,
    0x1495, 0x1498, 0x149b, 0x149e, 0x14a1, 0x14a4, 0x14a7, 0x14aa,

    0x14ad, 0x14af, 0x14b1, 0x14b3, 0x14b5, 0x14b7, 0x14b9, 0x14bb,
    0x14bd, 0x14bf, 0x14c1, 0x14c3, 0x14c5, 0x14c7, 0x14c9, 0x14cc,

    0x14cf, 0x14d2, 0x14d5, 0x14d8, 0x14db, 0x14de, 0x14e1, 0x14e4,
    0x14e7, 0x14ea, 0x14ed, 0x14f0, 0x14f3, 0x14f9, 0x14fe, 0xffff,

    0x1501, 0x1503, 0x1505, 0x1507, 0x1509, 0x150b, 0x150d, 0x150f,
    0x1511, 0x1513, 0x1515, 0x1517, 0x1519, 0x151b, 0x151d, 0x151f,

    0x1521, 0x1523, 0x1525, 0x1527, 0x1529, 0x152b, 0x152d, 0x152f,
    0x1531, 0x1533, 0x1535, 0x1537, 0x1539, 0x153b, 0x153d, 0x153f,

    0x1541, 0x1543, 0x1545, 0x1547, 0x1549, 0x154b, 0x154d, 0x154f,
    0x1551, 0x1553, 0x1555, 0x1557, 0x1559, 0x155b, 0x155d, 0x155f,

    0x1561, 0x1563, 0x1566, 0x1569, 0x156c, 0x156f, 0x1572, 0x1575,
    0x1578, 0x157b, 0x157e, 0x1581, 0x1584, 0x1587, 0x158a, 0x158d,

    0x1590, 0x1593, 0x1596, 0x1599, 0x159c, 0x159f, 0x15a2, 0x15a5,
    0x15a8, 0x15ab, 0x15af, 0x15b3, 0x15b7, 0x15ba, 0x15be, 0x15c1,

    0x15c5, 0x15c7, 0x15c9, 0x15cb, 0x15cd, 0x15cf, 0x15d1, 0x15d3,
    0x15d5, 0x15d7, 0x15d9, 0x15db, 0x15dd, 0x15df, 0x15e1, 0x15e3,

    0x15e5, 0x15e7, 0x15e9, 0x15eb, 0x15ed, 0x15ef, 0x15f1, 0x15f3,
    0x15f5, 0x15f7, 0x15f9, 0x15fb, 0x15fd, 0x15ff, 0x1601, 0x1603,

    0x1605, 0x1607, 0x1609, 0x160b, 0x160d, 0x160f, 0x1611, 0x1613,
    0x1615, 0x1617, 0x1619, 0x161b, 0x161d, 0x161f, 0x1621, 0xffff,

    0x1623, 0x1628, 0x162d, 0x1632, 0x1636, 0x163b, 0x163f, 0x1643,
    0x1649, 0x164e, 0x1652, 0x1656, 0x165a, 0x165f, 0x1664, 0x1668,

    0x166c, 0x166f, 0x1673, 0x1678, 0x167d, 0x1680, 0x1686, 0x168d,
    0x1693, 0x1697, 0x169d, 0x16a3, 0x16a8, 0x16ac, 0x16b0, 0x16b4,

    0x16b9, 0x16bf, 0x16c4, 0x16c8, 0x16cc, 0x16d0, 0x16d3, 0x16d6,
    0x16d9, 0x16dc, 0x16e0, 0x16e4, 0x16ea, 0x16ee, 0x16f3, 0x16f9,

    0x16fd, 0x1700, 0x1703, 0x1709, 0x170e, 0x1714, 0x1718, 0x171e,
    0x1721, 0x1725, 0x1729, 0x172d, 0x1731, 0x1735, 0x173a, 0x173e,

    0x1741, 0x1745, 0x1749, 0x174d, 0x1752, 0x1756, 0x175a, 0x175e,
    0x1764, 0x1769, 0x176c, 0x1772, 0x1775, 0x177a, 0x177f, 0x1783,

    0x1787, 0x178b, 0x1790, 0x1793, 0x1797, 0x179c, 0x179f, 0x17a5,
    0x17a9, 0x17ac, 0x17af, 0x17b2, 0x17b5, 0x17b8, 0x17bb, 0x17be,

    0x17c1, 0x17c4, 0x17c7, 0x17cb, 0x17cf, 0x17d3, 0x17d7, 0x17db,
    0x17df, 0x17e3, 0x17e7, 0x17eb, 0x17ef, 0x17f3, 0x17f7, 0x17fb,

    0x17ff, 0x1803, 0x1807, 0x180a, 0x180d, 0x1811, 0x1814, 0x1817,
    0x181a, 0x181e, 0x1822, 0x1825, 0x1828, 0x182b, 0x182e, 0x1831,

    0x1836, 0x1839, 0x183c, 0x183f, 0x1842, 0x1845, 0x1848, 0x184b,
    0x184e, 0x1852, 0x1857, 0x185a, 0x185d, 0x1860, 0x1863, 0x1866,

    0x1869, 0x186c, 0x1870, 0x1874, 0x1878, 0x187c, 0x187f, 0x1882,
    0x1885, 0x1888, 0x188b, 0x188e, 0x1891, 0x1894, 0x1897, 0x189a,

    0x189e, 0x18a2, 0x18a5, 0x18a9, 0x18ad, 0x18b1, 0x18b4, 0x18b8,
    0x18bc, 0x18c1, 0x18c4, 0x18c8, 0x18cc, 0x18d0, 0x18d4, 0x18da,

    0x18e1, 0x18e4, 0x18e7, 0x18ea, 0x18ed, 0x18f0, 0x18f3, 0x18f6,
    0x18f9, 0x18fc, 0x18ff, 0x1902, 0x1905, 0x1908, 0x190b, 0x190e,

    0x1911, 0x1914, 0x1917, 0x191c, 0x191f, 0x1922, 0x1925, 0x192a,
    0x192e, 0x1931, 0x1934, 0x1937, 0x193a, 0x193d, 0x1940, 0x1943,

    0x1946, 0x1949, 0x194c, 0x1950, 0x1953, 0x1956, 0x195a, 0x195e,
    0x1961, 0x1966, 0x196a, 0x196d, 0x1970, 0x1973, 0x1976, 0x197a,

    0x197e, 0x1981, 0x1984, 0x1987, 0x198a, 0x198d, 0x1990, 0x1993,
    0x1996, 0x1999, 0x199d, 0x19a1, 0x19a5, 0x19a9, 0x19ad, 0x19b1,

    0x19b5, 0x19b9, 0x19bd, 0x19c1, 0x19c5, 0x19c9, 0x19cd, 0x19d1,
    0x19d5, 0x19d9, 0x19dd, 0x19e1, 0x19e5, 0x19e9, 0x19ed, 0x19f1,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0x19f5, 0x19f7, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x19f9, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x19fb, 0x19fd, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0x19ff, 0x1a01, 0x1a03, 0x1a05,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x1a07, 0x1a09, 0x1a0b, 0x1a0d, 0x1a0f, 0x1a11, 0x1a13, 0x1a15,
    0x1a17, 0x1a19, 0x1a1b, 0x1a1d, 0x1a1f, 0x1a21, 0x1a23, 0x1a25,
    0x1a27, 0x1a29, 0x1a2b, 0x1a2d, 0x1a2f, 0x1a31, 0x1a33, 0x1a35,
    0x1a37, 0x1a39, 0x1a3b, 0x1a3d, 0x1a3f, 0x1a41, 0x1a43, 0x1a45,
    0x1a47, 0x1a49, 0x1a4b, 0x1a4d, 0x1a4f, 0x1a51, 0x1a53, 0x1a55,
    0x1a57, 0x1a59, 0x1a5b, 0x1a5d, 0x1a5f, 0x1a61, 0x1a63, 0x1a65,
    0x1a67, 0x1a69, 0x1a6b, 0x1a6d, 0x1a6f, 0x1a71, 0x1a73, 0x1a75,
    0x1a77, 0x1a79, 0x1a7b, 0x1a7d, 0x1a7f, 0x1a81, 0x1a83, 0x1a85,
    0x1a87, 0x1a89, 0x1a8b, 0x1a8d, 0x1a8f, 0x1a91, 0x1a93, 0x1a95,
    0x1a97, 0x1a99, 0x1a9b, 0x1a9d, 0x1a9f, 0x1aa1, 0x1aa3, 0x1aa5,
    0x1aa7, 0x1aa9, 0x1aab, 0x1aad, 0x1aaf, 0x1ab1, 0x1ab3, 0x1ab5,
    0x1ab7, 0x1ab9, 0x1abb, 0x1abd, 0x1abf, 0x1ac1, 0x1ac3, 0x1ac5,
    0x1ac7, 0x1ac9, 0x1acb, 0x1acd, 0x1acf, 0x1ad1, 0x1ad3, 0x1ad5,
    0x1ad7, 0x1ad9, 0x1adb, 0x1add, 0x1adf, 0x1ae1, 0x1ae3, 0x1ae5,
    0x1ae7, 0x1ae9, 0x1aeb, 0x1aed, 0x1aef, 0x1af1, 0x1af3, 0x1af5,
    0x1af7, 0x1af9, 0x1afb, 0x1afd, 0x1aff, 0x1b01, 0x1b03, 0x1b05,
    0x1b07, 0x1b09, 0x1b0b, 0x1b0d, 0x1b0f, 0x1b11, 0x1b13, 0x1b15,
    0x1b17, 0x1b19, 0x1b1b, 0x1b1d, 0x1b1f, 0x1b21, 0x1b23, 0x1b25,
    0x1b27, 0x1b29, 0x1b2b, 0x1b2d, 0x1b2f, 0x1b31, 0x1b33, 0x1b35,
    0x1b37, 0x1b39, 0x1b3b, 0x1b3d, 0x1b3f, 0x1b41, 0x1b43, 0x1b45,
    0x1b47, 0x1b49, 0x1b4b, 0x1b4d, 0x1b4f, 0x1b51, 0x1b53, 0x1b55,
    0x1b57, 0x1b59, 0x1b5b, 0x1b5d, 0x1b5f, 0x1b61, 0x1b63, 0x1b65,
    0x1b67, 0x1b69, 0x1b6b, 0x1b6d, 0x1b6f, 0x1b71, 0x1b73, 0x1b75,
    0x1b77, 0x1b79, 0x1b7b, 0x1b7d, 0x1b7f, 0x1b81, 0x1b83, 0x1b85,
    0x1b87, 0x1b89, 0x1b8b, 0x1b8d, 0x1b8f, 0x1b91, 0x1b93, 0x1b95,
    0x1b97, 0x1b99, 0x1b9b, 0x1b9d, 0x1b9f, 0x1ba1, 0x1ba3, 0x1ba5,
    0x1ba7, 0x1ba9, 0x1bab, 0x1bad, 0x1baf, 0x1bb1, 0x1bb3, 0x1bb5,
    0x1bb7, 0x1bb9, 0x1bbb, 0x1bbd, 0x1bbf, 0x1bc1, 0x1bc3, 0x1bc5,
    0x1bc7, 0x1bc9, 0x1bcb, 0x1bcd, 0x1bcf, 0x1bd1, 0x1bd3, 0x1bd5,
    0x1bd7, 0x1bd9, 0x1bdb, 0x1bdd, 0x1bdf, 0x1be1, 0x1be3, 0x1be5,
    0x1be7, 0x1be9, 0x1beb, 0x1bed, 0x1bef, 0x1bf1, 0x1bf3, 0x1bf5,
    0x1bf7, 0x1bf9, 0x1bfb, 0x1bfd, 0x1bff, 0x1c01, 0x1c03, 0x1c05,

    0x1c07, 0x1c09, 0x1c0b, 0x1c0d, 0x1c0f, 0x1c11, 0x1c13, 0x1c15,
    0x1c17, 0x1c19, 0x1c1b, 0x1c1d, 0x1c1f, 0x1c21, 0xffff, 0xffff,
    0x1c23, 0xffff, 0x1c25, 0xffff, 0xffff, 0x1c27, 0x1c29, 0x1c2b,
    0x1c2d, 0x1c2f, 0x1c31, 0x1c33, 0x1c35, 0x1c37, 0x1c39, 0xffff,
    0x1c3b, 0xffff, 0x1c3d, 0xffff, 0xffff, 0x1c3f, 0x1c41, 0xffff,
    0xffff, 0xffff, 0x1c43, 0x1c45, 0x1c47, 0x1c49, 0x1c4b, 0x1c4d,
    0x1c4f, 0x1c51, 0x1c53, 0x1c55, 0x1c57, 0x1c59, 0x1c5b, 0x1c5d,
    0x1c5f, 0x1c61, 0x1c63, 0x1c65, 0x1c67, 0x1c69, 0x1c6b, 0x1c6d,
    0x1c6f, 0x1c71, 0x1c73, 0x1c75, 0x1c77, 0x1c79, 0x1c7b, 0x1c7d,
    0x1c7f, 0x1c81, 0x1c83, 0x1c85, 0x1c87, 0x1c89, 0x1c8b, 0x1c8d,
    0x1c8f, 0x1c91, 0x1c93, 0x1c95, 0x1c97, 0x1c99, 0x1c9b, 0x1c9d,
    0x1c9f, 0x1ca1, 0x1ca3, 0x1ca5, 0x1ca7, 0x1ca9, 0x1cab, 0x1cad,
    0x1caf, 0x1cb1, 0x1cb3, 0x1cb5, 0x1cb7, 0x1cb9, 0x1cbb, 0x1cbd,
    0x1cbf, 0x1cc1, 0x1cc3, 0x1cc5, 0x1cc7, 0x1cca, 0xffff, 0xffff,
    0x1ccc, 0x1cce, 0x1cd0, 0x1cd2, 0x1cd4, 0x1cd6, 0x1cd8, 0x1cda,
    0x1cdc, 0x1cde, 0x1ce0, 0x1ce2, 0x1ce4, 0x1ce6, 0x1ce8, 0x1cea,
    0x1cec, 0x1cee, 0x1cf0, 0x1cf2, 0x1cf4, 0x1cf6, 0x1cf8, 0x1cfa,
    0x1cfc, 0x1cfe, 0x1d00, 0x1d02, 0x1d04, 0x1d06, 0x1d08, 0x1d0a,
    0x1d0c, 0x1d0e, 0x1d10, 0x1d12, 0x1d14, 0x1d16, 0x1d18, 0x1d1a,
    0x1d1c, 0x1d1e, 0x1d20, 0x1d22, 0x1d24, 0x1d26, 0x1d28, 0x1d2a,
    0x1d2c, 0x1d2e, 0x1d30, 0x1d32, 0x1d34, 0x1d36, 0x1d38, 0x1d3a,
    0x1d3c, 0x1d3e, 0x1d40, 0x1d42, 0x1d44, 0x1d46, 0x1d48, 0x1d4a,
    0x1d4c, 0x1d4e, 0x1d50, 0x1d52, 0x1d54, 0x1d56, 0x1d58, 0x1d5a,
    0x1d5c, 0x1d5e, 0x1d60, 0x1d62, 0x1d64, 0x1d66, 0x1d68, 0x1d6a,
    0x1d6c, 0x1d6e, 0x1d70, 0x1d72, 0x1d74, 0x1d76, 0x1d78, 0x1d7a,
    0x1d7c, 0x1d7e, 0x1d80, 0x1d82, 0x1d84, 0x1d86, 0x1d88, 0x1d8a,
    0x1d8d, 0x1d90, 0x1d93, 0x1d95, 0x1d97, 0x1d99, 0x1d9c, 0x1d9f,
    0x1da2, 0x1da4, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x1da6, 0x1da9, 0x1dac, 0x1daf, 0x1db3, 0x1db7, 0x1dba, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0x1dbd, 0x1dc0, 0x1dc3, 0x1dc6, 0x1dc9,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x1dcc, 0xffff, 0x1dcf,
    0x1dd2, 0x1dd4, 0x1dd6, 0x1dd8, 0x1dda, 0x1ddc, 0x1dde, 0x1de0,
    0x1de2, 0x1de4, 0x1de6, 0x1de9, 0x1dec, 0x1def, 0x1df2, 0x1df5,
    0x1df8, 0x1dfb, 0x1dfe, 0x1e01, 0x1e04, 0x1e07, 0x1e0a, 0xffff,
    0x1e0d, 0x1e10, 0x1e13, 0x1e16, 0x1e19, 0xffff, 0x1e1c, 0xffff,
    0x1e1f, 0x1e22, 0xffff, 0x1e25, 0x1e28, 0xffff, 0x1e2b, 0x1e2e,
    0x1e31, 0x1e34, 0x1e37, 0x1e3a, 0x1e3d, 0x1e40, 0x1e43, 0x1e46,
    0x1e49, 0x1e4b, 0x1e4d, 0x1e4f, 0x1e51, 0x1e53, 0x1e55, 0x1e57,
    0x1e59, 0x1e5b, 0x1e5d, 0x1e5f, 0x1e61, 0x1e63, 0x1e65, 0x1e67,
    0x1e69, 0x1e6b, 0x1e6d, 0x1e6f, 0x1e71, 0x1e73, 0x1e75, 0x1e77,
    0x1e79, 0x1e7b, 0x1e7d, 0x1e7f, 0x1e81, 0x1e83, 0x1e85, 0x1e87,
    0x1e89, 0x1e8b, 0x1e8d, 0x1e8f, 0x1e91, 0x1e93, 0x1e95, 0x1e97,
    0x1e99, 0x1e9b, 0x1e9d, 0x1e9f, 0x1ea1, 0x1ea3, 0x1ea5, 0x1ea7,
    0x1ea9, 0x1eab, 0x1ead, 0x1eaf, 0x1eb1, 0x1eb3, 0x1eb5, 0x1eb7,
    0x1eb9, 0x1ebb, 0x1ebd, 0x1ebf, 0x1ec1, 0x1ec3, 0x1ec5, 0x1ec7,
    0x1ec9, 0x1ecb, 0x1ecd, 0x1ecf, 0x1ed1, 0x1ed3, 0x1ed5, 0x1ed7,
    0x1ed9, 0x1edb, 0x1edd, 0x1edf, 0x1ee1, 0x1ee3, 0x1ee5, 0x1ee7,
    0x1ee9, 0x1eeb, 0x1eed, 0x1eef, 0x1ef1, 0x1ef3, 0x1ef5, 0x1ef7,
    0x1ef9, 0x1efb, 0x1efd, 0x1eff, 0x1f01, 0x1f03, 0x1f05, 0x1f07,
    0x1f09, 0x1f0b, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0x1f0d, 0x1f0f, 0x1f11, 0x1f13, 0x1f15,
    0x1f17, 0x1f19, 0x1f1b, 0x1f1d, 0x1f1f, 0x1f21, 0x1f23, 0x1f25,
    0x1f27, 0x1f29, 0x1f2b, 0x1f2d, 0x1f2f, 0x1f31, 0x1f33, 0x1f35,
    0x1f37, 0x1f39, 0x1f3b, 0x1f3e, 0x1f41, 0x1f44, 0x1f47, 0x1f4a,
    0x1f4d, 0x1f50, 0x1f53, 0x1f56, 0x1f59, 0x1f5c, 0x1f5f, 0x1f62,
    0x1f65, 0x1f68, 0x1f6b, 0x1f6e, 0x1f71, 0x1f73, 0x1f75, 0x1f77,

    0x1f79, 0x1f7c, 0x1f7f, 0x1f82, 0x1f85, 0x1f88, 0x1f8b, 0x1f8e,
    0x1f91, 0x1f94, 0x1f97, 0x1f9a, 0x1f9d, 0x1fa0, 0x1fa3, 0x1fa6,
    0x1fa9, 0x1fac, 0x1faf, 0x1fb2, 0x1fb5, 0x1fb8, 0x1fbb, 0x1fbe,
    0x1fc1, 0x1fc4, 0x1fc7, 0x1fca, 0x1fcd, 0x1fd0, 0x1fd3, 0x1fd6,
    0x1fd9, 0x1fdc, 0x1fdf, 0x1fe2, 0x1fe5, 0x1fe8, 0x1feb, 0x1fee,
    0x1ff1, 0x1ff4, 0x1ff7, 0x1ffa, 0x1ffd, 0x2000, 0x2003, 0x2006,
    0x2009, 0x200c, 0x200f, 0x2012, 0x2015, 0x2018, 0x201b, 0x201e,
    0x2021, 0x2024, 0x2027, 0x202a, 0x202d, 0x2030, 0x2033, 0x2036,
    0x2039, 0x203c, 0x203f, 0x2042, 0x2045, 0x2048, 0x204b, 0x204e,
    0x2051, 0x2054, 0x2057, 0x205a, 0x205d, 0x2060, 0x2063, 0x2066,
    0x2069, 0x206c, 0x206f, 0x2072, 0x2075, 0x2078, 0x207b, 0x207e,
    0x2081, 0x2084, 0x2087, 0x208a, 0x208d, 0x2090, 0x2093, 0x2097,
    0x209b, 0x209f, 0x20a3, 0x20a7, 0x20ab, 0x20ae, 0x20b1, 0x20b4,
    0x20b7, 0x20ba, 0x20bd, 0x20c0, 0x20c3, 0x20c6, 0x20c9, 0x20cc,
    0x20cf, 0x20d2, 0x20d5, 0x20d8, 0x20db, 0x20de, 0x20e1, 0x20e4,
    0x20e7, 0x20ea, 0x20ed, 0x20f0, 0x20f3, 0x20f6, 0x20f9, 0x20fc,
    0x20ff, 0x2102, 0x2105, 0x2108, 0x210b, 0x210e, 0x2111, 0x2114,
    0x2117, 0x211a, 0x211d, 0x2120, 0x2123, 0x2126, 0x2129, 0x212c,
    0x212f, 0x2132, 0x2135, 0x2138, 0x213b, 0x213e, 0x2141, 0x2144,
    0x2147, 0x214a, 0x214d, 0x2150, 0x2153, 0x2156, 0x2159, 0x215c,
    0x215f, 0x2162, 0x2165, 0x2168, 0x216b, 0x216e, 0x2171, 0x2174,
    0x2177, 0x217a, 0x217d, 0x2180, 0x2183, 0x2186, 0x2189, 0x218c,
    0x218f, 0x2192, 0x2195, 0x2198, 0x219b, 0x219e, 0x21a1, 0x21a4,
    0x21a7, 0x21aa, 0x21ad, 0x21b0, 0x21b3, 0x21b6, 0x21b9, 0x21bc,
    0x21bf, 0x21c2, 0x21c5, 0x21c8, 0x21cb, 0x21ce, 0x21d1, 0x21d4,
    0x21d7, 0x21da, 0x21dd, 0x21e0, 0x21e3, 0x21e6, 0x21e9, 0x21ec,
    0x21ef, 0x21f2, 0x21f5, 0x21f8, 0x21fb, 0x21fe, 0x2201, 0x2204,
    0x2207, 0x220a, 0x220d, 0x2210, 0x2213, 0x2216, 0x2219, 0x221c,
    0x221f, 0x2222, 0x2225, 0x2228, 0x222b, 0x222e, 0x2231, 0x2234,
    0x2237, 0x223a, 0x223d, 0x2240, 0x2243, 0x2246, 0x2249, 0x224c,
    0x224f, 0x2252, 0x2255, 0x2259, 0x225d, 0x2261, 0x2264, 0x2267,
    0x226a, 0x226d, 0x2270, 0x2273, 0x2276, 0x2279, 0x227c, 0x227f,

    0x2282, 0x2285, 0x2288, 0x228b, 0x228e, 0x2291, 0x2294, 0x2297,
    0x229a, 0x229d, 0x22a0, 0x22a3, 0x22a6, 0x22a9, 0x22ac, 0x22af,
    0x22b2, 0x22b5, 0x22b8, 0x22bb, 0x22be, 0x22c1, 0x22c4, 0x22c7,
    0x22ca, 0x22cd, 0x22d0, 0x22d3, 0x22d6, 0x22d9, 0x22dc, 0x22df,
    0x22e2, 0x22e5, 0x22e8, 0x22eb, 0x22ee, 0x22f1, 0x22f4, 0x22f7,
    0x22fa, 0x22fd, 0x2300, 0x2303, 0x2306, 0x2309, 0x230c, 0x230f,
    0x2312, 0x2315, 0x2318, 0x231b, 0x231e, 0x2321, 0x2324, 0x2327,
    0x232a, 0x232d, 0x2330, 0x2333, 0x2336, 0x2339, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x233c, 0x2340, 0x2344, 0x2348, 0x234c, 0x2350, 0x2354, 0x2358,
    0x235c, 0x2360, 0x2364, 0x2368, 0x236c, 0x2370, 0x2374, 0x2378,
    0x237c, 0x2380, 0x2384, 0x2388, 0x238c, 0x2390, 0x2394, 0x2398,
    0x239c, 0x23a0, 0x23a4, 0x23a8, 0x23ac, 0x23b0, 0x23b4, 0x23b8,
    0x23bc, 0x23c0, 0x23c4, 0x23c8, 0x23cc, 0x23d0, 0x23d4, 0x23d8,
    0x23dc, 0x23e0, 0x23e4, 0x23e8, 0x23ec, 0x23f0, 0x23f4, 0x23f8,
    0x23fc, 0x2400, 0x2404, 0x2408, 0x240c, 0x2410, 0x2414, 0x2418,
    0x241c, 0x2420, 0x2424, 0x2428, 0x242c, 0x2430, 0x2434, 0x2438,
    0xffff, 0xffff, 0x243c, 0x2440, 0x2444, 0x2448, 0x244c, 0x2450,
    0x2454, 0x2458, 0x245c, 0x2460, 0x2464, 0x2468, 0x246c, 0x2470,
    0x2474, 0x2478, 0x247c, 0x2480, 0x2484, 0x2488, 0x248c, 0x2490,
    0x2494, 0x2498, 0x249c, 0x24a0, 0x24a4, 0x24a8, 0x24ac, 0x24b0,
    0x24b4, 0x24b8, 0x24bc, 0x24c0, 0x24c4, 0x24c8, 0x24cc, 0x24d0,
    0x24d4, 0x24d8, 0x24dc, 0x24e0, 0x24e4, 0x24e8, 0x24ec, 0x24f0,
    0x24f4, 0x24f8, 0x24fc, 0x2500, 0x2504, 0x2508, 0x250c, 0x2510,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x2514, 0x2518, 0x251c, 0x2521, 0x2526, 0x252b, 0x2530, 0x2535,
    0x253a, 0x253f, 0x2543, 0x2556, 0x255f, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x2564, 0x2566, 0x2568, 0x256a, 0x256c, 0x256e, 0x2570, 0x2572,
    0x2574, 0x2576, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x2578, 0x257a, 0x257c, 0x257e, 0x2580, 0x2582, 0x2584, 0x2586,
    0x2588, 0x258a, 0x258c, 0x258e, 0x2590, 0x2592, 0x2594, 0x2596,
    0x2598, 0x259a, 0x259c, 0x259e, 0x25a0, 0xffff, 0xffff, 0x25a2,
    0x25a4, 0x25a6, 0x25a8, 0x25aa, 0x25ac, 0x25ae, 0x25b0, 0x25b2,
    0x25b4, 0x25b6, 0x25b8, 0xffff, 0x25ba, 0x25bc, 0x25be, 0x25c0,
    0x25c2, 0x25c4, 0x25c6, 0x25c8, 0x25ca, 0x25cc, 0x25ce, 0x25d0,
    0x25d2, 0x25d4, 0x25d6, 0x25d8, 0x25da, 0x25dc, 0x25de, 0xffff,
    0x25e0, 0x25e2, 0x25e4, 0x25e6, 0xffff, 0xffff, 0xffff, 0xffff,
    0x25e8, 0x25eb, 0x25ee, 0xffff, 0x25f1, 0xffff, 0x25f4, 0x25f7,
    0x25fa, 0x25fd, 0x2600, 0x2603, 0x2606, 0x2609, 0x260c, 0x260f,
    0x2612, 0x2614, 0x2616, 0x2618, 0x261a, 0x261c, 0x261e, 0x2620,
    0x2622, 0x2624, 0x2626, 0x2628, 0x262a, 0x262c, 0x262e, 0x2630,
    0x2632, 0x2634, 0x2636, 0x2638, 0x263a, 0x263c, 0x263e, 0x2640,
    0x2642, 0x2644, 0x2646, 0x2648, 0x264a, 0x264c, 0x264e, 0x2650,
    0x2652, 0x2654, 0x2656, 0x2658, 0x265a, 0x265c, 0x265e, 0x2660,
    0x2662, 0x2664, 0x2666, 0x2668, 0x266a, 0x266c, 0x266e, 0x2670,
    0x2672, 0x2674, 0x2676, 0x2678, 0x267a, 0x267c, 0x267e, 0x2680,
    0x2682, 0x2684, 0x2686, 0x2688, 0x268a, 0x268c, 0x268e, 0x2690,
    0x2692, 0x2694, 0x2696, 0x2698, 0x269a, 0x269c, 0x269e, 0x26a0,
    0x26a2, 0x26a4, 0x26a6, 0x26a8, 0x26aa, 0x26ac, 0x26ae, 0x26b0,
    0x26b2, 0x26b4, 0x26b6, 0x26b8, 0x26ba, 0x26bc, 0x26be, 0x26c0,
    0x26c2, 0x26c4, 0x26c6, 0x26c8, 0x26ca, 0x26cc, 0x26ce, 0x26d0,
    0x26d2, 0x26d4, 0x26d6, 0x26d8, 0x26da, 0x26dc, 0x26de, 0x26e0,
    0x26e2, 0x26e4, 0x26e6, 0x26e8, 0x26ea, 0x26ec, 0x26ee, 0x26f0,
    0x26f2, 0x26f4, 0x26f6, 0x26f8, 0x26fa, 0x26fc, 0x26ff, 0x2702,
    0x2705, 0x2708, 0x270b, 0x270e, 0x2711, 0xffff, 0xffff, 0xffff,

    0xffff, 0x2714, 0x2716, 0x2718, 0x271a, 0x271c, 0x271e, 0x2720,
    0x2722, 0x2724, 0x2726, 0x2728, 0x272a, 0x272c, 0x272e, 0x2730,
    0x2732, 0x2734, 0x2736, 0x2738, 0x273a, 0x273c, 0x273e, 0x2740,
    0x2742, 0x2744, 0x2746, 0x2748, 0x274a, 0x274c, 0x274e, 0x2750,
    0x2752, 0x2754, 0x2756, 0x2758, 0x275a, 0x275c, 0x275e, 0x2760,
    0x2762, 0x2764, 0x2766, 0x2768, 0x276a, 0x276c, 0x276e, 0x2770,
    0x2772, 0x2774, 0x2776, 0x2778, 0x277a, 0x277c, 0x277e, 0x2780,
    0x2782, 0x2784, 0x2786, 0x2788, 0x278a, 0x278c, 0x278e, 0x2790,
    0x2792, 0x2794, 0x2796, 0x2798, 0x279a, 0x279c, 0x279e, 0x27a0,
    0x27a2, 0x27a4, 0x27a6, 0x27a8, 0x27aa, 0x27ac, 0x27ae, 0x27b0,
    0x27b2, 0x27b4, 0x27b6, 0x27b8, 0x27ba, 0x27bc, 0x27be, 0x27c0,
    0x27c2, 0x27c4, 0x27c6, 0x27c8, 0x27ca, 0x27cc, 0x27ce, 0x27d0,
    0x27d2, 0x27d4, 0x27d6, 0x27d8, 0x27da, 0x27dc, 0x27de, 0x27e0,
    0x27e2, 0x27e4, 0x27e6, 0x27e8, 0x27ea, 0x27ec, 0x27ee, 0x27f0,
    0x27f2, 0x27f4, 0x27f6, 0x27f8, 0x27fa, 0x27fc, 0x27fe, 0x2800,
    0x2802, 0x2804, 0x2806, 0x2808, 0x280a, 0x280c, 0x280e, 0x2810,
    0x2812, 0x2814, 0x2816, 0x2818, 0x281a, 0x281c, 0x281e, 0x2820,
    0x2822, 0x2824, 0x2826, 0x2828, 0x282a, 0x282c, 0x282e, 0x2830,
    0x2832, 0x2834, 0x2836, 0x2838, 0x283a, 0x283c, 0x283e, 0x2840,
    0x2842, 0x2844, 0x2846, 0x2848, 0x284a, 0x284c, 0x284e, 0x2850,
    0x2852, 0x2854, 0x2856, 0x2858, 0x285a, 0x285c, 0x285e, 0x2860,
    0x2862, 0x2864, 0x2866, 0x2868, 0x286a, 0x286c, 0x286e, 0x2870,
    0x2872, 0x2874, 0x2876, 0x2878, 0x287a, 0x287c, 0x287e, 0x2880,
    0x2882, 0x2884, 0x2886, 0x2888, 0x288a, 0x288c, 0x288e, 0xffff,
    0xffff, 0xffff, 0x2890, 0x2892, 0x2894, 0x2896, 0x2898, 0x289a,
    0xffff, 0xffff, 0x289c, 0x289e, 0x28a0, 0x28a2, 0x28a4, 0x28a6,
    0xffff, 0xffff, 0x28a8, 0x28aa, 0x28ac, 0x28ae, 0x28b0, 0x28b2,
    0xffff, 0xffff, 0x28b4, 0x28b6, 0x28b8, 0xffff, 0xffff, 0xffff,
    0x28ba, 0x28bc, 0x28be, 0x28c0, 0x28c2, 0x28c4, 0x28c6, 0xffff,
    0x28c8, 0x28ca, 0x28cc, 0x28ce, 0x28d0, 0x28d2, 0x28d4, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0x28d6, 0xffff, 0x28db, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0x28e0, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x28e5, 0x28ea,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0x28ef, 0x28f4, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0x28f9, 0x28fe, 0xffff, 0x2903, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0x2908, 0x290d, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x2912, 0x2917,
    0x291c, 0x2921, 0x2926, 0x292b, 0x2930, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0x2935, 0x293a, 0x293f, 0x2944, 0x2949,
    0x294e, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x2953, 0x2955, 0x2957, 0x2959, 0x295b, 0x295d, 0x295f, 0x2961,
    0x2963, 0x2965, 0x2967, 0x2969, 0x296b, 0x296d, 0x296f, 0x2971,
    0x2973, 0x2975, 0x2977, 0x2979, 0x297b, 0x297d, 0x297f, 0x2981,
    0x2983, 0x2985, 0x2987, 0x2989, 0x298b, 0x298d, 0x298f, 0x2991,
    0x2993, 0x2995, 0x2997, 0x2999, 0x299b, 0x299d, 0x299f, 0x29a1,
    0x29a3, 0x29a5, 0x29a7, 0x29a9, 0x29ab, 0x29ad, 0x29af, 0x29b1,
    0x29b3, 0x29b5, 0x29b7, 0x29b9, 0x29bb, 0x29bd, 0x29bf, 0x29c1,
    0x29c3, 0x29c5, 0x29c7, 0x29c9, 0x29cb, 0x29cd, 0x29cf, 0x29d1,
    0x29d3, 0x29d5, 0x29d7, 0x29d9, 0x29db, 0x29dd, 0x29df, 0x29e1,
    0x29e3, 0x29e5, 0x29e7, 0x29e9, 0x29eb, 0x29ed, 0x29ef, 0x29f1,
    0x29f3, 0x29f5, 0x29f7, 0x29f9, 0x29fb, 0xffff, 0x29fd, 0x29ff,
    0x2a01, 0x2a03, 0x2a05, 0x2a07, 0x2a09, 0x2a0b, 0x2a0d, 0x2a0f,
    0x2a11, 0x2a13, 0x2a15, 0x2a17, 0x2a19, 0x2a1b, 0x2a1d, 0x2a1f,
    0x2a21, 0x2a23, 0x2a25, 0x2a27, 0x2a29, 0x2a2b, 0x2a2d, 0x2a2f,
    0x2a31, 0x2a33, 0x2a35, 0x2a37, 0x2a39, 0x2a3b, 0x2a3d, 0x2a3f,
    0x2a41, 0x2a43, 0x2a45, 0x2a47, 0x2a49, 0x2a4b, 0x2a4d, 0x2a4f,
    0x2a51, 0x2a53, 0x2a55, 0x2a57, 0x2a59, 0x2a5b, 0x2a5d, 0x2a5f,
    0x2a61, 0x2a63, 0x2a65, 0x2a67, 0x2a69, 0x2a6b, 0x2a6d, 0x2a6f,
    0x2a71, 0x2a73, 0x2a75, 0x2a77, 0x2a79, 0x2a7b, 0x2a7d, 0x2a7f,
    0x2a81, 0x2a83, 0x2a85, 0x2a87, 0x2a89, 0xffff, 0x2a8b, 0x2a8d,
    0xffff, 0xffff, 0x2a8f, 0xffff, 0xffff, 0x2a91, 0x2a93, 0xffff,
    0xffff, 0x2a95, 0x2a97, 0x2a99, 0x2a9b, 0xffff, 0x2a9d, 0x2a9f,
    0x2aa1, 0x2aa3, 0x2aa5, 0x2aa7, 0x2aa9, 0x2aab, 0x2aad, 0x2aaf,
    0x2ab1, 0x2ab3, 0xffff, 0x2ab5, 0xffff, 0x2ab7, 0x2ab9, 0x2abb,
    0x2abd, 0x2abf, 0x2ac1, 0x2ac3, 0xffff, 0x2ac5, 0x2ac7, 0x2ac9,
    0x2acb, 0x2acd, 0x2acf, 0x2ad1, 0x2ad3, 0x2ad5, 0x2ad7, 0x2ad9,
    0x2adb, 0x2add, 0x2adf, 0x2ae1, 0x2ae3, 0x2ae5, 0x2ae7, 0x2ae9,
    0x2aeb, 0x2aed, 0x2aef, 0x2af1, 0x2af3, 0x2af5, 0x2af7, 0x2af9,
    0x2afb, 0x2afd, 0x2aff, 0x2b01, 0x2b03, 0x2b05, 0x2b07, 0x2b09,
    0x2b0b, 0x2b0d, 0x2b0f, 0x2b11, 0x2b13, 0x2b15, 0x2b17, 0x2b19,
    0x2b1b, 0x2b1d, 0x2b1f, 0x2b21, 0x2b23, 0x2b25, 0x2b27, 0x2b29,
    0x2b2b, 0x2b2d, 0x2b2f, 0x2b31, 0x2b33, 0x2b35, 0x2b37, 0x2b39,

    0x2b3b, 0x2b3d, 0x2b3f, 0x2b41, 0x2b43, 0x2b45, 0xffff, 0x2b47,
    0x2b49, 0x2b4b, 0x2b4d, 0xffff, 0xffff, 0x2b4f, 0x2b51, 0x2b53,
    0x2b55, 0x2b57, 0x2b59, 0x2b5b, 0x2b5d, 0xffff, 0x2b5f, 0x2b61,
    0x2b63, 0x2b65, 0x2b67, 0x2b69, 0x2b6b, 0xffff, 0x2b6d, 0x2b6f,
    0x2b71, 0x2b73, 0x2b75, 0x2b77, 0x2b79, 0x2b7b, 0x2b7d, 0x2b7f,
    0x2b81, 0x2b83, 0x2b85, 0x2b87, 0x2b89, 0x2b8b, 0x2b8d, 0x2b8f,
    0x2b91, 0x2b93, 0x2b95, 0x2b97, 0x2b99, 0x2b9b, 0x2b9d, 0x2b9f,
    0x2ba1, 0x2ba3, 0xffff, 0x2ba5, 0x2ba7, 0x2ba9, 0x2bab, 0xffff,
    0x2bad, 0x2baf, 0x2bb1, 0x2bb3, 0x2bb5, 0xffff, 0x2bb7, 0xffff,
    0xffff, 0xffff, 0x2bb9, 0x2bbb, 0x2bbd, 0x2bbf, 0x2bc1, 0x2bc3,
    0x2bc5, 0xffff, 0x2bc7, 0x2bc9, 0x2bcb, 0x2bcd, 0x2bcf, 0x2bd1,
    0x2bd3, 0x2bd5, 0x2bd7, 0x2bd9, 0x2bdb, 0x2bdd, 0x2bdf, 0x2be1,
    0x2be3, 0x2be5, 0x2be7, 0x2be9, 0x2beb, 0x2bed, 0x2bef, 0x2bf1,
    0x2bf3, 0x2bf5, 0x2bf7, 0x2bf9, 0x2bfb, 0x2bfd, 0x2bff, 0x2c01,
    0x2c03, 0x2c05, 0x2c07, 0x2c09, 0x2c0b, 0x2c0d, 0x2c0f, 0x2c11,
    0x2c13, 0x2c15, 0x2c17, 0x2c19, 0x2c1b, 0x2c1d, 0x2c1f, 0x2c21,
    0x2c23, 0x2c25, 0x2c27, 0x2c29, 0x2c2b, 0x2c2d, 0x2c2f, 0x2c31,
    0x2c33, 0x2c35, 0x2c37, 0x2c39, 0x2c3b, 0x2c3d, 0x2c3f, 0x2c41,
    0x2c43, 0x2c45, 0x2c47, 0x2c49, 0x2c4b, 0x2c4d, 0x2c4f, 0x2c51,
    0x2c53, 0x2c55, 0x2c57, 0x2c59, 0x2c5b, 0x2c5d, 0x2c5f, 0x2c61,
    0x2c63, 0x2c65, 0x2c67, 0x2c69, 0x2c6b, 0x2c6d, 0x2c6f, 0x2c71,
    0x2c73, 0x2c75, 0x2c77, 0x2c79, 0x2c7b, 0x2c7d, 0x2c7f, 0x2c81,
    0x2c83, 0x2c85, 0x2c87, 0x2c89, 0x2c8b, 0x2c8d, 0x2c8f, 0x2c91,
    0x2c93, 0x2c95, 0x2c97, 0x2c99, 0x2c9b, 0x2c9d, 0x2c9f, 0x2ca1,
    0x2ca3, 0x2ca5, 0x2ca7, 0x2ca9, 0x2cab, 0x2cad, 0x2caf, 0x2cb1,
    0x2cb3, 0x2cb5, 0x2cb7, 0x2cb9, 0x2cbb, 0x2cbd, 0x2cbf, 0x2cc1,
    0x2cc3, 0x2cc5, 0x2cc7, 0x2cc9, 0x2ccb, 0x2ccd, 0x2ccf, 0x2cd1,
    0x2cd3, 0x2cd5, 0x2cd7, 0x2cd9, 0x2cdb, 0x2cdd, 0x2cdf, 0x2ce1,
    0x2ce3, 0x2ce5, 0x2ce7, 0x2ce9, 0x2ceb, 0x2ced, 0x2cef, 0x2cf1,
    0x2cf3, 0x2cf5, 0x2cf7, 0x2cf9, 0x2cfb, 0x2cfd, 0x2cff, 0x2d01,
    0x2d03, 0x2d05, 0x2d07, 0x2d09, 0x2d0b, 0x2d0d, 0x2d0f, 0x2d11,
    0x2d13, 0x2d15, 0x2d17, 0x2d19, 0x2d1b, 0x2d1d, 0x2d1f, 0x2d21,

    0x2d23, 0x2d25, 0x2d27, 0x2d29, 0x2d2b, 0x2d2d, 0x2d2f, 0x2d31,
    0x2d33, 0x2d35, 0x2d37, 0x2d39, 0x2d3b, 0x2d3d, 0x2d3f, 0x2d41,
    0x2d43, 0x2d45, 0x2d47, 0x2d49, 0x2d4b, 0x2d4d, 0x2d4f, 0x2d51,
    0x2d53, 0x2d55, 0x2d57, 0x2d59, 0x2d5b, 0x2d5d, 0x2d5f, 0x2d61,
    0x2d63, 0x2d65, 0x2d67, 0x2d69, 0x2d6b, 0x2d6d, 0x2d6f, 0x2d71,
    0x2d73, 0x2d75, 0x2d77, 0x2d79, 0x2d7b, 0x2d7d, 0x2d7f, 0x2d81,
    0x2d83, 0x2d85, 0x2d87, 0x2d89, 0x2d8b, 0x2d8d, 0x2d8f, 0x2d91,
    0x2d93, 0x2d95, 0x2d97, 0x2d99, 0x2d9b, 0x2d9d, 0x2d9f, 0x2da1,
    0x2da3, 0x2da5, 0x2da7, 0x2da9, 0x2dab, 0x2dad, 0x2daf, 0x2db1,
    0x2db3, 0x2db5, 0x2db7, 0x2db9, 0x2dbb, 0x2dbd, 0x2dbf, 0x2dc1,
    0x2dc3, 0x2dc5, 0x2dc7, 0x2dc9, 0x2dcb, 0x2dcd, 0x2dcf, 0x2dd1,
    0x2dd3, 0x2dd5, 0x2dd7, 0x2dd9, 0x2ddb, 0x2ddd, 0x2ddf, 0x2de1,
    0x2de3, 0x2de5, 0x2de7, 0x2de9, 0x2deb, 0x2ded, 0x2def, 0x2df1,
    0x2df3, 0x2df5, 0x2df7, 0x2df9, 0x2dfb, 0x2dfd, 0x2dff, 0x2e01,
    0x2e03, 0x2e05, 0x2e07, 0x2e09, 0x2e0b, 0x2e0d, 0x2e0f, 0x2e11,
    0x2e13, 0x2e15, 0x2e17, 0x2e19, 0x2e1b, 0x2e1d, 0x2e1f, 0x2e21,
    0x2e23, 0x2e25, 0x2e27, 0x2e29, 0x2e2b, 0x2e2d, 0x2e2f, 0x2e31,
    0x2e33, 0x2e35, 0x2e37, 0x2e39, 0x2e3b, 0x2e3d, 0x2e3f, 0x2e41,
    0x2e43, 0x2e45, 0x2e47, 0x2e49, 0x2e4b, 0x2e4d, 0x2e4f, 0x2e51,
    0x2e53, 0x2e55, 0x2e57, 0x2e59, 0x2e5b, 0x2e5d, 0x2e5f, 0x2e61,
    0x2e63, 0x2e65, 0x2e67, 0x2e69, 0x2e6b, 0x2e6d, 0xffff, 0xffff,
    0x2e6f, 0x2e71, 0x2e73, 0x2e75, 0x2e77, 0x2e79, 0x2e7b, 0x2e7d,
    0x2e7f, 0x2e81, 0x2e83, 0x2e85, 0x2e87, 0x2e89, 0x2e8b, 0x2e8d,
    0x2e8f, 0x2e91, 0x2e93, 0x2e95, 0x2e97, 0x2e99, 0x2e9b, 0x2e9d,
    0x2e9f, 0x2ea1, 0x2ea3, 0x2ea5, 0x2ea7, 0x2ea9, 0x2eab, 0x2ead,
    0x2eaf, 0x2eb1, 0x2eb3, 0x2eb5, 0x2eb7, 0x2eb9, 0x2ebb, 0x2ebd,
    0x2ebf, 0x2ec1, 0x2ec3, 0x2ec5, 0x2ec7, 0x2ec9, 0x2ecb, 0x2ecd,
    0x2ecf, 0x2ed1, 0x2ed3, 0x2ed5, 0x2ed7, 0x2ed9, 0x2edb, 0x2edd,
    0x2edf, 0x2ee1, 0x2ee3, 0x2ee5, 0x2ee7, 0x2ee9, 0x2eeb, 0x2eed,
    0x2eef, 0x2ef1, 0x2ef3, 0x2ef5, 0x2ef7, 0x2ef9, 0x2efb, 0x2efd,
    0x2eff, 0x2f01, 0x2f03, 0x2f05, 0x2f07, 0x2f09, 0x2f0b, 0x2f0d,
    0x2f0f, 0x2f11, 0x2f13, 0x2f15, 0x2f17, 0x2f19, 0x2f1b, 0x2f1d,

    0x2f1f, 0x2f21, 0x2f23, 0x2f25, 0x2f27, 0x2f29, 0x2f2b, 0x2f2d,
    0x2f2f, 0x2f31, 0x2f33, 0x2f35, 0x2f37, 0x2f39, 0x2f3b, 0x2f3d,
    0x2f3f, 0x2f41, 0x2f43, 0x2f45, 0x2f47, 0x2f49, 0x2f4b, 0x2f4d,
    0x2f4f, 0x2f51, 0x2f53, 0x2f55, 0x2f57, 0x2f59, 0x2f5b, 0x2f5d,
    0x2f5f, 0x2f61, 0x2f63, 0x2f65, 0x2f67, 0x2f69, 0x2f6b, 0x2f6d,
    0x2f6f, 0x2f71, 0x2f73, 0x2f75, 0x2f77, 0x2f79, 0x2f7b, 0x2f7d,
    0x2f7f, 0x2f81, 0x2f83, 0x2f85, 0x2f87, 0x2f89, 0x2f8b, 0x2f8d,
    0x2f8f, 0x2f91, 0x2f93, 0x2f95, 0x2f97, 0x2f99, 0x2f9b, 0x2f9d,
    0x2f9f, 0x2fa1, 0x2fa3, 0x2fa5, 0x2fa7, 0x2fa9, 0x2fab, 0x2fad,
    0x2faf, 0x2fb1, 0x2fb3, 0x2fb5, 0x2fb7, 0x2fb9, 0x2fbb, 0x2fbd,
    0x2fbf, 0x2fc1, 0x2fc3, 0x2fc5, 0x2fc7, 0x2fc9, 0x2fcb, 0x2fcd,
    0x2fcf, 0x2fd1, 0x2fd3, 0x2fd5, 0x2fd7, 0x2fd9, 0x2fdb, 0x2fdd,
    0x2fdf, 0x2fe1, 0x2fe3, 0x2fe5, 0x2fe7, 0x2fe9, 0x2feb, 0x2fed,
    0x2fef, 0x2ff1, 0x2ff3, 0x2ff5, 0x2ff7, 0x2ff9, 0x2ffb, 0x2ffd,
    0x2fff, 0x3001, 0x3003, 0x3005, 0x3007, 0x3009, 0x300b, 0x300d,
    0x300f, 0x3011, 0x3013, 0x3015, 0x3017, 0x3019, 0x301b, 0x301d,
    0x301f, 0x3021, 0x3023, 0x3025, 0x3027, 0x3029, 0x302b, 0x302d,
    0x302f, 0x3031, 0x3033, 0x3035, 0x3037, 0x3039, 0x303b, 0x303d,
    0x303f, 0x3041, 0x3043, 0x3045, 0x3047, 0x3049, 0x304b, 0x304d,
    0x304f, 0x3051, 0x3053, 0x3055, 0x3057, 0x3059, 0x305b, 0x305d,
    0x305f, 0x3061, 0x3063, 0x3065, 0x3067, 0x3069, 0x306b, 0x306d,
    0x306f, 0x3071, 0x3073, 0x3075, 0x3077, 0x3079, 0x307b, 0x307d,
    0x307f, 0x3081, 0x3083, 0x3085, 0x3087, 0x3089, 0x308b, 0x308d,
    0x308f, 0x3091, 0x3093, 0x3095, 0x3097, 0x3099, 0x309b, 0x309d,
    0x309f, 0x30a1, 0x30a3, 0x30a5, 0x30a7, 0x30a9, 0x30ab, 0x30ad,
    0x30af, 0x30b1, 0x30b3, 0x30b5, 0xffff, 0xffff, 0x30b7, 0x30b9,
    0x30bb, 0x30bd, 0x30bf, 0x30c1, 0x30c3, 0x30c5, 0x30c7, 0x30c9,
    0x30cb, 0x30cd, 0x30cf, 0x30d1, 0x30d3, 0x30d5, 0x30d7, 0x30d9,
    0x30db, 0x30dd, 0x30df, 0x30e1, 0x30e3, 0x30e5, 0x30e7, 0x30e9,
    0x30eb, 0x30ed, 0x30ef, 0x30f1, 0x30f3, 0x30f5, 0x30f7, 0x30f9,
    0x30fb, 0x30fd, 0x30ff, 0x3101, 0x3103, 0x3105, 0x3107, 0x3109,
    0x310b, 0x310d, 0x310f, 0x3111, 0x3113, 0x3115, 0x3117, 0x3119,

    0x311b, 0x311d, 0x311f, 0x3121, 0xffff, 0x3123, 0x3125, 0x3127,
    0x3129, 0x312b, 0x312d, 0x312f, 0x3131, 0x3133, 0x3135, 0x3137,
    0x3139, 0x313b, 0x313d, 0x313f, 0x3141, 0x3143, 0x3145, 0x3147,
    0x3149, 0x314b, 0x314d, 0x314f, 0x3151, 0x3153, 0x3155, 0x3157,
    0xffff, 0x3159, 0x315b, 0xffff, 0x315d, 0xffff, 0xffff, 0x315f,
    0xffff, 0x3161, 0x3163, 0x3165, 0x3167, 0x3169, 0x316b, 0x316d,
    0x316f, 0x3171, 0x3173, 0xffff, 0x3175, 0x3177, 0x3179, 0x317b,
    0xffff, 0x317d, 0xffff, 0x317f, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0x3181, 0xffff, 0xffff, 0xffff, 0xffff, 0x3183,
    0xffff, 0x3185, 0xffff, 0x3187, 0xffff, 0x3189, 0x318b, 0x318d,
    0xffff, 0x318f, 0x3191, 0xffff, 0x3193, 0xffff, 0xffff, 0x3195,
    0xffff, 0x3197, 0xffff, 0x3199, 0xffff, 0x319b, 0xffff, 0x319d,
    0xffff, 0x319f, 0x31a1, 0xffff, 0x31a3, 0xffff, 0xffff, 0x31a5,
    0x31a7, 0x31a9, 0x31ab, 0xffff, 0x31ad, 0x31af, 0x31b1, 0x31b3,
    0x31b5, 0x31b7, 0x31b9, 0xffff, 0x31bb, 0x31bd, 0x31bf, 0x31c1,
    0xffff, 0x31c3, 0x31c5, 0x31c7, 0x31c9, 0xffff, 0x31cb, 0xffff,
    0x31cd, 0x31cf, 0x31d1, 0x31d3, 0x31d5, 0x31d7, 0x31d9, 0x31db,
    0x31dd, 0x31df, 0xffff, 0x31e1, 0x31e3, 0x31e5, 0x31e7, 0x31e9,
    0x31eb, 0x31ed, 0x31ef, 0x31f1, 0x31f3, 0x31f5, 0x31f7, 0x31f9,
    0x31fb, 0x31fd, 0x31ff, 0x3201, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0x3203, 0x3205, 0x3207, 0xffff, 0x3209, 0x320b, 0x320d,
    0x320f, 0x3211, 0xffff, 0x3213, 0x3215, 0x3217, 0x3219, 0x321b,
    0x321d, 0x321f, 0x3221, 0x3223, 0x3225, 0x3227, 0x3229, 0x322b,
    0x322d, 0x322f, 0x3231, 0x3233, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x3235, 0x3238, 0x323b, 0x323e, 0x3241, 0x3244, 0x3247, 0x324a,
    0x324d, 0x3250, 0x3253, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x3256, 0x325a, 0x325e, 0x3262, 0x3266, 0x326a, 0x326e, 0x3272,
    0x3276, 0x327a, 0x327e, 0x3282, 0x3286, 0x328a, 0x328e, 0x3292,
    0x3296, 0x329a, 0x329e, 0x32a2, 0x32a6, 0x32aa, 0x32ae, 0x32b2,
    0x32b6, 0x32ba, 0x32be, 0x32c2, 0x32c4, 0x32c6, 0x32c9, 0xffff,
    0x32cc, 0x32ce, 0x32d0, 0x32d2, 0x32d4, 0x32d6, 0x32d8, 0x32da,
    0x32dc, 0x32de, 0x32e0, 0x32e2, 0x32e4, 0x32e6, 0x32e8, 0x32ea,
    0x32ec, 0x32ee, 0x32f0, 0x32f2, 0x32f4, 0x32f6, 0x32f8, 0x32fa,
    0x32fc, 0x32fe, 0x3300, 0x3303, 0x3306, 0x3309, 0x330c, 0x3310,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0x3313, 0x3316, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x3319, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x331c, 0x331f, 0x3322, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x3324, 0x3326, 0x3328, 0x332a, 0x332c, 0x332e, 0x3330, 0x3332,
    0x3334, 0x3336, 0x3338, 0x333a, 0x333c, 0x333e, 0x3340, 0x3342,
    0x3344, 0x3346, 0x3348, 0x334a, 0x334c, 0x334e, 0x3350, 0x3352,
    0x3354, 0x3356, 0x3358, 0x335a, 0x335c, 0x335e, 0x3360, 0x3362,
    0x3364, 0x3366, 0x3368, 0x336a, 0x336c, 0x336e, 0x3370, 0x3372,
    0x3374, 0x3376, 0x3378, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x337a, 0x337e, 0x3382, 0x3386, 0x338a, 0x338e, 0x3392, 0x3396,
    0x339a, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x339e, 0x33a0, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x33a2, 0x33a4, 0x33a6, 0x33a8, 0x33ab, 0x33ad, 0x33af, 0x33b1,
    0x33b3, 0x33b5, 0x33b7, 0x33b9, 0x33bb, 0x33bd, 0x33c0, 0x33c2,
    0x33c4, 0x33c6, 0x33c8, 0x33cb, 0x33cd, 0x33cf, 0x33d1, 0x33d4,
    0x33d6, 0x33d8, 0x33da, 0x33dc, 0x33de, 0x33e1, 0x33e3, 0x33e5,
    0x33e7, 0x33e9, 0x33eb, 0x33ed, 0x33ef, 0x33f1, 0x33f3, 0x33f5,
    0x33f7, 0x33f9, 0x33fb, 0x33fd, 0x33ff, 0x3401, 0x3403, 0x3405,
    0x3407, 0x3409, 0x340b, 0x340d, 0x340f, 0x3412, 0x3414, 0x3416,
    0x3418, 0x341b, 0x341d, 0x341f, 0x3421, 0x3423, 0x3425, 0x3427,
    0x3429, 0x342b, 0x342d, 0x342f, 0x3431, 0x3433, 0x3435, 0x3437,
    0x3439, 0x343b, 0x343d, 0x343f, 0x3441, 0x3443, 0x3445, 0x3447,
    0x3449, 0x344b, 0x344d, 0x344f, 0x3451, 0x3453, 0x3455, 0x3457,
    0x3459, 0x345b, 0x345e, 0x3460, 0x3462, 0x3464, 0x3466, 0x3468,
    0x346a, 0x346d, 0x3470, 0x3472, 0x3474, 0x3476, 0x3478, 0x347a,
    0x347c, 0x347e, 0x3480, 0x3482, 0x3484, 0x3487, 0x3489, 0x348b,
    0x348d, 0x348f, 0x3492, 0x3494, 0x3496, 0x3498, 0x349a, 0x349c,
    0x349e, 0x34a0, 0x34a2, 0x34a4, 0x34a7, 0x34a9, 0x34ac, 0x34ae,
    0x34b0, 0x34b2, 0x34b4, 0x34b6, 0x34b8, 0x34ba, 0x34bc, 0x34be,
    0x34c0, 0x34c2, 0x34c5, 0x34c7, 0x34c9, 0x34cb, 0x34cd, 0x34cf,
    0x34d2, 0x34d4, 0x34d7, 0x34da, 0x34dc, 0x34de, 0x34e0, 0x34e2,
    0x34e5, 0x34e8, 0x34ea, 0x34ec, 0x34ee, 0x34f0, 0x34f2, 0x34f4,
    0x34f6, 0x34f8, 0x34fa, 0x34fc, 0x34fe, 0x3501, 0x3503, 0x3505,
    0x3507, 0x3509, 0x350b, 0x350d, 0x350f, 0x3511, 0x3513, 0x3515,
    0x3517, 0x3519, 0x351b, 0x351d, 0x351f, 0x3521, 0x3523, 0x3525,
    0x3527, 0x352a, 0x352c, 0x352e, 0x3530, 0x3532, 0x3534, 0x3537,
    0x3539, 0x353b, 0x353d, 0x353f, 0x3541, 0x3543, 0x3545, 0x3547,
    0x3549, 0x354b, 0x354d, 0x3550, 0x3552, 0x3554, 0x3556, 0x3558,
    0x355a, 0x355c, 0x355e, 0x3560, 0x3562, 0x3564, 0x3566, 0x3568,
    0x356a, 0x356c, 0x356e, 0x3570, 0x3572, 0x3574, 0x3577, 0x3579,
    0x357b, 0x357d, 0x357f, 0x3581, 0x3584, 0x3586, 0x3588, 0x358a,
    0x358c, 0x358e, 0x3590, 0x3592, 0x3594, 0x3597, 0x3599, 0x359b,
    0x359d, 0x35a0, 0x35a2, 0x35a4, 0x35a6, 0x35a8, 0x35aa, 0x35ac,
    0x35af, 0x35b2, 0x35b5, 0x35b7, 0x35ba, 0x35bc, 0x35be, 0x35c0,

    0x35c2, 0x35c4, 0x35c6, 0x35c8, 0x35ca, 0x35cc, 0x35ce, 0x35d1,
    0x35d3, 0x35d5, 0x35d7, 0x35d9, 0x35db, 0x35dd, 0x35e0, 0x35e2,
    0x35e4, 0x35e7, 0x35ea, 0x35ec, 0x35ee, 0x35f0, 0x35f2, 0x35f4,
    0x35f6, 0x35f8, 0x35fa, 0x35fc, 0x35ff, 0x3601, 0x3604, 0x3606,
    0x3609, 0x360b, 0x360d, 0x360f, 0x3612, 0x3614, 0x3616, 0x3619,
    0x361c, 0x361e, 0x3620, 0x3622, 0x3624, 0x3626, 0x3628, 0x362a,
    0x362c, 0x362e, 0x3630, 0x3632, 0x3634, 0x3636, 0x3639, 0x363b,
    0x363e, 0x3640, 0x3643, 0x3645, 0x3648, 0x364b, 0x364e, 0x3650,
    0x3652, 0x3654, 0x3657, 0x365a, 0x365d, 0x3660, 0x3662, 0x3664,
    0x3666, 0x3668, 0x366a, 0x366c, 0x366e, 0x3670, 0x3673, 0x3675,
    0x3677, 0x3679, 0x367b, 0x367e, 0x3680, 0x3683, 0x3686, 0x3688,
    0x368a, 0x368c, 0x368e, 0x3690, 0x3692, 0x3695, 0x3698, 0x369b,
    0x369d, 0x369f, 0x36a2, 0x36a4, 0x36a6, 0x36a8, 0x36ab, 0x36ad,
    0x36af, 0x36b1, 0x36b3, 0x36b5, 0x36b8, 0x36ba, 0x36bc, 0x36be,
    0x36c0, 0x36c2, 0x36c4, 0x36c7, 0x36ca, 0x36cc, 0x36cf, 0x36d1,
    0x36d4, 0x36d6, 0x36d8, 0x36da, 0x36dd, 0x36e0, 0x36e2, 0x36e5,
    0x36e7, 0x36ea, 0x36ec, 0x36ee, 0x36f0, 0x36f2, 0x36f4, 0x36f6,
    0x36f9, 0x36fc, 0x36ff, 0x3702, 0x3704, 0x3706, 0x3708, 0x370a,
    0x370c, 0x370e, 0x3710, 0x3712, 0x3714, 0x3716, 0x3718, 0x371a,
    0x371d, 0x371f, 0x3721, 0x3723, 0x3725, 0x3727, 0x3729, 0x372b,
    0x372d, 0x372f, 0x3731, 0x3733, 0x3735, 0x3738, 0x373b, 0x373e,
    0x3740, 0x3742, 0x3744, 0x3746, 0x3749, 0x374b, 0x374e, 0x3750,
    0x3752, 0x3755, 0x3758, 0x375a, 0x375c, 0x375e, 0x3760, 0x3762,
    0x3764, 0x3766, 0x3768, 0x376a, 0x376c, 0x376e, 0x3770, 0x3772,
    0x3774, 0x3776, 0x3778, 0x377a, 0x377c, 0x377e, 0x3781, 0x3783,
    0x3785, 0x3787, 0x3789, 0x378b, 0x378e, 0x3791, 0x3793, 0x3795,
    0x3797, 0x3799, 0x379b, 0x379d, 0x37a0, 0x37a2, 0x37a4, 0x37a6,
    0x37a8, 0x37ab, 0x37ae, 0x37b0, 0x37b2, 0x37b4, 0x37b7, 0x37b9,
    0x37bb, 0x37be, 0x37c1, 0x37c3, 0x37c5, 0x37c7, 0x37ca, 0x37cc,
    0x37ce, 0x37d0, 0x37d2, 0x37d4, 0x37d6, 0x37d8, 0x37db, 0x37dd,
    0x37df, 0x37e1, 0x37e4, 0x37e6, 0x37e8, 0x37ea, 0x37ec, 0x37ef,
    0x37f2, 0x37f4, 0x37f6, 0x37f8, 0x37fb, 0x37fd, 0x3800, 0x3802,

    0x3804, 0x3806, 0x3809, 0x380b, 0x380d, 0x380f, 0x3811, 0x3813,
    0x3815, 0x3817, 0x381a, 0x381c, 0x381e, 0x3820, 0x3822, 0x3824,
    0x3826, 0x3829, 0x382b, 0x382e, 0x3831, 0x3834, 0x3836, 0x3838,
    0x383a, 0x383c, 0x383e, 0x3840, 0x3842, 0x3844, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff
};

#define GET_DECOMPOSITION_INDEX(ucs4) \
       (ucs4 < 0x3400 \
        ? (uc_decomposition_trie[uc_decomposition_trie[ucs4>>4] + (ucs4 & 0xf)]) \
        : (ucs4 < 0x30000 \
           ? uc_decomposition_trie[uc_decomposition_trie[((ucs4 - 0x3400)>>8) + 0x340] + (ucs4 & 0xff)] \
           : 0xffff))

static const unsigned short uc_decomposition_map[] = {
    0x103, 0x20, 0x210, 0x20, 0x308, 0x109, 0x61, 0x210,
    0x20, 0x304, 0x109, 0x32, 0x109, 0x33, 0x210, 0x20,
    0x301, 0x110, 0x3bc, 0x210, 0x20, 0x327, 0x109, 0x31,
    0x109, 0x6f, 0x311, 0x31, 0x2044, 0x34, 0x311, 0x31,
    0x2044, 0x32, 0x311, 0x33, 0x2044, 0x34, 0x201, 0x41,
    0x300, 0x201, 0x41, 0x301, 0x201, 0x41, 0x302, 0x201,
    0x41, 0x303, 0x201, 0x41, 0x308, 0x201, 0x41, 0x30a,
    0x201, 0x43, 0x327, 0x201, 0x45, 0x300, 0x201, 0x45,
    0x301, 0x201, 0x45, 0x302, 0x201, 0x45, 0x308, 0x201,
    0x49, 0x300, 0x201, 0x49, 0x301, 0x201, 0x49, 0x302,
    0x201, 0x49, 0x308, 0x201, 0x4e, 0x303, 0x201, 0x4f,
    0x300, 0x201, 0x4f, 0x301, 0x201, 0x4f, 0x302, 0x201,
    0x4f, 0x303, 0x201, 0x4f, 0x308, 0x201, 0x55, 0x300,
    0x201, 0x55, 0x301, 0x201, 0x55, 0x302, 0x201, 0x55,
    0x308, 0x201, 0x59, 0x301, 0x201, 0x61, 0x300, 0x201,
    0x61, 0x301, 0x201, 0x61, 0x302, 0x201, 0x61, 0x303,
    0x201, 0x61, 0x308, 0x201, 0x61, 0x30a, 0x201, 0x63,
    0x327, 0x201, 0x65, 0x300, 0x201, 0x65, 0x301, 0x201,
    0x65, 0x302, 0x201, 0x65, 0x308, 0x201, 0x69, 0x300,
    0x201, 0x69, 0x301, 0x201, 0x69, 0x302, 0x201, 0x69,
    0x308, 0x201, 0x6e, 0x303, 0x201, 0x6f, 0x300, 0x201,
    0x6f, 0x301, 0x201, 0x6f, 0x302, 0x201, 0x6f, 0x303,
    0x201, 0x6f, 0x308, 0x201, 0x75, 0x300, 0x201, 0x75,
    0x301, 0x201, 0x75, 0x302, 0x201, 0x75, 0x308, 0x201,
    0x79, 0x301, 0x201, 0x79, 0x308, 0x201, 0x41, 0x304,
    0x201, 0x61, 0x304, 0x201, 0x41, 0x306, 0x201, 0x61,
    0x306, 0x201, 0x41, 0x328, 0x201, 0x61, 0x328, 0x201,
    0x43, 0x301, 0x201, 0x63, 0x301, 0x201, 0x43, 0x302,
    0x201, 0x63, 0x302, 0x201, 0x43, 0x307, 0x201, 0x63,
    0x307, 0x201, 0x43, 0x30c, 0x201, 0x63, 0x30c, 0x201,
    0x44, 0x30c, 0x201, 0x64, 0x30c, 0x201, 0x45, 0x304,
    0x201, 0x65, 0x304, 0x201, 0x45, 0x306, 0x201, 0x65,
    0x306, 0x201, 0x45, 0x307, 0x201, 0x65, 0x307, 0x201,
    0x45, 0x328, 0x201, 0x65, 0x328, 0x201, 0x45, 0x30c,
    0x201, 0x65, 0x30c, 0x201, 0x47, 0x302, 0x201, 0x67,
    0x302, 0x201, 0x47, 0x306, 0x201, 0x67, 0x306, 0x201,
    0x47, 0x307, 0x201, 0x67, 0x307, 0x201, 0x47, 0x327,
    0x201, 0x67, 0x327, 0x201, 0x48, 0x302, 0x201, 0x68,
    0x302, 0x201, 0x49, 0x303, 0x201, 0x69, 0x303, 0x201,
    0x49, 0x304, 0x201, 0x69, 0x304, 0x201, 0x49, 0x306,
    0x201, 0x69, 0x306, 0x201, 0x49, 0x328, 0x201, 0x69,
    0x328, 0x201, 0x49, 0x307, 0x210, 0x49, 0x4a, 0x210,
    0x69, 0x6a, 0x201, 0x4a, 0x302, 0x201, 0x6a, 0x302,
    0x201, 0x4b, 0x327, 0x201, 0x6b, 0x327, 0x201, 0x4c,
    0x301, 0x201, 0x6c, 0x301, 0x201, 0x4c, 0x327, 0x201,
    0x6c, 0x327, 0x201, 0x4c, 0x30c, 0x201, 0x6c, 0x30c,
    0x210, 0x4c, 0xb7, 0x210, 0x6c, 0xb7, 0x201, 0x4e,
    0x301, 0x201, 0x6e, 0x301, 0x201, 0x4e, 0x327, 0x201,
    0x6e, 0x327, 0x201, 0x4e, 0x30c, 0x201, 0x6e, 0x30c,
    0x210, 0x2bc, 0x6e, 0x201, 0x4f, 0x304, 0x201, 0x6f,
    0x304, 0x201, 0x4f, 0x306, 0x201, 0x6f, 0x306, 0x201,
    0x4f, 0x30b, 0x201, 0x6f, 0x30b, 0x201, 0x52, 0x301,
    0x201, 0x72, 0x301, 0x201, 0x52, 0x327, 0x201, 0x72,
    0x327, 0x201, 0x52, 0x30c, 0x201, 0x72, 0x30c, 0x201,
    0x53, 0x301, 0x201, 0x73, 0x301, 0x201, 0x53, 0x302,
    0x201, 0x73, 0x302, 0x201, 0x53, 0x327, 0x201, 0x73,
    0x327, 0x201, 0x53, 0x30c, 0x201, 0x73, 0x30c, 0x201,
    0x54, 0x327, 0x201, 0x74, 0x327, 0x201, 0x54, 0x30c,
    0x201, 0x74, 0x30c, 0x201, 0x55, 0x303, 0x201, 0x75,
    0x303, 0x201, 0x55, 0x304, 0x201, 0x75, 0x304, 0x201,
    0x55, 0x306, 0x201, 0x75, 0x306, 0x201, 0x55, 0x30a,
    0x201, 0x75, 0x30a, 0x201, 0x55, 0x30b, 0x201, 0x75,
    0x30b, 0x201, 0x55, 0x328, 0x201, 0x75, 0x328, 0x201,
    0x57, 0x302, 0x201, 0x77, 0x302, 0x201, 0x59, 0x302,
    0x201, 0x79, 0x302, 0x201, 0x59, 0x308, 0x201, 0x5a,
    0x301, 0x201, 0x7a, 0x301, 0x201, 0x5a, 0x307, 0x201,
    0x7a, 0x307, 0x201, 0x5a, 0x30c, 0x201, 0x7a, 0x30c,
    0x110, 0x73, 0x201, 0x4f, 0x31b, 0x201, 0x6f, 0x31b,
    0x201, 0x55, 0x31b, 0x201, 0x75, 0x31b, 0x210, 0x44,
    0x17d, 0x210, 0x44, 0x17e, 0x210, 0x64, 0x17e, 0x210,
    0x4c, 0x4a, 0x210, 0x4c, 0x6a, 0x210, 0x6c, 0x6a,
    0x210, 0x4e, 0x4a, 0x210, 0x4e, 0x6a, 0x210, 0x6e,
    0x6a, 0x201, 0x41, 0x30c, 0x201, 0x61, 0x30c, 0x201,
    0x49, 0x30c, 0x201, 0x69, 0x30c, 0x201, 0x4f, 0x30c,
    0x201, 0x6f, 0x30c, 0x201, 0x55, 0x30c, 0x201, 0x75,
    0x30c, 0x201, 0xdc, 0x304, 0x201, 0xfc, 0x304, 0x201,
    0xdc, 0x301, 0x201, 0xfc, 0x301, 0x201, 0xdc, 0x30c,
    0x201, 0xfc, 0x30c, 0x201, 0xdc, 0x300, 0x201, 0xfc,
    0x300, 0x201, 0xc4, 0x304, 0x201, 0xe4, 0x304, 0x201,
    0x226, 0x304, 0x201, 0x227, 0x304, 0x201, 0xc6, 0x304,
    0x201, 0xe6, 0x304, 0x201, 0x47, 0x30c, 0x201, 0x67,
    0x30c, 0x201, 0x4b, 0x30c, 0x201, 0x6b, 0x30c, 0x201,
    0x4f, 0x328, 0x201, 0x6f, 0x328, 0x201, 0x1ea, 0x304,
    0x201, 0x1eb, 0x304, 0x201, 0x1b7, 0x30c, 0x201, 0x292,
    0x30c, 0x201, 0x6a, 0x30c, 0x210, 0x44, 0x5a, 0x210,
    0x44, 0x7a, 0x210, 0x64, 0x7a, 0x201, 0x47, 0x301,
    0x201, 0x67, 0x301, 0x201, 0x4e, 0x300, 0x201, 0x6e,
    0x300, 0x201, 0xc5, 0x301, 0x201, 0xe5, 0x301, 0x201,
    0xc6, 0x301, 0x201, 0xe6, 0x301, 0x201, 0xd8, 0x301,
    0x201, 0xf8, 0x301, 0x201, 0x41, 0x30f, 0x201, 0x61,
    0x30f, 0x201, 0x41, 0x311, 0x201, 0x61, 0x311, 0x201,
    0x45, 0x30f, 0x201, 0x65, 0x30f, 0x201, 0x45, 0x311,
    0x201, 0x65, 0x311, 0x201, 0x49, 0x30f, 0x201, 0x69,
    0x30f, 0x201, 0x49, 0x311, 0x201, 0x69, 0x311, 0x201,
    0x4f, 0x30f, 0x201, 0x6f, 0x30f, 0x201, 0x4f, 0x311,
    0x201, 0x6f, 0x311, 0x201, 0x52, 0x30f, 0x201, 0x72,
    0x30f, 0x201, 0x52, 0x311, 0x201, 0x72, 0x311, 0x201,
    0x55, 0x30f, 0x201, 0x75, 0x30f, 0x201, 0x55, 0x311,
    0x201, 0x75, 0x311, 0x201, 0x53, 0x326, 0x201, 0x73,
    0x326, 0x201, 0x54, 0x326, 0x201, 0x74, 0x326, 0x201,
    0x48, 0x30c, 0x201, 0x68, 0x30c, 0x201, 0x41, 0x307,
    0x201, 0x61, 0x307, 0x201, 0x45, 0x327, 0x201, 0x65,
    0x327, 0x201, 0xd6, 0x304, 0x201, 0xf6, 0x304, 0x201,
    0xd5, 0x304, 0x201, 0xf5, 0x304, 0x201, 0x4f, 0x307,
    0x201, 0x6f, 0x307, 0x201, 0x22e, 0x304, 0x201, 0x22f,
    0x304, 0x201, 0x59, 0x304, 0x201, 0x79, 0x304, 0x109,
    0x68, 0x109, 0x266, 0x109, 0x6a, 0x109, 0x72, 0x109,
    0x279, 0x109, 0x27b, 0x109, 0x281, 0x109, 0x77, 0x109,
    0x79, 0x210, 0x20, 0x306, 0x210, 0x20, 0x307, 0x210,
    0x20, 0x30a, 0x210, 0x20, 0x328, 0x210, 0x20, 0x303,
    0x210, 0x20, 0x30b, 0x109, 0x263, 0x109, 0x6c, 0x109,
    0x73, 0x109, 0x78, 0x109, 0x295, 0x101, 0x300, 0x101,
    0x301, 0x101, 0x313, 0x201, 0x308, 0x301, 0x101, 0x2b9,
    0x210, 0x20, 0x345, 0x101, 0x3b, 0x210, 0x20, 0x301,
    0x201, 0xa8, 0x301, 0x201, 0x391, 0x301, 0x101, 0xb7,
    0x201, 0x395, 0x301, 0x201, 0x397, 0x301, 0x201, 0x399,
    0x301, 0x201, 0x39f, 0x301, 0x201, 0x3a5, 0x301, 0x201,
    0x3a9, 0x301, 0x201, 0x3ca, 0x301, 0x201, 0x399, 0x308,
    0x201, 0x3a5, 0x308, 0x201, 0x3b1, 0x301, 0x201, 0x3b5,
    0x301, 0x201, 0x3b7, 0x301, 0x201, 0x3b9, 0x301, 0x201,
    0x3cb, 0x301, 0x201, 0x3b9, 0x308, 0x201, 0x3c5, 0x308,
    0x201, 0x3bf, 0x301, 0x201, 0x3c5, 0x301, 0x201, 0x3c9,
    0x301, 0x110, 0x3b2, 0x110, 0x3b8, 0x110, 0x3a5, 0x201,
    0x3d2, 0x301, 0x201, 0x3d2, 0x308, 0x110, 0x3c6, 0x110,
    0x3c0, 0x110, 0x3ba, 0x110, 0x3c1, 0x110, 0x3c2, 0x110,
    0x398, 0x110, 0x3b5, 0x110, 0x3a3, 0x201, 0x415, 0x300,
    0x201, 0x415, 0x308, 0x201, 0x413, 0x301, 0x201, 0x406,
    0x308, 0x201, 0x41a, 0x301, 0x201, 0x418, 0x300, 0x201,
    0x423, 0x306, 0x201, 0x418, 0x306, 0x201, 0x438, 0x306,
    0x201, 0x435, 0x300, 0x201, 0x435, 0x308, 0x201, 0x433,
    0x301, 0x201, 0x456, 0x308, 0x201, 0x43a, 0x301, 0x201,
    0x438, 0x300, 0x201, 0x443, 0x306, 0x201, 0x474, 0x30f,
    0x201, 0x475, 0x30f, 0x201, 0x416, 0x306, 0x201, 0x436,
    0x306, 0x201, 0x410, 0x306, 0x201, 0x430, 0x306, 0x201,
    0x410, 0x308, 0x201, 0x430, 0x308, 0x201, 0x415, 0x306,
    0x201, 0x435, 0x306, 0x201, 0x4d8, 0x308, 0x201, 0x4d9,
    0x308, 0x201, 0x416, 0x308, 0x201, 0x436, 0x308, 0x201,
    0x417, 0x308, 0x201, 0x437, 0x308, 0x201, 0x418, 0x304,
    0x201, 0x438, 0x304, 0x201, 0x418, 0x308, 0x201, 0x438,
    0x308, 0x201, 0x41e, 0x308, 0x201, 0x43e, 0x308, 0x201,
    0x4e8, 0x308, 0x201, 0x4e9, 0x308, 0x201, 0x42d, 0x308,
    0x201, 0x44d, 0x308, 0x201, 0x423, 0x304, 0x201, 0x443,
    0x304, 0x201, 0x423, 0x308, 0x201, 0x443, 0x308, 0x201,
    0x423, 0x30b, 0x201, 0x443, 0x30b, 0x201, 0x427, 0x308,
    0x201, 0x447, 0x308, 0x201, 0x42b, 0x308, 0x201, 0x44b,
    0x308, 0x210, 0x565, 0x582, 0x201, 0x627, 0x653, 0x201,
    0x627, 0x654, 0x201, 0x648, 0x654, 0x201, 0x627, 0x655,
    0x201, 0x64a, 0x654, 0x210, 0x627, 0x674, 0x210, 0x648,
    0x674, 0x210, 0x6c7, 0x674, 0x210, 0x64a, 0x674, 0x201,
    0x6d5, 0x654, 0x201, 0x6c1, 0x654, 0x201, 0x6d2, 0x654,
    0x201, 0x928, 0x93c, 0x201, 0x930, 0x93c, 0x201, 0x933,
    0x93c, 0x201, 0x915, 0x93c, 0x201, 0x916, 0x93c, 0x201,
    0x917, 0x93c, 0x201, 0x91c, 0x93c, 0x201, 0x921, 0x93c,
    0x201, 0x922, 0x93c, 0x201, 0x92b, 0x93c, 0x201, 0x92f,
    0x93c, 0x201, 0x9c7, 0x9be, 0x201, 0x9c7, 0x9d7, 0x201,
    0x9a1, 0x9bc, 0x201, 0x9a2, 0x9bc, 0x201, 0x9af, 0x9bc,
    0x201, 0xa32, 0xa3c, 0x201, 0xa38, 0xa3c, 0x201, 0xa16,
    0xa3c, 0x201, 0xa17, 0xa3c, 0x201, 0xa1c, 0xa3c, 0x201,
    0xa2b, 0xa3c, 0x201, 0xb47, 0xb56, 0x201, 0xb47, 0xb3e,
    0x201, 0xb47, 0xb57, 0x201, 0xb21, 0xb3c, 0x201, 0xb22,
    0xb3c, 0x201, 0xb92, 0xbd7, 0x201, 0xbc6, 0xbbe, 0x201,
    0xbc7, 0xbbe, 0x201, 0xbc6, 0xbd7, 0x201, 0xc46, 0xc56,
    0x201, 0xcbf, 0xcd5, 0x201, 0xcc6, 0xcd5, 0x201, 0xcc6,
    0xcd6, 0x201, 0xcc6, 0xcc2, 0x201, 0xcca, 0xcd5, 0x201,
    0xd46, 0xd3e, 0x201, 0xd47, 0xd3e, 0x201, 0xd46, 0xd57,
    0x201, 0xdd9, 0xdca, 0x201, 0xdd9, 0xdcf, 0x201, 0xddc,
    0xdca, 0x201, 0xdd9, 0xddf, 0x210, 0xe4d, 0xe32, 0x210,
    0xecd, 0xeb2, 0x210, 0xeab, 0xe99, 0x210, 0xeab, 0xea1,
    0x103, 0xf0b, 0x201, 0xf42, 0xfb7, 0x201, 0xf4c, 0xfb7,
    0x201, 0xf51, 0xfb7, 0x201, 0xf56, 0xfb7, 0x201, 0xf5b,
    0xfb7, 0x201, 0xf40, 0xfb5, 0x201, 0xf71, 0xf72, 0x201,
    0xf71, 0xf74, 0x201, 0xfb2, 0xf80, 0x210, 0xfb2, 0xf81,
    0x201, 0xfb3, 0xf80, 0x210, 0xfb3, 0xf81, 0x201, 0xf71,
    0xf80, 0x201, 0xf92, 0xfb7, 0x201, 0xf9c, 0xfb7, 0x201,
    0xfa1, 0xfb7, 0x201, 0xfa6, 0xfb7, 0x201, 0xfab, 0xfb7,
    0x201, 0xf90, 0xfb5, 0x201, 0x1025, 0x102e, 0x109, 0x10dc,
    0x201, 0x1b05, 0x1b35, 0x201, 0x1b07, 0x1b35, 0x201, 0x1b09,
    0x1b35, 0x201, 0x1b0b, 0x1b35, 0x201, 0x1b0d, 0x1b35, 0x201,
    0x1b11, 0x1b35, 0x201, 0x1b3a, 0x1b35, 0x201, 0x1b3c, 0x1b35,
    0x201, 0x1b3e, 0x1b35, 0x201, 0x1b3f, 0x1b35, 0x201, 0x1b42,
    0x1b35, 0x109, 0x41, 0x109, 0xc6, 0x109, 0x42, 0x109,
    0x44, 0x109, 0x45, 0x109, 0x18e, 0x109, 0x47, 0x109,
    0x48, 0x109, 0x49, 0x109, 0x4a, 0x109, 0x4b, 0x109,
    0x4c, 0x109, 0x4d, 0x109, 0x4e, 0x109, 0x4f, 0x109,
    0x222, 0x109, 0x50, 0x109, 0x52, 0x109, 0x54, 0x109,
    0x55, 0x109, 0x57, 0x109, 0x61, 0x109, 0x250, 0x109,
    0x251, 0x109, 0x1d02, 0x109, 0x62, 0x109, 0x64, 0x109,
    0x65, 0x109, 0x259, 0x109, 0x25b, 0x109, 0x25c, 0x109,
    0x67, 0x109, 0x6b, 0x109, 0x6d, 0x109, 0x14b, 0x109,
    0x6f, 0x109, 0x254, 0x109, 0x1d16, 0x109, 0x1d17, 0x109,
    0x70, 0x109, 0x74, 0x109, 0x75, 0x109, 0x1d1d, 0x109,
    0x26f, 0x109, 0x76, 0x109, 0x1d25, 0x109, 0x3b2, 0x109,
    0x3b3, 0x109, 0x3b4, 0x109, 0x3c6, 0x109, 0x3c7, 0x10a,
    0x69, 0x10a, 0x72, 0x10a, 0x75, 0x10a, 0x76, 0x10a,
    0x3b2, 0x10a, 0x3b3, 0x10a, 0x3c1, 0x10a, 0x3c6, 0x10a,
    0x3c7, 0x109, 0x43d, 0x109, 0x252, 0x109, 0x63, 0x109,
    0x255, 0x109, 0xf0, 0x109, 0x25c, 0x109, 0x66, 0x109,
    0x25f, 0x109, 0x261, 0x109, 0x265, 0x109, 0x268, 0x109,
    0x269, 0x109, 0x26a, 0x109, 0x1d7b, 0x109, 0x29d, 0x109,
    0x26d, 0x109, 0x1d85, 0x109, 0x29f, 0x109, 0x271, 0x109,
    0x270, 0x109, 0x272, 0x109, 0x273, 0x109, 0x274, 0x109,
    0x275, 0x109, 0x278, 0x109, 0x282, 0x109, 0x283, 0x109,
    0x1ab, 0x109, 0x289, 0x109, 0x28a, 0x109, 0x1d1c, 0x109,
    0x28b, 0x109, 0x28c, 0x109, 0x7a, 0x109, 0x290, 0x109,
    0x291, 0x109, 0x292, 0x109, 0x3b8, 0x201, 0x41, 0x325,
    0x201, 0x61, 0x325, 0x201, 0x42, 0x307, 0x201, 0x62,
    0x307, 0x201, 0x42, 0x323, 0x201, 0x62, 0x323, 0x201,
    0x42, 0x331, 0x201, 0x62, 0x331, 0x201, 0xc7, 0x301,
    0x201, 0xe7, 0x301, 0x201, 0x44, 0x307, 0x201, 0x64,
    0x307, 0x201, 0x44, 0x323, 0x201, 0x64, 0x323, 0x201,
    0x44, 0x331, 0x201, 0x64, 0x331, 0x201, 0x44, 0x327,
    0x201, 0x64, 0x327, 0x201, 0x44, 0x32d, 0x201, 0x64,
    0x32d, 0x201, 0x112, 0x300, 0x201, 0x113, 0x300, 0x201,
    0x112, 0x301, 0x201, 0x113, 0x301, 0x201, 0x45, 0x32d,
    0x201, 0x65, 0x32d, 0x201, 0x45, 0x330, 0x201, 0x65,
    0x330, 0x201, 0x228, 0x306, 0x201, 0x229, 0x306, 0x201,
    0x46, 0x307, 0x201, 0x66, 0x307, 0x201, 0x47, 0x304,
    0x201, 0x67, 0x304, 0x201, 0x48, 0x307, 0x201, 0x68,
    0x307, 0x201, 0x48, 0x323, 0x201, 0x68, 0x323, 0x201,
    0x48, 0x308, 0x201, 0x68, 0x308, 0x201, 0x48, 0x327,
    0x201, 0x68, 0x327, 0x201, 0x48, 0x32e, 0x201, 0x68,
    0x32e, 0x201, 0x49, 0x330, 0x201, 0x69, 0x330, 0x201,
    0xcf, 0x301, 0x201, 0xef, 0x301, 0x201, 0x4b, 0x301,
    0x201, 0x6b, 0x301, 0x201, 0x4b, 0x323, 0x201, 0x6b,
    0x323, 0x201, 0x4b, 0x331, 0x201, 0x6b, 0x331, 0x201,
    0x4c, 0x323, 0x201, 0x6c, 0x323, 0x201, 0x1e36, 0x304,
    0x201, 0x1e37, 0x304, 0x201, 0x4c, 0x331, 0x201, 0x6c,
    0x331, 0x201, 0x4c, 0x32d, 0x201, 0x6c, 0x32d, 0x201,
    0x4d, 0x301, 0x201, 0x6d, 0x301, 0x201, 0x4d, 0x307,
    0x201, 0x6d, 0x307, 0x201, 0x4d, 0x323, 0x201, 0x6d,
    0x323, 0x201, 0x4e, 0x307, 0x201, 0x6e, 0x307, 0x201,
    0x4e, 0x323, 0x201, 0x6e, 0x323, 0x201, 0x4e, 0x331,
    0x201, 0x6e, 0x331, 0x201, 0x4e, 0x32d, 0x201, 0x6e,
    0x32d, 0x201, 0xd5, 0x301, 0x201, 0xf5, 0x301, 0x201,
    0xd5, 0x308, 0x201, 0xf5, 0x308, 0x201, 0x14c, 0x300,
    0x201, 0x14d, 0x300, 0x201, 0x14c, 0x301, 0x201, 0x14d,
    0x301, 0x201, 0x50, 0x301, 0x201, 0x70, 0x301, 0x201,
    0x50, 0x307, 0x201, 0x70, 0x307, 0x201, 0x52, 0x307,
    0x201, 0x72, 0x307, 0x201, 0x52, 0x323, 0x201, 0x72,
    0x323, 0x201, 0x1e5a, 0x304, 0x201, 0x1e5b, 0x304, 0x201,
    0x52, 0x331, 0x201, 0x72, 0x331, 0x201, 0x53, 0x307,
    0x201, 0x73, 0x307, 0x201, 0x53, 0x323, 0x201, 0x73,
    0x323, 0x201, 0x15a, 0x307, 0x201, 0x15b, 0x307, 0x201,
    0x160, 0x307, 0x201, 0x161, 0x307, 0x201, 0x1e62, 0x307,
    0x201, 0x1e63, 0x307, 0x201, 0x54, 0x307, 0x201, 0x74,
    0x307, 0x201, 0x54, 0x323, 0x201, 0x74, 0x323, 0x201,
    0x54, 0x331, 0x201, 0x74, 0x331, 0x201, 0x54, 0x32d,
    0x201, 0x74, 0x32d, 0x201, 0x55, 0x324, 0x201, 0x75,
    0x324, 0x201, 0x55, 0x330, 0x201, 0x75, 0x330, 0x201,
    0x55, 0x32d, 0x201, 0x75, 0x32d, 0x201, 0x168, 0x301,
    0x201, 0x169, 0x301, 0x201, 0x16a, 0x308, 0x201, 0x16b,
    0x308, 0x201, 0x56, 0x303, 0x201, 0x76, 0x303, 0x201,
    0x56, 0x323, 0x201, 0x76, 0x323, 0x201, 0x57, 0x300,
    0x201, 0x77, 0x300, 0x201, 0x57, 0x301, 0x201, 0x77,
    0x301, 0x201, 0x57, 0x308, 0x201, 0x77, 0x308, 0x201,
    0x57, 0x307, 0x201, 0x77, 0x307, 0x201, 0x57, 0x323,
    0x201, 0x77, 0x323, 0x201, 0x58, 0x307, 0x201, 0x78,
    0x307, 0x201, 0x58, 0x308, 0x201, 0x78, 0x308, 0x201,
    0x59, 0x307, 0x201, 0x79, 0x307, 0x201, 0x5a, 0x302,
    0x201, 0x7a, 0x302, 0x201, 0x5a, 0x323, 0x201, 0x7a,
    0x323, 0x201, 0x5a, 0x331, 0x201, 0x7a, 0x331, 0x201,
    0x68, 0x331, 0x201, 0x74, 0x308, 0x201, 0x77, 0x30a,
    0x201, 0x79, 0x30a, 0x210, 0x61, 0x2be, 0x201, 0x17f,
    0x307, 0x201, 0x41, 0x323, 0x201, 0x61, 0x323, 0x201,
    0x41, 0x309, 0x201, 0x61, 0x309, 0x201, 0xc2, 0x301,
    0x201, 0xe2, 0x301, 0x201, 0xc2, 0x300, 0x201, 0xe2,
    0x300, 0x201, 0xc2, 0x309, 0x201, 0xe2, 0x309, 0x201,
    0xc2, 0x303, 0x201, 0xe2, 0x303, 0x201, 0x1ea0, 0x302,
    0x201, 0x1ea1, 0x302, 0x201, 0x102, 0x301, 0x201, 0x103,
    0x301, 0x201, 0x102, 0x300, 0x201, 0x103, 0x300, 0x201,
    0x102, 0x309, 0x201, 0x103, 0x309, 0x201, 0x102, 0x303,
    0x201, 0x103, 0x303, 0x201, 0x1ea0, 0x306, 0x201, 0x1ea1,
    0x306, 0x201, 0x45, 0x323, 0x201, 0x65, 0x323, 0x201,
    0x45, 0x309, 0x201, 0x65, 0x309, 0x201, 0x45, 0x303,
    0x201, 0x65, 0x303, 0x201, 0xca, 0x301, 0x201, 0xea,
    0x301, 0x201, 0xca, 0x300, 0x201, 0xea, 0x300, 0x201,
    0xca, 0x309, 0x201, 0xea, 0x309, 0x201, 0xca, 0x303,
    0x201, 0xea, 0x303, 0x201, 0x1eb8, 0x302, 0x201, 0x1eb9,
    0x302, 0x201, 0x49, 0x309, 0x201, 0x69, 0x309, 0x201,
    0x49, 0x323, 0x201, 0x69, 0x323, 0x201, 0x4f, 0x323,
    0x201, 0x6f, 0x323, 0x201, 0x4f, 0x309, 0x201, 0x6f,
    0x309, 0x201, 0xd4, 0x301, 0x201, 0xf4, 0x301, 0x201,
    0xd4, 0x300, 0x201, 0xf4, 0x300, 0x201, 0xd4, 0x309,
    0x201, 0xf4, 0x309, 0x201, 0xd4, 0x303, 0x201, 0xf4,
    0x303, 0x201, 0x1ecc, 0x302, 0x201, 0x1ecd, 0x302, 0x201,
    0x1a0, 0x301, 0x201, 0x1a1, 0x301, 0x201, 0x1a0, 0x300,
    0x201, 0x1a1, 0x300, 0x201, 0x1a0, 0x309, 0x201, 0x1a1,
    0x309, 0x201, 0x1a0, 0x303, 0x201, 0x1a1, 0x303, 0x201,
    0x1a0, 0x323, 0x201, 0x1a1, 0x323, 0x201, 0x55, 0x323,
    0x201, 0x75, 0x323, 0x201, 0x55, 0x309, 0x201, 0x75,
    0x309, 0x201, 0x1af, 0x301, 0x201, 0x1b0, 0x301, 0x201,
    0x1af, 0x300, 0x201, 0x1b0, 0x300, 0x201, 0x1af, 0x309,
    0x201, 0x1b0, 0x309, 0x201, 0x1af, 0x303, 0x201, 0x1b0,
    0x303, 0x201, 0x1af, 0x323, 0x201, 0x1b0, 0x323, 0x201,
    0x59, 0x300, 0x201, 0x79, 0x300, 0x201, 0x59, 0x323,
    0x201, 0x79, 0x323, 0x201, 0x59, 0x309, 0x201, 0x79,
    0x309, 0x201, 0x59, 0x303, 0x201, 0x79, 0x303, 0x201,
    0x3b1, 0x313, 0x201, 0x3b1, 0x314, 0x201, 0x1f00, 0x300,
    0x201, 0x1f01, 0x300, 0x201, 0x1f00, 0x301, 0x201, 0x1f01,
    0x301, 0x201, 0x1f00, 0x342, 0x201, 0x1f01, 0x342, 0x201,
    0x391, 0x313, 0x201, 0x391, 0x314, 0x201, 0x1f08, 0x300,
    0x201, 0x1f09, 0x300, 0x201, 0x1f08, 0x301, 0x201, 0x1f09,
    0x301, 0x201, 0x1f08, 0x342, 0x201, 0x1f09, 0x342, 0x201,
    0x3b5, 0x313, 0x201, 0x3b5, 0x314, 0x201, 0x1f10, 0x300,
    0x201, 0x1f11, 0x300, 0x201, 0x1f10, 0x301, 0x201, 0x1f11,
    0x301, 0x201, 0x395, 0x313, 0x201, 0x395, 0x314, 0x201,
    0x1f18, 0x300, 0x201, 0x1f19, 0x300, 0x201, 0x1f18, 0x301,
    0x201, 0x1f19, 0x301, 0x201, 0x3b7, 0x313, 0x201, 0x3b7,
    0x314, 0x201, 0x1f20, 0x300, 0x201, 0x1f21, 0x300, 0x201,
    0x1f20, 0x301, 0x201, 0x1f21, 0x301, 0x201, 0x1f20, 0x342,
    0x201, 0x1f21, 0x342, 0x201, 0x397, 0x313, 0x201, 0x397,
    0x314, 0x201, 0x1f28, 0x300, 0x201, 0x1f29, 0x300, 0x201,
    0x1f28, 0x301, 0x201, 0x1f29, 0x301, 0x201, 0x1f28, 0x342,
    0x201, 0x1f29, 0x342, 0x201, 0x3b9, 0x313, 0x201, 0x3b9,
    0x314, 0x201, 0x1f30, 0x300, 0x201, 0x1f31, 0x300, 0x201,
    0x1f30, 0x301, 0x201, 0x1f31, 0x301, 0x201, 0x1f30, 0x342,
    0x201, 0x1f31, 0x342, 0x201, 0x399, 0x313, 0x201, 0x399,
    0x314, 0x201, 0x1f38, 0x300, 0x201, 0x1f39, 0x300, 0x201,
    0x1f38, 0x301, 0x201, 0x1f39, 0x301, 0x201, 0x1f38, 0x342,
    0x201, 0x1f39, 0x342, 0x201, 0x3bf, 0x313, 0x201, 0x3bf,
    0x314, 0x201, 0x1f40, 0x300, 0x201, 0x1f41, 0x300, 0x201,
    0x1f40, 0x301, 0x201, 0x1f41, 0x301, 0x201, 0x39f, 0x313,
    0x201, 0x39f, 0x314, 0x201, 0x1f48, 0x300, 0x201, 0x1f49,
    0x300, 0x201, 0x1f48, 0x301, 0x201, 0x1f49, 0x301, 0x201,
    0x3c5, 0x313, 0x201, 0x3c5, 0x314, 0x201, 0x1f50, 0x300,
    0x201, 0x1f51, 0x300, 0x201, 0x1f50, 0x301, 0x201, 0x1f51,
    0x301, 0x201, 0x1f50, 0x342, 0x201, 0x1f51, 0x342, 0x201,
    0x3a5, 0x314, 0x201, 0x1f59, 0x300, 0x201, 0x1f59, 0x301,
    0x201, 0x1f59, 0x342, 0x201, 0x3c9, 0x313, 0x201, 0x3c9,
    0x314, 0x201, 0x1f60, 0x300, 0x201, 0x1f61, 0x300, 0x201,
    0x1f60, 0x301, 0x201, 0x1f61, 0x301, 0x201, 0x1f60, 0x342,
    0x201, 0x1f61, 0x342, 0x201, 0x3a9, 0x313, 0x201, 0x3a9,
    0x314, 0x201, 0x1f68, 0x300, 0x201, 0x1f69, 0x300, 0x201,
    0x1f68, 0x301, 0x201, 0x1f69, 0x301, 0x201, 0x1f68, 0x342,
    0x201, 0x1f69, 0x342, 0x201, 0x3b1, 0x300, 0x101, 0x3ac,
    0x201, 0x3b5, 0x300, 0x101, 0x3ad, 0x201, 0x3b7, 0x300,
    0x101, 0x3ae, 0x201, 0x3b9, 0x300, 0x101, 0x3af, 0x201,
    0x3bf, 0x300, 0x101, 0x3cc, 0x201, 0x3c5, 0x300, 0x101,
    0x3cd, 0x201, 0x3c9, 0x300, 0x101, 0x3ce, 0x201, 0x1f00,
    0x345, 0x201, 0x1f01, 0x345, 0x201, 0x1f02, 0x345, 0x201,
    0x1f03, 0x345, 0x201, 0x1f04, 0x345, 0x201, 0x1f05, 0x345,
    0x201, 0x1f06, 0x345, 0x201, 0x1f07, 0x345, 0x201, 0x1f08,
    0x345, 0x201, 0x1f09, 0x345, 0x201, 0x1f0a, 0x345, 0x201,
    0x1f0b, 0x345, 0x201, 0x1f0c, 0x345, 0x201, 0x1f0d, 0x345,
    0x201, 0x1f0e, 0x345, 0x201, 0x1f0f, 0x345, 0x201, 0x1f20,
    0x345, 0x201, 0x1f21, 0x345, 0x201, 0x1f22, 0x345, 0x201,
    0x1f23, 0x345, 0x201, 0x1f24, 0x345, 0x201, 0x1f25, 0x345,
    0x201, 0x1f26, 0x345, 0x201, 0x1f27, 0x345, 0x201, 0x1f28,
    0x345, 0x201, 0x1f29, 0x345, 0x201, 0x1f2a, 0x345, 0x201,
    0x1f2b, 0x345, 0x201, 0x1f2c, 0x345, 0x201, 0x1f2d, 0x345,
    0x201, 0x1f2e, 0x345, 0x201, 0x1f2f, 0x345, 0x201, 0x1f60,
    0x345, 0x201, 0x1f61, 0x345, 0x201, 0x1f62, 0x345, 0x201,
    0x1f63, 0x345, 0x201, 0x1f64, 0x345, 0x201, 0x1f65, 0x345,
    0x201, 0x1f66, 0x345, 0x201, 0x1f67, 0x345, 0x201, 0x1f68,
    0x345, 0x201, 0x1f69, 0x345, 0x201, 0x1f6a, 0x345, 0x201,
    0x1f6b, 0x345, 0x201, 0x1f6c, 0x345, 0x201, 0x1f6d, 0x345,
    0x201, 0x1f6e, 0x345, 0x201, 0x1f6f, 0x345, 0x201, 0x3b1,
    0x306, 0x201, 0x3b1, 0x304, 0x201, 0x1f70, 0x345, 0x201,
    0x3b1, 0x345, 0x201, 0x3ac, 0x345, 0x201, 0x3b1, 0x342,
    0x201, 0x1fb6, 0x345, 0x201, 0x391, 0x306, 0x201, 0x391,
    0x304, 0x201, 0x391, 0x300, 0x101, 0x386, 0x201, 0x391,
    0x345, 0x210, 0x20, 0x313, 0x101, 0x3b9, 0x210, 0x20,
    0x313, 0x210, 0x20, 0x342, 0x201, 0xa8, 0x342, 0x201,
    0x1f74, 0x345, 0x201, 0x3b7, 0x345, 0x201, 0x3ae, 0x345,
    0x201, 0x3b7, 0x342, 0x201, 0x1fc6, 0x345, 0x201, 0x395,
    0x300, 0x101, 0x388, 0x201, 0x397, 0x300, 0x101, 0x389,
    0x201, 0x397, 0x345, 0x201, 0x1fbf, 0x300, 0x201, 0x1fbf,
    0x301, 0x201, 0x1fbf, 0x342, 0x201, 0x3b9, 0x306, 0x201,
    0x3b9, 0x304, 0x201, 0x3ca, 0x300, 0x101, 0x390, 0x201,
    0x3b9, 0x342, 0x201, 0x3ca, 0x342, 0x201, 0x399, 0x306,
    0x201, 0x399, 0x304, 0x201, 0x399, 0x300, 0x101, 0x38a,
    0x201, 0x1ffe, 0x300, 0x201, 0x1ffe, 0x301, 0x201, 0x1ffe,
    0x342, 0x201, 0x3c5, 0x306, 0x201, 0x3c5, 0x304, 0x201,
    0x3cb, 0x300, 0x101, 0x3b0, 0x201, 0x3c1, 0x313, 0x201,
    0x3c1, 0x314, 0x201, 0x3c5, 0x342, 0x201, 0x3cb, 0x342,
    0x201, 0x3a5, 0x306, 0x201, 0x3a5, 0x304, 0x201, 0x3a5,
    0x300, 0x101, 0x38e, 0x201, 0x3a1, 0x314, 0x201, 0xa8,
    0x300, 0x101, 0x385, 0x101, 0x60, 0x201, 0x1f7c, 0x345,
    0x201, 0x3c9, 0x345, 0x201, 0x3ce, 0x345, 0x201, 0x3c9,
    0x342, 0x201, 0x1ff6, 0x345, 0x201, 0x39f, 0x300, 0x101,
    0x38c, 0x201, 0x3a9, 0x300, 0x101, 0x38f, 0x201, 0x3a9,
    0x345, 0x101, 0xb4, 0x210, 0x20, 0x314, 0x101, 0x2002,
    0x101, 0x2003, 0x110, 0x20, 0x110, 0x20, 0x110, 0x20,
    0x110, 0x20, 0x110, 0x20, 0x103, 0x20, 0x110, 0x20,
    0x110, 0x20, 0x110, 0x20, 0x103, 0x2010, 0x210, 0x20,
    0x333, 0x110, 0x2e, 0x210, 0x2e, 0x2e, 0x310, 0x2e,
    0x2e, 0x2e, 0x103, 0x20, 0x210, 0x2032, 0x2032, 0x310,
    0x2032, 0x2032, 0x2032, 0x210, 0x2035, 0x2035, 0x310, 0x2035,
    0x2035, 0x2035, 0x210, 0x21, 0x21, 0x210, 0x20, 0x305,
    0x210, 0x3f, 0x3f, 0x210, 0x3f, 0x21, 0x210, 0x21,
    0x3f, 0x410, 0x2032, 0x2032, 0x2032, 0x2032, 0x110, 0x20,
    0x109, 0x30, 0x109, 0x69, 0x109, 0x34, 0x109, 0x35,
    0x109, 0x36, 0x109, 0x37, 0x109, 0x38, 0x109, 0x39,
    0x109, 0x2b, 0x109, 0x2212, 0x109, 0x3d, 0x109, 0x28,
    0x109, 0x29, 0x109, 0x6e, 0x10a, 0x30, 0x10a, 0x31,
    0x10a, 0x32, 0x10a, 0x33, 0x10a, 0x34, 0x10a, 0x35,
    0x10a, 0x36, 0x10a, 0x37, 0x10a, 0x38, 0x10a, 0x39,
    0x10a, 0x2b, 0x10a, 0x2212, 0x10a, 0x3d, 0x10a, 0x28,
    0x10a, 0x29, 0x10a, 0x61, 0x10a, 0x65, 0x10a, 0x6f,
    0x10a, 0x78, 0x10a, 0x259, 0x10a, 0x68, 0x10a, 0x6b,
    0x10a, 0x6c, 0x10a, 0x6d, 0x10a, 0x6e, 0x10a, 0x70,
    0x10a, 0x73, 0x10a, 0x74, 0x210, 0x52, 0x73, 0x310,
    0x61, 0x2f, 0x63, 0x310, 0x61, 0x2f, 0x73, 0x102,
    0x43, 0x210, 0xb0, 0x43, 0x310, 0x63, 0x2f, 0x6f,
    0x310, 0x63, 0x2f, 0x75, 0x110, 0x190, 0x210, 0xb0,
    0x46, 0x102, 0x67, 0x102, 0x48, 0x102, 0x48, 0x102,
    0x48, 0x102, 0x68, 0x102, 0x127, 0x102, 0x49, 0x102,
    0x49, 0x102, 0x4c, 0x102, 0x6c, 0x102, 0x4e, 0x210,
    0x4e, 0x6f, 0x102, 0x50, 0x102, 0x51, 0x102, 0x52,
    0x102, 0x52, 0x102, 0x52, 0x209, 0x53, 0x4d, 0x310,
    0x54, 0x45, 0x4c, 0x209, 0x54, 0x4d, 0x102, 0x5a,
    0x101, 0x3a9, 0x102, 0x5a, 0x101, 0x4b, 0x101, 0xc5,
    0x102, 0x42, 0x102, 0x43, 0x102, 0x65, 0x102, 0x45,
    0x102, 0x46, 0x102, 0x4d, 0x102, 0x6f, 0x110, 0x5d0,
    0x110, 0x5d1, 0x110, 0x5d2, 0x110, 0x5d3, 0x102, 0x69,
    0x310, 0x46, 0x41, 0x58, 0x102, 0x3c0, 0x102, 0x3b3,
    0x102, 0x393, 0x102, 0x3a0, 0x102, 0x2211, 0x102, 0x44,
    0x102, 0x64, 0x102, 0x65, 0x102, 0x69, 0x102, 0x6a,
    0x311, 0x31, 0x2044, 0x37, 0x311, 0x31, 0x2044, 0x39,
    0x411, 0x31, 0x2044, 0x31, 0x30, 0x311, 0x31, 0x2044,
    0x33, 0x311, 0x32, 0x2044, 0x33, 0x311, 0x31, 0x2044,
    0x35, 0x311, 0x32, 0x2044, 0x35, 0x311, 0x33, 0x2044,
    0x35, 0x311, 0x34, 0x2044, 0x35, 0x311, 0x31, 0x2044,
    0x36, 0x311, 0x35, 0x2044, 0x36, 0x311, 0x31, 0x2044,
    0x38, 0x311, 0x33, 0x2044, 0x38, 0x311, 0x35, 0x2044,
    0x38, 0x311, 0x37, 0x2044, 0x38, 0x211, 0x31, 0x2044,
    0x110, 0x49, 0x210, 0x49, 0x49, 0x310, 0x49, 0x49,
    0x49, 0x210, 0x49, 0x56, 0x110, 0x56, 0x210, 0x56,
    0x49, 0x310, 0x56, 0x49, 0x49, 0x410, 0x56, 0x49,
    0x49, 0x49, 0x210, 0x49, 0x58, 0x110, 0x58, 0x210,
    0x58, 0x49, 0x310, 0x58, 0x49, 0x49, 0x110, 0x4c,
    0x110, 0x43, 0x110, 0x44, 0x110, 0x4d, 0x110, 0x69,
    0x210, 0x69, 0x69, 0x310, 0x69, 0x69, 0x69, 0x210,
    0x69, 0x76, 0x110, 0x76, 0x210, 0x76, 0x69, 0x310,
    0x76, 0x69, 0x69, 0x410, 0x76, 0x69, 0x69, 0x69,
    0x210, 0x69, 0x78, 0x110, 0x78, 0x210, 0x78, 0x69,
    0x310, 0x78, 0x69, 0x69, 0x110, 0x6c, 0x110, 0x63,
    0x110, 0x64, 0x110, 0x6d, 0x311, 0x30, 0x2044, 0x33,
    0x201, 0x2190, 0x338, 0x201, 0x2192, 0x338, 0x201, 0x2194,
    0x338, 0x201, 0x21d0, 0x338, 0x201, 0x21d4, 0x338, 0x201,
    0x21d2, 0x338, 0x201, 0x2203, 0x338, 0x201, 0x2208, 0x338,
    0x201, 0x220b, 0x338, 0x201, 0x2223, 0x338, 0x201, 0x2225,
    0x338, 0x210, 0x222b, 0x222b, 0x310, 0x222b, 0x222b, 0x222b,
    0x210, 0x222e, 0x222e, 0x310, 0x222e, 0x222e, 0x222e, 0x201,
    0x223c, 0x338, 0x201, 0x2243, 0x338, 0x201, 0x2245, 0x338,
    0x201, 0x2248, 0x338, 0x201, 0x3d, 0x338, 0x201, 0x2261,
    0x338, 0x201, 0x224d, 0x338, 0x201, 0x3c, 0x338, 0x201,
    0x3e, 0x338, 0x201, 0x2264, 0x338, 0x201, 0x2265, 0x338,
    0x201, 0x2272, 0x338, 0x201, 0x2273, 0x338, 0x201, 0x2276,
    0x338, 0x201, 0x2277, 0x338, 0x201, 0x227a, 0x338, 0x201,
    0x227b, 0x338, 0x201, 0x2282, 0x338, 0x201, 0x2283, 0x338,
    0x201, 0x2286, 0x338, 0x201, 0x2287, 0x338, 0x201, 0x22a2,
    0x338, 0x201, 0x22a8, 0x338, 0x201, 0x22a9, 0x338, 0x201,
    0x22ab, 0x338, 0x201, 0x227c, 0x338, 0x201, 0x227d, 0x338,
    0x201, 0x2291, 0x338, 0x201, 0x2292, 0x338, 0x201, 0x22b2,
    0x338, 0x201, 0x22b3, 0x338, 0x201, 0x22b4, 0x338, 0x201,
    0x22b5, 0x338, 0x101, 0x3008, 0x101, 0x3009, 0x108, 0x31,
    0x108, 0x32, 0x108, 0x33, 0x108, 0x34, 0x108, 0x35,
    0x108, 0x36, 0x108, 0x37, 0x108, 0x38, 0x108, 0x39,
    0x208, 0x31, 0x30, 0x208, 0x31, 0x31, 0x208, 0x31,
    0x32, 0x208, 0x31, 0x33, 0x208, 0x31, 0x34, 0x208,
    0x31, 0x35, 0x208, 0x31, 0x36, 0x208, 0x31, 0x37,
    0x208, 0x31, 0x38, 0x208, 0x31, 0x39, 0x208, 0x32,
    0x30, 0x310, 0x28, 0x31, 0x29, 0x310, 0x28, 0x32,
    0x29, 0x310, 0x28, 0x33, 0x29, 0x310, 0x28, 0x34,
    0x29, 0x310, 0x28, 0x35, 0x29, 0x310, 0x28, 0x36,
    0x29, 0x310, 0x28, 0x37, 0x29, 0x310, 0x28, 0x38,
    0x29, 0x310, 0x28, 0x39, 0x29, 0x410, 0x28, 0x31,
    0x30, 0x29, 0x410, 0x28, 0x31, 0x31, 0x29, 0x410,
    0x28, 0x31, 0x32, 0x29, 0x410, 0x28, 0x31, 0x33,
    0x29, 0x410, 0x28, 0x31, 0x34, 0x29, 0x410, 0x28,
    0x31, 0x35, 0x29, 0x410, 0x28, 0x31, 0x36, 0x29,
    0x410, 0x28, 0x31, 0x37, 0x29, 0x410, 0x28, 0x31,
    0x38, 0x29, 0x410, 0x28, 0x31, 0x39, 0x29, 0x410,
    0x28, 0x32, 0x30, 0x29, 0x210, 0x31, 0x2e, 0x210,
    0x32, 0x2e, 0x210, 0x33, 0x2e, 0x210, 0x34, 0x2e,
    0x210, 0x35, 0x2e, 0x210, 0x36, 0x2e, 0x210, 0x37,
    0x2e, 0x210, 0x38, 0x2e, 0x210, 0x39, 0x2e, 0x310,
    0x31, 0x30, 0x2e, 0x310, 0x31, 0x31, 0x2e, 0x310,
    0x31, 0x32, 0x2e, 0x310, 0x31, 0x33, 0x2e, 0x310,
    0x31, 0x34, 0x2e, 0x310, 0x31, 0x35, 0x2e, 0x310,
    0x31, 0x36, 0x2e, 0x310, 0x31, 0x37, 0x2e, 0x310,
    0x31, 0x38, 0x2e, 0x310, 0x31, 0x39, 0x2e, 0x310,
    0x32, 0x30, 0x2e, 0x310, 0x28, 0x61, 0x29, 0x310,
    0x28, 0x62, 0x29, 0x310, 0x28, 0x63, 0x29, 0x310,
    0x28, 0x64, 0x29, 0x310, 0x28, 0x65, 0x29, 0x310,
    0x28, 0x66, 0x29, 0x310, 0x28, 0x67, 0x29, 0x310,
    0x28, 0x68, 0x29, 0x310, 0x28, 0x69, 0x29, 0x310,
    0x28, 0x6a, 0x29, 0x310, 0x28, 0x6b, 0x29, 0x310,
    0x28, 0x6c, 0x29, 0x310, 0x28, 0x6d, 0x29, 0x310,
    0x28, 0x6e, 0x29, 0x310, 0x28, 0x6f, 0x29, 0x310,
    0x28, 0x70, 0x29, 0x310, 0x28, 0x71, 0x29, 0x310,
    0x28, 0x72, 0x29, 0x310, 0x28, 0x73, 0x29, 0x310,
    0x28, 0x74, 0x29, 0x310, 0x28, 0x75, 0x29, 0x310,
    0x28, 0x76, 0x29, 0x310, 0x28, 0x77, 0x29, 0x310,
    0x28, 0x78, 0x29, 0x310, 0x28, 0x79, 0x29, 0x310,
    0x28, 0x7a, 0x29, 0x108, 0x41, 0x108, 0x42, 0x108,
    0x43, 0x108, 0x44, 0x108, 0x45, 0x108, 0x46, 0x108,
    0x47, 0x108, 0x48, 0x108, 0x49, 0x108, 0x4a, 0x108,
    0x4b, 0x108, 0x4c, 0x108, 0x4d, 0x108, 0x4e, 0x108,
    0x4f, 0x108, 0x50, 0x108, 0x51, 0x108, 0x52, 0x108,
    0x53, 0x108, 0x54, 0x108, 0x55, 0x108, 0x56, 0x108,
    0x57, 0x108, 0x58, 0x108, 0x59, 0x108, 0x5a, 0x108,
    0x61, 0x108, 0x62, 0x108, 0x63, 0x108, 0x64, 0x108,
    0x65, 0x108, 0x66, 0x108, 0x67, 0x108, 0x68, 0x108,
    0x69, 0x108, 0x6a, 0x108, 0x6b, 0x108, 0x6c, 0x108,
    0x6d, 0x108, 0x6e, 0x108, 0x6f, 0x108, 0x70, 0x108,
    0x71, 0x108, 0x72, 0x108, 0x73, 0x108, 0x74, 0x108,
    0x75, 0x108, 0x76, 0x108, 0x77, 0x108, 0x78, 0x108,
    0x79, 0x108, 0x7a, 0x108, 0x30, 0x410, 0x222b, 0x222b,
    0x222b, 0x222b, 0x310, 0x3a, 0x3a, 0x3d, 0x210, 0x3d,
    0x3d, 0x310, 0x3d, 0x3d, 0x3d, 0x201, 0x2add, 0x338,
    0x10a, 0x6a, 0x109, 0x56, 0x109, 0x2d61, 0x110, 0x6bcd,
    0x110, 0x9f9f, 0x110, 0x4e00, 0x110, 0x4e28, 0x110, 0x4e36,
    0x110, 0x4e3f, 0x110, 0x4e59, 0x110, 0x4e85, 0x110, 0x4e8c,
    0x110, 0x4ea0, 0x110, 0x4eba, 0x110, 0x513f, 0x110, 0x5165,
    0x110, 0x516b, 0x110, 0x5182, 0x110, 0x5196, 0x110, 0x51ab,
    0x110, 0x51e0, 0x110, 0x51f5, 0x110, 0x5200, 0x110, 0x529b,
    0x110, 0x52f9, 0x110, 0x5315, 0x110, 0x531a, 0x110, 0x5338,
    0x110, 0x5341, 0x110, 0x535c, 0x110, 0x5369, 0x110, 0x5382,
    0x110, 0x53b6, 0x110, 0x53c8, 0x110, 0x53e3, 0x110, 0x56d7,
    0x110, 0x571f, 0x110, 0x58eb, 0x110, 0x5902, 0x110, 0x590a,
    0x110, 0x5915, 0x110, 0x5927, 0x110, 0x5973, 0x110, 0x5b50,
    0x110, 0x5b80, 0x110, 0x5bf8, 0x110, 0x5c0f, 0x110, 0x5c22,
    0x110, 0x5c38, 0x110, 0x5c6e, 0x110, 0x5c71, 0x110, 0x5ddb,
    0x110, 0x5de5, 0x110, 0x5df1, 0x110, 0x5dfe, 0x110, 0x5e72,
    0x110, 0x5e7a, 0x110, 0x5e7f, 0x110, 0x5ef4, 0x110, 0x5efe,
    0x110, 0x5f0b, 0x110, 0x5f13, 0x110, 0x5f50, 0x110, 0x5f61,
    0x110, 0x5f73, 0x110, 0x5fc3, 0x110, 0x6208, 0x110, 0x6236,
    0x110, 0x624b, 0x110, 0x652f, 0x110, 0x6534, 0x110, 0x6587,
    0x110, 0x6597, 0x110, 0x65a4, 0x110, 0x65b9, 0x110, 0x65e0,
    0x110, 0x65e5, 0x110, 0x66f0, 0x110, 0x6708, 0x110, 0x6728,
    0x110, 0x6b20, 0x110, 0x6b62, 0x110, 0x6b79, 0x110, 0x6bb3,
    0x110, 0x6bcb, 0x110, 0x6bd4, 0x110, 0x6bdb, 0x110, 0x6c0f,
    0x110, 0x6c14, 0x110, 0x6c34, 0x110, 0x706b, 0x110, 0x722a,
    0x110, 0x7236, 0x110, 0x723b, 0x110, 0x723f, 0x110, 0x7247,
    0x110, 0x7259, 0x110, 0x725b, 0x110, 0x72ac, 0x110, 0x7384,
    0x110, 0x7389, 0x110, 0x74dc, 0x110, 0x74e6, 0x110, 0x7518,
    0x110, 0x751f, 0x110, 0x7528, 0x110, 0x7530, 0x110, 0x758b,
    0x110, 0x7592, 0x110, 0x7676, 0x110, 0x767d, 0x110, 0x76ae,
    0x110, 0x76bf, 0x110, 0x76ee, 0x110, 0x77db, 0x110, 0x77e2,
    0x110, 0x77f3, 0x110, 0x793a, 0x110, 0x79b8, 0x110, 0x79be,
    0x110, 0x7a74, 0x110, 0x7acb, 0x110, 0x7af9, 0x110, 0x7c73,
    0x110, 0x7cf8, 0x110, 0x7f36, 0x110, 0x7f51, 0x110, 0x7f8a,
    0x110, 0x7fbd, 0x110, 0x8001, 0x110, 0x800c, 0x110, 0x8012,
    0x110, 0x8033, 0x110, 0x807f, 0x110, 0x8089, 0x110, 0x81e3,
    0x110, 0x81ea, 0x110, 0x81f3, 0x110, 0x81fc, 0x110, 0x820c,
    0x110, 0x821b, 0x110, 0x821f, 0x110, 0x826e, 0x110, 0x8272,
    0x110, 0x8278, 0x110, 0x864d, 0x110, 0x866b, 0x110, 0x8840,
    0x110, 0x884c, 0x110, 0x8863, 0x110, 0x897e, 0x110, 0x898b,
    0x110, 0x89d2, 0x110, 0x8a00, 0x110, 0x8c37, 0x110, 0x8c46,
    0x110, 0x8c55, 0x110, 0x8c78, 0x110, 0x8c9d, 0x110, 0x8d64,
    0x110, 0x8d70, 0x110, 0x8db3, 0x110, 0x8eab, 0x110, 0x8eca,
    0x110, 0x8f9b, 0x110, 0x8fb0, 0x110, 0x8fb5, 0x110, 0x9091,
    0x110, 0x9149, 0x110, 0x91c6, 0x110, 0x91cc, 0x110, 0x91d1,
    0x110, 0x9577, 0x110, 0x9580, 0x110, 0x961c, 0x110, 0x96b6,
    0x110, 0x96b9, 0x110, 0x96e8, 0x110, 0x9751, 0x110, 0x975e,
    0x110, 0x9762, 0x110, 0x9769, 0x110, 0x97cb, 0x110, 0x97ed,
    0x110, 0x97f3, 0x110, 0x9801, 0x110, 0x98a8, 0x110, 0x98db,
    0x110, 0x98df, 0x110, 0x9996, 0x110, 0x9999, 0x110, 0x99ac,
    0x110, 0x9aa8, 0x110, 0x9ad8, 0x110, 0x9adf, 0x110, 0x9b25,
    0x110, 0x9b2f, 0x110, 0x9b32, 0x110, 0x9b3c, 0x110, 0x9b5a,
    0x110, 0x9ce5, 0x110, 0x9e75, 0x110, 0x9e7f, 0x110, 0x9ea5,
    0x110, 0x9ebb, 0x110, 0x9ec3, 0x110, 0x9ecd, 0x110, 0x9ed1,
    0x110, 0x9ef9, 0x110, 0x9efd, 0x110, 0x9f0e, 0x110, 0x9f13,
    0x110, 0x9f20, 0x110, 0x9f3b, 0x110, 0x9f4a, 0x110, 0x9f52,
    0x110, 0x9f8d, 0x110, 0x9f9c, 0x110, 0x9fa0, 0x10c, 0x20,
    0x110, 0x3012, 0x110, 0x5341, 0x110, 0x5344, 0x110, 0x5345,
    0x201, 0x304b, 0x3099, 0x201, 0x304d, 0x3099, 0x201, 0x304f,
    0x3099, 0x201, 0x3051, 0x3099, 0x201, 0x3053, 0x3099, 0x201,
    0x3055, 0x3099, 0x201, 0x3057, 0x3099, 0x201, 0x3059, 0x3099,
    0x201, 0x305b, 0x3099, 0x201, 0x305d, 0x3099, 0x201, 0x305f,
    0x3099, 0x201, 0x3061, 0x3099, 0x201, 0x3064, 0x3099, 0x201,
    0x3066, 0x3099, 0x201, 0x3068, 0x3099, 0x201, 0x306f, 0x3099,
    0x201, 0x306f, 0x309a, 0x201, 0x3072, 0x3099, 0x201, 0x3072,
    0x309a, 0x201, 0x3075, 0x3099, 0x201, 0x3075, 0x309a, 0x201,
    0x3078, 0x3099, 0x201, 0x3078, 0x309a, 0x201, 0x307b, 0x3099,
    0x201, 0x307b, 0x309a, 0x201, 0x3046, 0x3099, 0x210, 0x20,
    0x3099, 0x210, 0x20, 0x309a, 0x201, 0x309d, 0x3099, 0x20b,
    0x3088, 0x308a, 0x201, 0x30ab, 0x3099, 0x201, 0x30ad, 0x3099,
    0x201, 0x30af, 0x3099, 0x201, 0x30b1, 0x3099, 0x201, 0x30b3,
    0x3099, 0x201, 0x30b5, 0x3099, 0x201, 0x30b7, 0x3099, 0x201,
    0x30b9, 0x3099, 0x201, 0x30bb, 0x3099, 0x201, 0x30bd, 0x3099,
    0x201, 0x30bf, 0x3099, 0x201, 0x30c1, 0x3099, 0x201, 0x30c4,
    0x3099, 0x201, 0x30c6, 0x3099, 0x201, 0x30c8, 0x3099, 0x201,
    0x30cf, 0x3099, 0x201, 0x30cf, 0x309a, 0x201, 0x30d2, 0x3099,
    0x201, 0x30d2, 0x309a, 0x201, 0x30d5, 0x3099, 0x201, 0x30d5,
    0x309a, 0x201, 0x30d8, 0x3099, 0x201, 0x30d8, 0x309a, 0x201,
    0x30db, 0x3099, 0x201, 0x30db, 0x309a, 0x201, 0x30a6, 0x3099,
    0x201, 0x30ef, 0x3099, 0x201, 0x30f0, 0x3099, 0x201, 0x30f1,
    0x3099, 0x201, 0x30f2, 0x3099, 0x201, 0x30fd, 0x3099, 0x20b,
    0x30b3, 0x30c8, 0x110, 0x1100, 0x110, 0x1101, 0x110, 0x11aa,
    0x110, 0x1102, 0x110, 0x11ac, 0x110, 0x11ad, 0x110, 0x1103,
    0x110, 0x1104, 0x110, 0x1105, 0x110, 0x11b0, 0x110, 0x11b1,
    0x110, 0x11b2, 0x110, 0x11b3, 0x110, 0x11b4, 0x110, 0x11b5,
    0x110, 0x111a, 0x110, 0x1106, 0x110, 0x1107, 0x110, 0x1108,
    0x110, 0x1121, 0x110, 0x1109, 0x110, 0x110a, 0x110, 0x110b,
    0x110, 0x110c, 0x110, 0x110d, 0x110, 0x110e, 0x110, 0x110f,
    0x110, 0x1110, 0x110, 0x1111, 0x110, 0x1112, 0x110, 0x1161,
    0x110, 0x1162, 0x110, 0x1163, 0x110, 0x1164, 0x110, 0x1165,
    0x110, 0x1166, 0x110, 0x1167, 0x110, 0x1168, 0x110, 0x1169,
    0x110, 0x116a, 0x110, 0x116b, 0x110, 0x116c, 0x110, 0x116d,
    0x110, 0x116e, 0x110, 0x116f, 0x110, 0x1170, 0x110, 0x1171,
    0x110, 0x1172, 0x110, 0x1173, 0x110, 0x1174, 0x110, 0x1175,
    0x110, 0x1160, 0x110, 0x1114, 0x110, 0x1115, 0x110, 0x11c7,
    0x110, 0x11c8, 0x110, 0x11cc, 0x110, 0x11ce, 0x110, 0x11d3,
    0x110, 0x11d7, 0x110, 0x11d9, 0x110, 0x111c, 0x110, 0x11dd,
    0x110, 0x11df, 0x110, 0x111d, 0x110, 0x111e, 0x110, 0x1120,
    0x110, 0x1122, 0x110, 0x1123, 0x110, 0x1127, 0x110, 0x1129,
    0x110, 0x112b, 0x110, 0x112c, 0x110, 0x112d, 0x110, 0x112e,
    0x110, 0x112f, 0x110, 0x1132, 0x110, 0x1136, 0x110, 0x1140,
    0x110, 0x1147, 0x110, 0x114c, 0x110, 0x11f1, 0x110, 0x11f2,
    0x110, 0x1157, 0x110, 0x1158, 0x110, 0x1159, 0x110, 0x1184,
    0x110, 0x1185, 0x110, 0x1188, 0x110, 0x1191, 0x110, 0x1192,
    0x110, 0x1194, 0x110, 0x119e, 0x110, 0x11a1, 0x109, 0x4e00,
    0x109, 0x4e8c, 0x109, 0x4e09, 0x109, 0x56db, 0x109, 0x4e0a,
    0x109, 0x4e2d, 0x109, 0x4e0b, 0x109, 0x7532, 0x109, 0x4e59,
    0x109, 0x4e19, 0x109, 0x4e01, 0x109, 0x5929, 0x109, 0x5730,
    0x109, 0x4eba, 0x310, 0x28, 0x1100, 0x29, 0x310, 0x28,
    0x1102, 0x29, 0x310, 0x28, 0x1103, 0x29, 0x310, 0x28,
    0x1105, 0x29, 0x310, 0x28, 0x1106, 0x29, 0x310, 0x28,
    0x1107, 0x29, 0x310, 0x28, 0x1109, 0x29, 0x310, 0x28,
    0x110b, 0x29, 0x310, 0x28, 0x110c, 0x29, 0x310, 0x28,
    0x110e, 0x29, 0x310, 0x28, 0x110f, 0x29, 0x310, 0x28,
    0x1110, 0x29, 0x310, 0x28, 0x1111, 0x29, 0x310, 0x28,
    0x1112, 0x29, 0x410, 0x28, 0x1100, 0x1161, 0x29, 0x410,
    0x28, 0x1102, 0x1161, 0x29, 0x410, 0x28, 0x1103, 0x1161,
    0x29, 0x410, 0x28, 0x1105, 0x1161, 0x29, 0x410, 0x28,
    0x1106, 0x1161, 0x29, 0x410, 0x28, 0x1107, 0x1161, 0x29,
    0x410, 0x28, 0x1109, 0x1161, 0x29, 0x410, 0x28, 0x110b,
    0x1161, 0x29, 0x410, 0x28, 0x110c, 0x1161, 0x29, 0x410,
    0x28, 0x110e, 0x1161, 0x29, 0x410, 0x28, 0x110f, 0x1161,
    0x29, 0x410, 0x28, 0x1110, 0x1161, 0x29, 0x410, 0x28,
    0x1111, 0x1161, 0x29, 0x410, 0x28, 0x1112, 0x1161, 0x29,
    0x410, 0x28, 0x110c, 0x116e, 0x29, 0x710, 0x28, 0x110b,
    0x1169, 0x110c, 0x1165, 0x11ab, 0x29, 0x610, 0x28, 0x110b,
    0x1169, 0x1112, 0x116e, 0x29, 0x310, 0x28, 0x4e00, 0x29,
    0x310, 0x28, 0x4e8c, 0x29, 0x310, 0x28, 0x4e09, 0x29,
    0x310, 0x28, 0x56db, 0x29, 0x310, 0x28, 0x4e94, 0x29,
    0x310, 0x28, 0x516d, 0x29, 0x310, 0x28, 0x4e03, 0x29,
    0x310, 0x28, 0x516b, 0x29, 0x310, 0x28, 0x4e5d, 0x29,
    0x310, 0x28, 0x5341, 0x29, 0x310, 0x28, 0x6708, 0x29,
    0x310, 0x28, 0x706b, 0x29, 0x310, 0x28, 0x6c34, 0x29,
    0x310, 0x28, 0x6728, 0x29, 0x310, 0x28, 0x91d1, 0x29,
    0x310, 0x28, 0x571f, 0x29, 0x310, 0x28, 0x65e5, 0x29,
    0x310, 0x28, 0x682a, 0x29, 0x310, 0x28, 0x6709, 0x29,
    0x310, 0x28, 0x793e, 0x29, 0x310, 0x28, 0x540d, 0x29,
    0x310, 0x28, 0x7279, 0x29, 0x310, 0x28, 0x8ca1, 0x29,
    0x310, 0x28, 0x795d, 0x29, 0x310, 0x28, 0x52b4, 0x29,
    0x310, 0x28, 0x4ee3, 0x29, 0x310, 0x28, 0x547c, 0x29,
    0x310, 0x28, 0x5b66, 0x29, 0x310, 0x28, 0x76e3, 0x29,
    0x310, 0x28, 0x4f01, 0x29, 0x310, 0x28, 0x8cc7, 0x29,
    0x310, 0x28, 0x5354, 0x29, 0x310, 0x28, 0x796d, 0x29,
    0x310, 0x28, 0x4f11, 0x29, 0x310, 0x28, 0x81ea, 0x29,
    0x310, 0x28, 0x81f3, 0x29, 0x108, 0x554f, 0x108, 0x5e7c,
    0x108, 0x6587, 0x108, 0x7b8f, 0x30f, 0x50, 0x54, 0x45,
    0x208, 0x32, 0x31, 0x208, 0x32, 0x32, 0x208, 0x32,
    0x33, 0x208, 0x32, 0x34, 0x208, 0x32, 0x35, 0x208,
    0x32, 0x36, 0x208, 0x32, 0x37, 0x208, 0x32, 0x38,
    0x208, 0x32, 0x39, 0x208, 0x33, 0x30, 0x208, 0x33,
    0x31, 0x208, 0x33, 0x32, 0x208, 0x33, 0x33, 0x208,
    0x33, 0x34, 0x208, 0x33, 0x35, 0x108, 0x1100, 0x108,
    0x1102, 0x108, 0x1103, 0x108, 0x1105, 0x108, 0x1106, 0x108,
    0x1107, 0x108, 0x1109, 0x108, 0x110b, 0x108, 0x110c, 0x108,
    0x110e, 0x108, 0x110f, 0x108, 0x1110, 0x108, 0x1111, 0x108,
    0x1112, 0x208, 0x1100, 0x1161, 0x208, 0x1102, 0x1161, 0x208,
    0x1103, 0x1161, 0x208, 0x1105, 0x1161, 0x208, 0x1106, 0x1161,
    0x208, 0x1107, 0x1161, 0x208, 0x1109, 0x1161, 0x208, 0x110b,
    0x1161, 0x208, 0x110c, 0x1161, 0x208, 0x110e, 0x1161, 0x208,
    0x110f, 0x1161, 0x208, 0x1110, 0x1161, 0x208, 0x1111, 0x1161,
    0x208, 0x1112, 0x1161, 0x508, 0x110e, 0x1161, 0x11b7, 0x1100,
    0x1169, 0x408, 0x110c, 0x116e, 0x110b, 0x1174, 0x208, 0x110b,
    0x116e, 0x108, 0x4e00, 0x108, 0x4e8c, 0x108, 0x4e09, 0x108,
    0x56db, 0x108, 0x4e94, 0x108, 0x516d, 0x108, 0x4e03, 0x108,
    0x516b, 0x108, 0x4e5d, 0x108, 0x5341, 0x108, 0x6708, 0x108,
    0x706b, 0x108, 0x6c34, 0x108, 0x6728, 0x108, 0x91d1, 0x108,
    0x571f, 0x108, 0x65e5, 0x108, 0x682a, 0x108, 0x6709, 0x108,
    0x793e, 0x108, 0x540d, 0x108, 0x7279, 0x108, 0x8ca1, 0x108,
    0x795d, 0x108, 0x52b4, 0x108, 0x79d8, 0x108, 0x7537, 0x108,
    0x5973, 0x108, 0x9069, 0x108, 0x512a, 0x108, 0x5370, 0x108,
    0x6ce8, 0x108, 0x9805, 0x108, 0x4f11, 0x108, 0x5199, 0x108,
    0x6b63, 0x108, 0x4e0a, 0x108, 0x4e2d, 0x108, 0x4e0b, 0x108,
    0x5de6, 0x108, 0x53f3, 0x108, 0x533b, 0x108, 0x5b97, 0x108,
    0x5b66, 0x108, 0x76e3, 0x108, 0x4f01, 0x108, 0x8cc7, 0x108,
    0x5354, 0x108, 0x591c, 0x208, 0x33, 0x36, 0x208, 0x33,
    0x37, 0x208, 0x33, 0x38, 0x208, 0x33, 0x39, 0x208,
    0x34, 0x30, 0x208, 0x34, 0x31, 0x208, 0x34, 0x32,
    0x208, 0x34, 0x33, 0x208, 0x34, 0x34, 0x208, 0x34,
    0x35, 0x208, 0x34, 0x36, 0x208, 0x34, 0x37, 0x208,
    0x34, 0x38, 0x208, 0x34, 0x39, 0x208, 0x35, 0x30,
    0x210, 0x31, 0x6708, 0x210, 0x32, 0x6708, 0x210, 0x33,
    0x6708, 0x210, 0x34, 0x6708, 0x210, 0x35, 0x6708, 0x210,
    0x36, 0x6708, 0x210, 0x37, 0x6708, 0x210, 0x38, 0x6708,
    0x210, 0x39, 0x6708, 0x310, 0x31, 0x30, 0x6708, 0x310,
    0x31, 0x31, 0x6708, 0x310, 0x31, 0x32, 0x6708, 0x20f,
    0x48, 0x67, 0x30f, 0x65, 0x72, 0x67, 0x20f, 0x65,
    0x56, 0x30f, 0x4c, 0x54, 0x44, 0x108, 0x30a2, 0x108,
    0x30a4, 0x108, 0x30a6, 0x108, 0x30a8, 0x108, 0x30aa, 0x108,
    0x30ab, 0x108, 0x30ad, 0x108, 0x30af, 0x108, 0x30b1, 0x108,
    0x30b3, 0x108, 0x30b5, 0x108, 0x30b7, 0x108, 0x30b9, 0x108,
    0x30bb, 0x108, 0x30bd, 0x108, 0x30bf, 0x108, 0x30c1, 0x108,
    0x30c4, 0x108, 0x30c6, 0x108, 0x30c8, 0x108, 0x30ca, 0x108,
    0x30cb, 0x108, 0x30cc, 0x108, 0x30cd, 0x108, 0x30ce, 0x108,
    0x30cf, 0x108, 0x30d2, 0x108, 0x30d5, 0x108, 0x30d8, 0x108,
    0x30db, 0x108, 0x30de, 0x108, 0x30df, 0x108, 0x30e0, 0x108,
    0x30e1, 0x108, 0x30e2, 0x108, 0x30e4, 0x108, 0x30e6, 0x108,
    0x30e8, 0x108, 0x30e9, 0x108, 0x30ea, 0x108, 0x30eb, 0x108,
    0x30ec, 0x108, 0x30ed, 0x108, 0x30ef, 0x108, 0x30f0, 0x108,
    0x30f1, 0x108, 0x30f2, 0x40f, 0x30a2, 0x30d1, 0x30fc, 0x30c8,
    0x40f, 0x30a2, 0x30eb, 0x30d5, 0x30a1, 0x40f, 0x30a2, 0x30f3,
    0x30da, 0x30a2, 0x30f, 0x30a2, 0x30fc, 0x30eb, 0x40f, 0x30a4,
    0x30cb, 0x30f3, 0x30b0, 0x30f, 0x30a4, 0x30f3, 0x30c1, 0x30f,
    0x30a6, 0x30a9, 0x30f3, 0x50f, 0x30a8, 0x30b9, 0x30af, 0x30fc,
    0x30c9, 0x40f, 0x30a8, 0x30fc, 0x30ab, 0x30fc, 0x30f, 0x30aa,
    0x30f3, 0x30b9, 0x30f, 0x30aa, 0x30fc, 0x30e0, 0x30f, 0x30ab,
    0x30a4, 0x30ea, 0x40f, 0x30ab, 0x30e9, 0x30c3, 0x30c8, 0x40f,
    0x30ab, 0x30ed, 0x30ea, 0x30fc, 0x30f, 0x30ac, 0x30ed, 0x30f3,
    0x30f, 0x30ac, 0x30f3, 0x30de, 0x20f, 0x30ae, 0x30ac, 0x30f,
    0x30ae, 0x30cb, 0x30fc, 0x40f, 0x30ad, 0x30e5, 0x30ea, 0x30fc,
    0x40f, 0x30ae, 0x30eb, 0x30c0, 0x30fc, 0x20f, 0x30ad, 0x30ed,
    0x50f, 0x30ad, 0x30ed, 0x30b0, 0x30e9, 0x30e0, 0x60f, 0x30ad,
    0x30ed, 0x30e1, 0x30fc, 0x30c8, 0x30eb, 0x50f, 0x30ad, 0x30ed,
    0x30ef, 0x30c3, 0x30c8, 0x30f, 0x30b0, 0x30e9, 0x30e0, 0x50f,
    0x30b0, 0x30e9, 0x30e0, 0x30c8, 0x30f3, 0x50f, 0x30af, 0x30eb,
    0x30bc, 0x30a4, 0x30ed, 0x40f, 0x30af, 0x30ed, 0x30fc, 0x30cd,
    0x30f, 0x30b1, 0x30fc, 0x30b9, 0x30f, 0x30b3, 0x30eb, 0x30ca,
    0x30f, 0x30b3, 0x30fc, 0x30dd, 0x40f, 0x30b5, 0x30a4, 0x30af,
    0x30eb, 0x50f, 0x30b5, 0x30f3, 0x30c1, 0x30fc, 0x30e0, 0x40f,
    0x30b7, 0x30ea, 0x30f3, 0x30b0, 0x30f, 0x30bb, 0x30f3, 0x30c1,
    0x30f, 0x30bb, 0x30f3, 0x30c8, 0x30f, 0x30c0, 0x30fc, 0x30b9,
    0x20f, 0x30c7, 0x30b7, 0x20f, 0x30c9, 0x30eb, 0x20f, 0x30c8,
    0x30f3, 0x20f, 0x30ca, 0x30ce, 0x30f, 0x30ce, 0x30c3, 0x30c8,
    0x30f, 0x30cf, 0x30a4, 0x30c4, 0x50f, 0x30d1, 0x30fc, 0x30bb,
    0x30f3, 0x30c8, 0x30f, 0x30d1, 0x30fc, 0x30c4, 0x40f, 0x30d0,
    0x30fc, 0x30ec, 0x30eb, 0x50f, 0x30d4, 0x30a2, 0x30b9, 0x30c8,
    0x30eb, 0x30f, 0x30d4, 0x30af, 0x30eb, 0x20f, 0x30d4, 0x30b3,
    0x20f, 0x30d3, 0x30eb, 0x50f, 0x30d5, 0x30a1, 0x30e9, 0x30c3,
    0x30c9, 0x40f, 0x30d5, 0x30a3, 0x30fc, 0x30c8, 0x50f, 0x30d6,
    0x30c3, 0x30b7, 0x30a7, 0x30eb, 0x30f, 0x30d5, 0x30e9, 0x30f3,
    0x50f, 0x30d8, 0x30af, 0x30bf, 0x30fc, 0x30eb, 0x20f, 0x30da,
    0x30bd, 0x30f, 0x30da, 0x30cb, 0x30d2, 0x30f, 0x30d8, 0x30eb,
    0x30c4, 0x30f, 0x30da, 0x30f3, 0x30b9, 0x30f, 0x30da, 0x30fc,
    0x30b8, 0x30f, 0x30d9, 0x30fc, 0x30bf, 0x40f, 0x30dd, 0x30a4,
    0x30f3, 0x30c8, 0x30f, 0x30dc, 0x30eb, 0x30c8, 0x20f, 0x30db,
    0x30f3, 0x30f, 0x30dd, 0x30f3, 0x30c9, 0x30f, 0x30db, 0x30fc,
    0x30eb, 0x30f, 0x30db, 0x30fc, 0x30f3, 0x40f, 0x30de, 0x30a4,
    0x30af, 0x30ed, 0x30f, 0x30de, 0x30a4, 0x30eb, 0x30f, 0x30de,
    0x30c3, 0x30cf, 0x30f, 0x30de, 0x30eb, 0x30af, 0x50f, 0x30de,
    0x30f3, 0x30b7, 0x30e7, 0x30f3, 0x40f, 0x30df, 0x30af, 0x30ed,
    0x30f3, 0x20f, 0x30df, 0x30ea, 0x50f, 0x30df, 0x30ea, 0x30d0,
    0x30fc, 0x30eb, 0x20f, 0x30e1, 0x30ac, 0x40f, 0x30e1, 0x30ac,
    0x30c8, 0x30f3, 0x40f, 0x30e1, 0x30fc, 0x30c8, 0x30eb, 0x30f,
    0x30e4, 0x30fc, 0x30c9, 0x30f, 0x30e4, 0x30fc, 0x30eb, 0x30f,
    0x30e6, 0x30a2, 0x30f3, 0x40f, 0x30ea, 0x30c3, 0x30c8, 0x30eb,
    0x20f, 0x30ea, 0x30e9, 0x30f, 0x30eb, 0x30d4, 0x30fc, 0x40f,
    0x30eb, 0x30fc, 0x30d6, 0x30eb, 0x20f, 0x30ec, 0x30e0, 0x50f,
    0x30ec, 0x30f3, 0x30c8, 0x30b2, 0x30f3, 0x30f, 0x30ef, 0x30c3,
    0x30c8, 0x210, 0x30, 0x70b9, 0x210, 0x31, 0x70b9, 0x210,
    0x32, 0x70b9, 0x210, 0x33, 0x70b9, 0x210, 0x34, 0x70b9,
    0x210, 0x35, 0x70b9, 0x210, 0x36, 0x70b9, 0x210, 0x37,
    0x70b9, 0x210, 0x38, 0x70b9, 0x210, 0x39, 0x70b9, 0x310,
    0x31, 0x30, 0x70b9, 0x310, 0x31, 0x31, 0x70b9, 0x310,
    0x31, 0x32, 0x70b9, 0x310, 0x31, 0x33, 0x70b9, 0x310,
    0x31, 0x34, 0x70b9, 0x310, 0x31, 0x35, 0x70b9, 0x310,
    0x31, 0x36, 0x70b9, 0x310, 0x31, 0x37, 0x70b9, 0x310,
    0x31, 0x38, 0x70b9, 0x310, 0x31, 0x39, 0x70b9, 0x310,
    0x32, 0x30, 0x70b9, 0x310, 0x32, 0x31, 0x70b9, 0x310,
    0x32, 0x32, 0x70b9, 0x310, 0x32, 0x33, 0x70b9, 0x310,
    0x32, 0x34, 0x70b9, 0x30f, 0x68, 0x50, 0x61, 0x20f,
    0x64, 0x61, 0x20f, 0x41, 0x55, 0x30f, 0x62, 0x61,
    0x72, 0x20f, 0x6f, 0x56, 0x20f, 0x70, 0x63, 0x20f,
    0x64, 0x6d, 0x30f, 0x64, 0x6d, 0xb2, 0x30f, 0x64,
    0x6d, 0xb3, 0x20f, 0x49, 0x55, 0x20f, 0x5e73, 0x6210,
    0x20f, 0x662d, 0x548c, 0x20f, 0x5927, 0x6b63, 0x20f, 0x660e,
    0x6cbb, 0x40f, 0x682a, 0x5f0f, 0x4f1a, 0x793e, 0x20f, 0x70,
    0x41, 0x20f, 0x6e, 0x41, 0x20f, 0x3bc, 0x41, 0x20f,
    0x6d, 0x41, 0x20f, 0x6b, 0x41, 0x20f, 0x4b, 0x42,
    0x20f, 0x4d, 0x42, 0x20f, 0x47, 0x42, 0x30f, 0x63,
    0x61, 0x6c, 0x40f, 0x6b, 0x63, 0x61, 0x6c, 0x20f,
    0x70, 0x46, 0x20f, 0x6e, 0x46, 0x20f, 0x3bc, 0x46,
    0x20f, 0x3bc, 0x67, 0x20f, 0x6d, 0x67, 0x20f, 0x6b,
    0x67, 0x20f, 0x48, 0x7a, 0x30f, 0x6b, 0x48, 0x7a,
    0x30f, 0x4d, 0x48, 0x7a, 0x30f, 0x47, 0x48, 0x7a,
    0x30f, 0x54, 0x48, 0x7a, 0x20f, 0x3bc, 0x2113, 0x20f,
    0x6d, 0x2113, 0x20f, 0x64, 0x2113, 0x20f, 0x6b, 0x2113,
    0x20f, 0x66, 0x6d, 0x20f, 0x6e, 0x6d, 0x20f, 0x3bc,
    0x6d, 0x20f, 0x6d, 0x6d, 0x20f, 0x63, 0x6d, 0x20f,
    0x6b, 0x6d, 0x30f, 0x6d, 0x6d, 0xb2, 0x30f, 0x63,
    0x6d, 0xb2, 0x20f, 0x6d, 0xb2, 0x30f, 0x6b, 0x6d,
    0xb2, 0x30f, 0x6d, 0x6d, 0xb3, 0x30f, 0x63, 0x6d,
    0xb3, 0x20f, 0x6d, 0xb3, 0x30f, 0x6b, 0x6d, 0xb3,
    0x30f, 0x6d, 0x2215, 0x73, 0x40f, 0x6d, 0x2215, 0x73,
    0xb2, 0x20f, 0x50, 0x61, 0x30f, 0x6b, 0x50, 0x61,
    0x30f, 0x4d, 0x50, 0x61, 0x30f, 0x47, 0x50, 0x61,
    0x30f, 0x72, 0x61, 0x64, 0x50f, 0x72, 0x61, 0x64,
    0x2215, 0x73, 0x60f, 0x72, 0x61, 0x64, 0x2215, 0x73,
    0xb2, 0x20f, 0x70, 0x73, 0x20f, 0x6e, 0x73, 0x20f,
    0x3bc, 0x73, 0x20f, 0x6d, 0x73, 0x20f, 0x70, 0x56,
    0x20f, 0x6e, 0x56, 0x20f, 0x3bc, 0x56, 0x20f, 0x6d,
    0x56, 0x20f, 0x6b, 0x56, 0x20f, 0x4d, 0x56, 0x20f,
    0x70, 0x57, 0x20f, 0x6e, 0x57, 0x20f, 0x3bc, 0x57,
    0x20f, 0x6d, 0x57, 0x20f, 0x6b, 0x57, 0x20f, 0x4d,
    0x57, 0x20f, 0x6b, 0x3a9, 0x20f, 0x4d, 0x3a9, 0x40f,
    0x61, 0x2e, 0x6d, 0x2e, 0x20f, 0x42, 0x71, 0x20f,
    0x63, 0x63, 0x20f, 0x63, 0x64, 0x40f, 0x43, 0x2215,
    0x6b, 0x67, 0x30f, 0x43, 0x6f, 0x2e, 0x20f, 0x64,
    0x42, 0x20f, 0x47, 0x79, 0x20f, 0x68, 0x61, 0x20f,
    0x48, 0x50, 0x20f, 0x69, 0x6e, 0x20f, 0x4b, 0x4b,
    0x20f, 0x4b, 0x4d, 0x20f, 0x6b, 0x74, 0x20f, 0x6c,
    0x6d, 0x20f, 0x6c, 0x6e, 0x30f, 0x6c, 0x6f, 0x67,
    0x20f, 0x6c, 0x78, 0x20f, 0x6d, 0x62, 0x30f, 0x6d,
    0x69, 0x6c, 0x30f, 0x6d, 0x6f, 0x6c, 0x20f, 0x50,
    0x48, 0x40f, 0x70, 0x2e, 0x6d, 0x2e, 0x30f, 0x50,
    0x50, 0x4d, 0x20f, 0x50, 0x52, 0x20f, 0x73, 0x72,
    0x20f, 0x53, 0x76, 0x20f, 0x57, 0x62, 0x30f, 0x56,
    0x2215, 0x6d, 0x30f, 0x41, 0x2215, 0x6d, 0x210, 0x31,
    0x65e5, 0x210, 0x32, 0x65e5, 0x210, 0x33, 0x65e5, 0x210,
    0x34, 0x65e5, 0x210, 0x35, 0x65e5, 0x210, 0x36, 0x65e5,
    0x210, 0x37, 0x65e5, 0x210, 0x38, 0x65e5, 0x210, 0x39,
    0x65e5, 0x310, 0x31, 0x30, 0x65e5, 0x310, 0x31, 0x31,
    0x65e5, 0x310, 0x31, 0x32, 0x65e5, 0x310, 0x31, 0x33,
    0x65e5, 0x310, 0x31, 0x34, 0x65e5, 0x310, 0x31, 0x35,
    0x65e5, 0x310, 0x31, 0x36, 0x65e5, 0x310, 0x31, 0x37,
    0x65e5, 0x310, 0x31, 0x38, 0x65e5, 0x310, 0x31, 0x39,
    0x65e5, 0x310, 0x32, 0x30, 0x65e5, 0x310, 0x32, 0x31,
    0x65e5, 0x310, 0x32, 0x32, 0x65e5, 0x310, 0x32, 0x33,
    0x65e5, 0x310, 0x32, 0x34, 0x65e5, 0x310, 0x32, 0x35,
    0x65e5, 0x310, 0x32, 0x36, 0x65e5, 0x310, 0x32, 0x37,
    0x65e5, 0x310, 0x32, 0x38, 0x65e5, 0x310, 0x32, 0x39,
    0x65e5, 0x310, 0x33, 0x30, 0x65e5, 0x310, 0x33, 0x31,
    0x65e5, 0x30f, 0x67, 0x61, 0x6c, 0x109, 0x44a, 0x109,
    0x44c, 0x109, 0xa76f, 0x109, 0x126, 0x109, 0x153, 0x109,
    0xa727, 0x109, 0xab37, 0x109, 0x26b, 0x109, 0xab52, 0x101,
    0x8c48, 0x101, 0x66f4, 0x101, 0x8eca, 0x101, 0x8cc8, 0x101,
    0x6ed1, 0x101, 0x4e32, 0x101, 0x53e5, 0x101, 0x9f9c, 0x101,
    0x9f9c, 0x101, 0x5951, 0x101, 0x91d1, 0x101, 0x5587, 0x101,
    0x5948, 0x101, 0x61f6, 0x101, 0x7669, 0x101, 0x7f85, 0x101,
    0x863f, 0x101, 0x87ba, 0x101, 0x88f8, 0x101, 0x908f, 0x101,
    0x6a02, 0x101, 0x6d1b, 0x101, 0x70d9, 0x101, 0x73de, 0x101,
    0x843d, 0x101, 0x916a, 0x101, 0x99f1, 0x101, 0x4e82, 0x101,
    0x5375, 0x101, 0x6b04, 0x101, 0x721b, 0x101, 0x862d, 0x101,
    0x9e1e, 0x101, 0x5d50, 0x101, 0x6feb, 0x101, 0x85cd, 0x101,
    0x8964, 0x101, 0x62c9, 0x101, 0x81d8, 0x101, 0x881f, 0x101,
    0x5eca, 0x101, 0x6717, 0x101, 0x6d6a, 0x101, 0x72fc, 0x101,
    0x90ce, 0x101, 0x4f86, 0x101, 0x51b7, 0x101, 0x52de, 0x101,
    0x64c4, 0x101, 0x6ad3, 0x101, 0x7210, 0x101, 0x76e7, 0x101,
    0x8001, 0x101, 0x8606, 0x101, 0x865c, 0x101, 0x8def, 0x101,
    0x9732, 0x101, 0x9b6f, 0x101, 0x9dfa, 0x101, 0x788c, 0x101,
    0x797f, 0x101, 0x7da0, 0x101, 0x83c9, 0x101, 0x9304, 0x101,
    0x9e7f, 0x101, 0x8ad6, 0x101, 0x58df, 0x101, 0x5f04, 0x101,
    0x7c60, 0x101, 0x807e, 0x101, 0x7262, 0x101, 0x78ca, 0x101,
    0x8cc2, 0x101, 0x96f7, 0x101, 0x58d8, 0x101, 0x5c62, 0x101,
    0x6a13, 0x101, 0x6dda, 0x101, 0x6f0f, 0x101, 0x7d2f, 0x101,
    0x7e37, 0x101, 0x964b, 0x101, 0x52d2, 0x101, 0x808b, 0x101,
    0x51dc, 0x101, 0x51cc, 0x101, 0x7a1c, 0x101, 0x7dbe, 0x101,
    0x83f1, 0x101, 0x9675, 0x101, 0x8b80, 0x101, 0x62cf, 0x101,
    0x6a02, 0x101, 0x8afe, 0x101, 0x4e39, 0x101, 0x5be7, 0x101,
    0x6012, 0x101, 0x7387, 0x101, 0x7570, 0x101, 0x5317, 0x101,
    0x78fb, 0x101, 0x4fbf, 0x101, 0x5fa9, 0x101, 0x4e0d, 0x101,
    0x6ccc, 0x101, 0x6578, 0x101, 0x7d22, 0x101, 0x53c3, 0x101,
    0x585e, 0x101, 0x7701, 0x101, 0x8449, 0x101, 0x8aaa, 0x101,
    0x6bba, 0x101, 0x8fb0, 0x101, 0x6c88, 0x101, 0x62fe, 0x101,
    0x82e5, 0x101, 0x63a0, 0x101, 0x7565, 0x101, 0x4eae, 0x101,
    0x5169, 0x101, 0x51c9, 0x101, 0x6881, 0x101, 0x7ce7, 0x101,
    0x826f, 0x101, 0x8ad2, 0x101, 0x91cf, 0x101, 0x52f5, 0x101,
    0x5442, 0x101, 0x5973, 0x101, 0x5eec, 0x101, 0x65c5, 0x101,
    0x6ffe, 0x101, 0x792a, 0x101, 0x95ad, 0x101, 0x9a6a, 0x101,
    0x9e97, 0x101, 0x9ece, 0x101, 0x529b, 0x101, 0x66c6, 0x101,
    0x6b77, 0x101, 0x8f62, 0x101, 0x5e74, 0x101, 0x6190, 0x101,
    0x6200, 0x101, 0x649a, 0x101, 0x6f23, 0x101, 0x7149, 0x101,
    0x7489, 0x101, 0x79ca, 0x101, 0x7df4, 0x101, 0x806f, 0x101,
    0x8f26, 0x101, 0x84ee, 0x101, 0x9023, 0x101, 0x934a, 0x101,
    0x5217, 0x101, 0x52a3, 0x101, 0x54bd, 0x101, 0x70c8, 0x101,
    0x88c2, 0x101, 0x8aaa, 0x101, 0x5ec9, 0x101, 0x5ff5, 0x101,
    0x637b, 0x101, 0x6bae, 0x101, 0x7c3e, 0x101, 0x7375, 0x101,
    0x4ee4, 0x101, 0x56f9, 0x101, 0x5be7, 0x101, 0x5dba, 0x101,
    0x601c, 0x101, 0x73b2, 0x101, 0x7469, 0x101, 0x7f9a, 0x101,
    0x8046, 0x101, 0x9234, 0x101, 0x96f6, 0x101, 0x9748, 0x101,
    0x9818, 0x101, 0x4f8b, 0x101, 0x79ae, 0x101, 0x91b4, 0x101,
    0x96b8, 0x101, 0x60e1, 0x101, 0x4e86, 0x101, 0x50da, 0x101,
    0x5bee, 0x101, 0x5c3f, 0x101, 0x6599, 0x101, 0x6a02, 0x101,
    0x71ce, 0x101, 0x7642, 0x101, 0x84fc, 0x101, 0x907c, 0x101,
    0x9f8d, 0x101, 0x6688, 0x101, 0x962e, 0x101, 0x5289, 0x101,
    0x677b, 0x101, 0x67f3, 0x101, 0x6d41, 0x101, 0x6e9c, 0x101,
    0x7409, 0x101, 0x7559, 0x101, 0x786b, 0x101, 0x7d10, 0x101,
    0x985e, 0x101, 0x516d, 0x101, 0x622e, 0x101, 0x9678, 0x101,
    0x502b, 0x101, 0x5d19, 0x101, 0x6dea, 0x101, 0x8f2a, 0x101,
    0x5f8b, 0x101, 0x6144, 0x101, 0x6817, 0x101, 0x7387, 0x101,
    0x9686, 0x101, 0x5229, 0x101, 0x540f, 0x101, 0x5c65, 0x101,
    0x6613, 0x101, 0x674e, 0x101, 0x68a8, 0x101, 0x6ce5, 0x101,
    0x7406, 0x101, 0x75e2, 0x101, 0x7f79, 0x101, 0x88cf, 0x101,
    0x88e1, 0x101, 0x91cc, 0x101, 0x96e2, 0x101, 0x533f, 0x101,
    0x6eba, 0x101, 0x541d, 0x101, 0x71d0, 0x101, 0x7498, 0x101,
    0x85fa, 0x101, 0x96a3, 0x101, 0x9c57, 0x101, 0x9e9f, 0x101,
    0x6797, 0x101, 0x6dcb, 0x101, 0x81e8, 0x101, 0x7acb, 0x101,
    0x7b20, 0x101, 0x7c92, 0x101, 0x72c0, 0x101, 0x7099, 0x101,
    0x8b58, 0x101, 0x4ec0, 0x101, 0x8336, 0x101, 0x523a, 0x101,
    0x5207, 0x101, 0x5ea6, 0x101, 0x62d3, 0x101, 0x7cd6, 0x101,
    0x5b85, 0x101, 0x6d1e, 0x101, 0x66b4, 0x101, 0x8f3b, 0x101,
    0x884c, 0x101, 0x964d, 0x101, 0x898b, 0x101, 0x5ed3, 0x101,
    0x5140, 0x101, 0x55c0, 0x101, 0x585a, 0x101, 0x6674, 0x101,
    0x51de, 0x101, 0x732a, 0x101, 0x76ca, 0x101, 0x793c, 0x101,
    0x795e, 0x101, 0x7965, 0x101, 0x798f, 0x101, 0x9756, 0x101,
    0x7cbe, 0x101, 0x7fbd, 0x101, 0x8612, 0x101, 0x8af8, 0x101,
    0x9038, 0x101, 0x90fd, 0x101, 0x98ef, 0x101, 0x98fc, 0x101,
    0x9928, 0x101, 0x9db4, 0x101, 0x90de, 0x101, 0x96b7, 0x101,
    0x4fae, 0x101, 0x50e7, 0x101, 0x514d, 0x101, 0x52c9, 0x101,
    0x52e4, 0x101, 0x5351, 0x101, 0x559d, 0x101, 0x5606, 0x101,
    0x5668, 0x101, 0x5840, 0x101, 0x58a8, 0x101, 0x5c64, 0x101,
    0x5c6e, 0x101, 0x6094, 0x101, 0x6168, 0x101, 0x618e, 0x101,
    0x61f2, 0x101, 0x654f, 0x101, 0x65e2, 0x101, 0x6691, 0x101,
    0x6885, 0x101, 0x6d77, 0x101, 0x6e1a, 0x101, 0x6f22, 0x101,
    0x716e, 0x101, 0x722b, 0x101, 0x7422, 0x101, 0x7891, 0x101,
    0x793e, 0x101, 0x7949, 0x101, 0x7948, 0x101, 0x7950, 0x101,
    0x7956, 0x101, 0x795d, 0x101, 0x798d, 0x101, 0x798e, 0x101,
    0x7a40, 0x101, 0x7a81, 0x101, 0x7bc0, 0x101, 0x7df4, 0x101,
    0x7e09, 0x101, 0x7e41, 0x101, 0x7f72, 0x101, 0x8005, 0x101,
    0x81ed, 0x101, 0x8279, 0x101, 0x8279, 0x101, 0x8457, 0x101,
    0x8910, 0x101, 0x8996, 0x101, 0x8b01, 0x101, 0x8b39, 0x101,
    0x8cd3, 0x101, 0x8d08, 0x101, 0x8fb6, 0x101, 0x9038, 0x101,
    0x96e3, 0x101, 0x97ff, 0x101, 0x983b, 0x101, 0x6075, 0x201,
    0xd850, 0xdeee, 0x101, 0x8218, 0x101, 0x4e26, 0x101, 0x51b5,
    0x101, 0x5168, 0x101, 0x4f80, 0x101, 0x5145, 0x101, 0x5180,
    0x101, 0x52c7, 0x101, 0x52fa, 0x101, 0x559d, 0x101, 0x5555,
    0x101, 0x5599, 0x101, 0x55e2, 0x101, 0x585a, 0x101, 0x58b3,
    0x101, 0x5944, 0x101, 0x5954, 0x101, 0x5a62, 0x101, 0x5b28,
    0x101, 0x5ed2, 0x101, 0x5ed9, 0x101, 0x5f69, 0x101, 0x5fad,
    0x101, 0x60d8, 0x101, 0x614e, 0x101, 0x6108, 0x101, 0x618e,
    0x101, 0x6160, 0x101, 0x61f2, 0x101, 0x6234, 0x101, 0x63c4,
    0x101, 0x641c, 0x101, 0x6452, 0x101, 0x6556, 0x101, 0x6674,
    0x101, 0x6717, 0x101, 0x671b, 0x101, 0x6756, 0x101, 0x6b79,
    0x101, 0x6bba, 0x101, 0x6d41, 0x101, 0x6edb, 0x101, 0x6ecb,
    0x101, 0x6f22, 0x101, 0x701e, 0x101, 0x716e, 0x101, 0x77a7,
    0x101, 0x7235, 0x101, 0x72af, 0x101, 0x732a, 0x101, 0x7471,
    0x101, 0x7506, 0x101, 0x753b, 0x101, 0x761d, 0x101, 0x761f,
    0x101, 0x76ca, 0x101, 0x76db, 0x101, 0x76f4, 0x101, 0x774a,
    0x101, 0x7740, 0x101, 0x78cc, 0x101, 0x7ab1, 0x101, 0x7bc0,
    0x101, 0x7c7b, 0x101, 0x7d5b, 0x101, 0x7df4, 0x101, 0x7f3e,
    0x101, 0x8005, 0x101, 0x8352, 0x101, 0x83ef, 0x101, 0x8779,
    0x101, 0x8941, 0x101, 0x8986, 0x101, 0x8996, 0x101, 0x8abf,
    0x101, 0x8af8, 0x101, 0x8acb, 0x101, 0x8b01, 0x101, 0x8afe,
    0x101, 0x8aed, 0x101, 0x8b39, 0x101, 0x8b8a, 0x101, 0x8d08,
    0x101, 0x8f38, 0x101, 0x9072, 0x101, 0x9199, 0x101, 0x9276,
    0x101, 0x967c, 0x101, 0x96e3, 0x101, 0x9756, 0x101, 0x97db,
    0x101, 0x97ff, 0x101, 0x980b, 0x101, 0x983b, 0x101, 0x9b12,
    0x101, 0x9f9c, 0x201, 0xd84a, 0xdc4a, 0x201, 0xd84a, 0xdc44,
    0x201, 0xd84c, 0xdfd5, 0x101, 0x3b9d, 0x101, 0x4018, 0x101,
    0x4039, 0x201, 0xd854, 0xde49, 0x201, 0xd857, 0xdcd0, 0x201,
    0xd85f, 0xded3, 0x101, 0x9f43, 0x101, 0x9f8e, 0x210, 0x66,
    0x66, 0x210, 0x66, 0x69, 0x210, 0x66, 0x6c, 0x310,
    0x66, 0x66, 0x69, 0x310, 0x66, 0x66, 0x6c, 0x210,
    0x17f, 0x74, 0x210, 0x73, 0x74, 0x210, 0x574, 0x576,
    0x210, 0x574, 0x565, 0x210, 0x574, 0x56b, 0x210, 0x57e,
    0x576, 0x210, 0x574, 0x56d, 0x201, 0x5d9, 0x5b4, 0x201,
    0x5f2, 0x5b7, 0x102, 0x5e2, 0x102, 0x5d0, 0x102, 0x5d3,
    0x102, 0x5d4, 0x102, 0x5db, 0x102, 0x5dc, 0x102, 0x5dd,
    0x102, 0x5e8, 0x102, 0x5ea, 0x102, 0x2b, 0x201, 0x5e9,
    0x5c1, 0x201, 0x5e9, 0x5c2, 0x201, 0xfb49, 0x5c1, 0x201,
    0xfb49, 0x5c2, 0x201, 0x5d0, 0x5b7, 0x201, 0x5d0, 0x5b8,
    0x201, 0x5d0, 0x5bc, 0x201, 0x5d1, 0x5bc, 0x201, 0x5d2,
    0x5bc, 0x201, 0x5d3, 0x5bc, 0x201, 0x5d4, 0x5bc, 0x201,
    0x5d5, 0x5bc, 0x201, 0x5d6, 0x5bc, 0x201, 0x5d8, 0x5bc,
    0x201, 0x5d9, 0x5bc, 0x201, 0x5da, 0x5bc, 0x201, 0x5db,
    0x5bc, 0x201, 0x5dc, 0x5bc, 0x201, 0x5de, 0x5bc, 0x201,
    0x5e0, 0x5bc, 0x201, 0x5e1, 0x5bc, 0x201, 0x5e3, 0x5bc,
    0x201, 0x5e4, 0x5bc, 0x201, 0x5e6, 0x5bc, 0x201, 0x5e7,
    0x5bc, 0x201, 0x5e8, 0x5bc, 0x201, 0x5e9, 0x5bc, 0x201,
    0x5ea, 0x5bc, 0x201, 0x5d5, 0x5b9, 0x201, 0x5d1, 0x5bf,
    0x201, 0x5db, 0x5bf, 0x201, 0x5e4, 0x5bf, 0x210, 0x5d0,
    0x5dc, 0x107, 0x671, 0x106, 0x671, 0x107, 0x67b, 0x106,
    0x67b, 0x104, 0x67b, 0x105, 0x67b, 0x107, 0x67e, 0x106,
    0x67e, 0x104, 0x67e, 0x105, 0x67e, 0x107, 0x680, 0x106,
    0x680, 0x104, 0x680, 0x105, 0x680, 0x107, 0x67a, 0x106,
    0x67a, 0x104, 0x67a, 0x105, 0x67a, 0x107, 0x67f, 0x106,
    0x67f, 0x104, 0x67f, 0x105, 0x67f, 0x107, 0x679, 0x106,
    0x679, 0x104, 0x679, 0x105, 0x679, 0x107, 0x6a4, 0x106,
    0x6a4, 0x104, 0x6a4, 0x105, 0x6a4, 0x107, 0x6a6, 0x106,
    0x6a6, 0x104, 0x6a6, 0x105, 0x6a6, 0x107, 0x684, 0x106,
    0x684, 0x104, 0x684, 0x105, 0x684, 0x107, 0x683, 0x106,
    0x683, 0x104, 0x683, 0x105, 0x683, 0x107, 0x686, 0x106,
    0x686, 0x104, 0x686, 0x105, 0x686, 0x107, 0x687, 0x106,
    0x687, 0x104, 0x687, 0x105, 0x687, 0x107, 0x68d, 0x106,
    0x68d, 0x107, 0x68c, 0x106, 0x68c, 0x107, 0x68e, 0x106,
    0x68e, 0x107, 0x688, 0x106, 0x688, 0x107, 0x698, 0x106,
    0x698, 0x107, 0x691, 0x106, 0x691, 0x107, 0x6a9, 0x106,
    0x6a9, 0x104, 0x6a9, 0x105, 0x6a9, 0x107, 0x6af, 0x106,
    0x6af, 0x104, 0x6af, 0x105, 0x6af, 0x107, 0x6b3, 0x106,
    0x6b3, 0x104, 0x6b3, 0x105, 0x6b3, 0x107, 0x6b1, 0x106,
    0x6b1, 0x104, 0x6b1, 0x105, 0x6b1, 0x107, 0x6ba, 0x106,
    0x6ba, 0x107, 0x6bb, 0x106, 0x6bb, 0x104, 0x6bb, 0x105,
    0x6bb, 0x107, 0x6c0, 0x106, 0x6c0, 0x107, 0x6c1, 0x106,
    0x6c1, 0x104, 0x6c1, 0x105, 0x6c1, 0x107, 0x6be, 0x106,
    0x6be, 0x104, 0x6be, 0x105, 0x6be, 0x107, 0x6d2, 0x106,
    0x6d2, 0x107, 0x6d3, 0x106, 0x6d3, 0x107, 0x6ad, 0x106,
    0x6ad, 0x104, 0x6ad, 0x105, 0x6ad, 0x107, 0x6c7, 0x106,
    0x6c7, 0x107, 0x6c6, 0x106, 0x6c6, 0x107, 0x6c8, 0x106,
    0x6c8, 0x107, 0x677, 0x107, 0x6cb, 0x106, 0x6cb, 0x107,
    0x6c5, 0x106, 0x6c5, 0x107, 0x6c9, 0x106, 0x6c9, 0x107,
    0x6d0, 0x106, 0x6d0, 0x104, 0x6d0, 0x105, 0x6d0, 0x104,
    0x649, 0x105, 0x649, 0x207, 0x626, 0x627, 0x206, 0x626,
    0x627, 0x207, 0x626, 0x6d5, 0x206, 0x626, 0x6d5, 0x207,
    0x626, 0x648, 0x206, 0x626, 0x648, 0x207, 0x626, 0x6c7,
    0x206, 0x626, 0x6c7, 0x207, 0x626, 0x6c6, 0x206, 0x626,
    0x6c6, 0x207, 0x626, 0x6c8, 0x206, 0x626, 0x6c8, 0x207,
    0x626, 0x6d0, 0x206, 0x626, 0x6d0, 0x204, 0x626, 0x6d0,
    0x207, 0x626, 0x649, 0x206, 0x626, 0x649, 0x204, 0x626,
    0x649, 0x107, 0x6cc, 0x106, 0x6cc, 0x104, 0x6cc, 0x105,
    0x6cc, 0x207, 0x626, 0x62c, 0x207, 0x626, 0x62d, 0x207,
    0x626, 0x645, 0x207, 0x626, 0x649, 0x207, 0x626, 0x64a,
    0x207, 0x628, 0x62c, 0x207, 0x628, 0x62d, 0x207, 0x628,
    0x62e, 0x207, 0x628, 0x645, 0x207, 0x628, 0x649, 0x207,
    0x628, 0x64a, 0x207, 0x62a, 0x62c, 0x207, 0x62a, 0x62d,
    0x207, 0x62a, 0x62e, 0x207, 0x62a, 0x645, 0x207, 0x62a,
    0x649, 0x207, 0x62a, 0x64a, 0x207, 0x62b, 0x62c, 0x207,
    0x62b, 0x645, 0x207, 0x62b, 0x649, 0x207, 0x62b, 0x64a,
    0x207, 0x62c, 0x62d, 0x207, 0x62c, 0x645, 0x207, 0x62d,
    0x62c, 0x207, 0x62d, 0x645, 0x207, 0x62e, 0x62c, 0x207,
    0x62e, 0x62d, 0x207, 0x62e, 0x645, 0x207, 0x633, 0x62c,
    0x207, 0x633, 0x62d, 0x207, 0x633, 0x62e, 0x207, 0x633,
    0x645, 0x207, 0x635, 0x62d, 0x207, 0x635, 0x645, 0x207,
    0x636, 0x62c, 0x207, 0x636, 0x62d, 0x207, 0x636, 0x62e,
    0x207, 0x636, 0x645, 0x207, 0x637, 0x62d, 0x207, 0x637,
    0x645, 0x207, 0x638, 0x645, 0x207, 0x639, 0x62c, 0x207,
    0x639, 0x645, 0x207, 0x63a, 0x62c, 0x207, 0x63a, 0x645,
    0x207, 0x641, 0x62c, 0x207, 0x641, 0x62d, 0x207, 0x641,
    0x62e, 0x207, 0x641, 0x645, 0x207, 0x641, 0x649, 0x207,
    0x641, 0x64a, 0x207, 0x642, 0x62d, 0x207, 0x642, 0x645,
    0x207, 0x642, 0x649, 0x207, 0x642, 0x64a, 0x207, 0x643,
    0x627, 0x207, 0x643, 0x62c, 0x207, 0x643, 0x62d, 0x207,
    0x643, 0x62e, 0x207, 0x643, 0x644, 0x207, 0x643, 0x645,
    0x207, 0x643, 0x649, 0x207, 0x643, 0x64a, 0x207, 0x644,
    0x62c, 0x207, 0x644, 0x62d, 0x207, 0x644, 0x62e, 0x207,
    0x644, 0x645, 0x207, 0x644, 0x649, 0x207, 0x644, 0x64a,
    0x207, 0x645, 0x62c, 0x207, 0x645, 0x62d, 0x207, 0x645,
    0x62e, 0x207, 0x645, 0x645, 0x207, 0x645, 0x649, 0x207,
    0x645, 0x64a, 0x207, 0x646, 0x62c, 0x207, 0x646, 0x62d,
    0x207, 0x646, 0x62e, 0x207, 0x646, 0x645, 0x207, 0x646,
    0x649, 0x207, 0x646, 0x64a, 0x207, 0x647, 0x62c, 0x207,
    0x647, 0x645, 0x207, 0x647, 0x649, 0x207, 0x647, 0x64a,
    0x207, 0x64a, 0x62c, 0x207, 0x64a, 0x62d, 0x207, 0x64a,
    0x62e, 0x207, 0x64a, 0x645, 0x207, 0x64a, 0x649, 0x207,
    0x64a, 0x64a, 0x207, 0x630, 0x670, 0x207, 0x631, 0x670,
    0x207, 0x649, 0x670, 0x307, 0x20, 0x64c, 0x651, 0x307,
    0x20, 0x64d, 0x651, 0x307, 0x20, 0x64e, 0x651, 0x307,
    0x20, 0x64f, 0x651, 0x307, 0x20, 0x650, 0x651, 0x307,
    0x20, 0x651, 0x670, 0x206, 0x626, 0x631, 0x206, 0x626,
    0x632, 0x206, 0x626, 0x645, 0x206, 0x626, 0x646, 0x206,
    0x626, 0x649, 0x206, 0x626, 0x64a, 0x206, 0x628, 0x631,
    0x206, 0x628, 0x632, 0x206, 0x628, 0x645, 0x206, 0x628,
    0x646, 0x206, 0x628, 0x649, 0x206, 0x628, 0x64a, 0x206,
    0x62a, 0x631, 0x206, 0x62a, 0x632, 0x206, 0x62a, 0x645,
    0x206, 0x62a, 0x646, 0x206, 0x62a, 0x649, 0x206, 0x62a,
    0x64a, 0x206, 0x62b, 0x631, 0x206, 0x62b, 0x632, 0x206,
    0x62b, 0x645, 0x206, 0x62b, 0x646, 0x206, 0x62b, 0x649,
    0x206, 0x62b, 0x64a, 0x206, 0x641, 0x649, 0x206, 0x641,
    0x64a, 0x206, 0x642, 0x649, 0x206, 0x642, 0x64a, 0x206,
    0x643, 0x627, 0x206, 0x643, 0x644, 0x206, 0x643, 0x645,
    0x206, 0x643, 0x649, 0x206, 0x643, 0x64a, 0x206, 0x644,
    0x645, 0x206, 0x644, 0x649, 0x206, 0x644, 0x64a, 0x206,
    0x645, 0x627, 0x206, 0x645, 0x645, 0x206, 0x646, 0x631,
    0x206, 0x646, 0x632, 0x206, 0x646, 0x645, 0x206, 0x646,
    0x646, 0x206, 0x646, 0x649, 0x206, 0x646, 0x64a, 0x206,
    0x649, 0x670, 0x206, 0x64a, 0x631, 0x206, 0x64a, 0x632,
    0x206, 0x64a, 0x645, 0x206, 0x64a, 0x646, 0x206, 0x64a,
    0x649, 0x206, 0x64a, 0x64a, 0x204, 0x626, 0x62c, 0x204,
    0x626, 0x62d, 0x204, 0x626, 0x62e, 0x204, 0x626, 0x645,
    0x204, 0x626, 0x647, 0x204, 0x628, 0x62c, 0x204, 0x628,
    0x62d, 0x204, 0x628, 0x62e, 0x204, 0x628, 0x645, 0x204,
    0x628, 0x647, 0x204, 0x62a, 0x62c, 0x204, 0x62a, 0x62d,
    0x204, 0x62a, 0x62e, 0x204, 0x62a, 0x645, 0x204, 0x62a,
    0x647, 0x204, 0x62b, 0x645, 0x204, 0x62c, 0x62d, 0x204,
    0x62c, 0x645, 0x204, 0x62d, 0x62c, 0x204, 0x62d, 0x645,
    0x204, 0x62e, 0x62c, 0x204, 0x62e, 0x645, 0x204, 0x633,
    0x62c, 0x204, 0x633, 0x62d, 0x204, 0x633, 0x62e, 0x204,
    0x633, 0x645, 0x204, 0x635, 0x62d, 0x204, 0x635, 0x62e,
    0x204, 0x635, 0x645, 0x204, 0x636, 0x62c, 0x204, 0x636,
    0x62d, 0x204, 0x636, 0x62e, 0x204, 0x636, 0x645, 0x204,
    0x637, 0x62d, 0x204, 0x638, 0x645, 0x204, 0x639, 0x62c,
    0x204, 0x639, 0x645, 0x204, 0x63a, 0x62c, 0x204, 0x63a,
    0x645, 0x204, 0x641, 0x62c, 0x204, 0x641, 0x62d, 0x204,
    0x641, 0x62e, 0x204, 0x641, 0x645, 0x204, 0x642, 0x62d,
    0x204, 0x642, 0x645, 0x204, 0x643, 0x62c, 0x204, 0x643,
    0x62d, 0x204, 0x643, 0x62e, 0x204, 0x643, 0x644, 0x204,
    0x643, 0x645, 0x204, 0x644, 0x62c, 0x204, 0x644, 0x62d,
    0x204, 0x644, 0x62e, 0x204, 0x644, 0x645, 0x204, 0x644,
    0x647, 0x204, 0x645, 0x62c, 0x204, 0x645, 0x62d, 0x204,
    0x645, 0x62e, 0x204, 0x645, 0x645, 0x204, 0x646, 0x62c,
    0x204, 0x646, 0x62d, 0x204, 0x646, 0x62e, 0x204, 0x646,
    0x645, 0x204, 0x646, 0x647, 0x204, 0x647, 0x62c, 0x204,
    0x647, 0x645, 0x204, 0x647, 0x670, 0x204, 0x64a, 0x62c,
    0x204, 0x64a, 0x62d, 0x204, 0x64a, 0x62e, 0x204, 0x64a,
    0x645, 0x204, 0x64a, 0x647, 0x205, 0x626, 0x645, 0x205,
    0x626, 0x647, 0x205, 0x628, 0x645, 0x205, 0x628, 0x647,
    0x205, 0x62a, 0x645, 0x205, 0x62a, 0x647, 0x205, 0x62b,
    0x645, 0x205, 0x62b, 0x647, 0x205, 0x633, 0x645, 0x205,
    0x633, 0x647, 0x205, 0x634, 0x645, 0x205, 0x634, 0x647,
    0x205, 0x643, 0x644, 0x205, 0x643, 0x645, 0x205, 0x644,
    0x645, 0x205, 0x646, 0x645, 0x205, 0x646, 0x647, 0x205,
    0x64a, 0x645, 0x205, 0x64a, 0x647, 0x305, 0x640, 0x64e,
    0x651, 0x305, 0x640, 0x64f, 0x651, 0x305, 0x640, 0x650,
    0x651, 0x207, 0x637, 0x649, 0x207, 0x637, 0x64a, 0x207,
    0x639, 0x649, 0x207, 0x639, 0x64a, 0x207, 0x63a, 0x649,
    0x207, 0x63a, 0x64a, 0x207, 0x633, 0x649, 0x207, 0x633,
    0x64a, 0x207, 0x634, 0x649, 0x207, 0x634, 0x64a, 0x207,
    0x62d, 0x649, 0x207, 0x62d, 0x64a, 0x207, 0x62c, 0x649,
    0x207, 0x62c, 0x64a, 0x207, 0x62e, 0x649, 0x207, 0x62e,
    0x64a, 0x207, 0x635, 0x649, 0x207, 0x635, 0x64a, 0x207,
    0x636, 0x649, 0x207, 0x636, 0x64a, 0x207, 0x634, 0x62c,
    0x207, 0x634, 0x62d, 0x207, 0x634, 0x62e, 0x207, 0x634,
    0x645, 0x207, 0x634, 0x631, 0x207, 0x633, 0x631, 0x207,
    0x635, 0x631, 0x207, 0x636, 0x631, 0x206, 0x637, 0x649,
    0x206, 0x637, 0x64a, 0x206, 0x639, 0x649, 0x206, 0x639,
    0x64a, 0x206, 0x63a, 0x649, 0x206, 0x63a, 0x64a, 0x206,
    0x633, 0x649, 0x206, 0x633, 0x64a, 0x206, 0x634, 0x649,
    0x206, 0x634, 0x64a, 0x206, 0x62d, 0x649, 0x206, 0x62d,
    0x64a, 0x206, 0x62c, 0x649, 0x206, 0x62c, 0x64a, 0x206,
    0x62e, 0x649, 0x206, 0x62e, 0x64a, 0x206, 0x635, 0x649,
    0x206, 0x635, 0x64a, 0x206, 0x636, 0x649, 0x206, 0x636,
    0x64a, 0x206, 0x634, 0x62c, 0x206, 0x634, 0x62d, 0x206,
    0x634, 0x62e, 0x206, 0x634, 0x645, 0x206, 0x634, 0x631,
    0x206, 0x633, 0x631, 0x206, 0x635, 0x631, 0x206, 0x636,
    0x631, 0x204, 0x634, 0x62c, 0x204, 0x634, 0x62d, 0x204,
    0x634, 0x62e, 0x204, 0x634, 0x645, 0x204, 0x633, 0x647,
    0x204, 0x634, 0x647, 0x204, 0x637, 0x645, 0x205, 0x633,
    0x62c, 0x205, 0x633, 0x62d, 0x205, 0x633, 0x62e, 0x205,
    0x634, 0x62c, 0x205, 0x634, 0x62d, 0x205, 0x634, 0x62e,
    0x205, 0x637, 0x645, 0x205, 0x638, 0x645, 0x206, 0x627,
    0x64b, 0x207, 0x627, 0x64b, 0x304, 0x62a, 0x62c, 0x645,
    0x306, 0x62a, 0x62d, 0x62c, 0x304, 0x62a, 0x62d, 0x62c,
    0x304, 0x62a, 0x62d, 0x645, 0x304, 0x62a, 0x62e, 0x645,
    0x304, 0x62a, 0x645, 0x62c, 0x304, 0x62a, 0x645, 0x62d,
    0x304, 0x62a, 0x645, 0x62e, 0x306, 0x62c, 0x645, 0x62d,
    0x304, 0x62c, 0x645, 0x62d, 0x306, 0x62d, 0x645, 0x64a,
    0x306, 0x62d, 0x645, 0x649, 0x304, 0x633, 0x62d, 0x62c,
    0x304, 0x633, 0x62c, 0x62d, 0x306, 0x633, 0x62c, 0x649,
    0x306, 0x633, 0x645, 0x62d, 0x304, 0x633, 0x645, 0x62d,
    0x304, 0x633, 0x645, 0x62c, 0x306, 0x633, 0x645, 0x645,
    0x304, 0x633, 0x645, 0x645, 0x306, 0x635, 0x62d, 0x62d,
    0x304, 0x635, 0x62d, 0x62d, 0x306, 0x635, 0x645, 0x645,
    0x306, 0x634, 0x62d, 0x645, 0x304, 0x634, 0x62d, 0x645,
    0x306, 0x634, 0x62c, 0x64a, 0x306, 0x634, 0x645, 0x62e,
    0x304, 0x634, 0x645, 0x62e, 0x306, 0x634, 0x645, 0x645,
    0x304, 0x634, 0x645, 0x645, 0x306, 0x636, 0x62d, 0x649,
    0x306, 0x636, 0x62e, 0x645, 0x304, 0x636, 0x62e, 0x645,
    0x306, 0x637, 0x645, 0x62d, 0x304, 0x637, 0x645, 0x62d,
    0x304, 0x637, 0x645, 0x645, 0x306, 0x637, 0x645, 0x64a,
    0x306, 0x639, 0x62c, 0x645, 0x306, 0x639, 0x645, 0x645,
    0x304, 0x639, 0x645, 0x645, 0x306, 0x639, 0x645, 0x649,
    0x306, 0x63a, 0x645, 0x645, 0x306, 0x63a, 0x645, 0x64a,
    0x306, 0x63a, 0x645, 0x649, 0x306, 0x641, 0x62e, 0x645,
    0x304, 0x641, 0x62e, 0x645, 0x306, 0x642, 0x645, 0x62d,
    0x306, 0x642, 0x645, 0x645, 0x306, 0x644, 0x62d, 0x645,
    0x306, 0x644, 0x62d, 0x64a, 0x306, 0x644, 0x62d, 0x649,
    0x304, 0x644, 0x62c, 0x62c, 0x306, 0x644, 0x62c, 0x62c,
    0x306, 0x644, 0x62e, 0x645, 0x304, 0x644, 0x62e, 0x645,
    0x306, 0x644, 0x645, 0x62d, 0x304, 0x644, 0x645, 0x62d,
    0x304, 0x645, 0x62d, 0x62c, 0x304, 0x645, 0x62d, 0x645,
    0x306, 0x645, 0x62d, 0x64a, 0x304, 0x645, 0x62c, 0x62d,
    0x304, 0x645, 0x62c, 0x645, 0x304, 0x645, 0x62e, 0x62c,
    0x304, 0x645, 0x62e, 0x645, 0x304, 0x645, 0x62c, 0x62e,
    0x304, 0x647, 0x645, 0x62c, 0x304, 0x647, 0x645, 0x645,
    0x304, 0x646, 0x62d, 0x645, 0x306, 0x646, 0x62d, 0x649,
    0x306, 0x646, 0x62c, 0x645, 0x304, 0x646, 0x62c, 0x645,
    0x306, 0x646, 0x62c, 0x649, 0x306, 0x646, 0x645, 0x64a,
    0x306, 0x646, 0x645, 0x649, 0x306, 0x64a, 0x645, 0x645,
    0x304, 0x64a, 0x645, 0x645, 0x306, 0x628, 0x62e, 0x64a,
    0x306, 0x62a, 0x62c, 0x64a, 0x306, 0x62a, 0x62c, 0x649,
    0x306, 0x62a, 0x62e, 0x64a, 0x306, 0x62a, 0x62e, 0x649,
    0x306, 0x62a, 0x645, 0x64a, 0x306, 0x62a, 0x645, 0x649,
    0x306, 0x62c, 0x645, 0x64a, 0x306, 0x62c, 0x62d, 0x649,
    0x306, 0x62c, 0x645, 0x649, 0x306, 0x633, 0x62e, 0x649,
    0x306, 0x635, 0x62d, 0x64a, 0x306, 0x634, 0x62d, 0x64a,
    0x306, 0x636, 0x62d, 0x64a, 0x306, 0x644, 0x62c, 0x64a,
    0x306, 0x644, 0x645, 0x64a, 0x306, 0x64a, 0x62d, 0x64a,
    0x306, 0x64a, 0x62c, 0x64a, 0x306, 0x64a, 0x645, 0x64a,
    0x306, 0x645, 0x645, 0x64a, 0x306, 0x642, 0x645, 0x64a,
    0x306, 0x646, 0x62d, 0x64a, 0x304, 0x642, 0x645, 0x62d,
    0x304, 0x644, 0x62d, 0x645, 0x306, 0x639, 0x645, 0x64a,
    0x306, 0x643, 0x645, 0x64a, 0x304, 0x646, 0x62c, 0x62d,
    0x306, 0x645, 0x62e, 0x64a, 0x304, 0x644, 0x62c, 0x645,
    0x306, 0x643, 0x645, 0x645, 0x306, 0x644, 0x62c, 0x645,
    0x306, 0x646, 0x62c, 0x62d, 0x306, 0x62c, 0x62d, 0x64a,
    0x306, 0x62d, 0x62c, 0x64a, 0x306, 0x645, 0x62c, 0x64a,
    0x306, 0x641, 0x645, 0x64a, 0x306, 0x628, 0x62d, 0x64a,
    0x304, 0x643, 0x645, 0x645, 0x304, 0x639, 0x62c, 0x645,
    0x304, 0x635, 0x645, 0x645, 0x306, 0x633, 0x62e, 0x64a,
    0x306, 0x646, 0x62c, 0x64a, 0x307, 0x635, 0x644, 0x6d2,
    0x307, 0x642, 0x644, 0x6d2, 0x407, 0x627, 0x644, 0x644,
    0x647, 0x407, 0x627, 0x643, 0x628, 0x631, 0x407, 0x645,
    0x62d, 0x645, 0x62f, 0x407, 0x635, 0x644, 0x639, 0x645,
    0x407, 0x631, 0x633, 0x648, 0x644, 0x407, 0x639, 0x644,
    0x64a, 0x647, 0x407, 0x648, 0x633, 0x644, 0x645, 0x307,
    0x635, 0x644, 0x649, 0x1207, 0x635, 0x644, 0x649, 0x20,
    0x627, 0x644, 0x644, 0x647, 0x20, 0x639, 0x644, 0x64a,
    0x647, 0x20, 0x648, 0x633, 0x644, 0x645, 0x807, 0x62c,
    0x644, 0x20, 0x62c, 0x644, 0x627, 0x644, 0x647, 0x407,
    0x631, 0x6cc, 0x627, 0x644, 0x10b, 0x2c, 0x10b, 0x3001,
    0x10b, 0x3002, 0x10b, 0x3a, 0x10b, 0x3b, 0x10b, 0x21,
    0x10b, 0x3f, 0x10b, 0x3016, 0x10b, 0x3017, 0x10b, 0x2026,
    0x10b, 0x2025, 0x10b, 0x2014, 0x10b, 0x2013, 0x10b, 0x5f,
    0x10b, 0x5f, 0x10b, 0x28, 0x10b, 0x29, 0x10b, 0x7b,
    0x10b, 0x7d, 0x10b, 0x3014, 0x10b, 0x3015, 0x10b, 0x3010,
    0x10b, 0x3011, 0x10b, 0x300a, 0x10b, 0x300b, 0x10b, 0x3008,
    0x10b, 0x3009, 0x10b, 0x300c, 0x10b, 0x300d, 0x10b, 0x300e,
    0x10b, 0x300f, 0x10b, 0x5b, 0x10b, 0x5d, 0x110, 0x203e,
    0x110, 0x203e, 0x110, 0x203e, 0x110, 0x203e, 0x110, 0x5f,
    0x110, 0x5f, 0x110, 0x5f, 0x10e, 0x2c, 0x10e, 0x3001,
    0x10e, 0x2e, 0x10e, 0x3b, 0x10e, 0x3a, 0x10e, 0x3f,
    0x10e, 0x21, 0x10e, 0x2014, 0x10e, 0x28, 0x10e, 0x29,
    0x10e, 0x7b, 0x10e, 0x7d, 0x10e, 0x3014, 0x10e, 0x3015,
    0x10e, 0x23, 0x10e, 0x26, 0x10e, 0x2a, 0x10e, 0x2b,
    0x10e, 0x2d, 0x10e, 0x3c, 0x10e, 0x3e, 0x10e, 0x3d,
    0x10e, 0x5c, 0x10e, 0x24, 0x10e, 0x25, 0x10e, 0x40,
    0x207, 0x20, 0x64b, 0x205, 0x640, 0x64b, 0x207, 0x20,
    0x64c, 0x207, 0x20, 0x64d, 0x207, 0x20, 0x64e, 0x205,
    0x640, 0x64e, 0x207, 0x20, 0x64f, 0x205, 0x640, 0x64f,
    0x207, 0x20, 0x650, 0x205, 0x640, 0x650, 0x207, 0x20,
    0x651, 0x205, 0x640, 0x651, 0x207, 0x20, 0x652, 0x205,
    0x640, 0x652, 0x107, 0x621, 0x107, 0x622, 0x106, 0x622,
    0x107, 0x623, 0x106, 0x623, 0x107, 0x624, 0x106, 0x624,
    0x107, 0x625, 0x106, 0x625, 0x107, 0x626, 0x106, 0x626,
    0x104, 0x626, 0x105, 0x626, 0x107, 0x627, 0x106, 0x627,
    0x107, 0x628, 0x106, 0x628, 0x104, 0x628, 0x105, 0x628,
    0x107, 0x629, 0x106, 0x629, 0x107, 0x62a, 0x106, 0x62a,
    0x104, 0x62a, 0x105, 0x62a, 0x107, 0x62b, 0x106, 0x62b,
    0x104, 0x62b, 0x105, 0x62b, 0x107, 0x62c, 0x106, 0x62c,
    0x104, 0x62c, 0x105, 0x62c, 0x107, 0x62d, 0x106, 0x62d,
    0x104, 0x62d, 0x105, 0x62d, 0x107, 0x62e, 0x106, 0x62e,
    0x104, 0x62e, 0x105, 0x62e, 0x107, 0x62f, 0x106, 0x62f,
    0x107, 0x630, 0x106, 0x630, 0x107, 0x631, 0x106, 0x631,
    0x107, 0x632, 0x106, 0x632, 0x107, 0x633, 0x106, 0x633,
    0x104, 0x633, 0x105, 0x633, 0x107, 0x634, 0x106, 0x634,
    0x104, 0x634, 0x105, 0x634, 0x107, 0x635, 0x106, 0x635,
    0x104, 0x635, 0x105, 0x635, 0x107, 0x636, 0x106, 0x636,
    0x104, 0x636, 0x105, 0x636, 0x107, 0x637, 0x106, 0x637,
    0x104, 0x637, 0x105, 0x637, 0x107, 0x638, 0x106, 0x638,
    0x104, 0x638, 0x105, 0x638, 0x107, 0x639, 0x106, 0x639,
    0x104, 0x639, 0x105, 0x639, 0x107, 0x63a, 0x106, 0x63a,
    0x104, 0x63a, 0x105, 0x63a, 0x107, 0x641, 0x106, 0x641,
    0x104, 0x641, 0x105, 0x641, 0x107, 0x642, 0x106, 0x642,
    0x104, 0x642, 0x105, 0x642, 0x107, 0x643, 0x106, 0x643,
    0x104, 0x643, 0x105, 0x643, 0x107, 0x644, 0x106, 0x644,
    0x104, 0x644, 0x105, 0x644, 0x107, 0x645, 0x106, 0x645,
    0x104, 0x645, 0x105, 0x645, 0x107, 0x646, 0x106, 0x646,
    0x104, 0x646, 0x105, 0x646, 0x107, 0x647, 0x106, 0x647,
    0x104, 0x647, 0x105, 0x647, 0x107, 0x648, 0x106, 0x648,
    0x107, 0x649, 0x106, 0x649, 0x107, 0x64a, 0x106, 0x64a,
    0x104, 0x64a, 0x105, 0x64a, 0x207, 0x644, 0x622, 0x206,
    0x644, 0x622, 0x207, 0x644, 0x623, 0x206, 0x644, 0x623,
    0x207, 0x644, 0x625, 0x206, 0x644, 0x625, 0x207, 0x644,
    0x627, 0x206, 0x644, 0x627, 0x10c, 0x21, 0x10c, 0x22,
    0x10c, 0x23, 0x10c, 0x24, 0x10c, 0x25, 0x10c, 0x26,
    0x10c, 0x27, 0x10c, 0x28, 0x10c, 0x29, 0x10c, 0x2a,
    0x10c, 0x2b, 0x10c, 0x2c, 0x10c, 0x2d, 0x10c, 0x2e,
    0x10c, 0x2f, 0x10c, 0x30, 0x10c, 0x31, 0x10c, 0x32,
    0x10c, 0x33, 0x10c, 0x34, 0x10c, 0x35, 0x10c, 0x36,
    0x10c, 0x37, 0x10c, 0x38, 0x10c, 0x39, 0x10c, 0x3a,
    0x10c, 0x3b, 0x10c, 0x3c, 0x10c, 0x3d, 0x10c, 0x3e,
    0x10c, 0x3f, 0x10c, 0x40, 0x10c, 0x41, 0x10c, 0x42,
    0x10c, 0x43, 0x10c, 0x44, 0x10c, 0x45, 0x10c, 0x46,
    0x10c, 0x47, 0x10c, 0x48, 0x10c, 0x49, 0x10c, 0x4a,
    0x10c, 0x4b, 0x10c, 0x4c, 0x10c, 0x4d, 0x10c, 0x4e,
    0x10c, 0x4f, 0x10c, 0x50, 0x10c, 0x51, 0x10c, 0x52,
    0x10c, 0x53, 0x10c, 0x54, 0x10c, 0x55, 0x10c, 0x56,
    0x10c, 0x57, 0x10c, 0x58, 0x10c, 0x59, 0x10c, 0x5a,
    0x10c, 0x5b, 0x10c, 0x5c, 0x10c, 0x5d, 0x10c, 0x5e,
    0x10c, 0x5f, 0x10c, 0x60, 0x10c, 0x61, 0x10c, 0x62,
    0x10c, 0x63, 0x10c, 0x64, 0x10c, 0x65, 0x10c, 0x66,
    0x10c, 0x67, 0x10c, 0x68, 0x10c, 0x69, 0x10c, 0x6a,
    0x10c, 0x6b, 0x10c, 0x6c, 0x10c, 0x6d, 0x10c, 0x6e,
    0x10c, 0x6f, 0x10c, 0x70, 0x10c, 0x71, 0x10c, 0x72,
    0x10c, 0x73, 0x10c, 0x74, 0x10c, 0x75, 0x10c, 0x76,
    0x10c, 0x77, 0x10c, 0x78, 0x10c, 0x79, 0x10c, 0x7a,
    0x10c, 0x7b, 0x10c, 0x7c, 0x10c, 0x7d, 0x10c, 0x7e,
    0x10c, 0x2985, 0x10c, 0x2986, 0x10d, 0x3002, 0x10d, 0x300c,
    0x10d, 0x300d, 0x10d, 0x3001, 0x10d, 0x30fb, 0x10d, 0x30f2,
    0x10d, 0x30a1, 0x10d, 0x30a3, 0x10d, 0x30a5, 0x10d, 0x30a7,
    0x10d, 0x30a9, 0x10d, 0x30e3, 0x10d, 0x30e5, 0x10d, 0x30e7,
    0x10d, 0x30c3, 0x10d, 0x30fc, 0x10d, 0x30a2, 0x10d, 0x30a4,
    0x10d, 0x30a6, 0x10d, 0x30a8, 0x10d, 0x30aa, 0x10d, 0x30ab,
    0x10d, 0x30ad, 0x10d, 0x30af, 0x10d, 0x30b1, 0x10d, 0x30b3,
    0x10d, 0x30b5, 0x10d, 0x30b7, 0x10d, 0x30b9, 0x10d, 0x30bb,
    0x10d, 0x30bd, 0x10d, 0x30bf, 0x10d, 0x30c1, 0x10d, 0x30c4,
    0x10d, 0x30c6, 0x10d, 0x30c8, 0x10d, 0x30ca, 0x10d, 0x30cb,
    0x10d, 0x30cc, 0x10d, 0x30cd, 0x10d, 0x30ce, 0x10d, 0x30cf,
    0x10d, 0x30d2, 0x10d, 0x30d5, 0x10d, 0x30d8, 0x10d, 0x30db,
    0x10d, 0x30de, 0x10d, 0x30df, 0x10d, 0x30e0, 0x10d, 0x30e1,
    0x10d, 0x30e2, 0x10d, 0x30e4, 0x10d, 0x30e6, 0x10d, 0x30e8,
    0x10d, 0x30e9, 0x10d, 0x30ea, 0x10d, 0x30eb, 0x10d, 0x30ec,
    0x10d, 0x30ed, 0x10d, 0x30ef, 0x10d, 0x30f3, 0x10d, 0x3099,
    0x10d, 0x309a, 0x10d, 0x3164, 0x10d, 0x3131, 0x10d, 0x3132,
    0x10d, 0x3133, 0x10d, 0x3134, 0x10d, 0x3135, 0x10d, 0x3136,
    0x10d, 0x3137, 0x10d, 0x3138, 0x10d, 0x3139, 0x10d, 0x313a,
    0x10d, 0x313b, 0x10d, 0x313c, 0x10d, 0x313d, 0x10d, 0x313e,
    0x10d, 0x313f, 0x10d, 0x3140, 0x10d, 0x3141, 0x10d, 0x3142,
    0x10d, 0x3143, 0x10d, 0x3144, 0x10d, 0x3145, 0x10d, 0x3146,
    0x10d, 0x3147, 0x10d, 0x3148, 0x10d, 0x3149, 0x10d, 0x314a,
    0x10d, 0x314b, 0x10d, 0x314c, 0x10d, 0x314d, 0x10d, 0x314e,
    0x10d, 0x314f, 0x10d, 0x3150, 0x10d, 0x3151, 0x10d, 0x3152,
    0x10d, 0x3153, 0x10d, 0x3154, 0x10d, 0x3155, 0x10d, 0x3156,
    0x10d, 0x3157, 0x10d, 0x3158, 0x10d, 0x3159, 0x10d, 0x315a,
    0x10d, 0x315b, 0x10d, 0x315c, 0x10d, 0x315d, 0x10d, 0x315e,
    0x10d, 0x315f, 0x10d, 0x3160, 0x10d, 0x3161, 0x10d, 0x3162,
    0x10d, 0x3163, 0x10c, 0xa2, 0x10c, 0xa3, 0x10c, 0xac,
    0x10c, 0xaf, 0x10c, 0xa6, 0x10c, 0xa5, 0x10c, 0x20a9,
    0x10d, 0x2502, 0x10d, 0x2190, 0x10d, 0x2191, 0x10d, 0x2192,
    0x10d, 0x2193, 0x10d, 0x25a0, 0x10d, 0x25cb, 0x401, 0xd804,
    0xdc99, 0xd804, 0xdcba, 0x401, 0xd804, 0xdc9b, 0xd804, 0xdcba,
    0x401, 0xd804, 0xdca5, 0xd804, 0xdcba, 0x401, 0xd804, 0xdd31,
    0xd804, 0xdd27, 0x401, 0xd804, 0xdd32, 0xd804, 0xdd27, 0x401,
    0xd804, 0xdf47, 0xd804, 0xdf3e, 0x401, 0xd804, 0xdf47, 0xd804,
    0xdf57, 0x401, 0xd805, 0xdcb9, 0xd805, 0xdcba, 0x401, 0xd805,
    0xdcb9, 0xd805, 0xdcb0, 0x401, 0xd805, 0xdcb9, 0xd805, 0xdcbd,
    0x401, 0xd805, 0xddb8, 0xd805, 0xddaf, 0x401, 0xd805, 0xddb9,
    0xd805, 0xddaf, 0x401, 0xd834, 0xdd57, 0xd834, 0xdd65, 0x401,
    0xd834, 0xdd58, 0xd834, 0xdd65, 0x401, 0xd834, 0xdd5f, 0xd834,
    0xdd6e, 0x401, 0xd834, 0xdd5f, 0xd834, 0xdd6f, 0x401, 0xd834,
    0xdd5f, 0xd834, 0xdd70, 0x401, 0xd834, 0xdd5f, 0xd834, 0xdd71,
    0x401, 0xd834, 0xdd5f, 0xd834, 0xdd72, 0x401, 0xd834, 0xddb9,
    0xd834, 0xdd65, 0x401, 0xd834, 0xddba, 0xd834, 0xdd65, 0x401,
    0xd834, 0xddbb, 0xd834, 0xdd6e, 0x401, 0xd834, 0xddbc, 0xd834,
    0xdd6e, 0x401, 0xd834, 0xddbb, 0xd834, 0xdd6f, 0x401, 0xd834,
    0xddbc, 0xd834, 0xdd6f, 0x102, 0x41, 0x102, 0x42, 0x102,
    0x43, 0x102, 0x44, 0x102, 0x45, 0x102, 0x46, 0x102,
    0x47, 0x102, 0x48, 0x102, 0x49, 0x102, 0x4a, 0x102,
    0x4b, 0x102, 0x4c, 0x102, 0x4d, 0x102, 0x4e, 0x102,
    0x4f, 0x102, 0x50, 0x102, 0x51, 0x102, 0x52, 0x102,
    0x53, 0x102, 0x54, 0x102, 0x55, 0x102, 0x56, 0x102,
    0x57, 0x102, 0x58, 0x102, 0x59, 0x102, 0x5a, 0x102,
    0x61, 0x102, 0x62, 0x102, 0x63, 0x102, 0x64, 0x102,
    0x65, 0x102, 0x66, 0x102, 0x67, 0x102, 0x68, 0x102,
    0x69, 0x102, 0x6a, 0x102, 0x6b, 0x102, 0x6c, 0x102,
    0x6d, 0x102, 0x6e, 0x102, 0x6f, 0x102, 0x70, 0x102,
    0x71, 0x102, 0x72, 0x102, 0x73, 0x102, 0x74, 0x102,
    0x75, 0x102, 0x76, 0x102, 0x77, 0x102, 0x78, 0x102,
    0x79, 0x102, 0x7a, 0x102, 0x41, 0x102, 0x42, 0x102,
    0x43, 0x102, 0x44, 0x102, 0x45, 0x102, 0x46, 0x102,
    0x47, 0x102, 0x48, 0x102, 0x49, 0x102, 0x4a, 0x102,
    0x4b, 0x102, 0x4c, 0x102, 0x4d, 0x102, 0x4e, 0x102,
    0x4f, 0x102, 0x50, 0x102, 0x51, 0x102, 0x52, 0x102,
    0x53, 0x102, 0x54, 0x102, 0x55, 0x102, 0x56, 0x102,
    0x57, 0x102, 0x58, 0x102, 0x59, 0x102, 0x5a, 0x102,
    0x61, 0x102, 0x62, 0x102, 0x63, 0x102, 0x64, 0x102,
    0x65, 0x102, 0x66, 0x102, 0x67, 0x102, 0x69, 0x102,
    0x6a, 0x102, 0x6b, 0x102, 0x6c, 0x102, 0x6d, 0x102,
    0x6e, 0x102, 0x6f, 0x102, 0x70, 0x102, 0x71, 0x102,
    0x72, 0x102, 0x73, 0x102, 0x74, 0x102, 0x75, 0x102,
    0x76, 0x102, 0x77, 0x102, 0x78, 0x102, 0x79, 0x102,
    0x7a, 0x102, 0x41, 0x102, 0x42, 0x102, 0x43, 0x102,
    0x44, 0x102, 0x45, 0x102, 0x46, 0x102, 0x47, 0x102,
    0x48, 0x102, 0x49, 0x102, 0x4a, 0x102, 0x4b, 0x102,
    0x4c, 0x102, 0x4d, 0x102, 0x4e, 0x102, 0x4f, 0x102,
    0x50, 0x102, 0x51, 0x102, 0x52, 0x102, 0x53, 0x102,
    0x54, 0x102, 0x55, 0x102, 0x56, 0x102, 0x57, 0x102,
    0x58, 0x102, 0x59, 0x102, 0x5a, 0x102, 0x61, 0x102,
    0x62, 0x102, 0x63, 0x102, 0x64, 0x102, 0x65, 0x102,
    0x66, 0x102, 0x67, 0x102, 0x68, 0x102, 0x69, 0x102,
    0x6a, 0x102, 0x6b, 0x102, 0x6c, 0x102, 0x6d, 0x102,
    0x6e, 0x102, 0x6f, 0x102, 0x70, 0x102, 0x71, 0x102,
    0x72, 0x102, 0x73, 0x102, 0x74, 0x102, 0x75, 0x102,
    0x76, 0x102, 0x77, 0x102, 0x78, 0x102, 0x79, 0x102,
    0x7a, 0x102, 0x41, 0x102, 0x43, 0x102, 0x44, 0x102,
    0x47, 0x102, 0x4a, 0x102, 0x4b, 0x102, 0x4e, 0x102,
    0x4f, 0x102, 0x50, 0x102, 0x51, 0x102, 0x53, 0x102,
    0x54, 0x102, 0x55, 0x102, 0x56, 0x102, 0x57, 0x102,
    0x58, 0x102, 0x59, 0x102, 0x5a, 0x102, 0x61, 0x102,
    0x62, 0x102, 0x63, 0x102, 0x64, 0x102, 0x66, 0x102,
    0x68, 0x102, 0x69, 0x102, 0x6a, 0x102, 0x6b, 0x102,
    0x6c, 0x102, 0x6d, 0x102, 0x6e, 0x102, 0x70, 0x102,
    0x71, 0x102, 0x72, 0x102, 0x73, 0x102, 0x74, 0x102,
    0x75, 0x102, 0x76, 0x102, 0x77, 0x102, 0x78, 0x102,
    0x79, 0x102, 0x7a, 0x102, 0x41, 0x102, 0x42, 0x102,
    0x43, 0x102, 0x44, 0x102, 0x45, 0x102, 0x46, 0x102,
    0x47, 0x102, 0x48, 0x102, 0x49, 0x102, 0x4a, 0x102,
    0x4b, 0x102, 0x4c, 0x102, 0x4d, 0x102, 0x4e, 0x102,
    0x4f, 0x102, 0x50, 0x102, 0x51, 0x102, 0x52, 0x102,
    0x53, 0x102, 0x54, 0x102, 0x55, 0x102, 0x56, 0x102,
    0x57, 0x102, 0x58, 0x102, 0x59, 0x102, 0x5a, 0x102,
    0x61, 0x102, 0x62, 0x102, 0x63, 0x102, 0x64, 0x102,
    0x65, 0x102, 0x66, 0x102, 0x67, 0x102, 0x68, 0x102,
    0x69, 0x102, 0x6a, 0x102, 0x6b, 0x102, 0x6c, 0x102,
    0x6d, 0x102, 0x6e, 0x102, 0x6f, 0x102, 0x70, 0x102,
    0x71, 0x102, 0x72, 0x102, 0x73, 0x102, 0x74, 0x102,
    0x75, 0x102, 0x76, 0x102, 0x77, 0x102, 0x78, 0x102,
    0x79, 0x102, 0x7a, 0x102, 0x41, 0x102, 0x42, 0x102,
    0x44, 0x102, 0x45, 0x102, 0x46, 0x102, 0x47, 0x102,
    0x4a, 0x102, 0x4b, 0x102, 0x4c, 0x102, 0x4d, 0x102,
    0x4e, 0x102, 0x4f, 0x102, 0x50, 0x102, 0x51, 0x102,
    0x53, 0x102, 0x54, 0x102, 0x55, 0x102, 0x56, 0x102,
    0x57, 0x102, 0x58, 0x102, 0x59, 0x102, 0x61, 0x102,
    0x62, 0x102, 0x63, 0x102, 0x64, 0x102, 0x65, 0x102,
    0x66, 0x102, 0x67, 0x102, 0x68, 0x102, 0x69, 0x102,
    0x6a, 0x102, 0x6b, 0x102, 0x6c, 0x102, 0x6d, 0x102,
    0x6e, 0x102, 0x6f, 0x102, 0x70, 0x102, 0x71, 0x102,
    0x72, 0x102, 0x73, 0x102, 0x74, 0x102, 0x75, 0x102,
    0x76, 0x102, 0x77, 0x102, 0x78, 0x102, 0x79, 0x102,
    0x7a, 0x102, 0x41, 0x102, 0x42, 0x102, 0x44, 0x102,
    0x45, 0x102, 0x46, 0x102, 0x47, 0x102, 0x49, 0x102,
    0x4a, 0x102, 0x4b, 0x102, 0x4c, 0x102, 0x4d, 0x102,
    0x4f, 0x102, 0x53, 0x102, 0x54, 0x102, 0x55, 0x102,
    0x56, 0x102, 0x57, 0x102, 0x58, 0x102, 0x59, 0x102,
    0x61, 0x102, 0x62, 0x102, 0x63, 0x102, 0x64, 0x102,
    0x65, 0x102, 0x66, 0x102, 0x67, 0x102, 0x68, 0x102,
    0x69, 0x102, 0x6a, 0x102, 0x6b, 0x102, 0x6c, 0x102,
    0x6d, 0x102, 0x6e, 0x102, 0x6f, 0x102, 0x70, 0x102,
    0x71, 0x102, 0x72, 0x102, 0x73, 0x102, 0x74, 0x102,
    0x75, 0x102, 0x76, 0x102, 0x77, 0x102, 0x78, 0x102,
    0x79, 0x102, 0x7a, 0x102, 0x41, 0x102, 0x42, 0x102,
    0x43, 0x102, 0x44, 0x102, 0x45, 0x102, 0x46, 0x102,
    0x47, 0x102, 0x48, 0x102, 0x49, 0x102, 0x4a, 0x102,
    0x4b, 0x102, 0x4c, 0x102, 0x4d, 0x102, 0x4e, 0x102,
    0x4f, 0x102, 0x50, 0x102, 0x51, 0x102, 0x52, 0x102,
    0x53, 0x102, 0x54, 0x102, 0x55, 0x102, 0x56, 0x102,
    0x57, 0x102, 0x58, 0x102, 0x59, 0x102, 0x5a, 0x102,
    0x61, 0x102, 0x62, 0x102, 0x63, 0x102, 0x64, 0x102,
    0x65, 0x102, 0x66, 0x102, 0x67, 0x102, 0x68, 0x102,
    0x69, 0x102, 0x6a, 0x102, 0x6b, 0x102, 0x6c, 0x102,
    0x6d, 0x102, 0x6e, 0x102, 0x6f, 0x102, 0x70, 0x102,
    0x71, 0x102, 0x72, 0x102, 0x73, 0x102, 0x74, 0x102,
    0x75, 0x102, 0x76, 0x102, 0x77, 0x102, 0x78, 0x102,
    0x79, 0x102, 0x7a, 0x102, 0x41, 0x102, 0x42, 0x102,
    0x43, 0x102, 0x44, 0x102, 0x45, 0x102, 0x46, 0x102,
    0x47, 0x102, 0x48, 0x102, 0x49, 0x102, 0x4a, 0x102,
    0x4b, 0x102, 0x4c, 0x102, 0x4d, 0x102, 0x4e, 0x102,
    0x4f, 0x102, 0x50, 0x102, 0x51, 0x102, 0x52, 0x102,
    0x53, 0x102, 0x54, 0x102, 0x55, 0x102, 0x56, 0x102,
    0x57, 0x102, 0x58, 0x102, 0x59, 0x102, 0x5a, 0x102,
    0x61, 0x102, 0x62, 0x102, 0x63, 0x102, 0x64, 0x102,
    0x65, 0x102, 0x66, 0x102, 0x67, 0x102, 0x68, 0x102,
    0x69, 0x102, 0x6a, 0x102, 0x6b, 0x102, 0x6c, 0x102,
    0x6d, 0x102, 0x6e, 0x102, 0x6f, 0x102, 0x70, 0x102,
    0x71, 0x102, 0x72, 0x102, 0x73, 0x102, 0x74, 0x102,
    0x75, 0x102, 0x76, 0x102, 0x77, 0x102, 0x78, 0x102,
    0x79, 0x102, 0x7a, 0x102, 0x41, 0x102, 0x42, 0x102,
    0x43, 0x102, 0x44, 0x102, 0x45, 0x102, 0x46, 0x102,
    0x47, 0x102, 0x48, 0x102, 0x49, 0x102, 0x4a, 0x102,
    0x4b, 0x102, 0x4c, 0x102, 0x4d, 0x102, 0x4e, 0x102,
    0x4f, 0x102, 0x50, 0x102, 0x51, 0x102, 0x52, 0x102,
    0x53, 0x102, 0x54, 0x102, 0x55, 0x102, 0x56, 0x102,
    0x57, 0x102, 0x58, 0x102, 0x59, 0x102, 0x5a, 0x102,
    0x61, 0x102, 0x62, 0x102, 0x63, 0x102, 0x64, 0x102,
    0x65, 0x102, 0x66, 0x102, 0x67, 0x102, 0x68, 0x102,
    0x69, 0x102, 0x6a, 0x102, 0x6b, 0x102, 0x6c, 0x102,
    0x6d, 0x102, 0x6e, 0x102, 0x6f, 0x102, 0x70, 0x102,
    0x71, 0x102, 0x72, 0x102, 0x73, 0x102, 0x74, 0x102,
    0x75, 0x102, 0x76, 0x102, 0x77, 0x102, 0x78, 0x102,
    0x79, 0x102, 0x7a, 0x102, 0x41, 0x102, 0x42, 0x102,
    0x43, 0x102, 0x44, 0x102, 0x45, 0x102, 0x46, 0x102,
    0x47, 0x102, 0x48, 0x102, 0x49, 0x102, 0x4a, 0x102,
    0x4b, 0x102, 0x4c, 0x102, 0x4d, 0x102, 0x4e, 0x102,
    0x4f, 0x102, 0x50, 0x102, 0x51, 0x102, 0x52, 0x102,
    0x53, 0x102, 0x54, 0x102, 0x55, 0x102, 0x56, 0x102,
    0x57, 0x102, 0x58, 0x102, 0x59, 0x102, 0x5a, 0x102,
    0x61, 0x102, 0x62, 0x102, 0x63, 0x102, 0x64, 0x102,
    0x65, 0x102, 0x66, 0x102, 0x67, 0x102, 0x68, 0x102,
    0x69, 0x102, 0x6a, 0x102, 0x6b, 0x102, 0x6c, 0x102,
    0x6d, 0x102, 0x6e, 0x102, 0x6f, 0x102, 0x70, 0x102,
    0x71, 0x102, 0x72, 0x102, 0x73, 0x102, 0x74, 0x102,
    0x75, 0x102, 0x76, 0x102, 0x77, 0x102, 0x78, 0x102,
    0x79, 0x102, 0x7a, 0x102, 0x41, 0x102, 0x42, 0x102,
    0x43, 0x102, 0x44, 0x102, 0x45, 0x102, 0x46, 0x102,
    0x47, 0x102, 0x48, 0x102, 0x49, 0x102, 0x4a, 0x102,
    0x4b, 0x102, 0x4c, 0x102, 0x4d, 0x102, 0x4e, 0x102,
    0x4f, 0x102, 0x50, 0x102, 0x51, 0x102, 0x52, 0x102,
    0x53, 0x102, 0x54, 0x102, 0x55, 0x102, 0x56, 0x102,
    0x57, 0x102, 0x58, 0x102, 0x59, 0x102, 0x5a, 0x102,
    0x61, 0x102, 0x62, 0x102, 0x63, 0x102, 0x64, 0x102,
    0x65, 0x102, 0x66, 0x102, 0x67, 0x102, 0x68, 0x102,
    0x69, 0x102, 0x6a, 0x102, 0x6b, 0x102, 0x6c, 0x102,
    0x6d, 0x102, 0x6e, 0x102, 0x6f, 0x102, 0x70, 0x102,
    0x71, 0x102, 0x72, 0x102, 0x73, 0x102, 0x74, 0x102,
    0x75, 0x102, 0x76, 0x102, 0x77, 0x102, 0x78, 0x102,
    0x79, 0x102, 0x7a, 0x102, 0x41, 0x102, 0x42, 0x102,
    0x43, 0x102, 0x44, 0x102, 0x45, 0x102, 0x46, 0x102,
    0x47, 0x102, 0x48, 0x102, 0x49, 0x102, 0x4a, 0x102,
    0x4b, 0x102, 0x4c, 0x102, 0x4d, 0x102, 0x4e, 0x102,
    0x4f, 0x102, 0x50, 0x102, 0x51, 0x102, 0x52, 0x102,
    0x53, 0x102, 0x54, 0x102, 0x55, 0x102, 0x56, 0x102,
    0x57, 0x102, 0x58, 0x102, 0x59, 0x102, 0x5a, 0x102,
    0x61, 0x102, 0x62, 0x102, 0x63, 0x102, 0x64, 0x102,
    0x65, 0x102, 0x66, 0x102, 0x67, 0x102, 0x68, 0x102,
    0x69, 0x102, 0x6a, 0x102, 0x6b, 0x102, 0x6c, 0x102,
    0x6d, 0x102, 0x6e, 0x102, 0x6f, 0x102, 0x70, 0x102,
    0x71, 0x102, 0x72, 0x102, 0x73, 0x102, 0x74, 0x102,
    0x75, 0x102, 0x76, 0x102, 0x77, 0x102, 0x78, 0x102,
    0x79, 0x102, 0x7a, 0x102, 0x131, 0x102, 0x237, 0x102,
    0x391, 0x102, 0x392, 0x102, 0x393, 0x102, 0x394, 0x102,
    0x395, 0x102, 0x396, 0x102, 0x397, 0x102, 0x398, 0x102,
    0x399, 0x102, 0x39a, 0x102, 0x39b, 0x102, 0x39c, 0x102,
    0x39d, 0x102, 0x39e, 0x102, 0x39f, 0x102, 0x3a0, 0x102,
    0x3a1, 0x102, 0x3f4, 0x102, 0x3a3, 0x102, 0x3a4, 0x102,
    0x3a5, 0x102, 0x3a6, 0x102, 0x3a7, 0x102, 0x3a8, 0x102,
    0x3a9, 0x102, 0x2207, 0x102, 0x3b1, 0x102, 0x3b2, 0x102,
    0x3b3, 0x102, 0x3b4, 0x102, 0x3b5, 0x102, 0x3b6, 0x102,
    0x3b7, 0x102, 0x3b8, 0x102, 0x3b9, 0x102, 0x3ba, 0x102,
    0x3bb, 0x102, 0x3bc, 0x102, 0x3bd, 0x102, 0x3be, 0x102,
    0x3bf, 0x102, 0x3c0, 0x102, 0x3c1, 0x102, 0x3c2, 0x102,
    0x3c3, 0x102, 0x3c4, 0x102, 0x3c5, 0x102, 0x3c6, 0x102,
    0x3c7, 0x102, 0x3c8, 0x102, 0x3c9, 0x102, 0x2202, 0x102,
    0x3f5, 0x102, 0x3d1, 0x102, 0x3f0, 0x102, 0x3d5, 0x102,
    0x3f1, 0x102, 0x3d6, 0x102, 0x391, 0x102, 0x392, 0x102,
    0x393, 0x102, 0x394, 0x102, 0x395, 0x102, 0x396, 0x102,
    0x397, 0x102, 0x398, 0x102, 0x399, 0x102, 0x39a, 0x102,
    0x39b, 0x102, 0x39c, 0x102, 0x39d, 0x102, 0x39e, 0x102,
    0x39f, 0x102, 0x3a0, 0x102, 0x3a1, 0x102, 0x3f4, 0x102,
    0x3a3, 0x102, 0x3a4, 0x102, 0x3a5, 0x102, 0x3a6, 0x102,
    0x3a7, 0x102, 0x3a8, 0x102, 0x3a9, 0x102, 0x2207, 0x102,
    0x3b1, 0x102, 0x3b2, 0x102, 0x3b3, 0x102, 0x3b4, 0x102,
    0x3b5, 0x102, 0x3b6, 0x102, 0x3b7, 0x102, 0x3b8, 0x102,
    0x3b9, 0x102, 0x3ba, 0x102, 0x3bb, 0x102, 0x3bc, 0x102,
    0x3bd, 0x102, 0x3be, 0x102, 0x3bf, 0x102, 0x3c0, 0x102,
    0x3c1, 0x102, 0x3c2, 0x102, 0x3c3, 0x102, 0x3c4, 0x102,
    0x3c5, 0x102, 0x3c6, 0x102, 0x3c7, 0x102, 0x3c8, 0x102,
    0x3c9, 0x102, 0x2202, 0x102, 0x3f5, 0x102, 0x3d1, 0x102,
    0x3f0, 0x102, 0x3d5, 0x102, 0x3f1, 0x102, 0x3d6, 0x102,
    0x391, 0x102, 0x392, 0x102, 0x393, 0x102, 0x394, 0x102,
    0x395, 0x102, 0x396, 0x102, 0x397, 0x102, 0x398, 0x102,
    0x399, 0x102, 0x39a, 0x102, 0x39b, 0x102, 0x39c, 0x102,
    0x39d, 0x102, 0x39e, 0x102, 0x39f, 0x102, 0x3a0, 0x102,
    0x3a1, 0x102, 0x3f4, 0x102, 0x3a3, 0x102, 0x3a4, 0x102,
    0x3a5, 0x102, 0x3a6, 0x102, 0x3a7, 0x102, 0x3a8, 0x102,
    0x3a9, 0x102, 0x2207, 0x102, 0x3b1, 0x102, 0x3b2, 0x102,
    0x3b3, 0x102, 0x3b4, 0x102, 0x3b5, 0x102, 0x3b6, 0x102,
    0x3b7, 0x102, 0x3b8, 0x102, 0x3b9, 0x102, 0x3ba, 0x102,
    0x3bb, 0x102, 0x3bc, 0x102, 0x3bd, 0x102, 0x3be, 0x102,
    0x3bf, 0x102, 0x3c0, 0x102, 0x3c1, 0x102, 0x3c2, 0x102,
    0x3c3, 0x102, 0x3c4, 0x102, 0x3c5, 0x102, 0x3c6, 0x102,
    0x3c7, 0x102, 0x3c8, 0x102, 0x3c9, 0x102, 0x2202, 0x102,
    0x3f5, 0x102, 0x3d1, 0x102, 0x3f0, 0x102, 0x3d5, 0x102,
    0x3f1, 0x102, 0x3d6, 0x102, 0x391, 0x102, 0x392, 0x102,
    0x393, 0x102, 0x394, 0x102, 0x395, 0x102, 0x396, 0x102,
    0x397, 0x102, 0x398, 0x102, 0x399, 0x102, 0x39a, 0x102,
    0x39b, 0x102, 0x39c, 0x102, 0x39d, 0x102, 0x39e, 0x102,
    0x39f, 0x102, 0x3a0, 0x102, 0x3a1, 0x102, 0x3f4, 0x102,
    0x3a3, 0x102, 0x3a4, 0x102, 0x3a5, 0x102, 0x3a6, 0x102,
    0x3a7, 0x102, 0x3a8, 0x102, 0x3a9, 0x102, 0x2207, 0x102,
    0x3b1, 0x102, 0x3b2, 0x102, 0x3b3, 0x102, 0x3b4, 0x102,
    0x3b5, 0x102, 0x3b6, 0x102, 0x3b7, 0x102, 0x3b8, 0x102,
    0x3b9, 0x102, 0x3ba, 0x102, 0x3bb, 0x102, 0x3bc, 0x102,
    0x3bd, 0x102, 0x3be, 0x102, 0x3bf, 0x102, 0x3c0, 0x102,
    0x3c1, 0x102, 0x3c2, 0x102, 0x3c3, 0x102, 0x3c4, 0x102,
    0x3c5, 0x102, 0x3c6, 0x102, 0x3c7, 0x102, 0x3c8, 0x102,
    0x3c9, 0x102, 0x2202, 0x102, 0x3f5, 0x102, 0x3d1, 0x102,
    0x3f0, 0x102, 0x3d5, 0x102, 0x3f1, 0x102, 0x3d6, 0x102,
    0x391, 0x102, 0x392, 0x102, 0x393, 0x102, 0x394, 0x102,
    0x395, 0x102, 0x396, 0x102, 0x397, 0x102, 0x398, 0x102,
    0x399, 0x102, 0x39a, 0x102, 0x39b, 0x102, 0x39c, 0x102,
    0x39d, 0x102, 0x39e, 0x102, 0x39f, 0x102, 0x3a0, 0x102,
    0x3a1, 0x102, 0x3f4, 0x102, 0x3a3, 0x102, 0x3a4, 0x102,
    0x3a5, 0x102, 0x3a6, 0x102, 0x3a7, 0x102, 0x3a8, 0x102,
    0x3a9, 0x102, 0x2207, 0x102, 0x3b1, 0x102, 0x3b2, 0x102,
    0x3b3, 0x102, 0x3b4, 0x102, 0x3b5, 0x102, 0x3b6, 0x102,
    0x3b7, 0x102, 0x3b8, 0x102, 0x3b9, 0x102, 0x3ba, 0x102,
    0x3bb, 0x102, 0x3bc, 0x102, 0x3bd, 0x102, 0x3be, 0x102,
    0x3bf, 0x102, 0x3c0, 0x102, 0x3c1, 0x102, 0x3c2, 0x102,
    0x3c3, 0x102, 0x3c4, 0x102, 0x3c5, 0x102, 0x3c6, 0x102,
    0x3c7, 0x102, 0x3c8, 0x102, 0x3c9, 0x102, 0x2202, 0x102,
    0x3f5, 0x102, 0x3d1, 0x102, 0x3f0, 0x102, 0x3d5, 0x102,
    0x3f1, 0x102, 0x3d6, 0x102, 0x3dc, 0x102, 0x3dd, 0x102,
    0x30, 0x102, 0x31, 0x102, 0x32, 0x102, 0x33, 0x102,
    0x34, 0x102, 0x35, 0x102, 0x36, 0x102, 0x37, 0x102,
    0x38, 0x102, 0x39, 0x102, 0x30, 0x102, 0x31, 0x102,
    0x32, 0x102, 0x33, 0x102, 0x34, 0x102, 0x35, 0x102,
    0x36, 0x102, 0x37, 0x102, 0x38, 0x102, 0x39, 0x102,
    0x30, 0x102, 0x31, 0x102, 0x32, 0x102, 0x33, 0x102,
    0x34, 0x102, 0x35, 0x102, 0x36, 0x102, 0x37, 0x102,
    0x38, 0x102, 0x39, 0x102, 0x30, 0x102, 0x31, 0x102,
    0x32, 0x102, 0x33, 0x102, 0x34, 0x102, 0x35, 0x102,
    0x36, 0x102, 0x37, 0x102, 0x38, 0x102, 0x39, 0x102,
    0x30, 0x102, 0x31, 0x102, 0x32, 0x102, 0x33, 0x102,
    0x34, 0x102, 0x35, 0x102, 0x36, 0x102, 0x37, 0x102,
    0x38, 0x102, 0x39, 0x102, 0x627, 0x102, 0x628, 0x102,
    0x62c, 0x102, 0x62f, 0x102, 0x648, 0x102, 0x632, 0x102,
    0x62d, 0x102, 0x637, 0x102, 0x64a, 0x102, 0x643, 0x102,
    0x644, 0x102, 0x645, 0x102, 0x646, 0x102, 0x633, 0x102,
    0x639, 0x102, 0x641, 0x102, 0x635, 0x102, 0x642, 0x102,
    0x631, 0x102, 0x634, 0x102, 0x62a, 0x102, 0x62b, 0x102,
    0x62e, 0x102, 0x630, 0x102, 0x636, 0x102, 0x638, 0x102,
    0x63a, 0x102, 0x66e, 0x102, 0x6ba, 0x102, 0x6a1, 0x102,
    0x66f, 0x102, 0x628, 0x102, 0x62c, 0x102, 0x647, 0x102,
    0x62d, 0x102, 0x64a, 0x102, 0x643, 0x102, 0x644, 0x102,
    0x645, 0x102, 0x646, 0x102, 0x633, 0x102, 0x639, 0x102,
    0x641, 0x102, 0x635, 0x102, 0x642, 0x102, 0x634, 0x102,
    0x62a, 0x102, 0x62b, 0x102, 0x62e, 0x102, 0x636, 0x102,
    0x63a, 0x102, 0x62c, 0x102, 0x62d, 0x102, 0x64a, 0x102,
    0x644, 0x102, 0x646, 0x102, 0x633, 0x102, 0x639, 0x102,
    0x635, 0x102, 0x642, 0x102, 0x634, 0x102, 0x62e, 0x102,
    0x636, 0x102, 0x63a, 0x102, 0x6ba, 0x102, 0x66f, 0x102,
    0x628, 0x102, 0x62c, 0x102, 0x647, 0x102, 0x62d, 0x102,
    0x637, 0x102, 0x64a, 0x102, 0x643, 0x102, 0x645, 0x102,
    0x646, 0x102, 0x633, 0x102, 0x639, 0x102, 0x641, 0x102,
    0x635, 0x102, 0x642, 0x102, 0x634, 0x102, 0x62a, 0x102,
    0x62b, 0x102, 0x62e, 0x102, 0x636, 0x102, 0x638, 0x102,
    0x63a, 0x102, 0x66e, 0x102, 0x6a1, 0x102, 0x627, 0x102,
    0x628, 0x102, 0x62c, 0x102, 0x62f, 0x102, 0x647, 0x102,
    0x648, 0x102, 0x632, 0x102, 0x62d, 0x102, 0x637, 0x102,
    0x64a, 0x102, 0x644, 0x102, 0x645, 0x102, 0x646, 0x102,
    0x633, 0x102, 0x639, 0x102, 0x641, 0x102, 0x635, 0x102,
    0x642, 0x102, 0x631, 0x102, 0x634, 0x102, 0x62a, 0x102,
    0x62b, 0x102, 0x62e, 0x102, 0x630, 0x102, 0x636, 0x102,
    0x638, 0x102, 0x63a, 0x102, 0x628, 0x102, 0x62c, 0x102,
    0x62f, 0x102, 0x648, 0x102, 0x632, 0x102, 0x62d, 0x102,
    0x637, 0x102, 0x64a, 0x102, 0x644, 0x102, 0x645, 0x102,
    0x646, 0x102, 0x633, 0x102, 0x639, 0x102, 0x641, 0x102,
    0x635, 0x102, 0x642, 0x102, 0x631, 0x102, 0x634, 0x102,
    0x62a, 0x102, 0x62b, 0x102, 0x62e, 0x102, 0x630, 0x102,
    0x636, 0x102, 0x638, 0x102, 0x63a, 0x210, 0x30, 0x2e,
    0x210, 0x30, 0x2c, 0x210, 0x31, 0x2c, 0x210, 0x32,
    0x2c, 0x210, 0x33, 0x2c, 0x210, 0x34, 0x2c, 0x210,
    0x35, 0x2c, 0x210, 0x36, 0x2c, 0x210, 0x37, 0x2c,
    0x210, 0x38, 0x2c, 0x210, 0x39, 0x2c, 0x310, 0x28,
    0x41, 0x29, 0x310, 0x28, 0x42, 0x29, 0x310, 0x28,
    0x43, 0x29, 0x310, 0x28, 0x44, 0x29, 0x310, 0x28,
    0x45, 0x29, 0x310, 0x28, 0x46, 0x29, 0x310, 0x28,
    0x47, 0x29, 0x310, 0x28, 0x48, 0x29, 0x310, 0x28,
    0x49, 0x29, 0x310, 0x28, 0x4a, 0x29, 0x310, 0x28,
    0x4b, 0x29, 0x310, 0x28, 0x4c, 0x29, 0x310, 0x28,
    0x4d, 0x29, 0x310, 0x28, 0x4e, 0x29, 0x310, 0x28,
    0x4f, 0x29, 0x310, 0x28, 0x50, 0x29, 0x310, 0x28,
    0x51, 0x29, 0x310, 0x28, 0x52, 0x29, 0x310, 0x28,
    0x53, 0x29, 0x310, 0x28, 0x54, 0x29, 0x310, 0x28,
    0x55, 0x29, 0x310, 0x28, 0x56, 0x29, 0x310, 0x28,
    0x57, 0x29, 0x310, 0x28, 0x58, 0x29, 0x310, 0x28,
    0x59, 0x29, 0x310, 0x28, 0x5a, 0x29, 0x310, 0x3014,
    0x53, 0x3015, 0x108, 0x43, 0x108, 0x52, 0x208, 0x43,
    0x44, 0x208, 0x57, 0x5a, 0x10f, 0x41, 0x10f, 0x42,
    0x10f, 0x43, 0x10f, 0x44, 0x10f, 0x45, 0x10f, 0x46,
    0x10f, 0x47, 0x10f, 0x48, 0x10f, 0x49, 0x10f, 0x4a,
    0x10f, 0x4b, 0x10f, 0x4c, 0x10f, 0x4d, 0x10f, 0x4e,
    0x10f, 0x4f, 0x10f, 0x50, 0x10f, 0x51, 0x10f, 0x52,
    0x10f, 0x53, 0x10f, 0x54, 0x10f, 0x55, 0x10f, 0x56,
    0x10f, 0x57, 0x10f, 0x58, 0x10f, 0x59, 0x10f, 0x5a,
    0x20f, 0x48, 0x56, 0x20f, 0x4d, 0x56, 0x20f, 0x53,
    0x44, 0x20f, 0x53, 0x53, 0x30f, 0x50, 0x50, 0x56,
    0x20f, 0x57, 0x43, 0x209, 0x4d, 0x43, 0x209, 0x4d,
    0x44, 0x20f, 0x44, 0x4a, 0x20f, 0x307b, 0x304b, 0x20f,
    0x30b3, 0x30b3, 0x10f, 0x30b5, 0x10f, 0x624b, 0x10f, 0x5b57,
    0x10f, 0x53cc, 0x10f, 0x30c7, 0x10f, 0x4e8c, 0x10f, 0x591a,
    0x10f, 0x89e3, 0x10f, 0x5929, 0x10f, 0x4ea4, 0x10f, 0x6620,
    0x10f, 0x7121, 0x10f, 0x6599, 0x10f, 0x524d, 0x10f, 0x5f8c,
    0x10f, 0x518d, 0x10f, 0x65b0, 0x10f, 0x521d, 0x10f, 0x7d42,
    0x10f, 0x751f, 0x10f, 0x8ca9, 0x10f, 0x58f0, 0x10f, 0x5439,
    0x10f, 0x6f14, 0x10f, 0x6295, 0x10f, 0x6355, 0x10f, 0x4e00,
    0x10f, 0x4e09, 0x10f, 0x904a, 0x10f, 0x5de6, 0x10f, 0x4e2d,
    0x10f, 0x53f3, 0x10f, 0x6307, 0x10f, 0x8d70, 0x10f, 0x6253,
    0x10f, 0x7981, 0x10f, 0x7a7a, 0x10f, 0x5408, 0x10f, 0x6e80,
    0x10f, 0x6709, 0x10f, 0x6708, 0x10f, 0x7533, 0x10f, 0x5272,
    0x10f, 0x55b6, 0x310, 0x3014, 0x672c, 0x3015, 0x310, 0x3014,
    0x4e09, 0x3015, 0x310, 0x3014, 0x4e8c, 0x3015, 0x310, 0x3014,
    0x5b89, 0x3015, 0x310, 0x3014, 0x70b9, 0x3015, 0x310, 0x3014,
    0x6253, 0x3015, 0x310, 0x3014, 0x76d7, 0x3015, 0x310, 0x3014,
    0x52dd, 0x3015, 0x310, 0x3014, 0x6557, 0x3015, 0x108, 0x5f97,
    0x108, 0x53ef, 0x101, 0x4e3d, 0x101, 0x4e38, 0x101, 0x4e41,
    0x201, 0xd840, 0xdd22, 0x101, 0x4f60, 0x101, 0x4fae, 0x101,
    0x4fbb, 0x101, 0x5002, 0x101, 0x507a, 0x101, 0x5099, 0x101,
    0x50e7, 0x101, 0x50cf, 0x101, 0x349e, 0x201, 0xd841, 0xde3a,
    0x101, 0x514d, 0x101, 0x5154, 0x101, 0x5164, 0x101, 0x5177,
    0x201, 0xd841, 0xdd1c, 0x101, 0x34b9, 0x101, 0x5167, 0x101,
    0x518d, 0x201, 0xd841, 0xdd4b, 0x101, 0x5197, 0x101, 0x51a4,
    0x101, 0x4ecc, 0x101, 0x51ac, 0x101, 0x51b5, 0x201, 0xd864,
    0xdddf, 0x101, 0x51f5, 0x101, 0x5203, 0x101, 0x34df, 0x101,
    0x523b, 0x101, 0x5246, 0x101, 0x5272, 0x101, 0x5277, 0x101,
    0x3515, 0x101, 0x52c7, 0x101, 0x52c9, 0x101, 0x52e4, 0x101,
    0x52fa, 0x101, 0x5305, 0x101, 0x5306, 0x101, 0x5317, 0x101,
    0x5349, 0x101, 0x5351, 0x101, 0x535a, 0x101, 0x5373, 0x101,
    0x537d, 0x101, 0x537f, 0x101, 0x537f, 0x101, 0x537f, 0x201,
    0xd842, 0xde2c, 0x101, 0x7070, 0x101, 0x53ca, 0x101, 0x53df,
    0x201, 0xd842, 0xdf63, 0x101, 0x53eb, 0x101, 0x53f1, 0x101,
    0x5406, 0x101, 0x549e, 0x101, 0x5438, 0x101, 0x5448, 0x101,
    0x5468, 0x101, 0x54a2, 0x101, 0x54f6, 0x101, 0x5510, 0x101,
    0x5553, 0x101, 0x5563, 0x101, 0x5584, 0x101, 0x5584, 0x101,
    0x5599, 0x101, 0x55ab, 0x101, 0x55b3, 0x101, 0x55c2, 0x101,
    0x5716, 0x101, 0x5606, 0x101, 0x5717, 0x101, 0x5651, 0x101,
    0x5674, 0x101, 0x5207, 0x101, 0x58ee, 0x101, 0x57ce, 0x101,
    0x57f4, 0x101, 0x580d, 0x101, 0x578b, 0x101, 0x5832, 0x101,
    0x5831, 0x101, 0x58ac, 0x201, 0xd845, 0xdce4, 0x101, 0x58f2,
    0x101, 0x58f7, 0x101, 0x5906, 0x101, 0x591a, 0x101, 0x5922,
    0x101, 0x5962, 0x201, 0xd845, 0xdea8, 0x201, 0xd845, 0xdeea,
    0x101, 0x59ec, 0x101, 0x5a1b, 0x101, 0x5a27, 0x101, 0x59d8,
    0x101, 0x5a66, 0x101, 0x36ee, 0x101, 0x36fc, 0x101, 0x5b08,
    0x101, 0x5b3e, 0x101, 0x5b3e, 0x201, 0xd846, 0xddc8, 0x101,
    0x5bc3, 0x101, 0x5bd8, 0x101, 0x5be7, 0x101, 0x5bf3, 0x201,
    0xd846, 0xdf18, 0x101, 0x5bff, 0x101, 0x5c06, 0x101, 0x5f53,
    0x101, 0x5c22, 0x101, 0x3781, 0x101, 0x5c60, 0x101, 0x5c6e,
    0x101, 0x5cc0, 0x101, 0x5c8d, 0x201, 0xd847, 0xdde4, 0x101,
    0x5d43, 0x201, 0xd847, 0xdde6, 0x101, 0x5d6e, 0x101, 0x5d6b,
    0x101, 0x5d7c, 0x101, 0x5de1, 0x101, 0x5de2, 0x101, 0x382f,
    0x101, 0x5dfd, 0x101, 0x5e28, 0x101, 0x5e3d, 0x101, 0x5e69,
    0x101, 0x3862, 0x201, 0xd848, 0xdd83, 0x101, 0x387c, 0x101,
    0x5eb0, 0x101, 0x5eb3, 0x101, 0x5eb6, 0x101, 0x5eca, 0x201,
    0xd868, 0xdf92, 0x101, 0x5efe, 0x201, 0xd848, 0xdf31, 0x201,
    0xd848, 0xdf31, 0x101, 0x8201, 0x101, 0x5f22, 0x101, 0x5f22,
    0x101, 0x38c7, 0x201, 0xd84c, 0xdeb8, 0x201, 0xd858, 0xddda,
    0x101, 0x5f62, 0x101, 0x5f6b, 0x101, 0x38e3, 0x101, 0x5f9a,
    0x101, 0x5fcd, 0x101, 0x5fd7, 0x101, 0x5ff9, 0x101, 0x6081,
    0x101, 0x393a, 0x101, 0x391c, 0x101, 0x6094, 0x201, 0xd849,
    0xded4, 0x101, 0x60c7, 0x101, 0x6148, 0x101, 0x614c, 0x101,
    0x614e, 0x101, 0x614c, 0x101, 0x617a, 0x101, 0x618e, 0x101,
    0x61b2, 0x101, 0x61a4, 0x101, 0x61af, 0x101, 0x61de, 0x101,
    0x61f2, 0x101, 0x61f6, 0x101, 0x6210, 0x101, 0x621b, 0x101,
    0x625d, 0x101, 0x62b1, 0x101, 0x62d4, 0x101, 0x6350, 0x201,
    0xd84a, 0xdf0c, 0x101, 0x633d, 0x101, 0x62fc, 0x101, 0x6368,
    0x101, 0x6383, 0x101, 0x63e4, 0x201, 0xd84a, 0xdff1, 0x101,
    0x6422, 0x101, 0x63c5, 0x101, 0x63a9, 0x101, 0x3a2e, 0x101,
    0x6469, 0x101, 0x647e, 0x101, 0x649d, 0x101, 0x6477, 0x101,
    0x3a6c, 0x101, 0x654f, 0x101, 0x656c, 0x201, 0xd84c, 0xdc0a,
    0x101, 0x65e3, 0x101, 0x66f8, 0x101, 0x6649, 0x101, 0x3b19,
    0x101, 0x6691, 0x101, 0x3b08, 0x101, 0x3ae4, 0x101, 0x5192,
    0x101, 0x5195, 0x101, 0x6700, 0x101, 0x669c, 0x101, 0x80ad,
    0x101, 0x43d9, 0x101, 0x6717, 0x101, 0x671b, 0x101, 0x6721,
    0x101, 0x675e, 0x101, 0x6753, 0x201, 0xd84c, 0xdfc3, 0x101,
    0x3b49, 0x101, 0x67fa, 0x101, 0x6785, 0x101, 0x6852, 0x101,
    0x6885, 0x201, 0xd84d, 0xdc6d, 0x101, 0x688e, 0x101, 0x681f,
    0x101, 0x6914, 0x101, 0x3b9d, 0x101, 0x6942, 0x101, 0x69a3,
    0x101, 0x69ea, 0x101, 0x6aa8, 0x201, 0xd84d, 0xdea3, 0x101,
    0x6adb, 0x101, 0x3c18, 0x101, 0x6b21, 0x201, 0xd84e, 0xdca7,
    0x101, 0x6b54, 0x101, 0x3c4e, 0x101, 0x6b72, 0x101, 0x6b9f,
    0x101, 0x6bba, 0x101, 0x6bbb, 0x201, 0xd84e, 0xde8d, 0x201,
    0xd847, 0xdd0b, 0x201, 0xd84e, 0xdefa, 0x101, 0x6c4e, 0x201,
    0xd84f, 0xdcbc, 0x101, 0x6cbf, 0x101, 0x6ccd, 0x101, 0x6c67,
    0x101, 0x6d16, 0x101, 0x6d3e, 0x101, 0x6d77, 0x101, 0x6d41,
    0x101, 0x6d69, 0x101, 0x6d78, 0x101, 0x6d85, 0x201, 0xd84f,
    0xdd1e, 0x101, 0x6d34, 0x101, 0x6e2f, 0x101, 0x6e6e, 0x101,
    0x3d33, 0x101, 0x6ecb, 0x101, 0x6ec7, 0x201, 0xd84f, 0xded1,
    0x101, 0x6df9, 0x101, 0x6f6e, 0x201, 0xd84f, 0xdf5e, 0x201,
    0xd84f, 0xdf8e, 0x101, 0x6fc6, 0x101, 0x7039, 0x101, 0x701e,
    0x101, 0x701b, 0x101, 0x3d96, 0x101, 0x704a, 0x101, 0x707d,
    0x101, 0x7077, 0x101, 0x70ad, 0x201, 0xd841, 0xdd25, 0x101,
    0x7145, 0x201, 0xd850, 0xde63, 0x101, 0x719c, 0x201, 0xd850,
    0xdfab, 0x101, 0x7228, 0x101, 0x7235, 0x101, 0x7250, 0x201,
    0xd851, 0xde08, 0x101, 0x7280, 0x101, 0x7295, 0x201, 0xd851,
    0xdf35, 0x201, 0xd852, 0xdc14, 0x101, 0x737a, 0x101, 0x738b,
    0x101, 0x3eac, 0x101, 0x73a5, 0x101, 0x3eb8, 0x101, 0x3eb8,
    0x101, 0x7447, 0x101, 0x745c, 0x101, 0x7471, 0x101, 0x7485,
    0x101, 0x74ca, 0x101, 0x3f1b, 0x101, 0x7524, 0x201, 0xd853,
    0xdc36, 0x101, 0x753e, 0x201, 0xd853, 0xdc92, 0x101, 0x7570,
    0x201, 0xd848, 0xdd9f, 0x101, 0x7610, 0x201, 0xd853, 0xdfa1,
    0x201, 0xd853, 0xdfb8, 0x201, 0xd854, 0xdc44, 0x101, 0x3ffc,
    0x101, 0x4008, 0x101, 0x76f4, 0x201, 0xd854, 0xdcf3, 0x201,
    0xd854, 0xdcf2, 0x201, 0xd854, 0xdd19, 0x201, 0xd854, 0xdd33,
    0x101, 0x771e, 0x101, 0x771f, 0x101, 0x771f, 0x101, 0x774a,
    0x101, 0x4039, 0x101, 0x778b, 0x101, 0x4046, 0x101, 0x4096,
    0x201, 0xd855, 0xdc1d, 0x101, 0x784e, 0x101, 0x788c, 0x101,
    0x78cc, 0x101, 0x40e3, 0x201, 0xd855, 0xde26, 0x101, 0x7956,
    0x201, 0xd855, 0xde9a, 0x201, 0xd855, 0xdec5, 0x101, 0x798f,
    0x101, 0x79eb, 0x101, 0x412f, 0x101, 0x7a40, 0x101, 0x7a4a,
    0x101, 0x7a4f, 0x201, 0xd856, 0xdd7c, 0x201, 0xd856, 0xdea7,
    0x201, 0xd856, 0xdea7, 0x101, 0x7aee, 0x101, 0x4202, 0x201,
    0xd856, 0xdfab, 0x101, 0x7bc6, 0x101, 0x7bc9, 0x101, 0x4227,
    0x201, 0xd857, 0xdc80, 0x101, 0x7cd2, 0x101, 0x42a0, 0x101,
    0x7ce8, 0x101, 0x7ce3, 0x101, 0x7d00, 0x201, 0xd857, 0xdf86,
    0x101, 0x7d63, 0x101, 0x4301, 0x101, 0x7dc7, 0x101, 0x7e02,
    0x101, 0x7e45, 0x101, 0x4334, 0x201, 0xd858, 0xde28, 0x201,
    0xd858, 0xde47, 0x101, 0x4359, 0x201, 0xd858, 0xded9, 0x101,
    0x7f7a, 0x201, 0xd858, 0xdf3e, 0x101, 0x7f95, 0x101, 0x7ffa,
    0x101, 0x8005, 0x201, 0xd859, 0xdcda, 0x201, 0xd859, 0xdd23,
    0x101, 0x8060, 0x201, 0xd859, 0xdda8, 0x101, 0x8070, 0x201,
    0xd84c, 0xdf5f, 0x101, 0x43d5, 0x101, 0x80b2, 0x101, 0x8103,
    0x101, 0x440b, 0x101, 0x813e, 0x101, 0x5ab5, 0x201, 0xd859,
    0xdfa7, 0x201, 0xd859, 0xdfb5, 0x201, 0xd84c, 0xdf93, 0x201,
    0xd84c, 0xdf9c, 0x101, 0x8201, 0x101, 0x8204, 0x101, 0x8f9e,
    0x101, 0x446b, 0x101, 0x8291, 0x101, 0x828b, 0x101, 0x829d,
    0x101, 0x52b3, 0x101, 0x82b1, 0x101, 0x82b3, 0x101, 0x82bd,
    0x101, 0x82e6, 0x201, 0xd85a, 0xdf3c, 0x101, 0x82e5, 0x101,
    0x831d, 0x101, 0x8363, 0x101, 0x83ad, 0x101, 0x8323, 0x101,
    0x83bd, 0x101, 0x83e7, 0x101, 0x8457, 0x101, 0x8353, 0x101,
    0x83ca, 0x101, 0x83cc, 0x101, 0x83dc, 0x201, 0xd85b, 0xdc36,
    0x201, 0xd85b, 0xdd6b, 0x201, 0xd85b, 0xdcd5, 0x101, 0x452b,
    0x101, 0x84f1, 0x101, 0x84f3, 0x101, 0x8516, 0x201, 0xd85c,
    0xdfca, 0x101, 0x8564, 0x201, 0xd85b, 0xdf2c, 0x101, 0x455d,
    0x101, 0x4561, 0x201, 0xd85b, 0xdfb1, 0x201, 0xd85c, 0xdcd2,
    0x101, 0x456b, 0x101, 0x8650, 0x101, 0x865c, 0x101, 0x8667,
    0x101, 0x8669, 0x101, 0x86a9, 0x101, 0x8688, 0x101, 0x870e,
    0x101, 0x86e2, 0x101, 0x8779, 0x101, 0x8728, 0x101, 0x876b,
    0x101, 0x8786, 0x101, 0x45d7, 0x101, 0x87e1, 0x101, 0x8801,
    0x101, 0x45f9, 0x101, 0x8860, 0x101, 0x8863, 0x201, 0xd85d,
    0xde67, 0x101, 0x88d7, 0x101, 0x88de, 0x101, 0x4635, 0x101,
    0x88fa, 0x101, 0x34bb, 0x201, 0xd85e, 0xdcae, 0x201, 0xd85e,
    0xdd66, 0x101, 0x46be, 0x101, 0x46c7, 0x101, 0x8aa0, 0x101,
    0x8aed, 0x101, 0x8b8a, 0x101, 0x8c55, 0x201, 0xd85f, 0xdca8,
    0x101, 0x8cab, 0x101, 0x8cc1, 0x101, 0x8d1b, 0x101, 0x8d77,
    0x201, 0xd85f, 0xdf2f, 0x201, 0xd842, 0xdc04, 0x101, 0x8dcb,
    0x101, 0x8dbc, 0x101, 0x8df0, 0x201, 0xd842, 0xdcde, 0x101,
    0x8ed4, 0x101, 0x8f38, 0x201, 0xd861, 0xddd2, 0x201, 0xd861,
    0xdded, 0x101, 0x9094, 0x101, 0x90f1, 0x101, 0x9111, 0x201,
    0xd861, 0xdf2e, 0x101, 0x911b, 0x101, 0x9238, 0x101, 0x92d7,
    0x101, 0x92d8, 0x101, 0x927c, 0x101, 0x93f9, 0x101, 0x9415,
    0x201, 0xd862, 0xdffa, 0x101, 0x958b, 0x101, 0x4995, 0x101,
    0x95b7, 0x201, 0xd863, 0xdd77, 0x101, 0x49e6, 0x101, 0x96c3,
    0x101, 0x5db2, 0x101, 0x9723, 0x201, 0xd864, 0xdd45, 0x201,
    0xd864, 0xde1a, 0x101, 0x4a6e, 0x101, 0x4a76, 0x101, 0x97e0,
    0x201, 0xd865, 0xdc0a, 0x101, 0x4ab2, 0x201, 0xd865, 0xdc96,
    0x101, 0x980b, 0x101, 0x980b, 0x101, 0x9829, 0x201, 0xd865,
    0xddb6, 0x101, 0x98e2, 0x101, 0x4b33, 0x101, 0x9929, 0x101,
    0x99a7, 0x101, 0x99c2, 0x101, 0x99fe, 0x101, 0x4bce, 0x201,
    0xd866, 0xdf30, 0x101, 0x9b12, 0x101, 0x9c40, 0x101, 0x9cfd,
    0x101, 0x4cce, 0x101, 0x4ced, 0x101, 0x9d67, 0x201, 0xd868,
    0xdcce, 0x101, 0x4cf8, 0x201, 0xd868, 0xdd05, 0x201, 0xd868,
    0xde0e, 0x201, 0xd868, 0xde91, 0x101, 0x9ebb, 0x101, 0x4d56,
    0x101, 0x9ef9, 0x101, 0x9efe, 0x101, 0x9f05, 0x101, 0x9f0f,
    0x101, 0x9f16, 0x101, 0x9f3b, 0x201, 0xd869, 0xde00
};

static const unsigned short uc_ligature_trie[] = {
    // 0 - 0x3100

    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    663, 695, 727, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 759, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 791, 631, 631, 631, 823, 855, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 887, 919, 631, 631, 951, 983, 631,
    631, 631, 1015, 631, 631, 631, 1047, 631,
    631, 1079, 1111, 631, 631, 631, 1143, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,

    631, 1175, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 1207, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,

    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,
    631, 631, 631, 631, 631, 631, 631, 631,

    631, 631, 631, 631, 1239, 631, 631, 631,

    // 0x3100 - 0x12000

    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,

    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271, 1527,
    1783, 1271, 2039, 2295, 2551, 1271, 1271, 1271,
    1271, 1271, 1271, 1271, 1271, 1271, 1271,


    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0x0, 0xa9, 0x194, 0x1d5, 0x20e, 0xffff, 0x267, 0x2a8,
    0x305, 0x372, 0x3a3, 0x3b0, 0x3bd, 0xffff, 0xffff, 0x408,
    0xffff, 0x425, 0xffff, 0x43e, 0x45b, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0x47c, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0x485, 0x4da, 0x4df, 0x4e4, 0x4ed,
    0x51a, 0xffff, 0xffff, 0xffff, 0xffff, 0x52f, 0x548, 0xffff,
    0x54d, 0x55a, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x57d, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0x5d6, 0xffff, 0xffff, 0x611, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0x690, 0x693, 0x6a0, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0x6a3, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x6aa, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x6ad,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x6b0, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x6b3, 0x6b6,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x6b9, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x6be,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x6c3, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0x6c6, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x6c9, 0x6d0, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x6d3, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x6d8,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0x6db, 0xffff, 0xffff, 0xffff, 0xffff, 0x6e0,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x6e3,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x6e6, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x6e9, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0x700, 0x761, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0x776, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x783,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x78c, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x791,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x796, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0x79b, 0xffff, 0xffff, 0x7a0, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,

    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x7a5,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff
};

#define GET_LIGATURE_INDEX(ucs4) \
       (ucs4 < 0x3100 \
        ? (uc_ligature_trie[uc_ligature_trie[ucs4>>5] + (ucs4 & 0x1f)]) \
        : (ucs4 < 0x12000 \
           ? uc_ligature_trie[uc_ligature_trie[((ucs4 - 0x3100)>>8) + 0x188] + (ucs4 & 0xff)] \
           : 0xffff))

static const unsigned short uc_ligature_map[] = {
    0x54, 0x41, 0xc0, 0x45, 0xc8, 0x49, 0xcc, 0x4e,
    0x1f8, 0x4f, 0xd2, 0x55, 0xd9, 0x57, 0x1e80, 0x59,
    0x1ef2, 0x61, 0xe0, 0x65, 0xe8, 0x69, 0xec, 0x6e,
    0x1f9, 0x6f, 0xf2, 0x75, 0xf9, 0x77, 0x1e81, 0x79,
    0x1ef3, 0xa8, 0x1fed, 0xc2, 0x1ea6, 0xca, 0x1ec0, 0xd4,
    0x1ed2, 0xdc, 0x1db, 0xe2, 0x1ea7, 0xea, 0x1ec1, 0xf4,
    0x1ed3, 0xfc, 0x1dc, 0x102, 0x1eb0, 0x103, 0x1eb1, 0x112,
    0x1e14, 0x113, 0x1e15, 0x14c, 0x1e50, 0x14d, 0x1e51, 0x1a0,
    0x1edc, 0x1a1, 0x1edd, 0x1af, 0x1eea, 0x1b0, 0x1eeb, 0x391,
    0x1fba, 0x395, 0x1fc8, 0x397, 0x1fca, 0x399, 0x1fda, 0x39f,
    0x1ff8, 0x3a5, 0x1fea, 0x3a9, 0x1ffa, 0x3b1, 0x1f70, 0x3b5,
    0x1f72, 0x3b7, 0x1f74, 0x3b9, 0x1f76, 0x3bf, 0x1f78, 0x3c5,
    0x1f7a, 0x3c9, 0x1f7c, 0x3ca, 0x1fd2, 0x3cb, 0x1fe2, 0x415,
    0x400, 0x418, 0x40d, 0x435, 0x450, 0x438, 0x45d, 0x1f00,
    0x1f02, 0x1f01, 0x1f03, 0x1f08, 0x1f0a, 0x1f09, 0x1f0b, 0x1f10,
    0x1f12, 0x1f11, 0x1f13, 0x1f18, 0x1f1a, 0x1f19, 0x1f1b, 0x1f20,
    0x1f22, 0x1f21, 0x1f23, 0x1f28, 0x1f2a, 0x1f29, 0x1f2b, 0x1f30,
    0x1f32, 0x1f31, 0x1f33, 0x1f38, 0x1f3a, 0x1f39, 0x1f3b, 0x1f40,
    0x1f42, 0x1f41, 0x1f43, 0x1f48, 0x1f4a, 0x1f49, 0x1f4b, 0x1f50,
    0x1f52, 0x1f51, 0x1f53, 0x1f59, 0x1f5b, 0x1f60, 0x1f62, 0x1f61,
    0x1f63, 0x1f68, 0x1f6a, 0x1f69, 0x1f6b, 0x1fbf, 0x1fcd, 0x1ffe,
    0x1fdd, 0x75, 0x41, 0xc1, 0x43, 0x106, 0x45, 0xc9,
    0x47, 0x1f4, 0x49, 0xcd, 0x4b, 0x1e30, 0x4c, 0x139,
    0x4d, 0x1e3e, 0x4e, 0x143, 0x4f, 0xd3, 0x50, 0x1e54,
    0x52, 0x154, 0x53, 0x15a, 0x55, 0xda, 0x57, 0x1e82,
    0x59, 0xdd, 0x5a, 0x179, 0x61, 0xe1, 0x63, 0x107,
    0x65, 0xe9, 0x67, 0x1f5, 0x69, 0xed, 0x6b, 0x1e31,
    0x6c, 0x13a, 0x6d, 0x1e3f, 0x6e, 0x144, 0x6f, 0xf3,
    0x70, 0x1e55, 0x72, 0x155, 0x73, 0x15b, 0x75, 0xfa,
    0x77, 0x1e83, 0x79, 0xfd, 0x7a, 0x17a, 0xa8, 0x385,
    0xc2, 0x1ea4, 0xc5, 0x1fa, 0xc6, 0x1fc, 0xc7, 0x1e08,
    0xca, 0x1ebe, 0xcf, 0x1e2e, 0xd4, 0x1ed0, 0xd5, 0x1e4c,
    0xd8, 0x1fe, 0xdc, 0x1d7, 0xe2, 0x1ea5, 0xe5, 0x1fb,
    0xe6, 0x1fd, 0xe7, 0x1e09, 0xea, 0x1ebf, 0xef, 0x1e2f,
    0xf4, 0x1ed1, 0xf5, 0x1e4d, 0xf8, 0x1ff, 0xfc, 0x1d8,
    0x102, 0x1eae, 0x103, 0x1eaf, 0x112, 0x1e16, 0x113, 0x1e17,
    0x14c, 0x1e52, 0x14d, 0x1e53, 0x168, 0x1e78, 0x169, 0x1e79,
    0x1a0, 0x1eda, 0x1a1, 0x1edb, 0x1af, 0x1ee8, 0x1b0, 0x1ee9,
    0x391, 0x386, 0x395, 0x388, 0x397, 0x389, 0x399, 0x38a,
    0x39f, 0x38c, 0x3a5, 0x38e, 0x3a9, 0x38f, 0x3b1, 0x3ac,
    0x3b5, 0x3ad, 0x3b7, 0x3ae, 0x3b9, 0x3af, 0x3bf, 0x3cc,
    0x3c5, 0x3cd, 0x3c9, 0x3ce, 0x3ca, 0x390, 0x3cb, 0x3b0,
    0x3d2, 0x3d3, 0x413, 0x403, 0x41a, 0x40c, 0x433, 0x453,
    0x43a, 0x45c, 0x1f00, 0x1f04, 0x1f01, 0x1f05, 0x1f08, 0x1f0c,
    0x1f09, 0x1f0d, 0x1f10, 0x1f14, 0x1f11, 0x1f15, 0x1f18, 0x1f1c,
    0x1f19, 0x1f1d, 0x1f20, 0x1f24, 0x1f21, 0x1f25, 0x1f28, 0x1f2c,
    0x1f29, 0x1f2d, 0x1f30, 0x1f34, 0x1f31, 0x1f35, 0x1f38, 0x1f3c,
    0x1f39, 0x1f3d, 0x1f40, 0x1f44, 0x1f41, 0x1f45, 0x1f48, 0x1f4c,
    0x1f49, 0x1f4d, 0x1f50, 0x1f54, 0x1f51, 0x1f55, 0x1f59, 0x1f5d,
    0x1f60, 0x1f64, 0x1f61, 0x1f65, 0x1f68, 0x1f6c, 0x1f69, 0x1f6d,
    0x1fbf, 0x1fce, 0x1ffe, 0x1fde, 0x20, 0x41, 0xc2, 0x43,
    0x108, 0x45, 0xca, 0x47, 0x11c, 0x48, 0x124, 0x49,
    0xce, 0x4a, 0x134, 0x4f, 0xd4, 0x53, 0x15c, 0x55,
    0xdb, 0x57, 0x174, 0x59, 0x176, 0x5a, 0x1e90, 0x61,
    0xe2, 0x63, 0x109, 0x65, 0xea, 0x67, 0x11d, 0x68,
    0x125, 0x69, 0xee, 0x6a, 0x135, 0x6f, 0xf4, 0x73,
    0x15d, 0x75, 0xfb, 0x77, 0x175, 0x79, 0x177, 0x7a,
    0x1e91, 0x1ea0, 0x1eac, 0x1ea1, 0x1ead, 0x1eb8, 0x1ec6, 0x1eb9,
    0x1ec7, 0x1ecc, 0x1ed8, 0x1ecd, 0x1ed9, 0x1c, 0x41, 0xc3,
    0x45, 0x1ebc, 0x49, 0x128, 0x4e, 0xd1, 0x4f, 0xd5,
    0x55, 0x168, 0x56, 0x1e7c, 0x59, 0x1ef8, 0x61, 0xe3,
    0x65, 0x1ebd, 0x69, 0x129, 0x6e, 0xf1, 0x6f, 0xf5,
    0x75, 0x169, 0x76, 0x1e7d, 0x79, 0x1ef9, 0xc2, 0x1eaa,
    0xca, 0x1ec4, 0xd4, 0x1ed6, 0xe2, 0x1eab, 0xea, 0x1ec5,
    0xf4, 0x1ed7, 0x102, 0x1eb4, 0x103, 0x1eb5, 0x1a0, 0x1ee0,
    0x1a1, 0x1ee1, 0x1af, 0x1eee, 0x1b0, 0x1eef, 0x2c, 0x41,
    0x100, 0x45, 0x112, 0x47, 0x1e20, 0x49, 0x12a, 0x4f,
    0x14c, 0x55, 0x16a, 0x59, 0x232, 0x61, 0x101, 0x65,
    0x113, 0x67, 0x1e21, 0x69, 0x12b, 0x6f, 0x14d, 0x75,
    0x16b, 0x79, 0x233, 0xc4, 0x1de, 0xc6, 0x1e2, 0xd5,
    0x22c, 0xd6, 0x22a, 0xdc, 0x1d5, 0xe4, 0x1df, 0xe6,
    0x1e3, 0xf5, 0x22d, 0xf6, 0x22b, 0xfc, 0x1d6, 0x1ea,
    0x1ec, 0x1eb, 0x1ed, 0x226, 0x1e0, 0x227, 0x1e1, 0x22e,
    0x230, 0x22f, 0x231, 0x391, 0x1fb9, 0x399, 0x1fd9, 0x3a5,
    0x1fe9, 0x3b1, 0x1fb1, 0x3b9, 0x1fd1, 0x3c5, 0x1fe1, 0x418,
    0x4e2, 0x423, 0x4ee, 0x438, 0x4e3, 0x443, 0x4ef, 0x1e36,
    0x1e38, 0x1e37, 0x1e39, 0x1e5a, 0x1e5c, 0x1e5b, 0x1e5d, 0x20,
    0x41, 0x102, 0x45, 0x114, 0x47, 0x11e, 0x49, 0x12c,
    0x4f, 0x14e, 0x55, 0x16c, 0x61, 0x103, 0x65, 0x115,
    0x67, 0x11f, 0x69, 0x12d, 0x6f, 0x14f, 0x75, 0x16d,
    0x228, 0x1e1c, 0x229, 0x1e1d, 0x391, 0x1fb8, 0x399, 0x1fd8,
    0x3a5, 0x1fe8, 0x3b1, 0x1fb0, 0x3b9, 0x1fd0, 0x3c5, 0x1fe0,
    0x410, 0x4d0, 0x415, 0x4d6, 0x416, 0x4c1, 0x418, 0x419,
    0x423, 0x40e, 0x430, 0x4d1, 0x435, 0x4d7, 0x436, 0x4c2,
    0x438, 0x439, 0x443, 0x45e, 0x1ea0, 0x1eb6, 0x1ea1, 0x1eb7,
    0x2e, 0x41, 0x226, 0x42, 0x1e02, 0x43, 0x10a, 0x44,
    0x1e0a, 0x45, 0x116, 0x46, 0x1e1e, 0x47, 0x120, 0x48,
    0x1e22, 0x49, 0x130, 0x4d, 0x1e40, 0x4e, 0x1e44, 0x4f,
    0x22e, 0x50, 0x1e56, 0x52, 0x1e58, 0x53, 0x1e60, 0x54,
    0x1e6a, 0x57, 0x1e86, 0x58, 0x1e8a, 0x59, 0x1e8e, 0x5a,
    0x17b, 0x61, 0x227, 0x62, 0x1e03, 0x63, 0x10b, 0x64,
    0x1e0b, 0x65, 0x117, 0x66, 0x1e1f, 0x67, 0x121, 0x68,
    0x1e23, 0x6d, 0x1e41, 0x6e, 0x1e45, 0x6f, 0x22f, 0x70,
    0x1e57, 0x72, 0x1e59, 0x73, 0x1e61, 0x74, 0x1e6b, 0x77,
    0x1e87, 0x78, 0x1e8b, 0x79, 0x1e8f, 0x7a, 0x17c, 0x15a,
    0x1e64, 0x15b, 0x1e65, 0x160, 0x1e66, 0x161, 0x1e67, 0x17f,
    0x1e9b, 0x1e62, 0x1e68, 0x1e63, 0x1e69, 0x36, 0x41, 0xc4,
    0x45, 0xcb, 0x48, 0x1e26, 0x49, 0xcf, 0x4f, 0xd6,
    0x55, 0xdc, 0x57, 0x1e84, 0x58, 0x1e8c, 0x59, 0x178,
    0x61, 0xe4, 0x65, 0xeb, 0x68, 0x1e27, 0x69, 0xef,
    0x6f, 0xf6, 0x74, 0x1e97, 0x75, 0xfc, 0x77, 0x1e85,
    0x78, 0x1e8d, 0x79, 0xff, 0xd5, 0x1e4e, 0xf5, 0x1e4f,
    0x16a, 0x1e7a, 0x16b, 0x1e7b, 0x399, 0x3aa, 0x3a5, 0x3ab,
    0x3b9, 0x3ca, 0x3c5, 0x3cb, 0x3d2, 0x3d4, 0x406, 0x407,
    0x410, 0x4d2, 0x415, 0x401, 0x416, 0x4dc, 0x417, 0x4de,
    0x418, 0x4e4, 0x41e, 0x4e6, 0x423, 0x4f0, 0x427, 0x4f4,
    0x42b, 0x4f8, 0x42d, 0x4ec, 0x430, 0x4d3, 0x435, 0x451,
    0x436, 0x4dd, 0x437, 0x4df, 0x438, 0x4e5, 0x43e, 0x4e7,
    0x443, 0x4f1, 0x447, 0x4f5, 0x44b, 0x4f9, 0x44d, 0x4ed,
    0x456, 0x457, 0x4d8, 0x4da, 0x4d9, 0x4db, 0x4e8, 0x4ea,
    0x4e9, 0x4eb, 0x18, 0x41, 0x1ea2, 0x45, 0x1eba, 0x49,
    0x1ec8, 0x4f, 0x1ece, 0x55, 0x1ee6, 0x59, 0x1ef6, 0x61,
    0x1ea3, 0x65, 0x1ebb, 0x69, 0x1ec9, 0x6f, 0x1ecf, 0x75,
    0x1ee7, 0x79, 0x1ef7, 0xc2, 0x1ea8, 0xca, 0x1ec2, 0xd4,
    0x1ed4, 0xe2, 0x1ea9, 0xea, 0x1ec3, 0xf4, 0x1ed5, 0x102,
    0x1eb2, 0x103, 0x1eb3, 0x1a0, 0x1ede, 0x1a1, 0x1edf, 0x1af,
    0x1eec, 0x1b0, 0x1eed, 0x6, 0x41, 0xc5, 0x55, 0x16e,
    0x61, 0xe5, 0x75, 0x16f, 0x77, 0x1e98, 0x79, 0x1e99,
    0x6, 0x4f, 0x150, 0x55, 0x170, 0x6f, 0x151, 0x75,
    0x171, 0x423, 0x4f2, 0x443, 0x4f3, 0x25, 0x41, 0x1cd,
    0x43, 0x10c, 0x44, 0x10e, 0x45, 0x11a, 0x47, 0x1e6,
    0x48, 0x21e, 0x49, 0x1cf, 0x4b, 0x1e8, 0x4c, 0x13d,
    0x4e, 0x147, 0x4f, 0x1d1, 0x52, 0x158, 0x53, 0x160,
    0x54, 0x164, 0x55, 0x1d3, 0x5a, 0x17d, 0x61, 0x1ce,
    0x63, 0x10d, 0x64, 0x10f, 0x65, 0x11b, 0x67, 0x1e7,
    0x68, 0x21f, 0x69, 0x1d0, 0x6a, 0x1f0, 0x6b, 0x1e9,
    0x6c, 0x13e, 0x6e, 0x148, 0x6f, 0x1d2, 0x72, 0x159,
    0x73, 0x161, 0x74, 0x165, 0x75, 0x1d4, 0x7a, 0x17e,
    0xdc, 0x1d9, 0xfc, 0x1da, 0x1b7, 0x1ee, 0x292, 0x1ef,
    0xe, 0x41, 0x200, 0x45, 0x204, 0x49, 0x208, 0x4f,
    0x20c, 0x52, 0x210, 0x55, 0x214, 0x61, 0x201, 0x65,
    0x205, 0x69, 0x209, 0x6f, 0x20d, 0x72, 0x211, 0x75,
    0x215, 0x474, 0x476, 0x475, 0x477, 0xc, 0x41, 0x202,
    0x45, 0x206, 0x49, 0x20a, 0x4f, 0x20e, 0x52, 0x212,
    0x55, 0x216, 0x61, 0x203, 0x65, 0x207, 0x69, 0x20b,
    0x6f, 0x20f, 0x72, 0x213, 0x75, 0x217, 0xe, 0x391,
    0x1f08, 0x395, 0x1f18, 0x397, 0x1f28, 0x399, 0x1f38, 0x39f,
    0x1f48, 0x3a9, 0x1f68, 0x3b1, 0x1f00, 0x3b5, 0x1f10, 0x3b7,
    0x1f20, 0x3b9, 0x1f30, 0x3bf, 0x1f40, 0x3c1, 0x1fe4, 0x3c5,
    0x1f50, 0x3c9, 0x1f60, 0x10, 0x391, 0x1f09, 0x395, 0x1f19,
    0x397, 0x1f29, 0x399, 0x1f39, 0x39f, 0x1f49, 0x3a1, 0x1fec,
    0x3a5, 0x1f59, 0x3a9, 0x1f69, 0x3b1, 0x1f01, 0x3b5, 0x1f11,
    0x3b7, 0x1f21, 0x3b9, 0x1f31, 0x3bf, 0x1f41, 0x3c1, 0x1fe5,
    0x3c5, 0x1f51, 0x3c9, 0x1f61, 0x4, 0x4f, 0x1a0, 0x55,
    0x1af, 0x6f, 0x1a1, 0x75, 0x1b0, 0x2a, 0x41, 0x1ea0,
    0x42, 0x1e04, 0x44, 0x1e0c, 0x45, 0x1eb8, 0x48, 0x1e24,
    0x49, 0x1eca, 0x4b, 0x1e32, 0x4c, 0x1e36, 0x4d, 0x1e42,
    0x4e, 0x1e46, 0x4f, 0x1ecc, 0x52, 0x1e5a, 0x53, 0x1e62,
    0x54, 0x1e6c, 0x55, 0x1ee4, 0x56, 0x1e7e, 0x57, 0x1e88,
    0x59, 0x1ef4, 0x5a, 0x1e92, 0x61, 0x1ea1, 0x62, 0x1e05,
    0x64, 0x1e0d, 0x65, 0x1eb9, 0x68, 0x1e25, 0x69, 0x1ecb,
    0x6b, 0x1e33, 0x6c, 0x1e37, 0x6d, 0x1e43, 0x6e, 0x1e47,
    0x6f, 0x1ecd, 0x72, 0x1e5b, 0x73, 0x1e63, 0x74, 0x1e6d,
    0x75, 0x1ee5, 0x76, 0x1e7f, 0x77, 0x1e89, 0x79, 0x1ef5,
    0x7a, 0x1e93, 0x1a0, 0x1ee2, 0x1a1, 0x1ee3, 0x1af, 0x1ef0,
    0x1b0, 0x1ef1, 0x2, 0x55, 0x1e72, 0x75, 0x1e73, 0x2,
    0x41, 0x1e00, 0x61, 0x1e01, 0x4, 0x53, 0x218, 0x54,
    0x21a, 0x73, 0x219, 0x74, 0x21b, 0x16, 0x43, 0xc7,
    0x44, 0x1e10, 0x45, 0x228, 0x47, 0x122, 0x48, 0x1e28,
    0x4b, 0x136, 0x4c, 0x13b, 0x4e, 0x145, 0x52, 0x156,
    0x53, 0x15e, 0x54, 0x162, 0x63, 0xe7, 0x64, 0x1e11,
    0x65, 0x229, 0x67, 0x123, 0x68, 0x1e29, 0x6b, 0x137,
    0x6c, 0x13c, 0x6e, 0x146, 0x72, 0x157, 0x73, 0x15f,
    0x74, 0x163, 0xa, 0x41, 0x104, 0x45, 0x118, 0x49,
    0x12e, 0x4f, 0x1ea, 0x55, 0x172, 0x61, 0x105, 0x65,
    0x119, 0x69, 0x12f, 0x6f, 0x1eb, 0x75, 0x173, 0xc,
    0x44, 0x1e12, 0x45, 0x1e18, 0x4c, 0x1e3c, 0x4e, 0x1e4a,
    0x54, 0x1e70, 0x55, 0x1e76, 0x64, 0x1e13, 0x65, 0x1e19,
    0x6c, 0x1e3d, 0x6e, 0x1e4b, 0x74, 0x1e71, 0x75, 0x1e77,
    0x2, 0x48, 0x1e2a, 0x68, 0x1e2b, 0x6, 0x45, 0x1e1a,
    0x49, 0x1e2c, 0x55, 0x1e74, 0x65, 0x1e1b, 0x69, 0x1e2d,
    0x75, 0x1e75, 0x11, 0x42, 0x1e06, 0x44, 0x1e0e, 0x4b,
    0x1e34, 0x4c, 0x1e3a, 0x4e, 0x1e48, 0x52, 0x1e5e, 0x54,
    0x1e6e, 0x5a, 0x1e94, 0x62, 0x1e07, 0x64, 0x1e0f, 0x68,
    0x1e96, 0x6b, 0x1e35, 0x6c, 0x1e3b, 0x6e, 0x1e49, 0x72,
    0x1e5f, 0x74, 0x1e6f, 0x7a, 0x1e95, 0x2c, 0x3c, 0x226e,
    0x3d, 0x2260, 0x3e, 0x226f, 0x2190, 0x219a, 0x2192, 0x219b,
    0x2194, 0x21ae, 0x21d0, 0x21cd, 0x21d2, 0x21cf, 0x21d4, 0x21ce,
    0x2203, 0x2204, 0x2208, 0x2209, 0x220b, 0x220c, 0x2223, 0x2224,
    0x2225, 0x2226, 0x223c, 0x2241, 0x2243, 0x2244, 0x2245, 0x2247,
    0x2248, 0x2249, 0x224d, 0x226d, 0x2261, 0x2262, 0x2264, 0x2270,
    0x2265, 0x2271, 0x2272, 0x2274, 0x2273, 0x2275, 0x2276, 0x2278,
    0x2277, 0x2279, 0x227a, 0x2280, 0x227b, 0x2281, 0x227c, 0x22e0,
    0x227d, 0x22e1, 0x2282, 0x2284, 0x2283, 0x2285, 0x2286, 0x2288,
    0x2287, 0x2289, 0x2291, 0x22e2, 0x2292, 0x22e3, 0x22a2, 0x22ac,
    0x22a8, 0x22ad, 0x22a9, 0x22ae, 0x22ab, 0x22af, 0x22b2, 0x22ea,
    0x22b3, 0x22eb, 0x22b4, 0x22ec, 0x22b5, 0x22ed, 0x1d, 0xa8,
    0x1fc1, 0x3b1, 0x1fb6, 0x3b7, 0x1fc6, 0x3b9, 0x1fd6, 0x3c5,
    0x1fe6, 0x3c9, 0x1ff6, 0x3ca, 0x1fd7, 0x3cb, 0x1fe7, 0x1f00,
    0x1f06, 0x1f01, 0x1f07, 0x1f08, 0x1f0e, 0x1f09, 0x1f0f, 0x1f20,
    0x1f26, 0x1f21, 0x1f27, 0x1f28, 0x1f2e, 0x1f29, 0x1f2f, 0x1f30,
    0x1f36, 0x1f31, 0x1f37, 0x1f38, 0x1f3e, 0x1f39, 0x1f3f, 0x1f50,
    0x1f56, 0x1f51, 0x1f57, 0x1f59, 0x1f5f, 0x1f60, 0x1f66, 0x1f61,
    0x1f67, 0x1f68, 0x1f6e, 0x1f69, 0x1f6f, 0x1fbf, 0x1fcf, 0x1ffe,
    0x1fdf, 0x3f, 0x391, 0x1fbc, 0x397, 0x1fcc, 0x3a9, 0x1ffc,
    0x3ac, 0x1fb4, 0x3ae, 0x1fc4, 0x3b1, 0x1fb3, 0x3b7, 0x1fc3,
    0x3c9, 0x1ff3, 0x3ce, 0x1ff4, 0x1f00, 0x1f80, 0x1f01, 0x1f81,
    0x1f02, 0x1f82, 0x1f03, 0x1f83, 0x1f04, 0x1f84, 0x1f05, 0x1f85,
    0x1f06, 0x1f86, 0x1f07, 0x1f87, 0x1f08, 0x1f88, 0x1f09, 0x1f89,
    0x1f0a, 0x1f8a, 0x1f0b, 0x1f8b, 0x1f0c, 0x1f8c, 0x1f0d, 0x1f8d,
    0x1f0e, 0x1f8e, 0x1f0f, 0x1f8f, 0x1f20, 0x1f90, 0x1f21, 0x1f91,
    0x1f22, 0x1f92, 0x1f23, 0x1f93, 0x1f24, 0x1f94, 0x1f25, 0x1f95,
    0x1f26, 0x1f96, 0x1f27, 0x1f97, 0x1f28, 0x1f98, 0x1f29, 0x1f99,
    0x1f2a, 0x1f9a, 0x1f2b, 0x1f9b, 0x1f2c, 0x1f9c, 0x1f2d, 0x1f9d,
    0x1f2e, 0x1f9e, 0x1f2f, 0x1f9f, 0x1f60, 0x1fa0, 0x1f61, 0x1fa1,
    0x1f62, 0x1fa2, 0x1f63, 0x1fa3, 0x1f64, 0x1fa4, 0x1f65, 0x1fa5,
    0x1f66, 0x1fa6, 0x1f67, 0x1fa7, 0x1f68, 0x1fa8, 0x1f69, 0x1fa9,
    0x1f6a, 0x1faa, 0x1f6b, 0x1fab, 0x1f6c, 0x1fac, 0x1f6d, 0x1fad,
    0x1f6e, 0x1fae, 0x1f6f, 0x1faf, 0x1f70, 0x1fb2, 0x1f74, 0x1fc2,
    0x1f7c, 0x1ff2, 0x1fb6, 0x1fb7, 0x1fc6, 0x1fc7, 0x1ff6, 0x1ff7,
    0x1, 0x627, 0x622, 0x6, 0x627, 0x623, 0x648, 0x624,
    0x64a, 0x626, 0x6c1, 0x6c2, 0x6d2, 0x6d3, 0x6d5, 0x6c0,
    0x1, 0x627, 0x625, 0x3, 0x928, 0x929, 0x930, 0x931,
    0x933, 0x934, 0x1, 0x9c7, 0x9cb, 0x1, 0x9c7, 0x9cc,
    0x1, 0xb47, 0xb4b, 0x1, 0xb47, 0xb48, 0x1, 0xb47,
    0xb4c, 0x2, 0xbc6, 0xbca, 0xbc7, 0xbcb, 0x2, 0xb92,
    0xb94, 0xbc6, 0xbcc, 0x1, 0xc46, 0xc48, 0x1, 0xcc6,
    0xcca, 0x3, 0xcbf, 0xcc0, 0xcc6, 0xcc7, 0xcca, 0xccb,
    0x1, 0xcc6, 0xcc8, 0x2, 0xd46, 0xd4a, 0xd47, 0xd4b,
    0x1, 0xd46, 0xd4c, 0x2, 0xdd9, 0xdda, 0xddc, 0xddd,
    0x1, 0xdd9, 0xddc, 0x1, 0xdd9, 0xdde, 0x1, 0x1025,
    0x1026, 0xb, 0x1b05, 0x1b06, 0x1b07, 0x1b08, 0x1b09, 0x1b0a,
    0x1b0b, 0x1b0c, 0x1b0d, 0x1b0e, 0x1b11, 0x1b12, 0x1b3a, 0x1b3b,
    0x1b3c, 0x1b3d, 0x1b3e, 0x1b40, 0x1b3f, 0x1b41, 0x1b42, 0x1b43,
    0x30, 0x3046, 0x3094, 0x304b, 0x304c, 0x304d, 0x304e, 0x304f,
    0x3050, 0x3051, 0x3052, 0x3053, 0x3054, 0x3055, 0x3056, 0x3057,
    0x3058, 0x3059, 0x305a, 0x305b, 0x305c, 0x305d, 0x305e, 0x305f,
    0x3060, 0x3061, 0x3062, 0x3064, 0x3065, 0x3066, 0x3067, 0x3068,
    0x3069, 0x306f, 0x3070, 0x3072, 0x3073, 0x3075, 0x3076, 0x3078,
    0x3079, 0x307b, 0x307c, 0x309d, 0x309e, 0x30a6, 0x30f4, 0x30ab,
    0x30ac, 0x30ad, 0x30ae, 0x30af, 0x30b0, 0x30b1, 0x30b2, 0x30b3,
    0x30b4, 0x30b5, 0x30b6, 0x30b7, 0x30b8, 0x30b9, 0x30ba, 0x30bb,
    0x30bc, 0x30bd, 0x30be, 0x30bf, 0x30c0, 0x30c1, 0x30c2, 0x30c4,
    0x30c5, 0x30c6, 0x30c7, 0x30c8, 0x30c9, 0x30cf, 0x30d0, 0x30d2,
    0x30d3, 0x30d5, 0x30d6, 0x30d8, 0x30d9, 0x30db, 0x30dc, 0x30ef,
    0x30f7, 0x30f0, 0x30f8, 0x30f1, 0x30f9, 0x30f2, 0x30fa, 0x30fd,
    0x30fe, 0xa, 0x306f, 0x3071, 0x3072, 0x3074, 0x3075, 0x3077,
    0x3078, 0x307a, 0x307b, 0x307d, 0x30cf, 0x30d1, 0x30d2, 0x30d4,
    0x30d5, 0x30d7, 0x30d8, 0x30da, 0x30db, 0x30dd, 0x3, 0xd804,
    0xdc99, 0xd804, 0xdc9a, 0xd804, 0xdc9b, 0xd804, 0xdc9c, 0xd804,
    0xdca5, 0xd804, 0xdcab, 0x2, 0xd804, 0xdd31, 0xd804, 0xdd2e,
    0xd804, 0xdd32, 0xd804, 0xdd2f, 0x1, 0xd804, 0xdf47, 0xd804,
    0xdf4b, 0x1, 0xd804, 0xdf47, 0xd804, 0xdf4c, 0x1, 0xd805,
    0xdcb9, 0xd805, 0xdcbc, 0x1, 0xd805, 0xdcb9, 0xd805, 0xdcbb,
    0x1, 0xd805, 0xdcb9, 0xd805, 0xdcbe, 0x2, 0xd805, 0xddb8,
    0xd805, 0xddba, 0xd805, 0xddb9, 0xd805, 0xddbb
};


struct NormalizationCorrection {
    uint ucs4;
    uint old_mapping;
    int version;
};

static const NormalizationCorrection uc_normalization_corrections[] = {
    { 0xf951, 0x96fb, 6 },
    { 0x2f868, 0x2136a, 7 },
    { 0x2f874, 0x5f33, 7 },
    { 0x2f91f, 0x43ab, 7 },
    { 0x2f95f, 0x7aae, 7 },
    { 0x2f9bf, 0x4d57, 7 }
};

enum { NumNormalizationCorrections = 6 };
enum { NormalizationCorrectionsVersionMax = 7 };

} // namespace QUnicodeTables

using namespace QUnicodeTables;

QT_END_NAMESPACE
