/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.puppycrawl.tools.checkstyle.checks.imports.AccessResult;

class Guard {
    private final boolean allowed;
    private final String pkgName;
    private final String className;
    private final boolean exactMatch;
    private final boolean localOnly;
    private final boolean regExp;

    Guard(boolean allow, boolean localOnly, String pkgName, boolean exactMatch, boolean regExp) {
        this.allowed = allow;
        this.localOnly = localOnly;
        this.pkgName = pkgName;
        this.regExp = regExp;
        this.className = null;
        this.exactMatch = exactMatch;
    }

    Guard(boolean allow, boolean localOnly, String className, boolean regExp) {
        this.allowed = allow;
        this.localOnly = localOnly;
        this.regExp = regExp;
        this.pkgName = null;
        this.className = className;
        this.exactMatch = true;
    }

    AccessResult verifyImport(String forImport) {
        boolean pkgMatch;
        assert (forImport != null);
        if (this.className != null) {
            boolean classMatch = this.regExp ? forImport.matches(this.className) : forImport.equals(this.className);
            return this.calculateResult(classMatch);
        }
        assert (this.pkgName != null);
        if (this.regExp) {
            pkgMatch = forImport.matches(this.pkgName + "\\..*");
            if (pkgMatch && this.exactMatch) {
                pkgMatch = !forImport.matches(this.pkgName + "\\..*\\..*");
            }
        } else {
            pkgMatch = forImport.startsWith(this.pkgName + ".");
            if (pkgMatch && this.exactMatch) {
                pkgMatch = forImport.indexOf(46, this.pkgName.length() + 1) == -1;
            }
        }
        return this.calculateResult(pkgMatch);
    }

    boolean isLocalOnly() {
        return this.localOnly;
    }

    private AccessResult calculateResult(boolean matched) {
        if (matched) {
            return this.allowed ? AccessResult.ALLOWED : AccessResult.DISALLOWED;
        }
        return AccessResult.UNKNOWN;
    }
}

