/*!****************************************************************************

 @file         OGLES2/OGLES2Tools.h
 @ingroup      API_OGLES2
 @copyright    Copyright (c) Imagination Technologies Limited.
 @brief        Header file of OGLES2Tools.lib.

******************************************************************************/

#ifndef _OGLES2TOOLS_H_
#define _OGLES2TOOLS_H_

/*! 
 @addtogroup API_OGLES2
 @brief      Tools for the OpenGL ES 2.0 API.
*/

#ifndef BUILD_OGLES2
	#define BUILD_OGLES2
#endif

#include "PVRTContext.h"
#include "../PVRTGlobal.h"
#include "../PVRTArray.h"
#include "../PVRTHash.h"
#include "../PVRTVector.h"
#include "../PVRTString.h"
#include "../PVRTStringHash.h"
#include "../PVRTFixedPoint.h"
#include "../PVRTMatrix.h"
#include "../PVRTQuaternion.h"
#include "../PVRTTrans.h"
#include "../PVRTVertex.h"
#include "../PVRTMap.h"
#include "../PVRTMisc.h"
#include "../PVRTBackground.h"
#include "PVRTgles2Ext.h"
#include "../PVRTPrint3D.h"
#include "../PVRTBoneBatch.h"
#include "../PVRTModelPOD.h"
#include "../PVRTTexture.h"
#include "PVRTTextureAPI.h"
#include "../PVRTTriStrip.h"
#include "PVRTShader.h"
#include "../PVRTPFXParser.h"
#include "PVRTPFXParserAPI.h"
#include "PVRTPFXSemantics.h"
#include "../PVRTShadowVol.h"
#include "../PVRTResourceFile.h"
#include "../PVRTError.h"

#endif /* _OGLES2TOOLS_H_ */

/*****************************************************************************
 End of file (OGLES2Tools.h)
*****************************************************************************/

