
#=============================================================================
# Copyright 2002-2010 Kitware, Inc.
#
# Distributed under the OSI-approved BSD License (the "License");
# see accompanying file Copyright.txt for details.
#
# This software is distributed WITHOUT ANY WARRANTY; without even the
# implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the License for more information.
#=============================================================================
# (To distribute this file outside of CMake, substitute the full
#  License text for the above reference.)

# This module is shared by multiple languages; use include blocker.
if(__WINDOWS_INTEL)
  return()
endif()
set(__WINDOWS_INTEL 1)

# make sure to enable languages after setting configuration types
ENABLE_LANGUAGE(RC)
SET(CMAKE_COMPILE_RESOURCE "rc <FLAGS> /fo<OBJECT> <SOURCE>")

SET(CMAKE_LIBRARY_PATH_FLAG "-LIBPATH:")
SET(CMAKE_LINK_LIBRARY_FLAG "")
SET(WIN32 1)
IF(CMAKE_VERBOSE_MAKEFILE)
  SET(CMAKE_CL_NOLOGO)
ELSE(CMAKE_VERBOSE_MAKEFILE)
  SET(CMAKE_CL_NOLOGO "/nologo")
ENDIF(CMAKE_VERBOSE_MAKEFILE)
SET(CMAKE_COMPILE_RESOURCE "rc <FLAGS> /fo<OBJECT> <SOURCE>")
SET(CMAKE_CREATE_WIN32_EXE /subsystem:windows)
SET(CMAKE_CREATE_CONSOLE_EXE /subsystem:console)

# default to Debug builds
#SET(CMAKE_BUILD_TYPE_INIT Debug)
SET(CMAKE_BUILD_TYPE_INIT Release)

SET(CMAKE_C_STANDARD_LIBRARIES_INIT "kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib")
SET(CMAKE_CXX_STANDARD_LIBRARIES_INIT "${CMAKE_C_STANDARD_LIBRARIES_INIT}")

# executable linker flags
SET (CMAKE_LINK_DEF_FILE_FLAG "/DEF:")
IF(MSVC_C_ARCHITECTURE_ID)
  SET(_MACHINE_ARCH_FLAG "/machine:${MSVC_C_ARCHITECTURE_ID}")
ELSEIF(MSVC_CXX_ARCHITECTURE_ID)
  SET(_MACHINE_ARCH_FLAG "/machine:${MSVC_CXX_ARCHITECTURE_ID}")
ELSEIF(MSVC_Fortran_ARCHITECTURE_ID)
  SET(_MACHINE_ARCH_FLAG "/machine:${MSVC_Fortran_ARCHITECTURE_ID}")
ENDIF()
SET (CMAKE_EXE_LINKER_FLAGS_INIT "/STACK:10000000 /INCREMENTAL:YES ${_MACHINE_ARCH_FLAG}")
SET (CMAKE_EXE_LINKER_FLAGS_DEBUG_INIT "/debug")
SET (CMAKE_EXE_LINKER_FLAGS_RELWITHDEBINFO_INIT "/debug")

SET (CMAKE_SHARED_LINKER_FLAGS_INIT ${CMAKE_EXE_LINKER_FLAGS_INIT})
SET (CMAKE_SHARED_LINKER_FLAGS_DEBUG_INIT ${CMAKE_EXE_LINKER_FLAGS_DEBUG_INIT})
SET (CMAKE_SHARED_LINKER_FLAGS_RELWITHDEBINFO_INIT ${CMAKE_EXE_LINKER_FLAGS_DEBUG_INIT})
SET (CMAKE_MODULE_LINKER_FLAGS_INIT ${CMAKE_SHARED_LINKER_FLAGS_INIT})
SET (CMAKE_MODULE_LINKER_FLAGS_DEBUG_INIT ${CMAKE_SHARED_LINKER_FLAGS_DEBUG_INIT})
SET (CMAKE_MODULE_LINKER_FLAGS_RELWITHDEBINFO_INIT ${CMAKE_EXE_LINKER_FLAGS_RELWITHDEBINFO_INIT})

INCLUDE("${CMAKE_PLATFORM_ROOT_BIN}/CMakeIntelInformation.cmake" OPTIONAL)

IF(NOT _INTEL_XILINK_TEST_RUN)
  EXECUTE_PROCESS(COMMAND xilink /? 
    ERROR_VARIABLE _XILINK_ERR
    OUTPUT_VARIABLE _XILINK_HELP)
  IF(_XILINK_HELP MATCHES MANIFEST)
    SET(_INTEL_COMPILER_SUPPORTS_MANIFEST 1)
  ENDIF(_XILINK_HELP MATCHES MANIFEST)
  IF(NOT  EXISTS "${CMAKE_PLATFORM_ROOT_BIN}/CMakeIntelInformation.cmake")
    FILE(WRITE ${CMAKE_PLATFORM_ROOT_BIN}/CMakeIntelInformation.cmake 
      "
SET(_INTEL_XILINK_TEST_RUN 1)
SET(_INTEL_COMPILER_SUPPORTS_MANIFEST ${_INTEL_COMPILER_SUPPORTS_MANIFEST})
")
  ENDIF(NOT  EXISTS "${CMAKE_PLATFORM_ROOT_BIN}/CMakeIntelInformation.cmake")
ENDIF(NOT _INTEL_XILINK_TEST_RUN)

macro(__windows_compiler_intel lang)
  set(CMAKE_${lang}_COMPILE_OBJECT
    "<CMAKE_${lang}_COMPILER> ${CMAKE_START_TEMP_FILE} ${CMAKE_CL_NOLOGO}${_COMPILE_${lang}} /Fo<OBJECT> <DEFINES> <FLAGS> -c <SOURCE>${CMAKE_END_TEMP_FILE}")
  set(CMAKE_${lang}_CREATE_PREPROCESSED_SOURCE
    "<CMAKE_${lang}_COMPILER> > <PREPROCESSED_SOURCE> ${CMAKE_START_TEMP_FILE} ${CMAKE_CL_NOLOGO}${_COMPILE_${lang}} <DEFINES> <FLAGS> -E <SOURCE>${CMAKE_END_TEMP_FILE}")
  set(CMAKE_${lang}_USE_RESPONSE_FILE_FOR_OBJECTS 1)
  set(CMAKE_${lang}_CREATE_STATIC_LIBRARY  "lib ${CMAKE_CL_NOLOGO} <LINK_FLAGS> /out:<TARGET> <OBJECTS> ")
  set(CMAKE_${lang}_CREATE_SHARED_LIBRARY
    "xilink ${CMAKE_CL_NOLOGO} ${CMAKE_START_TEMP_FILE}  /out:<TARGET> /implib:<TARGET_IMPLIB> /pdb:<TARGET_PDB> /dll  <LINK_FLAGS> <OBJECTS> <LINK_LIBRARIES> ${CMAKE_END_TEMP_FILE}")
  set(CMAKE_${lang}_CREATE_SHARED_MODULE "${CMAKE_${lang}_CREATE_SHARED_LIBRARY}")
  set(CMAKE_${lang}_LINK_EXECUTABLE
    "<CMAKE_${lang}_COMPILER> ${CMAKE_CL_NOLOGO} ${CMAKE_START_TEMP_FILE} <FLAGS> <OBJECTS> /Fe<TARGET> -link /implib:<TARGET_IMPLIB> <CMAKE_${lang}_LINK_FLAGS> <LINK_FLAGS> <LINK_LIBRARIES>${CMAKE_END_TEMP_FILE}")
  set(CMAKE_${lang}_FLAGS_INIT "/DWIN32 /D_WINDOWS /W3 /Zm1000${_FLAGS_${lang}}")
  set(CMAKE_${lang}_FLAGS_DEBUG_INIT "/D_DEBUG /MDd /Zi /Od /GZ")
  set(CMAKE_${lang}_FLAGS_MINSIZEREL_INIT "/DNDEBUG /MD /O1")
  set(CMAKE_${lang}_FLAGS_RELEASE_INIT "/DNDEBUG /MD /O2")
  set(CMAKE_${lang}_FLAGS_RELWITHDEBINFO_INIT "/DNDEBUG /MD /Zi /O2")

  if(_INTEL_COMPILER_SUPPORTS_MANIFEST)
    SET(CMAKE_${lang}_LINK_EXECUTABLE
      "<CMAKE_COMMAND> -E vs_link_exe ${CMAKE_${lang}_LINK_EXECUTABLE}")
    SET(CMAKE_${lang}_CREATE_SHARED_LIBRARY
      "<CMAKE_COMMAND> -E vs_link_dll ${CMAKE_${lang}_CREATE_SHARED_LIBRARY}")
    SET(CMAKE_${lang}_CREATE_SHARED_MODULE
      "<CMAKE_COMMAND> -E vs_link_dll ${CMAKE_${lang}_CREATE_SHARED_MODULE}")
  endif()
endmacro()
