/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.google.common.collect.Lists;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.ArrayList;
import java.util.List;

public final class CheckUtils {
    private static final int BASE_8 = 8;
    private static final int BASE_10 = 10;
    private static final int BASE_16 = 16;

    private CheckUtils() {
        throw new UnsupportedOperationException();
    }

    public static boolean isEqualsMethod(DetailAST ast) {
        if (ast.getType() != 9) {
            return false;
        }
        DetailAST modifiers = ast.findFirstToken(5);
        if (modifiers.branchContains(64) || modifiers.branchContains(40)) {
            return false;
        }
        DetailAST nameNode = ast.findFirstToken(58);
        String name = nameNode.getText();
        if (!"equals".equals(name)) {
            return false;
        }
        DetailAST paramsNode = ast.findFirstToken(20);
        return paramsNode.getChildCount() == 1;
    }

    public static boolean isElseIf(DetailAST ast) {
        DetailAST parentAST = ast.getParent();
        return ast.getType() == 83 && (CheckUtils.isElse(parentAST) || CheckUtils.isElseWithCurlyBraces(parentAST));
    }

    private static boolean isElse(DetailAST ast) {
        return ast.getType() == 92;
    }

    private static boolean isElseWithCurlyBraces(DetailAST ast) {
        return ast.getType() == 7 && ast.getChildCount() == 2 && CheckUtils.isElse(ast.getParent());
    }

    public static FullIdent createFullType(DetailAST typeAST) {
        DetailAST arrayDeclAST = typeAST.findFirstToken(17);
        return CheckUtils.createFullTypeNoArrays(arrayDeclAST == null ? typeAST : arrayDeclAST);
    }

    private static FullIdent createFullTypeNoArrays(DetailAST typeAST) {
        return FullIdent.createFullIdent(typeAST.getFirstChild());
    }

    public static double parseDouble(String text, int type) {
        String txt = text.replaceAll("_", "");
        double result = 0.0;
        switch (type) {
            case 140: 
            case 142: {
                result = Double.parseDouble(txt);
                break;
            }
            case 137: 
            case 141: {
                int radix = 10;
                if (txt.startsWith("0x") || txt.startsWith("0X")) {
                    radix = 16;
                    txt = txt.substring(2);
                } else if (txt.charAt(0) == '0') {
                    radix = 8;
                    txt = txt.substring(1);
                }
                if (txt.endsWith("L") || txt.endsWith("l")) {
                    txt = txt.substring(0, txt.length() - 1);
                }
                if (txt.length() <= 0) break;
                if (type == 137) {
                    result = CheckUtils.parseInt(txt, radix);
                    break;
                }
                result = CheckUtils.parseLong(txt, radix);
                break;
            }
        }
        return result;
    }

    public static int parseInt(String text, int radix) {
        int result = 0;
        int max = text.length();
        for (int i = 0; i < max; ++i) {
            int digit = Character.digit(text.charAt(i), radix);
            result *= radix;
            result += digit;
        }
        return result;
    }

    public static long parseLong(String text, int radix) {
        long result = 0L;
        int max = text.length();
        for (int i = 0; i < max; ++i) {
            int digit = Character.digit(text.charAt(i), radix);
            result *= (long)radix;
            result += (long)digit;
        }
        return result;
    }

    public static double parseFloat(String text, int type) {
        return (float)CheckUtils.parseDouble(text, type);
    }

    public static DetailAST getFirstNode(DetailAST node) {
        DetailAST currentNode = node;
        for (DetailAST child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            DetailAST newNode = CheckUtils.getFirstNode(child);
            if (newNode.getLineNo() >= currentNode.getLineNo() && (newNode.getLineNo() != currentNode.getLineNo() || newNode.getColumnNo() >= currentNode.getColumnNo())) continue;
            currentNode = newNode;
        }
        return currentNode;
    }

    public static List<String> getTypeParameterNames(DetailAST node) {
        DetailAST typeParameters = node.findFirstToken(165);
        ArrayList<String> typeParanames = Lists.newArrayList();
        if (typeParameters != null) {
            DetailAST typeParam = typeParameters.findFirstToken(166);
            typeParanames.add(typeParam.findFirstToken(58).getText());
            for (DetailAST sibling = typeParam.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
                if (sibling.getType() != 166) continue;
                typeParanames.add(sibling.findFirstToken(58).getText());
            }
        }
        return typeParanames;
    }

    public static List<DetailAST> getTypeParameters(DetailAST node) {
        DetailAST typeParameters = node.findFirstToken(165);
        ArrayList<DetailAST> typeParams = Lists.newArrayList();
        if (typeParameters != null) {
            DetailAST typeParam = typeParameters.findFirstToken(166);
            typeParams.add(typeParam);
            for (DetailAST sibling = typeParam.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
                if (sibling.getType() != 166) continue;
                typeParams.add(sibling);
            }
        }
        return typeParams;
    }
}

