/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.filters;

import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.filters.IntFilter;
import com.puppycrawl.tools.checkstyle.filters.IntMatchFilter;
import com.puppycrawl.tools.checkstyle.filters.IntRangeFilter;
import java.util.Set;
import java.util.StringTokenizer;

class CSVFilter
implements IntFilter {
    private final Set<IntFilter> filters = Sets.newHashSet();

    public void addFilter(IntFilter filter) {
        this.filters.add(filter);
    }

    protected Set<IntFilter> getFilters() {
        return this.filters;
    }

    public CSVFilter(String pattern) throws NumberFormatException {
        StringTokenizer tokenizer = new StringTokenizer(pattern, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            int index = token.indexOf("-");
            if (index == -1) {
                int matchValue = Integer.parseInt(token);
                this.addFilter(new IntMatchFilter(matchValue));
                continue;
            }
            int lowerBound = Integer.parseInt(token.substring(0, index));
            int upperBound = Integer.parseInt(token.substring(index + 1));
            this.addFilter(new IntRangeFilter(lowerBound, upperBound));
        }
    }

    @Override
    public boolean accept(int intValue) {
        for (IntFilter filter : this.getFilters()) {
            if (!filter.accept(intValue)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.filters.toString();
    }

    public int hashCode() {
        return this.filters.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof CSVFilter) {
            CSVFilter other = (CSVFilter)object;
            return this.filters.equals(other.filters);
        }
        return false;
    }
}

