/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import antlr.CommonASTWithHiddenTokens;
import antlr.Token;
import antlr.collections.AST;
import com.puppycrawl.tools.checkstyle.api.TokenTypes;
import java.util.BitSet;

public final class DetailAST
extends CommonASTWithHiddenTokens {
    private static final long serialVersionUID = -2580884815577559874L;
    private static final int NOT_INITIALIZED = Integer.MIN_VALUE;
    private int lineNo = Integer.MIN_VALUE;
    private int columnNo = Integer.MIN_VALUE;
    private int childCount = Integer.MIN_VALUE;
    private DetailAST parent;
    private DetailAST previousSibling;
    private BitSet branchTokenTypes;

    @Override
    public void initialize(Token tok) {
        super.initialize(tok);
        this.lineNo = tok.getLine();
        this.columnNo = tok.getColumn() - 1;
    }

    @Override
    public void initialize(AST ast) {
        DetailAST da = (DetailAST)ast;
        this.setText(da.getText());
        this.setType(da.getType());
        this.lineNo = da.getLineNo();
        this.columnNo = da.getColumnNo();
        this.hiddenAfter = da.getHiddenAfter();
        this.hiddenBefore = da.getHiddenBefore();
    }

    @Override
    public void setFirstChild(AST ast) {
        this.childCount = Integer.MIN_VALUE;
        super.setFirstChild(ast);
        if (ast != null) {
            ((DetailAST)ast).setParent(this);
        }
    }

    @Override
    public void setNextSibling(AST ast) {
        super.setNextSibling(ast);
        if (ast != null && this.parent != null) {
            ((DetailAST)ast).setParent(this.parent);
        }
        if (ast != null) {
            ((DetailAST)ast).setPreviousSibling(this);
        }
    }

    public void addPreviousSibling(DetailAST ast) {
        if (ast != null) {
            ast.setParent(this.parent);
            DetailAST previousSibling = this.getPreviousSibling();
            if (previousSibling != null) {
                ast.setPreviousSibling(previousSibling);
                previousSibling.setNextSibling(ast);
            } else if (this.parent != null) {
                this.parent.setFirstChild(ast);
            }
            ast.setNextSibling(this);
            this.setPreviousSibling(ast);
        }
    }

    public void addNextSibling(DetailAST ast) {
        if (ast != null) {
            ast.setParent(this.parent);
            DetailAST nextSibling = this.getNextSibling();
            if (nextSibling != null) {
                ast.setNextSibling(nextSibling);
                nextSibling.setPreviousSibling(ast);
            }
            ast.setPreviousSibling(this);
            this.setNextSibling(ast);
        }
    }

    void setPreviousSibling(DetailAST ast) {
        this.previousSibling = ast;
    }

    @Override
    public void addChild(AST ast) {
        super.addChild(ast);
        if (ast != null) {
            ((DetailAST)ast).setParent(this);
            this.getFirstChild().setParent(this);
        }
    }

    public int getChildCount() {
        if (this.childCount == Integer.MIN_VALUE) {
            this.childCount = 0;
            for (AST child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
                ++this.childCount;
            }
        }
        return this.childCount;
    }

    void setParent(DetailAST parent) {
        this.parent = parent;
        DetailAST nextSibling = this.getNextSibling();
        if (nextSibling != null) {
            nextSibling.setParent(parent);
            nextSibling.setPreviousSibling(this);
        }
    }

    public DetailAST getParent() {
        return this.parent;
    }

    public int getLineNo() {
        if (this.lineNo == Integer.MIN_VALUE) {
            for (DetailAST child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (TokenTypes.isCommentType(child.getType())) {
                    continue;
                }
                return child.getLineNo();
            }
            for (DetailAST sibling = this.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
                if (TokenTypes.isCommentType(sibling.getType())) {
                    continue;
                }
                return sibling.getLineNo();
            }
        }
        return this.lineNo;
    }

    public void setLineNo(int lineNo) {
        this.lineNo = lineNo;
    }

    public int getColumnNo() {
        if (this.columnNo == Integer.MIN_VALUE) {
            for (DetailAST child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (TokenTypes.isCommentType(child.getType())) {
                    continue;
                }
                return child.getColumnNo();
            }
            for (DetailAST sibling = this.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
                if (TokenTypes.isCommentType(sibling.getType())) {
                    continue;
                }
                return sibling.getColumnNo();
            }
        }
        return this.columnNo;
    }

    public void setColumnNo(int columnNo) {
        this.columnNo = columnNo;
    }

    public DetailAST getLastChild() {
        DetailAST ast;
        for (ast = this.getFirstChild(); ast != null && ast.getNextSibling() != null; ast = ast.getNextSibling()) {
        }
        return ast;
    }

    private BitSet getBranchTokenTypes() {
        if (this.branchTokenTypes == null) {
            this.branchTokenTypes = new BitSet();
            this.branchTokenTypes.set(this.getType());
            for (DetailAST child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
                BitSet childTypes = child.getBranchTokenTypes();
                this.branchTokenTypes.or(childTypes);
            }
        }
        return this.branchTokenTypes;
    }

    public boolean branchContains(int type) {
        return this.getBranchTokenTypes().get(type);
    }

    public int getChildCount(int type) {
        int count = 0;
        for (AST i = this.getFirstChild(); i != null; i = i.getNextSibling()) {
            if (i.getType() != type) continue;
            ++count;
        }
        return count;
    }

    public DetailAST getPreviousSibling() {
        return this.previousSibling;
    }

    public DetailAST findFirstToken(int type) {
        DetailAST retVal = null;
        for (DetailAST i = this.getFirstChild(); i != null; i = i.getNextSibling()) {
            if (i.getType() != type) continue;
            retVal = i;
            break;
        }
        return retVal;
    }

    @Override
    public String toString() {
        return super.toString() + "[" + this.getLineNo() + "x" + this.getColumnNo() + "]";
    }

    @Override
    public DetailAST getNextSibling() {
        return (DetailAST)super.getNextSibling();
    }

    @Override
    public DetailAST getFirstChild() {
        return (DetailAST)super.getFirstChild();
    }
}

