/****************************************************************************
**
** Copyright (C) 2021 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the tools applications of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:GPL-EXCEPT$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/
#ifndef MANIFESTWRITER_H
#define MANIFESTWRITER_H

#include <QtCore/qlist.h>
#include <QtCore/qset.h>
#include <QtCore/qstring.h>

QT_BEGIN_NAMESPACE

class ExampleNode;
class QDocDatabase;
class QXmlStreamWriter;
class ManifestWriter
{
    struct ManifestMetaFilter
    {
        QSet<QString> m_names {};
        QSet<QString> m_attributes {};
        QSet<QString> m_tags {};
    };

public:
    ManifestWriter();
    void generateManifestFiles();
    void generateManifestFile(const QString &manifest, const QString &element);
    void readManifestMetaContent();
    QString retrieveExampleInstallationPath(const ExampleNode *example) const;

private:
    QSet<QString> m_tags {};
    QString m_manifestDir {};
    QString m_examplesPath {};
    QString m_outputDirectory {};
    QString m_project {};
    QDocDatabase *m_qdb { nullptr };
    QList<ManifestMetaFilter> m_manifestMetaContent {};

    void addModuleNameAsTag();
    void includeTagsAddedWithMetaCommand(const ExampleNode *example);
    void writeTagsElement(QXmlStreamWriter *writer);
    template <typename F>
    void processManifestMetaContent(const QString &fullName, F matchFunc);
};

QT_END_NAMESPACE

#endif // MANIFESTWRITER_H
