// Copyright 2017 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_BROWSER_API_MEDIA_PERCEPTION_PRIVATE_CONVERSION_UTILS_H_
#define EXTENSIONS_BROWSER_API_MEDIA_PERCEPTION_PRIVATE_CONVERSION_UTILS_H_

#include "chromeos/media_perception/media_perception.pb.h"
#include "extensions/common/api/media_perception_private.h"

namespace extensions {
namespace api {
namespace media_perception_private {

// Converts State proto messages to State objects (generated by the
// media_perception_private.idl).
State StateProtoToIdl(const mri::State& state);

// Converts State objects (generated by the media_perception_private.idl) to
// State proto messages.
mri::State StateIdlToProto(const State& state);

// Converts MediaPerception proto messages to MediaPerception objects
// (generated by the media_perception_private.idl).
MediaPerception MediaPerceptionProtoToIdl(
    const mri::MediaPerception& media_perception);

// Converts Diagnostics proto messages to Diagnostics objects (generated by the
// media_perception_private.idl).
Diagnostics DiagnosticsProtoToIdl(const mri::Diagnostics& diagnostics);

}  //  namespace media_perception_private
}  //  namespace api
}  //  namespace extensions

#endif  // EXTENSIONS_BROWSER_API_MEDIA_PERCEPTION_PRIVATE_CONVERSION_UTILS_H_
