/*
 * Copyright (C) 2004, 2005, 2006, 2008 Nikolas Zimmermann <zimmermann@kde.org>
 * Copyright (C) 2004, 2005, 2006 Rob Buis <buis@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef SVGRadialGradientElement_h
#define SVGRadialGradientElement_h

#include "core/SVGNames.h"
#include "core/svg/SVGAnimatedLength.h"
#include "core/svg/SVGGradientElement.h"
#include "platform/heap/Handle.h"

namespace blink {

struct RadialGradientAttributes;

class SVGRadialGradientElement final : public SVGGradientElement {
  DEFINE_WRAPPERTYPEINFO();

 public:
  DECLARE_NODE_FACTORY(SVGRadialGradientElement);

  bool CollectGradientAttributes(RadialGradientAttributes&);

  SVGAnimatedLength* cx() const { return cx_.Get(); }
  SVGAnimatedLength* cy() const { return cy_.Get(); }
  SVGAnimatedLength* r() const { return r_.Get(); }
  SVGAnimatedLength* fx() const { return fx_.Get(); }
  SVGAnimatedLength* fy() const { return fy_.Get(); }
  SVGAnimatedLength* fr() const { return fr_.Get(); }

  DECLARE_VIRTUAL_TRACE();

 private:
  explicit SVGRadialGradientElement(Document&);

  void SvgAttributeChanged(const QualifiedName&) override;

  LayoutObject* CreateLayoutObject(const ComputedStyle&) override;

  bool SelfHasRelativeLengths() const override;

  Member<SVGAnimatedLength> cx_;
  Member<SVGAnimatedLength> cy_;
  Member<SVGAnimatedLength> r_;
  Member<SVGAnimatedLength> fx_;
  Member<SVGAnimatedLength> fy_;
  Member<SVGAnimatedLength> fr_;
};

}  // namespace blink

#endif  // SVGRadialGradientElement_h
