/*
 * Copyright (C) 2012 Google Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE AND ITS CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE OR ITS CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef WebIDBMetadata_h
#define WebIDBMetadata_h

#include "public/platform/WebCommon.h"
#include "public/platform/WebString.h"
#include "public/platform/WebVector.h"
#include "public/platform/modules/indexeddb/WebIDBKeyPath.h"

namespace blink {

struct WebIDBMetadata {
  enum { kNoVersion = -1 };
  struct Index;
  struct ObjectStore;

  WebString name;
  long long version;
  long long id;
  long long max_object_store_id;
  WebVector<ObjectStore> object_stores;
  WebIDBMetadata() : version(kNoVersion) {}

  struct ObjectStore {
    WebString name;
    WebIDBKeyPath key_path;
    bool auto_increment;
    long long id;
    long long max_index_id;
    WebVector<Index> indexes;
    ObjectStore()
        : key_path(WebIDBKeyPath::CreateNull()), auto_increment(false) {}
  };

  struct Index {
    WebString name;
    WebIDBKeyPath key_path;
    bool unique;
    bool multi_entry;
    long long id;
    Index()
        : key_path(WebIDBKeyPath::CreateNull()),
          unique(false),
          multi_entry(false) {}
  };
};

}  // namespace blink

#endif  // WebIDBMetadata_h
