/* Generated by wayland-scanner 1.14.0 */

#ifndef REMOTE_SHELL_UNSTABLE_V1_SERVER_PROTOCOL_H
#define REMOTE_SHELL_UNSTABLE_V1_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_remote_shell_unstable_v1 The remote_shell_unstable_v1 protocol
 * Create remote desktop-style surfaces
 *
 * @section page_desc_remote_shell_unstable_v1 Description
 *
 * remote_shell allows clients to turn a wl_surface into a "real window"
 * which can be stacked and activated by the user.
 *
 * Warning! The protocol described in this file is experimental and backward
 * incompatible changes may be made. Backward compatible changes may be added
 * together with the corresponding interface version bump. Backward
 * incompatible changes are done by bumping the version number in the protocol
 * and interface names and resetting the interface version. Once the protocol
 * is to be declared stable, the 'z' prefix and the version number in the
 * protocol and interface names are removed and the interface version number is
 * reset.
 *
 * @section page_ifaces_remote_shell_unstable_v1 Interfaces
 * - @subpage page_iface_zcr_remote_shell_v1 - remote_shell
 * - @subpage page_iface_zcr_remote_surface_v1 - A desktop window
 * - @subpage page_iface_zcr_notification_surface_v1 - A notification window
 * @section page_copyright_remote_shell_unstable_v1 Copyright
 * <pre>
 *
 * Copyright 2016 The Chromium Authors.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct wl_surface;
struct zcr_notification_surface_v1;
struct zcr_remote_shell_v1;
struct zcr_remote_surface_v1;

/**
 * @page page_iface_zcr_remote_shell_v1 zcr_remote_shell_v1
 * @section page_iface_zcr_remote_shell_v1_desc Description
 *
 * The global interface that allows clients to turn a wl_surface into a
 * "real window" which is remotely managed but can be stacked, activated
 * and made fullscreen by the user.
 * @section page_iface_zcr_remote_shell_v1_api API
 * See @ref iface_zcr_remote_shell_v1.
 */
/**
 * @defgroup iface_zcr_remote_shell_v1 The zcr_remote_shell_v1 interface
 *
 * The global interface that allows clients to turn a wl_surface into a
 * "real window" which is remotely managed but can be stacked, activated
 * and made fullscreen by the user.
 */
extern const struct wl_interface zcr_remote_shell_v1_interface;
/**
 * @page page_iface_zcr_remote_surface_v1 zcr_remote_surface_v1
 * @section page_iface_zcr_remote_surface_v1_desc Description
 *
 * An interface that may be implemented by a wl_surface, for
 * implementations that provide a desktop-style user interface
 * and allows for remotely managed windows.
 *
 * It provides requests to treat surfaces like windows, allowing to set
 * properties like app id and geometry.
 *
 * The client must call wl_surface.commit on the corresponding wl_surface
 * for the remote_surface state to take effect.
 *
 * For a surface to be mapped by the compositor the client must have
 * committed both an remote_surface state and a buffer.
 * @section page_iface_zcr_remote_surface_v1_api API
 * See @ref iface_zcr_remote_surface_v1.
 */
/**
 * @defgroup iface_zcr_remote_surface_v1 The zcr_remote_surface_v1 interface
 *
 * An interface that may be implemented by a wl_surface, for
 * implementations that provide a desktop-style user interface
 * and allows for remotely managed windows.
 *
 * It provides requests to treat surfaces like windows, allowing to set
 * properties like app id and geometry.
 *
 * The client must call wl_surface.commit on the corresponding wl_surface
 * for the remote_surface state to take effect.
 *
 * For a surface to be mapped by the compositor the client must have
 * committed both an remote_surface state and a buffer.
 */
extern const struct wl_interface zcr_remote_surface_v1_interface;
/**
 * @page page_iface_zcr_notification_surface_v1 zcr_notification_surface_v1
 * @section page_iface_zcr_notification_surface_v1_desc Description
 *
 * An interface that may be implemented by a wl_surface to host
 * notification contents.
 * @section page_iface_zcr_notification_surface_v1_api API
 * See @ref iface_zcr_notification_surface_v1.
 */
/**
 * @defgroup iface_zcr_notification_surface_v1 The zcr_notification_surface_v1 interface
 *
 * An interface that may be implemented by a wl_surface to host
 * notification contents.
 */
extern const struct wl_interface zcr_notification_surface_v1_interface;

#ifndef ZCR_REMOTE_SHELL_V1_CONTAINER_ENUM
#define ZCR_REMOTE_SHELL_V1_CONTAINER_ENUM
/**
 * @ingroup iface_zcr_remote_shell_v1
 * containers for remote surfaces
 *
 * Determine how a remote surface should be stacked relative to other
 * shell surfaces.
 */
enum zcr_remote_shell_v1_container {
	/**
	 * default container
	 */
	ZCR_REMOTE_SHELL_V1_CONTAINER_DEFAULT = 1,
	/**
	 * system modal container
	 */
	ZCR_REMOTE_SHELL_V1_CONTAINER_OVERLAY = 2,
};
#endif /* ZCR_REMOTE_SHELL_V1_CONTAINER_ENUM */

#ifndef ZCR_REMOTE_SHELL_V1_STATE_TYPE_ENUM
#define ZCR_REMOTE_SHELL_V1_STATE_TYPE_ENUM
/**
 * @ingroup iface_zcr_remote_shell_v1
 * state types for remote surfaces
 *
 * Defines common show states for shell surfaces.
 */
enum zcr_remote_shell_v1_state_type {
	/**
	 * normal window state
	 */
	ZCR_REMOTE_SHELL_V1_STATE_TYPE_NORMAL = 1,
	/**
	 * minimized window state
	 */
	ZCR_REMOTE_SHELL_V1_STATE_TYPE_MINIMIZED = 2,
	/**
	 * maximized window state
	 */
	ZCR_REMOTE_SHELL_V1_STATE_TYPE_MAXIMIZED = 3,
	/**
	 * fullscreen window state
	 */
	ZCR_REMOTE_SHELL_V1_STATE_TYPE_FULLSCREEN = 4,
	/**
	 * pinned window state
	 */
	ZCR_REMOTE_SHELL_V1_STATE_TYPE_PINNED = 5,
	/**
	 * trusted pinned window state
	 */
	ZCR_REMOTE_SHELL_V1_STATE_TYPE_TRUSTED_PINNED = 6,
	/**
	 * moving window state
	 */
	ZCR_REMOTE_SHELL_V1_STATE_TYPE_MOVING = 7,
	/**
	 * resizing window state
	 */
	ZCR_REMOTE_SHELL_V1_STATE_TYPE_RESIZING = 8,
};
#endif /* ZCR_REMOTE_SHELL_V1_STATE_TYPE_ENUM */

#ifndef ZCR_REMOTE_SHELL_V1_ERROR_ENUM
#define ZCR_REMOTE_SHELL_V1_ERROR_ENUM
enum zcr_remote_shell_v1_error {
	/**
	 * given wl_surface has another role
	 */
	ZCR_REMOTE_SHELL_V1_ERROR_ROLE = 0,
	/**
	 * invalid notification key
	 */
	ZCR_REMOTE_SHELL_V1_ERROR_INVALID_NOTIFICATION_KEY = 1,
};
#endif /* ZCR_REMOTE_SHELL_V1_ERROR_ENUM */

#ifndef ZCR_REMOTE_SHELL_V1_LAYOUT_MODE_ENUM
#define ZCR_REMOTE_SHELL_V1_LAYOUT_MODE_ENUM
/**
 * @ingroup iface_zcr_remote_shell_v1
 * the layout mode
 *
 * Determine how a client should layout surfaces.
 */
enum zcr_remote_shell_v1_layout_mode {
	/**
	 * multiple windows
	 */
	ZCR_REMOTE_SHELL_V1_LAYOUT_MODE_WINDOWED = 1,
	/**
	 * restricted mode for tablet
	 */
	ZCR_REMOTE_SHELL_V1_LAYOUT_MODE_TABLET = 2,
};
#endif /* ZCR_REMOTE_SHELL_V1_LAYOUT_MODE_ENUM */

/**
 * @ingroup iface_zcr_remote_shell_v1
 * @struct zcr_remote_shell_v1_interface
 */
struct zcr_remote_shell_v1_interface {
	/**
	 * destroy remote_shell
	 *
	 * Destroy this remote_shell object.
	 *
	 * Destroying a bound remote_shell object while there are surfaces
	 * still alive created by this remote_shell object instance is
	 * illegal and will result in a protocol error.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * create a remote shell surface from a surface
	 *
	 * This creates an remote_surface for the given surface and gives
	 * it the remote_surface role. A wl_surface can only be given a
	 * remote_surface role once. If get_remote_surface is called with a
	 * wl_surface that already has an active remote_surface associated
	 * with it, or if it had any other role, an error is raised.
	 *
	 * See the documentation of remote_surface for more details about
	 * what an remote_surface is and how it is used.
	 */
	void (*get_remote_surface)(struct wl_client *client,
				   struct wl_resource *resource,
				   uint32_t id,
				   struct wl_resource *surface,
				   uint32_t container);
	/**
	 * create a notification surface from a surface
	 *
	 * Creates a notification_surface for the given surface, gives it
	 * the notification_surface role and associated it with a
	 * notification id.
	 */
	void (*get_notification_surface)(struct wl_client *client,
					 struct wl_resource *resource,
					 uint32_t id,
					 struct wl_resource *surface,
					 const char *notification_key);
};

#define ZCR_REMOTE_SHELL_V1_ACTIVATED 0
#define ZCR_REMOTE_SHELL_V1_CONFIGURATION_CHANGED 1
#define ZCR_REMOTE_SHELL_V1_WORKSPACE 2
#define ZCR_REMOTE_SHELL_V1_CONFIGURE 3
#define ZCR_REMOTE_SHELL_V1_DEFAULT_DEVICE_SCALE_FACTOR 4

/**
 * @ingroup iface_zcr_remote_shell_v1
 */
#define ZCR_REMOTE_SHELL_V1_ACTIVATED_SINCE_VERSION 1
/**
 * @ingroup iface_zcr_remote_shell_v1
 */
#define ZCR_REMOTE_SHELL_V1_CONFIGURATION_CHANGED_SINCE_VERSION 1
/**
 * @ingroup iface_zcr_remote_shell_v1
 */
#define ZCR_REMOTE_SHELL_V1_WORKSPACE_SINCE_VERSION 5
/**
 * @ingroup iface_zcr_remote_shell_v1
 */
#define ZCR_REMOTE_SHELL_V1_CONFIGURE_SINCE_VERSION 5
/**
 * @ingroup iface_zcr_remote_shell_v1
 */
#define ZCR_REMOTE_SHELL_V1_DEFAULT_DEVICE_SCALE_FACTOR_SINCE_VERSION 8

/**
 * @ingroup iface_zcr_remote_shell_v1
 */
#define ZCR_REMOTE_SHELL_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_zcr_remote_shell_v1
 */
#define ZCR_REMOTE_SHELL_V1_GET_REMOTE_SURFACE_SINCE_VERSION 1
/**
 * @ingroup iface_zcr_remote_shell_v1
 */
#define ZCR_REMOTE_SHELL_V1_GET_NOTIFICATION_SURFACE_SINCE_VERSION 1

/**
 * @ingroup iface_zcr_remote_shell_v1
 * Sends an activated event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zcr_remote_shell_v1_send_activated(struct wl_resource *resource_, struct wl_resource *gained_active, struct wl_resource *lost_active)
{
	wl_resource_post_event(resource_, ZCR_REMOTE_SHELL_V1_ACTIVATED, gained_active, lost_active);
}

/**
 * @ingroup iface_zcr_remote_shell_v1
 * Sends an configuration_changed event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zcr_remote_shell_v1_send_configuration_changed(struct wl_resource *resource_, int32_t width, int32_t height, int32_t transform, wl_fixed_t scale_factor, int32_t work_area_inset_left, int32_t work_area_inset_top, int32_t work_area_inset_right, int32_t work_area_inset_bottom, uint32_t layout_mode)
{
	wl_resource_post_event(resource_, ZCR_REMOTE_SHELL_V1_CONFIGURATION_CHANGED, width, height, transform, scale_factor, work_area_inset_left, work_area_inset_top, work_area_inset_right, work_area_inset_bottom, layout_mode);
}

/**
 * @ingroup iface_zcr_remote_shell_v1
 * Sends an workspace event to the client owning the resource.
 * @param resource_ The client's resource
 * @param is_internal 1 if screen is built-in
 */
static inline void
zcr_remote_shell_v1_send_workspace(struct wl_resource *resource_, uint32_t id_hi, uint32_t id_lo, int32_t x, int32_t y, int32_t width, int32_t height, int32_t inset_left, int32_t inset_top, int32_t inset_right, int32_t inset_bottom, int32_t transform, wl_fixed_t scale_factor, uint32_t is_internal)
{
	wl_resource_post_event(resource_, ZCR_REMOTE_SHELL_V1_WORKSPACE, id_hi, id_lo, x, y, width, height, inset_left, inset_top, inset_right, inset_bottom, transform, scale_factor, is_internal);
}

/**
 * @ingroup iface_zcr_remote_shell_v1
 * Sends an configure event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zcr_remote_shell_v1_send_configure(struct wl_resource *resource_, uint32_t layout_mode)
{
	wl_resource_post_event(resource_, ZCR_REMOTE_SHELL_V1_CONFIGURE, layout_mode);
}

/**
 * @ingroup iface_zcr_remote_shell_v1
 * Sends an default_device_scale_factor event to the client owning the resource.
 * @param resource_ The client's resource
 * @param scale DP to pixels ratio, in 8.24 fixed point format
 */
static inline void
zcr_remote_shell_v1_send_default_device_scale_factor(struct wl_resource *resource_, int32_t scale)
{
	wl_resource_post_event(resource_, ZCR_REMOTE_SHELL_V1_DEFAULT_DEVICE_SCALE_FACTOR, scale);
}

#ifndef ZCR_REMOTE_SURFACE_V1_SYSTEMUI_VISIBILITY_STATE_ENUM
#define ZCR_REMOTE_SURFACE_V1_SYSTEMUI_VISIBILITY_STATE_ENUM
/**
 * @ingroup iface_zcr_remote_surface_v1
 * systemui visibility behavior
 *
 * Determine the visibility behavior of the system UI.
 */
enum zcr_remote_surface_v1_systemui_visibility_state {
	/**
	 * system ui is visible
	 */
	ZCR_REMOTE_SURFACE_V1_SYSTEMUI_VISIBILITY_STATE_VISIBLE = 1,
	/**
	 * system ui autohides and is not sticky
	 */
	ZCR_REMOTE_SURFACE_V1_SYSTEMUI_VISIBILITY_STATE_AUTOHIDE_NON_STICKY = 2,
	/**
	 * system ui autohides and is sticky
	 */
	ZCR_REMOTE_SURFACE_V1_SYSTEMUI_VISIBILITY_STATE_AUTOHIDE_STICKY = 3,
};
#endif /* ZCR_REMOTE_SURFACE_V1_SYSTEMUI_VISIBILITY_STATE_ENUM */

#ifndef ZCR_REMOTE_SURFACE_V1_ORIENTATION_ENUM
#define ZCR_REMOTE_SURFACE_V1_ORIENTATION_ENUM
/**
 * @ingroup iface_zcr_remote_surface_v1
 * window orientation
 *
 * The orientation of the window.
 */
enum zcr_remote_surface_v1_orientation {
	/**
	 * portrait
	 */
	ZCR_REMOTE_SURFACE_V1_ORIENTATION_PORTRAIT = 1,
	/**
	 * landscape
	 */
	ZCR_REMOTE_SURFACE_V1_ORIENTATION_LANDSCAPE = 2,
};
#endif /* ZCR_REMOTE_SURFACE_V1_ORIENTATION_ENUM */

#ifndef ZCR_REMOTE_SURFACE_V1_WINDOW_TYPE_ENUM
#define ZCR_REMOTE_SURFACE_V1_WINDOW_TYPE_ENUM
/**
 * @ingroup iface_zcr_remote_surface_v1
 * window type
 *
 * The type of the window.
 */
enum zcr_remote_surface_v1_window_type {
	/**
	 * normal app window
	 */
	ZCR_REMOTE_SURFACE_V1_WINDOW_TYPE_NORMAL = 1,
	/**
	 * window is treated as systemui
	 */
	ZCR_REMOTE_SURFACE_V1_WINDOW_TYPE_SYSTEM_UI = 2,
};
#endif /* ZCR_REMOTE_SURFACE_V1_WINDOW_TYPE_ENUM */

#ifndef ZCR_REMOTE_SURFACE_V1_BOUNDS_CHANGE_REASON_ENUM
#define ZCR_REMOTE_SURFACE_V1_BOUNDS_CHANGE_REASON_ENUM
/**
 * @ingroup iface_zcr_remote_surface_v1
 * bounds_change_reason
 *
 * Specifies the cause of the window bounds change event.
 */
enum zcr_remote_surface_v1_bounds_change_reason {
	/**
	 * the window is being moved by drag operation
	 */
	ZCR_REMOTE_SURFACE_V1_BOUNDS_CHANGE_REASON_DRAG_MOVE = 1,
	/**
	 * the window is being resized by drag operation.
	 */
	ZCR_REMOTE_SURFACE_V1_BOUNDS_CHANGE_REASON_DRAG_RESIZE = 2,
	/**
	 * the window is resized to left snapped state
	 */
	ZCR_REMOTE_SURFACE_V1_BOUNDS_CHANGE_REASON_SNAP_TO_LEFT = 3,
	/**
	 * the window is resized to right snapped state
	 */
	ZCR_REMOTE_SURFACE_V1_BOUNDS_CHANGE_REASON_SNAP_TO_RIGHT = 4,
	/**
	 * the window bounds is moved due to other WM operations
	 */
	ZCR_REMOTE_SURFACE_V1_BOUNDS_CHANGE_REASON_MOVE = 5,
	/**
	 * the window bounds is reiszed due to other WM operations
	 */
	ZCR_REMOTE_SURFACE_V1_BOUNDS_CHANGE_REASON_RESIZE = 6,
};
#endif /* ZCR_REMOTE_SURFACE_V1_BOUNDS_CHANGE_REASON_ENUM */

#ifndef ZCR_REMOTE_SURFACE_V1_RESIZE_DIRECTION_ENUM
#define ZCR_REMOTE_SURFACE_V1_RESIZE_DIRECTION_ENUM
/**
 * @ingroup iface_zcr_remote_surface_v1
 * resize direction
 *
 * The resize direction for drag operation
 */
enum zcr_remote_surface_v1_resize_direction {
	/**
	 * move only, no resize
	 */
	ZCR_REMOTE_SURFACE_V1_RESIZE_DIRECTION_NONE = 0,
	/**
	 * resize to the left
	 */
	ZCR_REMOTE_SURFACE_V1_RESIZE_DIRECTION_LEFT = 1,
	/**
	 * resize to the top left
	 */
	ZCR_REMOTE_SURFACE_V1_RESIZE_DIRECTION_TOPLEFT = 2,
	/**
	 * resize to the top
	 */
	ZCR_REMOTE_SURFACE_V1_RESIZE_DIRECTION_TOP = 3,
	/**
	 * resize to the top right
	 */
	ZCR_REMOTE_SURFACE_V1_RESIZE_DIRECTION_TOPRIGHT = 4,
	/**
	 * resize to the right
	 */
	ZCR_REMOTE_SURFACE_V1_RESIZE_DIRECTION_RIGHT = 5,
	/**
	 * resize to the buttom right
	 */
	ZCR_REMOTE_SURFACE_V1_RESIZE_DIRECTION_BOTTOMRIGHT = 6,
	/**
	 * resize to the bottom
	 */
	ZCR_REMOTE_SURFACE_V1_RESIZE_DIRECTION_BOTTOM = 7,
	/**
	 * resize to the bottom left
	 */
	ZCR_REMOTE_SURFACE_V1_RESIZE_DIRECTION_BOTTOMLEFT = 8,
};
#endif /* ZCR_REMOTE_SURFACE_V1_RESIZE_DIRECTION_ENUM */

/**
 * @ingroup iface_zcr_remote_surface_v1
 * @struct zcr_remote_surface_v1_interface
 */
struct zcr_remote_surface_v1_interface {
	/**
	 * Destroy the remote_surface
	 *
	 * Unmap and destroy the window. The window will be effectively
	 * hidden from the user's point of view, and all state will be
	 * lost.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * set application ID
	 *
	 * Set an application identifier for the surface.
	 */
	void (*set_app_id)(struct wl_client *client,
			   struct wl_resource *resource,
			   const char *app_id);
	/**
	 * set the new window geometry
	 *
	 * The window geometry of a window is its "visible bounds" from
	 * the user's perspective. Client-side decorations often have
	 * invisible portions like drop-shadows which should be ignored for
	 * the purposes of aligning, placing and constraining windows.
	 *
	 * The window geometry is double buffered, and will be applied at
	 * the time wl_surface.commit of the corresponding wl_surface is
	 * called.
	 *
	 * Once the window geometry of the surface is set once, it is not
	 * possible to unset it, and it will remain the same until
	 * set_window_geometry is called again, even if a new subsurface or
	 * buffer is attached.
	 *
	 * If never set, the value is the full bounds of the output. This
	 * updates dynamically on every commit.
	 *
	 * The arguments are given in the output coordinate space.
	 *
	 * The width and height must be greater than zero.
	 */
	void (*set_window_geometry)(struct wl_client *client,
				    struct wl_resource *resource,
				    int32_t x,
				    int32_t y,
				    int32_t width,
				    int32_t height);
	/**
	 * set scale
	 *
	 * Set a scale factor that will be applied to surface and all
	 * descendants.
	 */
	void (*set_scale)(struct wl_client *client,
			  struct wl_resource *resource,
			  wl_fixed_t scale);
	/**
	 * set a rectangular shadow
	 *
	 * [Deprecated] Request that surface needs a rectangular shadow.
	 *
	 * This is only a request that the surface should have a
	 * rectangular shadow. The compositor may choose to ignore this
	 * request.
	 *
	 * The arguments are given in the output coordinate space and
	 * specifies the inner bounds of the shadow.
	 *
	 * The arguments are given in the output coordinate space.
	 * Specifying zero width and height will disable the shadow.
	 */
	void (*set_rectangular_shadow)(struct wl_client *client,
				       struct wl_resource *resource,
				       int32_t x,
				       int32_t y,
				       int32_t width,
				       int32_t height);
	/**
	 * suggests the window's background opacity
	 *
	 * [Deprecated] Suggests the window's background opacity when the
	 * shadow is requested.
	 */
	void (*set_rectangular_shadow_background_opacity)(struct wl_client *client,
							  struct wl_resource *resource,
							  wl_fixed_t opacity);
	/**
	 * set surface title
	 *
	 * Set a short title for the surface.
	 *
	 * This string may be used to identify the surface in a task bar,
	 * window list, or other user interface elements provided by the
	 * compositor.
	 *
	 * The string must be encoded in UTF-8.
	 */
	void (*set_title)(struct wl_client *client,
			  struct wl_resource *resource,
			  const char *title);
	/**
	 * set top inset for surface
	 *
	 * Set distance from the top of the surface to the contents.
	 *
	 * This distance typically represents the size of the window
	 * caption.
	 */
	void (*set_top_inset)(struct wl_client *client,
			      struct wl_resource *resource,
			      int32_t height);
	/**
	 * make the surface active
	 *
	 * Make the surface active and bring it to the front.
	 * @param serial the serial of the user event
	 */
	void (*activate)(struct wl_client *client,
			 struct wl_resource *resource,
			 uint32_t serial);
	/**
	 * maximize
	 *
	 * Request that surface is maximized. The window geometry will be
	 * updated to whatever the compositor finds appropriate for a
	 * maximized window.
	 *
	 * This is only a request that the window should be maximized. The
	 * compositor may choose to ignore this request. The client should
	 * listen to set_maximized events to determine if the window was
	 * maximized or not.
	 */
	void (*maximize)(struct wl_client *client,
			 struct wl_resource *resource);
	/**
	 * minimize
	 *
	 * Request that surface is minimized.
	 *
	 * This is only a request that the window should be minimized. The
	 * compositor may choose to ignore this request. The client should
	 * listen to set_minimized events to determine if the window was
	 * minimized or not.
	 */
	void (*minimize)(struct wl_client *client,
			 struct wl_resource *resource);
	/**
	 * restore
	 *
	 * Request that surface is restored. This restores the window
	 * geometry to what it was before the window was minimized,
	 * maximized or made fullscreen.
	 *
	 * This is only a request that the window should be restored. The
	 * compositor may choose to ignore this request. The client should
	 * listen to unset_maximized, unset_minimize and unset_fullscreen
	 * events to determine if the window was restored or not.
	 */
	void (*restore)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * fullscreen
	 *
	 * Request that surface is made fullscreen.
	 *
	 * This is only a request that the window should be made
	 * fullscreen. The compositor may choose to ignore this request.
	 * The client should listen to set_fullscreen events to determine
	 * if the window was made fullscreen or not.
	 */
	void (*fullscreen)(struct wl_client *client,
			   struct wl_resource *resource);
	/**
	 * unfullscreen
	 *
	 * Request that surface is made unfullscreen.
	 *
	 * This is only a request that the window should be made
	 * unfullscreen. The compositor may choose to ignore this request.
	 * The client should listen to unset_fullscreen events to determine
	 * if the window was made unfullscreen or not.
	 */
	void (*unfullscreen)(struct wl_client *client,
			     struct wl_resource *resource);
	/**
	 * pin
	 *
	 * Request that surface is pinned.
	 *
	 * This is only a request that the window should be pinned. The
	 * compositor may choose to ignore this request. The client should
	 * listen to state_changed events to determine if the window was
	 * pinned or not. If trusted flag is non-zero, the app can prevent
	 * users from exiting the pinned mode.
	 */
	void (*pin)(struct wl_client *client,
		    struct wl_resource *resource,
		    int32_t trusted);
	/**
	 * unpin
	 *
	 * Request that surface is unpinned.
	 *
	 * This is only a request that the window should be unpinned. The
	 * compositor may choose to ignore this request. The client should
	 * listen to unset_pinned events to determine if the window was
	 * unpinned or not.
	 */
	void (*unpin)(struct wl_client *client,
		      struct wl_resource *resource);
	/**
	 * suggests a re-layout of remote shell input area
	 *
	 * Suggests a surface should become system modal.
	 */
	void (*set_system_modal)(struct wl_client *client,
				 struct wl_resource *resource);
	/**
	 * suggests a re-layout of remote shell input area
	 *
	 * Suggests a surface should become non system modal.
	 */
	void (*unset_system_modal)(struct wl_client *client,
				   struct wl_resource *resource);
	/**
	 * set a rectangular shadow
	 *
	 * Request that surface needs a rectangular shadow.
	 *
	 * This is only a request that the surface should have a
	 * rectangular shadow. The compositor may choose to ignore this
	 * request.
	 *
	 * The arguments are given in the remote surface coordinate space
	 * and specifies inner bounds of the shadow. Specifying zero width
	 * and height will disable the shadow.
	 * @since 2
	 */
	void (*set_rectangular_surface_shadow)(struct wl_client *client,
					       struct wl_resource *resource,
					       int32_t x,
					       int32_t y,
					       int32_t width,
					       int32_t height);
	/**
	 * requests the system ui visibility behavior for the surface
	 *
	 * Requests how the surface will change the visibility of the
	 * system UI when it is made active.
	 * @since 3
	 */
	void (*set_systemui_visibility)(struct wl_client *client,
					struct wl_resource *resource,
					uint32_t visibility);
	/**
	 * set always on top
	 *
	 * Request that surface is made to be always on top.
	 *
	 * This is only a request that the window should be always on top.
	 * The compositor may choose to ignore this request.
	 * @since 4
	 */
	void (*set_always_on_top)(struct wl_client *client,
				  struct wl_resource *resource);
	/**
	 * unset always on top
	 *
	 * Request that surface is made to be not always on top.
	 *
	 * This is only a request that the window should be not always on
	 * top. The compositor may choose to ignore this request.
	 * @since 4
	 */
	void (*unset_always_on_top)(struct wl_client *client,
				    struct wl_resource *resource);
	/**
	 * ack a configure event
	 *
	 * When a configure event is received, if a client commits the
	 * surface in response to the configure event, then the client must
	 * make an ack_configure request sometime before the commit
	 * request, passing along the serial of the configure event.
	 *
	 * For instance, the compositor might use this information during
	 * display configuration to change its coordinate space for
	 * set_window_geometry requests only when the client has switched
	 * to the new coordinate space.
	 *
	 * If the client receives multiple configure events before it can
	 * respond to one, it only has to ack the last configure event.
	 *
	 * A client is not required to commit immediately after sending an
	 * ack_configure request - it may even ack_configure several times
	 * before its next surface commit.
	 *
	 * A client may send multiple ack_configure requests before
	 * committing, but only the last request sent before a commit
	 * indicates which configure event the client really is responding
	 * to.
	 * @param serial the serial from the configure event
	 * @since 5
	 */
	void (*ack_configure)(struct wl_client *client,
			      struct wl_resource *resource,
			      uint32_t serial);
	/**
	 * start an interactive move
	 *
	 * Start an interactive, user-driven move of the surface.
	 *
	 * The compositor responds to this request with a configure event
	 * that transitions to the "moving" state. The client must only
	 * initiate motion after acknowledging the state change. The
	 * compositor can assume that subsequent set_window_geometry
	 * requests are position updates until the next state transition is
	 * acknowledged.
	 *
	 * The compositor may ignore move requests depending on the state
	 * of the surface, e.g. fullscreen or maximized.
	 * @since 5
	 */
	void (*move)(struct wl_client *client,
		     struct wl_resource *resource);
	/**
	 * set orientation
	 *
	 * Set an orientation for the surface.
	 * @since 6
	 */
	void (*set_orientation)(struct wl_client *client,
				struct wl_resource *resource,
				int32_t orientation);
	/**
	 * set the type of the window
	 *
	 * Set the type of window. This is only a hint to the compositor
	 * and the compositor is free to ignore it.
	 * @param type type of the window
	 * @since 7
	 */
	void (*set_window_type)(struct wl_client *client,
				struct wl_resource *resource,
				uint32_t type);
	/**
	 * start an interactive resize
	 *
	 * Start an interactive, user-driven resize of the surface.
	 *
	 * The compositor responds to this request with a configure event
	 * that transitions to the "resizing" state. The client must only
	 * initiate resizing after acknowledging the state change. The
	 * compositor can assume that subsequent set_window_geometry
	 * requests are resizes until the next state transition is
	 * acknowledged.
	 *
	 * The compositor may ignore resize requests depending on the state
	 * of the surface, e.g. fullscreen or maximized.
	 * @since 9
	 */
	void (*resize)(struct wl_client *client,
		       struct wl_resource *resource);
	/**
	 * expand input region for resizing
	 *
	 * Expand input region of surface with resize outset.
	 *
	 * The compositor clips the input region of each surface to its
	 * bounds, unless the client requests a resize outset. In that
	 * case, the input region of the root surface is expanded to allow
	 * for some leeway around visible bounds when starting a
	 * user-driven resize.
	 * @since 9
	 */
	void (*set_resize_outset)(struct wl_client *client,
				  struct wl_resource *resource,
				  int32_t outset);
	/**
	 * start an interactive move
	 *
	 * Request an interactive, user-driven move of the surface. "x"
	 * and "y" specifies the starting point of the pointer device that
	 * initiated the move.
	 *
	 * The compositor responds to this request with a drag_started
	 * event with "none" direction. Please see drag_started event for
	 * more details.
	 *
	 * The compositor may ignore move requests depending on the state
	 * of the surface, e.g. fullscreen or maximized.
	 * @since 10
	 */
	void (*start_move)(struct wl_client *client,
			   struct wl_resource *resource,
			   int32_t x,
			   int32_t y);
	/**
	 * set can_maximize
	 *
	 * Request that surface can be in maximzied state.
	 * @since 10
	 */
	void (*set_can_maximize)(struct wl_client *client,
				 struct wl_resource *resource);
	/**
	 * unset can_maximize
	 *
	 * Request that surface can not be in maximzied state.
	 * @since 10
	 */
	void (*unset_can_maximize)(struct wl_client *client,
				   struct wl_resource *resource);
	/**
	 * set the minimum size
	 *
	 * Set a minimum size of the surface.
	 *
	 * Values set in this way are double-buffered. They will get
	 * applied on the next commit.
	 * @since 10
	 */
	void (*set_min_size)(struct wl_client *client,
			     struct wl_resource *resource,
			     int32_t width,
			     int32_t height);
	/**
	 * set the maximum size
	 *
	 * Set a maximum size of the surface.
	 *
	 * Values set in this way are double-buffered. They will get
	 * applied on the next commit.
	 *
	 * Setting the same size as minimum size makes the surface
	 * unresizable.
	 * @since 10
	 */
	void (*set_max_size)(struct wl_client *client,
			     struct wl_resource *resource,
			     int32_t width,
			     int32_t height);
};

#define ZCR_REMOTE_SURFACE_V1_CLOSE 0
#define ZCR_REMOTE_SURFACE_V1_STATE_TYPE_CHANGED 1
#define ZCR_REMOTE_SURFACE_V1_CONFIGURE 2
#define ZCR_REMOTE_SURFACE_V1_WINDOW_GEOMETRY_CHANGED 3
#define ZCR_REMOTE_SURFACE_V1_BOUNDS_CHANGED 4
#define ZCR_REMOTE_SURFACE_V1_DRAG_STARTED 5
#define ZCR_REMOTE_SURFACE_V1_DRAG_FINISHED 6

/**
 * @ingroup iface_zcr_remote_surface_v1
 */
#define ZCR_REMOTE_SURFACE_V1_CLOSE_SINCE_VERSION 1
/**
 * @ingroup iface_zcr_remote_surface_v1
 */
#define ZCR_REMOTE_SURFACE_V1_STATE_TYPE_CHANGED_SINCE_VERSION 1
/**
 * @ingroup iface_zcr_remote_surface_v1
 */
#define ZCR_REMOTE_SURFACE_V1_CONFIGURE_SINCE_VERSION 5
/**
 * @ingroup iface_zcr_remote_surface_v1
 */
#define ZCR_REMOTE_SURFACE_V1_WINDOW_GEOMETRY_CHANGED_SINCE_VERSION 9
/**
 * @ingroup iface_zcr_remote_surface_v1
 */
#define ZCR_REMOTE_SURFACE_V1_BOUNDS_CHANGED_SINCE_VERSION 10
/**
 * @ingroup iface_zcr_remote_surface_v1
 */
#define ZCR_REMOTE_SURFACE_V1_DRAG_STARTED_SINCE_VERSION 10
/**
 * @ingroup iface_zcr_remote_surface_v1
 */
#define ZCR_REMOTE_SURFACE_V1_DRAG_FINISHED_SINCE_VERSION 10

/**
 * @ingroup iface_zcr_remote_surface_v1
 */
#define ZCR_REMOTE_SURFACE_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_zcr_remote_surface_v1
 */
#define ZCR_REMOTE_SURFACE_V1_SET_APP_ID_SINCE_VERSION 1
/**
 * @ingroup iface_zcr_remote_surface_v1
 */
#define ZCR_REMOTE_SURFACE_V1_SET_WINDOW_GEOMETRY_SINCE_VERSION 1
/**
 * @ingroup iface_zcr_remote_surface_v1
 */
#define ZCR_REMOTE_SURFACE_V1_SET_SCALE_SINCE_VERSION 1
/**
 * @ingroup iface_zcr_remote_surface_v1
 */
#define ZCR_REMOTE_SURFACE_V1_SET_RECTANGULAR_SHADOW_SINCE_VERSION 1
/**
 * @ingroup iface_zcr_remote_surface_v1
 */
#define ZCR_REMOTE_SURFACE_V1_SET_RECTANGULAR_SHADOW_BACKGROUND_OPACITY_SINCE_VERSION 1
/**
 * @ingroup iface_zcr_remote_surface_v1
 */
#define ZCR_REMOTE_SURFACE_V1_SET_TITLE_SINCE_VERSION 1
/**
 * @ingroup iface_zcr_remote_surface_v1
 */
#define ZCR_REMOTE_SURFACE_V1_SET_TOP_INSET_SINCE_VERSION 1
/**
 * @ingroup iface_zcr_remote_surface_v1
 */
#define ZCR_REMOTE_SURFACE_V1_ACTIVATE_SINCE_VERSION 1
/**
 * @ingroup iface_zcr_remote_surface_v1
 */
#define ZCR_REMOTE_SURFACE_V1_MAXIMIZE_SINCE_VERSION 1
/**
 * @ingroup iface_zcr_remote_surface_v1
 */
#define ZCR_REMOTE_SURFACE_V1_MINIMIZE_SINCE_VERSION 1
/**
 * @ingroup iface_zcr_remote_surface_v1
 */
#define ZCR_REMOTE_SURFACE_V1_RESTORE_SINCE_VERSION 1
/**
 * @ingroup iface_zcr_remote_surface_v1
 */
#define ZCR_REMOTE_SURFACE_V1_FULLSCREEN_SINCE_VERSION 1
/**
 * @ingroup iface_zcr_remote_surface_v1
 */
#define ZCR_REMOTE_SURFACE_V1_UNFULLSCREEN_SINCE_VERSION 1
/**
 * @ingroup iface_zcr_remote_surface_v1
 */
#define ZCR_REMOTE_SURFACE_V1_PIN_SINCE_VERSION 1
/**
 * @ingroup iface_zcr_remote_surface_v1
 */
#define ZCR_REMOTE_SURFACE_V1_UNPIN_SINCE_VERSION 1
/**
 * @ingroup iface_zcr_remote_surface_v1
 */
#define ZCR_REMOTE_SURFACE_V1_SET_SYSTEM_MODAL_SINCE_VERSION 1
/**
 * @ingroup iface_zcr_remote_surface_v1
 */
#define ZCR_REMOTE_SURFACE_V1_UNSET_SYSTEM_MODAL_SINCE_VERSION 1
/**
 * @ingroup iface_zcr_remote_surface_v1
 */
#define ZCR_REMOTE_SURFACE_V1_SET_RECTANGULAR_SURFACE_SHADOW_SINCE_VERSION 2
/**
 * @ingroup iface_zcr_remote_surface_v1
 */
#define ZCR_REMOTE_SURFACE_V1_SET_SYSTEMUI_VISIBILITY_SINCE_VERSION 3
/**
 * @ingroup iface_zcr_remote_surface_v1
 */
#define ZCR_REMOTE_SURFACE_V1_SET_ALWAYS_ON_TOP_SINCE_VERSION 4
/**
 * @ingroup iface_zcr_remote_surface_v1
 */
#define ZCR_REMOTE_SURFACE_V1_UNSET_ALWAYS_ON_TOP_SINCE_VERSION 4
/**
 * @ingroup iface_zcr_remote_surface_v1
 */
#define ZCR_REMOTE_SURFACE_V1_ACK_CONFIGURE_SINCE_VERSION 5
/**
 * @ingroup iface_zcr_remote_surface_v1
 */
#define ZCR_REMOTE_SURFACE_V1_MOVE_SINCE_VERSION 5
/**
 * @ingroup iface_zcr_remote_surface_v1
 */
#define ZCR_REMOTE_SURFACE_V1_SET_ORIENTATION_SINCE_VERSION 6
/**
 * @ingroup iface_zcr_remote_surface_v1
 */
#define ZCR_REMOTE_SURFACE_V1_SET_WINDOW_TYPE_SINCE_VERSION 7
/**
 * @ingroup iface_zcr_remote_surface_v1
 */
#define ZCR_REMOTE_SURFACE_V1_RESIZE_SINCE_VERSION 9
/**
 * @ingroup iface_zcr_remote_surface_v1
 */
#define ZCR_REMOTE_SURFACE_V1_SET_RESIZE_OUTSET_SINCE_VERSION 9
/**
 * @ingroup iface_zcr_remote_surface_v1
 */
#define ZCR_REMOTE_SURFACE_V1_START_MOVE_SINCE_VERSION 10
/**
 * @ingroup iface_zcr_remote_surface_v1
 */
#define ZCR_REMOTE_SURFACE_V1_SET_CAN_MAXIMIZE_SINCE_VERSION 10
/**
 * @ingroup iface_zcr_remote_surface_v1
 */
#define ZCR_REMOTE_SURFACE_V1_UNSET_CAN_MAXIMIZE_SINCE_VERSION 10
/**
 * @ingroup iface_zcr_remote_surface_v1
 */
#define ZCR_REMOTE_SURFACE_V1_SET_MIN_SIZE_SINCE_VERSION 10
/**
 * @ingroup iface_zcr_remote_surface_v1
 */
#define ZCR_REMOTE_SURFACE_V1_SET_MAX_SIZE_SINCE_VERSION 10

/**
 * @ingroup iface_zcr_remote_surface_v1
 * Sends an close event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zcr_remote_surface_v1_send_close(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ZCR_REMOTE_SURFACE_V1_CLOSE);
}

/**
 * @ingroup iface_zcr_remote_surface_v1
 * Sends an state_type_changed event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zcr_remote_surface_v1_send_state_type_changed(struct wl_resource *resource_, uint32_t state_type)
{
	wl_resource_post_event(resource_, ZCR_REMOTE_SURFACE_V1_STATE_TYPE_CHANGED, state_type);
}

/**
 * @ingroup iface_zcr_remote_surface_v1
 * Sends an configure event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zcr_remote_surface_v1_send_configure(struct wl_resource *resource_, int32_t origin_offset_x, int32_t origin_offset_y, struct wl_array *states, uint32_t serial)
{
	wl_resource_post_event(resource_, ZCR_REMOTE_SURFACE_V1_CONFIGURE, origin_offset_x, origin_offset_y, states, serial);
}

/**
 * @ingroup iface_zcr_remote_surface_v1
 * Sends an window_geometry_changed event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zcr_remote_surface_v1_send_window_geometry_changed(struct wl_resource *resource_, int32_t x, int32_t y, int32_t width, int32_t height)
{
	wl_resource_post_event(resource_, ZCR_REMOTE_SURFACE_V1_WINDOW_GEOMETRY_CHANGED, x, y, width, height);
}

/**
 * @ingroup iface_zcr_remote_surface_v1
 * Sends an bounds_changed event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zcr_remote_surface_v1_send_bounds_changed(struct wl_resource *resource_, uint32_t workspace_id_hi, uint32_t workspace_id_lo, int32_t x, int32_t y, int32_t width, int32_t height, uint32_t bounds_change_reason)
{
	wl_resource_post_event(resource_, ZCR_REMOTE_SURFACE_V1_BOUNDS_CHANGED, workspace_id_hi, workspace_id_lo, x, y, width, height, bounds_change_reason);
}

/**
 * @ingroup iface_zcr_remote_surface_v1
 * Sends an drag_started event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zcr_remote_surface_v1_send_drag_started(struct wl_resource *resource_, uint32_t direction)
{
	wl_resource_post_event(resource_, ZCR_REMOTE_SURFACE_V1_DRAG_STARTED, direction);
}

/**
 * @ingroup iface_zcr_remote_surface_v1
 * Sends an drag_finished event to the client owning the resource.
 * @param resource_ The client's resource
 * @param canceled true if the operation was canceled
 */
static inline void
zcr_remote_surface_v1_send_drag_finished(struct wl_resource *resource_, int32_t x, int32_t y, int32_t canceled)
{
	wl_resource_post_event(resource_, ZCR_REMOTE_SURFACE_V1_DRAG_FINISHED, x, y, canceled);
}

/**
 * @ingroup iface_zcr_notification_surface_v1
 * @struct zcr_notification_surface_v1_interface
 */
struct zcr_notification_surface_v1_interface {
	/**
	 * Destroy the notification_surface
	 *
	 * Unmap and destroy the notification surface.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};


/**
 * @ingroup iface_zcr_notification_surface_v1
 */
#define ZCR_NOTIFICATION_SURFACE_V1_DESTROY_SINCE_VERSION 1

#ifdef  __cplusplus
}
#endif

#endif
