/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.ClassPool;
import proguard.classfile.visitor.ClassPoolVisitor;

public class MultiClassPoolVisitor
implements ClassPoolVisitor {
    private static final int ARRAY_SIZE_INCREMENT = 5;
    private ClassPoolVisitor[] classPoolVisitors;
    private int classPoolVisitorCount;

    public MultiClassPoolVisitor() {
    }

    public MultiClassPoolVisitor(ClassPoolVisitor[] classPoolVisitorArray) {
        this.classPoolVisitors = classPoolVisitorArray;
        this.classPoolVisitorCount = classPoolVisitorArray.length;
    }

    public void addClassPoolVisitor(ClassPoolVisitor classPoolVisitor) {
        this.ensureArraySize();
        this.classPoolVisitors[this.classPoolVisitorCount++] = classPoolVisitor;
    }

    private void ensureArraySize() {
        if (this.classPoolVisitors == null) {
            this.classPoolVisitors = new ClassPoolVisitor[5];
        } else if (this.classPoolVisitors.length == this.classPoolVisitorCount) {
            ClassPoolVisitor[] classPoolVisitorArray = new ClassPoolVisitor[this.classPoolVisitorCount + 5];
            System.arraycopy(this.classPoolVisitors, 0, classPoolVisitorArray, 0, this.classPoolVisitorCount);
            this.classPoolVisitors = classPoolVisitorArray;
        }
    }

    @Override
    public void visitClassPool(ClassPool classPool) {
        for (int i = 0; i < this.classPoolVisitorCount; ++i) {
            this.classPoolVisitors[i].visitClassPool(classPool);
        }
    }
}

