/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation;

import proguard.evaluation.Variables;
import proguard.evaluation.value.Value;

public class TracedVariables
extends Variables {
    public static final int NONE = -1;
    private Value producerValue;
    private Variables producerVariables;

    public TracedVariables(int n) {
        super(n);
        this.producerVariables = new Variables(n);
    }

    public TracedVariables(TracedVariables tracedVariables) {
        super(tracedVariables);
        this.producerVariables = new Variables(tracedVariables.producerVariables);
    }

    public void setProducerValue(Value value) {
        this.producerValue = value;
    }

    public Value getProducerValue(int n) {
        return this.producerVariables.getValue(n);
    }

    public void setProducerValue(int n, Value value) {
        this.producerVariables.store(n, value);
    }

    @Override
    public void reset(int n) {
        super.reset(n);
        this.producerVariables.reset(n);
    }

    public void initialize(TracedVariables tracedVariables) {
        super.initialize(tracedVariables);
        this.producerVariables.initialize(tracedVariables.producerVariables);
    }

    public boolean generalize(TracedVariables tracedVariables, boolean bl) {
        boolean bl2 = super.generalize(tracedVariables, bl);
        boolean bl3 = this.producerVariables.generalize(tracedVariables.producerVariables, bl);
        if (bl2) {
            for (int i = 0; i < this.size; ++i) {
                if (this.values[i] != null) continue;
                this.producerVariables.values[i] = null;
                if (!bl) continue;
                tracedVariables.producerVariables.values[i] = null;
            }
        }
        return bl2 || bl3;
    }

    @Override
    public void store(int n, Value value) {
        super.store(n, value);
        this.producerVariables.store(n, this.producerValue);
        if (value.isCategory2()) {
            this.producerVariables.store(n + 1, this.producerValue);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TracedVariables tracedVariables = (TracedVariables)object;
        return super.equals(object) && this.producerVariables.equals(tracedVariables.producerVariables);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.producerVariables.hashCode();
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.size(); ++i) {
            Value value = this.values[i];
            Value value2 = this.producerVariables.getValue(i);
            stringBuffer = stringBuffer.append('[').append(value2 == null ? "empty:" : value2.toString()).append(value == null ? "empty" : value.toString()).append(']');
        }
        return stringBuffer.toString();
    }
}

