/*
 *  Copyright (c) 2018 The WebRTC project authors. All Rights Reserved.
 *
 *  Use of this source code is governed by a BSD-style license
 *  that can be found in the LICENSE file in the root of the source
 *  tree. An additional intellectual property rights grant can be found
 *  in the file PATENTS.  All contributing project authors may
 *  be found in the AUTHORS file in the root of the source tree.
 */

#ifndef API_VIDEO_CODECS_CREATE_VP8_TEMPORAL_LAYERS_H_
#define API_VIDEO_CODECS_CREATE_VP8_TEMPORAL_LAYERS_H_

#include <memory>

#include "api/video_codecs/vp8_temporal_layers.h"

namespace webrtc {

std::unique_ptr<Vp8TemporalLayers> CreateVp8TemporalLayers(
    Vp8TemporalLayersType type,
    int num_temporal_layers);

}  // namespace webrtc

#endif  // API_VIDEO_CODECS_CREATE_VP8_TEMPORAL_LAYERS_H_
