/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.TernaryValue;

final class CheckSuspiciousCode
extends NodeTraversal.AbstractPostOrderCallback {
    static final DiagnosticType SUSPICIOUS_SEMICOLON = DiagnosticType.warning("JSC_SUSPICIOUS_SEMICOLON", "If this if/for/while really shouldn''t have a body, use '{}'");
    static final DiagnosticType SUSPICIOUS_COMPARISON_WITH_NAN = DiagnosticType.warning("JSC_SUSPICIOUS_NAN", "Comparison against NaN is always false. Did you mean isNaN()?");
    static final DiagnosticType SUSPICIOUS_IN_OPERATOR = DiagnosticType.warning("JSC_SUSPICIOUS_IN", "Use of the \"in\" keyword on non-object types throws an exception.");
    static final DiagnosticType SUSPICIOUS_INSTANCEOF_LEFT_OPERAND = DiagnosticType.warning("JSC_SUSPICIOUS_INSTANCEOF_LEFT", "\"instanceof\" with left non-object operand is always false.");
    static final DiagnosticType SUSPICIOUS_LEFT_OPERAND_OF_LOGICAL_OPERATOR = DiagnosticType.warning("JSC_SUSPICIOUS_LEFT_OPERAND_OF_LOGICAL_OPERATOR", "Left operand of {0} operator is always {1}.");
    static final DiagnosticType SUSPICIOUS_NEGATED_LEFT_OPERAND_OF_IN_OPERATOR = DiagnosticType.warning("JSC_SUSPICIOUS_NEGATED_LEFT_OPERAND_OF_IN_OPERATOR", "Suspicious negated left operand of 'in' operator.");

    CheckSuspiciousCode() {
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        this.checkMissingSemicolon(t, n);
        this.checkNaN(t, n);
        this.checkInvalidIn(t, n);
        this.checkNonObjectInstanceOf(t, n);
        this.checkNegatedLeftOperandOfInOperator(t, n);
        this.checkLeftOperandOfLogicalOperator(t, n);
    }

    private void checkMissingSemicolon(NodeTraversal t, Node n) {
        switch (n.getToken()) {
            case IF: {
                Node trueCase = n.getSecondChild();
                CheckSuspiciousCode.reportIfWasEmpty(t, trueCase);
                Node elseCase = trueCase.getNext();
                if (elseCase == null) break;
                CheckSuspiciousCode.reportIfWasEmpty(t, elseCase);
                break;
            }
            case WHILE: 
            case FOR: 
            case FOR_IN: 
            case FOR_OF: 
            case FOR_AWAIT_OF: {
                CheckSuspiciousCode.reportIfWasEmpty(t, NodeUtil.getLoopCodeBlock(n));
                break;
            }
        }
    }

    private static void reportIfWasEmpty(NodeTraversal t, Node block) {
        Preconditions.checkState(block.isBlock());
        if (!block.hasChildren() && block.isAddedBlock()) {
            t.getCompiler().report(JSError.make(block, SUSPICIOUS_SEMICOLON, new String[0]));
        }
    }

    private void checkNaN(NodeTraversal t, Node n) {
        switch (n.getToken()) {
            case EQ: 
            case GE: 
            case GT: 
            case LE: 
            case LT: 
            case NE: 
            case SHEQ: 
            case SHNE: {
                CheckSuspiciousCode.reportIfNaN(t, n.getFirstChild());
                CheckSuspiciousCode.reportIfNaN(t, n.getLastChild());
                break;
            }
        }
    }

    private static void reportIfNaN(NodeTraversal t, Node n) {
        if (NodeUtil.isNaN(n)) {
            t.getCompiler().report(JSError.make(n.getParent(), SUSPICIOUS_COMPARISON_WITH_NAN, new String[0]));
        }
    }

    private void checkInvalidIn(NodeTraversal t, Node n) {
        if (n.isIn()) {
            CheckSuspiciousCode.reportIfNonObject(t, n.getLastChild(), SUSPICIOUS_IN_OPERATOR);
        }
    }

    private void checkNonObjectInstanceOf(NodeTraversal t, Node n) {
        if (n.isInstanceOf()) {
            CheckSuspiciousCode.reportIfNonObject(t, n.getFirstChild(), SUSPICIOUS_INSTANCEOF_LEFT_OPERAND);
        }
    }

    private static boolean reportIfNonObject(NodeTraversal t, Node n, DiagnosticType diagnosticType) {
        if (n.isAdd() || !NodeUtil.mayBeObject(n)) {
            t.report(n.getParent(), diagnosticType, new String[0]);
            return true;
        }
        return false;
    }

    private void checkNegatedLeftOperandOfInOperator(NodeTraversal t, Node n) {
        if (n.isIn() && n.getFirstChild().isNot()) {
            t.report(n.getFirstChild(), SUSPICIOUS_NEGATED_LEFT_OPERAND_OF_IN_OPERATOR, new String[0]);
        }
    }

    private void checkLeftOperandOfLogicalOperator(NodeTraversal t, Node n) {
        if (n.isOr() || n.isAnd()) {
            String operator = n.isOr() ? "||" : "&&";
            TernaryValue v = this.getBooleanValueWithTypes(n.getFirstChild());
            if (v != TernaryValue.UNKNOWN) {
                String result = v == TernaryValue.TRUE ? "truthy" : "falsy";
                t.report(n, SUSPICIOUS_LEFT_OPERAND_OF_LOGICAL_OPERATOR, operator, result);
            }
        }
    }

    private TernaryValue getBooleanValueWithTypes(Node n) {
        switch (n.getToken()) {
            case ASSIGN: 
            case COMMA: {
                return this.getBooleanValueWithTypes(n.getLastChild());
            }
            case NOT: {
                return this.getBooleanValueWithTypes(n.getLastChild()).not();
            }
            case AND: {
                return TernaryValue.UNKNOWN.and(this.getBooleanValueWithTypes(n.getLastChild()));
            }
            case OR: {
                return TernaryValue.UNKNOWN.or(this.getBooleanValueWithTypes(n.getLastChild()));
            }
            case HOOK: {
                TernaryValue trueValue = this.getBooleanValueWithTypes(n.getSecondChild());
                TernaryValue falseValue = this.getBooleanValueWithTypes(n.getLastChild());
                return trueValue.equals((Object)falseValue) ? trueValue : TernaryValue.UNKNOWN;
            }
            case FUNCTION: 
            case CLASS: 
            case NEW: 
            case ARRAYLIT: 
            case OBJECTLIT: {
                return TernaryValue.TRUE;
            }
            case VOID: {
                return TernaryValue.FALSE;
            }
            case GETPROP: 
            case GETELEM: {
                return TernaryValue.UNKNOWN;
            }
        }
        TernaryValue literalValue = NodeUtil.getBooleanValue(n);
        if (literalValue != TernaryValue.UNKNOWN || n.isName()) {
            return literalValue;
        }
        JSType type = n.getJSType();
        if (type != null) {
            return TernaryValue.UNKNOWN.and(type.getPossibleToBooleanOutcomes().toTernaryValue());
        }
        return TernaryValue.UNKNOWN;
    }
}

