/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AbstractPeepholeOptimization;
import com.google.javascript.jscomp.J2clSourceFileChecker;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;

public class J2clEqualitySameRewriterPass
extends AbstractPeepholeOptimization {
    private final boolean useTypes;
    private boolean shouldRunJ2clPasses;

    J2clEqualitySameRewriterPass(boolean useTypes) {
        this.useTypes = useTypes;
    }

    @Override
    void beginTraversal(AbstractCompiler compiler) {
        super.beginTraversal(compiler);
        this.shouldRunJ2clPasses = J2clSourceFileChecker.shouldRunJ2clPasses(compiler);
    }

    @Override
    Node optimizeSubtree(Node node) {
        if (!this.shouldRunJ2clPasses) {
            return node;
        }
        if (!J2clEqualitySameRewriterPass.isEqualitySameCall(node)) {
            return node;
        }
        Node replacement = this.trySubstituteEqualitySame(node);
        if (replacement != node) {
            replacement = replacement.useSourceInfoIfMissingFrom(node);
            node.replaceWith(replacement);
            this.reportChangeToEnclosingScope(replacement);
        }
        return replacement;
    }

    private Node trySubstituteEqualitySame(Node callNode) {
        Node firstExpr = callNode.getSecondChild();
        NodeValue firstExprValue = J2clEqualitySameRewriterPass.getKnownLiteralValue(firstExpr);
        Node secondExpr = callNode.getLastChild();
        NodeValue secondExprValue = J2clEqualitySameRewriterPass.getKnownLiteralValue(secondExpr);
        if (firstExprValue == NodeValue.UNKNOWN && secondExprValue == NodeValue.UNKNOWN) {
            return callNode;
        }
        if (firstExprValue == NodeValue.NULL_OR_UNDEFINED) {
            return this.rewriteNullCheck(secondExpr, firstExpr);
        }
        if (secondExprValue == NodeValue.NULL_OR_UNDEFINED) {
            return this.rewriteNullCheck(firstExpr, secondExpr);
        }
        return this.rewriteAsStrictEq(firstExpr, secondExpr);
    }

    private Node rewriteNullCheck(Node expr, Node nullExpression) {
        expr.detach();
        nullExpression.detach();
        if (this.useTypes && this.canOnlyBeObject(expr)) {
            return IR.not(expr);
        }
        return IR.eq(expr, nullExpression);
    }

    private boolean canOnlyBeObject(Node n) {
        JSType type = n.getJSType();
        if (type == null) {
            return false;
        }
        return !(type = type.restrictByNotNullOrUndefined()).isUnknownType() && !type.isEmptyType() && !type.isAllType() && type.isObjectType();
    }

    private Node rewriteAsStrictEq(Node firstExpr, Node secondExpr) {
        firstExpr.detach();
        secondExpr.detach();
        return IR.sheq(firstExpr, secondExpr);
    }

    private static NodeValue getKnownLiteralValue(Node n) {
        switch (NodeUtil.getKnownValueType(n)) {
            case VOID: {
                return NodeUtil.canBeSideEffected(n) ? NodeValue.UNKNOWN : NodeValue.NULL_OR_UNDEFINED;
            }
            case NULL: {
                return NodeValue.NULL_OR_UNDEFINED;
            }
            case NUMBER: 
            case STRING: 
            case BOOLEAN: 
            case OBJECT: {
                return NodeValue.NON_NULL;
            }
            case UNDETERMINED: {
                return NodeValue.UNKNOWN;
            }
        }
        throw new AssertionError((Object)"Unknown ValueType");
    }

    private static boolean isEqualitySameCall(Node node) {
        return node.isCall() && node.hasXChildren(3) && J2clEqualitySameRewriterPass.isEqualitySameMethodName(node.getFirstChild());
    }

    private static boolean isEqualitySameMethodName(Node fnName) {
        if (!fnName.isQualifiedName()) {
            return false;
        }
        String originalQname = fnName.getOriginalQualifiedName();
        return originalQname.endsWith(".$same") && originalQname.contains("Equality");
    }

    private static enum NodeValue {
        NULL_OR_UNDEFINED,
        NON_NULL,
        UNKNOWN;

    }
}

