/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AbstractScope;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.Es6RewriteModules;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.SyntacticScopeCreator;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.jscomp.modules.Binding;
import com.google.javascript.jscomp.modules.Module;
import com.google.javascript.jscomp.modules.ModuleMap;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class RewriteGoogJsImports
implements HotSwapCompilerPass {
    static final DiagnosticType GOOG_JS_IMPORT_MUST_BE_GOOG_STAR = DiagnosticType.error("JSC_GOOG_JS_IMPORT_MUST_BE_GOOG_STAR", "Closure''s goog.js file must be imported as `import * as goog`.");
    static final DiagnosticType GOOG_JS_REEXPORTED = DiagnosticType.error("JSC_GOOG_JS_REEXPORTED", "Do not re-export from goog.js.");
    static final DiagnosticType CANNOT_NAME_FILE_GOOG = DiagnosticType.error("JSC_CANNOT_NAME_FILE_GOOG", "Do not name files goog.js, it is reserved for Closure Library.");
    static final DiagnosticType CANNOT_HAVE_MODULE_VAR_NAMED_GOOG = DiagnosticType.error("JSC_CANNOT_HAVE_MODULE_VAR_NAMED_GOOG", "Module scoped variables named ''goog'' must come from importing Closure Library''s goog.js file..");
    private static final String EXPECTED_BASE_PROVIDE = "goog";
    private final Mode mode;
    private final ModuleMap moduleMap;
    private final AbstractCompiler compiler;
    private Module googModule;
    private final Map<Module, Module> moduleReplacements = new HashMap<Module, Module>();

    public RewriteGoogJsImports(AbstractCompiler compiler, Mode mode, ModuleMap moduleMap) {
        Preconditions.checkNotNull(moduleMap);
        this.compiler = compiler;
        this.mode = mode;
        this.moduleMap = moduleMap;
    }

    private void changeModules() {
        Module newModule;
        ImmutableMap.Builder resolvedModules = ImmutableMap.builder();
        ImmutableMap.Builder closureModules = ImmutableMap.builder();
        for (Map.Entry m : this.moduleMap.getModulesByPath().entrySet()) {
            newModule = this.moduleReplacements.getOrDefault(m.getValue(), (Module)m.getValue());
            resolvedModules.put(m.getKey(), newModule);
        }
        for (Map.Entry m : this.moduleMap.getModulesByClosureNamespace().entrySet()) {
            newModule = this.moduleReplacements.getOrDefault(m.getValue(), (Module)m.getValue());
            closureModules.put(m.getKey(), newModule);
        }
        this.compiler.setModuleMap(new ModuleMap(resolvedModules.build(), closureModules.build()));
        this.moduleReplacements.clear();
    }

    @Nullable
    private Node findGoogImportNode(Node scriptRoot) {
        boolean valid = true;
        Node googImportNode = null;
        for (Node child : scriptRoot.getFirstChild().children()) {
            if (!child.isImport() || !child.getLastChild().getString().endsWith("/goog.js")) continue;
            if (child.getFirstChild().isEmpty() && child.getSecondChild().isImportStar() && child.getSecondChild().getString().equals(EXPECTED_BASE_PROVIDE)) {
                googImportNode = child;
                continue;
            }
            valid = false;
            this.compiler.report(JSError.make(scriptRoot.getSourceFileName(), child.getLineno(), child.getCharno(), GOOG_JS_IMPORT_MUST_BE_GOOG_STAR, new String[0]));
        }
        if (!valid) {
            return null;
        }
        if (googImportNode != null) {
            return googImportNode;
        }
        AbstractScope moduleScope = new SyntacticScopeCreator(this.compiler).createScope(scriptRoot.getFirstChild(), (AbstractScope)Scope.createGlobalScope(scriptRoot));
        Var googVar = (Var)moduleScope.getVar(EXPECTED_BASE_PROVIDE);
        if (googVar != null && googVar.getNameNode() != null) {
            this.compiler.report(JSError.make(scriptRoot.getSourceFileName(), googVar.getNameNode().getLineno(), googVar.getNameNode().getCharno(), CANNOT_HAVE_MODULE_VAR_NAMED_GOOG, new String[0]));
        }
        return null;
    }

    private void rewriteImports(Node scriptRoot) {
        if (Es6RewriteModules.isEs6ModuleRoot(scriptRoot)) {
            Node googImportNode = this.findGoogImportNode(scriptRoot);
            NodeTraversal.traverse(this.compiler, scriptRoot, new FindReexports(googImportNode != null));
            Module module = this.moduleMap.getModule(this.compiler.getInput(scriptRoot.getInputId()).getPath());
            Preconditions.checkNotNull(module);
            if (googImportNode != null && this.mode == Mode.LINT_AND_REWRITE) {
                new ReferenceReplacer(scriptRoot, googImportNode, module, this.googModule == null);
            }
        }
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        this.rewriteImports(scriptRoot);
        this.changeModules();
    }

    @Nullable
    private Node findGoogJsScriptNode(Node root) {
        ModuleLoader.ModulePath expectedGoogPath = null;
        for (Node script : root.children()) {
            ImmutableList<String> provides = this.compiler.getInput(script.getInputId()).getProvides();
            if (!provides.contains(EXPECTED_BASE_PROVIDE)) continue;
            expectedGoogPath = this.compiler.getInput(script.getInputId()).getPath().resolveModuleAsPath("./goog.js");
            break;
        }
        if (expectedGoogPath != null) {
            Node googScriptNode = null;
            for (Node script : root.children()) {
                if (this.compiler.getInput(script.getInputId()).getPath().equalsIgnoreLeadingSlash(expectedGoogPath)) {
                    googScriptNode = script;
                    continue;
                }
                if (!script.getSourceFileName().endsWith("/goog.js")) continue;
                this.compiler.report(JSError.make(script.getSourceFileName(), -1, -1, CheckLevel.ERROR, CANNOT_NAME_FILE_GOOG, new String[0]));
            }
            return googScriptNode;
        }
        return null;
    }

    @Override
    public void process(Node externs, Node root) {
        this.googModule = null;
        Node googJsScriptNode = this.findGoogJsScriptNode(root);
        if (googJsScriptNode == null) {
            googJsScriptNode = this.findGoogJsScriptNode(externs);
        }
        if (this.mode == Mode.LINT_AND_REWRITE) {
            if (googJsScriptNode != null) {
                ModuleLoader.ModulePath googJsPath = this.compiler.getInput(googJsScriptNode.getInputId()).getPath();
                this.googModule = this.moduleMap.getModule(googJsPath);
                Preconditions.checkNotNull(this.googModule);
                Predicate isFromGoog = b -> b.originatingExport().modulePath() == googJsPath;
                Preconditions.checkState(this.googModule.boundNames().values().stream().allMatch(isFromGoog), "goog.js should never import anything");
                Preconditions.checkState(!this.googModule.namespace().containsKey("default"), "goog.js should never have a default export.");
                Preconditions.checkState(this.googModule.namespace().values().stream().allMatch(isFromGoog), "goog.js should never export from anything.");
            }
        } else {
            Preconditions.checkState(this.mode == Mode.LINT_ONLY);
        }
        for (Node script : root.children()) {
            this.rewriteImports(script);
        }
        this.changeModules();
    }

    private static class FindReexports
    extends NodeTraversal.AbstractPreOrderCallback {
        private final boolean hasGoogImport;

        public FindReexports(boolean hasGoogImport) {
            this.hasGoogImport = hasGoogImport;
        }

        private void checkIfForwardingExport(NodeTraversal t, Node export) {
            if (export.hasTwoChildren() && export.getLastChild().getString().endsWith("/goog.js")) {
                t.report(export, GOOG_JS_REEXPORTED, new String[0]);
            }
        }

        private void checkIfNameFowardedExport(NodeTraversal t, Node nameNode, Node parent) {
            if (this.hasGoogImport && nameNode.getString().equals(RewriteGoogJsImports.EXPECTED_BASE_PROVIDE) && (parent.isExportSpec() && parent.getFirstChild() == nameNode || parent.isExport())) {
                t.report(nameNode, GOOG_JS_REEXPORTED, new String[0]);
            }
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case ROOT: 
                case SCRIPT: 
                case MODULE_BODY: 
                case EXPORT_SPECS: 
                case EXPORT_SPEC: {
                    return true;
                }
                case EXPORT: {
                    this.checkIfForwardingExport(t, n);
                    return true;
                }
                case NAME: {
                    this.checkIfNameFowardedExport(t, n, parent);
                    return false;
                }
            }
            return false;
        }
    }

    private class ReferenceReplacer
    extends NodeTraversal.AbstractPostOrderCallback {
        private boolean hasBadExport;
        private final Node googImportNode;
        private final boolean globalizeAllReferences;

        ReferenceReplacer(Node script, Node googImportNode, Module module, boolean globalizeAllReferences) {
            this.googImportNode = googImportNode;
            this.globalizeAllReferences = globalizeAllReferences;
            NodeTraversal.traverse(RewriteGoogJsImports.this.compiler, script, this);
            if (googImportNode.getSecondChild().isImportStar()) {
                LinkedHashMap<String, Binding> newBindings = new LinkedHashMap<String, Binding>(module.boundNames());
                newBindings.remove(RewriteGoogJsImports.EXPECTED_BASE_PROVIDE);
                if (this.hasBadExport) {
                    googImportNode.getSecondChild().setOriginalName(RewriteGoogJsImports.EXPECTED_BASE_PROVIDE);
                    googImportNode.getSecondChild().setString("$goog");
                    newBindings.put("$goog", module.boundNames().get(RewriteGoogJsImports.EXPECTED_BASE_PROVIDE));
                } else {
                    googImportNode.getSecondChild().replaceWith(IR.empty());
                }
                Module newModule = module.toBuilder().boundNames(ImmutableMap.copyOf(newBindings)).build();
                RewriteGoogJsImports.this.moduleReplacements.put(module, newModule);
                RewriteGoogJsImports.this.compiler.reportChangeToEnclosingScope(googImportNode);
            }
        }

        private void maybeRewriteBadGoogJsImportRef(NodeTraversal t, Node nameNode, Node parent) {
            if (!parent.isGetProp() || !nameNode.getString().equals(RewriteGoogJsImports.EXPECTED_BASE_PROVIDE)) {
                return;
            }
            Var var = (Var)t.getScope().getVar(nameNode.getString());
            if (var == null || var.getNameNode() == null || var.getNameNode().getParent() != this.googImportNode) {
                return;
            }
            if (this.globalizeAllReferences || RewriteGoogJsImports.this.googModule.namespace().containsKey(parent.getSecondChild().getString())) {
                return;
            }
            this.hasBadExport = true;
            nameNode.setOriginalName(RewriteGoogJsImports.EXPECTED_BASE_PROVIDE);
            nameNode.setString("$goog");
            t.reportCodeChange();
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case NAME: {
                    this.maybeRewriteBadGoogJsImportRef(t, n, parent);
                    break;
                }
            }
        }
    }

    public static enum Mode {
        LINT_ONLY,
        LINT_AND_REWRITE;

    }
}

