/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.lint;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.ExportTestFunctions;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import javax.annotation.Nullable;

public final class CheckJSDocStyle
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    public static final DiagnosticType CLASS_DISALLOWED_JSDOC = DiagnosticType.disabled("JSC_CLASS_DISALLOWED_JSDOC", "@constructor annotations are redundant on classes.");
    public static final DiagnosticType MISSING_JSDOC = DiagnosticType.disabled("JSC_MISSING_JSDOC", "Function must have JSDoc.");
    public static final DiagnosticType MISSING_PARAMETER_JSDOC = DiagnosticType.disabled("JSC_MISSING_PARAMETER_JSDOC", "Parameter must have JSDoc.");
    public static final DiagnosticType MIXED_PARAM_JSDOC_STYLES = DiagnosticType.disabled("JSC_MIXED_PARAM_JSDOC_STYLES", "Functions may not use both @param annotations and inline JSDoc");
    public static final DiagnosticType MISSING_RETURN_JSDOC = DiagnosticType.disabled("JSC_MISSING_RETURN_JSDOC", "Function with non-trivial return must have JSDoc indicating the return type.");
    public static final DiagnosticType MUST_BE_PRIVATE = DiagnosticType.disabled("JSC_MUST_BE_PRIVATE", "Property {0} must be marked @private");
    public static final DiagnosticType MUST_HAVE_TRAILING_UNDERSCORE = DiagnosticType.disabled("JSC_MUST_HAVE_TRAILING_UNDERSCORE", "Private property {0} should end with ''_''");
    public static final DiagnosticType OPTIONAL_PARAM_NOT_MARKED_OPTIONAL = DiagnosticType.disabled("JSC_OPTIONAL_PARAM_NOT_MARKED_OPTIONAL", "Parameter {0} is optional so its type must end with =");
    public static final DiagnosticType WRONG_NUMBER_OF_PARAMS = DiagnosticType.disabled("JSC_WRONG_NUMBER_OF_PARAMS", "Wrong number of @param annotations");
    public static final DiagnosticType INCORRECT_PARAM_NAME = DiagnosticType.disabled("JSC_INCORRECT_PARAM_NAME", "Incorrect param name. Are your @param annotations in the wrong order?");
    public static final DiagnosticType EXTERNS_FILES_SHOULD_BE_ANNOTATED = DiagnosticType.disabled("JSC_EXTERNS_FILES_SHOULD_BE_ANNOTATED", "Externs files should be annotated with @externs in the @fileoverview block.");
    public static final DiagnosticType PREFER_BACKTICKS_TO_AT_SIGN_CODE = DiagnosticType.disabled("JSC_PREFER_BACKTICKS_TO_AT_SIGN_CODE", "Use `some_code` instead of '{'@code some_code'}'.");
    public static final DiagnosticGroup LINT_DIAGNOSTICS = new DiagnosticGroup(CLASS_DISALLOWED_JSDOC, MISSING_JSDOC, MISSING_PARAMETER_JSDOC, MIXED_PARAM_JSDOC_STYLES, MISSING_RETURN_JSDOC, OPTIONAL_PARAM_NOT_MARKED_OPTIONAL, WRONG_NUMBER_OF_PARAMS, INCORRECT_PARAM_NAME, EXTERNS_FILES_SHOULD_BE_ANNOTATED, PREFER_BACKTICKS_TO_AT_SIGN_CODE);
    public static final DiagnosticGroup UNDERSCORE_DIAGNOSTICS = new DiagnosticGroup(MUST_BE_PRIVATE, MUST_HAVE_TRAILING_UNDERSCORE);
    public static final DiagnosticGroup ALL_DIAGNOSTICS = new DiagnosticGroup(LINT_DIAGNOSTICS, UNDERSCORE_DIAGNOSTICS);
    private final AbstractCompiler compiler;

    public CheckJSDocStyle(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
        NodeTraversal.traverse(this.compiler, externs, new ExternsCallback());
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node unused) {
        switch (n.getToken()) {
            case FUNCTION: {
                this.visitFunction(t, n);
                break;
            }
            case CLASS: {
                this.visitClass(t, n);
                break;
            }
            case ASSIGN: {
                this.checkStyleForPrivateProperties(t, n);
                break;
            }
            case VAR: 
            case LET: 
            case CONST: 
            case STRING_KEY: 
            case SCRIPT: {
                break;
            }
            case MEMBER_FUNCTION_DEF: 
            case GETTER_DEF: 
            case SETTER_DEF: {
                if (NodeUtil.getEnclosingClass(n) == null) break;
                this.checkStyleForPrivateProperties(t, n);
                break;
            }
            default: {
                this.visitNonFunction(t, n);
            }
        }
    }

    private void checkForAtSignCodePresence(NodeTraversal t, Node n, @Nullable JSDocInfo jsDoc) {
        if (jsDoc == null) {
            return;
        }
        if (jsDoc.isAtSignCodePresent()) {
            t.report(n, PREFER_BACKTICKS_TO_AT_SIGN_CODE, new String[0]);
        }
    }

    private void visitNonFunction(NodeTraversal t, Node n) {
        JSDocInfo jsDoc = n.getJSDocInfo();
        this.checkForAtSignCodePresence(t, n, jsDoc);
    }

    private void checkStyleForPrivateProperties(NodeTraversal t, Node n) {
        String name;
        JSDocInfo jsDoc = NodeUtil.getBestJSDocInfo(n);
        this.checkForAtSignCodePresence(t, n, jsDoc);
        if (NodeUtil.isEs6ConstructorMemberFunctionDef(n)) {
            return;
        }
        if (n.isMemberFunctionDef() || n.isGetterDef() || n.isSetterDef()) {
            name = n.getString();
        } else {
            Preconditions.checkState(n.isAssign());
            Node lhs = n.getFirstChild();
            if (!lhs.isGetProp()) {
                return;
            }
            name = lhs.getLastChild().getString();
        }
        if (jsDoc != null && name != null) {
            if (this.compiler.getCodingConvention().isPrivate(name) && !jsDoc.getVisibility().equals((Object)JSDocInfo.Visibility.PRIVATE) && jsDoc.containsDeclaration()) {
                t.report(n, MUST_BE_PRIVATE, name);
            } else if (this.compiler.getCodingConvention().hasPrivacyConvention() && !this.compiler.getCodingConvention().isPrivate(name) && jsDoc.getVisibility().equals((Object)JSDocInfo.Visibility.PRIVATE)) {
                t.report(n, MUST_HAVE_TRAILING_UNDERSCORE, name);
            }
        }
    }

    private void visitFunction(NodeTraversal t, Node function) {
        JSDocInfo jsDoc = NodeUtil.getBestJSDocInfo(function);
        this.checkForAtSignCodePresence(t, function, jsDoc);
        if (jsDoc == null && !this.hasAnyInlineJsDoc(function)) {
            this.checkMissingJsDoc(t, function);
        } else {
            if (t.inGlobalScope() || this.hasAnyInlineJsDoc(function) || !jsDoc.getParameterNames().isEmpty() || jsDoc.hasReturnType()) {
                this.checkParams(t, function, jsDoc);
            }
            this.checkReturn(t, function, jsDoc);
        }
    }

    private void visitClass(NodeTraversal t, Node cls) {
        JSDocInfo jsDoc = NodeUtil.getBestJSDocInfo(cls);
        this.checkForAtSignCodePresence(t, cls, jsDoc);
        if (jsDoc == null) {
            return;
        }
        if (jsDoc.isConstructor()) {
            t.report(cls, CLASS_DISALLOWED_JSDOC, new String[0]);
        }
    }

    private void checkMissingJsDoc(NodeTraversal t, Node function) {
        if (this.isFunctionThatShouldHaveJsDoc(t, function) && !this.isTestMethod(function)) {
            t.report(function, MISSING_JSDOC, new String[0]);
        }
    }

    private boolean isFunctionThatShouldHaveJsDoc(NodeTraversal t, Node function) {
        if (!t.inGlobalHoistScope() && !t.inModuleScope()) {
            return false;
        }
        if (NodeUtil.isFunctionDeclaration(function)) {
            return true;
        }
        if (NodeUtil.isNameDeclaration(function.getGrandparent()) || function.getParent().isAssign()) {
            return true;
        }
        if (function.getParent().isExport()) {
            return true;
        }
        if (function.getGrandparent().isClassMembers()) {
            Node memberNode = function.getParent();
            if (memberNode.isMemberFunctionDef()) {
                return !this.isConstructorWithoutParameters(function);
            }
            if (memberNode.isGetterDef() || memberNode.isSetterDef()) {
                return true;
            }
        }
        return function.getGrandparent().isObjectLit() && NodeUtil.isCallTo(function.getGrandparent().getParent(), "Polymer");
    }

    private boolean isTestMethod(Node function) {
        Node bestLValue = NodeUtil.getBestLValue(function);
        String name = bestLValue != null ? NodeUtil.getBestLValueName(bestLValue) : null;
        return name != null && ExportTestFunctions.isTestFunction(name);
    }

    private boolean isConstructorWithoutParameters(Node function) {
        return NodeUtil.isEs6Constructor(function) && !NodeUtil.getFunctionParameters(function).hasChildren();
    }

    private void checkParams(NodeTraversal t, Node function, JSDocInfo jsDoc) {
        ImmutableList paramsFromJsDoc;
        if (jsDoc != null && jsDoc.isOverride()) {
            return;
        }
        if (jsDoc != null && jsDoc.getType() != null) {
            return;
        }
        ImmutableList<Object> immutableList = paramsFromJsDoc = jsDoc == null ? ImmutableList.of() : ImmutableList.copyOf(jsDoc.getParameterNames());
        if (paramsFromJsDoc.isEmpty()) {
            this.checkInlineParams(t, function);
        } else {
            Node paramList = NodeUtil.getFunctionParameters(function);
            if (!paramList.hasXChildren(paramsFromJsDoc.size())) {
                t.report(paramList, WRONG_NUMBER_OF_PARAMS, new String[0]);
                return;
            }
            Node param = paramList.getFirstChild();
            for (int i = 0; i < paramsFromJsDoc.size(); ++i) {
                JSTypeExpression paramType;
                String name;
                if (param.getJSDocInfo() != null) {
                    t.report(param, MIXED_PARAM_JSDOC_STYLES, new String[0]);
                }
                if (this.checkParam(t, param, name = (String)paramsFromJsDoc.get(i), paramType = jsDoc.getParameterType(name))) {
                    return;
                }
                param = param.getNext();
            }
        }
    }

    private void checkInlineParams(NodeTraversal t, Node function) {
        Node paramList = NodeUtil.getFunctionParameters(function);
        for (Node param : paramList.children()) {
            JSDocInfo jsDoc;
            JSDocInfo jSDocInfo = jsDoc = param.isDefaultValue() ? param.getFirstChild().getJSDocInfo() : param.getJSDocInfo();
            if (jsDoc == null) {
                t.report(param, MISSING_PARAMETER_JSDOC, new String[0]);
                return;
            }
            JSTypeExpression paramType = jsDoc.getType();
            Preconditions.checkNotNull(paramType, "Inline JSDoc info should always have a type");
            this.checkParam(t, param, null, paramType);
        }
    }

    private boolean checkParam(NodeTraversal t, Node param, @Nullable String name, JSTypeExpression paramType) {
        boolean jsDocOptional;
        boolean nameOptional;
        Node nodeToCheck = param;
        if (param.isDefaultValue()) {
            nodeToCheck = param.getFirstChild();
            nameOptional = true;
        } else if (param.isName()) {
            nameOptional = param.getString().startsWith("opt_");
        } else {
            Preconditions.checkState(param.isDestructuringPattern() || param.isRest(), param);
            nameOptional = false;
        }
        if (name == null || !nodeToCheck.isName()) {
            name = "<unknown name>";
        } else if (!nodeToCheck.matchesQualifiedName(name)) {
            t.report(nodeToCheck, INCORRECT_PARAM_NAME, new String[0]);
            return true;
        }
        boolean bl = jsDocOptional = paramType != null && paramType.isOptionalArg();
        if (nameOptional && !jsDocOptional) {
            t.report(nodeToCheck, OPTIONAL_PARAM_NOT_MARKED_OPTIONAL, name);
            return true;
        }
        return false;
    }

    private static boolean isDefaultAssignedParamWithInlineJsDoc(Node param) {
        return param.isDefaultValue() && param.hasChildren() && param.getFirstChild().isName() && param.getFirstChild().getJSDocInfo() != null;
    }

    private boolean hasAnyInlineJsDoc(Node function) {
        if (function.getFirstChild().getJSDocInfo() != null) {
            return true;
        }
        for (Node param : NodeUtil.getFunctionParameters(function).children()) {
            if (param.getJSDocInfo() == null && !CheckJSDocStyle.isDefaultAssignedParamWithInlineJsDoc(param)) continue;
            return true;
        }
        return false;
    }

    private void checkReturn(NodeTraversal t, Node function, JSDocInfo jsDoc) {
        if (jsDoc != null && (jsDoc.hasType() || jsDoc.isConstructor() || jsDoc.hasReturnType() || jsDoc.isOverride())) {
            return;
        }
        if (NodeUtil.isEs6Constructor(function)) {
            return;
        }
        if (function.getFirstChild().getJSDocInfo() != null) {
            return;
        }
        FindNonTrivialReturn finder = new FindNonTrivialReturn();
        NodeTraversal.traverse(this.compiler, function.getLastChild(), finder);
        if (finder.found) {
            t.report(function, MISSING_RETURN_JSDOC, new String[0]);
        }
    }

    private static class ExternsCallback
    implements NodeTraversal.Callback {
        private ExternsCallback() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            return parent == null || n.isScript();
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            JSDocInfo info;
            if (n.isScript() && ((info = n.getJSDocInfo()) == null || !info.isExterns())) {
                t.report(n, EXTERNS_FILES_SHOULD_BE_ANNOTATED, new String[0]);
            }
        }
    }

    private static class FindNonTrivialReturn
    extends NodeTraversal.AbstractPreOrderCallback {
        private boolean found;

        private FindNonTrivialReturn() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            if (this.found) {
                return false;
            }
            if (parent == null || NodeUtil.isControlStructure(parent) || NodeUtil.isStatementBlock(parent)) {
                if (n.isReturn() && n.hasChildren()) {
                    this.found = true;
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

