/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.parsing;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ascii;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.parsing.Annotation;
import com.google.javascript.jscomp.parsing.Config;
import com.google.javascript.jscomp.parsing.JsDocToken;
import com.google.javascript.jscomp.parsing.JsDocTokenStream;
import com.google.javascript.jscomp.parsing.TypeTransformationParser;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.SimpleErrorReporter;
import com.google.javascript.rhino.StaticSourceFile;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.TokenStream;
import com.google.javascript.rhino.TokenUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class JsDocInfoParser {
    @VisibleForTesting
    public static final String BAD_TYPE_WIKI_LINK = " See https://github.com/google/closure-compiler/wiki/Annotating-JavaScript-for-the-Closure-Compiler for more information.";
    private final JsDocTokenStream stream;
    private final JSDocInfoBuilder jsdocBuilder;
    private final ErrorReporter errorReporter;
    private final Node templateNode;
    private JSDocInfo fileOverviewJSDocInfo = null;
    private State state;
    private final Map<String, Annotation> annotations;
    private final Set<String> suppressionNames;
    private final Set<String> closurePrimitiveNames;
    private final boolean preserveWhitespace;
    private static final Set<String> modifiesAnnotationKeywords = ImmutableSet.of("this", "arguments");
    private static final Set<String> idGeneratorAnnotationKeywords = ImmutableSet.of("unique", "consistent", "stable", "mapped", "xid");
    private static final Set<String> primitiveTypes = ImmutableSet.of("number", "string", "boolean", "symbol");
    private JSDocInfoBuilder fileLevelJsDocBuilder;
    private static final JsDocToken NO_UNREAD_TOKEN = null;
    private JsDocToken unreadToken = NO_UNREAD_TOKEN;

    private void addParserWarning(String messageId, String messageArg) {
        this.addParserWarning(messageId, messageArg, this.stream.getLineno(), this.stream.getCharno());
    }

    private void addParserWarning(String messageId, String messageArg, int lineno, int charno) {
        this.errorReporter.warning(SimpleErrorReporter.getMessage1(messageId, messageArg), this.getSourceName(), lineno, charno);
    }

    private void addParserWarning(String messageId) {
        this.addParserWarning(messageId, this.stream.getLineno(), this.stream.getCharno());
    }

    private void addParserWarning(String messageId, int lineno, int charno) {
        this.errorReporter.warning(SimpleErrorReporter.getMessage0(messageId), this.getSourceName(), lineno, charno);
    }

    private void addTypeWarning(String messageId, String messageArg) {
        this.addTypeWarning(messageId, messageArg, this.stream.getLineno(), this.stream.getCharno());
    }

    private void addTypeWarning(String messageId, String messageArg, int lineno, int charno) {
        this.errorReporter.warning("Bad type annotation. " + SimpleErrorReporter.getMessage1(messageId, messageArg) + BAD_TYPE_WIKI_LINK, this.getSourceName(), lineno, charno);
    }

    private void addTypeWarning(String messageId) {
        this.addTypeWarning(messageId, this.stream.getLineno(), this.stream.getCharno());
    }

    private void addTypeWarning(String messageId, int lineno, int charno) {
        this.errorReporter.warning("Bad type annotation. " + SimpleErrorReporter.getMessage0(messageId) + BAD_TYPE_WIKI_LINK, this.getSourceName(), lineno, charno);
    }

    private void addMissingTypeWarning(int lineno, int charno) {
        this.errorReporter.warning("Missing type declaration.", this.getSourceName(), lineno, charno);
    }

    void setFileLevelJsDocBuilder(JSDocInfoBuilder fileLevelJsDocBuilder) {
        this.fileLevelJsDocBuilder = fileLevelJsDocBuilder;
    }

    void setFileOverviewJSDocInfo(JSDocInfo fileOverviewJSDocInfo) {
        this.fileOverviewJSDocInfo = fileOverviewJSDocInfo;
    }

    public StaticSourceFile getSourceFile() {
        return this.templateNode.getStaticSourceFile();
    }

    public JsDocInfoParser(JsDocTokenStream stream, String comment, int commentPosition, Node templateNode, Config config, ErrorReporter errorReporter) {
        this.stream = stream;
        boolean parseDocumentation = config.jsDocParsingMode().shouldParseDescriptions();
        this.jsdocBuilder = new JSDocInfoBuilder(parseDocumentation);
        if (comment != null) {
            this.jsdocBuilder.recordOriginalCommentString(comment);
            this.jsdocBuilder.recordOriginalCommentPosition(commentPosition);
        }
        this.annotations = config.annotations();
        this.suppressionNames = config.suppressionNames();
        this.closurePrimitiveNames = config.closurePrimitiveNames();
        this.preserveWhitespace = config.jsDocParsingMode().shouldPreserveWhitespace();
        this.errorReporter = errorReporter;
        this.templateNode = templateNode == null ? IR.script() : templateNode;
    }

    private String getSourceName() {
        StaticSourceFile sourceFile = this.getSourceFile();
        return sourceFile == null ? null : sourceFile.getName();
    }

    public JSDocInfo parseInlineTypeDoc() {
        this.skipEOLs();
        JsDocToken token = this.next();
        int lineno = this.stream.getLineno();
        int startCharno = this.stream.getCharno();
        Node typeAst = this.parseParamTypeExpression(token);
        this.recordTypeNode(lineno, startCharno, typeAst, token == JsDocToken.LEFT_CURLY);
        JSTypeExpression expr = this.createJSTypeExpression(typeAst);
        if (expr != null) {
            this.jsdocBuilder.recordType(expr);
            this.jsdocBuilder.recordInlineType();
            return this.retrieveAndResetParsedJSDocInfo();
        }
        return null;
    }

    private void recordTypeNode(int lineno, int startCharno, Node typeAst, boolean matchingLC) {
        if (typeAst != null) {
            int endLineno = this.stream.getLineno();
            int endCharno = this.stream.getCharno();
            this.jsdocBuilder.markTypeNode(typeAst, lineno, startCharno, endLineno, endCharno, matchingLC);
        }
    }

    public static Node parseTypeString(String typeString) {
        JsDocInfoParser parser = JsDocInfoParser.getParser(typeString);
        return parser.parseTopLevelTypeExpression(parser.next());
    }

    public static JSDocInfo parseJsdoc(String toParse) {
        JsDocInfoParser parser = JsDocInfoParser.getParser(toParse);
        parser.parse();
        return parser.retrieveAndResetParsedJSDocInfo();
    }

    @VisibleForTesting
    public static JSDocInfo parseFileOverviewJsdoc(String toParse) {
        JsDocInfoParser parser = JsDocInfoParser.getParser(toParse);
        parser.parse();
        return parser.getFileOverviewJSDocInfo();
    }

    private static JsDocInfoParser getParser(String toParse) {
        Config config = Config.builder().setLanguageMode(Config.LanguageMode.ECMASCRIPT3).setStrictMode(Config.StrictMode.SLOPPY).setClosurePrimitiveNames(ImmutableSet.of("testPrimitive")).build();
        JsDocInfoParser parser = new JsDocInfoParser(new JsDocTokenStream(toParse), toParse, 0, null, config, ErrorReporter.NULL_INSTANCE);
        return parser;
    }

    public boolean parse() {
        this.state = State.SEARCHING_ANNOTATION;
        this.skipEOLs();
        JsDocToken token = this.next();
        if (this.jsdocBuilder.shouldParseDocumentation()) {
            ExtractionInfo blockInfo = this.extractBlockComment(token);
            token = blockInfo.token;
            if (!blockInfo.string.isEmpty()) {
                this.jsdocBuilder.recordBlockDescription(blockInfo.string);
            }
        } else if (token != JsDocToken.ANNOTATION && token != JsDocToken.EOC) {
            this.jsdocBuilder.recordBlockDescription("");
        }
        return this.parseHelperLoop(token, new ArrayList<ExtendedTypeInfo>());
    }

    void parseImportantComment() {
        this.state = State.SEARCHING_ANNOTATION;
        this.skipEOLs();
        JsDocToken token = this.next();
        ExtractionInfo info = this.extractMultilineComment(token, WhitespaceOption.PRESERVE, false, true);
        String license = " " + info.string;
        if (this.fileLevelJsDocBuilder != null) {
            this.fileLevelJsDocBuilder.addLicense(license);
        } else if (this.jsdocBuilder.shouldParseDocumentation()) {
            this.jsdocBuilder.recordBlockDescription(license);
        } else {
            this.jsdocBuilder.recordBlockDescription("");
        }
    }

    private boolean parseHelperLoop(JsDocToken token, List<ExtendedTypeInfo> extendedTypes) {
        block9: while (true) {
            switch (token) {
                case ANNOTATION: {
                    if (this.state == State.SEARCHING_ANNOTATION) {
                        this.state = State.SEARCHING_NEWLINE;
                        token = this.parseAnnotation(token, extendedTypes);
                        continue block9;
                    }
                    token = this.next();
                    continue block9;
                }
                case EOC: {
                    boolean success = true;
                    this.checkExtendedTypes(extendedTypes);
                    if (this.hasParsedFileOverviewDocInfo()) {
                        this.fileOverviewJSDocInfo = this.retrieveAndResetParsedJSDocInfo();
                        JSDocInfo.Visibility visibility = this.fileOverviewJSDocInfo.getVisibility();
                        switch (visibility) {
                            case PRIVATE: 
                            case PROTECTED: {
                                this.addParserWarning("msg.bad.fileoverview.visibility.annotation", Ascii.toLowerCase(visibility.toString()));
                                success = false;
                                break;
                            }
                        }
                    }
                    return success;
                }
                case EOF: {
                    this.jsdocBuilder.build();
                    this.addParserWarning("msg.unexpected.eof");
                    this.checkExtendedTypes(extendedTypes);
                    return false;
                }
                case EOL: {
                    if (this.state == State.SEARCHING_NEWLINE) {
                        this.state = State.SEARCHING_ANNOTATION;
                    }
                    token = this.next();
                    continue block9;
                }
            }
            if (token == JsDocToken.STAR && this.state == State.SEARCHING_ANNOTATION) {
                token = this.next();
                continue;
            }
            this.state = State.SEARCHING_NEWLINE;
            token = this.eatTokensUntilEOL();
        }
    }

    private JsDocToken parseAnnotation(JsDocToken token, List<ExtendedTypeInfo> extendedTypes) {
        int lineno = this.stream.getLineno();
        int charno = this.stream.getCharno();
        String annotationName = this.stream.getString();
        Annotation annotation = this.annotations.get(annotationName);
        if (annotation == null || annotationName.isEmpty()) {
            this.addParserWarning("msg.bad.jsdoc.tag", annotationName);
        } else {
            this.jsdocBuilder.markAnnotation(annotationName, lineno, charno);
            switch (annotation) {
                case NG_INJECT: {
                    if (this.jsdocBuilder.isNgInjectRecorded()) {
                        this.addParserWarning("msg.jsdoc.nginject.extra");
                    } else {
                        this.jsdocBuilder.recordNgInject(true);
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case ABSTRACT: {
                    if (!this.jsdocBuilder.recordAbstract()) {
                        this.addTypeWarning("msg.jsdoc.incompat.type");
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case AUTHOR: {
                    if (this.jsdocBuilder.shouldParseDocumentation()) {
                        ExtractionInfo authorInfo = this.extractSingleLineBlock();
                        String author = authorInfo.string;
                        if (author.isEmpty()) {
                            this.addParserWarning("msg.jsdoc.authormissing");
                        } else {
                            this.jsdocBuilder.addAuthor(author);
                        }
                        token = authorInfo.token;
                    } else {
                        token = this.eatUntilEOLIfNotAnnotation();
                    }
                    return token;
                }
                case UNRESTRICTED: {
                    if (!this.jsdocBuilder.recordUnrestricted()) {
                        this.addTypeWarning("msg.jsdoc.incompat.type");
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case STRUCT: {
                    if (!this.jsdocBuilder.recordStruct()) {
                        this.addTypeWarning("msg.jsdoc.incompat.type");
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case DICT: {
                    if (!this.jsdocBuilder.recordDict()) {
                        this.addTypeWarning("msg.jsdoc.incompat.type");
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case CONSTRUCTOR: {
                    if (!this.jsdocBuilder.recordConstructor()) {
                        if (this.jsdocBuilder.isInterfaceRecorded()) {
                            this.addTypeWarning("msg.jsdoc.interface.constructor");
                        } else {
                            this.addTypeWarning("msg.jsdoc.incompat.type");
                        }
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case RECORD: {
                    if (!this.jsdocBuilder.recordImplicitMatch()) {
                        this.addTypeWarning("msg.jsdoc.record");
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case DEPRECATED: {
                    ExtractionInfo reasonInfo;
                    String reason;
                    if (!this.jsdocBuilder.recordDeprecated()) {
                        this.addParserWarning("msg.jsdoc.deprecated");
                    }
                    if ((reason = (reasonInfo = this.extractMultilineTextualBlock(token)).string).length() > 0) {
                        this.jsdocBuilder.recordDeprecationReason(reason);
                    }
                    token = reasonInfo.token;
                    return token;
                }
                case INTERFACE: {
                    if (!this.jsdocBuilder.recordInterface()) {
                        if (this.jsdocBuilder.isConstructorRecorded()) {
                            this.addTypeWarning("msg.jsdoc.interface.constructor");
                        } else {
                            this.addTypeWarning("msg.jsdoc.incompat.type");
                        }
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case DESC: {
                    if (this.jsdocBuilder.isDescriptionRecorded()) {
                        this.addParserWarning("msg.jsdoc.desc.extra");
                        return this.eatUntilEOLIfNotAnnotation();
                    }
                    ExtractionInfo descriptionInfo = this.extractMultilineTextualBlock(token);
                    String description = descriptionInfo.string;
                    this.jsdocBuilder.recordDescription(description);
                    token = descriptionInfo.token;
                    return token;
                }
                case FILE_OVERVIEW: {
                    String fileOverview = "";
                    if (this.jsdocBuilder.shouldParseDocumentation() && !this.lookAheadForAnnotation()) {
                        ExtractionInfo fileOverviewInfo = this.extractMultilineTextualBlock(token, this.getWhitespaceOption(WhitespaceOption.TRIM), false);
                        fileOverview = fileOverviewInfo.string;
                        token = fileOverviewInfo.token;
                    } else {
                        token = this.eatUntilEOLIfNotAnnotation();
                    }
                    if (!this.jsdocBuilder.recordFileOverview(fileOverview)) {
                        this.addParserWarning("msg.jsdoc.fileoverview.extra");
                    }
                    return token;
                }
                case LICENSE: 
                case PRESERVE: {
                    ExtractionInfo preserveInfo = this.extractMultilineTextualBlock(token, WhitespaceOption.PRESERVE, true);
                    String preserve = preserveInfo.string;
                    if (preserve.length() > 0 && this.fileLevelJsDocBuilder != null) {
                        this.fileLevelJsDocBuilder.addLicense(preserve);
                    }
                    token = preserveInfo.token;
                    return token;
                }
                case ENUM: {
                    token = this.next();
                    lineno = this.stream.getLineno();
                    charno = this.stream.getCharno();
                    JSTypeExpression type = null;
                    if (token != JsDocToken.EOL && token != JsDocToken.EOC) {
                        String typeName;
                        Node typeNode = this.parseAndRecordTypeNode(token);
                        if (typeNode != null && typeNode.isString() && !primitiveTypes.contains(typeName = typeNode.getString())) {
                            typeNode = this.wrapNode(Token.BANG, typeNode);
                        }
                        type = this.createJSTypeExpression(typeNode);
                    } else {
                        this.restoreLookAhead(token);
                    }
                    if (type == null) {
                        type = this.createJSTypeExpression(this.newStringNode("number"));
                    }
                    if (!this.jsdocBuilder.recordEnumParameterType(type)) {
                        this.addTypeWarning("msg.jsdoc.incompat.type", lineno, charno);
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case EXPOSE: {
                    if (!this.jsdocBuilder.recordExpose()) {
                        this.addParserWarning("msg.jsdoc.expose");
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case EXTERNS: {
                    if (!this.jsdocBuilder.recordExterns()) {
                        this.addParserWarning("msg.jsdoc.externs");
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case TYPE_SUMMARY: {
                    if (!this.jsdocBuilder.recordTypeSummary()) {
                        this.addParserWarning("msg.jsdoc.typesummary");
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case EXTENDS: 
                case IMPLEMENTS: {
                    this.skipEOLs();
                    token = this.next();
                    lineno = this.stream.getLineno();
                    charno = this.stream.getCharno();
                    boolean matchingRc = false;
                    if (token == JsDocToken.LEFT_CURLY) {
                        token = this.next();
                        matchingRc = true;
                    }
                    if (token == JsDocToken.STRING) {
                        Node typeNode = this.parseAndRecordTypeNameNode(token, lineno, charno, matchingRc);
                        lineno = this.stream.getLineno();
                        charno = this.stream.getCharno();
                        typeNode = this.wrapNode(Token.BANG, typeNode);
                        JSTypeExpression type = this.createJSTypeExpression(typeNode);
                        if (annotation == Annotation.EXTENDS) {
                            extendedTypes.add(new ExtendedTypeInfo(type, this.stream.getLineno(), this.stream.getCharno()));
                        } else {
                            Preconditions.checkState(annotation == Annotation.IMPLEMENTS);
                            if (!this.jsdocBuilder.recordImplementedInterface(type)) {
                                this.addTypeWarning("msg.jsdoc.implements.duplicate", lineno, charno);
                            }
                        }
                        token = this.next();
                        if (matchingRc) {
                            if (token != JsDocToken.RIGHT_CURLY) {
                                this.addTypeWarning("msg.jsdoc.missing.rc");
                            } else {
                                token = this.next();
                            }
                        } else if (token != JsDocToken.EOL && token != JsDocToken.EOF && token != JsDocToken.EOC) {
                            this.addTypeWarning("msg.end.annotation.expected");
                        }
                    } else if (token == JsDocToken.BANG || token == JsDocToken.QMARK) {
                        this.addTypeWarning("msg.jsdoc.implements.extraqualifier", lineno, charno);
                    } else {
                        this.addTypeWarning("msg.no.type.name", lineno, charno);
                    }
                    token = this.eatUntilEOLIfNotAnnotation(token);
                    return token;
                }
                case HIDDEN: {
                    if (!this.jsdocBuilder.recordHiddenness()) {
                        this.addParserWarning("msg.jsdoc.hidden");
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case LENDS: {
                    this.skipEOLs();
                    boolean matchingRc = false;
                    if (this.match(JsDocToken.LEFT_CURLY)) {
                        token = this.next();
                        matchingRc = true;
                    }
                    if (this.match(JsDocToken.STRING)) {
                        token = this.next();
                        if (!this.jsdocBuilder.recordLends(this.createJSTypeExpression(IR.string(this.stream.getString())))) {
                            this.addTypeWarning("msg.jsdoc.lends.incompatible");
                        }
                    } else {
                        this.addTypeWarning("msg.jsdoc.lends.missing");
                    }
                    if (matchingRc && !this.match(JsDocToken.RIGHT_CURLY)) {
                        this.addTypeWarning("msg.jsdoc.missing.rc");
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case MEANING: {
                    ExtractionInfo meaningInfo = this.extractMultilineTextualBlock(token);
                    String meaning = meaningInfo.string;
                    token = meaningInfo.token;
                    if (!this.jsdocBuilder.recordMeaning(meaning)) {
                        this.addParserWarning("msg.jsdoc.meaning.extra");
                    }
                    return token;
                }
                case CLOSURE_PRIMITIVE: {
                    this.skipEOLs();
                    return this.parseClosurePrimitiveTag(this.next());
                }
                case NO_COMPILE: {
                    if (!this.jsdocBuilder.recordNoCompile()) {
                        this.addParserWarning("msg.jsdoc.nocompile");
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case NO_COLLAPSE: {
                    if (!this.jsdocBuilder.recordNoCollapse()) {
                        this.addParserWarning("msg.jsdoc.nocollapse");
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case NO_INLINE: {
                    if (!this.jsdocBuilder.recordNoInline()) {
                        this.addParserWarning("msg.jsdoc.noinline");
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case NOT_IMPLEMENTED: {
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case INHERIT_DOC: 
                case OVERRIDE: {
                    if (!this.jsdocBuilder.recordOverride()) {
                        this.addTypeWarning("msg.jsdoc.override");
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case POLYMER: {
                    if (this.jsdocBuilder.isPolymerRecorded()) {
                        this.addParserWarning("msg.jsdoc.polymer.extra");
                    } else {
                        this.jsdocBuilder.recordPolymer();
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case POLYMER_BEHAVIOR: {
                    if (this.jsdocBuilder.isPolymerBehaviorRecorded()) {
                        this.addParserWarning("msg.jsdoc.polymerBehavior.extra");
                    } else {
                        this.jsdocBuilder.recordPolymerBehavior();
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case CUSTOM_ELEMENT: {
                    if (this.jsdocBuilder.isCustomElementRecorded()) {
                        this.addParserWarning("msg.jsdoc.customElement.extra");
                    } else {
                        this.jsdocBuilder.recordCustomElement();
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case MIXIN_CLASS: {
                    if (this.jsdocBuilder.isMixinClassRecorded()) {
                        this.addParserWarning("msg.jsdoc.mixinClass.extra");
                    } else {
                        this.jsdocBuilder.recordMixinClass();
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case MIXIN_FUNCTION: {
                    if (this.jsdocBuilder.isMixinFunctionRecorded()) {
                        this.addParserWarning("msg.jsdoc.mixinFunction.extra");
                    } else {
                        this.jsdocBuilder.recordMixinFunction();
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case THROWS: {
                    this.skipEOLs();
                    token = this.next();
                    lineno = this.stream.getLineno();
                    charno = this.stream.getCharno();
                    JSTypeExpression type = null;
                    if (token == JsDocToken.LEFT_CURLY && (type = this.createJSTypeExpression(this.parseAndRecordTypeNode(token))) == null) {
                        return this.eatUntilEOLIfNotAnnotation();
                    }
                    token = this.current();
                    this.jsdocBuilder.recordThrowType(type);
                    boolean isAnnotationNext = this.lookAheadForAnnotation();
                    if (this.jsdocBuilder.shouldParseDocumentation() && !isAnnotationNext) {
                        ExtractionInfo descriptionInfo = this.extractMultilineTextualBlock(token);
                        String description = descriptionInfo.string;
                        if (description.length() > 0) {
                            this.jsdocBuilder.recordThrowDescription(type, description);
                        }
                        token = descriptionInfo.token;
                    } else {
                        token = this.eatUntilEOLIfNotAnnotation();
                    }
                    return token;
                }
                case PARAM: {
                    boolean isBracketedParam;
                    this.skipEOLs();
                    token = this.next();
                    lineno = this.stream.getLineno();
                    charno = this.stream.getCharno();
                    JSTypeExpression type = null;
                    boolean hasParamType = false;
                    if (token == JsDocToken.LEFT_CURLY) {
                        type = this.createJSTypeExpression(this.parseAndRecordParamTypeNode(token));
                        if (type == null) {
                            return this.eatUntilEOLIfNotAnnotation();
                        }
                        this.skipEOLs();
                        token = this.next();
                        lineno = this.stream.getLineno();
                        charno = this.stream.getCharno();
                        hasParamType = true;
                    }
                    String name = null;
                    boolean bl = isBracketedParam = JsDocToken.LEFT_SQUARE == token;
                    if (isBracketedParam) {
                        token = this.next();
                    }
                    if (JsDocToken.STRING != token) {
                        this.addTypeWarning("msg.missing.variable.name", lineno, charno);
                    } else {
                        if (!hasParamType) {
                            this.addMissingTypeWarning(this.stream.getLineno(), this.stream.getCharno());
                        }
                        name = this.stream.getString();
                        if (isBracketedParam) {
                            token = this.next();
                            if (JsDocToken.EQUALS == token && JsDocToken.STRING == (token = this.next())) {
                                token = this.next();
                            }
                            if (JsDocToken.RIGHT_SQUARE != token) {
                                this.reportTypeSyntaxWarning("msg.jsdoc.missing.rb");
                            } else if (type != null) {
                                type = JSTypeExpression.makeOptionalArg(type);
                            }
                        }
                        if (!TokenStream.isJSIdentifier(name)) {
                            this.addParserWarning("msg.invalid.variable.name", name, lineno, charno);
                            name = null;
                        } else if (!this.jsdocBuilder.recordParameter(name, type)) {
                            if (this.jsdocBuilder.hasParameter(name)) {
                                this.addTypeWarning("msg.dup.variable.name", name, lineno, charno);
                            } else {
                                this.addTypeWarning("msg.jsdoc.incompat.type", name, lineno, charno);
                            }
                        }
                    }
                    if (name == null) {
                        token = this.eatUntilEOLIfNotAnnotation(token);
                        return token;
                    }
                    this.jsdocBuilder.markName(name, this.templateNode, lineno, charno);
                    if (this.jsdocBuilder.shouldParseDocumentation() && token != JsDocToken.ANNOTATION) {
                        ExtractionInfo paramDescriptionInfo = this.extractMultilineTextualBlock(token);
                        String paramDescription = paramDescriptionInfo.string;
                        if (paramDescription.length() > 0) {
                            this.jsdocBuilder.recordParameterDescription(name, paramDescription);
                        }
                        token = paramDescriptionInfo.token;
                    } else if (token != JsDocToken.EOC && token != JsDocToken.EOF) {
                        token = this.eatUntilEOLIfNotAnnotation();
                    }
                    return token;
                }
                case NO_SIDE_EFFECTS: {
                    if (!this.jsdocBuilder.recordNoSideEffects()) {
                        this.addParserWarning("msg.jsdoc.nosideeffects");
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case MODIFIES: {
                    token = this.parseModifiesTag(this.next());
                    return token;
                }
                case IMPLICIT_CAST: {
                    if (!this.jsdocBuilder.recordImplicitCast()) {
                        this.addTypeWarning("msg.jsdoc.implicitcast");
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case SEE: {
                    if (this.jsdocBuilder.shouldParseDocumentation()) {
                        ExtractionInfo referenceInfo = this.extractSingleLineBlock();
                        String reference = referenceInfo.string;
                        if (reference.isEmpty()) {
                            this.addParserWarning("msg.jsdoc.seemissing");
                        } else {
                            this.jsdocBuilder.addReference(reference);
                        }
                        token = referenceInfo.token;
                    } else {
                        token = this.eatUntilEOLIfNotAnnotation();
                    }
                    return token;
                }
                case SUPPRESS: {
                    token = this.parseSuppressTag(this.next());
                    return token;
                }
                case TEMPLATE: {
                    int templateLineno = this.stream.getLineno();
                    int templateCharno = this.stream.getCharno();
                    ExtractionInfo templateInfo = this.extractMultilineTextualBlock(token, WhitespaceOption.TRIM, false);
                    String templateString = templateInfo.string;
                    String ttlStartDelimiter = ":=";
                    String ttlEndDelimiter = "=:";
                    String typeTransformationExpr = "";
                    boolean isTypeTransformation = false;
                    boolean validTypeTransformation = true;
                    if (templateString.isEmpty() || templateString.charAt(0) != '{') {
                        String templateNames;
                        if (!templateString.contains(ttlStartDelimiter)) {
                            templateNames = templateString.contains("\n") ? templateString.substring(0, templateString.indexOf(10)) : templateString;
                        } else {
                            int ttlStartIndex = templateString.indexOf(ttlStartDelimiter);
                            templateNames = templateString.substring(0, ttlStartIndex);
                            if (!templateString.contains(ttlEndDelimiter)) {
                                validTypeTransformation = false;
                                this.addTypeWarning("msg.jsdoc.typetransformation.missing.delimiter", templateLineno, templateCharno);
                            } else {
                                isTypeTransformation = true;
                                int ttlEndIndex = templateString.indexOf(ttlEndDelimiter);
                                typeTransformationExpr = templateString.substring(ttlStartIndex + ttlStartDelimiter.length(), ttlEndIndex).trim();
                            }
                        }
                        List<String> names = Splitter.on(',').trimResults().splitToList(templateNames);
                        if (names.size() == 1 && names.get(0).isEmpty()) {
                            this.addTypeWarning("msg.jsdoc.templatemissing", templateLineno, templateCharno);
                        } else {
                            for (String typeName : names) {
                                if (!JsDocInfoParser.validTemplateTypeName(typeName)) {
                                    this.addTypeWarning("msg.jsdoc.template.invalid.type.name", templateLineno, templateCharno);
                                    continue;
                                }
                                if (isTypeTransformation || this.jsdocBuilder.recordTemplateTypeName(typeName)) continue;
                                this.addTypeWarning("msg.jsdoc.template.name.declared.twice", templateLineno, templateCharno);
                            }
                        }
                        if (isTypeTransformation) {
                            TypeTransformationParser ttlParser;
                            if (names.size() > 1) {
                                this.addTypeWarning("msg.jsdoc.typetransformation.with.multiple.names", templateLineno, templateCharno);
                            }
                            if (typeTransformationExpr.isEmpty()) {
                                validTypeTransformation = false;
                                this.addTypeWarning("msg.jsdoc.typetransformation.expression.missing", templateLineno, templateCharno);
                            }
                            if (validTypeTransformation && (ttlParser = new TypeTransformationParser(typeTransformationExpr, this.getSourceFile(), this.errorReporter, templateLineno, templateCharno)).parseTypeTransformation() && !this.jsdocBuilder.recordTypeTransformation(names.get(0), ttlParser.getTypeTransformationAst())) {
                                this.addTypeWarning("msg.jsdoc.template.name.declared.twice", templateLineno, templateCharno);
                            }
                        }
                        token = templateInfo.token;
                    } else {
                        List<String> genericDecl = Splitter.on("}").trimResults().splitToList(templateString);
                        this.addParserWarning("msg.jsdoc.template.boundedgenerics");
                        if (templateString.contains(",")) {
                            this.addParserWarning("msg.jsdoc.template.multipletemplates");
                        }
                        if (genericDecl.size() != 2) {
                            this.addTypeWarning("msg.jsdoc.template.invalid.type.name", templateLineno, templateCharno);
                            return templateInfo.token;
                        }
                        String genericBound = genericDecl.get(0).substring(1);
                        String genericName = genericDecl.get(1);
                        Node typeNode = JsDocInfoParser.parseTypeString(genericBound);
                        if (typeNode == null) {
                            this.addTypeWarning("msg.jsdoc.template.boundtypeexpr", templateLineno, templateCharno);
                            return templateInfo.token;
                        }
                        JSTypeExpression typeExpr = this.createJSTypeExpression(typeNode);
                        if (!JsDocInfoParser.validTemplateTypeName(genericName)) {
                            this.addTypeWarning("msg.jsdoc.template.invalid.type.name", templateLineno, templateCharno);
                        }
                        if (!this.jsdocBuilder.recordTemplateTypeName(genericName, typeExpr)) {
                            this.addTypeWarning("msg.jsdoc.template.name.declared.twice", templateLineno, templateCharno);
                        }
                        token = templateInfo.token;
                    }
                    return token;
                }
                case IDGENERATOR: {
                    token = this.parseIdGeneratorTag(this.next());
                    return token;
                }
                case WIZACTION: {
                    if (!this.jsdocBuilder.recordWizaction()) {
                        this.addParserWarning("msg.jsdoc.wizaction");
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
                case VERSION: {
                    ExtractionInfo versionInfo = this.extractSingleLineBlock();
                    String version = versionInfo.string;
                    if (version.isEmpty()) {
                        this.addParserWarning("msg.jsdoc.versionmissing");
                    } else if (!this.jsdocBuilder.recordVersion(version)) {
                        this.addParserWarning("msg.jsdoc.extraversion");
                    }
                    token = versionInfo.token;
                    return token;
                }
                case CONSTANT: 
                case FINAL: 
                case DEFINE: 
                case EXPORT: 
                case PRIVATE: 
                case PACKAGE: 
                case PROTECTED: 
                case PUBLIC: 
                case RETURN: 
                case THIS: 
                case TYPEDEF: 
                case TYPE: {
                    boolean hasError;
                    lineno = this.stream.getLineno();
                    charno = this.stream.getCharno();
                    Node typeNode = null;
                    boolean hasType = this.lookAheadForType();
                    boolean isAlternateTypeAnnotation = annotation == Annotation.PACKAGE || annotation == Annotation.PRIVATE || annotation == Annotation.PROTECTED || annotation == Annotation.PUBLIC || annotation == Annotation.CONSTANT || annotation == Annotation.FINAL || annotation == Annotation.EXPORT;
                    boolean canSkipTypeAnnotation = isAlternateTypeAnnotation || annotation == Annotation.RETURN;
                    JSTypeExpression type = null;
                    if (annotation == Annotation.RETURN && !hasType) {
                        this.addMissingTypeWarning(this.stream.getLineno(), this.stream.getCharno());
                    }
                    if (hasType || !canSkipTypeAnnotation) {
                        this.skipEOLs();
                        token = this.next();
                        typeNode = this.parseAndRecordTypeNode(token);
                        if (annotation == Annotation.THIS) {
                            typeNode = this.wrapNode(Token.BANG, typeNode);
                        }
                        type = this.createJSTypeExpression(typeNode);
                    }
                    boolean bl = hasError = type == null && !canSkipTypeAnnotation;
                    if (!hasError) {
                        if ((type != null && isAlternateTypeAnnotation || annotation == Annotation.TYPE) && !this.jsdocBuilder.recordType(type)) {
                            this.addTypeWarning("msg.jsdoc.incompat.type", lineno, charno);
                        }
                        boolean isAnnotationNext = this.lookAheadForAnnotation();
                        switch (annotation) {
                            case CONSTANT: {
                                if (this.jsdocBuilder.recordConstancy()) break;
                                this.addParserWarning("msg.jsdoc.const");
                                break;
                            }
                            case FINAL: {
                                if (this.jsdocBuilder.recordFinality()) break;
                                this.addTypeWarning("msg.jsdoc.final");
                                break;
                            }
                            case DEFINE: {
                                if (!this.jsdocBuilder.recordDefineType(type)) {
                                    this.addParserWarning("msg.jsdoc.define", lineno, charno);
                                }
                                if (isAnnotationNext) break;
                                return this.recordDescription(token);
                            }
                            case EXPORT: {
                                if (!this.jsdocBuilder.recordExport()) {
                                    this.addParserWarning("msg.jsdoc.export", lineno, charno);
                                } else if (!this.jsdocBuilder.recordVisibility(JSDocInfo.Visibility.PUBLIC)) {
                                    this.addParserWarning("msg.jsdoc.extra.visibility", lineno, charno);
                                }
                                if (isAnnotationNext) break;
                                return this.recordDescription(token);
                            }
                            case PRIVATE: {
                                if (!this.jsdocBuilder.recordVisibility(JSDocInfo.Visibility.PRIVATE)) {
                                    this.addParserWarning("msg.jsdoc.extra.visibility", lineno, charno);
                                }
                                if (isAnnotationNext) break;
                                return this.recordDescription(token);
                            }
                            case PACKAGE: {
                                if (!this.jsdocBuilder.recordVisibility(JSDocInfo.Visibility.PACKAGE)) {
                                    this.addParserWarning("msg.jsdoc.extra.visibility", lineno, charno);
                                }
                                if (isAnnotationNext) break;
                                return this.recordDescription(token);
                            }
                            case PROTECTED: {
                                if (!this.jsdocBuilder.recordVisibility(JSDocInfo.Visibility.PROTECTED)) {
                                    this.addParserWarning("msg.jsdoc.extra.visibility", lineno, charno);
                                }
                                if (isAnnotationNext) break;
                                return this.recordDescription(token);
                            }
                            case PUBLIC: {
                                if (!this.jsdocBuilder.recordVisibility(JSDocInfo.Visibility.PUBLIC)) {
                                    this.addParserWarning("msg.jsdoc.extra.visibility", lineno, charno);
                                }
                                if (isAnnotationNext) break;
                                return this.recordDescription(token);
                            }
                            case RETURN: {
                                if (type == null) {
                                    type = this.createJSTypeExpression(this.newNode(Token.QMARK));
                                }
                                if (!this.jsdocBuilder.recordReturnType(type)) {
                                    this.addTypeWarning("msg.jsdoc.incompat.type", lineno, charno);
                                    break;
                                }
                                if (this.jsdocBuilder.shouldParseDocumentation() && !isAnnotationNext) {
                                    ExtractionInfo returnDescriptionInfo = this.extractMultilineTextualBlock(token);
                                    String returnDescription = returnDescriptionInfo.string;
                                    if (returnDescription.length() > 0) {
                                        this.jsdocBuilder.recordReturnDescription(returnDescription);
                                    }
                                    token = returnDescriptionInfo.token;
                                } else {
                                    token = this.eatUntilEOLIfNotAnnotation();
                                }
                                return token;
                            }
                            case THIS: {
                                if (this.jsdocBuilder.recordThisType(type)) break;
                                this.addTypeWarning("msg.jsdoc.incompat.type", lineno, charno);
                                break;
                            }
                            case TYPEDEF: {
                                if (this.jsdocBuilder.recordTypedef(type)) break;
                                this.addTypeWarning("msg.jsdoc.incompat.type", lineno, charno);
                                break;
                            }
                        }
                    }
                    return this.eatUntilEOLIfNotAnnotation();
                }
            }
        }
        return this.next();
    }

    private static boolean validTemplateTypeName(String name) {
        return !name.isEmpty() && CharMatcher.javaLetterOrDigit().or(CharMatcher.is('_')).matchesAllOf(name);
    }

    private JsDocToken recordDescription(JsDocToken token) {
        if (this.jsdocBuilder.shouldParseDocumentation()) {
            ExtractionInfo descriptionInfo = this.extractMultilineTextualBlock(token);
            token = descriptionInfo.token;
        } else {
            token = this.eatTokensUntilEOL(token);
        }
        return token;
    }

    private void checkExtendedTypes(List<ExtendedTypeInfo> extendedTypes) {
        for (ExtendedTypeInfo typeInfo : extendedTypes) {
            if (this.jsdocBuilder.isInterfaceRecorded()) {
                if (this.jsdocBuilder.recordExtendedInterface(typeInfo.type)) continue;
                this.addParserWarning("msg.jsdoc.extends.duplicate", typeInfo.lineno, typeInfo.charno);
                continue;
            }
            if (this.jsdocBuilder.recordBaseType(typeInfo.type)) continue;
            this.addTypeWarning("msg.jsdoc.incompat.type", typeInfo.lineno, typeInfo.charno);
        }
    }

    private JsDocToken parseSuppressTag(JsDocToken token) {
        if (token != JsDocToken.LEFT_CURLY) {
            this.addParserWarning("msg.jsdoc.suppress");
            return token;
        }
        HashSet<String> suppressions = new HashSet<String>();
        while (true) {
            if (this.match(JsDocToken.STRING)) {
                String name = this.stream.getString();
                if (!this.suppressionNames.contains(name)) {
                    this.addParserWarning("msg.jsdoc.suppress.unknown", name);
                }
            } else {
                this.addParserWarning("msg.jsdoc.suppress");
                return token;
            }
            suppressions.add(this.stream.getString());
            token = this.next();
            if (!this.match(JsDocToken.PIPE, JsDocToken.COMMA)) break;
            token = this.next();
        }
        if (!this.match(JsDocToken.RIGHT_CURLY)) {
            this.addParserWarning("msg.jsdoc.suppress");
        } else {
            token = this.next();
            this.jsdocBuilder.recordSuppressions(suppressions);
        }
        return this.eatUntilEOLIfNotAnnotation();
    }

    private JsDocToken parseClosurePrimitiveTag(JsDocToken token) {
        if (token != JsDocToken.LEFT_CURLY) {
            this.addParserWarning("msg.jsdoc.missing.lc");
            return token;
        }
        if (this.match(JsDocToken.STRING)) {
            String name = this.stream.getString();
            if (!this.closurePrimitiveNames.contains(name)) {
                this.addParserWarning("msg.jsdoc.closurePrimitive.invalid", name);
            } else if (!this.jsdocBuilder.recordClosurePrimitiveId(name)) {
                this.addParserWarning("msg.jsdoc.closurePrimitive.extra");
            }
        } else {
            this.addParserWarning("msg.jsdoc.closurePrimitive.missing");
            return token;
        }
        token = this.next();
        if (!this.match(JsDocToken.RIGHT_CURLY)) {
            this.addParserWarning("msg.jsdoc.missing.rc");
        } else {
            token = this.next();
        }
        return this.eatUntilEOLIfNotAnnotation();
    }

    private JsDocToken parseModifiesTag(JsDocToken token) {
        if (token == JsDocToken.LEFT_CURLY) {
            HashSet<String> modifies = new HashSet<String>();
            while (true) {
                if (this.match(JsDocToken.STRING)) {
                    String name = this.stream.getString();
                    if (!modifiesAnnotationKeywords.contains(name) && !this.jsdocBuilder.hasParameter(name)) {
                        this.addParserWarning("msg.jsdoc.modifies.unknown", name);
                    }
                } else {
                    this.addParserWarning("msg.jsdoc.modifies");
                    return token;
                }
                modifies.add(this.stream.getString());
                token = this.next();
                if (!this.match(JsDocToken.PIPE)) break;
                token = this.next();
            }
            if (!this.match(JsDocToken.RIGHT_CURLY)) {
                this.addParserWarning("msg.jsdoc.modifies");
            } else {
                token = this.next();
                if (!this.jsdocBuilder.recordModifies(modifies)) {
                    this.addParserWarning("msg.jsdoc.modifies.duplicate");
                }
            }
        }
        return token;
    }

    private JsDocToken parseIdGeneratorTag(JsDocToken token) {
        String idgenKind = "unique";
        if (token == JsDocToken.LEFT_CURLY) {
            String name;
            if (this.match(JsDocToken.STRING)) {
                name = this.stream.getString();
                if (!idGeneratorAnnotationKeywords.contains(name) && !this.jsdocBuilder.hasParameter(name)) {
                    this.addParserWarning("msg.jsdoc.idgen.unknown", name);
                }
            } else {
                this.addParserWarning("msg.jsdoc.idgen.bad");
                return token;
            }
            idgenKind = name;
            token = this.next();
            if (!this.match(JsDocToken.RIGHT_CURLY)) {
                this.addParserWarning("msg.jsdoc.idgen.bad");
            } else {
                token = this.next();
            }
        }
        switch (idgenKind) {
            case "unique": {
                if (this.jsdocBuilder.recordIdGenerator()) break;
                this.addParserWarning("msg.jsdoc.idgen.duplicate");
                break;
            }
            case "consistent": {
                if (this.jsdocBuilder.recordConsistentIdGenerator()) break;
                this.addParserWarning("msg.jsdoc.idgen.duplicate");
                break;
            }
            case "stable": {
                if (this.jsdocBuilder.recordStableIdGenerator()) break;
                this.addParserWarning("msg.jsdoc.idgen.duplicate");
                break;
            }
            case "xid": {
                if (this.jsdocBuilder.recordXidGenerator()) break;
                this.addParserWarning("msg.jsdoc.idgen.duplicate");
                break;
            }
            case "mapped": {
                if (this.jsdocBuilder.recordMappedIdGenerator()) break;
                this.addParserWarning("msg.jsdoc.idgen.duplicate");
            }
        }
        return token;
    }

    Node parseAndRecordTypeNode(JsDocToken token) {
        return this.parseAndRecordTypeNode(token, this.stream.getLineno(), this.stream.getCharno(), token == JsDocToken.LEFT_CURLY, false);
    }

    private Node parseAndRecordTypeNode(JsDocToken token, int lineno, int startCharno, boolean matchingLC, boolean onlyParseSimpleNames) {
        Node typeNode = onlyParseSimpleNames ? this.parseTypeNameAnnotation(token) : this.parseTypeExpressionAnnotation(token);
        this.recordTypeNode(lineno, startCharno, typeNode, matchingLC);
        return typeNode;
    }

    private Node parseAndRecordTypeNameNode(JsDocToken token, int lineno, int startCharno, boolean matchingLC) {
        return this.parseAndRecordTypeNode(token, lineno, startCharno, matchingLC, true);
    }

    private Node parseAndRecordParamTypeNode(JsDocToken token) {
        Preconditions.checkArgument(token == JsDocToken.LEFT_CURLY);
        int lineno = this.stream.getLineno();
        int startCharno = this.stream.getCharno();
        Node typeNode = this.parseParamTypeExpressionAnnotation(token);
        this.recordTypeNode(lineno, startCharno, typeNode, true);
        return typeNode;
    }

    private String toString(JsDocToken token) {
        switch (token) {
            case ANNOTATION: {
                return "@" + this.stream.getString();
            }
            case BANG: {
                return "!";
            }
            case COMMA: {
                return ",";
            }
            case COLON: {
                return ":";
            }
            case RIGHT_ANGLE: {
                return ">";
            }
            case LEFT_SQUARE: {
                return "[";
            }
            case LEFT_CURLY: {
                return "{";
            }
            case LEFT_PAREN: {
                return "(";
            }
            case LEFT_ANGLE: {
                return "<";
            }
            case QMARK: {
                return "?";
            }
            case PIPE: {
                return "|";
            }
            case RIGHT_SQUARE: {
                return "]";
            }
            case RIGHT_CURLY: {
                return "}";
            }
            case RIGHT_PAREN: {
                return ")";
            }
            case STAR: {
                return "*";
            }
            case ITER_REST: {
                return "...";
            }
            case EQUALS: {
                return "=";
            }
            case STRING: {
                return this.stream.getString();
            }
        }
        throw new IllegalStateException(token.toString());
    }

    JSTypeExpression createJSTypeExpression(Node n) {
        return n == null ? null : new JSTypeExpression(n, this.getSourceName());
    }

    private ExtractionInfo extractSingleLineBlock() {
        this.stream.update();
        int lineno = this.stream.getLineno();
        int charno = this.stream.getCharno() + 1;
        String line = this.getRemainingJSDocLine().trim();
        if (line.length() > 0) {
            this.jsdocBuilder.markText(line, lineno, charno, lineno, charno + line.length());
        }
        return new ExtractionInfo(line, this.next());
    }

    private ExtractionInfo extractMultilineTextualBlock(JsDocToken token) {
        return this.extractMultilineTextualBlock(token, this.getWhitespaceOption(WhitespaceOption.SINGLE_LINE), false);
    }

    private ExtractionInfo extractMultilineTextualBlock(JsDocToken token, WhitespaceOption option, boolean includeAnnotations) {
        if (token == JsDocToken.EOC || token == JsDocToken.EOL || token == JsDocToken.EOF) {
            return new ExtractionInfo("", token);
        }
        return this.extractMultilineComment(token, option, true, includeAnnotations);
    }

    private WhitespaceOption getWhitespaceOption(WhitespaceOption defaultValue) {
        return this.preserveWhitespace ? WhitespaceOption.PRESERVE : defaultValue;
    }

    private ExtractionInfo extractBlockComment(JsDocToken token) {
        return this.extractMultilineComment(token, this.getWhitespaceOption(WhitespaceOption.TRIM), false, false);
    }

    private ExtractionInfo extractMultilineComment(JsDocToken token, WhitespaceOption option, boolean isMarker, boolean includeAnnotations) {
        StringBuilder builder = new StringBuilder();
        int startLineno = -1;
        int startCharno = -1;
        if (isMarker) {
            this.stream.update();
            startLineno = this.stream.getLineno();
            startCharno = this.stream.getCharno() + 1;
            String line = this.getRemainingJSDocLine();
            if (option != WhitespaceOption.PRESERVE) {
                line = line.trim();
            }
            builder.append(line);
            this.state = State.SEARCHING_ANNOTATION;
            token = this.next();
        }
        boolean ignoreStar = false;
        int lineStartChar = -1;
        block4: while (true) {
            boolean isEOC;
            switch (token) {
                case STAR: {
                    if (ignoreStar) {
                        lineStartChar = this.stream.getCharno() + 1;
                        ignoreStar = false;
                    } else {
                        this.padLine(builder, lineStartChar, option);
                        lineStartChar = -1;
                        builder.append('*');
                    }
                    token = this.next();
                    while (true) {
                        if (token != JsDocToken.STAR) continue block4;
                        if (lineStartChar != -1) {
                            this.padLine(builder, lineStartChar, option);
                            lineStartChar = -1;
                        }
                        builder.append('*');
                        token = this.next();
                    }
                }
                case EOL: {
                    if (option != WhitespaceOption.SINGLE_LINE) {
                        builder.append('\n');
                    }
                    ignoreStar = true;
                    lineStartChar = 0;
                    token = this.next();
                    continue block4;
                }
            }
            ignoreStar = false;
            this.state = State.SEARCHING_ANNOTATION;
            boolean bl = isEOC = token == JsDocToken.EOC;
            if (!isEOC) {
                this.padLine(builder, lineStartChar, option);
                lineStartChar = -1;
            }
            if (token == JsDocToken.EOC || token == JsDocToken.EOF || token == JsDocToken.ANNOTATION && !includeAnnotations) {
                String multilineText = builder.toString();
                if (option != WhitespaceOption.PRESERVE) {
                    multilineText = multilineText.trim();
                }
                if (isMarker && !multilineText.isEmpty()) {
                    int endLineno = this.stream.getLineno();
                    int endCharno = this.stream.getCharno();
                    this.jsdocBuilder.markText(multilineText, startLineno, startCharno, endLineno, endCharno);
                }
                return new ExtractionInfo(multilineText, token);
            }
            builder.append(this.toString(token));
            String line = this.getRemainingJSDocLine();
            if (option != WhitespaceOption.PRESERVE) {
                line = JsDocInfoParser.trimEnd(line);
            }
            builder.append(line);
            token = this.next();
        }
    }

    private void padLine(StringBuilder builder, int lineStartChar, WhitespaceOption option) {
        if (lineStartChar != -1 && option == WhitespaceOption.PRESERVE) {
            int numSpaces = this.stream.getCharno() - lineStartChar;
            for (int i = 0; i < numSpaces; ++i) {
                builder.append(' ');
            }
        } else if (builder.length() > 0 && (builder.charAt(builder.length() - 1) != '\n' || option == WhitespaceOption.PRESERVE)) {
            builder.append(' ');
        }
    }

    private static String trimEnd(String s) {
        char ch;
        int trimCount;
        for (trimCount = 0; trimCount < s.length() && TokenUtil.isWhitespace(ch = s.charAt(s.length() - trimCount - 1)); ++trimCount) {
        }
        if (trimCount == 0) {
            return s;
        }
        return s.substring(0, s.length() - trimCount);
    }

    private Node parseTypeExpressionAnnotation(JsDocToken token) {
        if (token == JsDocToken.LEFT_CURLY) {
            this.skipEOLs();
            Node typeNode = this.parseTopLevelTypeExpression(this.next());
            if (typeNode != null) {
                this.skipEOLs();
                if (!this.match(JsDocToken.RIGHT_CURLY)) {
                    if (typeNode.isString() && "import".equals(typeNode.getString())) {
                        this.reportTypeSyntaxWarning("msg.jsdoc.import");
                    } else {
                        this.reportTypeSyntaxWarning("msg.jsdoc.missing.rc");
                    }
                } else {
                    this.next();
                }
            }
            return typeNode;
        }
        this.reportTypeSyntaxWarning("msg.jsdoc.missing.braces");
        return this.parseTypeExpression(token);
    }

    private Node parseParamTypeExpression(JsDocToken token) {
        Node typeNode;
        boolean restArg = false;
        if (token == JsDocToken.ITER_REST) {
            token = this.next();
            if (token == JsDocToken.RIGHT_CURLY) {
                this.restoreLookAhead(token);
                return this.wrapNode(Token.ITER_REST, IR.empty());
            }
            restArg = true;
        }
        if ((typeNode = this.parseTopLevelTypeExpression(token)) != null) {
            this.skipEOLs();
            if (restArg) {
                typeNode = this.wrapNode(Token.ITER_REST, typeNode);
            } else if (this.match(JsDocToken.EQUALS)) {
                this.next();
                this.skipEOLs();
                typeNode = this.wrapNode(Token.EQUALS, typeNode);
            }
        }
        return typeNode;
    }

    private Node parseParamTypeExpressionAnnotation(JsDocToken token) {
        Preconditions.checkArgument(token == JsDocToken.LEFT_CURLY);
        this.skipEOLs();
        Node typeNode = this.parseParamTypeExpression(this.next());
        if (typeNode != null) {
            if (!this.match(JsDocToken.RIGHT_CURLY)) {
                this.reportTypeSyntaxWarning("msg.jsdoc.missing.rc");
            } else {
                this.next();
            }
        }
        return typeNode;
    }

    private Node parseTypeNameAnnotation(JsDocToken token) {
        if (token == JsDocToken.LEFT_CURLY) {
            this.skipEOLs();
            Node typeNode = this.parseTypeName(this.next());
            if (typeNode != null) {
                this.skipEOLs();
                if (!this.match(JsDocToken.RIGHT_CURLY)) {
                    this.reportTypeSyntaxWarning("msg.jsdoc.missing.rc");
                } else {
                    this.next();
                }
            }
            return typeNode;
        }
        return this.parseTypeName(token);
    }

    private Node parseTopLevelTypeExpression(JsDocToken token) {
        Node typeExpr = this.parseTypeExpression(token);
        if (typeExpr != null && this.match(JsDocToken.PIPE)) {
            this.next();
            this.skipEOLs();
            token = this.next();
            return this.parseUnionTypeWithAlternate(token, typeExpr);
        }
        return typeExpr;
    }

    private Node parseTypeExpressionList(String typeName, JsDocToken token) {
        Node typeExpr = this.parseTopLevelTypeExpression(token);
        if (typeExpr == null) {
            return null;
        }
        Node typeList = IR.block();
        int numTypeExprs = 1;
        typeList.addChildToBack(typeExpr);
        while (this.match(JsDocToken.COMMA)) {
            this.next();
            this.skipEOLs();
            typeExpr = this.parseTopLevelTypeExpression(this.next());
            if (typeExpr == null) {
                return null;
            }
            ++numTypeExprs;
            typeList.addChildToBack(typeExpr);
        }
        if (typeName.equals("Object") && numTypeExprs == 1) {
            typeList.addChildToFront(this.newNode(Token.QMARK));
        }
        return typeList;
    }

    private Node parseTypeExpression(JsDocToken token) {
        int lineno = this.stream.getLineno();
        int charno = this.stream.getCharno();
        if (token == JsDocToken.QMARK) {
            token = this.next();
            if (token == JsDocToken.COMMA || token == JsDocToken.EQUALS || token == JsDocToken.RIGHT_SQUARE || token == JsDocToken.RIGHT_CURLY || token == JsDocToken.RIGHT_PAREN || token == JsDocToken.PIPE || token == JsDocToken.RIGHT_ANGLE || token == JsDocToken.EOC || token == JsDocToken.EOL || token == JsDocToken.EOF) {
                this.restoreLookAhead(token);
                return this.newNode(Token.QMARK);
            }
            return this.wrapNode(Token.QMARK, this.parseBasicTypeExpression(token), lineno, charno);
        }
        if (token == JsDocToken.BANG) {
            return this.wrapNode(Token.BANG, this.parseBasicTypeExpression(this.next()), lineno, charno);
        }
        Node basicTypeExpr = this.parseBasicTypeExpression(token);
        lineno = this.stream.getLineno();
        charno = this.stream.getCharno();
        if (basicTypeExpr != null) {
            if (this.match(JsDocToken.QMARK)) {
                this.next();
                return this.wrapNode(Token.QMARK, basicTypeExpr, lineno, charno);
            }
            if (this.match(JsDocToken.BANG)) {
                this.next();
                return this.wrapNode(Token.BANG, basicTypeExpr, lineno, charno);
            }
        }
        return basicTypeExpr;
    }

    private Node parseContextTypeExpression(JsDocToken token) {
        if (token == JsDocToken.QMARK) {
            return this.newNode(Token.QMARK);
        }
        return this.parseBasicTypeExpression(token);
    }

    private Node parseBasicTypeExpression(JsDocToken token) {
        if (token == JsDocToken.STAR) {
            return this.newNode(Token.STAR);
        }
        if (token == JsDocToken.LEFT_CURLY) {
            this.skipEOLs();
            return this.parseRecordType(this.next());
        }
        if (token == JsDocToken.LEFT_PAREN) {
            this.skipEOLs();
            return this.parseUnionType(this.next());
        }
        if (token == JsDocToken.STRING) {
            String string;
            switch (string = this.stream.getString()) {
                case "function": {
                    this.skipEOLs();
                    return this.parseFunctionType(this.next());
                }
                case "null": 
                case "undefined": {
                    return this.newStringNode(string);
                }
                case "typeof": {
                    this.skipEOLs();
                    return this.parseTypeofType(this.next());
                }
            }
            return this.parseTypeName(token);
        }
        this.restoreLookAhead(token);
        return this.reportGenericTypeSyntaxWarning();
    }

    private Node parseNameExpression(JsDocToken token) {
        if (token != JsDocToken.STRING) {
            return this.reportGenericTypeSyntaxWarning();
        }
        String typeName = this.stream.getString();
        int lineno = this.stream.getLineno();
        int charno = this.stream.getCharno();
        while (this.match(JsDocToken.EOL) && typeName.charAt(typeName.length() - 1) == '.') {
            this.skipEOLs();
            if (!this.match(JsDocToken.STRING)) continue;
            this.next();
            typeName = typeName + this.stream.getString();
        }
        return this.newStringNode(typeName, lineno, charno);
    }

    private Node parseTypeName(JsDocToken token) {
        Node typeNameNode = this.parseNameExpression(token);
        if (this.match(JsDocToken.LEFT_ANGLE)) {
            this.next();
            this.skipEOLs();
            Node memberType = this.parseTypeExpressionList(typeNameNode.getString(), this.next());
            if (memberType != null) {
                typeNameNode.addChildToFront(memberType);
                this.skipEOLs();
                if (!this.match(JsDocToken.RIGHT_ANGLE)) {
                    return this.reportTypeSyntaxWarning("msg.jsdoc.missing.gt");
                }
                this.next();
            }
        }
        return typeNameNode;
    }

    private Node parseTypeofType(JsDocToken token) {
        Node typeofType = this.newNode(Token.TYPEOF);
        Node name = this.parseNameExpression(token);
        this.skipEOLs();
        typeofType.addChildToFront(name);
        return typeofType;
    }

    private Node parseFunctionType(JsDocToken token) {
        if (token != JsDocToken.LEFT_PAREN) {
            this.restoreLookAhead(token);
            return this.reportTypeSyntaxWarning("msg.jsdoc.missing.lp");
        }
        Node functionType = this.newNode(Token.FUNCTION);
        Node parameters = null;
        this.skipEOLs();
        if (!this.match(JsDocToken.RIGHT_PAREN)) {
            token = this.next();
            boolean hasParams = true;
            if (token == JsDocToken.STRING) {
                String tokenStr = this.stream.getString();
                boolean isThis = "this".equals(tokenStr);
                boolean isNew = "new".equals(tokenStr);
                if (isThis || isNew) {
                    Node contextType;
                    if (this.match(JsDocToken.COLON)) {
                        this.next();
                        this.skipEOLs();
                        contextType = this.wrapNode(isThis ? Token.THIS : Token.NEW, this.parseContextTypeExpression(this.next()));
                        if (contextType == null) {
                            return null;
                        }
                    } else {
                        return this.reportTypeSyntaxWarning("msg.jsdoc.missing.colon");
                    }
                    functionType.addChildToFront(contextType);
                    if (this.match(JsDocToken.COMMA)) {
                        this.next();
                        this.skipEOLs();
                        token = this.next();
                    } else {
                        hasParams = false;
                    }
                }
            }
            if (hasParams && (parameters = this.parseParametersType(token)) == null) {
                return null;
            }
        }
        if (parameters != null) {
            functionType.addChildToBack(parameters);
        }
        this.skipEOLs();
        if (!this.match(JsDocToken.RIGHT_PAREN)) {
            return this.reportTypeSyntaxWarning("msg.jsdoc.missing.rp");
        }
        this.skipEOLs();
        this.next();
        Node resultType = this.parseResultType();
        if (resultType == null) {
            return null;
        }
        functionType.addChildToBack(resultType);
        return functionType;
    }

    private Node parseParametersType(JsDocToken token) {
        Node paramsType = this.newNode(Token.PARAM_LIST);
        boolean isVarArgs = false;
        Node paramType = null;
        if (token != JsDocToken.RIGHT_PAREN) {
            do {
                if (paramType != null) {
                    this.next();
                    this.skipEOLs();
                    token = this.next();
                }
                if (token == JsDocToken.ITER_REST) {
                    this.skipEOLs();
                    if (this.match(JsDocToken.RIGHT_PAREN)) {
                        paramType = this.newNode(Token.ITER_REST);
                    } else {
                        this.skipEOLs();
                        paramType = this.wrapNode(Token.ITER_REST, this.parseTypeExpression(this.next()));
                        this.skipEOLs();
                    }
                    isVarArgs = true;
                } else {
                    paramType = this.parseTypeExpression(token);
                    if (this.match(JsDocToken.EQUALS)) {
                        this.skipEOLs();
                        this.next();
                        paramType = this.wrapNode(Token.EQUALS, paramType);
                    }
                }
                if (paramType == null) {
                    return null;
                }
                paramsType.addChildToBack(paramType);
            } while (!isVarArgs && this.match(JsDocToken.COMMA));
        }
        if (isVarArgs && this.match(JsDocToken.COMMA)) {
            return this.reportTypeSyntaxWarning("msg.jsdoc.function.varargs");
        }
        return paramsType;
    }

    private Node parseResultType() {
        this.skipEOLs();
        if (!this.match(JsDocToken.COLON)) {
            return this.newNode(Token.EMPTY);
        }
        this.next();
        this.skipEOLs();
        if (this.match(JsDocToken.STRING) && "void".equals(this.stream.getString())) {
            this.next();
            return this.newNode(Token.VOID);
        }
        return this.parseTypeExpression(this.next());
    }

    private Node parseUnionType(JsDocToken token) {
        return this.parseUnionTypeWithAlternate(token, null);
    }

    private Node parseUnionTypeWithAlternate(JsDocToken token, Node alternate) {
        Node union = this.newNode(Token.PIPE);
        if (alternate != null) {
            union.addChildToBack(alternate);
        }
        Node expr = null;
        do {
            if (expr != null) {
                this.skipEOLs();
                token = this.next();
                Preconditions.checkState(token == JsDocToken.PIPE);
                this.skipEOLs();
                token = this.next();
            }
            if ((expr = this.parseTypeExpression(token)) == null) {
                return null;
            }
            union.addChildToBack(expr);
        } while (this.match(JsDocToken.PIPE));
        if (alternate == null) {
            this.skipEOLs();
            if (!this.match(JsDocToken.RIGHT_PAREN)) {
                return this.reportTypeSyntaxWarning("msg.jsdoc.missing.rp");
            }
            this.next();
        }
        if (union.hasOneChild()) {
            Node firstChild = union.getFirstChild();
            union.removeChild(firstChild);
            return firstChild;
        }
        return union;
    }

    private Node parseRecordType(JsDocToken token) {
        Node recordType = this.newNode(Token.LC);
        Node fieldTypeList = this.parseFieldTypeList(token);
        if (fieldTypeList == null) {
            return this.reportGenericTypeSyntaxWarning();
        }
        this.skipEOLs();
        if (!this.match(JsDocToken.RIGHT_CURLY)) {
            return this.reportTypeSyntaxWarning("msg.jsdoc.missing.rc");
        }
        this.next();
        recordType.addChildToBack(fieldTypeList);
        return recordType;
    }

    private Node parseFieldTypeList(JsDocToken token) {
        Node fieldTypeList = this.newNode(Token.LB);
        HashSet<String> names = new HashSet<String>();
        while (true) {
            String name;
            Node fieldType;
            if ((fieldType = this.parseFieldType(token)) == null) {
                return null;
            }
            String string = name = fieldType.isStringKey() ? fieldType.getString() : fieldType.getFirstChild().getString();
            if (names.add(name)) {
                fieldTypeList.addChildToBack(fieldType);
            } else {
                this.addTypeWarning("msg.jsdoc.type.record.duplicate", name);
            }
            this.skipEOLs();
            if (!this.match(JsDocToken.COMMA)) break;
            this.next();
            this.skipEOLs();
            if (this.match(JsDocToken.RIGHT_CURLY)) break;
            token = this.next();
        }
        return fieldTypeList;
    }

    private Node parseFieldType(JsDocToken token) {
        Node fieldName = this.parseFieldName(token);
        if (fieldName == null) {
            return null;
        }
        this.skipEOLs();
        if (!this.match(JsDocToken.COLON)) {
            return fieldName;
        }
        this.next();
        this.skipEOLs();
        Node typeExpression = this.parseTypeExpression(this.next());
        if (typeExpression == null) {
            return null;
        }
        Node fieldType = this.newNode(Token.COLON);
        fieldType.addChildToBack(fieldName);
        fieldType.addChildToBack(typeExpression);
        return fieldType;
    }

    private Node parseFieldName(JsDocToken token) {
        switch (token) {
            case STRING: {
                String s = this.stream.getString();
                Node n = Node.newString(Token.STRING_KEY, s, this.stream.getLineno(), this.stream.getCharno()).clonePropsFrom(this.templateNode);
                n.setLength(s.length());
                return n;
            }
        }
        return null;
    }

    private Node wrapNode(Token type, Node n) {
        return n == null ? null : this.wrapNode(type, n, n.getLineno(), n.getCharno());
    }

    private Node wrapNode(Token type, Node n, int lineno, int charno) {
        return n == null ? null : new Node(type, n, lineno, charno).clonePropsFrom(this.templateNode);
    }

    private Node newNode(Token type) {
        return new Node(type, this.stream.getLineno(), this.stream.getCharno()).clonePropsFrom(this.templateNode);
    }

    private Node newStringNode(String s) {
        return this.newStringNode(s, this.stream.getLineno(), this.stream.getCharno());
    }

    private Node newStringNode(String s, int lineno, int charno) {
        Node n = Node.newString(s, lineno, charno).clonePropsFrom(this.templateNode);
        n.setLength(s.length());
        return n;
    }

    private Node reportTypeSyntaxWarning(String warning) {
        this.addTypeWarning(warning, this.stream.getLineno(), this.stream.getCharno());
        return null;
    }

    private Node reportGenericTypeSyntaxWarning() {
        return this.reportTypeSyntaxWarning("msg.jsdoc.type.syntax");
    }

    private JsDocToken eatUntilEOLIfNotAnnotation() {
        return this.eatUntilEOLIfNotAnnotation(this.next());
    }

    private JsDocToken eatUntilEOLIfNotAnnotation(JsDocToken token) {
        if (token == JsDocToken.ANNOTATION) {
            this.state = State.SEARCHING_ANNOTATION;
            return token;
        }
        return this.eatTokensUntilEOL(token);
    }

    private JsDocToken eatTokensUntilEOL() {
        return this.eatTokensUntilEOL(this.next());
    }

    private JsDocToken eatTokensUntilEOL(JsDocToken token) {
        while (true) {
            if (token == JsDocToken.EOL || token == JsDocToken.EOC || token == JsDocToken.EOF) {
                this.state = State.SEARCHING_ANNOTATION;
                return token;
            }
            token = this.next();
        }
    }

    private void restoreLookAhead(JsDocToken token) {
        this.unreadToken = token;
    }

    private boolean match(JsDocToken token) {
        this.unreadToken = this.next();
        return this.unreadToken == token;
    }

    private boolean match(JsDocToken token1, JsDocToken token2) {
        this.unreadToken = this.next();
        return this.unreadToken == token1 || this.unreadToken == token2;
    }

    private JsDocToken next() {
        if (this.unreadToken == NO_UNREAD_TOKEN) {
            return this.stream.getJsDocToken();
        }
        return this.current();
    }

    private JsDocToken current() {
        JsDocToken t = this.unreadToken;
        this.unreadToken = NO_UNREAD_TOKEN;
        return t;
    }

    private void skipEOLs() {
        while (this.match(JsDocToken.EOL)) {
            this.next();
            if (!this.match(JsDocToken.STAR)) continue;
            this.next();
        }
    }

    private String getRemainingJSDocLine() {
        String result = this.stream.getRemainingJSDocLine();
        this.unreadToken = NO_UNREAD_TOKEN;
        return result;
    }

    private boolean hasParsedFileOverviewDocInfo() {
        return this.jsdocBuilder.isPopulatedWithFileOverview();
    }

    public JSDocInfo retrieveAndResetParsedJSDocInfo() {
        return this.jsdocBuilder.build();
    }

    JSDocInfo getFileOverviewJSDocInfo() {
        return this.fileOverviewJSDocInfo;
    }

    private boolean lookAheadForType() {
        return this.lookAheadFor('{');
    }

    private boolean lookAheadForAnnotation() {
        return this.lookAheadFor('@');
    }

    private boolean lookAheadFor(char expect) {
        int c;
        boolean matched = false;
        while ((c = this.stream.getChar()) == 32) {
        }
        if (c == expect) {
            matched = true;
        }
        this.stream.ungetChar(c);
        return matched;
    }

    private static enum WhitespaceOption {
        PRESERVE,
        TRIM,
        SINGLE_LINE;

    }

    private static class ExtendedTypeInfo {
        final JSTypeExpression type;
        final int lineno;
        final int charno;

        public ExtendedTypeInfo(JSTypeExpression type, int lineno, int charno) {
            this.type = type;
            this.lineno = lineno;
            this.charno = charno;
        }
    }

    private static class ExtractionInfo {
        private final String string;
        private final JsDocToken token;

        public ExtractionInfo(String string, JsDocToken token) {
            this.string = string;
            this.token = token;
        }
    }

    private static enum State {
        SEARCHING_ANNOTATION,
        SEARCHING_NEWLINE,
        NEXT_IS_ANNOTATION;

    }
}

