//===- BlackfinSubtarget.h - Define Subtarget for the Blackfin -*- C++ -*-====//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
//===----------------------------------------------------------------------===//
//
// This file declares the BLACKFIN specific subclass of TargetSubtargetInfo.
//
//===----------------------------------------------------------------------===//

#ifndef BLACKFIN_SUBTARGET_H
#define BLACKFIN_SUBTARGET_H

#include "llvm/Target/TargetSubtargetInfo.h"
#include <string>

#define GET_SUBTARGETINFO_HEADER
#include "BlackfinGenSubtargetInfo.inc"

namespace llvm {
class StringRef;

  class BlackfinSubtarget : public BlackfinGenSubtargetInfo {
    bool sdram;
    bool icplb;
    bool wa_mi_shift;
    bool wa_csync;
    bool wa_specld;
    bool wa_mmr_stall;
    bool wa_lcregs;
    bool wa_hwloop;
    bool wa_ind_call;
    bool wa_killed_mmr;
    bool wa_rets;
  public:
    BlackfinSubtarget(const std::string &TT, const std::string &CPU,
                      const std::string &FS);

    /// ParseSubtargetFeatures - Parses features string setting specified
    /// subtarget options.  Definition of function is auto generated by tblgen.
    void ParseSubtargetFeatures(StringRef CPU, StringRef FS);
  };

} // end namespace llvm

#endif
