Grammar of the schema language    {#flatbuffers_grammar}
==============================

schema = include*
         ( namespace\_decl | type\_decl | enum\_decl | root\_decl |
           file_extension_decl | file_identifier_decl |
           attribute\_decl | object )*

include = `include` string\_constant `;`

namespace\_decl = `namespace` ident ( `.` ident )* `;`

attribute\_decl = `attribute` string\_constant `;`

type\_decl = ( `table` | `struct` ) ident metadata `{` field\_decl+ `}`

enum\_decl = ( `enum` | `union` ) ident [ `:` type ] metadata `{` commasep(
enumval\_decl ) `}`

root\_decl = `root_type` ident `;`

field\_decl = ident `:` type [ `=` scalar ] metadata `;`

type = `bool` | `byte` | `ubyte` | `short` | `ushort` | `int` | `uint` |
`float` | `long` | `ulong` | `double`
 | `string` | `[` type `]` | ident

enumval\_decl = ident [ `=` integer\_constant ]

metadata = [ `(` commasep( ident [ `:` single\_value ] ) `)` ]

scalar = integer\_constant | float\_constant

object = { commasep( ident `:` value ) }

single\_value = scalar | string\_constant

value = single\_value | object | `[` commasep( value ) `]`

commasep(x) = [ x ( `,` x )\* ]

file_extension_decl = `file_extension` string\_constant `;`

file_identifier_decl = `file_identifier` string\_constant `;`

integer\_constant = -?[0-9]+ | `true` | `false`

float\_constant = -?[0-9]+.[0-9]+((e|E)(+|-)?[0-9]+)?
