/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.haha.guava.base;

import com.squareup.haha.guava.base.Joiner$MapJoiner;
import com.squareup.haha.guava.base.Predicate;
import com.squareup.haha.guava.collect.ImmutableList;
import com.squareup.haha.guava.collect.Iterators;
import com.squareup.haha.guava.collect.Lists$RandomAccessReverseList;
import com.squareup.haha.guava.collect.Lists$ReverseList;
import com.squareup.haha.guava.collect.Multiset;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

public class Ascii {
    final String separator;

    public Ascii(String separator) {
        this.separator = Ascii.checkNotNull(separator);
    }

    Ascii(Ascii prototype) {
        this.separator = prototype.separator;
    }

    public <A extends Appendable> A appendTo(A appendable, Iterator<?> parts) throws IOException {
        Ascii.checkNotNull(appendable);
        if (parts.hasNext()) {
            appendable.append(this.toString(parts.next()));
            while (parts.hasNext()) {
                appendable.append(this.separator);
                appendable.append(this.toString(parts.next()));
            }
        }
        return appendable;
    }

    public StringBuilder appendTo(StringBuilder builder, Iterator<?> parts) {
        try {
            this.appendTo((Appendable)builder, parts);
        }
        catch (IOException impossible) {
            throw new AssertionError((Object)impossible);
        }
        return builder;
    }

    public String join(Iterable<?> parts) {
        return this.join(parts.iterator());
    }

    public String join(Iterator<?> parts) {
        return this.appendTo(new StringBuilder(), parts).toString();
    }

    @CheckReturnValue
    public Ascii useForNull$5f7c8ce0(String nullText) {
        Ascii.checkNotNull(nullText);
        return new Ascii(this, this, nullText){
            private /* synthetic */ String val$nullText;
            private /* synthetic */ Ascii this$0$5f22bbb7;
            {
                this.this$0$5f22bbb7 = ascii;
                this.val$nullText = string;
                super(x0, (byte)0);
            }

            final CharSequence toString(@Nullable Object part) {
                if (part == null) {
                    return this.val$nullText;
                }
                return this.this$0$5f22bbb7.toString(part);
            }

            public final Ascii useForNull$5f7c8ce0(String nullText) {
                throw new UnsupportedOperationException("already specified useForNull");
            }
        };
    }

    @CheckReturnValue
    public Joiner$MapJoiner withKeyValueSeparator(String keyValueSeparator) {
        return new Joiner$MapJoiner(this, keyValueSeparator, 0);
    }

    CharSequence toString(Object part) {
        Ascii.checkNotNull(part);
        if (part instanceof CharSequence) {
            return (CharSequence)part;
        }
        return part.toString();
    }

    /* synthetic */ Ascii(Ascii x0, byte by) {
        this(x0);
    }

    @CheckReturnValue
    public static boolean equal(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static void checkArgument(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new IllegalArgumentException(Ascii.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static void checkState(boolean expression) {
        if (!expression) {
            throw new IllegalStateException();
        }
    }

    public static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    public static int checkElementIndex(int index, int size) {
        String string = "index";
        int n = size;
        int n2 = index;
        if (n2 < 0 || n2 >= n) {
            String string2;
            String string3 = string;
            int n3 = n;
            int n4 = n2;
            if (n4 < 0) {
                string2 = Ascii.format("%s (%s) must not be negative", string3, n4);
            } else {
                if (n3 < 0) {
                    throw new IllegalArgumentException("negative size: " + n3);
                }
                string2 = Ascii.format("%s (%s) must be less than size (%s)", string3, n4, n3);
            }
            throw new IndexOutOfBoundsException(string2);
        }
        return n2;
    }

    public static int checkPositionIndex(int index, int size) {
        String string = "index";
        int n = size;
        int n2 = index;
        if (n2 < 0 || n2 > n) {
            throw new IndexOutOfBoundsException(Ascii.badPositionIndex(n2, n, string));
        }
        return n2;
    }

    static String badPositionIndex(int index, int size, String desc) {
        if (index < 0) {
            return Ascii.format("%s (%s) must not be negative", desc, index);
        }
        if (size < 0) {
            throw new IllegalArgumentException("negative size: " + size);
        }
        return Ascii.format("%s (%s) must not be greater than size (%s)", desc, index, size);
    }

    public static void checkPositionIndexes(int start, int end, int size) {
        if (start < 0 || end < start || end > size) {
            int n = size;
            int n2 = end;
            int n3 = start;
            throw new IndexOutOfBoundsException(n3 < 0 || n3 > n ? Ascii.badPositionIndex(n3, n, "start index") : (n2 < 0 || n2 > n ? Ascii.badPositionIndex(n2, n, "end index") : Ascii.format("end index (%s) must not be less than start index (%s)", n2, n3)));
        }
    }

    static String format(String template, Object ... args) {
        int placeholderStart;
        template = String.valueOf(template);
        StringBuilder builder = new StringBuilder(template.length() + 16 * args.length);
        int templateStart = 0;
        int i = 0;
        while (i < args.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
            builder.append(template.substring(templateStart, placeholderStart));
            builder.append(args[i++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template.substring(templateStart));
        if (i < args.length) {
            builder.append(" [");
            builder.append(args[i++]);
            while (i < args.length) {
                builder.append(", ");
                builder.append(args[i++]);
            }
            builder.append(']');
        }
        return builder.toString();
    }

    public static int checkNonnegative(int value, String name) {
        if (value < 0) {
            throw new IllegalArgumentException(name + " cannot be negative but was: " + value);
        }
        return value;
    }

    public static void checkRemove(boolean canRemove) {
        String string = "no calls to next() since the last call to remove()";
        boolean bl = canRemove;
        if (!bl) {
            throw new IllegalStateException(String.valueOf(string));
        }
    }

    public static <T> boolean removeIfFromRandomAccessList(List<T> list, Predicate<? super T> predicate) {
        int from;
        int to = 0;
        for (from = 0; from < list.size(); ++from) {
            T element = list.get(from);
            if (predicate.apply(element)) continue;
            if (from > to) {
                try {
                    list.set(to, element);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    int n;
                    int n2 = from;
                    int n3 = to;
                    Predicate<T> predicate2 = predicate;
                    List<T> list2 = list;
                    for (n = list2.size() - 1; n > n2; --n) {
                        if (!predicate2.apply(list2.get(n))) continue;
                        list2.remove(n);
                    }
                    for (n = n2 - 1; n >= n3; --n) {
                        list2.remove(n);
                    }
                    return true;
                }
            }
            ++to;
        }
        list.subList(to, list.size()).clear();
        return from != to;
    }

    @Nullable
    public static <T> T getFirst(Iterable<? extends T> iterable, T defaultValue) {
        return Iterators.getNext(iterable.iterator(), null);
    }

    public static <E> ArrayList<E> newArrayList(Iterator<? extends E> elements) {
        ArrayList list = new ArrayList();
        Iterators.addAll(list, elements);
        return list;
    }

    public static <T> List<T> reverse(List<T> list) {
        if (list instanceof ImmutableList) {
            return ((ImmutableList)list).reverse();
        }
        if (list instanceof Lists$ReverseList) {
            Lists$ReverseList lists$ReverseList = (Lists$ReverseList)list;
            return lists$ReverseList.forwardList;
        }
        if (list instanceof RandomAccess) {
            return new Lists$RandomAccessReverseList<T>(list);
        }
        return new Lists$ReverseList<T>(list);
    }

    public static int hashCodeImpl(Set<?> s) {
        int hashCode = 0;
        for (Object o : s) {
            hashCode += o != null ? o.hashCode() : 0;
            hashCode = ~(~hashCode);
        }
        return hashCode;
    }

    public static boolean equalsImpl(Set<?> s, Object object) {
        if (s == object) {
            return true;
        }
        if (object instanceof Set) {
            Set o = (Set)object;
            try {
                return s.size() == o.size() && s.containsAll(o);
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }
        return false;
    }

    public static boolean removeAllImpl(Set<?> set, Iterator<?> iterator) {
        boolean changed = false;
        while (iterator.hasNext()) {
            changed |= set.remove(iterator.next());
        }
        return changed;
    }

    public static boolean removeAllImpl(Set<?> set, Collection<?> collection) {
        Ascii.checkNotNull(collection);
        if (collection instanceof Multiset) {
            collection = ((Multiset)collection).elementSet();
        }
        if (collection instanceof Set && collection.size() > set.size()) {
            return Iterators.removeAll(set.iterator(), collection);
        }
        return Ascii.removeAllImpl(set, collection.iterator());
    }

    public static int hash(Object object) {
        if (object == null) {
            return 0;
        }
        return object.hashCode();
    }
}

