// Copyright 2019 The Wuffs Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// +build ignore

package main

// gen.go generates data.go.
//
// Invoke it via "go generate".

import (
	"bytes"
	"fmt"
	"go/format"
	"io/ioutil"
	"os"
)

func main() {
	if err := main1(); err != nil {
		os.Stderr.WriteString(err.Error() + "\n")
		os.Exit(1)
	}
}

func main1() error {
	src, err := ioutil.ReadFile("main.go")
	if err != nil {
		return err
	}

	if i := bytes.Index(src, []byte("ractool manipulates ")); i < 0 {
		return fmt.Errorf(`couldn't find documentation sub-string`)
	} else {
		src = src[i:]
	}
	if j := bytes.Index(src, []byte("*/")); j < 0 {
		return fmt.Errorf(`couldn't find documentation sub-string`)
	} else {
		src = src[:j]
	}

	out := []byte(`
// Code generated by running "go generate". DO NOT EDIT.

// Copyright 2019 The Wuffs Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package main

const usageStr = ` + "`")

	out = append(out, src...)
	out = append(out, '`')

	formatted, err := format.Source(out)
	if err != nil {
		return err
	}
	return ioutil.WriteFile("data.go", formatted, 0644)
}
