/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt5.android;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.PopupWindow;
import org.qtproject.qt5.android.EditContextView;
import org.qtproject.qt5.android.QtNativeInputConnection;

public class EditPopupMenu
implements ViewTreeObserver.OnPreDrawListener,
EditContextView.OnClickListener {
    private View m_layout = null;
    private EditContextView m_view = null;
    private PopupWindow m_popup = null;
    private int m_posX;
    private int m_posY;
    private int m_buttons;

    public EditPopupMenu(Activity activity, View view) {
        this.m_view = new EditContextView((Context)activity, this);
        this.m_layout = view;
    }

    private void initOverlay() {
        if (this.m_popup != null) {
            return;
        }
        Context context = this.m_layout.getContext();
        this.m_popup = new PopupWindow(context, null, 16843464);
        this.m_popup.setSplitTouchEnabled(true);
        this.m_popup.setClippingEnabled(false);
        this.m_popup.setContentView((View)this.m_view);
        this.m_popup.setWidth(-2);
        this.m_popup.setHeight(-2);
        this.m_layout.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
    }

    public int getHeight() {
        return this.m_view.getHeight();
    }

    public void setPosition(int n, int n2, int n3) {
        this.initOverlay();
        this.m_view.updateButtons(n3);
        int[] nArray = new int[2];
        this.m_layout.getLocationOnScreen(nArray);
        int n4 = n + nArray[0];
        int n5 = n2 + nArray[1];
        n4 -= this.m_view.getWidth() / 2;
        if (this.m_layout.getWidth() < n + this.m_view.getWidth() / 2) {
            n4 = this.m_layout.getWidth() - this.m_view.getWidth();
        }
        if (n4 < 0) {
            n4 = 0;
        }
        if (this.m_popup.isShowing()) {
            this.m_popup.update(n4, n5, -1, -1);
        } else {
            this.m_popup.showAtLocation(this.m_layout, 0, n4, n5);
        }
        this.m_posX = n;
        this.m_posY = n2;
        this.m_buttons = n3;
    }

    public void hide() {
        if (this.m_popup != null) {
            this.m_popup.dismiss();
            this.m_popup = null;
        }
    }

    public boolean onPreDraw() {
        if (this.m_popup != null && this.m_popup.isShowing()) {
            this.setPosition(this.m_posX, this.m_posY, this.m_buttons);
        }
        return true;
    }

    @Override
    public void contextButtonClicked(int n) {
        switch (n) {
            case 17039363: {
                QtNativeInputConnection.cut();
                break;
            }
            case 0x1040001: {
                QtNativeInputConnection.copy();
                break;
            }
            case 17039371: {
                QtNativeInputConnection.paste();
                break;
            }
            case 17039373: {
                QtNativeInputConnection.selectAll();
            }
        }
        this.hide();
    }
}

