/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.android.desugar.runtime;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public final class ThrowableExtension {
    static final AbstractDesugaringStrategy STRATEGY;
    public static final String SYSTEM_PROPERTY_TWR_DISABLE_MIMIC = "com.google.devtools.build.android.desugar.runtime.twr_disable_mimic";
    private static final String ANDROID_OS_BUILD_VERSION = "android.os.Build$VERSION";

    public static AbstractDesugaringStrategy getStrategy() {
        return STRATEGY;
    }

    public static void addSuppressed(Throwable throwable, Throwable throwable2) {
        STRATEGY.addSuppressed(throwable, throwable2);
    }

    public static Throwable[] getSuppressed(Throwable throwable) {
        return STRATEGY.getSuppressed(throwable);
    }

    public static void printStackTrace(Throwable throwable) {
        STRATEGY.printStackTrace(throwable);
    }

    public static void printStackTrace(Throwable throwable, PrintWriter printWriter) {
        STRATEGY.printStackTrace(throwable, printWriter);
    }

    public static void printStackTrace(Throwable throwable, PrintStream printStream) {
        STRATEGY.printStackTrace(throwable, printStream);
    }

    private static boolean useMimicStrategy() {
        return !Boolean.getBoolean(SYSTEM_PROPERTY_TWR_DISABLE_MIMIC);
    }

    private static Integer readApiLevelFromBuildVersion() {
        try {
            Class<?> clazz = Class.forName(ANDROID_OS_BUILD_VERSION);
            Field field = clazz.getField("SDK_INT");
            return (Integer)field.get(null);
        }
        catch (Exception exception) {
            System.err.println("Failed to retrieve value from android.os.Build$VERSION.SDK_INT due to the following exception.");
            exception.printStackTrace(System.err);
            return null;
        }
    }

    static {
        AbstractDesugaringStrategy abstractDesugaringStrategy;
        try {
            Integer n = ThrowableExtension.readApiLevelFromBuildVersion();
            abstractDesugaringStrategy = n != null && n >= 19 ? new ReuseDesugaringStrategy() : (ThrowableExtension.useMimicStrategy() ? new MimicDesugaringStrategy() : new NullDesugaringStrategy());
        }
        catch (Throwable throwable) {
            System.err.println("An error has occured when initializing the try-with-resources desuguring strategy. The default strategy " + NullDesugaringStrategy.class.getName() + "will be used. The error is: ");
            throwable.printStackTrace(System.err);
            abstractDesugaringStrategy = new NullDesugaringStrategy();
        }
        STRATEGY = abstractDesugaringStrategy;
    }

    static final class NullDesugaringStrategy
    extends AbstractDesugaringStrategy {
        NullDesugaringStrategy() {
        }

        @Override
        public void addSuppressed(Throwable throwable, Throwable throwable2) {
        }

        @Override
        public Throwable[] getSuppressed(Throwable throwable) {
            return EMPTY_THROWABLE_ARRAY;
        }

        @Override
        public void printStackTrace(Throwable throwable) {
            throwable.printStackTrace();
        }

        @Override
        public void printStackTrace(Throwable throwable, PrintStream printStream) {
            throwable.printStackTrace(printStream);
        }

        @Override
        public void printStackTrace(Throwable throwable, PrintWriter printWriter) {
            throwable.printStackTrace(printWriter);
        }
    }

    static final class ConcurrentWeakIdentityHashMap {
        private final ConcurrentHashMap<WeakKey, List<Throwable>> map = new ConcurrentHashMap(16, 0.75f, 10);
        private final ReferenceQueue<Throwable> referenceQueue = new ReferenceQueue();

        ConcurrentWeakIdentityHashMap() {
        }

        public List<Throwable> get(Throwable throwable, boolean bl) {
            this.deleteEmptyKeys();
            WeakKey weakKey = new WeakKey(throwable, null);
            List list = this.map.get(weakKey);
            if (!bl) {
                return list;
            }
            if (list != null) {
                return list;
            }
            Vector vector = new Vector(2);
            list = this.map.putIfAbsent(new WeakKey(throwable, this.referenceQueue), vector);
            return list == null ? vector : list;
        }

        int size() {
            return this.map.size();
        }

        void deleteEmptyKeys() {
            Reference<Throwable> reference = this.referenceQueue.poll();
            while (reference != null) {
                this.map.remove(reference);
                reference = this.referenceQueue.poll();
            }
        }

        private static final class WeakKey
        extends WeakReference<Throwable> {
            private final int hash;

            public WeakKey(Throwable throwable, ReferenceQueue<Throwable> referenceQueue) {
                super(throwable, referenceQueue);
                if (throwable == null) {
                    throw new NullPointerException("The referent cannot be null");
                }
                this.hash = System.identityHashCode(throwable);
            }

            public int hashCode() {
                return this.hash;
            }

            public boolean equals(Object object) {
                if (object == null || object.getClass() != this.getClass()) {
                    return false;
                }
                if (this == object) {
                    return true;
                }
                WeakKey weakKey = (WeakKey)object;
                return this.hash == weakKey.hash && this.get() == weakKey.get();
            }
        }
    }

    static final class MimicDesugaringStrategy
    extends AbstractDesugaringStrategy {
        static final String SUPPRESSED_PREFIX = "Suppressed: ";
        private final ConcurrentWeakIdentityHashMap map = new ConcurrentWeakIdentityHashMap();

        MimicDesugaringStrategy() {
        }

        @Override
        public void addSuppressed(Throwable throwable, Throwable throwable2) {
            if (throwable2 == throwable) {
                throw new IllegalArgumentException("Self suppression is not allowed.", throwable2);
            }
            if (throwable2 == null) {
                throw new NullPointerException("The suppressed exception cannot be null.");
            }
            this.map.get(throwable, true).add(throwable2);
        }

        @Override
        public Throwable[] getSuppressed(Throwable throwable) {
            List<Throwable> list = this.map.get(throwable, false);
            if (list == null || list.isEmpty()) {
                return EMPTY_THROWABLE_ARRAY;
            }
            return list.toArray(EMPTY_THROWABLE_ARRAY);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void printStackTrace(Throwable throwable) {
            throwable.printStackTrace();
            List<Throwable> list = this.map.get(throwable, false);
            if (list == null) {
                return;
            }
            List<Throwable> list2 = list;
            synchronized (list2) {
                for (Throwable throwable2 : list) {
                    System.err.print(SUPPRESSED_PREFIX);
                    throwable2.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void printStackTrace(Throwable throwable, PrintStream printStream) {
            throwable.printStackTrace(printStream);
            List<Throwable> list = this.map.get(throwable, false);
            if (list == null) {
                return;
            }
            List<Throwable> list2 = list;
            synchronized (list2) {
                for (Throwable throwable2 : list) {
                    printStream.print(SUPPRESSED_PREFIX);
                    throwable2.printStackTrace(printStream);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void printStackTrace(Throwable throwable, PrintWriter printWriter) {
            throwable.printStackTrace(printWriter);
            List<Throwable> list = this.map.get(throwable, false);
            if (list == null) {
                return;
            }
            List<Throwable> list2 = list;
            synchronized (list2) {
                for (Throwable throwable2 : list) {
                    printWriter.print(SUPPRESSED_PREFIX);
                    throwable2.printStackTrace(printWriter);
                }
            }
        }
    }

    static final class ReuseDesugaringStrategy
    extends AbstractDesugaringStrategy {
        ReuseDesugaringStrategy() {
        }

        @Override
        public void addSuppressed(Throwable throwable, Throwable throwable2) {
            throwable.addSuppressed(throwable2);
        }

        @Override
        public Throwable[] getSuppressed(Throwable throwable) {
            return throwable.getSuppressed();
        }

        @Override
        public void printStackTrace(Throwable throwable) {
            throwable.printStackTrace();
        }

        @Override
        public void printStackTrace(Throwable throwable, PrintStream printStream) {
            throwable.printStackTrace(printStream);
        }

        @Override
        public void printStackTrace(Throwable throwable, PrintWriter printWriter) {
            throwable.printStackTrace(printWriter);
        }
    }

    static abstract class AbstractDesugaringStrategy {
        protected static final Throwable[] EMPTY_THROWABLE_ARRAY = new Throwable[0];

        AbstractDesugaringStrategy() {
        }

        public abstract void addSuppressed(Throwable var1, Throwable var2);

        public abstract Throwable[] getSuppressed(Throwable var1);

        public abstract void printStackTrace(Throwable var1);

        public abstract void printStackTrace(Throwable var1, PrintStream var2);

        public abstract void printStackTrace(Throwable var1, PrintWriter var2);
    }
}

